/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.Vertex;

public class SimulatorEvent
implements Comparable<SimulatorEvent>,
Iterable<EventRecord>,
Serializable {
    int event_id;
    double magnitude;
    double time;
    double duration;
    private List<? extends EventRecord> records;

    public SimulatorEvent(EventRecord eventRecord) {
        this(Lists.newArrayList((Object[])new EventRecord[]{eventRecord}));
    }

    public SimulatorEvent(List<? extends EventRecord> records) {
        this.records = records;
        Preconditions.checkArgument((!records.isEmpty() ? 1 : 0) != 0);
        EventRecord firstRecord = records.get(0);
        this.event_id = firstRecord.getID();
        this.magnitude = firstRecord.getMagnitude();
        this.time = firstRecord.getTime();
        this.duration = firstRecord.getDuration();
    }

    public String toString() {
        Object info = "";
        info = (String)info + "event_id=" + this.event_id + "\n";
        info = (String)info + "magnitude=" + this.magnitude + "\n";
        info = (String)info + "time=" + this.time + "\n";
        info = (String)info + "duration=" + this.duration + "\n";
        info = (String)info + "getArea()=" + this.getArea() + "\n";
        info = (String)info + "size()=" + this.size() + "\n";
        for (int i = 0; i < this.size(); ++i) {
            EventRecord evRec = this.get(i);
            info = (String)info + "EventRecord " + i + ":\n" + evRec.toString();
        }
        return info;
    }

    @Override
    public int compareTo(SimulatorEvent event) {
        double thatTime;
        double thisTime = this.getTime();
        int cmp = Double.compare(thisTime, thatTime = event.getTime());
        if (cmp == 0) {
            cmp = Integer.valueOf(this.event_id).compareTo(event.event_id);
        }
        return cmp;
    }

    public boolean isSameEvent(EventRecord eventRecord) {
        return eventRecord.getID() == this.event_id;
    }

    public boolean doesEventIncludeSection(int sectId) {
        for (EventRecord eventRecord : this) {
            if (eventRecord.getSectionID() != sectId) continue;
            return true;
        }
        return false;
    }

    public boolean doesEventIncludeFault(HashSet<Integer> sectsForFault) {
        for (EventRecord eventRecord : this) {
            if (!sectsForFault.contains(eventRecord.sectionID)) continue;
            return true;
        }
        return false;
    }

    public void setID(int event_id) {
        this.event_id = event_id;
    }

    public int getID() {
        return this.event_id;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
        for (EventRecord rec : this) {
            rec.setTime(time);
        }
    }

    public double getTimeInYears() {
        return this.time / 3.1536E7;
    }

    public double getDuration() {
        return this.duration;
    }

    public boolean hasElementSlipsAndIDs() {
        for (EventRecord evRec : this) {
            if (!evRec.hasElementSlipsAndIDs()) continue;
            return true;
        }
        return false;
    }

    public boolean hasElementSlipsAndIDsOnAllRecords() {
        boolean hasThem = true;
        for (EventRecord evRec : this) {
            if (evRec.hasElementSlipsAndIDs()) continue;
            hasThem = false;
        }
        return hasThem;
    }

    public int getNumElements() {
        int num = 0;
        for (EventRecord evRec : this) {
            num += evRec.getElementIDs().length;
        }
        return num;
    }

    public int[] getAllElementIDs() {
        if (this.hasElementSlipsAndIDs()) {
            ArrayList<int[]> idList = new ArrayList<int[]>();
            int totSize = 0;
            for (int r = 0; r < this.size(); ++r) {
                int[] ids = this.get(r).getElementIDs();
                totSize += ids.length;
                idList.add(ids);
            }
            int[] ids = new int[totSize];
            int index = 0;
            for (int i = 0; i < idList.size(); ++i) {
                int[] recIDs = (int[])idList.get(i);
                System.arraycopy(recIDs, 0, ids, index, recIDs.length);
                index += recIDs.length;
            }
            return ids;
        }
        return null;
    }

    public ArrayList<SimulatorElement> getAllElements() {
        if (this.hasElementSlipsAndIDs()) {
            ArrayList<SimulatorElement> elementList = new ArrayList<SimulatorElement>();
            for (EventRecord er : this) {
                elementList.addAll(er.getElements());
            }
            return elementList;
        }
        return null;
    }

    public double[] getAllElementSlips() {
        if (this.hasElementSlipsAndIDs()) {
            ArrayList<double[]> slipList = new ArrayList<double[]>();
            int totSize = 0;
            for (int r = 0; r < this.size(); ++r) {
                double[] slips = this.get(r).getElementSlips();
                totSize += slips.length;
                slipList.add(slips);
            }
            double[] slips = new double[totSize];
            int index = 0;
            for (int i = 0; i < slipList.size(); ++i) {
                double[] recSlips = (double[])slipList.get(i);
                System.arraycopy(recSlips, 0, slips, index, recSlips.length);
                index += recSlips.length;
            }
            return slips;
        }
        return null;
    }

    static double getMinDistBetweenEventRecordEnds(Vertex er1_1stEnd, Vertex er1_2ndEnd, Vertex er2_1stEnd, Vertex er2_2ndEnd) {
        double min1 = Math.min(er1_1stEnd.getLinearDistance(er2_1stEnd), er1_1stEnd.getLinearDistance(er2_2ndEnd));
        double min2 = Math.min(er1_2ndEnd.getLinearDistance(er2_1stEnd), er1_2ndEnd.getLinearDistance(er2_2ndEnd));
        return Math.min(min1, min2);
    }

    public double getArea() {
        double area = 0.0;
        for (EventRecord evRec : this) {
            area += evRec.getArea();
        }
        return area;
    }

    public SimulatorEvent cloneNewTime(double timeSeconds, int newID) {
        SimulatorEvent o = new SimulatorEvent(this.records);
        o.time = timeSeconds;
        o.event_id = newID;
        o.magnitude = this.magnitude;
        o.duration = this.duration;
        return o;
    }

    @Override
    public Iterator<EventRecord> iterator() {
        return this.records.iterator();
    }

    public int size() {
        return this.records.size();
    }

    public EventRecord get(int index) {
        return this.records.get(index);
    }

    public double getLength() {
        double length = 0.0;
        for (EventRecord eventRecord : this.records) {
            length += eventRecord.getLength();
        }
        return length;
    }
}

