/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.BitSet;
import java.util.List;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.AbstractRuptureIdentifier;

public class ElementIden
extends AbstractRuptureIdentifier {
    private String name;
    private List<Integer> elementIDs;
    private BitSet elemSet;

    public ElementIden(String name, int elementID) {
        this(name, Lists.newArrayList((Object[])new Integer[]{elementID}));
    }

    public ElementIden(String name, int ... elementIDs) {
        this(name, Ints.asList((int[])elementIDs));
    }

    public ElementIden(String name, List<Integer> elementIDs) {
        this.setElementID(elementIDs);
        this.name = name;
    }

    @Override
    public boolean isMatch(SimulatorEvent event) {
        for (EventRecord rec : event) {
            for (int elementID : rec.getElementIDs()) {
                if (!this.elemSet.get(elementID)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Integer> getElementIDs() {
        return this.elementIDs;
    }

    public void setElementID(int elementID) {
        this.elementIDs = Lists.newArrayList((Object[])new Integer[]{elementID});
        this.elemSet.clear();
        this.elemSet.set(elementID);
    }

    public void addElementID(int elementID) {
        this.elementIDs.add(elementID);
        this.elemSet.set(elementID);
    }

    public boolean removeElementID(int elementID) {
        if (this.elemSet.get(elementID)) {
            this.elemSet.clear(elementID);
            int ind = this.elementIDs.indexOf(elementID);
            this.elementIDs.remove(ind);
            return true;
        }
        return false;
    }

    public void setElementID(List<Integer> elementIDs) {
        this.elementIDs = elementIDs;
        int maxID = 0;
        for (Integer id : elementIDs) {
            maxID = Integer.max(id, maxID);
        }
        this.elemSet = new BitSet(maxID + 1);
        for (Integer id : elementIDs) {
            this.elemSet.set(id);
        }
        this.elementIDs = elementIDs;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

