/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.AbstractRuptureIdentifier;

public class FaultIDIden
extends AbstractRuptureIdentifier {
    private String name;
    private HashSet<Integer> elementIDs;

    public FaultIDIden(String name, List<SimulatorElement> elems, int faultID) {
        this(name, elems, Lists.newArrayList((Object[])new Integer[]{faultID}));
    }

    public FaultIDIden(String name, List<SimulatorElement> elems, int ... faultIDs) {
        this(name, elems, Ints.asList((int[])faultIDs));
    }

    public FaultIDIden(String name, List<SimulatorElement> elems, List<Integer> faultIDs) {
        this.name = name;
        this.elementIDs = new HashSet<Integer>(FaultIDIden.getElemIDs(elems, faultIDs));
    }

    private static List<Integer> getElemIDs(List<SimulatorElement> elems, Collection<Integer> faultIDs) {
        faultIDs = new HashSet<Integer>(faultIDs);
        ArrayList elemIDs = Lists.newArrayList();
        for (SimulatorElement elem : elems) {
            if (!faultIDs.contains(elem.getFaultID())) continue;
            elemIDs.add(elem.getID());
        }
        return elemIDs;
    }

    @Override
    public boolean isMatch(SimulatorEvent event) {
        return this.isElementMatch(event);
    }

    private boolean isElementMatch(SimulatorEvent event) {
        for (int elementID : event.getAllElementIDs()) {
            if (!this.elementIDs.contains(elementID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

