/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import com.google.common.primitives.Doubles;
import java.util.Set;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.AbstractRuptureIdentifier;

public class MagRangeRuptureIdentifier
extends AbstractRuptureIdentifier {
    private double minMag;
    private double maxMag;
    private Set<Integer> elementsInRegion;

    public MagRangeRuptureIdentifier(double minMag, double maxMag) {
        this(minMag, maxMag, null);
    }

    public MagRangeRuptureIdentifier(double minMag, double maxMag, Set<Integer> elementsInRegion) {
        this.minMag = minMag;
        this.maxMag = maxMag;
        this.elementsInRegion = elementsInRegion;
    }

    @Override
    public boolean isMatch(SimulatorEvent event) {
        double mag = event.getMagnitude();
        if (mag < this.minMag || mag >= this.maxMag || !Doubles.isFinite((double)mag)) {
            return false;
        }
        if (this.elementsInRegion == null) {
            return true;
        }
        for (int elementID : event.getAllElementIDs()) {
            if (!this.elementsInRegion.contains(elementID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "Mag Range: " + this.minMag + " => " + this.maxMag;
    }
}

