/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.AbstractRuptureIdentifier;

public class SectionIDIden
extends AbstractRuptureIdentifier {
    private String name;
    private HashSet<Integer> elementIDs;
    private HashSet<Integer> sectionIDs;
    private double momentFractForInclusion = 0.0;
    private double areaFractForInclusion = 0.0;
    private double totalSectionArea;

    public static SectionIDIden getALLCAL2_NSAF(List<SimulatorElement> elems) {
        return new SectionIDIden("N. SAF", elems, SectionIDIden.parseNames(elems, "SAF-Mendo_Offs", "SAF-N_Coast_Of", "SAF-N_Coast_On", "SAF-N_Mendocin", "SAF-N_Mid_Peni", "SAF-S_Cruz_Mts", "SAF-S_Mid_Peni"));
    }

    public static SectionIDIden getALLCAL2_SSAF(List<SimulatorElement> elems) {
        return new SectionIDIden("S. SAF", elems, SectionIDIden.parseNames(elems, "SAF-Carrizo", "SAF-Coachella", "SAF-Mojave", "SAF-San_Bernar"));
    }

    public static SectionIDIden getALLCAL2_SSAF_Mojave(List<SimulatorElement> elems) {
        return new SectionIDIden("SAF-Mojave", elems, SectionIDIden.parseNames(elems, "SAF-Mojave"));
    }

    public static SectionIDIden getALLCAL2_SSAF_Coachella(List<SimulatorElement> elems) {
        return new SectionIDIden("SAF-Coachella", elems, SectionIDIden.parseNames(elems, "SAF-Coachella"));
    }

    public static SectionIDIden getALLCAL2_SanJacinto(List<SimulatorElement> elems) {
        return new SectionIDIden("San Jacinto", elems, SectionIDIden.parseNames(elems, "Anza", "San_Bernardino", "San_Jacinto"));
    }

    public static SectionIDIden getALLCAL2_Elsinore(List<SimulatorElement> elems) {
        return new SectionIDIden("Elsinore", elems, SectionIDIden.parseNames(elems, "Coyote_Mt.", "Glen_Ivy", "Julian", "Temecula", "Whittier"));
    }

    public SectionIDIden(String name, List<SimulatorElement> elems, int sectionID) {
        this(name, elems, Lists.newArrayList((Object[])new Integer[]{sectionID}));
    }

    public SectionIDIden(String name, List<SimulatorElement> elems, int ... sectionIDs) {
        this(name, elems, Ints.asList((int[])sectionIDs));
    }

    public SectionIDIden(String name, List<SimulatorElement> elems, List<Integer> sectionIDs) {
        this.name = name;
        this.elementIDs = new HashSet<Integer>(SectionIDIden.getElemIDs(elems, sectionIDs));
        this.sectionIDs = new HashSet<Integer>(sectionIDs);
        this.totalSectionArea = 0.0;
        for (SimulatorElement elem : elems) {
            if (!this.elementIDs.contains(elem.getID())) continue;
            this.totalSectionArea += elem.getArea();
        }
    }

    public void setMomentFractForInclusion(double momentFractForInclusion) {
        Preconditions.checkArgument((momentFractForInclusion >= 0.0 && momentFractForInclusion <= 1.0 ? 1 : 0) != 0, (String)"moment fraction for inclusion must be in the range [0 1]: %s", (Object)momentFractForInclusion);
        this.momentFractForInclusion = momentFractForInclusion;
    }

    public void setAreaFractForInclusion(double areaFractForInclusion) {
        Preconditions.checkArgument((areaFractForInclusion >= 0.0 && areaFractForInclusion <= 1.0 ? 1 : 0) != 0, (String)"area fraction for inclusion must be in the range [0 1]: %s", (Object)areaFractForInclusion);
        this.areaFractForInclusion = areaFractForInclusion;
    }

    private static List<Integer> getElemIDs(List<SimulatorElement> elems, List<Integer> sectionIDs) {
        HashSet<Integer> sectIDs = new HashSet<Integer>(sectionIDs);
        ArrayList elemIDs = Lists.newArrayList();
        for (SimulatorElement elem : elems) {
            if (!sectIDs.contains(elem.getSectionID())) continue;
            elemIDs.add(elem.getID());
        }
        return elemIDs;
    }

    public static List<Integer> parseNames(List<SimulatorElement> elems, String ... sectionNames) {
        return SectionIDIden.parseNames(elems, Lists.newArrayList((Object[])sectionNames));
    }

    public static List<Integer> parseNames(List<SimulatorElement> elems, List<String> sectionNames) {
        ArrayList ids = Lists.newArrayList();
        for (String sectionName : sectionNames) {
            Integer id = null;
            for (SimulatorElement elem : elems) {
                if (!elem.getSectionName().equals(sectionName)) continue;
                id = elem.getSectionID();
                break;
            }
            Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)("Section ID not found for: " + sectionName));
            ids.add(id);
        }
        return ids;
    }

    @Override
    public boolean isMatch(SimulatorEvent event) {
        if (!this.isElementMatch(event)) {
            return false;
        }
        if (this.momentFractForInclusion > 0.0) {
            double momentOnFault = 0.0;
            double totMoment = 0.0;
            for (EventRecord rec : event) {
                totMoment += rec.getMoment();
                if (!this.sectionIDs.contains(rec.getSectionID())) continue;
                momentOnFault += rec.getMoment();
            }
            double fract = momentOnFault / totMoment;
            if (fract < this.momentFractForInclusion) {
                return false;
            }
        }
        if (this.areaFractForInclusion > 0.0) {
            double areaOnFaultRuptured = 0.0;
            for (SimulatorElement elem : event.getAllElements()) {
                if (!this.elementIDs.contains(elem.getID())) continue;
                areaOnFaultRuptured += elem.getArea();
            }
            double fract = areaOnFaultRuptured / this.totalSectionArea;
            Preconditions.checkState(((float)fract >= 0.0f && (float)fract <= 1.0f ? 1 : 0) != 0);
            if (fract < this.areaFractForInclusion) {
                return false;
            }
        }
        return true;
    }

    private boolean isElementMatch(SimulatorEvent event) {
        for (int elementID : event.getAllElementIDs()) {
            if (!this.elementIDs.contains(elementID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static void main(String[] args) {
    }
}

