/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.parsers;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Range;
import com.google.common.io.Files;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.RSQSimEvent;
import org.opensha.sha.simulators.RSQSimEventRecord;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.iden.LogicalAndRupIden;
import org.opensha.sha.simulators.iden.MagRangeRuptureIdentifier;
import org.opensha.sha.simulators.iden.RuptureIdentifier;
import org.opensha.sha.simulators.iden.SkipYearsLoadIden;
import org.opensha.sha.simulators.parsers.RSQSimFileReader;
import org.opensha.sha.simulators.srf.RSQSimStateTime;
import org.opensha.sha.simulators.srf.RSQSimStateTransitionFileReader;
import org.opensha.sha.simulators.srf.RSQSimTransValidIden;

public class RSQSimFileWriter {
    private DataOutput dOut;
    private DataOutput eOut;
    private DataOutput pOut;
    private DataOutput tOut;
    private DataOutput transOut;
    private int prevTransEventID;
    private RSQSimStateTime prevTrans;
    private double prevTransEventTime;
    private double prevTransEventFirstTransTime;
    private double prevTransEventLastTransTime;
    private double prevTransTime = Double.NEGATIVE_INFINITY;

    public RSQSimFileWriter(File outputDir, String prefix, boolean bigEndian) throws IOException {
        this(outputDir, prefix, bigEndian, false, null);
    }

    public RSQSimFileWriter(File outputDir, String prefix, boolean bigEndian, boolean writeTrans, RSQSimStateTransitionFileReader.TransVersion transVersion) throws IOException {
        BufferedOutputStream dListStream = new BufferedOutputStream(new FileOutputStream(new File(outputDir, prefix + ".dList")));
        BufferedOutputStream eListStream = new BufferedOutputStream(new FileOutputStream(new File(outputDir, prefix + ".eList")));
        BufferedOutputStream pListStream = new BufferedOutputStream(new FileOutputStream(new File(outputDir, prefix + ".pList")));
        BufferedOutputStream tListStream = new BufferedOutputStream(new FileOutputStream(new File(outputDir, prefix + ".tList")));
        BufferedOutputStream transStream = null;
        if (writeTrans) {
            String name = transVersion == RSQSimStateTransitionFileReader.TransVersion.TRANSV ? "transV." + prefix + ".out" : "trans." + prefix + ".out";
            transStream = new BufferedOutputStream(new FileOutputStream(new File(outputDir, name)));
        }
        if (bigEndian) {
            this.eOut = new DataOutputStream(eListStream);
            this.pOut = new DataOutputStream(pListStream);
            this.dOut = new DataOutputStream(dListStream);
            this.tOut = new DataOutputStream(tListStream);
            if (writeTrans) {
                this.transOut = new DataOutputStream(transStream);
            }
        } else {
            this.eOut = new LittleEndianDataOutputStream((OutputStream)eListStream);
            this.pOut = new LittleEndianDataOutputStream((OutputStream)pListStream);
            this.dOut = new LittleEndianDataOutputStream((OutputStream)dListStream);
            this.tOut = new LittleEndianDataOutputStream((OutputStream)tListStream);
            if (writeTrans) {
                this.transOut = new LittleEndianDataOutputStream((OutputStream)transStream);
            }
        }
    }

    public void writeEvent(RSQSimEvent event) throws IOException {
        this.writeEvent(event, event.getID());
    }

    public void writeEvent(RSQSimEvent event, int eventID) throws IOException {
        this.writeEvent(event, eventID, 0.0);
    }

    public void writeEvent(RSQSimEvent event, int eventID, double timeOffset) throws IOException {
        ArrayList<PatchSlipTime> slipTimes = new ArrayList<PatchSlipTime>();
        for (EventRecord r : event) {
            int[] ids = r.getElementIDs();
            double[] slips = r.getElementSlips();
            double[] times = r.getElementTimeFirstSlips();
            for (int i = 0; i < ids.length; ++i) {
                slipTimes.add(new PatchSlipTime(ids[i], slips[i], times[i]));
            }
        }
        Collections.sort(slipTimes);
        for (PatchSlipTime slipTime : slipTimes) {
            this.dOut.writeDouble(slipTime.slip);
            this.eOut.writeInt(eventID);
            this.pOut.writeInt(slipTime.patchID);
            this.tOut.writeDouble(slipTime.time + timeOffset);
        }
    }

    public void writeEvents(Iterable<RSQSimEvent> events) throws IOException {
        this.writeEvents(events, Double.NEGATIVE_INFINITY);
    }

    public void writeEvents(Iterable<RSQSimEvent> events, double minMag) throws IOException {
        MagRangeRuptureIdentifier rupIden = Double.isFinite(minMag) && minMag > 0.0 ? new MagRangeRuptureIdentifier(minMag, Double.POSITIVE_INFINITY) : null;
        this.writeEvents(events, rupIden);
    }

    public void writeEvents(Iterable<RSQSimEvent> events, RuptureIdentifier rupIden) throws IOException {
        for (RSQSimEvent e : events) {
            if (rupIden != null && !rupIden.isMatch(e)) continue;
            this.writeEvent(e);
        }
    }

    public synchronized double writeTransitions(RSQSimEvent event, RSQSimStateTransitionFileReader transReader, double timeOffset) throws IOException {
        return this.writeTransitions(event, event.getID(), transReader, timeOffset);
    }

    public synchronized double writeTransitions(RSQSimEvent event, int eventID, RSQSimStateTransitionFileReader transReader, double timeOffset) throws IOException {
        RSQSimStateTransitionFileReader.TransVersion version = transReader.getVersion();
        ArrayList<RSQSimStateTime> allTrans = new ArrayList<RSQSimStateTime>();
        transReader.getTransitions(event, allTrans);
        double prevTransTime = this.prevTransTime;
        for (int i = 0; i < allTrans.size(); ++i) {
            RSQSimStateTime trans = (RSQSimStateTime)allTrans.get(i);
            double transTime = trans.absoluteTime;
            if (Double.isFinite(timeOffset) && timeOffset != 0.0) {
                transTime += timeOffset;
            }
            if (transTime < prevTransTime) {
                String error = "Transitions are out of order! Working on transition " + i + " for event " + event.getID();
                error = error + "\n\tOriginal trans time: " + trans.absoluteTime;
                error = error + "\n\tOriginal event time: " + event.getTime();
                error = error + "\n\tOffset write trans time: " + transTime + " (" + (float)(transTime / 3.1536E7) + " yr)";
                error = error + "\n\tOriginal trans index before: " + transReader.getIndexBefore(trans.absoluteTime);
                error = error + "\n\tOffset event time: " + (event.getTime() + timeOffset);
                error = error + "\n\tPrevious transitions time: " + prevTransTime + " (" + (float)(prevTransTime / 3.1536E7) + " yr)";
                error = error + "\n\tOriginal trans index before pref time: " + transReader.getIndexBefore(prevTransTime - timeOffset);
                double secs = transTime - prevTransTime;
                error = error + "\n\ttime diff: " + secs + " s";
                error = error + "\n\tprevious event timing (modified times):";
                error = error + "\n\t\tevent time: " + this.prevTransEventTime;
                error = error + "\n\t\tfirst trans time: " + this.prevTransEventFirstTransTime;
                error = error + "\n\t\tlast trans time: " + this.prevTransEventLastTransTime;
                error = error + "\n\t\tduration: " + (this.prevTransEventLastTransTime - this.prevTransEventFirstTransTime);
                error = error + "\n\t\tevent ID: " + this.prevTransEventID;
                error = error + "\n\tprev transition patch: " + this.prevTrans.patchID;
                error = error + "\n\tprev transition: " + String.valueOf(this.prevTrans);
                throw new IllegalStateException(error);
            }
            prevTransTime = transTime;
        }
        return this.writeTransitions(event, eventID, timeOffset, version, allTrans);
    }

    public synchronized double writeTransitions(RSQSimEvent event, int eventID, double timeOffset, RSQSimStateTransitionFileReader.TransVersion version, List<RSQSimStateTime> transitions) throws IOException {
        for (int i = 0; i < transitions.size(); ++i) {
            RSQSimStateTime trans = transitions.get(i);
            double transTime = trans.absoluteTime;
            if (Double.isFinite(timeOffset) && timeOffset != 0.0) {
                transTime += timeOffset;
            }
            this.prevTransTime = transTime;
            if (version == RSQSimStateTransitionFileReader.TransVersion.ORIGINAL || version == RSQSimStateTransitionFileReader.TransVersion.TRANSV) {
                this.transOut.writeDouble(transTime);
                this.transOut.writeInt(trans.patchID - 1);
                this.transOut.writeByte(trans.state.getStateInt());
                if (version != RSQSimStateTransitionFileReader.TransVersion.TRANSV) continue;
                this.transOut.writeDouble(trans.velocity);
                continue;
            }
            if (version == RSQSimStateTransitionFileReader.TransVersion.CONSOLIDATED_RELATIVE) {
                this.transOut.writeDouble(transTime);
                this.transOut.writeFloat(trans.relativeTime);
                this.transOut.writeInt(eventID);
                this.transOut.writeInt(trans.patchID - 1);
                this.transOut.writeByte(trans.state.getStateInt());
                this.transOut.writeFloat(trans.velocity);
                continue;
            }
            throw new IllegalStateException("Cannot yet write transition version: " + String.valueOf((Object)version));
        }
        this.prevTransEventTime = event.getTime() + timeOffset;
        this.prevTransEventFirstTransTime = transitions.get((int)0).absoluteTime + timeOffset;
        this.prevTransEventLastTransTime = this.prevTransTime;
        this.prevTransEventID = event.getID();
        this.prevTrans = transitions.get(transitions.size() - 1);
        return this.prevTransTime;
    }

    public void copyTransitions(RSQSimStateTransitionFileReader transReader, Range<Double> transRange, double timeOffset, int evenIDOffset) throws IOException {
        int written = 0;
        double firstTime = Double.NaN;
        double lastTime = Double.NaN;
        RSQSimStateTransitionFileReader.TransVersion version = transReader.getVersion();
        for (RSQSimStateTime trans : transReader.getTransitionsIterable(transRange)) {
            double transTime = trans.absoluteTime;
            if (written == 0) {
                firstTime = transTime;
            }
            ++written;
            lastTime = transTime;
            if (Double.isFinite(timeOffset) && timeOffset != 0.0) {
                transTime += timeOffset;
            }
            if (version == RSQSimStateTransitionFileReader.TransVersion.ORIGINAL || version == RSQSimStateTransitionFileReader.TransVersion.TRANSV) {
                this.transOut.writeDouble(transTime);
                this.transOut.writeInt(trans.patchID - 1);
                this.transOut.writeByte(trans.state.getStateInt());
                if (version != RSQSimStateTransitionFileReader.TransVersion.TRANSV) continue;
                this.transOut.writeDouble(trans.velocity);
                continue;
            }
            if (version == RSQSimStateTransitionFileReader.TransVersion.CONSOLIDATED_RELATIVE) {
                this.transOut.writeDouble(transTime);
                this.transOut.writeFloat(trans.relativeTime);
                int eventID = trans.eventID >= 0 ? trans.eventID + evenIDOffset : trans.eventID;
                this.transOut.writeInt(eventID);
                this.transOut.writeInt(trans.patchID - 1);
                this.transOut.writeByte(trans.state.getStateInt());
                this.transOut.writeFloat(trans.velocity);
                continue;
            }
            throw new IllegalStateException("Cannot yet write transition version: " + String.valueOf((Object)version));
        }
        System.out.println("wrote " + written + " transitions from time range [" + firstTime + "," + lastTime + "]");
        if (Double.isFinite(timeOffset) && timeOffset != 0.0) {
            System.out.println("\tOffset output time range: [" + (firstTime + timeOffset) + "," + (lastTime + timeOffset) + "]");
        }
    }

    public void close() throws IOException {
        ((FilterOutputStream)((Object)this.eOut)).close();
        ((FilterOutputStream)((Object)this.pOut)).close();
        ((FilterOutputStream)((Object)this.dOut)).close();
        ((FilterOutputStream)((Object)this.tOut)).close();
        if (this.transOut != null) {
            ((FilterOutputStream)((Object)this.transOut)).close();
        }
    }

    public static void writeFilteredCatalog(Iterable<RSQSimEvent> events, RuptureIdentifier filter, File outputDir, String prefix, boolean bigEndian) throws IOException {
        RSQSimFileWriter writer = new RSQSimFileWriter(outputDir, prefix, bigEndian);
        writer.writeEvents(events, filter);
        writer.close();
    }

    public static void writeFilteredCatalog(Iterable<RSQSimEvent> events, RuptureIdentifier filter, File outputDir, String prefix, boolean bigEndian, RSQSimStateTransitionFileReader transReader) throws IOException {
        RSQSimFileWriter writer = new RSQSimFileWriter(outputDir, prefix, bigEndian, true, transReader.getVersion());
        for (RSQSimEvent event : events) {
            if (!filter.isMatch(event)) continue;
            writer.writeEvent(event);
            writer.writeTransitions(event, transReader, 0.0);
        }
        writer.close();
    }

    public static void stitchCatalogs(File outputDir, String outputPrefix, RuptureIdentifier filter, List<SimulatorElement> elements, File ... inputDirs) throws IOException {
        RSQSimFileWriter.stitchCatalogs(outputDir, outputPrefix, filter, elements, null, inputDirs);
    }

    public static void stitchCatalogs(File outputDir, String outputPrefix, RuptureIdentifier filter, List<SimulatorElement> elements, RSQSimStateTransitionFileReader.TransVersion version, File ... inputDirs) throws IOException {
        Preconditions.checkState((inputDirs.length > 1 ? 1 : 0) != 0, (Object)"Must supply at least 2 output directories");
        boolean bigEndian = RSQSimFileReader.isBigEndian(inputDirs[0], elements);
        RSQSimStateTransitionFileReader[] transReaders = version == null ? null : RSQSimFileWriter.loadTransReaders(inputDirs, bigEndian, version);
        RSQSimFileWriter writer = new RSQSimFileWriter(outputDir, outputPrefix, bigEndian, transReaders != null, version);
        ArrayList<PeekingIterator> iterators = new ArrayList<PeekingIterator>();
        RSQSimEvent prevLastEvent = null;
        int currentID = 1;
        double overallFirstTime = Double.NaN;
        for (int i = 0; i < inputDirs.length; ++i) {
            PeekingIterator it;
            if (iterators.size() > i) {
                it = (PeekingIterator)iterators.get(i);
            } else {
                it = Iterators.peekingIterator(RSQSimFileReader.getEventsIterable(inputDirs[i], elements).iterator());
                iterators.add(it);
            }
            PeekingIterator nextIt = null;
            if (i + 1 < inputDirs.length) {
                if (iterators.size() > i + 1) {
                    nextIt = (PeekingIterator)iterators.get(i + 1);
                } else {
                    nextIt = Iterators.peekingIterator(RSQSimFileReader.getEventsIterable(inputDirs[i + 1], elements).iterator());
                    iterators.add(nextIt);
                }
            }
            RSQSimEvent nextEvent = nextIt == null ? null : (RSQSimEvent)nextIt.peek();
            boolean first = true;
            boolean firstOverlap = true;
            int numOverlap = 0;
            int totalNum = 0;
            double firstTime = Double.NaN;
            int eventIDOffset = 0;
            while (it.hasNext()) {
                ++totalNum;
                RSQSimEvent event = (RSQSimEvent)it.next();
                if (first) {
                    firstTime = event.getTime();
                    eventIDOffset = currentID - event.getID();
                    System.out.println("Catalog " + i + " starts at t=" + firstTime + " s (" + event.getTimeInYears() + " yrs), first ID=" + event.getID() + " (offset=" + eventIDOffset + ")");
                    if (prevLastEvent != null) {
                        double deltaSecs = firstTime - prevLastEvent.getTime();
                        System.out.println("\t" + deltaSecs + " s (" + deltaSecs / 3.1536E7 + " yrs) after last event written from previous catalog");
                    }
                    first = false;
                }
                if (nextEvent == null || event.getTime() < nextEvent.getTime()) {
                    prevLastEvent = event;
                    if (filter == null || filter.isMatch(event)) {
                        writer.writeEvent(event, currentID);
                    }
                    ++currentID;
                    continue;
                }
                if (nextEvent != null && firstOverlap) {
                    firstOverlap = false;
                    double t1 = event.getTime();
                    double t2 = nextEvent.getTime();
                    double m1 = event.getMagnitude();
                    double m2 = nextEvent.getMagnitude();
                    if (t1 != t2 || m1 != m2) {
                        System.err.println("WARNING! Catalogs overlap, but first events in overlap zone are different. Is this catalog really an extension?");
                        System.err.println("\tLast written event with id=" + prevLastEvent.getID() + " from catalog " + i + ":\tt=" + prevLastEvent.getTime() + ", m=" + prevLastEvent.getMagnitude());
                        System.err.println("\tNext event with id=" + event.getID() + " at end of catalog " + i + ":\tt=" + t1 + ", m=" + m1);
                        System.err.println("\tEvent with id=" + nextEvent.getID() + " at start of catalog " + (i + 1) + ":\tt=" + t2 + ", m=" + m2);
                    }
                }
                ++numOverlap;
            }
            Preconditions.checkState((totalNum > 0 && prevLastEvent != null ? 1 : 0) != 0, (Object)("Catalog " + i + " has no events"));
            if (i == 0) {
                overallFirstTime = firstTime;
            }
            System.out.println("Processed " + (totalNum - numOverlap) + " events from catalog " + i);
            if (numOverlap > 0) {
                System.out.println("Skipped " + numOverlap + " events which overlap with next catalog");
            }
            double curTime = prevLastEvent.getTime();
            System.out.println("Duration for catalog " + i + ": " + (curTime - firstTime) / 3.1536E7 + " yrs");
            System.out.println("Current total duration: " + (curTime - overallFirstTime) / 3.1536E7 + " yrs");
            if (transReaders == null) continue;
            Range transRange = Range.closed((Comparable)Double.valueOf(transReaders[i].getFirstTransitionTime()), (Comparable)Double.valueOf(transReaders[i].getLastTransitionTime()));
            if (nextEvent != null && nextEvent.getTime() <= (Double)transRange.upperEndpoint()) {
                transRange = Range.closedOpen((Comparable)((Double)transRange.lowerEndpoint()), (Comparable)Double.valueOf(nextEvent.getTime()));
            }
            System.out.println("Copying transitions for range: " + String.valueOf(transRange));
            writer.copyTransitions(transReaders[i], (Range<Double>)transRange, 0.0, eventIDOffset);
        }
        System.out.println("Copying inputs");
        RSQSimFileWriter.writeCopyInputsForCombined(outputDir, outputPrefix, inputDirs);
        System.out.println("Done extending");
        writer.close();
    }

    private static RSQSimStateTransitionFileReader[] loadTransReaders(File[] inputDirs, boolean bigEndian, RSQSimStateTransitionFileReader.TransVersion version) throws IOException {
        File[] transFiles = new File[inputDirs.length];
        for (int i = 0; i < inputDirs.length; ++i) {
            for (File file : inputDirs[i].listFiles()) {
                String name = file.getName().toLowerCase();
                if (!name.endsWith(".out")) continue;
                if (name.startsWith("transv.")) {
                    transFiles[i] = file;
                    break;
                }
                if (!name.startsWith("trans.")) continue;
                transFiles[i] = file;
            }
            if (transFiles[i] != null) continue;
            transFiles = null;
            break;
        }
        RSQSimStateTransitionFileReader[] transReaders = null;
        if (transFiles == null) {
            System.out.println("Don't have transition files, will only write event files");
        } else {
            System.out.println("Have transition files, initializing");
            ByteOrder byteOrder = bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            transReaders = new RSQSimStateTransitionFileReader[transFiles.length];
            for (int i = 0; i < transReaders.length; ++i) {
                transReaders[i] = new RSQSimStateTransitionFileReader(transFiles[i], byteOrder, version);
                transReaders[i].setQuiet(true);
            }
        }
        return transReaders;
    }

    public static void combineSeparateCatalogs(File outputDir, String outputPrefix, RuptureIdentifier filter, List<SimulatorElement> elements, double skipYears, File ... inputDirs) throws IOException {
        RSQSimFileWriter.combineSeparateCatalogs(outputDir, outputPrefix, filter, elements, skipYears, null, inputDirs);
    }

    public static void combineSeparateCatalogs(File outputDir, String outputPrefix, RuptureIdentifier filter, List<SimulatorElement> elements, double skipYears, RSQSimStateTransitionFileReader.TransVersion version, File ... inputDirs) throws IOException {
        Preconditions.checkState((inputDirs.length > 1 ? 1 : 0) != 0, (Object)"Must supply at least 2 output directories");
        boolean bigEndian = RSQSimFileReader.isBigEndian(inputDirs[0], elements);
        RSQSimStateTransitionFileReader[] transReaders = version == null ? null : RSQSimFileWriter.loadTransReaders(inputDirs, bigEndian, version);
        RSQSimTransValidIden[] transValidIdens = null;
        if (transReaders != null) {
            transValidIdens = new RSQSimTransValidIden[transReaders.length];
            for (int i = 0; i < transReaders.length; ++i) {
                transValidIdens[i] = new RSQSimTransValidIden(transReaders[i]);
            }
        }
        RSQSimFileWriter writer = new RSQSimFileWriter(outputDir, outputPrefix, bigEndian, transReaders != null, version);
        Random r = new Random(elements.size());
        int currentID = 1;
        double curTime = 0.0;
        double nextPrintTime = 0.0;
        int totalWritten = 0;
        FileWriter logFW = new FileWriter(new File(outputDir, "combine_log.txt"));
        for (int i = 0; i < inputDirs.length; ++i) {
            System.out.println("*****************");
            System.out.println("Starting catalog " + i + " at " + curTime + " s = " + (float)(curTime / 3.1536E7) + " yrs");
            System.out.println("Loading events...");
            ArrayList<RuptureIdentifier> loadIdens = new ArrayList<RuptureIdentifier>();
            if (filter != null) {
                loadIdens.add(filter);
            }
            if (transValidIdens != null) {
                loadIdens.add(transValidIdens[i]);
            }
            if (skipYears > 0.0 && i > 0) {
                loadIdens.add(new SkipYearsLoadIden(skipYears));
            }
            if (loadIdens.isEmpty()) {
                loadIdens = null;
            } else if (loadIdens.size() > 1) {
                LogicalAndRupIden andIden = new LogicalAndRupIden(loadIdens);
                loadIdens = new ArrayList();
                loadIdens.add(andIden);
            }
            List<RSQSimEvent> events = RSQSimFileReader.readEventsFile(inputDirs[i], elements, loadIdens);
            System.out.println("Loaded " + events.size() + " events");
            Preconditions.checkState((!events.isEmpty() ? 1 : 0) != 0, (String)"no matching events for catalog %i: %s", (int)i, (Object)inputDirs[i].getAbsolutePath());
            double myStartTime = events.get(0).getTime();
            System.out.println("Catalog " + i + " internal start time is " + myStartTime);
            logFW.write("catalog " + i + "\n");
            logFW.write("original first event: " + events.get(i).getID() + " at " + myStartTime + " (" + (float)(myStartTime / 3.1536E7) + " yr)\n");
            ArrayList<Double> eventRIs = new ArrayList<Double>();
            double timeOffset = curTime - myStartTime;
            System.out.println("Time offset: " + timeOffset);
            System.out.println("*****************");
            logFW.write("time offset: " + timeOffset + "\n");
            logFW.write("modified first event: " + currentID + " at " + curTime + " (" + (float)(curTime / 3.1536E7) + " yr)\n");
            logFW.flush();
            Double prevWrittenTime = null;
            int catalogWritten = 0;
            for (RSQSimEvent event : events) {
                writer.writeEvent(event, currentID++, timeOffset);
                curTime = event.getTime() + timeOffset;
                if (transReaders != null) {
                    double lastTime = writer.writeTransitions(event, currentID - 1, transReaders[i], timeOffset);
                    Preconditions.checkState((lastTime >= curTime ? 1 : 0) != 0);
                    curTime = lastTime;
                }
                if (prevWrittenTime != null) {
                    double ri = event.getTime() - prevWrittenTime;
                    eventRIs.add(ri);
                }
                prevWrittenTime = event.getTime();
                ++catalogWritten;
                ++totalWritten;
                double curTimeYears = curTime / 3.1536E7;
                if (!(curTimeYears > nextPrintTime)) continue;
                System.out.println((float)curTimeYears + " yr: written " + totalWritten + " events, currentID=" + currentID);
                if (nextPrintTime < 1000.0) {
                    nextPrintTime += 100.0;
                    continue;
                }
                nextPrintTime += 1000.0;
            }
            logFW.write("wrote " + catalogWritten + " events\n");
            logFW.write("original last event: " + events.get(events.size() - 1).getID() + " at " + prevWrittenTime + " (" + (float)(prevWrittenTime / 3.1536E7) + " yr)\n");
            logFW.write("modified last event: " + (currentID - 1) + " at " + (prevWrittenTime + timeOffset) + " (" + (float)(prevWrittenTime + timeOffset / 3.1536E7) + " yr)\n");
            logFW.write("end time: " + curTime + " (" + (float)(curTime / 3.1536E7) + " yr)\n");
            System.out.println("Processed " + catalogWritten + " events from catalog " + i);
            Preconditions.checkState((catalogWritten > 0 ? 1 : 0) != 0, (Object)("Catalog " + i + " has no events"));
            System.out.println("Ended at " + curTime);
            double randRI = eventRIs.isEmpty() ? 1.0 : (Double)eventRIs.get(r.nextInt(eventRIs.size()));
            System.out.println("\tRandom recurrence interval: " + randRI + " (s)");
            logFW.write("random RI: " + randRI + " (" + (float)(randRI / 3.1536E7) + " yr)\n");
            System.out.println("\tMod end time: " + (curTime += randRI));
            logFW.write("mod end time: " + curTime + " (" + (float)(curTime / 3.1536E7) + " yr)\n");
            logFW.write("\n");
        }
        logFW.close();
        System.out.println("Copying inputs");
        RSQSimFileWriter.writeCopyInputsForCombined(outputDir, outputPrefix, inputDirs);
        System.out.println("Done combining");
        writer.close();
    }

    private static void writeCopyInputsForCombined(File outputDir, String prefix, File ... inputDirs) throws IOException {
        Map<String, String> commonParams = null;
        for (int i = 0; i < inputDirs.length; ++i) {
            Object geomFile;
            File paramFile = RSQSimFileReader.getParamFile(inputDirs[i]);
            if (paramFile == null) {
                System.out.println("No parameter file for catalog " + i + ", won't combine: " + inputDirs[i].getAbsolutePath());
                break;
            }
            Map<String, String> params = RSQSimFileReader.readParams(paramFile);
            if (i == 0) {
                commonParams = params;
                String geomFileName = params.get("faultFname");
                if (geomFileName == null || !((File)(geomFile = new File(inputDirs[i], geomFileName))).exists()) continue;
                System.out.println("Copying geom file from: " + ((File)geomFile).getAbsolutePath());
                Files.copy((File)geomFile, (File)new File(outputDir, ((File)geomFile).getName()));
                continue;
            }
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String key : commonParams.keySet()) {
                String v1 = commonParams.get(key);
                if (!params.containsKey(key)) {
                    System.out.println("Catalog " + i + " doesn't have parameter: " + key + " = " + v1);
                    toRemove.add(key);
                    continue;
                }
                String v2 = params.get(key);
                if (v1.equals(v2)) continue;
                System.out.println("Catalog " + i + " has different value for '" + key + "': " + v1 + " != " + v2);
                toRemove.add(key);
            }
            geomFile = toRemove.iterator();
            while (geomFile.hasNext()) {
                String key;
                key = (String)geomFile.next();
                commonParams.remove(key);
            }
        }
        if (commonParams != null) {
            commonParams.put("outFnameInfix", prefix);
            File outputFile = new File(outputDir, prefix + ".in");
            System.out.println("Writing " + commonParams.size() + " parameter values to: " + outputFile.getAbsolutePath());
            ArrayList<String> keys = new ArrayList<String>(commonParams.keySet());
            Collections.sort(keys);
            FileWriter fw = new FileWriter(outputFile);
            for (String key : keys) {
                fw.write(" " + key + " = " + commonParams.get(key) + "\n");
            }
            fw.close();
        }
    }

    public static void patchFilterCatalog(Iterable<RSQSimEvent> events, List<SimulatorElement> allPatches, Set<Integer> includePatches, boolean includeOtherCorupturingPatches, RuptureIdentifier rupFilter, File outputDir, String prefix, boolean bigEndian) throws IOException {
        RSQSimFileWriter.patchFilterCatalog(events, allPatches, includePatches, includeOtherCorupturingPatches, rupFilter, outputDir, prefix, bigEndian, null);
    }

    public static void patchFilterCatalog(Iterable<RSQSimEvent> events, List<SimulatorElement> allPatches, Set<Integer> includePatches, boolean includeOtherCorupturingPatches, RuptureIdentifier rupFilter, File outputDir, String prefix, boolean bigEndian, RSQSimStateTransitionFileReader transReader) throws IOException {
        RSQSimFileWriter writer = new RSQSimFileWriter(outputDir, prefix, bigEndian, transReader != null, transReader == null ? null : transReader.getVersion());
        int numWritten = 0;
        int totalNum = 0;
        for (RSQSimEvent e : events) {
            int patch;
            boolean match;
            int[] elementIDs;
            ++totalNum;
            if (rupFilter != null && !rupFilter.isMatch(e)) continue;
            boolean fullMatch = false;
            boolean anyMatch = false;
            int[] nArray = elementIDs = e.getAllElementIDs();
            int n = nArray.length;
            for (int i = 0; i < n && (!(anyMatch |= (match = includePatches.contains(patch = nArray[i]))) || (fullMatch &= match)); ++i) {
            }
            if (!anyMatch) continue;
            ArrayList<RSQSimStateTime> transitions = null;
            if (transReader != null) {
                transitions = new ArrayList<RSQSimStateTime>();
                transReader.getTransitions(e, transitions);
            }
            if (!fullMatch && !includeOtherCorupturingPatches) {
                ArrayList<RSQSimEventRecord> modRecords = new ArrayList<RSQSimEventRecord>();
                for (EventRecord origRec : e) {
                    Preconditions.checkState((boolean)(origRec instanceof RSQSimEventRecord));
                    RSQSimEventRecord rsRec = (RSQSimEventRecord)origRec;
                    int[] recIDs = rsRec.getElementIDs();
                    int numMatches = 0;
                    for (int patch2 : recIDs) {
                        if (!includePatches.contains(patch2)) continue;
                        ++numMatches;
                    }
                    if (numMatches == recIDs.length) {
                        modRecords.add(rsRec);
                        continue;
                    }
                    if (numMatches <= 0) continue;
                    double[] recSlips = rsRec.getElementSlips();
                    RSQSimEventRecord modRec = new RSQSimEventRecord(allPatches);
                    for (int i = 0; i < recIDs.length; ++i) {
                        if (!includePatches.contains(recIDs[i])) continue;
                        modRec.addSlip(recIDs[i], recSlips[i]);
                    }
                    modRecords.add(modRec);
                }
                Preconditions.checkState((!modRecords.isEmpty() ? 1 : 0) != 0);
                e = new RSQSimEvent((List<RSQSimEventRecord>)modRecords);
                if (transitions != null) {
                    ArrayList<RSQSimStateTime> filteredTrans = new ArrayList<RSQSimStateTime>();
                    for (RSQSimStateTime trans : transitions) {
                        if (!includePatches.contains(trans.patchID)) continue;
                        filteredTrans.add(trans);
                    }
                }
            }
            writer.writeEvent(e);
            if (transitions != null) {
                writer.writeTransitions(e, e.getID(), 0.0, transReader.getVersion(), transitions);
            }
            ++numWritten;
        }
        writer.close();
        System.out.println("Wrote " + numWritten + "/" + totalNum + " events");
    }

    public static void main(String[] args) throws IOException {
        File bruceDir = new File("/home/kevin/Simulators/catalogs/bruce");
        File origDir = new File(bruceDir, "rundir6261");
        int thousandYears = 200;
        File skipDir = new File(bruceDir, origDir.getName() + "_skip" + thousandYears + "k");
        Preconditions.checkState((skipDir.exists() || skipDir.mkdir() ? 1 : 0) != 0);
        SkipYearsLoadIden filter = new SkipYearsLoadIden((double)thousandYears * 1000.0);
        List<SimulatorElement> elements = RSQSimFileReader.readGeometryFile(new File(origDir, "zfault_Deepen.in"), 11, 'S');
        Iterable<RSQSimEvent> allEvents = RSQSimFileReader.getEventsIterable(origDir, elements);
        RSQSimFileWriter.writeFilteredCatalog(allEvents, filter, skipDir, "skip" + thousandYears + "k", false);
        for (File file : origDir.listFiles()) {
            if (!file.getName().endsWith(".in")) continue;
            Files.copy((File)file, (File)new File(skipDir, file.getName()));
        }
    }

    private class PatchSlipTime
    implements Comparable<PatchSlipTime> {
        final int patchID;
        final double slip;
        final double time;

        public PatchSlipTime(int patchID, double slip, double time) {
            this.patchID = patchID;
            this.slip = slip;
            this.time = time;
        }

        @Override
        public int compareTo(PatchSlipTime o) {
            return Double.compare(this.time, o.time);
        }
    }
}

