/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.simulators.RectangularElement;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.Vertex;

public class WardFileReader {
    public static List<SimulatorElement> readGeometryFile(File geomFile) throws IOException {
        return WardFileReader.readGeometryFile(new FileInputStream(geomFile));
    }

    public static List<SimulatorElement> readGeometryFile(InputStream is) throws IOException {
        int i;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        ArrayList<SimulatorElement> rectElementsList = new ArrayList<SimulatorElement>();
        ArrayList<Vertex> vertexList = new ArrayList<Vertex>();
        ArrayList rectElementsListForSections = new ArrayList();
        ArrayList vertexListForSections = new ArrayList();
        ArrayList<String> sectionNamesList = new ArrayList<String>();
        ArrayList<Integer> faultIDs_ForSections = new ArrayList<Integer>();
        int lastSectionID = -1;
        ArrayList<RectangularElement> currentRectElForSection = null;
        ArrayList<Vertex> currVertexListForSection = null;
        int numVertices = 0;
        String line = reader.readLine();
        while (line != null) {
            if (line.isEmpty()) {
                line = reader.readLine();
                continue;
            }
            StringTokenizer tok = new StringTokenizer(line);
            int id = Integer.parseInt(tok.nextToken());
            int numAlongStrike = Integer.parseInt(tok.nextToken());
            int numDownDip = Integer.parseInt(tok.nextToken());
            int faultID = Integer.parseInt(tok.nextToken());
            int sectionID = Integer.parseInt(tok.nextToken());
            double slipRate = Double.parseDouble(tok.nextToken());
            double strength = Double.parseDouble(tok.nextToken());
            double strike = Double.parseDouble(tok.nextToken());
            double dip = Double.parseDouble(tok.nextToken());
            double rake = Double.parseDouble(tok.nextToken());
            FocalMechanism focalMechanism = new FocalMechanism(strike, dip, rake);
            Vertex[] vertices = new Vertex[4];
            double lat = Double.parseDouble(tok.nextToken());
            double lon = Double.parseDouble(tok.nextToken());
            double depth = Double.parseDouble(tok.nextToken()) / -1000.0;
            vertices[0] = new Vertex(lat, lon, depth, ++numVertices);
            lat = Double.parseDouble(tok.nextToken());
            lon = Double.parseDouble(tok.nextToken());
            depth = Double.parseDouble(tok.nextToken()) / -1000.0;
            vertices[1] = new Vertex(lat, lon, depth, ++numVertices);
            lat = Double.parseDouble(tok.nextToken());
            lon = Double.parseDouble(tok.nextToken());
            depth = Double.parseDouble(tok.nextToken()) / -1000.0;
            vertices[2] = new Vertex(lat, lon, depth, ++numVertices);
            lat = Double.parseDouble(tok.nextToken());
            lon = Double.parseDouble(tok.nextToken());
            depth = Double.parseDouble(tok.nextToken()) / -1000.0;
            vertices[3] = new Vertex(lat, lon, depth, ++numVertices);
            Object name = null;
            while (tok.hasMoreTokens()) {
                name = name == null ? "" : (String)name + " ";
                name = (String)name + tok.nextToken();
            }
            String sectionName = name;
            RectangularElement rectElem = new RectangularElement(id, vertices, sectionName, faultID, sectionID, numAlongStrike, numDownDip, slipRate, Double.NaN, focalMechanism, true);
            rectElementsList.add(rectElem);
            if (sectionID != lastSectionID) {
                currentRectElForSection = new ArrayList<RectangularElement>();
                currVertexListForSection = new ArrayList<Vertex>();
                rectElementsListForSections.add(currentRectElForSection);
                vertexListForSections.add(currVertexListForSection);
                sectionNamesList.add(sectionName);
                faultIDs_ForSections.add(faultID);
            }
            currentRectElForSection.add(rectElem);
            for (int i2 = 0; i2 < 4; ++i2) {
                vertexList.add(vertices[i2]);
                currVertexListForSection.add(vertices[i2]);
            }
            line = reader.readLine();
        }
        for (i = 0; i < vertexList.size(); ++i) {
            int idMinus1 = ((Vertex)vertexList.get(i)).getID() - 1;
            if (i == idMinus1) continue;
            throw new RuntimeException("vertexList index problem at index " + i + " (ID-1=" + idMinus1 + ")");
        }
        for (i = 0; i < rectElementsList.size(); ++i) {
            if (i == ((SimulatorElement)rectElementsList.get(i)).getID() - 1) continue;
            throw new RuntimeException("rectElementsList index problem at " + i);
        }
        System.out.println("namesOfSections.size()=" + sectionNamesList.size() + "\tvertexList.size()=" + vertexList.size() + "\trectElementsList.size()=" + rectElementsList.size());
        return rectElementsList;
    }
}

