/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.srf;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public enum RSQSimState {
    LOCKED(0),
    NUCLEATING_SLIP(1),
    EARTHQUAKE_SLIP(2),
    CREEP(3),
    LOW_SIGMA(4),
    LOW_TAU(5),
    HIGH_THETA(6),
    SLOW_SLIP_2A(7),
    SLOW_SLIP_2B(8),
    SLOW_SLIP_2C(9),
    HIGH_TAU(10),
    MAX_TIME_STEP(11),
    STRESS_RATE_STEP(12),
    HIGH_SIGMA(13);

    private int stateInt;
    private static final Map<Integer, RSQSimState> statesMap;

    private RSQSimState(int stateInt) {
        this.stateInt = stateInt;
    }

    public int getStateInt() {
        return this.stateInt;
    }

    public static RSQSimState forInt(int stateInt) {
        RSQSimState state = statesMap.get(stateInt);
        Preconditions.checkState((state != null ? 1 : 0) != 0, (Object)("Unknown state: " + stateInt));
        return state;
    }

    static {
        statesMap = new HashMap<Integer, RSQSimState>();
        for (RSQSimState state : RSQSimState.values()) {
            statesMap.put(state.stateInt, state);
        }
    }
}

