/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.srf;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.RSQSimEvent;
import org.opensha.sha.simulators.RSQSimEventRecord;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.AbstractRuptureIdentifier;
import org.opensha.sha.simulators.srf.RSQSimEventSlipTimeFunc;
import org.opensha.sha.simulators.srf.RSQSimStateTransitionFileReader;

public class RSQSimTransValidIden
extends AbstractRuptureIdentifier {
    private RSQSimStateTransitionFileReader trans;
    private double firstTrans;
    private double lastTrans;

    public RSQSimTransValidIden(RSQSimStateTransitionFileReader trans) throws IOException {
        this.trans = trans;
        this.firstTrans = trans.getFirstTransitionTime();
        this.lastTrans = trans.getLastTransitionTime();
    }

    @Override
    public boolean isMatch(SimulatorEvent event) {
        Preconditions.checkState((boolean)(event instanceof RSQSimEvent));
        double eventStart = event.getTime();
        if (eventStart < this.firstTrans || eventStart > this.lastTrans) {
            return false;
        }
        if (this.lastTrans - eventStart < 3600.0) {
            RSQSimEventSlipTimeFunc slipTime = null;
            double nextEventTime = ((RSQSimEvent)event).getNextEventTime();
            for (EventRecord rec : event) {
                RSQSimEventRecord rRec = (RSQSimEventRecord)rec;
                int[] ids = rRec.getElementIDs();
                for (int i = 0; i < ids.length; ++i) {
                    if (!Double.isFinite(nextEventTime)) {
                        int patchID;
                        double slip;
                        double pDiff;
                        if (slipTime == null) {
                            try {
                                slipTime = new RSQSimEventSlipTimeFunc(this.trans.getTransitions((RSQSimEvent)event));
                            }
                            catch (IOException e) {
                                throw ExceptionUtils.asRuntimeException(e);
                            }
                            catch (IllegalStateException e) {
                                return false;
                            }
                        }
                        if (!((pDiff = DataUtils.getPercentDiff(slip = slipTime.getCumulativeEventSlip(patchID = rRec.getElementIDs()[i], slipTime.getEndTime()), rRec.getElementSlips()[i])) > 1.0)) continue;
                        return false;
                    }
                    if (!(nextEventTime > this.lastTrans)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "Transition-valid events identifier";
    }
}

