/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.stiffness;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.CSVFile;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;
import org.opensha.sha.simulators.stiffness.SubSectStiffnessCalculator;

public class AggregatedStiffnessCache {
    public Map<AggregatedStiffnessCalculator.AggregationMethod, AggregatedStiffnessCalculator.ReceiverDistribution[][][]> patchAggregatedCache;
    public Map<AggregatedStiffnessCalculator.AggregationMethod, AggregatedStiffnessCalculator.StiffnessAggregation[][]> patchSectAggregatedCache;
    public AggregatedStiffnessCalculator.StiffnessAggregation[][] fullDistCache;
    private SubSectStiffnessCalculator calc;
    private List<? extends FaultSection> sects;
    private SubSectStiffnessCalculator.StiffnessType type;

    AggregatedStiffnessCache(SubSectStiffnessCalculator calc, SubSectStiffnessCalculator.StiffnessType type) {
        this.calc = calc;
        this.type = type;
        this.sects = calc.getSubSects();
        this.patchAggregatedCache = new HashMap<AggregatedStiffnessCalculator.AggregationMethod, AggregatedStiffnessCalculator.ReceiverDistribution[][][]>();
        this.patchSectAggregatedCache = new HashMap<AggregatedStiffnessCalculator.AggregationMethod, AggregatedStiffnessCalculator.StiffnessAggregation[][]>();
        Preconditions.checkArgument((this.sects != null && !this.sects.isEmpty() ? 1 : 0) != 0);
        for (int i = 0; i < this.sects.size(); ++i) {
            Preconditions.checkState((this.sects.get(i).getSectionId() == i ? 1 : 0) != 0, (Object)"section IDs must be 0-based indexes");
        }
    }

    public synchronized void clear() {
        this.fullDistCache = null;
        this.patchSectAggregatedCache.clear();
        this.patchAggregatedCache.clear();
    }

    public AggregatedStiffnessCalculator.ReceiverDistribution[] getPatchAggregated(AggregatedStiffnessCalculator.AggregationMethod patchAggMethod, FaultSection source, FaultSection receiver) {
        AggregatedStiffnessCalculator.ReceiverDistribution[][][] cache = this.patchAggregatedCache.get((Object)patchAggMethod);
        if (cache == null || cache[receiver.getSectionId()] == null) {
            return null;
        }
        return cache[receiver.getSectionId()][source.getSectionId()];
    }

    public synchronized void putPatchAggregated(AggregatedStiffnessCalculator.AggregationMethod patchAggMethod, FaultSection source, FaultSection receiver, AggregatedStiffnessCalculator.ReceiverDistribution[] aggregated) {
        AggregatedStiffnessCalculator.ReceiverDistribution[][][] cache = this.patchAggregatedCache.get((Object)patchAggMethod);
        if (cache == null) {
            cache = new AggregatedStiffnessCalculator.ReceiverDistribution[this.sects.size()][this.sects.size()][];
            this.patchAggregatedCache.put(patchAggMethod, cache);
        }
        if (cache[receiver.getSectionId()] == null) {
            cache[receiver.getSectionId()] = new AggregatedStiffnessCalculator.ReceiverDistribution[this.sects.size()][];
        }
        cache[receiver.getSectionId()][source.getSectionId()] = aggregated;
    }

    public AggregatedStiffnessCalculator.StiffnessAggregation getSectAggregated(AggregatedStiffnessCalculator.AggregationMethod patchAggMethod, FaultSection source, FaultSection receiver) {
        AggregatedStiffnessCalculator.StiffnessAggregation[][] cache = patchAggMethod == null ? this.fullDistCache : this.patchSectAggregatedCache.get((Object)patchAggMethod);
        if (cache == null || cache[receiver.getSectionId()] == null) {
            return null;
        }
        return cache[receiver.getSectionId()][source.getSectionId()];
    }

    public synchronized void putSectAggregated(AggregatedStiffnessCalculator.AggregationMethod patchAggMethod, FaultSection source, FaultSection receiver, AggregatedStiffnessCalculator.StiffnessAggregation aggregated) {
        this.putSectAggregated(patchAggMethod, source.getSectionId(), receiver.getSectionId(), aggregated);
    }

    private void putSectAggregated(AggregatedStiffnessCalculator.AggregationMethod patchAggMethod, int sourceID, int receiverID, AggregatedStiffnessCalculator.StiffnessAggregation aggregated) {
        AggregatedStiffnessCalculator.StiffnessAggregation[][] cache;
        if (patchAggMethod == null) {
            if (this.fullDistCache == null) {
                this.fullDistCache = new AggregatedStiffnessCalculator.StiffnessAggregation[this.sects.size()][];
            }
            cache = this.fullDistCache;
        } else {
            if (this.patchSectAggregatedCache == null) {
                this.patchSectAggregatedCache = new HashMap<AggregatedStiffnessCalculator.AggregationMethod, AggregatedStiffnessCalculator.StiffnessAggregation[][]>();
            }
            if ((cache = this.patchSectAggregatedCache.get((Object)patchAggMethod)) == null) {
                cache = new AggregatedStiffnessCalculator.StiffnessAggregation[this.sects.size()][];
                this.patchSectAggregatedCache.put(patchAggMethod, cache);
            }
        }
        if (cache[receiverID] == null) {
            cache[receiverID] = new AggregatedStiffnessCalculator.StiffnessAggregation[this.sects.size()];
        }
        cache[receiverID][sourceID] = aggregated;
    }

    public int calcCacheSize() {
        int size = this.calcCacheSize(this.fullDistCache);
        for (AggregatedStiffnessCalculator.StiffnessAggregation[][] cache : this.patchSectAggregatedCache.values()) {
            size += this.calcCacheSize(cache);
        }
        return size;
    }

    private int calcCacheSize(AggregatedStiffnessCalculator.StiffnessAggregation[][] cache) {
        if (cache == null) {
            return 0;
        }
        int cached = 0;
        for (int i = 0; i < cache.length; ++i) {
            if (cache[i] == null) continue;
            for (int j = 0; j < cache.length; ++j) {
                if (cache[i][j] == null) continue;
                ++cached;
            }
        }
        return cached;
    }

    public String getCacheFileName() {
        DecimalFormat df = new DecimalFormat("0.##");
        String ret = this.type.name().toLowerCase() + "_cache_" + SectionDistanceAzimuthCalculator.getUniqueSectCacheFileStr(this.sects) + "_" + df.format(this.calc.getGridSpacing()) + "km_lambda" + df.format(this.calc.getLameLambda()) + "_mu" + df.format(this.calc.getLameMu()) + "_coeff" + (float)this.calc.getCoeffOfFriction() + "_align" + this.calc.getPatchAlignment().name();
        if (this.calc.getSelfStiffnessCap() > 0.0) {
            ret = ret + "_stiffCap" + df.format(this.calc.getSelfStiffnessCap()) + "x";
        }
        return ret + ".csv";
    }

    public void writeCacheFile(File cacheFile) throws IOException {
        CSVFile<String> csv = new CSVFile<String>(true);
        ArrayList<String> line = new ArrayList<String>();
        line.add("Source ID");
        line.add("Receiver ID");
        line.add("Receiver Patch Aggregation");
        for (AggregatedStiffnessCalculator.AggregationMethod method : AggregatedStiffnessCalculator.CACHEABLE_AGG_METHODS) {
            line.add(method.name());
        }
        csv.addLine((List<String>)line);
        this.writeCacheLines(csv, null, this.fullDistCache);
        for (AggregatedStiffnessCalculator.AggregationMethod patchMethod : this.patchSectAggregatedCache.keySet()) {
            this.writeCacheLines(csv, patchMethod, this.patchSectAggregatedCache.get((Object)patchMethod));
        }
        csv.writeToFile(cacheFile);
    }

    private void writeCacheLines(CSVFile<String> csv, AggregatedStiffnessCalculator.AggregationMethod patchMethod, AggregatedStiffnessCalculator.StiffnessAggregation[][] cache) {
        if (cache == null) {
            return;
        }
        for (int i = 0; i < cache.length; ++i) {
            if (cache[i] == null) continue;
            for (int j = 0; j < cache[i].length; ++j) {
                if (cache[i][j] == null) continue;
                AggregatedStiffnessCalculator.StiffnessAggregation agg = cache[i][j];
                ArrayList<Object> line = new ArrayList<Object>();
                line.add("" + j);
                line.add("" + i);
                line.add(patchMethod == null ? "" : patchMethod.name());
                for (AggregatedStiffnessCalculator.AggregationMethod method : AggregatedStiffnessCalculator.CACHEABLE_AGG_METHODS) {
                    line.add("" + agg.get(method));
                }
                csv.addLine((List<String>)line);
            }
        }
    }

    public int loadCacheFile(File cacheFile) throws IOException {
        int col;
        System.out.println("Loading " + String.valueOf((Object)this.type) + " cache from " + cacheFile.getAbsolutePath() + "...");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(cacheFile), 65536);
        CSVFile<String> csv = CSVFile.readStream(bis, true);
        List<String> header = csv.getLine(0);
        if (header.size() < 4) {
            System.err.println("Warning: stiffness cache file is invalid, skipping loading");
            return 0;
        }
        AggregatedStiffnessCalculator.AggregationMethod[] methods = new AggregatedStiffnessCalculator.AggregationMethod[header.size() - 3];
        if (methods.length != AggregatedStiffnessCalculator.CACHEABLE_AGG_METHODS.size()) {
            System.err.println("Warning: aggregation methods have changed and cache is now invalid, skipping loading");
            return 0;
        }
        HashSet<AggregatedStiffnessCalculator.AggregationMethod> prevMethods = new HashSet<AggregatedStiffnessCalculator.AggregationMethod>();
        for (int i = 0; i < methods.length; ++i) {
            col = i + 3;
            String name = header.get(col);
            try {
                methods[i] = AggregatedStiffnessCalculator.AggregationMethod.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Warning: aggregation methods have changed (can't find '" + name + "') and cache is now invalid, skipping loading");
                return 0;
            }
            if (!AggregatedStiffnessCalculator.CACHEABLE_AGG_METHODS.contains((Object)methods[i])) {
                System.err.println("Warning: aggregation methods have changed and cache is now invalid, skipping loading");
                return 0;
            }
            if (prevMethods.contains((Object)methods[i])) {
                System.err.println("Warning: cache contains duplicate columns and is invalid, skipping loading");
                return 0;
            }
            prevMethods.add(methods[i]);
        }
        for (int row = 1; row < csv.getNumRows(); ++row) {
            String aggStr;
            col = 0;
            int sourceID = csv.getInt(row, col++);
            int receiverID = csv.getInt(row, col++);
            AggregatedStiffnessCalculator.AggregationMethod patchAggMethod = (aggStr = csv.get(row, col++)).isEmpty() ? null : AggregatedStiffnessCalculator.AggregationMethod.valueOf(aggStr);
            double[] aggValues = new double[methods.length];
            for (int i = 0; i < methods.length; ++i) {
                aggValues[i] = csv.getDouble(row, col++);
            }
            AggregatedStiffnessCalculator.StiffnessAggregation aggregation = new AggregatedStiffnessCalculator.StiffnessAggregation(methods, aggValues);
            this.putSectAggregated(patchAggMethod, sourceID, receiverID, aggregation);
        }
        System.out.println("Loaded " + (csv.getNumRows() - 1) + " values");
        return csv.getNumRows() - 1;
    }

    public void copyCacheFrom(AggregatedStiffnessCache o) {
        Preconditions.checkState((this.type == o.type ? 1 : 0) != 0);
        Preconditions.checkState((this.sects.size() == o.sects.size() ? 1 : 0) != 0);
        this.copyCacheFrom(null, o.fullDistCache);
        for (AggregatedStiffnessCalculator.AggregationMethod aggMethod : this.patchSectAggregatedCache.keySet()) {
            this.copyCacheFrom(aggMethod, o.patchSectAggregatedCache.get((Object)aggMethod));
        }
    }

    private void copyCacheFrom(AggregatedStiffnessCalculator.AggregationMethod patchAggMethod, AggregatedStiffnessCalculator.StiffnessAggregation[][] cache) {
        if (cache == null) {
            return;
        }
        for (int r = 0; r < cache.length; ++r) {
            if (cache[r] == null) continue;
            for (int s = 0; s < cache[r].length; ++s) {
                if (cache[r][s] == null) continue;
                this.putSectAggregated(patchAggMethod, s, r, cache[r][s]);
            }
        }
    }
}

