/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.utils;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.xyz.EvenlyDiscrXYZ_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.simulators.RSQSimEvent;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.Vertex;
import org.opensha.sha.simulators.iden.MagRangeRuptureIdentifier;
import org.opensha.sha.simulators.parsers.RSQSimFileReader;
import org.opensha.sha.simulators.utils.RSQSimUtils;
import org.opensha.sha.simulators.utils.RupturePlotGenerator;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.kevin.simulators.erf.SimulatorFaultSystemSolution;

public class RSQSimSubSectionMapper {
    private List<? extends FaultSection> subSects;
    private List<SimulatorElement> elements;
    private Map<Integer, Double> subSectAreas;
    private Map<IDPairing, Double> distsCache;
    private Map<SimulatorElement, SubSectDAS_Record> elemRawDASs;
    private Map<SimulatorElement, SubSectDAS_Record> elemSectDASs;
    private int minElemSectID;
    private Map<SimulatorElement, FaultSection> elemToSectsMap;
    private Map<FaultSection, HashSet<SimulatorElement>> sectsToElemsMap;
    private Map<SimulatorElement, FaultSection> slipElemsToSectsMap;
    private Map<FaultSection, HashSet<SimulatorElement>> slipSectsToElemsMap;
    private Map<FaultSection, double[]> sectMidDepthConstraints;
    private LoadingCache<SimulatorEvent, List<List<SubSectionMapping>>> mappingsCache;
    public static final double MID_SEIS_MIN_DEPTH_DEFAULT = 4.0;
    public static final double MID_SEIS_MAX_DEPTH_DEFAULT = 8.0;
    public static final double MID_SEIS_BUFFER_DEFAULT = 2.0;
    private double minSlipDepth;
    private double maxSlipDepth;
    private double faultDownDipBuffer;
    private double minFractForInclusion;
    private static Comparator<FaultSection> sectIDCompare = new Comparator<FaultSection>(){

        @Override
        public int compare(FaultSection o1, FaultSection o2) {
            return Integer.valueOf(o1.getSectionId()).compareTo(o2.getSectionId());
        }
    };

    public RSQSimSubSectionMapper(List<? extends FaultSection> subSects, List<SimulatorElement> elements, double minFractForInclusion) {
        this(subSects, elements, minFractForInclusion, RSQSimUtils.calcSubSectAreas(elements, subSects), new HashMap<IDPairing, Double>());
    }

    public RSQSimSubSectionMapper(List<? extends FaultSection> subSects, List<SimulatorElement> elements, double minFractForInclusion, Map<Integer, Double> subSectAreas, Map<IDPairing, Double> distsCache) {
        this.subSects = subSects;
        this.elements = elements;
        this.minFractForInclusion = minFractForInclusion;
        this.subSectAreas = subSectAreas;
        this.distsCache = distsCache;
        this.minElemSectID = RSQSimUtils.getSubSectIndexOffset(elements, subSects);
        this.elemToSectsMap = new HashMap<SimulatorElement, FaultSection>();
        this.sectsToElemsMap = new HashMap<FaultSection, HashSet<SimulatorElement>>();
        for (SimulatorElement simulatorElement : elements) {
            int sectID = simulatorElement.getSectionID() - this.minElemSectID;
            Preconditions.checkState((sectID >= 0 && sectID <= subSects.size() ? 1 : 0) != 0, (String)"Bad section id. origID=%s, minID=%s, index=%s, numSects=%s", (Object)simulatorElement.getSectionID(), (Object)this.minElemSectID, (Object)sectID, (Object)subSects.size());
            FaultSection sect = subSects.get(sectID);
            this.elemToSectsMap.put(simulatorElement, sect);
            HashSet<SimulatorElement> sectElems = this.sectsToElemsMap.get(sect);
            if (sectElems == null) {
                sectElems = new HashSet();
                this.sectsToElemsMap.put(sect, sectElems);
            }
            sectElems.add(simulatorElement);
        }
        this.elemSectDASs = new HashMap<SimulatorElement, SubSectDAS_Record>();
        this.elemRawDASs = new HashMap<SimulatorElement, SubSectDAS_Record>();
        for (FaultSection faultSection : subSects) {
            if (!this.sectsToElemsMap.containsKey(faultSection)) continue;
            Preconditions.checkState((boolean)subSectAreas.containsKey(faultSection.getSectionId()), (String)"No area found for section %s, %s, with %s mapped elements", (Object)faultSection.getSectionId(), (Object)faultSection.getSectionName(), (Object)this.sectsToElemsMap.get(faultSection).size());
            HashSet<SimulatorElement> sectElems = this.sectsToElemsMap.get(faultSection);
            SimpleFaultData sfd = new SimpleFaultData(faultSection.getAveDip(), Math.max(faultSection.getAveLowerDepth(), 20.0), faultSection.getOrigAveUpperDepth(), faultSection.getFaultTrace(), faultSection.getDipDirection());
            StirlingGriddedSurface gridSurf = new StirlingGriddedSurface(sfd, 0.5, 1.0);
            double sectLen = faultSection.getFaultTrace().getTraceLength();
            int rows = gridSurf.getNumRows();
            int cols = gridSurf.getNumCols();
            int numDAS_x = 100;
            double spacingX = 1.0 / (double)(numDAS_x - 1);
            double spacingY = 1.0 / (double)(rows - 1);
            EvenlyDiscrXYZ_DataSet dasXYZ = new EvenlyDiscrXYZ_DataSet(numDAS_x, rows, 0.0, 0.0, spacingX, spacingY);
            Preconditions.checkState(((float)dasXYZ.getMaxX() == 1.0f ? 1 : 0) != 0);
            Preconditions.checkState(((float)dasXYZ.getMaxY() == 1.0f ? 1 : 0) != 0);
            boolean debugSect = false;
            if (debugSect) {
                System.out.println("DEBUG section " + faultSection.getSectionName() + " with " + sectElems.size() + " elements");
            }
            for (int row = 0; row < rows; ++row) {
                double cumulativeLen = 0.0;
                ArbitrarilyDiscretizedFunc dasFunc = new ArbitrarilyDiscretizedFunc();
                dasFunc.set(0.0, 0.0);
                Location start = (Location)gridSurf.get(row, 0);
                Location end = (Location)gridSurf.get(row, gridSurf.getNumCols() - 1);
                for (int col = 1; col < gridSurf.getNumCols(); ++col) {
                    double rawDAS = this.calcStraightLineDAS(start, end, (Location)gridSurf.get(row, col));
                    dasFunc.set(rawDAS, cumulativeLen += LocationUtils.horzDistanceFast((Location)gridSurf.get(row, col - 1), (Location)gridSurf.get(row, col)));
                }
                for (int xInd = 0; xInd < numDAS_x; ++xInd) {
                    double normX = dasXYZ.getX(xInd);
                    Preconditions.checkState((normX <= 1.0 ? 1 : 0) != 0);
                    double funcDAS = normX * dasFunc.getMaxX();
                    Preconditions.checkState((funcDAS <= dasFunc.getMaxX() ? 1 : 0) != 0, (String)"Bad funcDAS: %s * %s = %s > %s", (Object)normX, (Object)cumulativeLen, (Object)funcDAS, (Object)dasFunc.getMaxX());
                    double uncorrectedDAS = dasFunc.getInterpolatedY(funcDAS);
                    Preconditions.checkState((uncorrectedDAS <= cumulativeLen && uncorrectedDAS >= 0.0 ? 1 : 0) != 0);
                    double realDAS = sectLen * uncorrectedDAS / cumulativeLen;
                    dasXYZ.set(xInd, row, realDAS);
                }
            }
            HashMap<SimulatorElement, Integer> elemRows = new HashMap<SimulatorElement, Integer>();
            DefaultXY_DataSet dasDepthFunc = new DefaultXY_DataSet();
            ArrayList<Double> dips = new ArrayList<Double>();
            for (SimulatorElement elem : sectElems) {
                Location center = elem.getCenterLocation();
                dips.add(elem.getFocalMechanism().getDip());
                int closestRow = -1;
                double minDepthDiff = Double.POSITIVE_INFINITY;
                for (int row = 0; row < rows; ++row) {
                    double depthDiff = Math.abs(center.getDepth() - ((Location)gridSurf.get(row, 0)).getDepth());
                    if (!(depthDiff < minDepthDiff)) continue;
                    minDepthDiff = depthDiff;
                    closestRow = row;
                }
                Location start = (Location)gridSurf.get(closestRow, 0);
                Location end = (Location)gridSurf.get(closestRow, gridSurf.getNumCols() - 1);
                double rawMidDAS = this.calcStraightLineDAS(start, end, center);
                Vertex[] verts = elem.getVertices();
                double[] vertDASs = new double[verts.length];
                for (int i = 0; i < verts.length; ++i) {
                    vertDASs[i] = this.calcStraightLineDAS(start, end, verts[i]);
                    dasDepthFunc.set(vertDASs[i], verts[i].getDepth());
                }
                try {
                    this.elemRawDASs.put(elem, new SubSectDAS_Record(vertDASs, rawMidDAS));
                }
                catch (RuntimeException e1) {
                    System.out.println("Element: " + elem.getID() + ". " + elem.getName() + " (" + elem.getSectionName() + ")");
                    System.out.println("Center: " + String.valueOf(center) + ", DAS=" + this.calcStraightLineDAS(start, end, center));
                    System.out.println("Vertices:");
                    for (Vertex vert : elem.getVertices()) {
                        System.out.println("\t" + String.valueOf(vert) + ", DAS=" + this.calcStraightLineDAS(start, end, vert));
                    }
                    throw e1;
                }
                elemRows.put(elem, closestRow);
            }
            double minDepth = dasDepthFunc.getMinY();
            double maxDepth = dasDepthFunc.getMaxY();
            double aveDip = FaultUtils.getAngleAverage(dips);
            double estDDW = (maxDepth - minDepth) / Math.sin(Math.toRadians(aveDip));
            double aveArea = 0.0;
            for (SimulatorElement e : sectElems) {
                aveArea += e.getArea() * 1.0E-6;
            }
            double aveSpacing = Math.sqrt(aveArea /= (double)sectElems.size());
            double estNumDownDip = estDDW / aveSpacing;
            int numDepthBins = Integer.max(2, (int)Math.round(estNumDownDip / 3.0));
            if (debugSect) {
                System.out.println("\tEstimated DDW with dip=" + (float)aveDip + ": " + estDDW);
                System.out.println("\tEstimated average spacing: " + aveSpacing);
                System.out.println("\tEstimated num down dip: " + estNumDownDip);
                System.out.println("\tDepth bins: " + numDepthBins);
            }
            EvenlyDiscretizedFunc minFunc = new EvenlyDiscretizedFunc(minDepth, maxDepth, numDepthBins);
            EvenlyDiscretizedFunc maxFunc = new EvenlyDiscretizedFunc(minDepth, maxDepth, numDepthBins);
            for (int i = 0; i < minFunc.size(); ++i) {
                minFunc.set(i, Double.POSITIVE_INFINITY);
                maxFunc.set(i, Double.NEGATIVE_INFINITY);
            }
            for (Point2D pt : dasDepthFunc) {
                double das = pt.getX();
                double depth = pt.getY();
                int ind = minFunc.getClosestXIndex(depth);
                minFunc.set(ind, Math.min(minFunc.getY(ind), das));
                maxFunc.set(ind, Math.max(maxFunc.getY(ind), das));
            }
            boolean hasNonFinite = false;
            for (int i = 0; i < minFunc.size(); ++i) {
                hasNonFinite = hasNonFinite || !Double.isFinite(minFunc.getY(i));
            }
            Preconditions.checkState((!hasNonFinite ? 1 : 0) != 0, (Object)"We have a non-finite depth bin while correcting section DAS");
            ArbitrarilyDiscretizedFunc depthMinDASFunc = new ArbitrarilyDiscretizedFunc();
            ArbitrarilyDiscretizedFunc depthMaxDASFunc = new ArbitrarilyDiscretizedFunc();
            depthMinDASFunc = new ArbitrarilyDiscretizedFunc();
            depthMaxDASFunc = new ArbitrarilyDiscretizedFunc();
            depthMinDASFunc.set(minDepth, minFunc.getY(0));
            depthMinDASFunc.set(maxDepth, minFunc.getY(minFunc.size() - 1));
            depthMaxDASFunc.set(minDepth, maxFunc.getY(0));
            depthMaxDASFunc.set(maxDepth, maxFunc.getY(maxFunc.size() - 1));
            for (SimulatorElement elem : sectElems) {
                SubSectDAS_Record rawDAS = this.elemRawDASs.get(elem);
                Vertex[] verts = elem.getVertices();
                Location[] vertLocs = new Location[verts.length];
                double[] normVertDASs = new double[vertLocs.length];
                for (int i = 0; i < vertLocs.length; ++i) {
                    double myRawDAS;
                    if (i < verts.length) {
                        vertLocs[i] = verts[i];
                        myRawDAS = rawDAS.vertDASs[i];
                    } else {
                        vertLocs[i] = elem.getCenterLocation();
                        myRawDAS = rawDAS.midDAS;
                    }
                    double depth = vertLocs[i].getDepth();
                    double myMinDAS = depthMinDASFunc.getInterpolatedY(depth);
                    double myMaxDAS = depthMaxDASFunc.getInterpolatedY(depth);
                    double dasSpan = myMaxDAS - myMinDAS;
                    normVertDASs[i] = (myRawDAS - myMinDAS) / dasSpan;
                }
                double[] interpVertDASArray = new double[normVertDASs.length];
                for (int i = 0; i < normVertDASs.length; ++i) {
                    double das;
                    double normDepth;
                    double normDAS = normVertDASs[i];
                    if (normDAS < dasXYZ.getMinX()) {
                        normDAS = dasXYZ.getMinX();
                    }
                    if (normDAS > dasXYZ.getMaxX()) {
                        normDAS = dasXYZ.getMaxX();
                    }
                    if ((normDepth = (vertLocs[i].getDepth() - minDepth) / (maxDepth - minDepth)) < dasXYZ.getMinY()) {
                        normDepth = dasXYZ.getMinY();
                    }
                    if (normDepth > dasXYZ.getMaxY()) {
                        normDepth = dasXYZ.getMaxY();
                    }
                    interpVertDASArray[i] = das = dasXYZ.bilinearInterpolation(normDAS, normDepth);
                    Preconditions.checkState(((float)das >= 0.0f && (float)das <= (float)sectLen ? 1 : 0) != 0, (String)"Bad interp das=%s, not in range [0 %s]", (Object)das, (Object)sectLen);
                }
                double interpMidDAS = StatUtils.mean((double[])interpVertDASArray);
                SubSectDAS_Record das = new SubSectDAS_Record(interpVertDASArray, interpMidDAS);
                this.elemSectDASs.put(elem, das);
            }
        }
        this.mappingsCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<SimulatorEvent, List<List<SubSectionMapping>>>(){

            public List<List<SubSectionMapping>> load(SimulatorEvent key) throws Exception {
                return RSQSimSubSectionMapper.this.loadSubSectionMappings(key);
            }
        });
    }

    private double calcStraightLineDAS(Location start, Location end, Location loc) {
        double distToStart;
        double distToLine = Math.abs(LocationUtils.distanceToLineFast(start, end, loc));
        if (distToLine > (distToStart = LocationUtils.horzDistanceFast(start, loc))) {
            Preconditions.checkState((Math.abs(distToLine - distToStart) < 0.1 ? 1 : 0) != 0, (String)"Bad triangle in straight line DAS calc. distToLine=%s, distToStart=%s", (Object)distToLine, (Object)distToStart);
            return 0.0;
        }
        double ret = Math.sqrt(distToStart * distToStart - distToLine * distToLine);
        double startEndAz = LocationUtils.azimuth(start, end);
        Location orthogonal = LocationUtils.location(start, Math.toRadians(startEndAz + 90.0), distToStart);
        double distToOrthogonal = LocationUtils.distanceToLineFast(start, orthogonal, loc);
        if (distToOrthogonal > 0.0) {
            ret = -ret;
        }
        Preconditions.checkState((boolean)Double.isFinite(ret), (String)"Non-finite straight line DAS. distToLine=%s, distToStart=%s", (Object)distToLine, (Object)distToStart);
        return ret;
    }

    public List<? extends FaultSection> getSubSections() {
        return this.subSects;
    }

    public boolean isMapped(FaultSection sect) {
        return this.sectsToElemsMap.containsKey(sect) && !this.sectsToElemsMap.get(sect).isEmpty();
    }

    public FaultSection getMappedSection(SimulatorElement element) {
        return this.elemToSectsMap.get(element);
    }

    public Collection<SimulatorElement> getElementsForSection(FaultSection sect) {
        return this.sectsToElemsMap.get(sect);
    }

    public SubSectDAS_Record getElemSubSectDAS(SimulatorElement element) {
        return this.elemSectDASs.get(element);
    }

    public void trackSlipOnSections() {
        if (this.slipElemsToSectsMap == null) {
            this.trackSlipOnSections(4.0, 8.0, 2.0);
        }
    }

    public void trackSlipOnSections(double minDepth, double maxDepth, double faultDownDipBuffer) {
        this.minSlipDepth = minDepth;
        this.maxSlipDepth = maxDepth;
        this.faultDownDipBuffer = faultDownDipBuffer;
        this.mappingsCache.invalidateAll();
        Preconditions.checkArgument((minDepth < maxDepth ? 1 : 0) != 0, (Object)"minDepth must be > maxDepth!");
        HashMap<Integer, double[]> sectDDConstraints = null;
        if (faultDownDipBuffer > 0.0) {
            sectDDConstraints = new HashMap<Integer, double[]>();
            HashMap sectDips = new HashMap();
            for (SimulatorElement elem : this.elements) {
                int sectID = elem.getSectionID() - this.minElemSectID;
                double[] minMax = (double[])sectDDConstraints.get(sectID);
                if (minMax == null) {
                    minMax = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
                    sectDDConstraints.put(sectID, minMax);
                    sectDips.put(sectID, new ArrayList());
                }
                double depth = elem.getCenterLocation().getDepth();
                minMax[0] = Math.min(minMax[0], depth);
                minMax[1] = Math.max(minMax[1], depth);
                ((List)sectDips.get(sectID)).add(elem.getFocalMechanism().getDip());
            }
            for (Integer sectID : sectDDConstraints.keySet()) {
                List dips = (List)sectDips.get(sectID);
                double aveDip = 0.0;
                for (Double dip : dips) {
                    aveDip += dip.doubleValue();
                }
                double bufferVertical = Math.sin(Math.toRadians(aveDip /= (double)dips.size())) * faultDownDipBuffer;
                double[] depthRange = (double[])sectDDConstraints.get(sectID);
                double[] depthConstraint = new double[]{depthRange[0] + bufferVertical, depthRange[1] - bufferVertical};
                sectDDConstraints.put(sectID, depthConstraint);
            }
        }
        this.slipElemsToSectsMap = new HashMap<SimulatorElement, FaultSection>();
        this.slipSectsToElemsMap = new HashMap<FaultSection, HashSet<SimulatorElement>>();
        this.sectMidDepthConstraints = new HashMap<FaultSection, double[]>();
        for (SimulatorElement simulatorElement : this.elements) {
            int sectID = simulatorElement.getSectionID() - this.minElemSectID;
            FaultSection subSect = this.subSects.get(sectID);
            double myMinDepth = minDepth;
            double myMaxDepth = maxDepth;
            if (sectDDConstraints != null) {
                double[] constr = (double[])sectDDConstraints.get(sectID);
                if (constr[0] > myMaxDepth || constr[1] < myMinDepth) {
                    myMinDepth = constr[0];
                    myMaxDepth = constr[1];
                } else {
                    myMinDepth = Math.max(myMinDepth, constr[0]);
                    myMaxDepth = Math.min(myMaxDepth, constr[1]);
                }
            }
            this.sectMidDepthConstraints.put(subSect, new double[]{myMinDepth, myMaxDepth});
            double depth = simulatorElement.getCenterLocation().getDepth();
            if (!(depth >= myMinDepth) || !(depth <= myMaxDepth)) continue;
            this.slipElemsToSectsMap.put(simulatorElement, subSect);
            HashSet<SimulatorElement> elemsForSect = this.slipSectsToElemsMap.get(subSect);
            if (elemsForSect == null) {
                elemsForSect = new HashSet();
                this.slipSectsToElemsMap.put(subSect, elemsForSect);
            }
            elemsForSect.add(simulatorElement);
        }
        for (FaultSection faultSection : this.subSects) {
            if (this.slipSectsToElemsMap.containsKey(faultSection)) continue;
            this.slipSectsToElemsMap.put(faultSection, new HashSet());
        }
    }

    public double getMinSlipDepth() {
        return this.minSlipDepth;
    }

    public double getMaxSlipDepth() {
        return this.maxSlipDepth;
    }

    public double getFaultDownDipBuffer() {
        return this.faultDownDipBuffer;
    }

    public double[] getSlipOnSectionDepthConstraints(FaultSection sect) {
        Preconditions.checkNotNull(this.sectMidDepthConstraints, (Object)"Must enable slip on section tracking first");
        return this.sectMidDepthConstraints.get(sect);
    }

    public HashSet<SimulatorElement> getSlipSectionsForSect(FaultSection sect) {
        Preconditions.checkNotNull(this.sectMidDepthConstraints, (Object)"Must enable slip on section tracking first");
        return this.slipSectsToElemsMap.get(sect);
    }

    public void setMinFractForInclusion(double minFractForInclusion) {
        this.minFractForInclusion = minFractForInclusion;
    }

    public double getMinFractForInclusion() {
        return this.minFractForInclusion;
    }

    public List<List<SubSectionMapping>> getAllSubSectionMappings(SimulatorEvent event) {
        try {
            return (List)this.mappingsCache.get((Object)event);
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    public List<List<SubSectionMapping>> getFilteredSubSectionMappings(SimulatorEvent event) {
        List<List<SubSectionMapping>> allMappings = this.getAllSubSectionMappings(event);
        if (this.minFractForInclusion == 0.0) {
            return allMappings;
        }
        ArrayList<List<SubSectionMapping>> ret = new ArrayList<List<SubSectionMapping>>();
        for (List<SubSectionMapping> bundle : allMappings) {
            ArrayList<SubSectionMapping> filtered = new ArrayList<SubSectionMapping>();
            for (SubSectionMapping mapping : bundle) {
                double fractOn = mapping.getAreaSlipped() / this.subSectAreas.get(mapping.subSect.getSectionId());
                if (!(fractOn >= this.minFractForInclusion)) continue;
                filtered.add(mapping);
            }
            if (filtered.isEmpty()) continue;
            ret.add(filtered);
        }
        return ret;
    }

    private List<List<SubSectionMapping>> loadSubSectionMappings(SimulatorEvent event) {
        ArrayList<SubSectionMapping> mappings = new ArrayList<SubSectionMapping>();
        HashMap<FaultSection, SubSectionMapping> sectMap = new HashMap<FaultSection, SubSectionMapping>();
        ArrayList<SimulatorElement> elems = event.getAllElements();
        double[] slips = event.getAllElementSlips();
        for (int i = 0; i < elems.size(); ++i) {
            SimulatorElement elem = (SimulatorElement)elems.get(i);
            Preconditions.checkNotNull((Object)elem, (Object)"Element is null??");
            double slip = slips.length > 0 ? slips[i] : Double.MIN_VALUE;
            FaultSection sect = this.elemToSectsMap.get(elem);
            Preconditions.checkNotNull((Object)sect, (String)"No section mapping for element %s with section named: %s", (int)elem.getID(), (Object)elem.getSectionName());
            SubSectionMapping mapping = (SubSectionMapping)sectMap.get(sect);
            if (mapping == null) {
                mapping = new SubSectionMapping(sect);
                sectMap.put(sect, mapping);
                mappings.add(mapping);
            }
            mapping.addSlip(elem, slip);
        }
        HashMap rupSectsBundled = Maps.newHashMap();
        for (SubSectionMapping mapping : mappings) {
            int parentID = mapping.subSect.getParentSectionId();
            ArrayList<FaultSection> sects = (ArrayList<FaultSection>)rupSectsBundled.get(parentID);
            if (sects == null) {
                sects = new ArrayList<FaultSection>();
                rupSectsBundled.put(parentID, sects);
            }
            sects.add(mapping.subSect);
        }
        List<Object> rupSectsListBundled = Lists.newArrayList();
        for (List sects : rupSectsBundled.values()) {
            Collections.sort(sects, sectIDCompare);
            rupSectsListBundled.add(sects);
        }
        HashSet<FaultSection> reversedSections = new HashSet<FaultSection>();
        if (rupSectsListBundled.size() > 1) {
            rupSectsListBundled = SimulatorFaultSystemSolution.sortRupture(this.subSects, rupSectsListBundled, this.distsCache, reversedSections);
        }
        ArrayList ret = new ArrayList();
        for (List bundle : rupSectsListBundled) {
            ArrayList<SubSectionMapping> bundleMappings = new ArrayList<SubSectionMapping>();
            for (FaultSection sect : bundle) {
                SubSectionMapping mapping = (SubSectionMapping)sectMap.get(sect);
                mapping.setReversed(reversedSections.contains(sect));
                bundleMappings.add(mapping);
            }
            ret.add(Collections.unmodifiableList(bundleMappings));
        }
        return Collections.unmodifiableList(ret);
    }

    private void debugPlotDAS(File outputDir, int parentSectID) throws IOException {
        ArrayList<FaultSection> parentSects = new ArrayList<FaultSection>();
        String parentName = null;
        for (FaultSection faultSection : this.subSects) {
            if (faultSection.getParentSectionId() != parentSectID) continue;
            parentSects.add(faultSection);
            parentName = faultSection.getParentSectionName();
        }
        Preconditions.checkState((!parentSects.isEmpty() ? 1 : 0) != 0);
        ArrayList<SimulatorElement> mappedElements = new ArrayList<SimulatorElement>();
        ArrayList<RuptureSurface> arrayList = new ArrayList<RuptureSurface>();
        ArrayList<Double> mappedIDs = new ArrayList<Double>();
        for (FaultSection sect : parentSects) {
            mappedElements.addAll((Collection)this.sectsToElemsMap.get(sect));
            arrayList.add(sect.getFaultSurface(1.0, false, false));
            for (int i = 0; i < this.sectsToElemsMap.get(sect).size(); ++i) {
                mappedIDs.add(Double.valueOf(sect.getSectionId()));
            }
        }
        CompoundSurface surfaceToOutline = new CompoundSurface(arrayList);
        double[] dasScalars = new double[mappedElements.size()];
        String prefix = "das_debug_" + parentName.replaceAll("\\W+", "");
        for (int i = 0; i < dasScalars.length; ++i) {
            dasScalars[i] = this.elemRawDASs.get(mappedElements.get((int)i)).midDAS;
        }
        CPT elemCPT = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(0.0, StatUtils.max((double[])dasScalars));
        RupturePlotGenerator.writeMapPlot(this.elements, null, null, outputDir, prefix + "_raw_das", null, null, surfaceToOutline, mappedElements, dasScalars, elemCPT, parentName + " Raw DAS", null);
        for (int i = 0; i < dasScalars.length; ++i) {
            dasScalars[i] = this.elemSectDASs.get(mappedElements.get((int)i)).midDAS;
        }
        elemCPT = elemCPT.rescale(0.0, StatUtils.max((double[])dasScalars));
        RupturePlotGenerator.writeMapPlot(this.elements, null, null, outputDir, prefix + "_mid_das", null, null, surfaceToOutline, mappedElements, dasScalars, elemCPT, parentName + " Mid DAS", null);
        dasScalars = Doubles.toArray(mappedIDs);
        elemCPT = elemCPT.rescale(StatUtils.min((double[])dasScalars), StatUtils.max((double[])dasScalars));
        RupturePlotGenerator.writeMapPlot(this.elements, null, null, outputDir, prefix + "_sect_mappings", null, null, surfaceToOutline, mappedElements, dasScalars, elemCPT, parentName + " Section Mappings", null);
    }

    public static void main(String[] args) throws IOException {
        File dir = new File("/data/kevin/simulators/catalogs/rundir2585_1myr");
        File geomFile = new File(dir, "zfault_Deepen.in");
        List<SimulatorElement> elements = RSQSimFileReader.readGeometryFile(geomFile, 11, 'S');
        List<? extends FaultSection> subSects = RSQSimUtils.getUCERF3SubSectsForComparison(FaultModels.FM3_1, DeformationModels.GEOLOGIC);
        RSQSimSubSectionMapper mapper = new RSQSimSubSectionMapper(subSects, elements, 0.2);
        mapper.debugPlotDAS(new File("/tmp"), 142);
        mapper.debugPlotDAS(new File("/tmp"), 151);
        System.exit(0);
        int maxNum = 10;
        double minMag = 6.5;
        int count = 0;
        for (RSQSimEvent event : RSQSimFileReader.getEventsIterable(dir, elements, Lists.newArrayList((Object[])new MagRangeRuptureIdentifier[]{new MagRangeRuptureIdentifier(minMag, Double.POSITIVE_INFINITY)}))) {
            List<List<SubSectionMapping>> allMappings = mapper.getAllSubSectionMappings(event);
            List<List<SubSectionMapping>> filteredMappings = mapper.getFilteredSubSectionMappings(event);
            HashSet<SubSectionMapping> allFiltered = new HashSet<SubSectionMapping>();
            for (List<SubSectionMapping> bundle : filteredMappings) {
                allFiltered.addAll(bundle);
            }
            boolean hasAll = true;
            System.out.println("Event with M=" + event.getMagnitude());
            for (List<SubSectionMapping> bundle : allMappings) {
                for (SubSectionMapping mapping : bundle) {
                    int sectID = mapping.getSubSect().getSectionId();
                    double areaSlipped = mapping.getAreaSlipped();
                    double totArea = mapper.subSectAreas.get(sectID);
                    double fract = areaSlipped / totArea;
                    System.out.println("\tSect " + sectID + ": fractSlipped = " + (float)areaSlipped + " / " + (float)totArea + " = " + (float)fract);
                    boolean included = allFiltered.contains(mapping);
                    hasAll = hasAll && included;
                    System.out.println("\t\tIncluded? " + included);
                }
            }
            System.out.println();
            if (++count != maxNum) continue;
            break;
        }
    }

    public static class SubSectDAS_Record
    extends DAS_Record {
        public final double[] vertDASs;

        public SubSectDAS_Record(double[] vertDASs, double midDAS) {
            super(midDAS, StatUtils.min((double[])vertDASs), StatUtils.max((double[])vertDASs));
            this.vertDASs = vertDASs;
        }
    }

    public class SubSectionMapping {
        private FaultSection subSect;
        private double areaSlipped;
        private double subSectArea;
        private double momentOnSect;
        private double minDAS = Double.POSITIVE_INFINITY;
        private double maxDAS = Double.NEGATIVE_INFINITY;
        private double minSlipRegionDAS = Double.POSITIVE_INFINITY;
        private double maxSlipRegionDAS = Double.NEGATIVE_INFINITY;
        private Map<SimulatorElement, Double> elemSlipsInSlipRegion;
        private double minSurfaceSlipDAS = Double.POSITIVE_INFINITY;
        private double maxSurfaceSlipDAS = Double.NEGATIVE_INFINITY;
        private boolean reversed;

        private SubSectionMapping(FaultSection subSect) {
            this.subSect = subSect;
            this.subSectArea = RSQSimSubSectionMapper.this.subSectAreas.get(subSect.getSectionId());
            if (RSQSimSubSectionMapper.this.slipSectsToElemsMap != null) {
                this.elemSlipsInSlipRegion = new HashMap<SimulatorElement, Double>();
            }
        }

        private void setReversed(boolean reversed) {
            this.reversed = reversed;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        protected void addSlip(SimulatorElement elem, double slip) {
            if (slip <= 0.0) {
                return;
            }
            double area = elem.getArea();
            Preconditions.checkState((area > 0.0 ? 1 : 0) != 0, (Object)"Zero area!");
            this.areaSlipped += area;
            this.momentOnSect += FaultMomentCalc.getMoment(area, slip);
            DAS_Record das = RSQSimSubSectionMapper.this.elemSectDASs.get(elem);
            this.minDAS = Math.min(das.startDAS, this.minDAS);
            this.maxDAS = Math.max(das.endDAS, this.maxDAS);
            if (RSQSimSubSectionMapper.this.slipSectsToElemsMap != null) {
                if (RSQSimSubSectionMapper.this.slipSectsToElemsMap.get(this.subSect).contains(elem)) {
                    this.minSlipRegionDAS = Math.min(das.startDAS, this.minSlipRegionDAS);
                    this.maxSlipRegionDAS = Math.max(das.endDAS, this.maxSlipRegionDAS);
                    this.elemSlipsInSlipRegion.put(elem, slip);
                }
                int numSurface = 0;
                for (Vertex loc : elem.getVertices()) {
                    if ((float)loc.getDepth() != 0.0f) continue;
                    ++numSurface;
                }
                if (numSurface > 1) {
                    this.minSurfaceSlipDAS = Math.min(this.minSurfaceSlipDAS, das.startDAS);
                    this.maxSurfaceSlipDAS = Math.max(this.maxSurfaceSlipDAS, das.endDAS);
                }
            }
        }

        public FaultSection getSubSect() {
            return this.subSect;
        }

        public double getAreaSlipped() {
            return this.areaSlipped;
        }

        public double getSubSectArea() {
            return this.subSectArea;
        }

        public double getMomentOnSect() {
            return this.momentOnSect;
        }

        public DAS_Record getDASforSlip(SlipAlongSectAlgorithm type) {
            Preconditions.checkState((RSQSimSubSectionMapper.this.slipElemsToSectsMap != null ? 1 : 0) != 0, (Object)"Must enable slip tracking with trackSlipOnSections(...)");
            switch (type.ordinal()) {
                case 0: {
                    return new DAS_Record(0.0, this.subSect.getFaultTrace().getTraceLength());
                }
                case 3: {
                    if (Double.isFinite(this.minSurfaceSlipDAS)) {
                        return new DAS_Record(this.minSurfaceSlipDAS, this.maxSurfaceSlipDAS);
                    }
                    return null;
                }
                case 1: {
                    if (Double.isFinite(this.minDAS)) {
                        return new DAS_Record(this.minDAS, this.maxDAS);
                    }
                    return null;
                }
                case 2: {
                    if (Double.isFinite(this.minSlipRegionDAS)) {
                        return new DAS_Record(this.minSlipRegionDAS, this.maxSlipRegionDAS);
                    }
                    return null;
                }
            }
            throw new IllegalStateException("Unsupported type: " + String.valueOf((Object)type));
        }

        public double getLengthForSlip(SlipAlongSectAlgorithm type) {
            DAS_Record record = this.getDASforSlip(type);
            if (record == null) {
                return 0.0;
            }
            return record.endDAS - record.startDAS;
        }

        public List<SimulatorElement> getSlipCalcElements(SlipAlongSectAlgorithm type) {
            return this.getSlipCalcElements(this.getDASforSlip(type));
        }

        public List<SimulatorElement> getSlipCalcElements(DAS_Record slipDAS) {
            if (slipDAS == null) {
                return null;
            }
            Preconditions.checkNotNull(RSQSimSubSectionMapper.this.slipSectsToElemsMap, (Object)"Must enable slip tracking with trackSlipOnSections(...)");
            ArrayList<SimulatorElement> elems = new ArrayList<SimulatorElement>();
            for (SimulatorElement elem : RSQSimSubSectionMapper.this.slipSectsToElemsMap.get(this.subSect)) {
                if (!slipDAS.contains(RSQSimSubSectionMapper.this.elemSectDASs.get((Object)elem).midDAS)) continue;
                elems.add(elem);
            }
            return elems;
        }

        public double getAreaForAverageSlip(SlipAlongSectAlgorithm type) {
            return this.getAreaForAverageSlip(this.getDASforSlip(type));
        }

        public double getAreaForAverageSlip(DAS_Record slipDAS) {
            List<SimulatorElement> slipElems = this.getSlipCalcElements(slipDAS);
            if (slipElems == null) {
                return 0.0;
            }
            double totArea = 0.0;
            for (SimulatorElement elem : slipElems) {
                totArea += elem.getArea();
            }
            return totArea;
        }

        public double getAverageSlip(SlipAlongSectAlgorithm type) {
            return this.getAverageSlip(this.getDASforSlip(type));
        }

        public double getAverageSlip(DAS_Record slipDAS) {
            List<SimulatorElement> slipElems = this.getSlipCalcElements(slipDAS);
            if (slipElems == null || slipElems.isEmpty()) {
                return 0.0;
            }
            double areaWeightedSlipInSlipRegion = 0.0;
            double totArea = 0.0;
            for (SimulatorElement elem : slipElems) {
                double area = elem.getArea();
                totArea += area;
                if (!this.elemSlipsInSlipRegion.containsKey(elem)) continue;
                areaWeightedSlipInSlipRegion += area * this.elemSlipsInSlipRegion.get(elem);
            }
            Preconditions.checkState((totArea > 0.0 ? 1 : 0) != 0);
            return areaWeightedSlipInSlipRegion / totArea;
        }
    }

    public static enum SlipAlongSectAlgorithm {
        MID_SEIS_FULL_SUBSECTION_LEN("Full Mapped Subsection Length", "Average slip in the mid-seismogenic zone across the whole length of each mapped subsection"),
        MID_SEIS_SLIPPED_LEN("Full Slipped Length", "Average slip in the mid-seismogenic zone across the section of fault that slipped (regardless of if that slip was in the mid-seismgenic zone or not)"),
        MID_SEIS_MID_SLIPPED_LEN("Mid-Seismogenic Slipped Length", "Average slip in the mid-seismogenic zone across the section of fault that slipped in that mid-seismogenic zone (including any holes with no slip)"),
        MID_SEIS_SURF_SLIP_LEN("Surface Slipped Length", "Average slip in the mid-seismogenic zone across the section of fault that had surface slip");

        private String name;
        private String description;

        private SlipAlongSectAlgorithm(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String toString() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class DAS_Record {
        public final double midDAS;
        public final double startDAS;
        public final double endDAS;

        public DAS_Record(double startDAS, double endDAS) {
            this(0.5 * (startDAS + endDAS), startDAS, endDAS);
        }

        public DAS_Record(double midDAS, double startDAS, double endDAS) {
            Preconditions.checkState((endDAS >= startDAS && midDAS >= startDAS && midDAS <= endDAS ? 1 : 0) != 0, (String)"Bad DAS: mid=%s, start=%s, end=%s", (Object)midDAS, (Object)startDAS, (Object)endDAS);
            this.midDAS = midDAS;
            this.startDAS = startDAS;
            this.endDAS = endDAS;
        }

        public DAS_Record getReversed(double totalLen) {
            Preconditions.checkState(((float)this.endDAS <= (float)totalLen ? 1 : 0) != 0);
            return new DAS_Record(totalLen - this.midDAS, totalLen - this.endDAS, totalLen - this.startDAS);
        }

        public boolean contains(double das) {
            return das >= this.startDAS && das <= this.endDAS;
        }
    }
}

