/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.writers;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.simulators.RectangularElement;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.Vertex;

public class EQSimv06FileWriter {
    static final String GEOM_FILE_SIG = "EQSim_Input_Geometry_2";
    static final int GEOM_FILE_SPEC_LEVEL = 4;
    private static final DateFormat df = new SimpleDateFormat("MMM d, yyyy");

    public static String getCurDateString() {
        return df.format(new Date());
    }

    public static void writeGeometryFile(List<SimulatorElement> rectElementsList, File outputFile, List<String> infoLines, String titleLine, String author, String date) throws IOException {
        FileWriter efw = new FileWriter(outputFile);
        efw.write("101 EQSim_Input_Geometry_2 4\n");
        if (titleLine != null) {
            efw.write("111 " + titleLine + "\n");
        }
        if (author != null) {
            efw.write("112 " + author + "\n");
        }
        if (date != null) {
            efw.write("113 " + date + "\n");
        }
        if (infoLines != null) {
            for (int i = 0; i < infoLines.size(); ++i) {
                efw.write("110 " + infoLines.get(i) + "\n");
            }
        }
        String fullPath = "org/opensha/sha/simulators/parsers/eqsim_docs/Sample_File_Headers/Sample_Header_Input_Geometry.txt";
        ArrayList<String> lines = null;
        try {
            lines = FileUtils.loadJarFile(fullPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int l = 0; l < lines.size(); ++l) {
            StringTokenizer tok;
            int kindOfLine;
            String line = ((String)lines.get(l)).trim();
            if (line.isEmpty() || (kindOfLine = Integer.parseInt((tok = new StringTokenizer(line)).nextToken())) != 120 && kindOfLine != 121 && kindOfLine != 103) continue;
            efw.write(line + "\n");
        }
        ArrayList sectionNamesList = Lists.newArrayList();
        String prevName = null;
        ArrayList vertexList = Lists.newArrayList();
        ArrayList vertexListForSections = Lists.newArrayList();
        ArrayList vertexListForSection = null;
        ArrayList rectElementsListForSections = Lists.newArrayList();
        List rectElementsListForSection = null;
        for (SimulatorElement elem : rectElementsList) {
            String sectName = elem.getName();
            if (!sectName.equals(prevName)) {
                sectionNamesList.add(sectName);
                prevName = sectName;
                vertexListForSection = Lists.newArrayList();
                rectElementsListForSection = Lists.newArrayList();
                rectElementsListForSections.add(rectElementsListForSection);
                vertexListForSection = Lists.newArrayList();
                vertexListForSections.add(vertexListForSection);
            }
            rectElementsListForSection.add(elem);
            for (Vertex v : elem.getVertices()) {
                vertexList.add(v);
                vertexListForSection.add(v);
            }
        }
        String coord_sys = "0";
        efw.write("200 " + sectionNamesList.size() + " " + vertexList.size() + " 0 " + rectElementsList.size() + " " + EQSimv06FileWriter.getMinMaxFileString(vertexList, false) + " " + coord_sys + "\n");
        for (int i = 0; i < sectionNamesList.size(); ++i) {
            List vertListForSect = (List)vertexListForSections.get(i);
            List rectElemForSect = (List)rectElementsListForSections.get(i);
            int fault_id = ((SimulatorElement)rectElemForSect.get(0)).getFaultID();
            Object fault_id_str = fault_id >= 0 ? "" + fault_id : "NA";
            efw.write("201 " + (i + 1) + " " + (String)sectionNamesList.get(i) + " " + vertListForSect.size() + " 0 " + rectElemForSect.size() + " " + EQSimv06FileWriter.getMinMaxFileString(vertListForSect, true) + " " + (String)fault_id_str + "\n");
            for (int v = 0; v < vertListForSect.size(); ++v) {
                Vertex vert = (Vertex)vertListForSect.get(v);
                efw.write("202 " + vert.getID() + " " + (float)vert.getLatitude() + " " + (float)vert.getLongitude() + " " + (float)(vert.getDepth() * -1000.0) + " " + (float)vert.getDAS() * 1000.0f + " " + vert.getTraceFlag() + "\n");
            }
            for (int e = 0; e < rectElemForSect.size(); ++e) {
                RectangularElement elem = (RectangularElement)rectElemForSect.get(e);
                Vertex[] vert = elem.getVertices();
                FocalMechanism focalMech = elem.getFocalMechanism();
                efw.write("204 " + elem.getID() + " " + vert[0].getID() + " " + vert[1].getID() + " " + vert[2].getID() + " " + vert[3].getID() + " " + (float)focalMech.getRake() + " " + (float)(elem.getSlipRate() / 3.1536E7) + " " + (float)elem.getAseisFactor() + " " + (float)focalMech.getStrike() + " " + (float)focalMech.getDip() + " " + elem.getPerfectInt() + "\n");
            }
        }
        efw.write("999 End\n");
        efw.close();
    }

    private static String getMinMaxFileString(List<Vertex> vertexList, boolean includeDAS) {
        double minLat = Double.MAX_VALUE;
        double maxLat = -1.7976931348623157E308;
        double minLon = Double.MAX_VALUE;
        double maxLon = -1.7976931348623157E308;
        double minDep = Double.MAX_VALUE;
        double maxDep = -1.7976931348623157E308;
        double minDAS = Double.MAX_VALUE;
        double maxDAS = -1.7976931348623157E308;
        for (Vertex vertex : vertexList) {
            if (vertex.getLatitude() < minLat) {
                minLat = vertex.getLatitude();
            }
            if (vertex.getLongitude() < minLon) {
                minLon = vertex.getLongitude();
            }
            if (vertex.getDepth() < minDep) {
                minDep = vertex.getDepth();
            }
            if (vertex.getDAS() < minDAS) {
                minDAS = vertex.getDAS();
            }
            if (vertex.getLatitude() > maxLat) {
                maxLat = vertex.getLatitude();
            }
            if (vertex.getLongitude() > maxLon) {
                maxLon = vertex.getLongitude();
            }
            if (vertex.getDepth() > maxDep) {
                maxDep = vertex.getDepth();
            }
            if (!(vertex.getDAS() > maxDAS)) continue;
            maxDAS = vertex.getDAS();
        }
        String string = (float)minLat + " " + (float)maxLat + " " + (float)minLon + " " + (float)maxLon + " " + (float)maxDep * -1000.0f + " " + (float)minDep * -1000.0f;
        if (includeDAS) {
            string = string + " " + (float)minDAS * 1000.0f + " " + (float)maxDAS * 1000.0f;
        }
        return string;
    }

    public static void filterEventFileByMag(File inputFile, File outputFile, double minMag) throws IOException {
        FileWriter fw = new FileWriter(outputFile);
        BufferedReader buffRead = new BufferedReader(new FileReader(inputFile));
        boolean skip = false;
        String line = buffRead.readLine();
        while (line != null) {
            if ((line = line.trim()).startsWith("200 ")) {
                String magStr = line.split(" ")[2];
                skip = magStr.toLowerCase().contains("inf") || Double.parseDouble(magStr) < minMag;
            } else if (!line.startsWith("2")) {
                skip = false;
            }
            if (!skip) {
                fw.write(line + "\n");
            }
            line = buffRead.readLine();
        }
        fw.close();
        buffRead.close();
    }

    public static void main(String[] args) throws IOException {
        File inputFile = new File("/home/kevin/Simulators/eqs.ALLCAL2_RSQSim_sigma0.5-5_b=0.015.long.barall");
        File outputFile = new File("/home/kevin/Simulators/eqs.ALLCAL2_RSQSim_sigma0.5-5_b=0.015.long.barall.m7");
        EQSimv06FileWriter.filterEventFileByMag(inputFile, outputFile, 7.0);
    }
}

