/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.calc;

public class BenefitCostCalculator {
    private double EAL0;
    private double EAL1;
    private double netCost;
    private double rate;
    private double years;

    public BenefitCostCalculator() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public BenefitCostCalculator(double eal0, double eal1, double rate, double years, double cost0, double cost1) {
        this.EAL0 = eal0;
        this.EAL1 = eal1;
        this.netCost = cost1 - cost0;
        this.rate = rate / 100.0;
        this.years = years;
    }

    public BenefitCostCalculator(double eal0, double eal1, double rate, double years, double netCost) {
        this.EAL0 = eal0;
        this.EAL1 = eal1;
        this.netCost = netCost;
        this.rate = rate / 100.0;
        this.years = years;
    }

    public double computeBenefit() {
        double diff = this.EAL0 - this.EAL1;
        double numer = 1.0 - Math.exp(-(this.rate * this.years));
        double answer = diff * (numer / this.rate);
        return answer;
    }

    public double computeCost() {
        return this.netCost;
    }

    public double computeBCR() {
        return this.computeBenefit() / this.computeCost();
    }

    public static double computeBenefit(double eal0, double eal1, double rate, double years) {
        BenefitCostCalculator static_calc = new BenefitCostCalculator(eal0, eal1, rate, years, 0.0, 0.0);
        return static_calc.computeBenefit();
    }

    public static double computeCost(double cost0, double cost1) {
        return cost1 - cost0;
    }

    public static double computeBCR(double eal0, double eal1, double rate, double years, double cost0, double cost1) {
        BenefitCostCalculator static_calc = new BenefitCostCalculator(eal0, eal1, rate, years, cost0, cost1);
        return static_calc.computeBenefit() / static_calc.computeCost();
    }

    public void setNetCost(double netCost) {
        this.netCost = netCost;
    }

    public void setNetCost(double cost0, double cost1) {
        this.netCost = cost1 - cost0;
    }

    public void setInitialEAL(double eal0) {
        this.EAL0 = eal0;
    }

    public void setRetroEAL(double eal1) {
        this.EAL1 = eal1;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public void setYears(double years) {
        this.years = years;
    }

    public double getNetCost() {
        return this.netCost;
    }

    public double getInitialEAL() {
        return this.EAL0;
    }

    public double getRetroEAL() {
        return this.EAL1;
    }

    public double getRate() {
        return this.rate;
    }

    public double getYears() {
        return this.years;
    }
}

