/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.calc.parallel;

import com.google.common.base.Preconditions;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mpi.MPI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.calc.params.MagDistCutoffParam;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.AbstractEpistemicListERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.imr.AbstractIMR;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sra.calc.parallel.ThreadedEALCalc;
import org.opensha.sra.gui.portfolioeal.Asset;
import org.opensha.sra.gui.portfolioeal.CalculationExceptionHandler;
import org.opensha.sra.gui.portfolioeal.Portfolio;
import org.opensha.sra.vulnerability.VulnerabilityFetcher;

public class MPJ_EAL_Calc
extends MPJTaskCalculator
implements CalculationExceptionHandler {
    public static final String BATCH_ELEMENT_NAME = "BatchCalculation";
    private Portfolio portfolio;
    protected List<Asset> assets;
    private ArrayList<Integer> indexes = new ArrayList();
    private ArrayList<Double> eals = new ArrayList();
    protected ThreadedEALCalc calc;
    private File outputFile;

    public MPJ_EAL_Calc(CommandLine cmd, Portfolio portfolio, Element el) throws IOException, DocumentException, InvocationTargetException {
        this(cmd, portfolio, el, null);
    }

    public MPJ_EAL_Calc(CommandLine cmd, Portfolio portfolio, Element el, File outputFile) throws IOException, DocumentException, InvocationTargetException {
        super(cmd);
        this.portfolio = portfolio;
        this.assets = portfolio.getAssetList();
        System.gc();
        if (outputFile == null) {
            outputFile = new File(el.attributeValue("outputFile"));
        }
        this.outputFile = outputFile;
        int numThreads = this.getNumThreads();
        int numERFs = cmd.hasOption("mult-erfs") ? numThreads : 1;
        ERF[] erfs = new ERF[numERFs];
        for (int i = 0; i < numERFs; ++i) {
            erfs[i] = this.loadERF(el);
            erfs[i].updateForecast();
        }
        ScalarIMR[] imrs = new ScalarIMR[numThreads];
        for (int i = 0; i < imrs.length; ++i) {
            imrs[i] = (ScalarIMR)((Object)AbstractIMR.fromXMLMetadata(el.element("IMR"), null));
        }
        if (cmd.hasOption("vuln-file")) {
            File vulnFile = new File(cmd.getOptionValue("vuln-file"));
            System.out.println("trying to load vulnerabilities from: " + vulnFile.getAbsolutePath());
            VulnerabilityFetcher.getVulnerabilities(vulnFile);
            System.out.println("DONE loading vulns.");
        }
        ArbitrarilyDiscretizedFunc magThreshFunc = cmd.hasOption("dist-func") ? (ArbitrarilyDiscretizedFunc)new MagDistCutoffParam().getDefaultValue() : null;
        this.calc = new ThreadedEALCalc(this.assets, erfs, imrs, this, 200.0, magThreshFunc);
    }

    private ERF loadERF(Element root) throws InvocationTargetException {
        Element epistemicEl = root.element("ERF_Epistemic");
        if (epistemicEl != null) {
            return (ERF)AbstractEpistemicListERF.fromXMLMetadata(epistemicEl);
        }
        return AbstractERF.fromXMLMetadata(root.element("ERF"));
    }

    protected int getNumTasks() {
        return this.assets.size();
    }

    protected void calculateBatch(int[] batch) throws Exception {
        double[] results = this.calc.calculateBatch(batch);
        for (int i = 0; i < batch.length; ++i) {
            this.registerResult(batch[i], results[i]);
        }
    }

    protected synchronized void registerResult(int index, double eal) {
        this.indexes.add(index);
        this.eals.add(eal);
    }

    protected void doFinalAssembly() throws Exception {
        int[] myIndexes = new int[this.indexes.size()];
        double[] myEALs = new double[this.indexes.size()];
        for (int i = 0; i < this.indexes.size(); ++i) {
            myIndexes[i] = this.indexes.get(i);
            myEALs[i] = this.eals.get(i);
        }
        int TAG_GET_NUM = 0;
        int TAG_GET_INDEXES = 1;
        int TAG_GET_EALS = 2;
        if (this.rank == 0) {
            double[] eal_vals = new double[this.assets.size()];
            for (int i = 0; i < eal_vals.length; ++i) {
                eal_vals[i] = Double.NaN;
            }
            for (int source = 0; source < this.size; ++source) {
                double[] srcEALs;
                int[] srcIndexes;
                if (source == this.rank) {
                    srcIndexes = myIndexes;
                    srcEALs = myEALs;
                } else {
                    int[] size = new int[1];
                    MPI.COMM_WORLD.Recv((Object)size, 0, 1, MPI.INT, source, TAG_GET_NUM);
                    srcIndexes = new int[size[0]];
                    MPI.COMM_WORLD.Recv((Object)srcIndexes, 0, srcIndexes.length, MPI.INT, source, TAG_GET_INDEXES);
                    srcEALs = new double[size[0]];
                    MPI.COMM_WORLD.Recv((Object)srcEALs, 0, srcEALs.length, MPI.DOUBLE, source, TAG_GET_EALS);
                }
                for (int i = 0; i < srcIndexes.length; ++i) {
                    eal_vals[srcIndexes[i]] = srcEALs[i];
                }
            }
            for (double eal_val : eal_vals) {
                Preconditions.checkState((!Double.isNaN(eal_val) ? 1 : 0) != 0);
            }
            this.writeOutputFile(eal_vals);
        } else {
            int[] size = new int[]{this.indexes.size()};
            MPI.COMM_WORLD.Send((Object)size, 0, 1, MPI.INT, 0, TAG_GET_NUM);
            MPI.COMM_WORLD.Send((Object)myIndexes, 0, myIndexes.length, MPI.INT, 0, TAG_GET_INDEXES);
            MPI.COMM_WORLD.Send((Object)myEALs, 0, myEALs.length, MPI.DOUBLE, 0, TAG_GET_EALS);
        }
    }

    private void writeOutputFile(double[] eal_vals) throws IOException {
        FileWriter fw = new FileWriter(this.outputFile);
        double portfolioEAL = StatUtils.sum((double[])eal_vals);
        fw.write("Portfolio EAL: " + portfolioEAL + "\n");
        fw.write("\n");
        for (int i = 0; i < eal_vals.length; ++i) {
            int id = (Integer)this.assets.get(i).getParameterList().getParameter("AssetID").getValue();
            fw.write(id + "," + eal_vals[i] + "\n");
        }
        fw.close();
    }

    public static Options createOptions() {
        Options ops = MPJTaskCalculator.createOptions();
        Option vulnOp = new Option("v", "vuln-file", true, "VUL06 file");
        vulnOp.setRequired(false);
        ops.addOption(vulnOp);
        Option erfOp = new Option("e", "mult-erfs", false, "If set, a copy of the ERF will be instantiated for each thread.");
        erfOp.setRequired(false);
        ops.addOption(erfOp);
        Option distFuncOp = new Option("df", "dist-func", false, "If set, the default distance/mag function will be used instead of 200 km");
        distFuncOp.setRequired(false);
        ops.addOption(distFuncOp);
        return ops;
    }

    public static void main(String[] args) {
        args = MPJTaskCalculator.initMPJ((String[])args);
        try {
            Options options = MPJ_EAL_Calc.createOptions();
            CommandLine cmd = MPJ_EAL_Calc.parse((Options)options, (String[])args, MPJ_EAL_Calc.class);
            args = cmd.getArgs();
            if (args.length < 2 || args.length > 3) {
                System.err.println("USAGE: " + ClassUtils.getClassNameWithoutPackage(MPJ_EAL_Calc.class) + " [options] <portfolio_file> <calculation_params_file> [<output_file>]");
                MPJ_EAL_Calc.abortAndExit((int)2);
            }
            Portfolio portfolio = Portfolio.createPortfolio(new File(args[0]));
            Document doc = XMLUtils.loadDocument(new File(args[1]));
            Element root = doc.getRootElement();
            if (args.length == 2) {
                Iterator it = root.elementIterator(BATCH_ELEMENT_NAME);
                while (it.hasNext()) {
                    MPJ_EAL_Calc driver = new MPJ_EAL_Calc(cmd, portfolio, (Element)it.next());
                    driver.run();
                }
            } else {
                File outputFile = new File(args[2]);
                MPJ_EAL_Calc driver = new MPJ_EAL_Calc(cmd, portfolio, root, outputFile);
                driver.run();
            }
            MPJ_EAL_Calc.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJ_EAL_Calc.abortAndExit((Throwable)t);
        }
    }

    @Override
    public void calculationException(String errorMessage) {
        MPJ_EAL_Calc.abortAndExit((Throwable)new RuntimeException(errorMessage));
    }
}

