/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.calc.portfolioLEC;

import com.google.common.base.Preconditions;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.param.Parameter;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sra.asset.Asset;
import org.opensha.sra.asset.MonetaryHighLowValue;
import org.opensha.sra.asset.MonetaryValue;
import org.opensha.sra.asset.Portfolio;
import org.opensha.sra.asset.Value;

public abstract class AbstractPortfolioLECCalculator {
    public static final boolean D = false;
    protected static double valueCoefficientOfVariation = 0.15;
    protected static double interEventFactor = 0.25;

    protected abstract DiscretizedFunc[][] calcRuptureLECs(ScalarIMR var1, ERF var2, Portfolio var3, DiscretizedFunc var4);

    protected void calcProbabilityOfExceedanceCurve(DiscretizedFunc[][] funcs, ERF erf, DiscretizedFunc function) {
        for (int k = 0; k < function.size(); ++k) {
            double x = function.getX(k);
            double product = 1.0;
            for (int sourceID = 0; sourceID < erf.getNumSources(); ++sourceID) {
                ProbEqkSource src = erf.getSource(sourceID);
                for (int rupID = 0; rupID < src.getNumRuptures(); ++rupID) {
                    ProbEqkRupture rup = src.getRupture(rupID);
                    DiscretizedFunc normCumDist = funcs[sourceID][rupID];
                    if (normCumDist == null) continue;
                    double rupProb = rup.getProbability();
                    double normCumDistVal = normCumDist.getY(k);
                    if (Double.isNaN(normCumDistVal)) continue;
                    product *= 1.0 - rupProb * normCumDist.getY(k);
                }
            }
            function.set(x, 1.0 - product);
        }
    }

    public void calcProbabilityOfExceedanceCurve(ScalarIMR imr, ERF erf, Portfolio portfolio, DiscretizedFunc function) {
        DiscretizedFunc[][] funcs = this.calcRuptureLECs(imr, erf, portfolio, function);
        this.calcProbabilityOfExceedanceCurve(funcs, erf, function);
    }

    public void calcFrequencyOfExceedanceCurve(ScalarIMR imr, ERF erf, Portfolio portfolio, DiscretizedFunc function) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected final double getMaxSiteSourceDistance() {
        return 200.0;
    }

    protected void populateValues(Portfolio portfolio, double[] mValue, double[] betaVJs, double[] medValue, double[] hValue, double[] lValue) {
        Preconditions.checkNotNull((Object)portfolio, (Object)"portfolio can't be null");
        Preconditions.checkState((portfolio.size() > 0 ? 1 : 0) != 0, (Object)"portfolio can't be empty");
        Preconditions.checkNotNull((Object)mValue, (Object)"mValue array can't be null");
        Preconditions.checkState((mValue.length == portfolio.size() ? 1 : 0) != 0, (Object)"mValue array is of incorrect size");
        Preconditions.checkNotNull((Object)betaVJs, (Object)"betaVJs array can't be null");
        Preconditions.checkState((betaVJs.length == portfolio.size() ? 1 : 0) != 0, (Object)"betaVJs array is of incorrect size");
        Preconditions.checkNotNull((Object)medValue, (Object)"medValue array can't be null");
        Preconditions.checkState((medValue.length == portfolio.size() ? 1 : 0) != 0, (Object)"medValue array is of incorrect size");
        Preconditions.checkNotNull((Object)mValue, (Object)"mValue array can't be null");
        Preconditions.checkState((hValue.length == portfolio.size() ? 1 : 0) != 0, (Object)"hValue array is of incorrect size");
        Preconditions.checkNotNull((Object)hValue, (Object)"hValue array can't be null");
        Preconditions.checkState((lValue.length == portfolio.size() ? 1 : 0) != 0, (Object)"lValue array is of incorrect size");
        for (int i = 0; i < portfolio.size(); ++i) {
            double medianValue;
            double betaVJ;
            double lowValue;
            double highValue;
            double meanValue;
            Asset asset = (Asset)portfolio.get(i);
            Value value = asset.getValue();
            if (value instanceof MonetaryValue) {
                MonetaryValue mvalue = (MonetaryValue)asset.getValue();
                meanValue = mvalue.getValue();
                if (mvalue instanceof MonetaryHighLowValue) {
                    MonetaryHighLowValue hlmValue = (MonetaryHighLowValue)mvalue;
                    highValue = hlmValue.getHighValue();
                    lowValue = hlmValue.getLowValue();
                    betaVJ = Math.log(highValue / lowValue) / 3.864;
                    medianValue = meanValue / Math.sqrt(Math.exp(betaVJ * betaVJ));
                } else {
                    betaVJ = Math.sqrt(Math.log(1.0 + valueCoefficientOfVariation * valueCoefficientOfVariation));
                    medianValue = meanValue / Math.sqrt(Math.exp(betaVJ * betaVJ));
                    highValue = medianValue * Math.exp(betaVJ * 1.932);
                    lowValue = medianValue * Math.exp(-betaVJ * 1.932);
                }
            } else {
                throw new RuntimeException("Value must be of type MonetaryValue");
            }
            mValue[i] = meanValue;
            betaVJs[i] = betaVJ;
            medValue[i] = medianValue;
            hValue[i] = highValue;
            lValue[i] = lowValue;
        }
    }

    protected ShakingResult calcShaking(ScalarIMR imr) {
        double interSTD;
        double intraSTD;
        double mLnIML = imr.getMean();
        Parameter stdParam = imr.getParameter("Std Dev Type");
        stdParam.setValue("Total");
        double std = imr.getStdDev();
        if (stdParam.isAllowed("Intra-Event")) {
            stdParam.setValue("Intra-Event");
            intraSTD = imr.getStdDev();
            stdParam.setValue("Inter-Event");
            interSTD = imr.getStdDev();
        } else {
            interSTD = interEventFactor * std;
            intraSTD = Math.sqrt(std * std - interSTD * interSTD);
        }
        double medIML = Math.exp(mLnIML);
        return new ShakingResult(mLnIML, medIML, interSTD, intraSTD);
    }

    protected double calcMedDamage(double meanDamage, double deltaJ) {
        return meanDamage / Math.sqrt(1.0 + deltaJ * deltaJ);
    }

    protected class ShakingResult {
        protected final double mLnIML;
        protected final double medIML;
        protected final double interSTD;
        protected final double intraSTD;

        private ShakingResult(double mLnIML, double medIML, double interSTD, double intraSTD) {
            this.mLnIML = mLnIML;
            this.medIML = medIML;
            this.interSTD = interSTD;
            this.intraSTD = intraSTD;
        }
    }
}

