/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.gui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.impl.DoubleParameterEditor;
import org.opensha.commons.param.editor.impl.StringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sra.gui.LossEstimationApplication;
import org.opensha.sra.gui.components.GuiBeanAPI;
import org.opensha.sra.gui.components.StructureDescriptorBean;
import org.opensha.sra.vulnerability.AbstractVulnerability;

public class BenefitCostBean
implements GuiBeanAPI {
    public static final int CURRENT = 0;
    public static final int RETRO = 1;
    private String description = "";
    private double discountRate = 0.0;
    private double designLife = 0.0;
    private double retroCost = 0.0;
    private static final String DESC_PARAM = "BCR Description";
    private static final String DISCOUNT_PARAM = "Discount Rate";
    private static final String DESIGN_PARAM = "Design Life";
    private static final String RC_PARAM = "Added Cost to Retrofit";
    private StructureDescriptorBean structNow = null;
    private StructureDescriptorBean structRetro = null;
    private EventListener listener = null;
    private StringParameter descParam = null;
    private DoubleParameter discRateParam = null;
    private DoubleParameter dsgnLifeParam = null;
    private DoubleParameter retroCostParam = null;
    private List<AbstractVulnerability> vms = LossEstimationApplication.fetchVulns();

    public BenefitCostBean() throws IOException {
        this.structNow = new StructureDescriptorBean("Current Construction Conditions", this.vms);
        this.structRetro = new StructureDescriptorBean("What-If Construction Conditions", this.vms);
        this.listener = new BenefitCostParameterListener();
        this.descParam = new StringParameter(DESC_PARAM, "Describe this BCR Action");
        this.descParam.addParameterChangeListener((ParameterChangeListener)this.listener);
        this.descParam.addParameterChangeFailListener((ParameterChangeFailListener)this.listener);
        this.descParam.setInfo("Describe the benefit-cost analysis being considered");
        this.discRateParam = new DoubleParameter(DISCOUNT_PARAM, 0.0, 200.0, "%");
        this.discRateParam.addParameterChangeListener((ParameterChangeListener)this.listener);
        this.discRateParam.addParameterChangeFailListener((ParameterChangeFailListener)this.listener);
        this.discRateParam.setInfo("The after-inflation annual rate at which future money is discounted to present value");
        this.dsgnLifeParam = new DoubleParameter(DESIGN_PARAM, 0.0, 1000000.0, "Years");
        this.dsgnLifeParam.addParameterChangeListener((ParameterChangeListener)this.listener);
        this.dsgnLifeParam.addParameterChangeFailListener((ParameterChangeFailListener)this.listener);
        this.dsgnLifeParam.setInfo("The number of years into the future during which reduced future losses are recognized as a benefit");
        this.retroCostParam = new DoubleParameter(RC_PARAM, 0.0, 1.0E11, "$$$");
        this.retroCostParam.setInfo("The marginal cost to build the what-if facility relative to as-is");
        this.retroCostParam.addParameterChangeListener((ParameterChangeListener)this.listener);
        this.retroCostParam.addParameterChangeFailListener((ParameterChangeFailListener)this.listener);
    }

    public String getDescription() {
        return this.description;
    }

    public double getDiscountRate() {
        return this.discountRate;
    }

    public double getDesignLife() {
        return this.designLife;
    }

    public double getRetroCost() {
        return this.retroCost;
    }

    public AbstractVulnerability getCurrentVulnModel() {
        return this.getVulnModel(0);
    }

    public Parameter getCurrentVulnParam() {
        return this.getVulnerabilityParameter(0);
    }

    public double getCurrentReplaceCost() {
        return this.getReplaceCost(0);
    }

    public AbstractVulnerability getRetroVulnModel() {
        return this.getVulnModel(1);
    }

    public Parameter getRetroVulnParam() {
        return this.getVulnerabilityParameter(1);
    }

    public double getRetroReplaceCost() {
        return this.getReplaceCost(1);
    }

    public AbstractVulnerability getVulnModel(int design) {
        if (design == 0) {
            return this.structNow.getVulnerabilityModel();
        }
        if (design == 1) {
            return this.structRetro.getVulnerabilityModel();
        }
        throw new IllegalArgumentException("The given design is not currently supported.");
    }

    public double getReplaceCost(int design) {
        if (design == 0) {
            return this.structNow.getReplaceCost();
        }
        if (design == 1) {
            return this.structRetro.getReplaceCost();
        }
        throw new IllegalArgumentException("The given design is not currently supported.");
    }

    public double getIntensityMeasurePeriod(int design) {
        if (design == 0) {
            return this.structNow.getVulnerabilityModel().getPeriod();
        }
        if (design == 1) {
            return this.structRetro.getVulnerabilityModel().getPeriod();
        }
        throw new IllegalArgumentException("The given design is not currently supported");
    }

    public DiscretizedFunc getSupportedIMLevels(int design) throws IllegalArgumentException {
        if (design == 0) {
            return this.structNow.getVulnerabilityModel().getHazardTemplate();
        }
        if (design == 1) {
            return this.structRetro.getVulnerabilityModel().getHazardTemplate();
        }
        throw new IllegalArgumentException("The given design is not currently supported");
    }

    public Parameter getVulnerabilityParameter(int design) throws IllegalArgumentException {
        if (design == 0) {
            return this.structNow.getVulnerabilityBean().getParameter();
        }
        if (design == 1) {
            return this.structNow.getVulnerabilityBean().getParameter();
        }
        throw new IllegalArgumentException("The given design is not currently supported");
    }

    @Override
    public Object getVisualization(int type) {
        if (!this.isVisualizationSupported(type)) {
            throw new IllegalArgumentException("That type of visualization is not yet supported.");
        }
        if (type == 0) {
            return this.getApplicationVisualization();
        }
        return null;
    }

    @Override
    public String getVisualizationClassName(int type) {
        if (type == 0) {
            return "javax.swing.JPanel";
        }
        return null;
    }

    @Override
    public boolean isVisualizationSupported(int type) {
        return type == 0;
    }

    private JPanel getApplicationVisualization() {
        JPanel ret = new JPanel(new GridBagLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        JSplitPane structSplit = new JSplitPane(1, true);
        structSplit.add((Component)((JComponent)this.structNow.getVisualization(0)), "left");
        structSplit.add((Component)((JComponent)this.structRetro.getVisualization(0)), "right");
        structSplit.setDividerLocation(230);
        try {
            panel.add((Component)new DoubleParameterEditor((Parameter)this.retroCostParam), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 2, 2));
            panel.add((Component)new DoubleParameterEditor((Parameter)this.discRateParam), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 2, 2));
            panel.add((Component)new DoubleParameterEditor((Parameter)this.dsgnLifeParam), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 2, 2));
            panel.add((Component)new StringParameterEditor((Parameter)this.descParam), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 2, 2));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JSplitPane paramSplit = new JSplitPane(0, structSplit, panel);
        paramSplit.setDividerLocation(250);
        ret.add((Component)paramSplit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 2, 2));
        ret.setPreferredSize(new Dimension(480, 500));
        ret.setMinimumSize(new Dimension(200, 200));
        ret.setMaximumSize(new Dimension(10000, 10000));
        ret.setSize(ret.getPreferredSize());
        return ret;
    }

    private void handleDescriptionChangeEvent(ParameterChangeEvent event) {
        this.description = (String)event.getNewValue();
    }

    private void handleDiscountChangeEvent(ParameterChangeEvent event) {
        this.discountRate = (Double)event.getNewValue();
    }

    private void handleDesignChangeEvent(ParameterChangeEvent event) {
        this.designLife = (Double)event.getNewValue();
    }

    private void handleRetroChangeEvent(ParameterChangeEvent event) {
        this.retroCost = (Double)event.getNewValue();
    }

    private class BenefitCostParameterListener
    implements ParameterChangeListener,
    ParameterChangeFailListener {
        private BenefitCostParameterListener() {
        }

        @Override
        public void parameterChange(ParameterChangeEvent event) {
            if (BenefitCostBean.DESC_PARAM.equals(event.getParameterName())) {
                BenefitCostBean.this.handleDescriptionChangeEvent(event);
            } else if (BenefitCostBean.DISCOUNT_PARAM.equals(event.getParameterName())) {
                BenefitCostBean.this.handleDiscountChangeEvent(event);
            } else if (BenefitCostBean.DESIGN_PARAM.equals(event.getParameterName())) {
                BenefitCostBean.this.handleDesignChangeEvent(event);
            } else if (BenefitCostBean.RC_PARAM.equals(event.getParameterName())) {
                BenefitCostBean.this.handleRetroChangeEvent(event);
            }
        }

        @Override
        public void parameterChangeFailed(ParameterChangeFailEvent event) {
            String message = "The given value of " + String.valueOf(event.getBadValue()) + " is out of range.";
            JOptionPane.showMessageDialog(null, message, "Failed to Change Value", 0);
        }
    }
}

