/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.gui.portfolioeal;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.util.SiteTranslator;
import org.opensha.sra.calc.EALCalculator;
import org.opensha.sra.gui.portfolioeal.CalculationExceptionHandler;
import org.opensha.sra.gui.portfolioeal.ParameterParser;
import org.opensha.sra.vulnerability.Vulnerability;
import org.opensha.sra.vulnerability.VulnerabilityFetcher;

public class Asset
implements Cloneable {
    private ParameterList paramList;
    private String errorMessage = "";
    private double EAL;
    private Site assetSite;
    private HazardCurveCalculator calc;
    private boolean calculationDone = false;
    private ArbitrarilyDiscretizedFunc hazFunction;
    private SiteTranslator trans = new SiteTranslator();

    public Asset(String asset) {
        String[] parameters = asset.split(",");
        this.paramList = new ParameterList();
        this.initParameterMap(parameters);
        this.EAL = 0.0;
    }

    private void initParameterMap(String[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            this.paramList.addParameter(this.createParameter(parameters[i]));
        }
    }

    private void startCalcProgressBar() {
    }

    public void setAssetParameters(String[] assetList) {
        ParameterList list = this.getParameterList();
        ListIterator<Parameter<?>> iter = list.getParametersIterator();
        Integer i = 0;
        Object val = null;
        while (iter.hasNext()) {
            Parameter<?> param = iter.next();
            if (param.getType().equals("IntegerParameter")) {
                val = Integer.parseInt(assetList[i]);
            } else if (param.getType().equals("StringParameter")) {
                val = assetList[i];
            } else if (param.getType().equals("DoubleParameter")) {
                val = Double.parseDouble(assetList[i]);
            }
            param.setValue(val);
            Integer n = i;
            i = i + 1;
        }
    }

    private AbstractParameter createParameter(String paramName) {
        paramName = paramName.trim();
        AbstractParameter param = null;
        ParameterParser parameterParser = ParameterParser.getParameterParser();
        Class<?> c = null;
        try {
            String className = "org.opensha.commons.param.impl." + parameterParser.getParameterType(paramName);
            c = Class.forName(className);
            Class[] paramTypes = new Class[]{String.class};
            Constructor<?> cons = c.getConstructor(paramTypes);
            param = (AbstractParameter)cons.newInstance(paramName);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Parameter type " + paramName + " in file not recognized!", "Error", 0);
        }
        return param;
    }

    public void siteSetup(Site site) {
        if (this.getParameterList().containsParameter("SiteName")) {
            site.setName((String)this.getParameterList().getParameter("SiteName").getValue());
        }
        site.setLocation(this.getLocation());
        this.assetSite = (Site)site.clone();
        double vs30 = (Double)this.getParameterList().getParameter("Vs30").getValue();
        SiteDataValue<Double> vs30val = new SiteDataValue<Double>("Vs30", null, vs30);
        ListIterator<Parameter<?>> it = this.assetSite.getParametersIterator();
        while (it.hasNext()) {
            this.trans.setParameterValue((Parameter)it.next(), vs30val);
        }
    }

    public Location getLocation() {
        return new Location((Double)this.getParameterList().getParameter("Lat").getValue(), (Double)this.paramList.getParameter("Lon").getValue());
    }

    public Vulnerability getVulnModel() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String vulnName = this.getVulnModelName();
        return VulnerabilityFetcher.getVulnerabilities().get(vulnName);
    }

    public String getVulnModelName() {
        return this.paramList.getParameter(String.class, "VulnModel").getValue();
    }

    private DiscretizedFunc resetHazardXValues(DiscretizedFunc hazFunction, Vulnerability vulnModel) {
        DiscretizedFunc tempFunc = hazFunction.deepClone();
        Preconditions.checkState((tempFunc.size() == hazFunction.size() ? 1 : 0) != 0);
        hazFunction = new ArbitrarilyDiscretizedFunc();
        double[] imlvals = vulnModel.getIMLValues();
        Preconditions.checkState((imlvals.length == tempFunc.size() ? 1 : 0) != 0, (Object)("IML val length inconsistant: " + imlvals.length + " != " + tempFunc.size()));
        for (int i = 0; i < tempFunc.size(); ++i) {
            hazFunction.set(imlvals[i], tempFunc.getY(i));
        }
        return hazFunction;
    }

    public double calculateEAL(ScalarIMR imr, double distance, Site site, BaseERF erf, CalculationExceptionHandler controller) {
        return this.calculateEAL(imr, distance, null, site, erf, controller);
    }

    public double calculateEAL(ScalarIMR imr, double distance, ArbitrarilyDiscretizedFunc magThreshFunc, Site site, BaseERF erf, CalculationExceptionHandler controller) {
        double[] imls;
        Vulnerability vulnModel;
        ArbitrarilyDiscretizedFunc annualizedRates;
        BaseERF forecast;
        boolean error;
        Site newSite;
        block15: {
            this.siteSetup(site);
            newSite = this.getSite();
            error = false;
            this.errorMessage = "";
            this.hazFunction = new ArbitrarilyDiscretizedFunc();
            try {
                this.calc = new HazardCurveCalculator();
                this.calc.setTrackProgress(true);
                this.wait(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.startCalcProgressBar();
            forecast = null;
            annualizedRates = null;
            vulnModel = null;
            try {
                vulnModel = this.getVulnModel();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMessage = this.errorMessage + e.getMessage();
                error = true;
            }
            Preconditions.checkNotNull((Object)vulnModel, (Object)("Vulnerability model '" + this.getVulnModelName() + "' is null!"));
            String imt = vulnModel.getIMT();
            imls = vulnModel.getIMLValues();
            try {
                imr.setIntensityMeasure(imt);
                if (imt.equals("SA")) {
                    SA_Param.setPeriodInSA_Param(imr.getIntensityMeasure(), vulnModel.getPeriod());
                }
            }
            catch (ParameterException e) {
                e.printStackTrace();
                if (controller == null) break block15;
                controller.calculationException(e.getMessage());
            }
        }
        for (int i = 0; i < imls.length; ++i) {
            this.hazFunction.set(Math.log(imls[i]), 1.0);
        }
        Preconditions.checkState((imls.length == this.hazFunction.size() ? 1 : 0) != 0);
        try {
            if (magThreshFunc != null) {
                this.calc.setMagDistCutoffFunc(magThreshFunc);
            } else {
                this.calc.setMaxSourceDistance(distance);
            }
            forecast = erf;
            this.hazFunction = (ArbitrarilyDiscretizedFunc)this.calc.getHazardCurve((DiscretizedFunc)this.hazFunction, newSite, imr, (ERF)forecast);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMessage = this.errorMessage + e.getMessage();
            error = true;
        }
        Preconditions.checkState((imls.length == this.hazFunction.size() ? 1 : 0) != 0);
        this.hazFunction = (ArbitrarilyDiscretizedFunc)this.resetHazardXValues(this.hazFunction, vulnModel);
        try {
            annualizedRates = (ArbitrarilyDiscretizedFunc)this.calc.getAnnualizedRates(this.hazFunction, forecast.getTimeSpan().getDuration());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMessage = this.errorMessage + e.getMessage();
            error = true;
        }
        if (error && controller != null) {
            controller.calculationException(this.errorMessage);
        }
        EALCalculator currentCalc = new EALCalculator((DiscretizedFunc)annualizedRates, (DiscretizedFunc)vulnModel.getVulnerabilityFunc(), this.getValue());
        this.EAL = currentCalc.computeEAL();
        this.calculationDone();
        this.calc = null;
        return this.EAL;
    }

    public double[][] calculateExpectedLossPerRup(ScalarIMR imr, double maxDistance, DiscretizedFunc magThreshFunc, Site site, ERF erf, CalculationExceptionHandler controller) {
        double[] imls;
        Vulnerability vulnModel;
        ArbitrarilyDiscretizedFunc hazFunction;
        ArbitrarilyDiscretizedFunc logHazFunction;
        boolean error;
        Site newSite;
        block12: {
            this.siteSetup(site);
            newSite = this.getSite();
            error = false;
            this.errorMessage = "";
            logHazFunction = new ArbitrarilyDiscretizedFunc();
            hazFunction = new ArbitrarilyDiscretizedFunc();
            try {
                this.calc = new HazardCurveCalculator();
                this.wait(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.startCalcProgressBar();
            vulnModel = null;
            try {
                vulnModel = this.getVulnModel();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMessage = this.errorMessage + e.getMessage();
                error = true;
            }
            Preconditions.checkNotNull((Object)vulnModel, (Object)("Vulnerability model '" + this.getVulnModelName() + "' is null!"));
            String imt = vulnModel.getIMT();
            imls = vulnModel.getIMLValues();
            try {
                imr.setIntensityMeasure(imt);
                if (imt.equals("SA")) {
                    SA_Param.setPeriodInSA_Param(imr.getIntensityMeasure(), vulnModel.getPeriod());
                }
            }
            catch (ParameterException e) {
                System.out.println("imt: " + imt);
                System.out.println("Vuln class: " + vulnModel.getClass().getName());
                System.out.println("Vuln name: " + vulnModel.getName());
                e.printStackTrace();
                if (controller == null) break block12;
                controller.calculationException(e.getMessage());
            }
        }
        for (int i = 0; i < imls.length; ++i) {
            logHazFunction.set(Math.log(imls[i]), 1.0);
            hazFunction.set(imls[i], 1.0);
        }
        Preconditions.checkState((imls.length == hazFunction.size() ? 1 : 0) != 0);
        double[][] results = new double[erf.getNumSources()][];
        this.EAL = 0.0;
        double duration = erf.getTimeSpan().getDuration();
        EALCalculator currentCalc = new EALCalculator((DiscretizedFunc)hazFunction, (DiscretizedFunc)vulnModel.getVulnerabilityFunc(), this.getValue());
        for (int sourceID = 0; sourceID < erf.getNumSources(); ++sourceID) {
            ProbEqkSource source = erf.getSource(sourceID);
            double distance = source.getMinDistance(site);
            if (magThreshFunc != null ? distance > magThreshFunc.getMaxX() : distance > maxDistance) continue;
            double magThresh = magThreshFunc == null ? Double.NaN : magThreshFunc.getInterpolatedY(distance);
            results[sourceID] = new double[source.getNumRuptures()];
            for (int rupID = 0; rupID < source.getNumRuptures(); ++rupID) {
                double rupEL;
                ProbEqkRupture rupture = source.getRupture(rupID);
                if (magThreshFunc != null && rupture.getMag() < magThresh) continue;
                this.calc.getHazardCurve((DiscretizedFunc)logHazFunction, newSite, imr, rupture);
                Preconditions.checkState((imls.length == logHazFunction.size() ? 1 : 0) != 0);
                for (int i = 0; i < logHazFunction.size(); ++i) {
                    hazFunction.set(i, logHazFunction.getY(i));
                }
                if (error && controller != null) {
                    controller.calculationException(this.errorMessage);
                }
                currentCalc.setMAFE(hazFunction);
                results[sourceID][rupID] = rupEL = currentCalc.computeEAL();
                this.EAL += rupEL * rupture.getMeanAnnualRate(duration);
            }
        }
        this.calculationDone();
        return results;
    }

    public double getValue() {
        return (Double)this.paramList.getParameter("Value").getValue();
    }

    private void calculationDone() {
        this.calculationDone = true;
    }

    public boolean isCalculationDone() {
        return this.calculationDone;
    }

    public int getTotalRuptures() {
        return this.calc.getTotRuptures();
    }

    public int getCurrentRuptures() {
        return this.calc.getCurrRuptures();
    }

    public ParameterList getParameterList() {
        return this.paramList;
    }

    public double getAssetEAL() {
        return this.EAL;
    }

    private void setParamList(ParameterList paramList) {
        this.paramList = paramList;
    }

    public Site getSite() {
        return this.assetSite;
    }

    public ArbitrarilyDiscretizedFunc getHazardFunction() {
        return this.hazFunction;
    }

    public Asset clone() throws CloneNotSupportedException {
        Asset asset = (Asset)super.clone();
        asset.setParamList((ParameterList)this.getParameterList().clone());
        return asset;
    }
}

