/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.gui.portfolioeal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.Site;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sra.gui.portfolioeal.Asset;
import org.opensha.sra.gui.portfolioeal.CalculationExceptionHandler;
import org.opensha.sra.gui.portfolioeal.PortfolioParser;

public class Portfolio {
    private ArrayList<Asset> assetList = new ArrayList();
    private File portfolioFile;
    private double EAL;

    private Portfolio(File portfolioFile) {
        this.portfolioFile = portfolioFile;
        this.EAL = 0.0;
    }

    public static Portfolio createPortfolio(File portfolioFile) throws IOException {
        Portfolio portfolio = new Portfolio(portfolioFile);
        portfolio.createAssets();
        return portfolio;
    }

    private void createAssets() throws IOException {
        PortfolioParser parser = new PortfolioParser();
        this.assetList = parser.scanFile(this.portfolioFile);
    }

    public double calculatePortfolioEAL(ScalarIMR imr, double maxSourceDistance, Site site, BaseERF erf, CalculationExceptionHandler controller) {
        Object toWrite = "";
        try {
            BufferedWriter out = null;
            for (Asset asset : this.assetList) {
                this.EAL += asset.calculateEAL(imr, maxSourceDistance, site, erf, controller);
                toWrite = (String)toWrite + String.valueOf(asset.getParameterList().getParameter("Lat").getValue());
                toWrite = (String)toWrite + ", ";
                toWrite = (String)toWrite + String.valueOf(asset.getParameterList().getParameter("Lon").getValue());
                toWrite = (String)toWrite + ", ";
                toWrite = (String)toWrite + asset.getAssetEAL();
                toWrite = (String)toWrite + "\n";
                out = new BufferedWriter(new FileWriter(new File("EAL.csv")));
            }
            out.write((String)toWrite, 0, ((String)toWrite).length());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.EAL;
    }

    public void setPortfolioFile(File portfolioFile) {
        this.assetList.clear();
        this.portfolioFile = portfolioFile;
        this.EAL = 0.0;
    }

    public ArrayList<Asset> getAssetList() {
        return this.assetList;
    }

    public ArrayList<Site> getSiteList() {
        ArrayList<Site> siteList = new ArrayList<Site>();
        for (Asset asset : this.assetList) {
            siteList.add(asset.getSite());
        }
        return siteList;
    }

    public File getPortfolioFile() {
        return this.portfolioFile;
    }

    public static void main(String[] args) throws IOException {
        Portfolio.createPortfolio(new File("/home/kevin/OpenSHA/UCERF3/eal/Porter-09-Feb-2020-CEA-100-pct-procy-portfolio.csv"));
    }
}

