/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.riskmaps;

import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Arrays;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.xyz.EvenlyDiscrXYZ_DataSet;
import org.opensha.sha.calc.hazardMap.BinaryHazardCurveReader;
import org.opensha.sra.calc.LossCurveCalculator;
import org.opensha.sra.riskmaps.FragilityCurveReader;
import org.opensha.sra.riskmaps.func.DiscreteInterpExterpFunc;

public class NSHMPRiskMapCalc {
    public static final double gridSpacing = 0.05;
    public static final double minLat = 24.6;
    public static final double minLon = -125.0;
    public static final int ncols = 1201;
    public static final int nrows = 509;
    public static boolean interp = true;
    private BinaryHazardCurveReader curveReader;
    private DiscreteInterpExterpFunc fragilityCurve;
    private static long interpTime = 0L;
    private static long calcTime = 0L;
    private static long fetchTime = 0L;
    private ArrayList<Double> testVals = null;

    public NSHMPRiskMapCalc(BinaryHazardCurveReader curveReader, DiscreteInterpExterpFunc fragilityCurve) {
        this.curveReader = curveReader;
        this.fragilityCurve = fragilityCurve;
    }

    public static ArbitrarilyDiscretizedFunc[] getInterpolatedCurvesFast(ArbitrarilyDiscretizedFunc hazCurve, ArbitrarilyDiscretizedFunc fragilityCurve) {
        double[] xVals;
        long start = System.currentTimeMillis();
        DiscreteInterpExterpFunc interpHazFunc = DiscreteInterpExterpFunc.fromArbDistFunc(hazCurve);
        DiscreteInterpExterpFunc interpFragFunc = DiscreteInterpExterpFunc.fromArbDistFunc(fragilityCurve);
        ArbitrarilyDiscretizedFunc interpHazCurve = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc interpFragCurve = new ArbitrarilyDiscretizedFunc();
        for (double x : xVals = NSHMPRiskMapCalc.boundedMerge(hazCurve.getXVals(), fragilityCurve.getXVals())) {
            interpHazCurve.set(x, interpHazFunc.valueOf(x));
            interpFragCurve.set(x, interpFragFunc.valueOf(x));
        }
        ArbitrarilyDiscretizedFunc[] result = new ArbitrarilyDiscretizedFunc[]{interpHazCurve, interpFragCurve};
        long end = System.currentTimeMillis();
        interpTime += end - start;
        return result;
    }

    private double[] getXVals(ArbitrarilyDiscretizedFunc hazCurve, ArbitrarilyDiscretizedFunc fragilityCurve) {
        return this.getXVals(DiscreteInterpExterpFunc.fromArbDistFunc(hazCurve), DiscreteInterpExterpFunc.fromArbDistFunc(fragilityCurve));
    }

    private double[] getXVals(DiscreteInterpExterpFunc hazCurve, DiscreteInterpExterpFunc fragilityCurve) {
        return NSHMPRiskMapCalc.boundedMerge(hazCurve.getXVals(), fragilityCurve.getXVals());
    }

    private ArbitrarilyDiscretizedFunc interp(ArbitrarilyDiscretizedFunc func, double[] xvals) {
        DiscreteInterpExterpFunc dfunc = DiscreteInterpExterpFunc.fromArbDistFunc(func);
        dfunc = this.interp(dfunc, xvals);
        return NSHMPRiskMapCalc.getArbDist(dfunc);
    }

    private DiscreteInterpExterpFunc interp(DiscreteInterpExterpFunc func, double[] xvals) {
        long start = System.currentTimeMillis();
        double[] yvals = new double[xvals.length];
        for (int i = 0; i < xvals.length; ++i) {
            double x = xvals[i];
            yvals[i] = func.valueOf(x);
        }
        long end = System.currentTimeMillis();
        interpTime += end - start;
        return new DiscreteInterpExterpFunc(xvals, yvals);
    }

    public static DiscreteInterpExterpFunc[] getInterpolatedCurvesFast(DiscreteInterpExterpFunc hazCurve, DiscreteInterpExterpFunc fragilityCurve) {
        long start = System.currentTimeMillis();
        double[] xVals = NSHMPRiskMapCalc.boundedMerge(hazCurve.getXVals(), fragilityCurve.getXVals());
        double[] hazYVals = new double[xVals.length];
        double[] fragYVals = new double[xVals.length];
        for (int i = 0; i < xVals.length; ++i) {
            double x = xVals[i];
            hazYVals[i] = hazCurve.valueOf(x);
            fragYVals[i] = fragilityCurve.valueOf(x);
        }
        DiscreteInterpExterpFunc[] result = new DiscreteInterpExterpFunc[]{new DiscreteInterpExterpFunc(xVals, hazYVals), new DiscreteInterpExterpFunc(xVals, fragYVals)};
        long end = System.currentTimeMillis();
        interpTime += end - start;
        return result;
    }

    public static ArbitrarilyDiscretizedFunc[] getInterpolatedCurves(ArbitrarilyDiscretizedFunc hazCurve, ArbitrarilyDiscretizedFunc fragilityCurve) {
        double[] xVals;
        long start = System.currentTimeMillis();
        ArbitrarilyDiscretizedFunc interpHazCurve = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc interpFragCurve = new ArbitrarilyDiscretizedFunc();
        for (double x : xVals = NSHMPRiskMapCalc.boundedMerge(hazCurve.getXVals(), fragilityCurve.getXVals())) {
            interpHazCurve.set(x, hazCurve.getInterpExterpY_inLogYDomain(x));
            interpFragCurve.set(x, fragilityCurve.getInterpExterpY_inLogYDomain(x));
        }
        ArbitrarilyDiscretizedFunc[] result = new ArbitrarilyDiscretizedFunc[]{interpHazCurve, interpFragCurve};
        long end = System.currentTimeMillis();
        interpTime += end - start;
        return result;
    }

    private DiscreteInterpExterpFunc getNextCurve() throws Exception {
        long start = System.currentTimeMillis();
        DiscreteInterpExterpFunc hazCurve = this.curveReader.nextDiscreteCurve();
        long end = System.currentTimeMillis();
        fetchTime += end - start;
        return hazCurve;
    }

    private static void printSingleTime(String desc, long val, long total) {
        double secs = (double)val / 1000.0;
        double precent = (double)val / (double)total * 100.0;
        System.out.println(desc + ": " + secs + "s (" + precent + " %)");
    }

    private static void printTimes() {
        long total = interpTime + calcTime + fetchTime;
        NSHMPRiskMapCalc.printSingleTime("interpolate", interpTime, total);
        NSHMPRiskMapCalc.printSingleTime("calculate", calcTime, total);
        NSHMPRiskMapCalc.printSingleTime("fetch", fetchTime, total);
    }

    public EvenlyDiscrXYZ_DataSet calcRiskMap() throws Exception {
        DiscreteInterpExterpFunc hazCurve = this.getNextCurve();
        DiscreteInterpExterpFunc fragilityCurve = this.fragilityCurve;
        double[] xvals = this.getXVals(hazCurve, fragilityCurve);
        DiscreteInterpExterpFunc interpDiscreteFrag = this.interp(fragilityCurve, xvals);
        ArbitrarilyDiscretizedFunc interpFrag = NSHMPRiskMapCalc.getArbDist(interpDiscreteFrag);
        LossCurveCalculator calc = new LossCurveCalculator();
        EvenlyDiscrXYZ_DataSet result = new EvenlyDiscrXYZ_DataSet(1201, 509, -125.0, 24.6, 0.05);
        int count = 0;
        System.out.println("Starting calc!");
        while (hazCurve != null) {
            double[] loc = this.curveReader.currentLocationArray();
            if (this.testVals != null && count == 10000) break;
            if (interp) {
                hazCurve = this.interp(hazCurve, xvals);
            }
            long calcStart = System.currentTimeMillis();
            double val = calc.getLossExceedance(NSHMPRiskMapCalc.getArbDist(hazCurve), interpFrag);
            long calcEnd = System.currentTimeMillis();
            calcTime += calcEnd - calcStart;
            result.set(loc[1], loc[0], val);
            if (this.testVals != null && count < 10000) {
                this.testVals.add(val);
            }
            ++count;
            hazCurve = this.getNextCurve();
        }
        System.out.println("Calculated " + count + " sites!");
        NSHMPRiskMapCalc.printTimes();
        return result;
    }

    public static ArbitrarilyDiscretizedFunc getArbDist(DiscreteInterpExterpFunc func) {
        ArbitrarilyDiscretizedFunc afunc = new ArbitrarilyDiscretizedFunc();
        double[] xvals = func.getXVals();
        double[] yvals = func.getYVals();
        for (int i = 0; i < xvals.length; ++i) {
            afunc.set(xvals[i], yvals[i]);
        }
        return afunc;
    }

    public void setStoreTestVals() {
        this.testVals = new ArrayList();
    }

    public ArrayList<Double> getTestVals() {
        return this.testVals;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.err.println("USAGE: NSHMPRiskMapCalc <hazard curve bin file> <fragility xml file> <damage state> <outfile>");
            System.exit(2);
        }
        String curveFile = args[0];
        BinaryHazardCurveReader curveReader = new BinaryHazardCurveReader(curveFile);
        String fragFile = args[1];
        String damageState = args[2];
        DiscreteInterpExterpFunc fragilityCurve = DiscreteInterpExterpFunc.fromArbDistFunc(FragilityCurveReader.loadFunc(fragFile, damageState));
        interp = fragilityCurve.getXVals().length != 20;
        long start = System.currentTimeMillis();
        NSHMPRiskMapCalc calc = new NSHMPRiskMapCalc(curveReader, fragilityCurve);
        EvenlyDiscrXYZ_DataSet result = calc.calcRiskMap();
        long end = System.currentTimeMillis();
        System.out.println("Took " + (double)(end - start) / 1000.0 + " secs");
        String outputFile = args[3];
        result.writeXYZBinFile(outputFile);
    }

    private static double[] boundedMerge(double[] paramArrayOfDouble1, double[] paramArrayOfDouble2) {
        double d1 = Math.max(Doubles.min((double[])paramArrayOfDouble1), Doubles.min((double[])paramArrayOfDouble2));
        double d2 = Math.min(Doubles.max((double[])paramArrayOfDouble1), Doubles.max((double[])paramArrayOfDouble2));
        return NSHMPRiskMapCalc.merge(NSHMPRiskMapCalc.trim(paramArrayOfDouble1, d1, d2), NSHMPRiskMapCalc.trim(paramArrayOfDouble2, d1, d2));
    }

    private static double[] trim(double[] paramArrayOfDouble, double paramDouble1, double paramDouble2) {
        int i = 0;
        int j = paramArrayOfDouble.length;
        double[] arrayOfDouble = new double[j];
        for (int k = 0; k < j; ++k) {
            if (paramArrayOfDouble[k] < paramDouble1 || paramArrayOfDouble[k] > paramDouble2) continue;
            arrayOfDouble[i++] = paramArrayOfDouble[k];
        }
        return NSHMPRiskMapCalc.trim(arrayOfDouble, i);
    }

    private static double[] trim(double[] paramArrayOfDouble, int paramInt) {
        double[] arrayOfDouble = new double[paramInt];
        System.arraycopy(paramArrayOfDouble, 0, arrayOfDouble, 0, paramInt);
        return arrayOfDouble;
    }

    private static double[] merge(double[] vals1, double[] vals2) {
        int i = 0;
        int len1 = vals1.length;
        int len2 = vals2.length;
        int maxlen = len1 + len2;
        double[] allVals = new double[maxlen];
        int idx = 0;
        for (i = 0; i < len1; ++i) {
            boolean[] isNewVal = new boolean[]{true, true};
            double[] curVal = new double[]{vals1[i], len2 > i ? vals2[i] : Double.NaN};
            for (int j = 0; j < idx && (isNewVal[0] || isNewVal[1]); ++j) {
                isNewVal[0] = isNewVal[0] && allVals[i] != curVal[0];
                isNewVal[1] = isNewVal[1] && allVals[i] != curVal[1];
            }
            if (isNewVal[0]) {
                allVals[idx++] = curVal[0];
            }
            if (!isNewVal[1] || curVal[0] == curVal[1]) continue;
            allVals[idx++] = curVal[1];
        }
        for (i = len1; i < len2; ++i) {
            boolean isNewVal = true;
            double curVal = vals2[i];
            for (int i5 = 0; i5 < idx && isNewVal; ++i5) {
                isNewVal = isNewVal && allVals[i] != curVal;
            }
            if (!isNewVal) continue;
            allVals[idx++] = curVal;
        }
        double[] mergedVals = new double[idx];
        System.arraycopy(allVals, 0, mergedVals, 0, idx);
        Arrays.sort(mergedVals);
        return mergedVals;
    }
}

