/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.riskmaps.func;

import java.util.Arrays;
import org.opensha.sra.riskmaps.func.DiscreteSet;
import org.opensha.sra.riskmaps.func.FunctionAPI;
import org.opensha.sra.riskmaps.func.SetAPI;

public class DiscreteFunction
implements FunctionAPI {
    protected double[] xvals;
    protected double[] yvals;
    private String name;
    private static final String DEFAULT_NAME = "Discrete Function";

    public DiscreteFunction(double[] xvals, double[] yvals) {
        this(xvals, yvals, DEFAULT_NAME);
    }

    public DiscreteFunction(double[] xvals, double[] yvals, String name) {
        DiscreteFunction.sort(xvals, yvals);
        this.xvals = xvals;
        this.yvals = yvals;
        this.name = name;
    }

    @Override
    public SetAPI getDomain() {
        return new DiscreteSet(this.xvals);
    }

    @Override
    public SetAPI getRange() {
        return new DiscreteSet(this.yvals);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double valueOf(double x) {
        try {
            int idx = Arrays.binarySearch(this.xvals, x);
            return this.yvals[idx];
        }
        catch (ArrayIndexOutOfBoundsException abx) {
            IllegalArgumentException iax = new IllegalArgumentException("The value " + x + " was not in the domain of the function.");
            iax.fillInStackTrace();
            throw iax;
        }
    }

    public double[] getXVals() {
        return this.xvals;
    }

    public double[] getYVals() {
        return this.yvals;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DiscreteFunction) {
            DiscreteFunction func = (DiscreteFunction)obj;
            double[] otherX = func.getXVals();
            double[] otherY = func.getYVals();
            for (int i = 0; i < this.xvals.length; ++i) {
                try {
                    if (this.xvals[i] == otherX[i] && this.yvals[i] == otherY[i]) continue;
                    return false;
                }
                catch (ArrayIndexOutOfBoundsException abx) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String s = this.name + "\n";
        s = s + Arrays.toString(this.xvals) + "\n";
        s = s + Arrays.toString(this.yvals) + "\n";
        return s;
    }

    private static void sort(double[] paramArrayOfDouble1, double[] paramArrayOfDouble2) {
        if (paramArrayOfDouble1.length != paramArrayOfDouble2.length) {
            IllegalArgumentException localIllegalArgumentException = new IllegalArgumentException("Cannot associatively sort arrays of different lengths.");
            localIllegalArgumentException.fillInStackTrace();
            throw localIllegalArgumentException;
        }
        DiscreteFunction.sort(paramArrayOfDouble1, 0, paramArrayOfDouble1.length - 1, paramArrayOfDouble2);
    }

    private static void sort(double[] paramArrayOfDouble1, int paramInt1, int paramInt2, double[] paramArrayOfDouble2) {
        int i = paramInt1;
        int j = paramInt2;
        if (paramInt2 - paramInt1 >= 1) {
            double d = paramArrayOfDouble1[paramInt1];
            while (j > i) {
                while (paramArrayOfDouble1[i] <= d && i < paramInt2 && j > i) {
                    ++i;
                }
                while (paramArrayOfDouble1[j] > d && j >= paramInt1 && j >= i) {
                    --j;
                }
                if (j <= i) continue;
                DiscreteFunction.swap(paramArrayOfDouble1, i, j, paramArrayOfDouble2);
            }
        } else {
            return;
        }
        DiscreteFunction.swap(paramArrayOfDouble1, paramInt1, j, paramArrayOfDouble2);
        DiscreteFunction.sort(paramArrayOfDouble1, paramInt1, j - 1, paramArrayOfDouble2);
        DiscreteFunction.sort(paramArrayOfDouble1, j + 1, paramInt2, paramArrayOfDouble2);
    }

    private static void swap(double[] paramArrayOfDouble1, int paramInt1, int paramInt2, double[] paramArrayOfDouble2) {
        double d = paramArrayOfDouble1[paramInt1];
        paramArrayOfDouble1[paramInt1] = paramArrayOfDouble1[paramInt2];
        paramArrayOfDouble1[paramInt2] = d;
        d = paramArrayOfDouble2[paramInt1];
        paramArrayOfDouble2[paramInt1] = paramArrayOfDouble2[paramInt2];
        paramArrayOfDouble2[paramInt2] = d;
    }
}

