/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.riskmaps.func;

import java.awt.geom.Point2D;
import java.util.Arrays;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.sra.riskmaps.func.DiscreteFunction;
import org.opensha.sra.riskmaps.func.DiscreteSet;

public class DiscreteInterpExterpFunc
extends DiscreteFunction {
    public static final int LINEAR_LINEAR = 0;
    public static final int LINEAR_LOG = 1;
    public static final int LOG_LINEAR = 2;
    public static final int LOG_LOG = 3;
    public static final int EXTRAP_ZERO = 0;
    public static final int EXTRAP_FLATTEN = 1;
    public static final int EXTRAP_EXTEND = 2;
    public static final int EXTRAP_INFINITY = 3;
    private static final String DEFAULT_NAME = "Interpolated/Extrapolated Discrete Function";
    protected int interpType = 0;
    protected int extrapBelow = 2;
    protected int extrapAbove = 2;

    public DiscreteInterpExterpFunc(double[] xvals, double[] yvals) {
        super(xvals, yvals, DEFAULT_NAME);
    }

    public DiscreteInterpExterpFunc(double[] xvals, double[] yvals, String name) {
        super(xvals, yvals, name);
    }

    public DiscreteInterpExterpFunc(double[] xvals, double[] yvals, String name, int interpType, int extrapBelow, int extrapAbove) {
        super(xvals, yvals, name);
        if (0 <= interpType && interpType <= 3) {
            this.interpType = interpType;
        }
        if (0 <= extrapBelow && extrapBelow <= 3) {
            this.extrapBelow = extrapBelow;
        }
        if (0 <= extrapAbove && extrapAbove <= 3) {
            this.extrapAbove = extrapAbove;
        }
    }

    public void setInterpMethod(int interpType) {
        if (0 <= interpType && interpType <= 3) {
            this.interpType = interpType;
        }
    }

    public void setExtrapMethod(int extrapAbove, int extrapBelow) {
        if (0 <= extrapBelow && extrapBelow <= 3) {
            this.extrapBelow = extrapBelow;
        }
        if (0 <= extrapAbove && extrapAbove <= 3) {
            this.extrapAbove = extrapAbove;
        }
    }

    public int getInterp() {
        return this.interpType;
    }

    public int getExtrapBelow() {
        return this.extrapBelow;
    }

    public int getExtrapAbove() {
        return this.extrapAbove;
    }

    @Override
    public double valueOf(double x) {
        DiscreteSet domain = (DiscreteSet)this.getDomain();
        if (domain.contains(x)) {
            return super.valueOf(x);
        }
        if (x < domain.lowerBound()) {
            return this.extrapolate(this.xvals[1], this.xvals[0], this.yvals[1], this.yvals[0], x, this.extrapBelow);
        }
        if (x > domain.upperBound()) {
            return this.extrapolate(this.xvals[this.xvals.length - 2], this.xvals[this.xvals.length - 1], this.yvals[this.yvals.length - 2], this.yvals[this.yvals.length - 1], x, this.extrapAbove);
        }
        if (domain.lowerBound() <= x && x <= domain.upperBound()) {
            int idx = -1 * (Arrays.binarySearch(this.xvals, x) + 1) - 1;
            return this.interpolate(this.xvals[idx], this.xvals[idx + 1], this.yvals[idx], this.yvals[idx + 1], x);
        }
        return Double.NaN;
    }

    public double[] valueOf(double[] x) {
        double[] y = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = this.valueOf(x[i]);
        }
        return y;
    }

    private double interpolate(double x1, double x2, double y1, double y2, double x) {
        if (this.interpType == 0) {
            return DiscreteInterpExterpFunc.linearInterp(x1, x2, y1, y2, x);
        }
        if (this.interpType == 1) {
            return Math.exp(DiscreteInterpExterpFunc.linearInterp(x1, x2, Math.log(y1), Math.log(y2), x));
        }
        if (this.interpType == 2) {
            return DiscreteInterpExterpFunc.linearInterp(Math.log(x1), Math.log(x2), y1, y2, Math.log(x));
        }
        if (this.interpType == 3) {
            return Math.exp(DiscreteInterpExterpFunc.linearInterp(Math.log(x1), Math.log(x2), Math.log(y1), Math.log(y2), Math.log(x)));
        }
        IllegalStateException isx = new IllegalStateException("Unknown interpolation method: " + this.interpType);
        isx.fillInStackTrace();
        throw isx;
    }

    private double extrapolate(double x1, double x2, double y1, double y2, double x, int extrapType) {
        if (extrapType == 0) {
            return 0.0;
        }
        if (extrapType == 1) {
            if (x < this.getDomain().lowerBound()) {
                return this.yvals[0];
            }
            return this.yvals[this.yvals.length - 1];
        }
        if (extrapType == 2) {
            if (this.interpType == 0) {
                return DiscreteInterpExterpFunc.linearExtrap(x1, x2, y1, y2, x);
            }
            if (this.interpType == 2) {
                return DiscreteInterpExterpFunc.linearExtrap(Math.log(x1), Math.log(x2), y1, y2, Math.log(x));
            }
            if (this.interpType == 1) {
                return Math.exp(DiscreteInterpExterpFunc.linearExtrap(x1, x2, Math.log(y1), Math.log(y2), x));
            }
            if (this.interpType == 3) {
                return Math.exp(DiscreteInterpExterpFunc.linearExtrap(Math.log(x1), Math.log(x2), Math.log(y1), Math.log(y2), Math.log(x)));
            }
        } else if (extrapType == 3) {
            double slope;
            if (this.interpType == 2 || this.interpType == 3) {
                x1 = Math.log(x1);
                x2 = Math.log(x2);
            }
            if (this.interpType == 1 || this.interpType == 3) {
                y1 = Math.log(y1);
                y2 = Math.log(y2);
            }
            if ((slope = (y2 - y1) / (x2 - x1)) < 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (slope > 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return this.extrapolate(x1, x2, y1, y2, x, 1);
        }
        IllegalStateException isx = new IllegalStateException("Unknown extrapolation method: " + extrapType);
        isx.fillInStackTrace();
        throw isx;
    }

    public static DiscreteInterpExterpFunc fromArbDistFunc(DiscretizedFunc func) {
        int size = func.size();
        double[] xVals = new double[size];
        double[] yVals = new double[size];
        for (int i = 0; i < size; ++i) {
            Point2D pt = func.get(i);
            xVals[i] = pt.getX();
            yVals[i] = pt.getY();
        }
        return new DiscreteInterpExterpFunc(xVals, yVals);
    }

    private static double linearInterp(double paramDouble1, double paramDouble2, double paramDouble3, double paramDouble4, double paramDouble5) {
        if (paramDouble1 == paramDouble2) {
            IllegalArgumentException localIllegalArgumentException = new IllegalArgumentException("X1 and X1 were equal. Cannot interpolate these values.");
            localIllegalArgumentException.fillInStackTrace();
            throw localIllegalArgumentException;
        }
        return paramDouble3 + (paramDouble5 - paramDouble1) / (paramDouble2 - paramDouble1) * (paramDouble4 - paramDouble3);
    }

    private static double linearExtrap(double paramDouble1, double paramDouble2, double paramDouble3, double paramDouble4, double paramDouble5) {
        if (paramDouble1 == paramDouble2) {
            IllegalArgumentException localIllegalArgumentException = new IllegalArgumentException("X1 and X1 were equal. Cannot extrapolate these values.");
            localIllegalArgumentException.fillInStackTrace();
            throw localIllegalArgumentException;
        }
        double d1 = (paramDouble4 - paramDouble3) / (paramDouble2 - paramDouble1);
        double d2 = paramDouble4 - d1 * paramDouble2;
        return d1 * paramDouble5 + d2;
    }

    private static double precisionFloor(double paramDouble1, double paramDouble2) {
        if (paramDouble1 < 0.0) {
            return -1.0 * DiscreteInterpExterpFunc.precisionCeil(Math.abs(paramDouble1), paramDouble2);
        }
        int i = (int)(paramDouble1 / paramDouble2);
        double d = paramDouble1 - paramDouble2 * (double)i;
        if (d == 0.0) {
            return paramDouble1;
        }
        return paramDouble2 * (double)i;
    }

    private static double precisionCeil(double paramDouble1, double paramDouble2) {
        if (paramDouble1 < 0.0) {
            return -1.0 * DiscreteInterpExterpFunc.precisionFloor(Math.abs(paramDouble1), paramDouble2);
        }
        int i = (int)(paramDouble1 / paramDouble2);
        double d = paramDouble1 - paramDouble2 * (double)i;
        if (d == 0.0) {
            return paramDouble1;
        }
        return paramDouble2 * (double)(i + 1);
    }
}

