/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.riskmaps.func;

import java.util.Arrays;
import java.util.Vector;
import org.opensha.sra.riskmaps.func.SetAPI;

public class DiscreteSet
implements SetAPI {
    private double[] values;

    public DiscreteSet(double[] values) {
        this.values = values;
        Arrays.sort(this.values);
    }

    @Override
    public boolean contains(double x) {
        return Arrays.binarySearch(this.values, x) >= 0;
    }

    @Override
    public SetAPI unionWith(SetAPI set) {
        int i;
        if (!(set instanceof DiscreteSet)) {
            IllegalArgumentException iax = new IllegalArgumentException("Cannot union a discrete and non-discrete set.");
            iax.fillInStackTrace();
            throw iax;
        }
        double[] otherVals = ((DiscreteSet)set).toArray();
        Vector<Double> unionSet = new Vector<Double>();
        for (i = 0; i < this.values.length; ++i) {
            unionSet.add(this.values[i]);
        }
        for (i = 0; i < otherVals.length; ++i) {
            if (Arrays.binarySearch(this.values, otherVals[i]) >= 0) continue;
            unionSet.add(otherVals[i]);
        }
        double[] result = new double[unionSet.size()];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = (Double)unionSet.get(i2);
        }
        return new DiscreteSet(result);
    }

    @Override
    public SetAPI intersectionOf(SetAPI set) {
        if (!(set instanceof DiscreteSet)) {
            IllegalArgumentException iax = new IllegalArgumentException("Cannot intersect a discrete and non-discrete set");
            iax.fillInStackTrace();
            throw iax;
        }
        double[] otherVals = ((DiscreteSet)set).toArray();
        Vector<Double> intersect = new Vector<Double>();
        for (int i = 0; i < otherVals.length; ++i) {
            if (Arrays.binarySearch(this.values, otherVals[i]) < 0) continue;
            intersect.add(otherVals[i]);
        }
        double[] result = new double[intersect.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Double)intersect.get(i);
        }
        return new DiscreteSet(result);
    }

    @Override
    public boolean equals(SetAPI set) {
        if (set instanceof DiscreteSet) {
            return this.equals((DiscreteSet)set);
        }
        return false;
    }

    @Override
    public double lowerBound() {
        double d = Double.NaN;
        try {
            d = this.values[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return d;
    }

    @Override
    public double upperBound() {
        double d = Double.NaN;
        try {
            d = this.values[this.values.length - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return d;
    }

    public int size() {
        return this.values.length;
    }

    public double[] toArray() {
        return this.values;
    }
}

