/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.rtgm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.Interpolate;
import org.opensha.sra.rtgm.RTGM_Util;

public class RTGM
implements Callable<RTGM> {
    private static final double TARGET_RISK = -Math.log(0.99) / 50.0;
    private static final double FRAGILITY_AT_RTGM = 0.1;
    private static final double BETA_DEFAULT = 0.6;
    private double beta = 0.6;
    public static final double AFE4UHGM = -Math.log(0.98) / 50.0;
    private static final int MAX_ITERATIONS = 6;
    private static final double UPSAMPLING_FACTOR = 1.05;
    private static final double MIN_SA = 0.001;
    private static final double TOLERANCE = 0.01;
    private DiscretizedFunc hazCurve;
    private double riskCoeff = Double.NaN;
    private double rtgm = Double.NaN;
    private List<Double> rtgmIters = null;
    private List<Double> riskIters = null;
    private Frequency sa;
    private int index = -1;

    private RTGM() {
    }

    public static RTGM create(DiscretizedFunc hazCurve, Frequency sa, Double beta) {
        Preconditions.checkNotNull((Object)hazCurve, (Object)"Supplied curve is null");
        RTGM instance = new RTGM();
        instance.hazCurve = RTGM.cleanCurve(hazCurve);
        if (sa != null) {
            instance.sa = sa;
        }
        if (beta != null) {
            instance.beta = beta;
        }
        return instance;
    }

    public static RTGM createIndexed(DiscretizedFunc hazCurve, Frequency sa, Double beta, int index) {
        RTGM instance = RTGM.create(hazCurve, sa, beta);
        instance.index = index;
        return instance;
    }

    @Override
    public RTGM call() {
        this.calculate(this.hazCurve);
        return this;
    }

    public double get() {
        return this.sa != null ? this.rtgm * this.sa.scale : this.rtgm;
    }

    public int index() {
        return this.index;
    }

    public double riskCoeff() {
        return this.riskCoeff;
    }

    public List<Double> rtgmIterations() {
        return this.rtgmIters;
    }

    public List<Double> riskIterations() {
        return this.riskIters;
    }

    public DiscretizedFunc hazardCurve() {
        return this.hazCurve;
    }

    private void calculate(DiscretizedFunc hazCurve) {
        int i;
        double uhgm = hazCurve.getFirstInterpolatedX_inLogXLogYDomain(AFE4UHGM);
        this.rtgmIters = Lists.newArrayList();
        this.riskIters = Lists.newArrayList();
        TreeMap interpMap = Maps.newTreeMap();
        DiscretizedFunc upsampHazCurve = RTGM.logResample(hazCurve, 0.001, 1.05);
        double errorRatio = Double.NaN;
        for (i = 0; i < 6; ++i) {
            double rtgmTmp = i == 0 ? uhgm : (i == 1 ? this.rtgmIters.get(0) * errorRatio : Interpolate.findLogLogY(Doubles.toArray(interpMap.keySet()), Doubles.toArray(interpMap.values()), TARGET_RISK));
            FragilityCurve fc = new FragilityCurve(rtgmTmp, upsampHazCurve, this.beta);
            double riskTmp = RTGM.riskIntegral(fc.pdf(), upsampHazCurve);
            errorRatio = RTGM.checkRiskAgainstTarget(riskTmp);
            this.riskIters.add(riskTmp);
            this.rtgmIters.add(rtgmTmp);
            interpMap.put(riskTmp, rtgmTmp);
            if (errorRatio == 1.0) break;
            if (i != 6) continue;
            throw new RuntimeException("RTGM: max # iterations reached");
        }
        this.rtgm = errorRatio != 1.0 ? Double.NaN : this.rtgmIters.get(this.rtgmIters.size() - 1);
        this.riskCoeff = this.rtgm / uhgm;
        for (i = 0; i < this.riskIters.size(); ++i) {
            this.riskIters.set(i, this.riskIters.get(i) / TARGET_RISK);
        }
    }

    private static double riskIntegral(DiscretizedFunc fragPDF, DiscretizedFunc hazCurve) {
        RTGM_Util.multiplyFunc(fragPDF, hazCurve);
        return RTGM_Util.trapz(fragPDF);
    }

    private static double checkRiskAgainstTarget(double risk) {
        double er = risk / TARGET_RISK;
        return Math.abs(er - 1.0) < 0.01 ? 1.0 : er;
    }

    private static DiscretizedFunc logResample(DiscretizedFunc f, double min, double interval) {
        double[] oldXs = new double[f.size()];
        double[] oldYs = new double[f.size()];
        for (int i = 0; i < f.size(); ++i) {
            oldXs[i] = f.getX(i);
            oldYs[i] = f.getY(i);
        }
        double[] newXs = DataUtils.buildLogSequence(min, f.getMaxX(), interval, true);
        double[] newYs = Interpolate.findLogLogY(oldXs, oldYs, newXs);
        ArbitrarilyDiscretizedFunc fOut = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < newXs.length; ++i) {
            fOut.set(newXs[i], newYs[i]);
        }
        return fOut;
    }

    private static DiscretizedFunc cleanCurve(DiscretizedFunc f) {
        ArbitrarilyDiscretizedFunc fOut = new ArbitrarilyDiscretizedFunc();
        for (Point2D p : f) {
            if (p.getY() == 0.0) continue;
            fOut.set(p);
        }
        Preconditions.checkArgument((fOut.size() > 2 ? 1 : 0) != 0, (Object)("Curve must have more than two non-zero y-values \n" + String.valueOf(f)));
        return fOut;
    }

    public static void main(String[] args) {
        double[] xs = new double[]{0.0025, 0.00375, 0.00563, 0.00844, 0.0127, 0.019, 0.0285, 0.0427, 0.0641, 0.0961, 0.144, 0.216, 0.324, 0.487, 0.73, 1.09, 1.64, 2.46, 3.69, 5.54};
        double[] ys = new double[]{0.4782, 0.3901, 0.3055, 0.2322, 0.1716, 0.1241, 0.08621, 0.05687, 0.03492, 0.01985, 0.01045, 0.005095, 0.002302, 9.371E-4, 3.308E-4, 9.488E-5, 1.952E-5, 2.174E-6, 8.553E-8, 1.315E-10};
        ArbitrarilyDiscretizedFunc f = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < xs.length; ++i) {
            f.set(xs[i], ys[i]);
        }
        RTGM rtgm = RTGM.create(f, null, null);
        System.out.println(rtgm.call());
        System.out.println(rtgm.get());
        System.out.println(rtgm.riskCoeff());
        System.out.println(rtgm.rtgmIterations());
        System.out.println(rtgm.riskIterations());
    }

    public static enum Frequency {
        SA_0P20(1.1),
        SA_1P00(1.3);

        private double scale;

        private Frequency(double scale) {
            this.scale = scale;
        }
    }

    private static class FragilityCurve {
        private double median;
        private double beta;
        private XY_DataSet model;
        private DiscretizedFunc pdf;
        private DiscretizedFunc cdf;

        FragilityCurve(double rtgm, DiscretizedFunc model, double beta) {
            this.median = rtgm / Math.exp(RTGM_Util.norminv(0.1) * beta);
            this.model = model;
            this.beta = beta;
        }

        double median() {
            return this.median;
        }

        DiscretizedFunc pdf() {
            if (this.pdf == null) {
                this.pdf = new ArbitrarilyDiscretizedFunc();
                for (Point2D p : this.model) {
                    this.pdf.set(p.getX(), RTGM_Util.logNormalDensity(p.getX(), Math.log(this.median), this.beta));
                }
            }
            return this.pdf;
        }

        DiscretizedFunc cdf() {
            if (this.cdf == null) {
                this.cdf = new ArbitrarilyDiscretizedFunc();
                for (Point2D p : this.model) {
                    this.cdf.set(p.getX(), RTGM_Util.logNormalCumProb(p.getX(), Math.log(this.median), this.beta));
                }
            }
            return this.cdf;
        }
    }
}

