/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.vulnerability;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.param.ParameterList;
import org.opensha.sra.asset.AssetCategory;
import org.opensha.sra.asset.LossType;
import org.opensha.sra.vulnerability.Vulnerability;

public abstract class AbstractVulnerability
implements Vulnerability,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name = "Unnamed Vulnerability";
    protected String shortName = "unnamed";
    protected String im_type;
    private double[] im_levels;
    public static final String SA = "SA";
    public static final String PGA = "PGA";
    private double period = 0.0;
    protected double ADF;
    protected double BDF;

    protected AbstractVulnerability() {
    }

    protected AbstractVulnerability(String name, String shortName, String im_type, double[] im_levels) {
        if (im_levels == null) {
            throw new NullPointerException("IM Levels array is null");
        }
        if (im_levels.length == 0) {
            throw new IllegalArgumentException("IM Levels array is empty");
        }
        for (double level : im_levels) {
            if (!(level < 0.0)) continue;
            throw new IllegalArgumentException("IM Levels array contains negative values");
        }
        this.name = name;
        this.shortName = shortName;
        this.im_type = im_type;
        this.im_levels = (double[])im_levels.clone();
        Arrays.sort(this.im_levels);
    }

    public double getADF() {
        return this.ADF;
    }

    public double getBDF() {
        return this.BDF;
    }

    @Override
    public double getPeriod() {
        return this.period;
    }

    public void setPeriod(double period) {
        this.period = period;
    }

    public AbstractDiscretizedFunc getHazardTemplate() {
        ArbitrarilyDiscretizedFunc rtn = new ArbitrarilyDiscretizedFunc();
        for (double level : this.im_levels) {
            rtn.set(level, 0.0);
        }
        return rtn;
    }

    public ArrayList<Double> getDFVals() {
        ArrayList<double[]> tmp = this.getDFTable();
        ArrayList<Double> rtn = new ArrayList<Double>();
        for (int i = 0; i < tmp.size(); ++i) {
            double[] entry = tmp.get(i);
            rtn.add(entry[1]);
        }
        return rtn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public ParameterList getParameters() {
        return null;
    }

    @Override
    public void setParameter(String name, Object value) {
    }

    @Override
    public double[] getIMLValues() {
        return (double[])this.im_levels.clone();
    }

    @Override
    public double getMinIMLVal() {
        return this.im_levels[0];
    }

    @Override
    public double getMaxIMLVal() {
        return this.im_levels[this.im_levels.length - 1];
    }

    @Override
    public double getMeanDamageFactor(double iml) {
        return -1.0;
    }

    @Override
    public double getLossStdDev() {
        return -1.0;
    }

    @Override
    public double getMeanDamageAtExceedProb(double iml, double prob) {
        return -1.0;
    }

    @Override
    public double getExceedProb(double loss, double iml) {
        return -1.0;
    }

    @Override
    public AssetCategory getAssetType() {
        return null;
    }

    @Override
    public LossType getLossType() {
        return null;
    }

    @Override
    public AbstractDiscretizedFunc getVulnerabilityFunc() {
        ArrayList<Double> DFs = this.getDFVals();
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        String name = this.getClass().getSimpleName();
        String info = this.getClass().getSimpleName() + "," + this.getIMT() + "," + this.im_levels.length;
        func.setName(name);
        func.setInfo(info);
        for (int i = 0; i < this.im_levels.length; ++i) {
            func.set(this.im_levels[i], (double)DFs.get(i));
        }
        return func;
    }

    @Override
    public String getIMT() {
        return this.im_type;
    }

    public abstract ArrayList<double[]> getDFTable();

    public abstract double getDF(double var1);

    public abstract double[][] getDEMMatrix();

    public abstract double[] getDEMDFVals();
}

