/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.ui.util;

import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

class Prefs {
    private static Preferences prefs;
    private static Map<Class<?>, Preferences> appPrefs;
    private static final String EXPORT_PATH_KEY = "EXPORT_PATH";
    private static final String EXPORT_PATH_DEFAULT;
    private static final String LEGAL_NOTICE_KEY = "LEGAL_NOTICE";
    private static final String LEGAL_NOTICE_DEFAULT = "0.0.0";

    Prefs() {
    }

    private static Preferences getAppPrefs(Class<?> c) {
        if (!appPrefs.containsKey(c)) {
            appPrefs.put(c, Preferences.userNodeForPackage(c));
        }
        return appPrefs.get(c);
    }

    static void close() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    static String getExportDir() {
        String path = prefs.get(EXPORT_PATH_KEY, EXPORT_PATH_DEFAULT);
        return !new File(path).exists() ? EXPORT_PATH_DEFAULT : path;
    }

    static void setExportDir(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return;
        }
        prefs.put(EXPORT_PATH_KEY, path);
    }

    public static void setShowLegal(Class<?> clazz, boolean show) {
        if (clazz == null) {
            return;
        }
        Prefs.getAppPrefs(clazz).putBoolean(LEGAL_NOTICE_KEY, show);
    }

    public void setColor(String key, Color c) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        if (c == null) {
            return;
        }
        prefs.putInt(key, c.getRGB());
    }

    public static Color getColor(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return Color.RED;
        }
        return new Color(prefs.getInt(key, Color.RED.getRGB()));
    }

    public void setColor(Class<?> clazz, String key, Color c) {
        if (clazz == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        if (c == null) {
            return;
        }
        Prefs.getAppPrefs(clazz).putInt(key, c.getRGB());
    }

    public static Color getColor(Class<?> clazz, String key) {
        if (clazz == null) {
            return Color.RED;
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            return Color.RED;
        }
        return new Color(prefs.getInt(key, Color.RED.getRGB()));
    }

    static {
        EXPORT_PATH_DEFAULT = SystemUtils.USER_HOME;
        prefs = Preferences.userRoot();
        appPrefs = new HashMap();
    }
}

