/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.Range;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.jfreechart.tornado.TornadoDiagram;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.DataUtils;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;

public class BranchSensitivityHistogram
implements Serializable {
    private Table<String, String, List<Double>> valsTable;
    private Table<String, String, List<Double>> weightsTable;
    private List<String> categoryAddedOrder = Lists.newArrayList();
    private String xAxisName;

    public BranchSensitivityHistogram(String xAxisName) {
        this.xAxisName = xAxisName;
        this.valsTable = HashBasedTable.create();
        this.weightsTable = HashBasedTable.create();
    }

    public void addValues(U3LogicTreeBranch branch, Double val, Double weight) {
        this.addValues(branch, val, weight, new String[0]);
    }

    public void addValues(U3LogicTreeBranch branch, Double val, Double weight, String ... extraValues) {
        int i;
        Preconditions.checkState((extraValues == null || extraValues.length % 2 == 0 ? 1 : 0) != 0, (Object)"Extra values must be empty/null or supplied in category/choice pairs.");
        ArrayList extraCategories = Lists.newArrayList();
        ArrayList extraChoices = Lists.newArrayList();
        if (extraValues != null && extraValues.length > 0) {
            for (i = 0; i < extraValues.length; ++i) {
                extraCategories.add(extraValues[i++]);
                extraChoices.add(extraValues[i]);
            }
        }
        for (i = 0; i < branch.size(); ++i) {
            U3LogicTreeBranchNode choice = (U3LogicTreeBranchNode)branch.getValue(i);
            String categoryName = ClassUtils.getClassNameWithoutPackage(U3LogicTreeBranch.getEnumEnclosingClass(choice.getClass()));
            this.addValue(categoryName, choice.getShortName(), val, weight);
        }
        for (i = 0; i < extraCategories.size(); ++i) {
            this.addValue((String)extraCategories.get(i), (String)extraChoices.get(i), val, weight);
        }
    }

    public synchronized void addValue(String categoryName, String choiceName, Double val, Double weight) {
        if (!this.valsTable.contains((Object)categoryName, (Object)choiceName)) {
            if (!this.valsTable.rowKeySet().contains(categoryName)) {
                this.categoryAddedOrder.add(categoryName);
            }
            this.valsTable.put((Object)categoryName, (Object)choiceName, new ArrayList());
            this.weightsTable.put((Object)categoryName, (Object)choiceName, new ArrayList());
        }
        ((List)this.valsTable.get((Object)categoryName, (Object)choiceName)).add(val);
        ((List)this.weightsTable.get((Object)categoryName, (Object)choiceName)).add(weight);
    }

    public void addAll(BranchSensitivityHistogram o) {
        for (Table.Cell cell : this.valsTable.cellSet()) {
            String categoryName = (String)cell.getRowKey();
            String choiceName = (String)cell.getColumnKey();
            List value = (List)cell.getValue();
            for (int i = 0; i < value.size(); ++i) {
                double val = (Double)value.get(i);
                double weight = (Double)((List)this.weightsTable.get((Object)categoryName, (Object)choiceName)).get(i);
                this.addValue(categoryName, choiceName, val, weight);
            }
        }
    }

    private HistogramFunction generateHist(String categoryName, String choiceName, double min, int num, double delta) {
        HistogramFunction hist = new HistogramFunction(min, num, delta);
        List vals = (List)this.valsTable.get((Object)categoryName, (Object)choiceName);
        List weights = (List)this.weightsTable.get((Object)categoryName, (Object)choiceName);
        Preconditions.checkState((vals.size() == weights.size() ? 1 : 0) != 0);
        Preconditions.checkState((!vals.isEmpty() ? 1 : 0) != 0);
        for (int i = 0; i < vals.size(); ++i) {
            double val = (Double)vals.get(i);
            if (!Doubles.isFinite((double)val)) continue;
            double weight = (Double)weights.get(i);
            int index = hist.getClosestXIndex(val);
            hist.add(index, weight);
        }
        hist.setName(choiceName);
        return hist;
    }

    public List<Double> getVals(String categoryName, String choiceName) {
        return Collections.unmodifiableList((List)this.valsTable.get((Object)categoryName, (Object)choiceName));
    }

    public double calcOverallMean() {
        double weightTot = 0.0;
        double mean = 0.0;
        for (Table.Cell cell : this.valsTable.cellSet()) {
            List vals = (List)cell.getValue();
            List weights = (List)this.weightsTable.get(cell.getRowKey(), cell.getColumnKey());
            for (int i = 0; i < weights.size(); ++i) {
                double val = (Double)vals.get(i);
                if (!Doubles.isFinite((double)val)) continue;
                double weight = (Double)weights.get(i);
                mean += val * weight;
                weightTot += weight;
            }
        }
        return mean / weightTot;
    }

    public double calcOverallStdDev() {
        double weightTot = 0.0;
        double mean = this.calcOverallMean();
        double var = 0.0;
        for (Table.Cell cell : this.valsTable.cellSet()) {
            List vals = (List)cell.getValue();
            List weights = (List)this.weightsTable.get(cell.getRowKey(), cell.getColumnKey());
            for (int i = 0; i < weights.size(); ++i) {
                double val = (Double)vals.get(i);
                if (!Doubles.isFinite((double)val)) continue;
                double weight = (Double)weights.get(i);
                var += (val - mean) * (val - mean) * weight;
                weightTot += weight;
            }
        }
        return Math.sqrt(var /= weightTot);
    }

    public double calcMean(String categoryName) {
        return this.calcMean(categoryName, new String[0]);
    }

    public double calcMean(String categoryName, String ... choiceNames) {
        if (choiceNames == null || choiceNames.length == 0) {
            ArrayList choices = Lists.newArrayList(this.getChoices(categoryName));
            choiceNames = new String[choices.size()];
            for (int i = 0; i < choiceNames.length; ++i) {
                choiceNames[i] = (String)choices.get(i);
            }
        }
        ArrayList vals = Lists.newArrayList();
        ArrayList weights = Lists.newArrayList();
        for (String choice : choiceNames) {
            vals.addAll((Collection)this.valsTable.get((Object)categoryName, (Object)choice));
            weights.addAll((Collection)this.weightsTable.get((Object)categoryName, (Object)choice));
        }
        double sumWeight = 0.0;
        double weightedSum = 0.0;
        DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
        for (int i = 0; i < vals.size(); ++i) {
            double val = (Double)vals.get(i);
            double weight = (Double)weights.get(i);
            if (!Doubles.isFinite((double)val)) continue;
            sumWeight += weight;
            weightedSum += val * weight;
            track.addValue(val);
        }
        double mean = weightedSum / sumWeight;
        Preconditions.checkState((mean >= track.getMin() && mean <= track.getMax() ? 1 : 0) != 0, (Object)("Mean not within min/max: mean=" + mean + ", min=" + track.getMin() + ", max=" + track.getMax()));
        return mean;
    }

    public double calcMeanWithout(String categoryName, String choiceName) {
        Set<String> choices = this.getChoices(categoryName);
        String[] namesWithout = new String[choices.size() - 1];
        int cnt = 0;
        for (String oChoice : choices) {
            if (oChoice.equals(choiceName)) continue;
            namesWithout[cnt++] = oChoice;
        }
        return this.calcMean(categoryName, namesWithout);
    }

    public double calcStdDev(String categoryName) {
        return this.calcStdDev(categoryName, new String[0]);
    }

    public double calcStdDev(String categoryName, String ... choiceNames) {
        if (choiceNames == null || choiceNames.length == 0) {
            ArrayList choices = Lists.newArrayList(this.getChoices(categoryName));
            choiceNames = new String[choices.size()];
            for (int i = 0; i < choiceNames.length; ++i) {
                choiceNames[i] = (String)choices.get(i);
            }
        }
        ArrayList vals = Lists.newArrayList();
        ArrayList weights = Lists.newArrayList();
        for (String choice : choiceNames) {
            vals.addAll((Collection)this.valsTable.get((Object)categoryName, (Object)choice));
            weights.addAll((Collection)this.weightsTable.get((Object)categoryName, (Object)choice));
        }
        double sumWeight = 0.0;
        double mean = this.calcMean(categoryName, choiceNames);
        double var = 0.0;
        for (int i = 0; i < vals.size(); ++i) {
            double val = (Double)vals.get(i);
            double weight = (Double)weights.get(i);
            if (!Doubles.isFinite((double)val)) continue;
            sumWeight += weight;
            var += (val - mean) * (val - mean) * weight;
        }
        return Math.sqrt(var /= sumWeight);
    }

    public double calcStdDevWithout(String categoryName, String choiceName) {
        Set<String> choices = this.getChoices(categoryName);
        String[] namesWithout = new String[choices.size() - 1];
        int cnt = 0;
        for (String oChoice : choices) {
            if (oChoice.equals(choiceName)) continue;
            namesWithout[cnt++] = oChoice;
        }
        return this.calcStdDev(categoryName, namesWithout);
    }

    public Range getRange() {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (Table.Cell cell : this.valsTable.cellSet()) {
            Iterator iterator = ((List)cell.getValue()).iterator();
            while (iterator.hasNext()) {
                double val = (Double)iterator.next();
                if (val < min) {
                    min = val;
                }
                if (!(val > max)) continue;
                max = val;
            }
        }
        return new Range(min, max);
    }

    public Range calcSmartHistRange(double delta) {
        Range range = this.getRange();
        double min = Math.floor(range.getLowerBound() / delta) * delta;
        if (min + 0.5 * delta < range.getLowerBound()) {
            min += delta;
        }
        double max = min;
        while (max + 0.5 * delta < range.getUpperBound()) {
            max += delta;
        }
        return new Range(min, max);
    }

    public Set<String> getChoices(String categoryName) {
        return this.valsTable.row((Object)categoryName).keySet();
    }

    public Map<String, PlotSpec> getStackedHistPlots(boolean meanLines, double delta) {
        Range range = this.calcSmartHistRange(delta);
        int num = (int)Math.round((range.getUpperBound() - range.getLowerBound()) / delta) + 1;
        System.out.println("Smart range: " + String.valueOf(range) + ", num=" + num);
        return this.getStackedHistPlots(meanLines, range.getLowerBound(), num, delta);
    }

    public Map<String, PlotSpec> getStackedHistPlots(boolean meanLines, double min, int num, double delta) {
        HashMap map = Maps.newHashMap();
        for (String categoryName : this.valsTable.rowKeySet()) {
            if (this.valsTable.row((Object)categoryName).size() <= 1) continue;
            map.put(categoryName, this.getStackedHistPlot(categoryName, meanLines, min, num, delta));
        }
        return map;
    }

    public PlotSpec getStackedHistPlot(String categoryName, boolean meanLines, double min, int num, double delta) {
        ArrayList hists = Lists.newArrayList();
        ArrayList choiceNames = Lists.newArrayList(this.getChoices(categoryName));
        Collections.sort(choiceNames);
        for (String choiceName : choiceNames) {
            hists.add(this.generateHist(categoryName, choiceName, min, num, delta));
        }
        ArrayList funcs = Lists.newArrayList();
        funcs.addAll(HistogramFunction.getStackedHists(hists, true));
        ArrayList chars = Lists.newArrayList();
        ArrayList colors = Lists.newArrayList((Object[])new Color[]{Color.BLACK, Color.BLUE, Color.RED, Color.GREEN, Color.CYAN, Color.ORANGE, Color.MAGENTA, Color.PINK, Color.YELLOW});
        Preconditions.checkState((hists.size() <= colors.size() ? 1 : 0) != 0, (Object)("Only have enough colors for " + colors.size() + " hists."));
        for (int i = 0; i < funcs.size(); ++i) {
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, (Color)colors.get(i)));
        }
        PlotSpec spec = new PlotSpec(funcs, chars, categoryName, this.xAxisName, "Density");
        spec.setLegendVisible(true);
        spec.setLegendLocation(RectangleEdge.BOTTOM);
        if (meanLines) {
            int j;
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            CommandLineInversionRunner.setFontSizes(gp);
            gp.drawGraphPanel(spec);
            spec.setCustomLegendItems(gp.getPlot().getLegendItems());
            ArrayList choiceMeans = Lists.newArrayList();
            ArrayList choiceColors = Lists.newArrayList();
            for (j = 0; j < choiceNames.size(); ++j) {
                String choiceName = (String)choiceNames.get(j);
                double choiceMean = this.calcMean(categoryName, choiceName);
                Color choiceColor = ((PlotCurveCharacterstics)chars.get(j)).getColor();
                choiceMeans.add(choiceMean);
                choiceColors.add(choiceColor);
            }
            for (j = 0; j < choiceNames.size(); ++j) {
                double choiceMean = (Double)choiceMeans.get(j);
                DefaultXY_DataSet line = new DefaultXY_DataSet();
                line.set(choiceMean, 0.0);
                line.set(choiceMean, 1.0);
                line.setName("(line mask)");
                funcs.add(line);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.GRAY));
            }
            for (j = 0; j < choiceNames.size(); ++j) {
                double choiceMean = (Double)choiceMeans.get(j);
                Color choiceColor = (Color)choiceColors.get(j);
                String choiceName = (String)choiceNames.get(j);
                DefaultXY_DataSet line = new DefaultXY_DataSet();
                line.set(choiceMean, 0.0);
                line.set(choiceMean, 1.0);
                line.setName(choiceName + " (mean=" + (float)choiceMean + ")");
                funcs.add(line);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 4.0f, choiceColor));
            }
        }
        return spec;
    }

    public CSVFile<String> getStaticsticsCSV() {
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine("Category", "Choice", "Choice Mean", "Choice Std Dev", "Mean WITHOUT Choice", "Std Dev WITHOUT Choice");
        for (String categoryName : this.categoryAddedOrder) {
            ArrayList choices = Lists.newArrayList(this.getChoices(categoryName));
            Collections.sort(choices);
            for (String choiceName : choices) {
                ArrayList line = Lists.newArrayList((Object[])new String[]{categoryName, choiceName});
                double choiceMean = this.calcMean(categoryName, choiceName);
                double choiceStdDev = this.calcStdDev(categoryName, choiceName);
                double withoutMean = this.calcMeanWithout(categoryName, choiceName);
                double withoutStdDev = this.calcStdDevWithout(categoryName, choiceName);
                line.add("" + choiceMean);
                line.add("" + choiceStdDev);
                line.add("" + withoutMean);
                line.add("" + withoutStdDev);
                csv.addLine(line);
            }
        }
        double overallMean = this.calcOverallMean();
        double overallStdDev = this.calcOverallStdDev();
        csv.addLine("TOTAL", "N/A", "" + overallMean, "" + overallStdDev, "NaN", "NaN");
        return csv;
    }

    public TornadoDiagram getTornadoDiagram(String title, boolean useMeanShift) {
        double overallMean = this.calcOverallMean();
        TornadoDiagram t = useMeanShift ? new TornadoDiagram(title, "Mean With - Mean Without, " + this.xAxisName, "Branch Level", 0.0) : new TornadoDiagram(title, "Mean " + this.xAxisName, "Branch Level", overallMean);
        for (String categoryName : this.categoryAddedOrder) {
            Set<String> choices = this.getChoices(categoryName);
            if (choices.size() == 1) continue;
            for (String choiceName : choices) {
                double val;
                double choiceMean = this.calcMean(categoryName, choiceName);
                if (useMeanShift) {
                    double withoutMean = this.calcMeanWithout(categoryName, choiceName);
                    val = overallMean - withoutMean;
                } else {
                    val = choiceMean;
                }
                t.addTornadoValue(categoryName, choiceName, val);
            }
        }
        return t;
    }

    public List<String> getCategoriesInAddedOrder() {
        return this.categoryAddedOrder;
    }
}

