/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import com.google.common.primitives.Doubles;
import com.itextpdf.text.DocumentException;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.dom4j.Document;
import org.dom4j.Element;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.calc.FractileCurveCalculator;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.NamedComparator;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.EvenlyDiscrXYZ_DataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSetMath;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZPlotSpec;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.mapping.gmt.GMT_Map;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.mapping.gmt.elements.TopographicSlopeFile;
import org.opensha.commons.mapping.gmt.gui.GMT_MapGuiBean;
import org.opensha.commons.mapping.gmt.gui.ImageViewerWindow;
import org.opensha.commons.param.impl.CPTParameter;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.XMLUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.earthquake.param.BPTAveragingTypeOptions;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.MagDependentAperiodicityOptions;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeDependentEpistemicList;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeIndependentEpistemicList;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.U3FaultSystemSolutionFetcher;
import scratch.UCERF3.analysis.BranchSensitivityHistogram;
import scratch.UCERF3.analysis.CompoundFSSPlots;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.analysis.GMT_CA_Maps;
import scratch.UCERF3.analysis.MPJ_ERF_ProbGainCalc;
import scratch.UCERF3.analysis.MPJ_ERF_ProbGainCalcScriptWriter;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.erf.FSSRupsInRegionCache;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.erf.mean.MeanUCERF3;
import scratch.UCERF3.erf.utils.ProbabilityModelsCalc;
import scratch.UCERF3.griddedSeismicity.FaultPolyMgr;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.logicTree.U3APrioriBranchWeightProvider;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.LastEventData;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF2_MFD_ConstraintFetcher;
import scratch.UCERF3.utils.UCERF2_Section_MFDs.UCERF2_Section_MFDsCalc;
import scratch.UCERF3.utils.UCERF2_Section_MFDs.UCERF2_Section_TimeDepMFDsCalc;
import scratch.UCERF3.utils.UCERF3_DataUtils;
import scratch.kevin.ucerf3.TestPDFCombine;

public class FaultSysSolutionERF_Calc {
    private static final double YEARS_PER_MILLI = 3.168878188728042E-11;
    private static final boolean debug_zip_file_check = false;
    private static final boolean debug_saf_nan_check = false;
    private static final DecimalFormat kmlProbDF = new DecimalFormat("0.00%");
    private static final String kmlBelowMinStr = "< 0.01%";
    private static final DecimalFormat kmlGainDF = new DecimalFormat("0.00");
    private static final String kmlInfGainStr = "-";
    private static final double kmlMinProb = 1.0E-4;
    private static String col_span_placeholder = "!COLSPAN!";

    public static FaultSystemSolutionERF getUCERF3_ERF_Instance(File faultSysSolZipFile) {
        InversionFaultSystemSolution invFss;
        try {
            invFss = U3FaultSystemIO.loadInvSol(faultSysSolZipFile);
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(invFss);
        erf.getParameter("Aleatory Mag-Area StdDev").setValue(0.0);
        erf.getTimeSpan().setDuration(1.0);
        erf.updateForecast();
        return erf;
    }

    public static void makePrelimReportPartPlots() {
        try {
            File file = new File("/Users/field/Neds_Creations/CEA_WGCEP/UCERF3/PrelimModelReport/Figures/Fig16_ERF_ParticipationMaps/zipFiles/FM3_1_GLpABM_MaEllB_DsrTap_DrEllB_GR_VarAseis0.1_VarOffAseis0.5_VarMFDMod1_VarNone_sol.zip");
            FaultSystemSolutionERF erf = FaultSysSolutionERF_Calc.getUCERF3_ERF_Instance(file);
            String fileName = "UCERF3_GR_DefMod_MoBal";
            GMT_CA_Maps.plotParticipationRateMap(erf, 5.0, 10.0, fileName + "_Part5pt0", "test", fileName + "_Part5pt0");
            GMT_CA_Maps.plotParticipationRateMap(erf, 6.7, 10.0, fileName + "_Part6pt7", "test", fileName + "_Part6pt7");
            GMT_CA_Maps.plotParticipationRateMap(erf, 7.7, 10.0, fileName + "_Part7pt7", "test", fileName + "_Part7pt7");
            GMT_CA_Maps.plotM6_5_BulgeMap(erf, 6.5, 1.0, fileName + "_Bulge", "test", fileName + "_Bulge");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void makeDraftFinalModelReportPartPlots() {
        try {
            File file = new File("/Users/field/Neds_Creations/CEA_WGCEP/UCERF3/draftFinalModelReport/FaultSystemSolutions/FM3_1_ZENG_EllB_DsrUni_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_sol.zip");
            FaultSystemSolutionERF erf = new FaultSystemSolutionERF(U3FaultSystemIO.loadSol(file));
            erf.updateForecast();
            String fileName = "UCERF3_Char_Ref_Zeng_Model";
            GMT_CA_Maps.plotParticipationRateMap(erf, 5.0, 10.0, fileName + "_Part5pt0", "test", fileName + "_Part5pt0");
            GMT_CA_Maps.plotParticipationRateMap(erf, 6.7, 10.0, fileName + "_Part6pt7", "test", fileName + "_Part6pt7");
            GMT_CA_Maps.plotParticipationRateMap(erf, 7.7, 10.0, fileName + "_Part7pt7", "test", fileName + "_Part7pt7");
            GMT_CA_Maps.plotM6_5_BulgeMap(erf, 6.5, 1.0, fileName + "_Bulge", "test", fileName + "_Bulge");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (org.dom4j.DocumentException e) {
            e.printStackTrace();
        }
    }

    public static void makeAveMoRateMapForU3pt3(boolean includeAftershocks) {
        try {
            String fileName = "UCERF3_MEAN_BRANCH_AVG_SOL";
            String scaleLabel = "Moment Rate (Nm/yr)";
            String metadata = "includeAftershocks=" + includeAftershocks + "; \n";
            String dirName = fileName + "_MoRate";
            System.out.println(dirName);
            String f1 = "dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip";
            File file1 = new File(f1);
            System.out.println("Instantiating ERF1...");
            FaultSystemSolutionERF erf1 = new FaultSystemSolutionERF(U3FaultSystemIO.loadSol(file1));
            erf1.getParameter("Apply Aftershock Filter").setValue(!includeAftershocks);
            erf1.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.INCLUDE);
            erf1.getParameter("Treat Background Seismicity As").setValue(BackgroundRupType.POINT);
            erf1.updateForecast();
            System.out.println(erf1.getAdjustableParameterList().toString());
            InversionFaultSystemSolution fss1 = (InversionFaultSystemSolution)erf1.getSolution();
            PolygonFaultGridAssociations fltPolyMgr1 = fss1.getRupSet().getInversionTargetMFDs().getGridSeisUtils().getPolyMgr();
            System.out.println("calculation section moment rates...");
            double[] sectMoRates1 = FaultSysSolutionERF_Calc.calcMomentRateForAllFaultSections(erf1);
            GriddedGeoDataSet supraSeisMoRates_xyzData1 = new GriddedGeoDataSet(GMT_CA_Maps.defaultGridRegion, true);
            for (int s = 0; s < sectMoRates1.length; ++s) {
                Map<Integer, Double> nodesForSectMap = fltPolyMgr1.getNodeFractions(s);
                Set<Integer> nodeIndicesList = nodesForSectMap.keySet();
                for (int index : nodeIndicesList) {
                    double oldRate = supraSeisMoRates_xyzData1.get(index);
                    supraSeisMoRates_xyzData1.set(index, oldRate + nodesForSectMap.get(index) * sectMoRates1[s]);
                }
            }
            System.out.println("ERF_Calculator.getNucleationRatesInRegion...");
            erf1.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.ONLY);
            erf1.updateForecast();
            GriddedGeoDataSet geoDataSetForGridSeis1 = ERF_Calculator.getMomentRatesInRegion(erf1, GMT_CA_Maps.defaultGridRegion);
            String f2 = "dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_2_MEAN_BRANCH_AVG_SOL.zip";
            File file2 = new File(f2);
            System.out.println("Instantiating ERF2...");
            FaultSystemSolutionERF erf2 = new FaultSystemSolutionERF(U3FaultSystemIO.loadSol(file2));
            erf2.getParameter("Apply Aftershock Filter").setValue(!includeAftershocks);
            erf2.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.INCLUDE);
            erf2.getParameter("Treat Background Seismicity As").setValue(BackgroundRupType.POINT);
            erf2.updateForecast();
            System.out.println(erf2.getAdjustableParameterList().toString());
            InversionFaultSystemSolution fss2 = (InversionFaultSystemSolution)erf2.getSolution();
            PolygonFaultGridAssociations fltPolyMgr2 = fss2.getRupSet().getInversionTargetMFDs().getGridSeisUtils().getPolyMgr();
            System.out.println("calculation section moment rates 2...");
            double[] sectMoRates2 = FaultSysSolutionERF_Calc.calcMomentRateForAllFaultSections(erf2);
            GriddedGeoDataSet supraSeisMoRates_xyzData2 = new GriddedGeoDataSet(GMT_CA_Maps.defaultGridRegion, true);
            for (int s = 0; s < sectMoRates2.length; ++s) {
                Map<Integer, Double> nodesForSectMap = fltPolyMgr2.getNodeFractions(s);
                Set<Integer> nodeIndicesList = nodesForSectMap.keySet();
                for (int index : nodeIndicesList) {
                    double oldRate = supraSeisMoRates_xyzData2.get(index);
                    supraSeisMoRates_xyzData2.set(index, oldRate + nodesForSectMap.get(index) * sectMoRates2[s]);
                }
            }
            System.out.println("ERF_Calculator.getNucleationRatesInRegion 2...");
            erf2.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.ONLY);
            erf2.updateForecast();
            GriddedGeoDataSet geoDataSetForGridSeis2 = ERF_Calculator.getMomentRatesInRegion(erf2, GMT_CA_Maps.defaultGridRegion);
            GriddedGeoDataSet sumGeoDataSet = new GriddedGeoDataSet(GMT_CA_Maps.defaultGridRegion, true);
            double totalRate = 0.0;
            for (int i = 0; i < sumGeoDataSet.size(); ++i) {
                double ave = 0.5 * (geoDataSetForGridSeis1.get(i) + geoDataSetForGridSeis2.get(i) + supraSeisMoRates_xyzData1.get(i) + supraSeisMoRates_xyzData2.get(i));
                totalRate += ave;
                sumGeoDataSet.set(i, ave);
            }
            System.out.println("Total Moment Rate In Region : " + totalRate + " Nm/yr");
            metadata = metadata + "Total Moment Rate In Region : " + totalRate + " Nm/yr";
            GMT_MapGenerator gmt_MapGenerator = GMT_CA_Maps.getDefaultGMT_MapGenerator();
            System.out.println("Making GMT Map...");
            gmt_MapGenerator.setParameter("Color-Scale Min", 13.0);
            gmt_MapGenerator.setParameter("Color-Scale Max", 17.0);
            gmt_MapGenerator.setParameter("DPI", 300);
            gmt_MapGenerator.setParameter("Apply Black Background?", false);
            gmt_MapGenerator.setParameter("Generate KML Files", true);
            CPTParameter cptParam = (CPTParameter)gmt_MapGenerator.getAdjustableParamsList().getParameter("Color Scheme");
            cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
            GMT_CA_Maps.makeMap(sumGeoDataSet, scaleLabel, metadata, dirName, gmt_MapGenerator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (org.dom4j.DocumentException e) {
            e.printStackTrace();
        }
    }

    public static void makeIconicFigureForU3pt3_and_FM3pt1() {
        try {
            double[] minMagArray = new double[]{5.0, 6.7};
            double maxMag = 10.0;
            String f = "dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip";
            File file = new File(f);
            System.out.println("Instantiating ERF...");
            FaultSystemSolutionERF erf = new FaultSystemSolutionERF(U3FaultSystemIO.loadSol(file));
            erf.getParameter("Aleatory Mag-Area StdDev").setValue(0.12);
            erf.getParameter("Apply Aftershock Filter").setValue(false);
            erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.ONLY);
            erf.getParameter("Treat Background Seismicity As").setValue(BackgroundRupType.CROSSHAIR);
            erf.updateForecast();
            String fileName = "COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL";
            System.out.println(erf.getAdjustableParameterList().toString());
            String scaleLabel = "Participation Rate";
            String metadata = " ";
            InversionFaultSystemSolution fss = (InversionFaultSystemSolution)erf.getSolution();
            PolygonFaultGridAssociations fltPolyMgr = fss.getRupSet().getInversionTargetMFDs().getGridSeisUtils().getPolyMgr();
            for (double minMag : minMagArray) {
                System.out.println("fss.calcParticRateForAllSects...");
                double[] sectPartRates = fss.calcParticRateForAllSects(minMag, maxMag);
                GriddedGeoDataSet supraSeisPartRates_xyzData = new GriddedGeoDataSet(GMT_CA_Maps.defaultGridRegion, true);
                for (int s = 0; s < sectPartRates.length; ++s) {
                    Map<Integer, Double> nodesForSectMap = fltPolyMgr.getNodeFractions(s);
                    Set<Integer> nodeIndicesList = nodesForSectMap.keySet();
                    for (int index : nodeIndicesList) {
                        double oldRate = supraSeisPartRates_xyzData.get(index);
                        supraSeisPartRates_xyzData.set(index, oldRate + nodesForSectMap.get(index) * sectPartRates[s]);
                    }
                }
                Double tempDouble = minMag;
                String magString = tempDouble.toString();
                String dirName = fileName + "_Part_" + magString.replace(".", "pt");
                System.out.println(dirName);
                System.out.println("ERF_Calculator.getParticipationRatesInRegion...");
                GriddedGeoDataSet geoDataSetForGridSeis = ERF_Calculator.getParticipationRatesInRegion(erf, GMT_CA_Maps.defaultGridRegion, minMag, maxMag);
                GMT_MapGenerator gmt_MapGenerator = GMT_CA_Maps.getDefaultGMT_MapGenerator();
                GeoDataSet sumGeoDataSet = GeoDataSetMath.add(supraSeisPartRates_xyzData, geoDataSetForGridSeis);
                System.out.println("Making GMT Map...");
                gmt_MapGenerator.setParameter("Color-Scale Min", -6.0);
                gmt_MapGenerator.setParameter("Color-Scale Max", -2.0);
                gmt_MapGenerator.setParameter("Topo Resolution", "30 sec Global");
                gmt_MapGenerator.setParameter("Apply GMT Smoothing?", true);
                gmt_MapGenerator.setParameter("DPI", 300);
                gmt_MapGenerator.setParameter("Apply Black Background?", false);
                gmt_MapGenerator.setParameter("Generate KML Files", true);
                CPTParameter cptParam = (CPTParameter)gmt_MapGenerator.getAdjustableParamsList().getParameter("Color Scheme");
                cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
                GMT_CA_Maps.makeMap(sumGeoDataSet, "M>=" + minMag + " " + scaleLabel, metadata, dirName, gmt_MapGenerator);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (org.dom4j.DocumentException e) {
            e.printStackTrace();
        }
    }

    public static void makeNucleationRateMapForU3pt3(double magThresh, boolean includeAftershocks, double magAreaAleatory) {
        try {
            double maxMag = 10.0;
            String fileName = "MEAN_BRANCH_AVG_SOL";
            String scaleLabel = "Nucleation Rate";
            String metadata = "magThresh=" + magThresh + "\nincludeAftershocks=" + includeAftershocks + "\nmagAreaAleatory=" + magAreaAleatory + "\n";
            Double tempDouble = magThresh;
            String magString = tempDouble.toString();
            String dirName = fileName + "_Nucl_" + magString.replace(".", "pt");
            System.out.println(dirName);
            String f1 = "dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip";
            File file1 = new File(f1);
            System.out.println("Instantiating ERF1...");
            FaultSystemSolutionERF erf1 = new FaultSystemSolutionERF(U3FaultSystemIO.loadSol(file1));
            erf1.getParameter("Aleatory Mag-Area StdDev").setValue(magAreaAleatory);
            erf1.getParameter("Apply Aftershock Filter").setValue(!includeAftershocks);
            erf1.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.INCLUDE);
            erf1.getParameter("Treat Background Seismicity As").setValue(BackgroundRupType.POINT);
            erf1.updateForecast();
            System.out.println(erf1.getAdjustableParameterList().toString());
            InversionFaultSystemSolution fss1 = (InversionFaultSystemSolution)erf1.getSolution();
            PolygonFaultGridAssociations fltPolyMgr1 = fss1.getRupSet().getInversionTargetMFDs().getGridSeisUtils().getPolyMgr();
            System.out.println("calculation section nucleation rates...");
            double[] sectNuclRates1 = FaultSysSolutionERF_Calc.calcNucleationRateAboveMagForAllSects(erf1, magThresh);
            GriddedGeoDataSet supraSeisNuclRates_xyzData1 = new GriddedGeoDataSet(GMT_CA_Maps.defaultGridRegion, true);
            for (int s = 0; s < sectNuclRates1.length; ++s) {
                Map<Integer, Double> nodesForSectMap = fltPolyMgr1.getNodeFractions(s);
                Set<Integer> nodeIndicesList = nodesForSectMap.keySet();
                for (int index : nodeIndicesList) {
                    double oldRate = supraSeisNuclRates_xyzData1.get(index);
                    supraSeisNuclRates_xyzData1.set(index, oldRate + nodesForSectMap.get(index) * sectNuclRates1[s]);
                }
            }
            System.out.println("ERF_Calculator.getNucleationRatesInRegion...");
            erf1.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.ONLY);
            erf1.updateForecast();
            GriddedGeoDataSet geoDataSetForGridSeis1 = ERF_Calculator.getNucleationRatesInRegion(erf1, GMT_CA_Maps.defaultGridRegion, magThresh, maxMag);
            String f2 = "dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_2_MEAN_BRANCH_AVG_SOL.zip";
            File file2 = new File(f2);
            System.out.println("Instantiating ERF1...");
            FaultSystemSolutionERF erf2 = new FaultSystemSolutionERF(U3FaultSystemIO.loadSol(file2));
            erf2.getParameter("Aleatory Mag-Area StdDev").setValue(magAreaAleatory);
            erf2.getParameter("Apply Aftershock Filter").setValue(!includeAftershocks);
            erf2.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.INCLUDE);
            erf2.getParameter("Treat Background Seismicity As").setValue(BackgroundRupType.POINT);
            erf2.updateForecast();
            System.out.println(erf2.getAdjustableParameterList().toString());
            InversionFaultSystemSolution fss2 = (InversionFaultSystemSolution)erf2.getSolution();
            PolygonFaultGridAssociations fltPolyMgr2 = fss2.getRupSet().getInversionTargetMFDs().getGridSeisUtils().getPolyMgr();
            System.out.println("calculation section nucleation rates 2...");
            double[] sectNuclRates2 = FaultSysSolutionERF_Calc.calcNucleationRateAboveMagForAllSects(erf2, magThresh);
            GriddedGeoDataSet supraSeisNuclRates_xyzData2 = new GriddedGeoDataSet(GMT_CA_Maps.defaultGridRegion, true);
            for (int s = 0; s < sectNuclRates2.length; ++s) {
                Map<Integer, Double> nodesForSectMap = fltPolyMgr2.getNodeFractions(s);
                Set<Integer> nodeIndicesList = nodesForSectMap.keySet();
                for (int index : nodeIndicesList) {
                    double oldRate = supraSeisNuclRates_xyzData2.get(index);
                    supraSeisNuclRates_xyzData2.set(index, oldRate + nodesForSectMap.get(index) * sectNuclRates2[s]);
                }
            }
            System.out.println("ERF_Calculator.getNucleationRatesInRegion 2...");
            erf2.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.ONLY);
            erf2.updateForecast();
            GriddedGeoDataSet geoDataSetForGridSeis2 = ERF_Calculator.getNucleationRatesInRegion(erf2, GMT_CA_Maps.defaultGridRegion, magThresh, maxMag);
            GriddedGeoDataSet sumGeoDataSet = new GriddedGeoDataSet(GMT_CA_Maps.defaultGridRegion, true);
            double totalRate = 0.0;
            for (int i = 0; i < sumGeoDataSet.size(); ++i) {
                double ave = 0.5 * (geoDataSetForGridSeis1.get(i) + geoDataSetForGridSeis2.get(i) + supraSeisNuclRates_xyzData1.get(i) + supraSeisNuclRates_xyzData2.get(i));
                totalRate += ave;
                sumGeoDataSet.set(i, ave);
            }
            System.out.println("Total Rate : " + totalRate);
            metadata = metadata + "Total Rate : " + totalRate;
            GMT_MapGenerator gmt_MapGenerator = GMT_CA_Maps.getDefaultGMT_MapGenerator();
            System.out.println("Making GMT Map...");
            gmt_MapGenerator.setParameter("Color-Scale Min", -6.0);
            gmt_MapGenerator.setParameter("Color-Scale Max", -2.0);
            gmt_MapGenerator.setParameter("DPI", 300);
            gmt_MapGenerator.setParameter("Apply Black Background?", false);
            gmt_MapGenerator.setParameter("Generate KML Files", true);
            CPTParameter cptParam = (CPTParameter)gmt_MapGenerator.getAdjustableParamsList().getParameter("Color Scheme");
            cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
            GMT_CA_Maps.makeMap(sumGeoDataSet, "M>=" + magThresh + " " + scaleLabel, metadata, dirName, gmt_MapGenerator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (org.dom4j.DocumentException e) {
            e.printStackTrace();
        }
    }

    public static double[] calcNucleationRateAboveMagForAllSects(FaultSystemSolutionERF erf, double magThresh) {
        InversionFaultSystemRupSet rupSet = ((InversionFaultSystemSolution)erf.getSolution()).getRupSet();
        double[] sectNuclRates = new double[rupSet.getNumSections()];
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            double srcRate = ERF_Calculator.getTotalRateAboveMagForSource(erf.getSource(s), erf.getTimeSpan().getDuration(), magThresh);
            int fssRupIndex = erf.getFltSysRupIndexForSource(s);
            double rupArea = rupSet.getAreaForRup(fssRupIndex);
            for (int sectIndex : rupSet.getSectionsIndicesForRup(fssRupIndex)) {
                double sectArea = rupSet.getAreaForSection(sectIndex);
                int n = sectIndex;
                sectNuclRates[n] = sectNuclRates[n] + srcRate * sectArea / rupArea;
            }
        }
        return sectNuclRates;
    }

    public static SummedMagFreqDist[] calcParticipationMFDForAllSects(FaultSystemSolutionERF erf, double min, double max, int num) {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        SummedMagFreqDist[] mfdArray = new SummedMagFreqDist[rupSet.getNumSections()];
        for (int i = 0; i < mfdArray.length; ++i) {
            mfdArray[i] = new SummedMagFreqDist(min, max, num);
        }
        double duration = erf.getTimeSpan().getDuration();
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            SummedMagFreqDist srcMFD = ERF_Calculator.getTotalMFD_ForSource(erf.getSource(s), duration, min, max, num, true);
            int fssRupIndex = erf.getFltSysRupIndexForSource(s);
            for (int sectIndex : rupSet.getSectionsIndicesForRup(fssRupIndex)) {
                for (int i = 0; i < num; ++i) {
                    mfdArray[sectIndex].add(i, srcMFD.getY(i));
                }
            }
        }
        return mfdArray;
    }

    public static double[] calcParticipationRateForAllSects(FaultSystemSolutionERF erf, double minMag) {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        double[] rates = new double[rupSet.getNumSections()];
        double duration = erf.getTimeSpan().getDuration();
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            int fssRupIndex = erf.getFltSysRupIndexForSource(s);
            for (ProbEqkRupture rup : erf.getSource(s)) {
                if (!(rup.getMag() >= minMag)) continue;
                double rate = rup.getMeanAnnualRate(duration);
                Iterator<Integer> iterator = rupSet.getSectionsIndicesForRup(fssRupIndex).iterator();
                while (iterator.hasNext()) {
                    int sectIndex;
                    int n = sectIndex = iterator.next().intValue();
                    rates[n] = rates[n] + rate;
                }
            }
        }
        return rates;
    }

    public static double calcParticipationRateForParentSect(FaultSystemSolutionERF erf, int parentID, double minMag) {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        double duration = erf.getTimeSpan().getDuration();
        HashSet<Integer> rupIndexes = new HashSet<Integer>(rupSet.getRupturesForParentSection(parentID));
        double rate = 0.0;
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            int fssRupIndex = erf.getFltSysRupIndexForSource(s);
            if (!rupIndexes.contains(fssRupIndex)) continue;
            for (ProbEqkRupture rup : erf.getSource(s)) {
                if (!(rup.getMag() >= minMag)) continue;
                rate += rup.getMeanAnnualRate(duration);
            }
        }
        return rate;
    }

    public static double calcParticipationRateForParentSects(FaultSystemSolutionERF erf, double minMag, int ... parentIDs) {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        double duration = erf.getTimeSpan().getDuration();
        HashSet<Integer> rupIndexes = new HashSet<Integer>();
        int[] nArray = parentIDs;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer parentID = nArray[i];
            rupIndexes.addAll(rupSet.getRupturesForParentSection(parentID));
        }
        double rate = 0.0;
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            int fssRupIndex = erf.getFltSysRupIndexForSource(s);
            if (!rupIndexes.contains(fssRupIndex)) continue;
            for (ProbEqkRupture rup : erf.getSource(s)) {
                if (!(rup.getMag() >= minMag)) continue;
                rate += rup.getMeanAnnualRate(duration);
            }
        }
        return rate;
    }

    public static double calcParticipationProbForParentSects(FaultSystemSolutionERF erf, double minMag, int ... parentIDs) {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        HashSet<Integer> rupIndexes = new HashSet<Integer>();
        int[] nArray = parentIDs;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer parentID = nArray[i];
            rupIndexes.addAll(rupSet.getRupturesForParentSection(parentID));
        }
        ArrayList probs = Lists.newArrayList();
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            int fssRupIndex = erf.getFltSysRupIndexForSource(s);
            if (!rupIndexes.contains(fssRupIndex)) continue;
            for (ProbEqkRupture rup : erf.getSource(s)) {
                if (!(rup.getMag() >= minMag)) continue;
                probs.add(rup.getProbability());
            }
        }
        return FaultSysSolutionERF_Calc.calcSummedProbs(probs);
    }

    public static double calcParticipationProbForSect(FaultSystemSolutionERF erf, double minMag, int sectionIndex) {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        HashSet<Integer> rupIndexes = new HashSet<Integer>(rupSet.getRupturesForSection(sectionIndex));
        ArrayList probs = Lists.newArrayList();
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            int fssRupIndex = erf.getFltSysRupIndexForSource(s);
            if (!rupIndexes.contains(fssRupIndex)) continue;
            for (ProbEqkRupture rup : erf.getSource(s)) {
                if (!(rup.getMag() >= minMag)) continue;
                probs.add(rup.getProbability());
            }
        }
        return FaultSysSolutionERF_Calc.calcSummedProbs(probs);
    }

    public static double calcNucleationRateForParentSect(FaultSystemSolutionERF erf, int parentID, double minMag) {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        double duration = erf.getTimeSpan().getDuration();
        HashSet<Integer> rupIndexes = new HashSet<Integer>(rupSet.getRupturesForParentSection(parentID));
        double rate = 0.0;
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            int fssRupIndex = erf.getFltSysRupIndexForSource(s);
            if (!rupIndexes.contains(fssRupIndex)) continue;
            double rupArea = rupSet.getAreaForRup(fssRupIndex);
            double rupAreaOnParent = 0.0;
            for (FaultSection sect : rupSet.getFaultSectionDataForRupture(fssRupIndex)) {
                if (sect.getParentSectionId() != parentID) continue;
                rupAreaOnParent += rupSet.getAreaForSection(sect.getSectionId());
            }
            Preconditions.checkState((rupAreaOnParent > 0.0 ? 1 : 0) != 0);
            Preconditions.checkState((rupAreaOnParent <= rupArea ? 1 : 0) != 0);
            double nuclFract = rupAreaOnParent / rupArea;
            for (ProbEqkRupture rup : erf.getSource(s)) {
                if (!(rup.getMag() >= minMag)) continue;
                rate += nuclFract * rup.getMeanAnnualRate(duration);
            }
        }
        return rate;
    }

    public static GriddedGeoDataSet calcParticipationProbInGriddedRegionFltMapped(FaultSystemSolutionERF erf, GriddedRegion griddedRegion, double minMag, double maxMag) {
        IncludeBackgroundOption origOption = (IncludeBackgroundOption)((Object)erf.getParameter("Background Seismicity").getValue());
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        FaultPolyMgr polyManager = FaultPolyMgr.create(rupSet.getFaultSectionDataList(), 12.0);
        double duration = erf.getTimeSpan().getDuration();
        erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.ONLY);
        erf.updateForecast();
        GriddedGeoDataSet combinedData = ERF_Calculator.getParticipationRatesInRegion(erf, griddedRegion, minMag, maxMag);
        erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
        erf.updateForecast();
        for (int sourceID = 0; sourceID < erf.getNumFaultSystemSources(); ++sourceID) {
            int invIndex = erf.getFltSysRupIndexForSource(sourceID);
            for (ProbEqkRupture rup : erf.getSource(sourceID)) {
                double mag = rup.getMag();
                if (mag < minMag || mag > maxMag) continue;
                double rupRate = rup.getMeanAnnualRate(duration);
                for (int s : rupSet.getSectionsIndicesForRup(invIndex)) {
                    Map<Integer, Double> nodeFracts = polyManager.getNodeFractions(s);
                    for (int n : nodeFracts.keySet()) {
                        double prevRate = combinedData.get(n);
                        combinedData.set(n, prevRate + rupRate * nodeFracts.get(n));
                    }
                }
            }
        }
        for (int n = 0; n < combinedData.size(); ++n) {
            double nodeRate = combinedData.get(n);
            combinedData.set(n, 1.0 - Math.exp(-nodeRate * duration));
        }
        erf.setParameter("Background Seismicity", (Object)origOption);
        erf.updateForecast();
        return combinedData;
    }

    public static SummedMagFreqDist[] calcNucleationMFDForAllSects(FaultSystemSolutionERF erf, double min, double max, int num) {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        SummedMagFreqDist[] mfdArray = new SummedMagFreqDist[rupSet.getNumSections()];
        for (int i = 0; i < mfdArray.length; ++i) {
            mfdArray[i] = new SummedMagFreqDist(min, max, num);
        }
        double duration = erf.getTimeSpan().getDuration();
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            SummedMagFreqDist srcMFD = ERF_Calculator.getTotalMFD_ForSource(erf.getSource(s), duration, min, max, num, true);
            int fssRupIndex = erf.getFltSysRupIndexForSource(s);
            double rupArea = rupSet.getAreaForRup(fssRupIndex);
            for (int sectIndex : rupSet.getSectionsIndicesForRup(fssRupIndex)) {
                double sectArea = rupSet.getAreaForSection(sectIndex);
                for (int i = 0; i < num; ++i) {
                    mfdArray[sectIndex].add(i, srcMFD.getY(i) * sectArea / rupArea);
                }
            }
        }
        return mfdArray;
    }

    public static double[] tempCalcParticipationRateForAllSects(FaultSystemSolutionERF erf) {
        int s;
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        double[] rateArraySmall = new double[rupSet.getNumSections()];
        double[] rateArray = new double[rupSet.getNumSections()];
        double[] maxMagArray = new double[rupSet.getNumSections()];
        double[] minMagArray = new double[rupSet.getNumSections()];
        int[] maxNumSectInRupForSect = new int[rupSet.getNumSections()];
        double duration = erf.getTimeSpan().getDuration();
        for (s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            int fssRupIndex = erf.getFltSysRupIndexForSource(s);
            double mag = erf.getSource(s).getRupture(0).getMag();
            List<Integer> setIndexList = rupSet.getSectionsIndicesForRup(fssRupIndex);
            double rate = erf.getSource(s).computeTotalEquivMeanAnnualRate(duration);
            Iterator<Integer> iterator = setIndexList.iterator();
            while (iterator.hasNext()) {
                int sectIndex;
                int n = sectIndex = iterator.next().intValue();
                rateArray[n] = rateArray[n] + rate;
                if (setIndexList.size() <= 3) {
                    int n2 = sectIndex;
                    rateArraySmall[n2] = rateArraySmall[n2] + rate;
                }
                if (setIndexList.size() > maxNumSectInRupForSect[sectIndex]) {
                    maxNumSectInRupForSect[sectIndex] = setIndexList.size();
                }
                if (maxMagArray[sectIndex] < mag) {
                    maxMagArray[sectIndex] = mag;
                }
                if (!(minMagArray[sectIndex] > mag)) continue;
                minMagArray[sectIndex] = mag;
            }
        }
        for (s = 0; s < rateArray.length; ++s) {
            rateArray[s] = rateArraySmall[s] / (rateArray[s] / (maxMagArray[s] - minMagArray[s]));
        }
        return rateArray;
    }

    public static double[] calcMomentRateForAllFaultSections(FaultSystemSolutionERF erf) {
        InversionFaultSystemRupSet rupSet = ((InversionFaultSystemSolution)erf.getSolution()).getRupSet();
        double[] sectMoRates = new double[rupSet.getNumSections()];
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            double srcMoRate = ERF_Calculator.getTotalMomentRateForSource(erf.getSource(s), erf.getTimeSpan().getDuration());
            int fssRupIndex = erf.getFltSysRupIndexForSource(s);
            double rupArea = rupSet.getAreaForRup(fssRupIndex);
            for (int sectIndex : rupSet.getSectionsIndicesForRup(fssRupIndex)) {
                double sectArea = rupSet.getAreaForSection(sectIndex);
                int n = sectIndex;
                sectMoRates[n] = sectMoRates[n] + srcMoRate * sectArea / rupArea;
            }
        }
        return sectMoRates;
    }

    public static void makeIconicFigureForU3TimeDependence() throws Exception {
        File xmlInputFile;
        File outputDir;
        File gmtDir = new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "GMT");
        if (!gmtDir.exists()) {
            gmtDir.mkdir();
        }
        if (!(outputDir = new File(gmtDir, "time_dep_fig_1")).exists()) {
            outputDir.mkdir();
        }
        if (!(xmlInputFile = new File(outputDir, "gridded_participation_prob_plots.xml")).exists()) {
            FileUtils.downloadURL("http://opensha.usc.edu/ftp/kmilner/ucerf3/2013_05_10-ucerf3p3-production-10runs/gridded_participation_prob_plots.xml", xmlInputFile);
        }
        double minMag = 6.7;
        double duration = 30.0;
        boolean display = false;
        FaultSysSolutionERF_Calc.makeIconicFigureForU3TimeDependence(xmlInputFile, outputDir, minMag, duration, display);
    }

    public static void makeIconicFigureForU3TimeDependence(File xmlInputFile, File outputDir, double minMag, double duration, boolean display) throws Exception {
        Preconditions.checkState((boolean)xmlInputFile.exists(), (Object)("XML Input file doesn't exist: " + xmlInputFile.getAbsolutePath()));
        List<CompoundFSSPlots.MapPlotData> mapDatas = CompoundFSSPlots.MapBasedPlot.loadPlotData(xmlInputFile);
        String plotFileName = (int)duration + "_timedep_gridded_partic_prob_" + (float)minMag + "+";
        CompoundFSSPlots.MapPlotData mapData = null;
        ArrayList availableDatasets = Lists.newArrayList();
        for (CompoundFSSPlots.MapPlotData data : mapDatas) {
            if (!data.getFileName().contains("timedep_gridded_partic_prob")) continue;
            availableDatasets.add(data.getFileName());
            if (!data.getFileName().equals(plotFileName)) continue;
            mapData = data;
            break;
        }
        if (mapData == null) {
            throw new IllegalArgumentException("Selected dataset '" + plotFileName + "' not found in xml input file. Available files:\n" + Joiner.on((String)"\n\t").join((Iterable)availableDatasets));
        }
        CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
        double minValue = -5.0;
        double maxValue = 0.0;
        cpt.setBelowMinColor(cpt.getMinColor());
        GeoDataSet data = mapData.getGriddedData();
        for (int index = 0; index < data.size(); ++index) {
            if (Doubles.isFinite((double)data.get(index))) continue;
            data.set(index, minValue);
        }
        GMT_Map map = new GMT_Map(mapData.getRegion(), data, mapData.getSpacing(), cpt);
        map.setCustomScaleMax(null);
        map.setCustomScaleMax(null);
        map.setTopoResolution(TopographicSlopeFile.SRTM_30_PLUS);
        map.setUseGMTSmoothing(true);
        map.setDpi(300);
        map.setBlackBackground(false);
        map.setGenerateKML(true);
        map.setCustomLabel(mapData.getLabel());
        map.setRescaleCPT(true);
        map.setCustomScaleMin(minValue);
        map.setCustomScaleMax(maxValue);
        GMT_MapGenerator gmt = new GMT_MapGenerator();
        gmt.getAdjustableParamsList().getParameter(Boolean.class, "Plot Log").setValue(false);
        gmt.getAdjustableParamsList().getParameter(Boolean.class, "Apply GMT Smoothing?").setValue(false);
        String url = gmt.makeMapUsingServlet(map, "metadata", null);
        System.out.println(url);
        String metadata = GMT_MapGuiBean.getClickHereHTML(gmt.getGMTFilesWebAddress());
        String baseURL = url.substring(0, url.lastIndexOf(47) + 1);
        File pngFile = new File(outputDir, plotFileName + ".png");
        FileUtils.downloadURL(baseURL + "map.png", pngFile);
        File pdfFile = new File(outputDir, plotFileName + ".pdf");
        FileUtils.downloadURL(baseURL + "map.pdf", pdfFile);
        File kmzFile = new File(outputDir, plotFileName + ".kmz");
        FileUtils.downloadURL(baseURL + "map.kmz", kmzFile);
        ZipFile zip = new ZipFile(kmzFile);
        ZipEntry entry = zip.getEntry("map.png");
        FileOutputStream fout = new FileOutputStream(new File(outputDir, plotFileName + "_scec_vdo.png"));
        FileUtils.copyInputStream(new BufferedInputStream(zip.getInputStream(entry)), new BufferedOutputStream(fout));
        if (display) {
            new ImageViewerWindow(url, metadata, true);
        }
    }

    public static void makeBackgroundImageForSCEC_VDO(GeoDataSet data, GriddedRegion griddedRegion, File outputDir, String plotFileName, boolean display, CPT cpt, double minValue, double maxValue, boolean includeTopo) throws Exception {
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        cpt.setBelowMinColor(cpt.getMinColor());
        for (int index = 0; index < data.size(); ++index) {
            if (Doubles.isFinite((double)data.get(index))) continue;
            data.set(index, minValue);
        }
        GMT_Map map = new GMT_Map((Region)griddedRegion, data, griddedRegion.getSpacing(), cpt);
        map.setCustomScaleMax(null);
        map.setCustomScaleMax(null);
        if (includeTopo) {
            map.setTopoResolution(TopographicSlopeFile.SRTM_30_PLUS);
            plotFileName = (String)plotFileName + "_withTopo";
        }
        map.setUseGMTSmoothing(true);
        map.setDpi(300);
        map.setBlackBackground(false);
        map.setGenerateKML(true);
        map.setCustomLabel("Label");
        map.setRescaleCPT(true);
        map.setCustomScaleMin(minValue);
        map.setCustomScaleMax(maxValue);
        GMT_MapGenerator gmt = new GMT_MapGenerator();
        gmt.getAdjustableParamsList().getParameter(Boolean.class, "Plot Log").setValue(false);
        gmt.getAdjustableParamsList().getParameter(Boolean.class, "Apply GMT Smoothing?").setValue(false);
        String url = gmt.makeMapUsingServlet(map, "metadata", null);
        System.out.println(url);
        String metadata = GMT_MapGuiBean.getClickHereHTML(gmt.getGMTFilesWebAddress());
        String baseURL = url.substring(0, url.lastIndexOf(47) + 1);
        File pngFile = new File(outputDir, (String)plotFileName + ".png");
        FileUtils.downloadURL(baseURL + "map.png", pngFile);
        File pdfFile = new File(outputDir, (String)plotFileName + ".pdf");
        FileUtils.downloadURL(baseURL + "map.pdf", pdfFile);
        File kmzFile = new File(outputDir, (String)plotFileName + ".kmz");
        FileUtils.downloadURL(baseURL + "map.kmz", kmzFile);
        File txtFile = new File(outputDir, (String)plotFileName + ".txt");
        FileUtils.downloadURL(baseURL + "map_data.txt", txtFile);
        ZipFile zip = new ZipFile(kmzFile);
        ZipEntry entry = zip.getEntry("map.png");
        FileOutputStream fout = new FileOutputStream(new File(outputDir, (String)plotFileName + "_scec_vdo.png"));
        FileUtils.copyInputStream(new BufferedInputStream(zip.getInputStream(entry)), new BufferedOutputStream(fout));
        if (display) {
            new ImageViewerWindow(url, metadata, true);
        }
    }

    public static void makeUCERF2_PartRateMaps() {
        try {
            MeanUCERF2 erf = new MeanUCERF2();
            erf.setParameter("Probability Model", "Poisson");
            erf.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
            erf.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
            erf.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
            erf.getTimeSpan().setDuration(1.0);
            erf.updateForecast();
            String fileName = "UCERF2";
            GMT_CA_Maps.plotParticipationRateMap(erf, 5.0, 10.0, fileName + "_Part5pt0", "test", fileName + "_Part5pt0");
            GMT_CA_Maps.plotParticipationRateMap(erf, 6.7, 10.0, fileName + "_Part6pt7", "test", fileName + "_Part6pt7");
            GMT_CA_Maps.plotParticipationRateMap(erf, 7.7, 10.0, fileName + "_Part7pt7", "test", fileName + "_Part7pt7");
            GMT_CA_Maps.plotParticipationRateMap(erf, 8.0, 10.0, fileName + "_Part8pt0", "test", fileName + "_Part8pt0");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void testUCERF2_Figure25() {
        UCERF2_TimeDependentEpistemicList erf_list = new UCERF2_TimeDependentEpistemicList();
        erf_list.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
        erf_list.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
        erf_list.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
        erf_list.getTimeSpan().setDuration(1.0);
        erf_list.updateForecast();
        String fileName = "UCERF2";
        XY_DataSetList wtedFuncList = new XY_DataSetList();
        ArrayList<Double> relativeWts = new ArrayList<Double>();
        for (int e = 0; e < erf_list.getNumERFs(); ++e) {
            System.out.println(e + " of " + erf_list.getNumERFs());
            SummedMagFreqDist mfdPart = ERF_Calculator.getParticipationMagFreqDistInRegion(erf_list.getERF(e), new CaliforniaRegions.SF_BOX(), 5.05, 40, 0.1, true);
            EvenlyDiscretizedFunc testMFD_Part = mfdPart.getCumRateDistWithOffset();
            for (int i = 0; i < testMFD_Part.size(); ++i) {
                double prob_part = 1.0 - Math.exp(-testMFD_Part.getY(i) * 30.0);
                testMFD_Part.set(i, prob_part);
            }
            wtedFuncList.add(testMFD_Part);
            relativeWts.add(erf_list.getERF_RelativeWeight(e));
        }
        FractileCurveCalculator fractileCalc = new FractileCurveCalculator(wtedFuncList, relativeWts);
        ArrayList<AbstractXY_DataSet> funcs = new ArrayList<AbstractXY_DataSet>();
        funcs.add(fractileCalc.getMeanCurve());
        funcs.add(fractileCalc.getFractile(0.025));
        funcs.add(fractileCalc.getFractile(0.5));
        funcs.add(fractileCalc.getFractile(0.975));
        GraphWindow graph = new GraphWindow(funcs, "Test of UCERF2 Figure 25");
        graph.setX_AxisRange(5.0, 8.5);
        graph.setY_AxisRange(0.0, 1.0);
    }

    public static void plotMFD_InRegion(Region region, String fileName) {
        FaultSystemSolutionERF ucerf3_erf;
        UCERF2_TimeIndependentEpistemicList erf_list = new UCERF2_TimeIndependentEpistemicList();
        erf_list.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
        erf_list.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
        erf_list.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
        erf_list.getTimeSpan().setDuration(1.0);
        erf_list.updateForecast();
        XY_DataSetList wtedFuncList = new XY_DataSetList();
        ArrayList<Double> relativeWts = new ArrayList<Double>();
        for (int e = 0; e < erf_list.getNumERFs(); ++e) {
            System.out.println(e + " of " + erf_list.getNumERFs());
            SummedMagFreqDist mfdPart = ERF_Calculator.getParticipationMagFreqDistInRegion(erf_list.getERF(e), region, 5.05, 40, 0.1, true);
            wtedFuncList.add(mfdPart.getCumRateDistWithOffset());
            relativeWts.add(erf_list.getERF_RelativeWeight(e));
        }
        FractileCurveCalculator fractileCalc = new FractileCurveCalculator(wtedFuncList, relativeWts);
        ArrayList<AbstractXY_DataSet> funcs = new ArrayList<AbstractXY_DataSet>();
        funcs.add(fractileCalc.getMeanCurve());
        funcs.add(fractileCalc.getMinimumCurve());
        funcs.add(fractileCalc.getMaximumCurve());
        funcs.add(fractileCalc.getFractile(0.5));
        MeanUCERF2 erf = new MeanUCERF2();
        erf.setParameter("Probability Model", "Poisson");
        erf.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
        erf.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
        erf.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
        erf.getTimeSpan().setDuration(1.0);
        erf.updateForecast();
        SummedMagFreqDist meanPart = ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 40, 0.1, true);
        meanPart.setName("MFD for MeanUCERF2");
        meanPart.setInfo(" ");
        funcs.add(meanPart.getCumRateDistWithOffset());
        File file = new File("/Users/field/Downloads/FaultSystemSolutions/FM3_1_NEOK_EllB_DsrUni_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_mean_sol.zip");
        try {
            ucerf3_erf = new FaultSystemSolutionERF(U3FaultSystemIO.loadSol(file));
        }
        catch (Exception e1) {
            throw ExceptionUtils.asRuntimeException(e1);
        }
        ucerf3_erf.updateForecast();
        SummedMagFreqDist ucerf3_Part = ERF_Calculator.getParticipationMagFreqDistInRegion(ucerf3_erf, region, 5.05, 40, 0.1, true);
        ucerf3_Part.setName("MFD for UCERF3 Char Reference Branch");
        ucerf3_Part.setInfo(" ");
        funcs.add(ucerf3_Part.getCumRateDistWithOffset());
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, null, 1.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, null, 1.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.GREEN));
        GraphWindow graph = new GraphWindow(funcs, "Cumulative MFDs in " + region.getName(), plotChars);
        graph.setX_AxisLabel("Magnitude");
        graph.setY_AxisLabel("Rate (per year)");
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(18);
        graph.setTickLabelFontSize(16);
        graph.setX_AxisRange(5.0, 8.5);
        graph.setY_AxisRange(1.0E-4, 1.0);
        graph.setYLog(true);
        try {
            graph.saveAsPDF(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void plot_U3pt3_U2_TotalMeanMFDs() {
        double aleatoryMagAreaVar = 0.0;
        CaliforniaRegions.RELM_TESTING_GRIDDED relmRegion = RELM_RegionUtils.getGriddedRegionInstance();
        MeanUCERF3 erf = new MeanUCERF3();
        erf.setMeanParams(10.0, true, 0.0, "Def. Model Mean");
        erf.getParameter("Aleatory Mag-Area StdDev").setValue(aleatoryMagAreaVar);
        erf.getParameter("Apply Aftershock Filter").setValue(false);
        erf.getParameter("Treat Background Seismicity As").setValue(BackgroundRupType.POINT);
        System.out.println("Working on INCLUDE");
        erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.INCLUDE);
        erf.updateForecast();
        SummedMagFreqDist mfd_U3_total = ERF_Calculator.getMagFreqDistInRegionFaster(erf, relmRegion, 5.05, 40, 0.1, true);
        System.out.println("Working on EXCLUDE");
        erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.EXCLUDE);
        erf.updateForecast();
        SummedMagFreqDist mfd_U3_faults = ERF_Calculator.getMagFreqDistInRegionFaster(erf, relmRegion, 5.05, 40, 0.1, true);
        System.out.println("Working on ONLY");
        erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.ONLY);
        erf.updateForecast();
        SummedMagFreqDist mfd_U3_gridded = ERF_Calculator.getMagFreqDistInRegionFaster(erf, relmRegion, 5.05, 40, 0.1, true);
        EvenlyDiscretizedFunc mfd_U3_total_cum = mfd_U3_total.getCumRateDistWithOffset();
        mfd_U3_total_cum.setName("Cumulative MFD for Mean UCERF3 - Total");
        EvenlyDiscretizedFunc mfd_U3_faults_cum = mfd_U3_faults.getCumRateDistWithOffset();
        mfd_U3_faults_cum.setName("Cumulative MFD for Mean UCERF3 - Faults");
        EvenlyDiscretizedFunc mfd_U3_gridded_cum = mfd_U3_gridded.getCumRateDistWithOffset();
        mfd_U3_gridded_cum.setName("Cumulative MFD for Mean UCERF3 - Gridded");
        UCERF2_MFD_ConstraintFetcher U2_fetcher = new UCERF2_MFD_ConstraintFetcher(relmRegion);
        EvenlyDiscretizedFunc mfd_U2_total_cum = U2_fetcher.getTotalMFD().getCumRateDistWithOffset();
        EvenlyDiscretizedFunc mfd_U2_faults_cum = U2_fetcher.getFaultMFD().getCumRateDistWithOffset();
        EvenlyDiscretizedFunc mfd_U2_gridded_cum = U2_fetcher.getBackgroundSeisMFD().getCumRateDistWithOffset();
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(mfd_U3_total_cum);
        funcs.add(mfd_U2_total_cum);
        funcs.add(mfd_U3_faults_cum);
        funcs.add(mfd_U2_faults_cum);
        funcs.add(mfd_U3_gridded_cum);
        funcs.add(mfd_U2_gridded_cum);
        GraphWindow graph = new GraphWindow(funcs, "U2 and U3 Cumulative MFDs");
        graph.setX_AxisLabel("Magnitude");
        graph.setY_AxisLabel("Cumulative Rate (per year)");
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(18);
        graph.setTickLabelFontSize(16);
        graph.setX_AxisRange(5.0, 9.0);
        graph.setY_AxisRange(1.0E-6, 10.0);
        graph.setYLog(true);
        Object tableString = new String();
        tableString = "U3_total\tU3_faults\tU3_gridded\tU2_total\tU2_faults\tU2_gridded\n";
        for (double mag = 5.0; mag < 8.8; mag += 0.1) {
            tableString = (String)tableString + (float)mag + "\t";
            tableString = (String)tableString + mfd_U3_total_cum.getClosestYtoX(mag) + "\t";
            tableString = (String)tableString + mfd_U3_faults_cum.getClosestYtoX(mag) + "\t";
            tableString = (String)tableString + mfd_U3_gridded_cum.getClosestYtoX(mag) + "\t";
            tableString = (String)tableString + mfd_U2_total_cum.getClosestYtoX(mag) + "\t";
            tableString = (String)tableString + mfd_U2_faults_cum.getClosestYtoX(mag) + "\t";
            tableString = (String)tableString + mfd_U2_gridded_cum.getClosestYtoX(mag) + "\n";
        }
        System.out.println((String)tableString);
        File dataFile = new File("dev/scratch/UCERF3/data/scratch/aveMFDs_ForU3_andU2.txt");
        try {
            FileWriter fw = new FileWriter(dataFile);
            fw.write((String)tableString);
            fw.close();
            graph.saveAsPDF("dev/scratch/UCERF3/data/scratch/aveMFDs_ForU3_andU2.pdf");
        }
        catch (IOException e) {
            System.out.println("IO exception = " + String.valueOf(e));
        }
    }

    public static EvenlyDiscretizedFunc calcMagProbDist(FaultSystemSolutionERF erf, Region region, double minMag, int numMag, double deltaMag, boolean calcFromMFD, FSSRupsInRegionCache cache) {
        Preconditions.checkState((numMag > 0 ? 1 : 0) != 0);
        erf.updateForecast();
        double duration = erf.getTimeSpan().getDuration();
        if (calcFromMFD) {
            SummedMagFreqDist incrMFD = ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, minMag + 0.5 * deltaMag, numMag, deltaMag, true, cache);
            EvenlyDiscretizedFunc mfd = incrMFD.getCumRateDistWithOffset();
            Preconditions.checkState((minMag == mfd.getMinX() ? 1 : 0) != 0);
            EvenlyDiscretizedFunc result = FaultSysSolutionERF_Calc.calcProbsFromSummedMFD(mfd, duration);
            Preconditions.checkState((minMag == result.getMinX() ? 1 : 0) != 0);
            return result;
        }
        if (cache == null) {
            cache = new FSSRupsInRegionCache();
        }
        EvenlyDiscretizedFunc result = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
        ArrayList probsList = Lists.newArrayList();
        for (int m = 0; m < numMag; ++m) {
            probsList.add(new ArrayList());
        }
        for (int sourceID = 0; sourceID < erf.getNumFaultSystemSources(); ++sourceID) {
            ProbEqkSource source = erf.getSource(sourceID);
            if (!cache.isRupInRegion(erf, source, source.getRupture(0), sourceID, 0, region)) continue;
            for (ProbEqkRupture rup : source) {
                double prob = rup.getProbability();
                double mag = rup.getMag();
                FaultSysSolutionERF_Calc.populateProbList(mag, prob, probsList, result);
            }
        }
        FaultSysSolutionERF_Calc.calcSummedProbs(probsList, result);
        return result;
    }

    private static void testProbSumMethods() throws IOException, org.dom4j.DocumentException {
        U3FaultSystemSolution meanSol = U3FaultSystemIO.loadSol(new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions"), "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
        double duration = 30.0;
        String durStr = (int)duration + "yr";
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(meanSol);
        erf.getTimeSpan().setDuration(duration);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        CaliforniaRegions.LA_BOX region = new CaliforniaRegions.LA_BOX();
        double minMag = 5.0;
        int numMag = 40;
        double deltaMag = 0.1;
        FSSRupsInRegionCache cache = new FSSRupsInRegionCache();
        EvenlyDiscretizedFunc mfdVals = FaultSysSolutionERF_Calc.calcMagProbDist(erf, region, minMag, numMag, deltaMag, true, cache);
        EvenlyDiscretizedFunc sumVals = FaultSysSolutionERF_Calc.calcMagProbDist(erf, region, minMag, numMag, deltaMag, true, cache);
        for (int i = 0; i < numMag; ++i) {
            double mfdY = mfdVals.getY(i);
            double sumY = sumVals.getY(i);
            double pDiff = DataUtils.getPercentDiff(sumY, mfdY);
            Preconditions.checkState((pDiff < 0.01 ? 1 : 0) != 0, (Object)("Fails within 0.01%: mfdY=" + mfdY + ", sumY=" + sumY + ", pDiff=" + pDiff + "%"));
        }
    }

    public static EvenlyDiscretizedFunc calcProbsFromSummedMFD(EvenlyDiscretizedFunc cmlMFD, double duration) {
        int numMag = cmlMFD.size();
        EvenlyDiscretizedFunc result = new EvenlyDiscretizedFunc(cmlMFD.getMinX(), numMag, cmlMFD.getDelta());
        for (int i = 0; i < numMag; ++i) {
            double rate = cmlMFD.getY(i);
            double prob = 1.0 - Math.exp(-rate * duration);
            result.set(i, prob);
        }
        return result;
    }

    private static void calcSummedProbs(List<List<Double>> probsList, EvenlyDiscretizedFunc result) {
        for (int i = 0; i < result.size(); ++i) {
            List<Double> probs = probsList.get(i);
            double totProb = FaultSysSolutionERF_Calc.calcSummedProbs(probs);
            result.set(i, totProb);
        }
    }

    public static double calcSummedProbs(double ... probs) {
        double totOneMinus = 1.0;
        for (double prob : probs) {
            totOneMinus *= 1.0 - prob;
        }
        double totProb = 1.0 - totOneMinus;
        return totProb;
    }

    public static double calcSummedProbs(List<Double> probs) {
        double totOneMinus = 1.0;
        for (double prob : probs) {
            totOneMinus *= 1.0 - prob;
        }
        double totProb = 1.0 - totOneMinus;
        return totProb;
    }

    private static void populateProbList(double mag, double prob, List<List<Double>> probsList, EvenlyDiscretizedFunc xVals) {
        if (mag < xVals.getMinX()) {
            return;
        }
        int magIndex = xVals.getClosestXIndex(mag);
        if (mag < xVals.getX(magIndex)) {
            --magIndex;
        }
        Preconditions.checkState((magIndex >= 0 ? 1 : 0) != 0);
        for (int m = 0; m <= magIndex && m < xVals.size(); ++m) {
            probsList.get(m).add(prob);
        }
    }

    public static EvenlyDiscretizedFunc[] calcSubSectSupraSeisMagProbDists(FaultSystemSolutionERF erf, double minMag, int numMag, double deltaMag) {
        return FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag, 10.0);
    }

    public static EvenlyDiscretizedFunc[] calcSubSectSupraSeisMagProbDists(FaultSystemSolutionERF erf, double minMag, int numMag, double deltaMag, double overallMaxMag) {
        erf.updateForecast();
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        int numSects = rupSet.getNumSections();
        ArrayList sectProbLists = Lists.newArrayList();
        for (int i = 0; i < numSects; ++i) {
            ArrayList probLists = Lists.newArrayList();
            for (int m = 0; m < numMag; ++m) {
                probLists.add(new ArrayList());
            }
            sectProbLists.add(probLists);
        }
        EvenlyDiscretizedFunc xVals = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
        for (int sourceID = 0; sourceID < erf.getNumFaultSystemSources(); ++sourceID) {
            int invIndex = erf.getFltSysRupIndexForSource(sourceID);
            for (ProbEqkRupture rup : erf.getSource(sourceID)) {
                double mag = rup.getMag();
                if (mag > overallMaxMag) continue;
                double prob = rup.getProbability();
                for (int sectIndex : rupSet.getSectionsIndicesForRup(invIndex)) {
                    FaultSysSolutionERF_Calc.populateProbList(mag, prob, (List)sectProbLists.get(sectIndex), xVals);
                }
            }
        }
        EvenlyDiscretizedFunc[] results = new EvenlyDiscretizedFunc[numSects];
        for (int sectIndex = 0; sectIndex < numSects; ++sectIndex) {
            results[sectIndex] = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
            FaultSysSolutionERF_Calc.calcSummedProbs((List)sectProbLists.get(sectIndex), results[sectIndex]);
        }
        return results;
    }

    public static Map<Integer, EvenlyDiscretizedFunc> calcParentSectSupraSeisMagProbDists(FaultSystemSolutionERF erf, double minMag, int numMag, double deltaMag) {
        return FaultSysSolutionERF_Calc.calcParentSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag, 10.0);
    }

    private static Map<Integer, EvenlyDiscretizedFunc> calcParentSectSupraSeisMagProbDists(FaultSystemSolutionERF erf, double minMag, int numMag, double deltaMag, double overallMaxMag) {
        erf.updateForecast();
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        HashSet<Integer> parentIDs = new HashSet<Integer>();
        for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
            parentIDs.add(faultSection.getParentSectionId());
        }
        HashMap sectProbLists = Maps.newHashMap();
        for (Integer parentID : parentIDs) {
            ArrayList probLists = Lists.newArrayList();
            for (int m = 0; m < numMag; ++m) {
                probLists.add(new ArrayList());
            }
            sectProbLists.put(parentID, probLists);
        }
        EvenlyDiscretizedFunc evenlyDiscretizedFunc = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
        for (int sourceID = 0; sourceID < erf.getNumFaultSystemSources(); ++sourceID) {
            int invIndex = erf.getFltSysRupIndexForSource(sourceID);
            for (ProbEqkRupture rup : erf.getSource(sourceID)) {
                double mag = rup.getMag();
                if (mag > overallMaxMag) continue;
                double prob = rup.getProbability();
                for (int parentID : rupSet.getParentSectionsForRup(invIndex)) {
                    FaultSysSolutionERF_Calc.populateProbList(mag, prob, (List)sectProbLists.get(parentID), evenlyDiscretizedFunc);
                }
            }
        }
        HashMap results = Maps.newHashMap();
        Iterator iterator = parentIDs.iterator();
        while (iterator.hasNext()) {
            int parentID = (Integer)iterator.next();
            EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
            FaultSysSolutionERF_Calc.calcSummedProbs((List)sectProbLists.get(parentID), func);
            results.put(parentID, func);
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    public static void makeFaultProbGainMaps(FaultSystemSolutionERF erf, File saveDir, String prefix) throws GMT_MapException, RuntimeException, IOException {
        void var21_20;
        double minMag = 6.7;
        int numMag = 4;
        double deltaMag = 0.5;
        double duration = erf.getTimeSpan().getDuration();
        FaultSystemSolution sol = erf.getSolution();
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.getTimeSpan().setDuration(duration);
        erf.updateForecast();
        EvenlyDiscretizedFunc[] poissonFuncs = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag);
        EvenlyDiscretizedFunc[] poissonAllMags = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag);
        EvenlyDiscretizedFunc[] poissonSmallMags = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag, 7.0);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        erf.getTimeSpan().setDuration(duration);
        erf.updateForecast();
        EvenlyDiscretizedFunc[] bptFuncs = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag);
        EvenlyDiscretizedFunc[] bptAllMags = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag);
        EvenlyDiscretizedFunc[] bptSmallMags = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag, 7.0);
        CPT probCPT = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(-4.0, 0.0);
        CPT ratioCPT = FaultSysSolutionERF_Calc.getScaledLinearRatioCPT(0.02);
        ArrayList faults = Lists.newArrayList();
        for (FaultSection faultSection : sol.getRupSet().getFaultSectionDataList()) {
            faults.add(faultSection.getFaultTrace());
        }
        CaliforniaRegions.RELM_COLLECTION region = new CaliforniaRegions.RELM_COLLECTION();
        if (prefix == null) {
            prefix = "";
        }
        if (!((String)prefix).isEmpty() && !((String)prefix).endsWith("_")) {
            prefix = (String)prefix + "_";
        }
        prefix = (String)prefix + (int)duration + "yr";
        boolean bl = false;
        while (var21_20 < numMag + 2) {
            Object magStr;
            String myPrefix;
            double[] bptVals;
            double[] poissonVals;
            if (var21_20 == numMag) {
                poissonVals = FaultSysSolutionERF_Calc.extractYVals(poissonAllMags, 0);
                bptVals = FaultSysSolutionERF_Calc.extractYVals(bptAllMags, 0);
                myPrefix = (String)prefix + "_supra_seis";
                magStr = "Supra Seis";
            } else if (var21_20 == numMag + 1) {
                poissonVals = FaultSysSolutionERF_Calc.extractYVals(poissonSmallMags, 0);
                bptVals = FaultSysSolutionERF_Calc.extractYVals(bptSmallMags, 0);
                myPrefix = (String)prefix + "_below_7";
                magStr = "All M<=7";
            } else {
                poissonVals = FaultSysSolutionERF_Calc.extractYVals(poissonFuncs, (int)var21_20);
                bptVals = FaultSysSolutionERF_Calc.extractYVals(bptFuncs, (int)var21_20);
                double mag = poissonFuncs[0].getX((int)var21_20);
                myPrefix = (String)prefix + "_" + (float)mag + "+";
                magStr = "M>=" + (float)mag;
            }
            double[] ratioVals = new double[poissonVals.length];
            for (int j = 0; j < ratioVals.length; ++j) {
                ratioVals[j] = bptVals[j] / poissonVals[j];
            }
            FaultBasedMapGen.makeFaultPlot(probCPT, faults, FaultBasedMapGen.log10(poissonVals), region, saveDir, myPrefix + "_poisson", false, true, "Log10(" + (float)duration + " yr " + (String)magStr + " Poisson Prob)");
            FaultBasedMapGen.makeFaultPlot(probCPT, faults, FaultBasedMapGen.log10(bptVals), region, saveDir, myPrefix + "_bpt", false, true, "Log10(" + (float)duration + " yr " + (String)magStr + " BPT Prob)");
            FaultBasedMapGen.makeFaultPlot(ratioCPT, faults, ratioVals, region, saveDir, myPrefix + "_prob_gain", false, true, (float)duration + " yr " + (String)magStr + " BPT/Poisson Prob Gain");
            ++var21_20;
        }
        double[] dArray = new double[poissonAllMags.length];
        ProbabilityModelsCalc calc = new ProbabilityModelsCalc(erf);
        double[] sectImpliedProbGain = new double[poissonAllMags.length];
        long curTime = System.currentTimeMillis();
        FaultSystemRupSet rupSet = sol.getRupSet();
        double[] partRates = sol.calcTotParticRateForAllSects();
        for (int i = 0; i < dArray.length; ++i) {
            FaultSection sect = rupSet.getFaultSectionData(i);
            long dateLast = sect.getDateOfLastEvent();
            if (dateLast == Long.MIN_VALUE) {
                dArray[i] = Double.NaN;
                sectImpliedProbGain[i] = Double.NaN;
                continue;
            }
            long deltaMillis = curTime - dateLast;
            double diffYears = 3.168878188728042E-11 * (double)deltaMillis;
            double ri = 1.0 / partRates[i];
            dArray[i] = diffYears / ri;
            double bptProb = calc.computeBPT_ProbFast(ri, diffYears, duration, 0.0);
            double poissonProb = ProbabilityModelsCalc.computePoissonProb(ri, duration);
            sectImpliedProbGain[i] = bptProb / poissonProb;
        }
        FaultBasedMapGen.makeFaultPlot(ratioCPT, faults, dArray, region, saveDir, (String)prefix + "_norm_time_since_last", false, true, "Normalized Time Since Last Event");
        FaultBasedMapGen.makeFaultPlot(ratioCPT, faults, sectImpliedProbGain, region, saveDir, (String)prefix + "_sect_implied_prob_gain", false, true, "Sect Implied Prob Gain");
    }

    /*
     * WARNING - void declaration
     */
    public static void makeWG02_FaultProbMaps() throws GMT_MapException, RuntimeException, IOException {
        void var24_24;
        double minMag = 6.7;
        int numMag = 4;
        double deltaMag = 0.5;
        Object prefix = "aper0pt3";
        String dirName = "WG02_tests_Aper0pt3";
        File saveDir = new File(dirName);
        if (!saveDir.exists()) {
            saveDir.mkdir();
        }
        U3FaultSystemSolution meanSol = null;
        try {
            meanSol = U3FaultSystemIO.loadSol(new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions"), "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
        }
        catch (org.dom4j.DocumentException e) {
            e.printStackTrace();
        }
        double duration = 30.0;
        String durStr = (int)duration + "yr";
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(meanSol);
        erf.getTimeSpan().setDuration(duration);
        FaultSystemSolution sol = erf.getSolution();
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        EvenlyDiscretizedFunc[] poissonFuncs = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag);
        EvenlyDiscretizedFunc[] poissonAllMags = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        erf.setParameter("Aperiodicity", (Object)MagDependentAperiodicityOptions.ALL_PT3_VALUES);
        erf.updateForecast();
        EvenlyDiscretizedFunc[] bptFuncs = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag);
        EvenlyDiscretizedFunc[] bptAllMags = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.WG02_BPT);
        erf.setParameter("Aperiodicity", (Object)MagDependentAperiodicityOptions.ALL_PT3_VALUES);
        erf.updateForecast();
        EvenlyDiscretizedFunc[] wg02_Funcs = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag);
        EvenlyDiscretizedFunc[] wg02_AllMags = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag);
        CPT probCPT = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(-4.0, 0.0);
        CPT ratioCPT = FaultSysSolutionERF_Calc.getScaledLinearRatioCPT(0.02);
        ArrayList faults = Lists.newArrayList();
        for (FaultSection faultSection : sol.getRupSet().getFaultSectionDataList()) {
            faults.add(faultSection.getFaultTrace());
        }
        CaliforniaRegions.RELM_COLLECTION region = new CaliforniaRegions.RELM_COLLECTION();
        if (prefix == null) {
            prefix = "";
        }
        if (!((String)prefix).isEmpty() && !((String)prefix).endsWith("_")) {
            prefix = (String)prefix + "_";
        }
        prefix = (String)prefix + (int)duration + "yr";
        boolean bl = false;
        while (var24_24 < numMag + 1) {
            Object magStr;
            String myPrefix;
            double[] wg02_Vals;
            double[] bptVals;
            double[] poissonVals;
            if (var24_24 == numMag) {
                poissonVals = FaultSysSolutionERF_Calc.extractYVals(poissonAllMags, 0);
                bptVals = FaultSysSolutionERF_Calc.extractYVals(bptAllMags, 0);
                wg02_Vals = FaultSysSolutionERF_Calc.extractYVals(wg02_AllMags, 0);
                myPrefix = (String)prefix + "_supra_seis";
                magStr = "Supra Seis";
            } else {
                poissonVals = FaultSysSolutionERF_Calc.extractYVals(poissonFuncs, (int)var24_24);
                bptVals = FaultSysSolutionERF_Calc.extractYVals(bptFuncs, (int)var24_24);
                wg02_Vals = FaultSysSolutionERF_Calc.extractYVals(wg02_Funcs, 0);
                double mag = poissonFuncs[0].getX((int)var24_24);
                myPrefix = (String)prefix + "_" + (float)mag + "+";
                magStr = "M>=" + (float)mag;
            }
            double[] wg02overPoisVavs = new double[poissonVals.length];
            double[] U3overWG02_Vavs = new double[poissonVals.length];
            for (int j = 0; j < wg02overPoisVavs.length; ++j) {
                wg02overPoisVavs[j] = wg02_Vals[j] / poissonVals[j];
                U3overWG02_Vavs[j] = bptVals[j] / wg02_Vals[j];
            }
            FaultBasedMapGen.makeFaultPlot(probCPT, faults, FaultBasedMapGen.log10(poissonVals), region, saveDir, myPrefix + "_poisson", false, true, "Log10(" + (float)duration + " yr " + (String)magStr + " Poisson Prob)");
            FaultBasedMapGen.makeFaultPlot(probCPT, faults, FaultBasedMapGen.log10(bptVals), region, saveDir, myPrefix + "_U3", false, true, "Log10(" + (float)duration + " yr " + (String)magStr + " U3 Prob)");
            FaultBasedMapGen.makeFaultPlot(probCPT, faults, FaultBasedMapGen.log10(wg02_Vals), region, saveDir, myPrefix + "_WG02", false, true, "Log10(" + (float)duration + " yr " + (String)magStr + " WG02 Prob)");
            FaultBasedMapGen.makeFaultPlot(ratioCPT, faults, wg02overPoisVavs, region, saveDir, myPrefix + "_WG02_prob_gain", false, true, (float)duration + " yr " + (String)magStr + " WG02 Prob Gain");
            FaultBasedMapGen.makeFaultPlot(ratioCPT, faults, U3overWG02_Vavs, region, saveDir, myPrefix + "_U2overWG02_ratio", false, true, (float)duration + " yr " + (String)magStr + " U3 over WG02 Prob Ratio");
            ++var24_24;
        }
    }

    private static boolean[] toArray(boolean ... vals) {
        return vals;
    }

    public static void makeAvgMethodProbGainMaps(FaultSystemSolutionERF erf, File saveDir, String prefix) throws GMT_MapException, RuntimeException, IOException {
        ArrayList avgTypes = Lists.newArrayList();
        int refIndex = 1;
        avgTypes.add(BPTAveragingTypeOptions.AVE_RATE_AVE_NORM_TIME_SINCE);
        avgTypes.add(BPTAveragingTypeOptions.AVE_RI_AVE_TIME_SINCE);
        avgTypes.add(BPTAveragingTypeOptions.AVE_RI_AVE_NORM_TIME_SINCE);
        FaultSysSolutionERF_Calc.makeAvgMethodProbGainMaps(erf, saveDir, prefix, avgTypes, refIndex);
        avgTypes = Lists.newArrayList();
        refIndex = 0;
        avgTypes.add(BPTAveragingTypeOptions.AVE_RATE_AVE_NORM_TIME_SINCE);
        avgTypes.add(BPTAveragingTypeOptions.AVE_RI_AVE_NORM_TIME_SINCE);
        FaultSysSolutionERF_Calc.makeAvgMethodProbGainMaps(erf, saveDir, prefix, avgTypes, refIndex);
    }

    private static void makeAvgMethodProbGainMaps(FaultSystemSolutionERF erf, File saveDir, String prefix, List<BPTAveragingTypeOptions> avgTypes, int refIndex) throws GMT_MapException, RuntimeException, IOException {
        double minMag = 6.7;
        int numMag = 4;
        double deltaMag = 0.5;
        double duration = erf.getTimeSpan().getDuration();
        System.out.println("Duration: " + duration);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        erf.getTimeSpan().setDuration(duration);
        erf.updateForecast();
        ArrayList regFuncsList = Lists.newArrayList();
        ArrayList allMagsList = Lists.newArrayList();
        ArrayList smallMagsList = Lists.newArrayList();
        for (int i = 0; i < avgTypes.size(); ++i) {
            BPTAveragingTypeOptions avgType = avgTypes.get(i);
            erf.setParameter("BPT Averaging Type", (Object)avgType);
            erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
            erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
            erf.getTimeSpan().setDuration(duration);
            regFuncsList.add(FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag));
            allMagsList.add(FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, numMag, deltaMag));
            smallMagsList.add(FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, numMag, deltaMag, 7.0));
        }
        CPT ratioCPT = FaultSysSolutionERF_Calc.getScaledLinearRatioCPT(0.02);
        FaultSystemSolution sol = erf.getSolution();
        ArrayList faults = Lists.newArrayList();
        for (FaultSection faultSection : sol.getRupSet().getFaultSectionDataList()) {
            faults.add(faultSection.getFaultTrace());
        }
        CaliforniaRegions.RELM_COLLECTION region = new CaliforniaRegions.RELM_COLLECTION();
        if (prefix == null) {
            prefix = "";
        }
        if (!((String)prefix).isEmpty() && !((String)prefix).endsWith("_")) {
            prefix = (String)prefix + "_";
        }
        prefix = (String)prefix + (float)duration + "yr";
        String string = avgTypes.get(refIndex).getCompactLabel();
        for (int i = 0; i < numMag + 2; ++i) {
            for (int j = 0; j < avgTypes.size(); ++j) {
                Object magStr;
                String myPrefix;
                double[] refVals;
                double[] testVals;
                if (j == refIndex) continue;
                String testLabel = avgTypes.get(j).getCompactLabel();
                if (i == numMag) {
                    testVals = FaultSysSolutionERF_Calc.extractYVals((EvenlyDiscretizedFunc[])allMagsList.get(j), 0);
                    refVals = FaultSysSolutionERF_Calc.extractYVals((EvenlyDiscretizedFunc[])allMagsList.get(refIndex), 0);
                    myPrefix = (String)prefix + "_supra_seis";
                    magStr = "Supra Seis";
                } else if (i == numMag + 1) {
                    testVals = FaultSysSolutionERF_Calc.extractYVals((EvenlyDiscretizedFunc[])smallMagsList.get(j), 0);
                    refVals = FaultSysSolutionERF_Calc.extractYVals((EvenlyDiscretizedFunc[])smallMagsList.get(refIndex), 0);
                    myPrefix = (String)prefix + "_below_7";
                    magStr = "All M<=7";
                } else {
                    testVals = FaultSysSolutionERF_Calc.extractYVals((EvenlyDiscretizedFunc[])regFuncsList.get(j), 0);
                    refVals = FaultSysSolutionERF_Calc.extractYVals((EvenlyDiscretizedFunc[])regFuncsList.get(refIndex), 0);
                    double mag = ((EvenlyDiscretizedFunc[])regFuncsList.get(j))[0].getX(i);
                    myPrefix = (String)prefix + "_" + (float)mag + "+";
                    magStr = "M>=" + (float)mag;
                }
                double[] ratioVals = new double[testVals.length];
                for (int k = 0; k < ratioVals.length; ++k) {
                    ratioVals[k] = testVals[k] / refVals[k];
                }
                String fName = myPrefix + "_" + testLabel.replaceAll("\\W+", "_") + "_vs_" + string.replaceAll("\\W+", "_");
                FaultBasedMapGen.makeFaultPlot(ratioCPT, faults, ratioVals, region, saveDir, fName, false, true, (float)duration + "yr " + (String)magStr + testLabel + "/" + string);
            }
        }
    }

    private static double[] extractYVals(EvenlyDiscretizedFunc[] funcs, int index) {
        double[] vals = new double[funcs.length];
        for (int i = 0; i < funcs.length; ++i) {
            vals[i] = funcs[i].getY(index);
        }
        return vals;
    }

    private static void populateMagDurationXYZ(FaultSystemSolutionERF erf, EvenlyDiscrXYZ_DataSet[] xyzs, Region[] regions, FSSRupsInRegionCache cache) {
        double minMag = xyzs[0].getMinY();
        int numMag = xyzs[0].getNumY();
        double deltaMag = xyzs[0].getGridSpacingY();
        for (int x = 0; x < xyzs[0].getNumX(); ++x) {
            double duration = xyzs[0].getX(x);
            erf.getTimeSpan().setDuration(duration);
            erf.updateForecast();
            for (int i = 0; i < xyzs.length; ++i) {
                EvenlyDiscretizedFunc func = FaultSysSolutionERF_Calc.calcMagProbDist(erf, regions[i], minMag, numMag, deltaMag, true, cache);
                for (int y = 0; y < numMag; ++y) {
                    xyzs[i].set(x, y, func.getY(y));
                }
            }
        }
    }

    public static void makeMagDurationProbPlots(FaultSystemSolutionERF erf, File saveDir, String prefix) throws IOException {
        double minMag = 6.5;
        int numMag = 21;
        double deltaMag = 0.1;
        double minDuration = 5.0;
        double deltaDuration = 5.0;
        int numDuration = 20;
        Region[] regions = new Region[]{new CaliforniaRegions.RELM_COLLECTION(), new CaliforniaRegions.RELM_SOCAL(), new CaliforniaRegions.RELM_NOCAL(), new CaliforniaRegions.LA_BOX(), new CaliforniaRegions.SF_BOX()};
        String[] regNames = new String[]{"Statewide", "So Cal", "No Cal", "LA", "SF"};
        EvenlyDiscrXYZ_DataSet[] poissonXYZs = new EvenlyDiscrXYZ_DataSet[regions.length];
        EvenlyDiscrXYZ_DataSet[] bptXYZs = new EvenlyDiscrXYZ_DataSet[regions.length];
        for (int r = 0; r < regions.length; ++r) {
            poissonXYZs[r] = new EvenlyDiscrXYZ_DataSet(numDuration, numMag, minDuration, minMag, deltaDuration, deltaMag);
            bptXYZs[r] = new EvenlyDiscrXYZ_DataSet(numDuration, numMag, minDuration, minMag, deltaDuration, deltaMag);
        }
        FSSRupsInRegionCache cache = new FSSRupsInRegionCache();
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        FaultSysSolutionERF_Calc.populateMagDurationXYZ(erf, poissonXYZs, regions, cache);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        FaultSysSolutionERF_Calc.populateMagDurationXYZ(erf, bptXYZs, regions, cache);
        CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(0.0, 1.0);
        CPT ratioCPT = (CPT)FaultBasedMapGen.getLinearRatioCPT().clone();
        ratioCPT.setNanColor(Color.WHITE);
        if (prefix == null) {
            prefix = "";
        }
        if (!((String)prefix).isEmpty() && !((String)prefix).endsWith("_")) {
            prefix = (String)prefix + "_";
        }
        for (int r = 0; r < regions.length; ++r) {
            EvenlyDiscrXYZ_DataSet ratioXYZ = new EvenlyDiscrXYZ_DataSet(numDuration, numMag, minDuration, minMag, deltaDuration, deltaMag);
            for (int i = 0; i < ratioXYZ.size(); ++i) {
                ratioXYZ.set(i, bptXYZs[r].get(i) / poissonXYZs[r].get(i));
            }
            String name = regNames[r];
            String fName = (String)prefix + name.toLowerCase().replaceAll("\\W+", "_");
            FaultSysSolutionERF_Calc.writeMagProbXYZ(cpt, poissonXYZs[r], name + " Poisson Prob", "Probability", saveDir, fName + "_poisson");
            FaultSysSolutionERF_Calc.writeMagProbXYZ(cpt, bptXYZs[r], name + " BPT Prob", "Probability", saveDir, fName + "_bpt");
            FaultSysSolutionERF_Calc.writeMagProbXYZ(ratioCPT, ratioXYZ, name + " BPT/Poisson Prob Gain", "Prob Gain", saveDir, fName + "_prob_gain");
        }
    }

    private static void writeMagProbXYZ(CPT cpt, EvenlyDiscrXYZ_DataSet xyz, String title, String zLabel, File saveDir, String prefix) throws IOException {
        XYZPlotSpec spec = new XYZPlotSpec(xyz, cpt, title, "Duration (years)", "Min Mag", zLabel);
        Range xRange = new Range(xyz.getMinX() - 0.5 * xyz.getGridSpacingX(), xyz.getMaxX() + 0.5 * xyz.getGridSpacingX());
        Range yRange = new Range(xyz.getMinY() - 0.5 * xyz.getGridSpacingY(), xyz.getMaxY() + 0.5 * xyz.getGridSpacingY());
        new PlotUtils();
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.drawGraphPanel(spec, false, false, xRange, yRange);
        File file = new File(saveDir, prefix);
        gp.getChartPanel().setSize(1000, 1000);
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        EvenlyDiscrXYZ_DataSet.writeXYZFile((XYZ_DataSet)xyz, file.getAbsolutePath() + "_xyz.txt");
    }

    public static void writeSubSectionTimeDependenceCSV(FaultSystemSolutionERF erf, File outputFile) throws IOException {
        FaultSysSolutionERF_Calc.writeTimeDependenceCSV(erf, outputFile, false);
    }

    private static Map<Integer, EvenlyDiscretizedFunc> remap(EvenlyDiscretizedFunc[] funcs) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < funcs.length; ++i) {
            map.put(i, funcs[i]);
        }
        return map;
    }

    private static void writeTimeDependenceCSV(FaultSystemSolutionERF erf, File outputFile, boolean parent) throws IOException {
        Map<Integer, EvenlyDiscretizedFunc> bptSmallMags;
        Map<Integer, EvenlyDiscretizedFunc> bptAllMags;
        Map<Integer, EvenlyDiscretizedFunc> bptFuncs;
        Map<Integer, EvenlyDiscretizedFunc> poissonSmallMags;
        Map<Integer, EvenlyDiscretizedFunc> poissonAllMags;
        Map<Integer, EvenlyDiscretizedFunc> poissonFuncs;
        CSVFile csv = new CSVFile(true);
        double minMag = 6.7;
        int numMag = 4;
        double deltaMag = 0.5;
        FaultSystemSolution sol = erf.getSolution();
        double duration = erf.getTimeSpan().getDuration();
        double allMagMin = 5.2;
        int numAllMag = 3 + numMag;
        double allMagMax = allMagMin + deltaMag * (double)(numAllMag - 1);
        String[] magRangeStrs = new String[]{"M>=6.7", "M>=7.2", "M>=7.7", "M>=8.2", "Supra Seis", "M<=7.0"};
        ArrayList header = Lists.newArrayList((Object[])new String[]{"Section Name"});
        if (parent) {
            header.add("Parent Section ID");
        } else {
            header.add("Sub Section ID");
        }
        for (String rangeStr : magRangeStrs) {
            header.add(rangeStr);
            header.add("Recurr Int.");
            if (parent) {
                header.add("Open Int. Where Known");
            } else {
                header.add("Open Int.");
            }
            header.add("Ppois");
            header.add("Pbpt");
            header.add("Prob Gain");
            header.add("Sect Impl Gain");
        }
        csv.addLine(header);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.getTimeSpan().setDuration(duration);
        erf.updateForecast();
        if (parent) {
            poissonFuncs = FaultSysSolutionERF_Calc.calcParentSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag);
            poissonAllMags = FaultSysSolutionERF_Calc.calcParentSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag);
            poissonSmallMags = FaultSysSolutionERF_Calc.calcParentSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag, 7.0);
        } else {
            poissonFuncs = FaultSysSolutionERF_Calc.remap(FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag));
            poissonAllMags = FaultSysSolutionERF_Calc.remap(FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag));
            poissonSmallMags = FaultSysSolutionERF_Calc.remap(FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag, 7.0));
        }
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        erf.getTimeSpan().setDuration(duration);
        erf.updateForecast();
        if (parent) {
            bptFuncs = FaultSysSolutionERF_Calc.calcParentSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag);
            bptAllMags = FaultSysSolutionERF_Calc.calcParentSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag);
            bptSmallMags = FaultSysSolutionERF_Calc.calcParentSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag, 7.0);
        } else {
            bptFuncs = FaultSysSolutionERF_Calc.remap(FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag));
            bptAllMags = FaultSysSolutionERF_Calc.remap(FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag));
            bptSmallMags = FaultSysSolutionERF_Calc.remap(FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag, 7.0));
        }
        HashSet<String> namesSet = new HashSet<String>();
        HashMap nameIDMap = Maps.newHashMap();
        HashMap parentLastEventMap = Maps.newHashMap();
        for (FaultSection faultSection : sol.getRupSet().getFaultSectionDataList()) {
            if (parent) {
                int parentID = faultSection.getParentSectionId();
                String parentName = faultSection.getParentSectionName();
                if (!namesSet.contains(parentName)) {
                    namesSet.add(parentName);
                    nameIDMap.put(parentName, parentID);
                    parentLastEventMap.put(parentID, new ArrayList());
                }
                if (faultSection.getDateOfLastEvent() <= Long.MIN_VALUE) continue;
                ((List)parentLastEventMap.get(parentID)).add(faultSection.getDateOfLastEvent());
                continue;
            }
            int sectID = faultSection.getSectionId();
            String name = faultSection.getSectionName();
            namesSet.add(name);
            nameIDMap.put(name, sectID);
        }
        ArrayList sectNames = Lists.newArrayList(namesSet);
        Collections.sort(sectNames, new SubSectNameComparator());
        Collections.sort(sectNames);
        long l = System.currentTimeMillis();
        ProbabilityModelsCalc calc = new ProbabilityModelsCalc(erf);
        for (String sectName : sectNames) {
            double oi;
            ArrayList line = Lists.newArrayList();
            Integer sectID = (Integer)nameIDMap.get(sectName);
            line.add(sectName);
            line.add("" + sectID);
            List lastDates = (List)parentLastEventMap.get(sectID);
            if (!parent) {
                lastDates = Lists.newArrayList();
                long last = sol.getRupSet().getFaultSectionData(sectID).getDateOfLastEvent();
                if (last > Long.MIN_VALUE) {
                    lastDates.add(last);
                }
            }
            if (lastDates.isEmpty()) {
                oi = Double.NaN;
            } else {
                oi = 0.0;
                Iterator last = lastDates.iterator();
                while (last.hasNext()) {
                    long lastDate = (Long)last.next();
                    long deltaMillis = l - lastDate;
                    double diffYears = 3.168878188728042E-11 * (double)deltaMillis;
                    oi += diffYears;
                }
                oi /= (double)lastDates.size();
            }
            for (int i = 0; i < numMag + 2; ++i) {
                double implCompareMag;
                double ri;
                double bptProb;
                double poissonProb;
                line.add("");
                IncrementalMagFreqDist mfd = parent ? sol.calcParticipationMFD_forParentSect(sectID, allMagMin + 0.5 * deltaMag, allMagMax + 0.5 * deltaMag, numAllMag) : sol.calcParticipationMFD_forSect(sectID, allMagMin + 0.5 * deltaMag, allMagMax + 0.5 * deltaMag, numAllMag);
                EvenlyDiscretizedFunc cmlMFD = mfd.getCumRateDistWithOffset();
                if (i == numMag) {
                    poissonProb = poissonAllMags.get(sectID).getY(0);
                    bptProb = bptAllMags.get(sectID).getY(0);
                    ri = 1.0 / cmlMFD.getY(0);
                    implCompareMag = 0.0;
                } else if (i == numMag + 1) {
                    poissonProb = poissonSmallMags.get(sectID).getY(0);
                    bptProb = bptSmallMags.get(sectID).getY(0);
                    double smallRate = 0.0;
                    for (Point2D pt : mfd) {
                        if (pt.getX() > 7.0) break;
                        smallRate += pt.getY();
                    }
                    ri = 1.0 / smallRate;
                    implCompareMag = 0.0;
                } else {
                    poissonProb = poissonFuncs.get(sectID).getY(i);
                    bptProb = bptFuncs.get(sectID).getY(i);
                    implCompareMag = poissonFuncs.get(sectID).getX(i) + 0.05;
                    ri = 1.0 / cmlMFD.getY(i + (numAllMag - numMag));
                }
                line.add("" + ri);
                line.add("" + oi);
                line.add("" + poissonProb);
                line.add("" + bptProb);
                line.add("" + bptProb / poissonProb);
                double implBPTProb = calc.computeBPT_ProbFast(ri, oi, duration, implCompareMag);
                double implPoissonProb = ProbabilityModelsCalc.computePoissonProb(ri, duration);
                line.add("" + implBPTProb / implPoissonProb);
            }
            csv.addLine(line);
        }
        csv.writeToFile(outputFile);
    }

    public static void writeParentSectionTimeDependenceCSV(FaultSystemSolutionERF erf, File outputFile) throws IOException {
        FaultSysSolutionERF_Calc.writeTimeDependenceCSV(erf, outputFile, true);
    }

    public static void writeDiffAveragingMethodsRupProbGains(double yrForOpenInterval) {
        String fileName = "dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip";
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(fileName);
        erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.EXCLUDE);
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.U3_BPT);
        erf.getTimeSpan().setDuration(30.0);
        int startYear = erf.getTimeSpan().getStartTimeYear();
        double openIntervalYrs = (double)startYear - yrForOpenInterval;
        System.out.println("ERF startYear=" + startYear + ": openIntervalYrs=" + openIntervalYrs);
        erf.setParameter("Historic Open Interval", openIntervalYrs);
        erf.getParameter("Aperiodicity").setValue(MagDependentAperiodicityOptions.LOW_VALUES);
        erf.updateForecast();
        ProbabilityModelsCalc testCalc = new ProbabilityModelsCalc(erf);
        testCalc.writeRupProbGainsForDiffAveragingMethods(erf.getTimeSpan().getStartTimeInMillis(), erf.getTimeSpan().getDuration(), "RupProbGainsForDiffAveMethods30yrs_LowApers_HistOpenInt" + Math.round(openIntervalYrs) + ".txt");
        erf.getParameter("Aperiodicity").setValue(MagDependentAperiodicityOptions.MID_VALUES);
        erf.updateForecast();
        testCalc = new ProbabilityModelsCalc(erf);
        testCalc.writeRupProbGainsForDiffAveragingMethods(erf.getTimeSpan().getStartTimeInMillis(), erf.getTimeSpan().getDuration(), "RupProbGainsForDiffAveMethods30yrs_MidApers_HistOpenInt" + Math.round(openIntervalYrs) + ".txt");
        erf.getParameter("Aperiodicity").setValue(MagDependentAperiodicityOptions.HIGH_VALUES);
        erf.updateForecast();
        testCalc = new ProbabilityModelsCalc(erf);
        testCalc.writeRupProbGainsForDiffAveragingMethods(erf.getTimeSpan().getStartTimeInMillis(), erf.getTimeSpan().getDuration(), "RupProbGainsForDiffAveMethods30yrs_HighApers_HistOpenInt" + Math.round(openIntervalYrs) + ".txt");
    }

    public static void testAftershockInclusionOnProbs() {
        int r;
        String erfFileName = "dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip";
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(erfFileName);
        erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.EXCLUDE);
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.U3_BPT);
        erf.getTimeSpan().setDuration(30.0);
        int startYear = erf.getTimeSpan().getStartTimeYear();
        erf.getParameter("Aperiodicity").setValue(MagDependentAperiodicityOptions.MID_VALUES);
        erf.getParameter("Apply Aftershock Filter").setValue(true);
        erf.updateForecast();
        int numRups = erf.getTotNumRups();
        double[] probWith = new double[numRups];
        double[] probWithout = new double[numRups];
        double[] ratio = new double[numRups];
        for (r = 0; r < numRups; ++r) {
            probWithout[r] = erf.getNthRupture(r).getProbability();
        }
        erf.getParameter("Apply Aftershock Filter").setValue(false);
        erf.updateForecast();
        for (r = 0; r < numRups; ++r) {
            probWith[r] = erf.getNthRupture(r).getProbability();
            ratio[r] = probWithout[r] / probWith[r];
        }
        double ave = 0.0;
        int num = 0;
        for (double val : ratio) {
            if (Double.isNaN(val) || Double.isInfinite(val)) continue;
            ave += val;
            ++num;
        }
        for (int i = 0; i < 10; ++i) {
            System.out.println(ratio[i]);
        }
        System.out.println("Average:\t" + ave / (double)num);
        System.out.println("num=" + num + "; ratio.length=" + ratio.length);
    }

    public static void writeDiffAveragingMethodsRupProbGains(int subSectIndex, double yrForOpenInterval) {
        String erfFileName = "dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip";
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(erfFileName);
        erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.EXCLUDE);
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.U3_BPT);
        erf.getTimeSpan().setDuration(30.0);
        int startYear = erf.getTimeSpan().getStartTimeYear();
        double openIntervalYrs = (double)startYear - yrForOpenInterval;
        System.out.println("ERF startYear=" + startYear + ": openIntervalYrs=" + openIntervalYrs);
        erf.setParameter("Historic Open Interval", openIntervalYrs);
        erf.getParameter("Aperiodicity").setValue(MagDependentAperiodicityOptions.LOW_VALUES);
        erf.updateForecast();
        String fileName = "sect" + subSectIndex + "_HistOpenInt" + Math.round(openIntervalYrs) + "_RupProbGainsForDiffAveMethods30yrs_LowApers.txt";
        ProbabilityModelsCalc testCalc = new ProbabilityModelsCalc(erf);
        testCalc.writeRupProbGainsForDiffAveragingMethods(erf.getTimeSpan().getStartTimeInMillis(), erf.getTimeSpan().getDuration(), fileName, subSectIndex);
        erf.getParameter("Aperiodicity").setValue(MagDependentAperiodicityOptions.MID_VALUES);
        erf.updateForecast();
        fileName = "sect" + subSectIndex + "_HistOpenInt" + Math.round(openIntervalYrs) + "_RupProbGainsForDiffAveMethods30yrs_MidApers.txt";
        testCalc = new ProbabilityModelsCalc(erf);
        testCalc.writeRupProbGainsForDiffAveragingMethods(erf.getTimeSpan().getStartTimeInMillis(), erf.getTimeSpan().getDuration(), fileName, subSectIndex);
        erf.getParameter("Aperiodicity").setValue(MagDependentAperiodicityOptions.HIGH_VALUES);
        erf.updateForecast();
        fileName = "sect" + subSectIndex + "_HistOpenInt" + Math.round(openIntervalYrs) + "_RupProbGainsForDiffAveMethods30yrs_HighApers.txt";
        testCalc = new ProbabilityModelsCalc(erf);
        testCalc.writeRupProbGainsForDiffAveragingMethods(erf.getTimeSpan().getStartTimeInMillis(), erf.getTimeSpan().getDuration(), fileName, subSectIndex);
    }

    public static CPT getScaledLinearRatioCPT(double fractToWashOut) throws IOException {
        return FaultSysSolutionERF_Calc.getScaledLinearRatioCPT(fractToWashOut, 0.0, 2.0);
    }

    public static CPT getScaledLinearRatioCPT(double fractToWashOut, double min, double max) throws IOException {
        Preconditions.checkArgument((fractToWashOut >= 0.0 && fractToWashOut < 1.0 ? 1 : 0) != 0);
        CPT ratioCPT = GMT_CPT_Files.UCERF3_HAZ_RATIO_P3.instance().rescale(min, max);
        CPT belowCPT = new CPT();
        CPT afterCPT = new CPT();
        for (CPTVal val : ratioCPT) {
            if (val.end < 1.0) {
                belowCPT.add(val);
                continue;
            }
            if (!(val.start > 1.0)) continue;
            afterCPT.add(val);
        }
        belowCPT = belowCPT.rescale(min, 1.0 - fractToWashOut);
        afterCPT = afterCPT.rescale(1.0 + fractToWashOut, max);
        CPT combCPT = (CPT)ratioCPT.clone();
        combCPT.clear();
        combCPT.addAll(belowCPT);
        if (fractToWashOut > 0.0) {
            Color washColor = ((CPTVal)combCPT.get((int)(combCPT.size() - 1))).maxColor;
            combCPT.add(new CPTVal(belowCPT.getMaxValue(), washColor, afterCPT.getMinValue(), washColor));
        }
        combCPT.addAll(afterCPT);
        return combCPT;
    }

    public static void writeDiffAveragingMethodsSubSectionTimeDependenceCSV(File outputDir, double yrForOpenInterval) throws IOException {
        MagDependentAperiodicityOptions[] covFuncs;
        U3FaultSystemSolution meanSol;
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        try {
            meanSol = U3FaultSystemIO.loadSol(new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions"), "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(meanSol);
        double duration = 30.0;
        erf.getTimeSpan().setDuration(duration);
        String durStr = (int)duration + "yr";
        erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.EXCLUDE);
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.U3_BPT);
        int startYear = erf.getTimeSpan().getStartTimeYear();
        double openIntervalYrs = (double)startYear - yrForOpenInterval;
        System.out.println("ERF startYear=" + startYear + ": openIntervalYrs=" + openIntervalYrs);
        erf.setParameter("Historic Open Interval", openIntervalYrs);
        for (MagDependentAperiodicityOptions cov : covFuncs = new MagDependentAperiodicityOptions[]{MagDependentAperiodicityOptions.LOW_VALUES, MagDependentAperiodicityOptions.MID_VALUES, MagDependentAperiodicityOptions.HIGH_VALUES}) {
            erf.getParameter("Aperiodicity").setValue(cov);
            ArrayList avgTypesList = Lists.newArrayList();
            ArrayList csvFiles = Lists.newArrayList();
            for (BPTAveragingTypeOptions aveType : BPTAveragingTypeOptions.values()) {
                erf.setParameter("BPT Averaging Type", (Object)aveType);
                String calcType = aveType.getFileSafeLabel();
                System.out.println("working on " + calcType);
                File csvFile = new File(outputDir, "SubSectProbData_" + durStr + "_" + cov.name() + "_COVs_" + calcType + "_HistOpenInt" + Math.round(openIntervalYrs) + ".csv");
                FaultSysSolutionERF_Calc.writeSubSectionTimeDependenceCSV(erf, csvFile);
                avgTypesList.add(aveType);
                csvFiles.add(CSVFile.readFile(csvFile, true));
            }
            double[] minMags = new double[]{0.0, 6.7};
            int[] startCols = new int[]{31, 3};
            for (int i = 0; i < minMags.length; ++i) {
                double minMag = minMags[i];
                int startCol = startCols[i];
                CSVFile refCSV = (CSVFile)csvFiles.get(0);
                CSVFile csv = new CSVFile(true);
                csv.addColumn(refCSV.getColumn(0));
                csv.addColumn(refCSV.getColumn(1));
                csv.addColumn(refCSV.getColumn(startCol));
                csv.addColumn(refCSV.getColumn(startCol + 1));
                csv.addColumn(refCSV.getColumn(startCol + 2));
                csv.addColumn(refCSV.getColumn(startCol + 5));
                for (int j = 0; j < avgTypesList.size(); ++j) {
                    BPTAveragingTypeOptions avgTypes = (BPTAveragingTypeOptions)((Object)avgTypesList.get(j));
                    CSVFile calcCSV = (CSVFile)csvFiles.get(j);
                    ArrayList headerCol = Lists.newArrayList();
                    String calcType = avgTypes.getCompactLabel();
                    headerCol.add(calcType);
                    while (headerCol.size() < refCSV.getNumRows()) {
                        headerCol.add("");
                    }
                    csv.addColumn(headerCol);
                    csv.addColumn(calcCSV.getColumn(startCol + 3));
                    csv.addColumn(calcCSV.getColumn(startCol + 4));
                }
                Object magStr = minMag < 5.0 ? "supra_seis" : (float)minMag + "+";
                File csvFile = new File(outputDir, "SubSectProbData_" + durStr + "_" + cov.name() + "_COVs_" + (String)magStr + "_HistOpenInt" + Math.round(openIntervalYrs) + "_combined.csv");
                csv.writeToFile(csvFile);
            }
        }
    }

    public static Map<Integer, List<Double>> writeBranchAggregatedTimeDepFigs(File zipFile, File outputDir, boolean parents, int magRangeIndex, double minMag, double duration) throws ZipException, IOException, GMT_MapException, RuntimeException {
        Table<MagDependentAperiodicityOptions, BPTAveragingTypeOptions, Map<U3LogicTreeBranch, SectProbGainResults[]>> table = FaultSysSolutionERF_Calc.loadBranchCSVVals(zipFile, new int[]{magRangeIndex}, parents).get(0);
        return FaultSysSolutionERF_Calc.writeBranchAggregatedTimeDepFigs(table, outputDir, parents, minMag, duration);
    }

    static Map<U3LogicTreeBranch, SectProbGainResults[]> calcPoissonValues(Table<MagDependentAperiodicityOptions, BPTAveragingTypeOptions, Map<U3LogicTreeBranch, SectProbGainResults[]>> table) {
        Map refMap = (Map)table.get(table.rowKeySet().iterator().next(), table.columnKeySet().iterator().next());
        HashMap poisMap = Maps.newHashMap();
        for (U3LogicTreeBranch branch : refMap.keySet()) {
            SectProbGainResults[] refResults = (SectProbGainResults[])refMap.get(branch);
            SectProbGainResults[] poisResults = new SectProbGainResults[refResults.length];
            for (int i = 0; i < refResults.length; ++i) {
                SectProbGainResults ref = refResults[i];
                double recurrInt = 1.0 / ref.pPois;
                poisResults[i] = new SectProbGainResults(recurrInt, ref.openInt, ref.pPois, ref.pPois, 1.0, ref.implGain);
            }
            poisMap.put(branch, poisResults);
        }
        return poisMap;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Integer, List<Double>> writeBranchAggregatedTimeDepFigs(Table<MagDependentAperiodicityOptions, BPTAveragingTypeOptions, Map<U3LogicTreeBranch, SectProbGainResults[]>> table, File outputDir, boolean parents, double minMag, double duration) throws ZipException, IOException, GMT_MapException, RuntimeException {
        String className;
        boolean isWeightedMultiCOV;
        HashMap branchVals = Maps.newHashMap();
        double avgTypeWeight = 1.0 / (double)table.columnKeySet().size();
        double totCellWeight = 0.0;
        boolean bl = isWeightedMultiCOV = table.rowKeySet().size() == 3 && table.rowKeySet().contains((Object)MagDependentAperiodicityOptions.LOW_VALUES) && table.rowKeySet().contains((Object)MagDependentAperiodicityOptions.MID_VALUES) && table.rowKeySet().contains((Object)MagDependentAperiodicityOptions.HIGH_VALUES);
        if (isWeightedMultiCOV) {
            System.out.println("Multiple/Weighted COV!");
            Map<U3LogicTreeBranch, SectProbGainResults[]> poisMap = FaultSysSolutionERF_Calc.calcPoissonValues(table);
            double pw = 0.2;
            for (U3LogicTreeBranch branch : poisMap.keySet()) {
                SectProbGainResults[] poisResults = poisMap.get(branch);
                SectProbGainResults[] scaledResults = new SectProbGainResults[poisResults.length];
                for (int i = 0; i < poisResults.length; ++i) {
                    SectProbGainResults pois = poisResults[i];
                    scaledResults[i] = new SectProbGainResults(pw * pois.recurrInt, pw * pois.openInt, pw * pois.pPois, pw * pois.pTimeDep, pw * pois.pGain, pw * pois.implGain);
                }
                branchVals.put(branch, scaledResults);
            }
            totCellWeight += pw;
        }
        HashSet mojaveNaNBranches = new HashSet();
        for (Object cell : table.cellSet()) {
            double cellWeight = avgTypeWeight;
            if (isWeightedMultiCOV) {
                if ((cellWeight *= FaultSystemSolutionERF.getWeightForCOV((MagDependentAperiodicityOptions)((Object)cell.getRowKey()))) == 0.0) {
                    throw new IllegalStateException("Multiple COV's only supported with low/mid/high (and all 3 must be present).");
                }
            } else {
                cellWeight *= 1.0 / (double)table.rowKeySet().size();
            }
            Map subBranchMap = (Map)cell.getValue();
            for (U3LogicTreeBranch branch : subBranchMap.keySet()) {
                SectProbGainResults[] vals = (SectProbGainResults[])subBranchMap.get(branch);
                SectProbGainResults[] curVals = (SectProbGainResults[])branchVals.get(branch);
                if (curVals == null) {
                    curVals = new SectProbGainResults[vals.length];
                    for (int i = 0; i < curVals.length; ++i) {
                        curVals[i] = new SectProbGainResults(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                    }
                    branchVals.put(branch, curVals);
                }
                for (int j = 0; j < vals.length; ++j) {
                    curVals[j].recurrInt += vals[j].recurrInt * cellWeight;
                    curVals[j].openInt += vals[j].openInt * cellWeight;
                    curVals[j].pPois += vals[j].pPois * cellWeight;
                    curVals[j].pTimeDep += vals[j].pTimeDep * cellWeight;
                    curVals[j].pGain += vals[j].pGain * cellWeight;
                    curVals[j].implGain += vals[j].implGain * cellWeight;
                }
            }
            totCellWeight += cellWeight;
        }
        Preconditions.checkState(((float)totCellWeight == 1.0f ? 1 : 0) != 0, (Object)("Total cell weight != 1: " + totCellWeight + ", isWeightedMultiCOV=" + isWeightedMultiCOV));
        HashSet<FaultModels> fms = new HashSet<FaultModels>();
        for (U3LogicTreeBranch branch : branchVals.keySet()) {
            FaultModels fm = branch.getValue(FaultModels.class);
            if (fms.contains(fm)) continue;
            fms.add(fm);
        }
        HashSet<FaultTraceComparable> tracesSet = new HashSet<FaultTraceComparable>();
        HashMap fmTracesMap = Maps.newHashMap();
        HashMap fmIndexMaps = Maps.newHashMap();
        HashMap meanYearsSinceMap = Maps.newHashMap();
        HashMap fractWithYearsSinceMap = parents ? Maps.newHashMap() : null;
        long curMillis = new GregorianCalendar(2014, 0, 0).getTimeInMillis();
        HashBasedTable fmSubSectIndexMap = HashBasedTable.create();
        for (FaultModels fm : fms) {
            int i;
            HashMap fmIndexMap = Maps.newHashMap();
            fmIndexMaps.put(fm, fmIndexMap);
            List<? extends FaultSection> subSects = new DeformationModelFetcher(fm, DeformationModels.GEOLOGIC, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1).getSubSectionList();
            LastEventData.populateSubSects(subSects, LastEventData.load());
            ArrayList fmTraces = Lists.newArrayList();
            for (i = 0; i < subSects.size(); ++i) {
                fmTraces.add(subSects.get(i).getFaultTrace());
                fmSubSectIndexMap.put((Object)fm, (Object)subSects.get(i).getName(), (Object)i);
            }
            fmTracesMap.put(fm, fmTraces);
            if (parents) {
                void var31_40;
                HashMap subSectsMap = Maps.newHashMap();
                for (FaultSection faultSection : subSects) {
                    List subSectsForParent = (List)subSectsMap.get(faultSection.getParentSectionId());
                    if (subSectsForParent == null) {
                        subSectsForParent = Lists.newArrayList();
                        subSectsMap.put(faultSection.getParentSectionId(), subSectsForParent);
                    }
                    subSectsForParent.add(faultSection);
                }
                List<FaultSection> parentSects = fm.getFaultSections();
                Collections.sort(parentSects, new NamedComparator());
                boolean bl2 = false;
                while (var31_40 < parentSects.size()) {
                    double oi;
                    FaultSection sect = parentSects.get((int)var31_40);
                    FaultTraceComparable comp = new FaultTraceComparable(sect.getName(), sect.getSectionId(), sect.getFaultTrace());
                    tracesSet.add(comp);
                    fmIndexMap.put(comp, (int)var31_40);
                    Integer parentID = sect.getSectionId();
                    List sects = (List)subSectsMap.get(parentID);
                    ArrayList lastDates = Lists.newArrayList();
                    for (FaultSection subSect : sects) {
                        if (subSect.getDateOfLastEvent() <= Long.MIN_VALUE) continue;
                        lastDates.add(subSect.getDateOfLastEvent());
                    }
                    if (lastDates.isEmpty()) {
                        oi = Double.NaN;
                    } else {
                        oi = 0.0;
                        Iterator iterator = lastDates.iterator();
                        while (iterator.hasNext()) {
                            long lastDate = (Long)iterator.next();
                            long deltaMillis = curMillis - lastDate;
                            double diffYears = 3.168878188728042E-11 * (double)deltaMillis;
                            oi += diffYears;
                        }
                        oi /= (double)lastDates.size();
                    }
                    double fractWith = (double)lastDates.size() / (double)sects.size();
                    meanYearsSinceMap.put(comp, oi);
                    fractWithYearsSinceMap.put(comp, fractWith);
                    ++var31_40;
                }
                continue;
            }
            for (i = 0; i < subSects.size(); ++i) {
                FaultSection sect = subSects.get(i);
                FaultTraceComparable faultTraceComparable = new FaultTraceComparable(sect.getName(), sect.getParentSectionId(), sect.getFaultTrace());
                tracesSet.add(faultTraceComparable);
                fmIndexMap.put(faultTraceComparable, i);
                double oi = sect.getDateOfLastEvent() > Long.MIN_VALUE ? 3.168878188728042E-11 * (double)(curMillis - sect.getDateOfLastEvent()) : Double.NaN;
                meanYearsSinceMap.put(faultTraceComparable, oi);
            }
        }
        ArrayList traceComps = Lists.newArrayList(tracesSet);
        Collections.sort(traceComps);
        ArrayList traces = Lists.newArrayList();
        double[] meanTimeDepVals = new double[traceComps.size()];
        HashMap fmMeanTimeDepVals = Maps.newHashMap();
        double[] minTimeDepVals = new double[traceComps.size()];
        double[] maxTimeDepVals = new double[traceComps.size()];
        double[] gainU3Vals = new double[traceComps.size()];
        double[] dArray = new double[traceComps.size()];
        HashMap meanBPT_COVVals = null;
        HashMap meanBPT_CalcVals = null;
        if (table.rowKeySet().size() > 1) {
            meanBPT_COVVals = Maps.newHashMap();
            for (MagDependentAperiodicityOptions theCOV : table.rowKeySet()) {
                meanBPT_COVVals.put(theCOV, new double[traceComps.size()]);
            }
            if (isWeightedMultiCOV) {
                meanBPT_COVVals.put(null, new double[traceComps.size()]);
            }
        }
        if (table.columnKeySet().size() > 1) {
            meanBPT_CalcVals = Maps.newHashMap();
            for (BPTAveragingTypeOptions aveType : table.columnKeySet()) {
                meanBPT_CalcVals.put(aveType, new double[traceComps.size()]);
            }
        }
        HashMap traceToCombIndexMap = Maps.newHashMap();
        for (int i = 0; i < traceComps.size(); ++i) {
            FaultTraceComparable traceComp = (FaultTraceComparable)traceComps.get(i);
            traces.add(traceComp.trace);
            traceToCombIndexMap.put(traceComp, i);
        }
        System.out.println(tracesSet.size() + " unique sects");
        U3APrioriBranchWeightProvider weightProv = new U3APrioriBranchWeightProvider();
        CSVFile csv = new CSVFile(true);
        ArrayList header = Lists.newArrayList((Object[])new String[]{"Name", "Fract With Years Since", "Average Years Since", "U3 Mean Time Dep Prob", "U3 Min", "U3 Max", "U3 Time Indep Prob", "U3 Time Dep/Indep"});
        if (parents) {
            header.addAll(Lists.newArrayList((Object[])new String[]{"U2 Mean Time Dep Prob", "U2 min", "U2 max", "U2 Time Indep Prob", "MeanU3 Time Dep/MeanU2 Time Dep"}));
        }
        csv.addLine(header);
        HashMap meanMap = Maps.newHashMap();
        for (int i = 0; i < traceComps.size(); ++i) {
            List parentVals;
            double[] timeDepAllValsArray;
            FaultModels fm;
            Object branch22;
            FaultTraceComparable trace = (FaultTraceComparable)traceComps.get(i);
            ArrayList timeDepVals = Lists.newArrayList();
            HashMap fmTimeDepValsMap = Maps.newHashMap();
            ArrayList poisVals = Lists.newArrayList();
            ArrayList gainVals = Lists.newArrayList();
            ArrayList weights = Lists.newArrayList();
            HashMap fmTimeDepWeightsMap = Maps.newHashMap();
            HashBasedTable bptOpsValsTable = null;
            if (meanBPT_COVVals != null || meanBPT_CalcVals != null) {
                bptOpsValsTable = HashBasedTable.create();
                for (Table.Cell cell : table.cellSet()) {
                    bptOpsValsTable.put((Object)((MagDependentAperiodicityOptions)((Object)cell.getRowKey())), (Object)((BPTAveragingTypeOptions)((Object)cell.getColumnKey())), new ArrayList());
                }
            }
            for (Object branch22 : branchVals.keySet()) {
                fm = ((LogicTreeBranch)branch22).getValue(FaultModels.class);
                Integer index = (Integer)((Map)fmIndexMaps.get(fm)).get(trace);
                if (index == null) continue;
                List fmTimeDepVals = (List)fmTimeDepValsMap.get(fm);
                List fmTimeDepWeights = (List)fmTimeDepWeightsMap.get(fm);
                if (fmTimeDepVals == null) {
                    fmTimeDepVals = Lists.newArrayList();
                    fmTimeDepValsMap.put(fm, fmTimeDepVals);
                    fmTimeDepWeights = Lists.newArrayList();
                    fmTimeDepWeightsMap.put(fm, fmTimeDepWeights);
                }
                SectProbGainResults val = ((SectProbGainResults[])branchVals.get(branch22))[index];
                timeDepVals.add(val.pTimeDep);
                fmTimeDepVals.add(val.pTimeDep);
                poisVals.add(val.pPois);
                gainVals.add(val.pGain);
                double weight = weightProv.getWeight((U3LogicTreeBranch)branch22);
                weights.add(weight);
                fmTimeDepWeights.add(weight);
                if (bptOpsValsTable == null) continue;
                for (Table.Cell cell : table.cellSet()) {
                    ((List)bptOpsValsTable.get(cell.getRowKey(), cell.getColumnKey())).add(((SectProbGainResults[])((Map)table.get((Object)cell.getRowKey(), (Object)cell.getColumnKey())).get((Object)branch22))[index.intValue()].pTimeDep);
                }
            }
            double[] timeDepValsArray = Doubles.toArray((Collection)timeDepVals);
            branch22 = fmTimeDepValsMap.keySet().iterator();
            while (branch22.hasNext()) {
                fm = (FaultModels)branch22.next();
                if (parents) break;
                List fmTimeDepVals = (List)fmTimeDepValsMap.get(fm);
                double[] fmTimeDepValsArray = Doubles.toArray((Collection)fmTimeDepVals);
                Object fmWeightsArray = Doubles.toArray((Collection)((Collection)fmTimeDepWeightsMap.get(fm)));
                int subSectIndex = (Integer)fmSubSectIndexMap.get((Object)fm, (Object)trace.name);
                double[] fmMeanTimeDep = (double[])fmMeanTimeDepVals.get(fm);
                if (fmMeanTimeDep == null) {
                    fmMeanTimeDep = new double[fmSubSectIndexMap.row((Object)fm).size()];
                    fmMeanTimeDepVals.put(fm, fmMeanTimeDep);
                }
                fmMeanTimeDep[subSectIndex] = U3FaultSystemSolutionFetcher.calcScaledAverage(fmTimeDepValsArray, (double[])fmWeightsArray);
            }
            double[] poisValsArray = Doubles.toArray((Collection)poisVals);
            double[] weightsArray = Doubles.toArray((Collection)weights);
            if (table.rowKeySet().size() == 1) {
                timeDepAllValsArray = timeDepValsArray;
            } else {
                ArrayList timeDepAllVals = Lists.newArrayList();
                for (Table.Cell cell : table.cellSet()) {
                    Map cellMap = (Map)cell.getValue();
                    for (U3LogicTreeBranch branch3 : cellMap.keySet()) {
                        FaultModels fm2 = branch3.getValue(FaultModels.class);
                        Integer index = (Integer)((Map)fmIndexMaps.get(fm2)).get(trace);
                        if (index == null) continue;
                        timeDepAllVals.add(((SectProbGainResults[])cellMap.get((Object)branch3))[index.intValue()].pTimeDep);
                    }
                }
                timeDepAllVals.addAll(poisVals);
                timeDepAllValsArray = Doubles.toArray((Collection)timeDepAllVals);
            }
            double meanTimeDep = U3FaultSystemSolutionFetcher.calcScaledAverage(timeDepValsArray, weightsArray);
            double minTimeDep = StatUtils.min((double[])timeDepAllValsArray);
            double maxTimeDep = StatUtils.max((double[])timeDepAllValsArray);
            double meanPois = U3FaultSystemSolutionFetcher.calcScaledAverage(poisValsArray, weightsArray);
            double gainU3 = FaultSysSolutionERF_Calc.weightedAvgNonZero(gainVals, weights);
            double oi = (Double)meanYearsSinceMap.get(trace);
            double fractWith = fractWithYearsSinceMap == null ? (Double.isNaN(oi) ? 0.0 : 1.0) : (Double)fractWithYearsSinceMap.get(trace);
            ArrayList line = Lists.newArrayList((Object[])new String[]{trace.name, "" + fractWith, "" + oi, "" + meanTimeDep, "" + minTimeDep, "" + maxTimeDep, "" + meanPois, "" + gainU3});
            if (parents) {
                double gainU3U2;
                double meanU2 = Double.NaN;
                double minU2 = Double.NaN;
                double maxU2 = Double.NaN;
                double meanU2pois = Double.NaN;
                ArrayList<IncrementalMagFreqDist> mfds = UCERF2_Section_TimeDepMFDsCalc.getMeanMinAndMaxMFD(trace.parentID, true, true);
                if (mfds != null) {
                    IncrementalMagFreqDist meanU2MFD = mfds.get(0);
                    IncrementalMagFreqDist minU2MFD = mfds.get(1);
                    IncrementalMagFreqDist maxU2MFD = mfds.get(2);
                    IncrementalMagFreqDist meanU2IndepMFD = UCERF2_Section_MFDsCalc.getMeanMinAndMaxMFD(trace.parentID, true, true).get(0);
                    meanU2MFD.scale(1.0309278350515465);
                    minU2MFD.scale(1.0309278350515465);
                    maxU2MFD.scale(1.0309278350515465);
                    meanU2IndepMFD.scale(1.0309278350515465);
                    meanU2 = FaultSysSolutionERF_Calc.calcProbAboveMagFromMFD(meanU2MFD, minMag, duration);
                    minU2 = FaultSysSolutionERF_Calc.calcProbAboveMagFromMFD(minU2MFD, minMag, duration);
                    maxU2 = FaultSysSolutionERF_Calc.calcProbAboveMagFromMFD(maxU2MFD, minMag, duration);
                    meanU2pois = FaultSysSolutionERF_Calc.calcProbAboveMagFromMFD(meanU2IndepMFD, minMag, duration);
                }
                dArray[i] = gainU3U2 = meanTimeDep / meanU2;
                line.addAll(Lists.newArrayList((Object[])new String[]{"" + meanU2, "" + minU2, "" + maxU2, "" + meanU2pois, "" + gainU3U2}));
            }
            csv.addLine(line);
            meanTimeDepVals[i] = meanTimeDep;
            minTimeDepVals[i] = minTimeDep;
            maxTimeDepVals[i] = maxTimeDep;
            gainU3Vals[i] = gainU3;
            if (meanBPT_COVVals != null) {
                for (Object theCOV : meanBPT_COVVals.keySet()) {
                    if (theCOV == null) continue;
                    ArrayList avgVals = Lists.newArrayList();
                    for (Table.Cell cell : bptOpsValsTable.cellSet()) {
                        if (cell.getRowKey() != theCOV) continue;
                        double[] bptCOV_ValsArray = Doubles.toArray((Collection)((Collection)cell.getValue()));
                        avgVals.add(U3FaultSystemSolutionFetcher.calcScaledAverage(bptCOV_ValsArray, weightsArray));
                    }
                    Preconditions.checkState((!avgVals.isEmpty() ? 1 : 0) != 0);
                    ((double[])meanBPT_COVVals.get((Object)theCOV))[i] = StatUtils.mean((double[])Doubles.toArray((Collection)avgVals));
                }
                if (isWeightedMultiCOV) {
                    Object theCOV;
                    ArrayList branchPoisVals = Lists.newArrayList();
                    theCOV = branchVals.keySet().iterator();
                    while (theCOV.hasNext()) {
                        U3LogicTreeBranch branch4 = (U3LogicTreeBranch)theCOV.next();
                        FaultModels fm3 = branch4.getValue(FaultModels.class);
                        Integer index = (Integer)((Map)fmIndexMaps.get(fm3)).get(trace);
                        if (index == null) continue;
                        SectProbGainResults val = ((SectProbGainResults[])branchVals.get(branch4))[index];
                        branchPoisVals.add(val.pPois);
                    }
                    ((double[])meanBPT_COVVals.get(null))[i] = U3FaultSystemSolutionFetcher.calcScaledAverage(Doubles.toArray((Collection)branchPoisVals), weightsArray);
                }
            }
            if (meanBPT_CalcVals != null) {
                for (BPTAveragingTypeOptions theAve : meanBPT_CalcVals.keySet()) {
                    ArrayList avgVals = Lists.newArrayList();
                    ArrayList cellWeights = Lists.newArrayList();
                    for (Table.Cell cell : bptOpsValsTable.cellSet()) {
                        if (cell.getColumnKey() != theAve) continue;
                        double[] bptCOV_ValsArray = Doubles.toArray((Collection)((Collection)cell.getValue()));
                        avgVals.add(U3FaultSystemSolutionFetcher.calcScaledAverage(bptCOV_ValsArray, weightsArray));
                        if (isWeightedMultiCOV) {
                            cellWeights.add(FaultSystemSolutionERF.getWeightForCOV((MagDependentAperiodicityOptions)((Object)cell.getRowKey())));
                            continue;
                        }
                        cellWeights.add(1.0);
                    }
                    if (isWeightedMultiCOV) {
                        avgVals.add(meanPois);
                        cellWeights.add(FaultSystemSolutionERF.getWeightForCOV(null));
                        Preconditions.checkState((avgVals.size() == 4 ? 1 : 0) != 0);
                        Preconditions.checkState((cellWeights.size() == 4 ? 1 : 0) != 0);
                    }
                    double mean = U3FaultSystemSolutionFetcher.calcScaledAverage(Doubles.toArray((Collection)avgVals), Doubles.toArray((Collection)cellWeights));
                    Preconditions.checkState((!avgVals.isEmpty() ? 1 : 0) != 0);
                    ((double[])meanBPT_CalcVals.get((Object)((Object)theAve)))[i] = mean;
                }
            }
            if ((parentVals = (List)meanMap.get(trace.parentID)) == null) {
                parentVals = Lists.newArrayList();
                meanMap.put(trace.parentID, parentVals);
            }
            parentVals.add(meanTimeDep);
        }
        File csvFile = parents ? new File(outputDir, "branch_aggregated_parents.csv") : new File(outputDir, "branch_aggregated_subs.csv");
        csv.writeToFile(csvFile);
        CPT ratioCPT = FaultSysSolutionERF_Calc.getScaledLinearRatioCPT(0.02);
        CaliforniaRegions.RELM_COLLECTION region = new CaliforniaRegions.RELM_COLLECTION();
        if (parents) {
            FaultBasedMapGen.makeFaultPlot(ratioCPT, traces, dArray, region, outputDir, "gain_u3_u2", false, true, "UCERF3/UCERF2 Time Dep Ratio");
            return meanMap;
        }
        File comparePlotsDir = new File(outputDir, "branch_ratios");
        if (!comparePlotsDir.exists()) {
            comparePlotsDir.mkdir();
        }
        BranchSensitivityHistogram branchSensHist = new BranchSensitivityHistogram("Ratio");
        for (Class<U3LogicTreeBranchNode<?>> clazz : U3LogicTreeBranch.getLogicTreeNodeClasses()) {
            if (clazz.equals(InversionModels.class) || clazz.equals(MomentRateFixes.class)) continue;
            String className2 = ClassUtils.getClassNameWithoutPackage(clazz);
            U3LogicTreeBranchNode<?>[] choices = clazz.getEnumConstants();
            ArrayList allVals = Lists.newArrayList();
            for (U3LogicTreeBranchNode<?> choice : choices) {
                if (choice.getRelativeWeight(InversionModels.CHAR_CONSTRAINED) <= 0.0) continue;
                double[] choiceVals = new double[meanTimeDepVals.length];
                double[] weightTots = new double[meanTimeDepVals.length];
                for (U3LogicTreeBranch branch : branchVals.keySet()) {
                    if (branch.getValueUnchecked(clazz) != choice) continue;
                    FaultModels fm = branch.getValue(FaultModels.class);
                    double weight = weightProv.getWeight(branch);
                    SectProbGainResults[] vals = (SectProbGainResults[])branchVals.get(branch);
                    for (int i = 0; i < traceComps.size(); ++i) {
                        double val;
                        FaultTraceComparable trace = (FaultTraceComparable)traceComps.get(i);
                        Integer index = (Integer)((Map)fmIndexMaps.get(fm)).get(trace);
                        if (index == null || Double.isNaN(val = vals[index.intValue()].pTimeDep)) continue;
                        int n = i;
                        choiceVals[n] = choiceVals[n] + val * weight;
                        int n2 = i;
                        weightTots[n2] = weightTots[n2] + weight;
                    }
                }
                for (int i = 0; i < choiceVals.length; ++i) {
                    int n = i;
                    choiceVals[n] = choiceVals[n] / weightTots[i];
                }
                double[] ratios = new double[choiceVals.length];
                for (int i = 0; i < ratios.length; ++i) {
                    ratios[i] = choiceVals[i] / meanTimeDepVals[i];
                }
                String prefix = (String)className2 + "_" + choice.encodeChoiceString();
                String plotLabel = choice.encodeChoiceString() + "/Mean";
                double choiceWeight = choice.getRelativeWeight(InversionModels.CHAR_CONSTRAINED);
                FaultBasedMapGen.makeFaultPlot(ratioCPT, traces, ratios, region, comparePlotsDir, prefix, false, true, plotLabel);
                double[] dArray2 = ratios;
                int n = dArray2.length;
                for (int trace = 0; trace < n; ++trace) {
                    double ratio = dArray2[trace];
                    if (!Doubles.isFinite((double)ratio)) continue;
                    branchSensHist.addValue(className2, choice.getShortName(), ratio, choiceWeight);
                }
                allVals.addAll(FaultSysSolutionERF_Calc.getNonNanInfinites(ratios));
            }
            double stdDev = Math.sqrt(StatUtils.variance((double[])Doubles.toArray((Collection)allVals)));
            System.out.println((String)className2 + " orig sigma: " + stdDev);
        }
        if (meanBPT_COVVals != null) {
            className = "MagDepAperiodicity";
            ArrayList allVals = Lists.newArrayList();
            for (MagDependentAperiodicityOptions theCOV : meanBPT_COVVals.keySet()) {
                String name = theCOV == null ? "POISSON" : theCOV.name();
                double[] choiceVals = (double[])meanBPT_COVVals.get((Object)theCOV);
                double[] ratios = new double[choiceVals.length];
                for (int i = 0; i < ratios.length; ++i) {
                    ratios[i] = choiceVals[i] / meanTimeDepVals[i];
                }
                String prefix = "MagDepAperiodicity_" + name;
                String plotLabel = name + "/Mean";
                FaultBasedMapGen.makeFaultPlot(ratioCPT, traces, ratios, region, comparePlotsDir, prefix, false, true, plotLabel);
                double weight = FaultSystemSolutionERF.getWeightForCOV(theCOV);
                for (double ratio : ratios) {
                    if (!Doubles.isFinite((double)ratio)) continue;
                    branchSensHist.addValue(className, name, ratio, weight);
                }
                allVals.addAll(FaultSysSolutionERF_Calc.getNonNanInfinites(ratios));
            }
            double stdDev = Math.sqrt(StatUtils.variance((double[])Doubles.toArray((Collection)allVals)));
            System.out.println(className + " orig sigma: " + stdDev);
        }
        if (meanBPT_CalcVals != null) {
            className = "BPTAveType";
            double maxDiff = 0.0;
            ArrayList diffVals = Lists.newArrayList();
            ArrayList diffLabels = Lists.newArrayList();
            ArrayList diffPrefixes = Lists.newArrayList();
            ArrayList allVals = Lists.newArrayList();
            for (BPTAveragingTypeOptions theAve : meanBPT_CalcVals.keySet()) {
                double[] choiceVals = (double[])meanBPT_CalcVals.get((Object)theAve);
                double[] ratios = new double[choiceVals.length];
                for (int i = 0; i < ratios.length; ++i) {
                    ratios[i] = choiceVals[i] / meanTimeDepVals[i];
                }
                String prefix = "BPTAveType_" + theAve.getFileSafeLabel();
                String plotLabel = theAve.getCompactLabel() + "/Mean";
                FaultBasedMapGen.makeFaultPlot(ratioCPT, traces, ratios, region, comparePlotsDir, prefix, false, true, plotLabel);
                double[] diffs = new double[choiceVals.length];
                for (int i = 0; i < diffs.length; ++i) {
                    diffs[i] = choiceVals[i] - meanTimeDepVals[i];
                }
                maxDiff = Math.max(maxDiff, Math.max(Math.abs(StatUtils.max((double[])diffs)), Math.abs(StatUtils.min((double[])diffs))));
                diffVals.add(diffs);
                diffLabels.add(theAve.getCompactLabel() + " - Mean");
                diffPrefixes.add("BPTAveType_diff_" + theAve.getFileSafeLabel());
                CSVFile<String> diffCSV = new CSVFile<String>(true);
                diffCSV.addLine("Subsection Index", "Ave Type Val", "Mean Val", "Diff", "Ratio");
                for (int i = 0; i < diffs.length; ++i) {
                    diffCSV.addLine("" + i, "" + choiceVals[i], "" + meanTimeDepVals[i], "" + diffs[i], "" + ratios[i]);
                }
                diffCSV.writeToFile(new File(comparePlotsDir, prefix + ".csv"));
                for (double ratio : ratios) {
                    if (!Doubles.isFinite((double)ratio)) continue;
                    branchSensHist.addValue(className, theAve.getFileSafeLabel(), ratio, 1.0);
                }
                allVals.addAll(FaultSysSolutionERF_Calc.getNonNanInfinites(ratios));
            }
            double stdDev = Math.sqrt(StatUtils.variance((double[])Doubles.toArray((Collection)allVals)));
            System.out.println(className + " orig sigma: " + stdDev);
            maxDiff = Math.ceil(maxDiff * 100.0) / 100.0;
            CPT diffCPT = ratioCPT.rescale(-maxDiff, maxDiff);
            for (int i = 0; i < diffVals.size(); ++i) {
                FaultBasedMapGen.makeFaultPlot(diffCPT, traces, (double[])diffVals.get(i), region, comparePlotsDir, (String)diffPrefixes.get(i), false, true, (String)diffLabels.get(i));
            }
        }
        Map<String, PlotSpec> histPlots = branchSensHist.getStackedHistPlots(false, 0.0, 21, 0.1);
        for (String categoryName : histPlots.keySet()) {
            PlotSpec spec = histPlots.get(categoryName);
            double mean = branchSensHist.calcMean(categoryName);
            double stdDev = branchSensHist.calcStdDev(categoryName);
            System.out.println(categoryName + ": mean=" + mean + ", sigma=" + stdDev);
            XYTextAnnotation ann = new XYTextAnnotation("StdDev=" + new DecimalFormat("0.00").format(stdDev), 0.05, 0.95);
            ann.setFont(new Font("SansSerif", 0, 18));
            ann.setTextAnchor(TextAnchor.TOP_LEFT);
            spec.setPlotAnnotations(Lists.newArrayList((Object[])new XYTextAnnotation[]{ann}));
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            CommandLineInversionRunner.setFontSizes(gp);
            gp.drawGraphPanel(spec, false, false, new Range(0.0, 2.0), new Range(0.0, 1.0));
            File file = new File(comparePlotsDir, categoryName + "_hists");
            gp.getChartPanel().setSize(1000, 600);
            gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
            file = new File(file.getAbsolutePath() + "_small");
            gp.getChartPanel().setSize(500, 400);
            gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
            gp.saveAsPNG(file.getAbsolutePath() + ".png");
        }
        try {
            FaultSysSolutionERF_Calc.combineBranchSensHists(comparePlotsDir);
        }
        catch (DocumentException e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        CPT logProbCPT = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(-4.0, 0.0);
        FaultBasedMapGen.makeFaultPlot(logProbCPT, traces, FaultBasedMapGen.log10(meanTimeDepVals), region, outputDir, "mean_time_dep_prob", false, true, "UCERF3 Mean Time Dep Prob");
        FaultBasedMapGen.makeFaultKML(logProbCPT, traces, FaultBasedMapGen.log10(meanTimeDepVals), outputDir, "mean_time_dep_prob", false, 40, 4, "UCERF3 Mean Time Dep Prob");
        for (FaultModels fm : fmMeanTimeDepVals.keySet()) {
            if (parents) break;
            double[] fmVals = (double[])fmMeanTimeDepVals.get(fm);
            List fmTraces = (List)fmTracesMap.get(fm);
            FaultBasedMapGen.makeFaultPlot(logProbCPT, fmTraces, FaultBasedMapGen.log10(fmVals), region, outputDir, fm.name() + "_mean_time_dep_prob", false, true, fm.name() + " UCERF3 Mean Time Dep Prob");
            FaultBasedMapGen.makeFaultKML(logProbCPT, fmTraces, FaultBasedMapGen.log10(fmVals), outputDir, fm.name() + "_mean_time_dep_prob", false, 40, 4, fm.name() + " UCERF3 Mean Time Dep Prob");
        }
        FaultBasedMapGen.makeFaultPlot(logProbCPT, traces, FaultBasedMapGen.log10(minTimeDepVals), region, outputDir, "min_time_dep_prob", false, true, "UCERF3 Min Time Dep Prob");
        FaultBasedMapGen.makeFaultPlot(logProbCPT, traces, FaultBasedMapGen.log10(maxTimeDepVals), region, outputDir, "max_time_dep_prob", false, true, "UCERF3 Max Time Dep Prob");
        FaultBasedMapGen.makeFaultPlot(ratioCPT, traces, gainU3Vals, region, outputDir, "gain_u3", false, true, "UCERF3 Mean BPT/Poisson Prob Gain");
        return meanMap;
    }

    public static void combineBranchSensHists(File dir) throws IOException, DocumentException {
        File bptFile;
        ArrayList pdfFiles = Lists.newArrayList();
        ArrayList classNames = Lists.newArrayList();
        for (Class<U3LogicTreeBranchNode<?>> clazz : U3LogicTreeBranch.getLogicTreeNodeClasses()) {
            if (clazz.equals(InversionModels.class) || clazz.equals(MomentRateFixes.class)) continue;
            String name = ClassUtils.getClassNameWithoutPackage(clazz);
            classNames.add(name);
        }
        Collections.sort(classNames);
        for (String name : classNames) {
            File pdfFile = new File(dir, name + "_hists_small.pdf");
            Preconditions.checkState((boolean)pdfFile.exists(), (Object)("File doesn't exist: " + pdfFile.getAbsolutePath()));
            pdfFiles.add(pdfFile);
        }
        File covFile = new File(dir, "MagDepAperiodicity_hists_small.pdf");
        if (covFile.exists()) {
            pdfFiles.add(covFile);
        }
        if ((bptFile = new File(dir, "BPTAveType_hists_small.pdf")).exists()) {
            pdfFiles.add(bptFile);
        }
        File outputFile = new File(dir, "histograms_combined.pdf");
        FaultSysSolutionERF_Calc.combineBranchSensHists(pdfFiles, outputFile);
    }

    public static void combineBranchSensHists(List<File> pdfFiles, File outputFile) throws IOException, DocumentException {
        int cols = 3;
        double scale = 0.4;
        boolean rotate = false;
        double xMarginBuffFract = 0.02;
        double yMarginBuffFract = 0.05;
        double xPosMult = 0.96;
        double yPosMult = 0.95;
        TestPDFCombine.combine(pdfFiles, outputFile, cols, scale, rotate, xMarginBuffFract, yMarginBuffFract, xPosMult, yPosMult);
    }

    private static List<Double> getNonNanInfinites(double[] vals) {
        ArrayList nonNanRatios = Lists.newArrayList();
        for (double ratio : vals) {
            if (Double.isNaN(ratio) || Double.isInfinite(ratio)) continue;
            nonNanRatios.add(ratio);
        }
        return nonNanRatios;
    }

    private static void writeBranchAggregatedFaultResults(Table<MagDependentAperiodicityOptions, BPTAveragingTypeOptions, Map<U3LogicTreeBranch, SectProbGainResults[]>> table, File outputDir, double minMag, double duration) throws IOException {
        boolean isWeightedMultiCOV;
        HashMap branchVals = Maps.newHashMap();
        double avgTypeWeight = 1.0 / (double)table.columnKeySet().size();
        double totCellWeight = 0.0;
        boolean bl = isWeightedMultiCOV = table.rowKeySet().size() == 3 && table.rowKeySet().contains((Object)MagDependentAperiodicityOptions.LOW_VALUES) && table.rowKeySet().contains((Object)MagDependentAperiodicityOptions.MID_VALUES) && table.rowKeySet().contains((Object)MagDependentAperiodicityOptions.HIGH_VALUES);
        if (isWeightedMultiCOV) {
            System.out.println("Multiple/Weighted COV!");
            Map<U3LogicTreeBranch, SectProbGainResults[]> poisMap = FaultSysSolutionERF_Calc.calcPoissonValues(table);
            double pw = 0.2;
            for (U3LogicTreeBranch branch : poisMap.keySet()) {
                SectProbGainResults[] poisResults = poisMap.get(branch);
                SectProbGainResults[] scaledResults = new SectProbGainResults[poisResults.length];
                for (int i = 0; i < poisResults.length; ++i) {
                    SectProbGainResults pois = poisResults[i];
                    scaledResults[i] = new SectProbGainResults(pw * pois.recurrInt, pw * pois.openInt, pw * pois.pPois, pw * pois.pTimeDep, pw * pois.pGain, pw * pois.implGain);
                }
                branchVals.put(branch, scaledResults);
            }
            totCellWeight += pw;
        }
        for (Table.Cell cell : table.cellSet()) {
            double cellWeight = avgTypeWeight;
            if (isWeightedMultiCOV) {
                if ((cellWeight *= FaultSystemSolutionERF.getWeightForCOV((MagDependentAperiodicityOptions)((Object)cell.getRowKey()))) == 0.0) {
                    throw new IllegalStateException("Multiple COV's only supported with low/mid/high (and all 3 must be present).");
                }
            } else {
                cellWeight *= 1.0 / (double)table.rowKeySet().size();
            }
            totCellWeight += cellWeight;
            Map subBranchMap = (Map)cell.getValue();
            for (U3LogicTreeBranch branch : subBranchMap.keySet()) {
                SectProbGainResults[] vals = (SectProbGainResults[])subBranchMap.get(branch);
                SectProbGainResults[] curVals = (SectProbGainResults[])branchVals.get(branch);
                if (curVals == null) {
                    curVals = new SectProbGainResults[vals.length];
                    for (int i = 0; i < curVals.length; ++i) {
                        curVals[i] = new SectProbGainResults(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                    }
                    branchVals.put(branch, curVals);
                }
                for (int j = 0; j < vals.length; ++j) {
                    curVals[j].recurrInt += vals[j].recurrInt * cellWeight;
                    curVals[j].openInt += vals[j].openInt * cellWeight;
                    curVals[j].pPois += vals[j].pPois * cellWeight;
                    curVals[j].pTimeDep += vals[j].pTimeDep * cellWeight;
                    curVals[j].pGain += vals[j].pGain * cellWeight;
                    curVals[j].implGain += vals[j].implGain * cellWeight;
                }
            }
        }
        Preconditions.checkState(((float)totCellWeight == 1.0f ? 1 : 0) != 0, (Object)("Total cell weight != 1: " + totCellWeight + ", isWeightedMultiCOV=" + isWeightedMultiCOV));
        Map<String, DiscretizedFunc[]> u2DepMPDs = null;
        Map<String, DiscretizedFunc[]> u2IndepMPDs = null;
        int u2FuncIndex = -1;
        if ((float)duration == 30.0f) {
            u2DepMPDs = FaultSysSolutionERF_Calc.loadUCERF2MainFaultMPDs(true, true);
            u2IndepMPDs = FaultSysSolutionERF_Calc.loadUCERF2MainFaultMPDs(true, false);
            u2FuncIndex = u2DepMPDs.values().iterator().next()[0].getXIndex(minMag);
            if (u2FuncIndex < 0) {
                u2DepMPDs = null;
                u2IndepMPDs = null;
            }
        }
        CSVFile csv = new CSVFile(true);
        ArrayList header = Lists.newArrayList((Object[])new String[]{"Name", "U3 Mean Time Dep", "U3 Min", "U3 Max", "U3 Time Indep", "U3 Time Dep/Time Indep"});
        if (u2DepMPDs != null) {
            header.addAll(Lists.newArrayList((Object[])new String[]{"U2 Mean Time Dep", "U2 Min", "U2 Max", "U2 Mean Time Indep", "U2 Time Dep/Time Indep", "U3 Time Dep / U2 Time Dep"}));
        }
        csv.addLine(header);
        ArrayList faultNames = Lists.newArrayList(FaultModels.parseNamedFaultsAltFile(UCERF3_DataUtils.getReader("FaultModels", "MainFaultsForTimeDepComparison.txt")).keySet());
        Collections.sort(faultNames);
        U3APrioriBranchWeightProvider weightProv = new U3APrioriBranchWeightProvider();
        for (int i = 0; i < faultNames.size(); ++i) {
            double[] timeDepAllValsArray;
            String name = (String)faultNames.get(i);
            ArrayList bptVals = Lists.newArrayList();
            ArrayList poisVals = Lists.newArrayList();
            ArrayList gainVals = Lists.newArrayList();
            ArrayList weights = Lists.newArrayList();
            for (U3LogicTreeBranch branch : branchVals.keySet()) {
                FaultModels fm = branch.getValue(FaultModels.class);
                if (name.contains("FM3.1") && fm == FaultModels.FM3_2 || name.contains("FM3.2") && fm == FaultModels.FM3_1) continue;
                SectProbGainResults val = ((SectProbGainResults[])branchVals.get(branch))[i];
                if (Double.isNaN(val.pTimeDep)) continue;
                bptVals.add(val.pTimeDep);
                poisVals.add(val.pPois);
                gainVals.add(val.pGain);
                weights.add(weightProv.getWeight(branch));
            }
            double[] bptValsArray = Doubles.toArray((Collection)bptVals);
            double[] poisValsArray = Doubles.toArray((Collection)poisVals);
            double[] weightsArray = Doubles.toArray((Collection)weights);
            if (table.rowKeySet().size() == 1) {
                timeDepAllValsArray = bptValsArray;
            } else {
                ArrayList timeDepAllVals = Lists.newArrayList();
                for (Table.Cell cell : table.cellSet()) {
                    Map cellMap = (Map)cell.getValue();
                    for (U3LogicTreeBranch branch : cellMap.keySet()) {
                        FaultModels fm = branch.getValue(FaultModels.class);
                        if (name.contains("FM3.1") && fm == FaultModels.FM3_2 || name.contains("FM3.2") && fm == FaultModels.FM3_1) continue;
                        timeDepAllVals.add(((SectProbGainResults[])cellMap.get((Object)branch))[i].pTimeDep);
                    }
                }
                timeDepAllVals.addAll(poisVals);
                timeDepAllValsArray = Doubles.toArray((Collection)timeDepAllVals);
            }
            double meanBPT = U3FaultSystemSolutionFetcher.calcScaledAverage(bptValsArray, weightsArray);
            double minBPT = StatUtils.min((double[])timeDepAllValsArray);
            double maxBPT = StatUtils.max((double[])timeDepAllValsArray);
            double meanPois = U3FaultSystemSolutionFetcher.calcScaledAverage(poisValsArray, weightsArray);
            double gainU3 = FaultSysSolutionERF_Calc.weightedAvgNonZero(gainVals, weights);
            ArrayList line = Lists.newArrayList((Object[])new String[]{name, "" + meanBPT, "" + minBPT, "" + maxBPT, "" + meanPois, "" + gainU3});
            if (u2DepMPDs != null) {
                DiscretizedFunc[] u2Funcs = u2DepMPDs.get(name);
                DiscretizedFunc[] u2IndepFuncs = u2IndepMPDs.get(name);
                double minU2 = u2Funcs[0].getY(u2FuncIndex);
                double maxU2 = u2Funcs[1].getY(u2FuncIndex);
                double meanU2 = u2Funcs[2].getY(u2FuncIndex);
                double meanIndepU2 = u2IndepFuncs[2].getY(u2FuncIndex);
                line.add("" + meanU2);
                line.add("" + minU2);
                line.add("" + maxU2);
                line.add("" + meanIndepU2);
                line.add("" + meanU2 / meanIndepU2);
                line.add("" + meanBPT / meanU2);
            }
            csv.addLine(line);
        }
        File csvFile = new File(outputDir, "branch_aggregated_main_faults.csv");
        csv.writeToFile(csvFile);
    }

    private static double calcProbAboveMagFromMFD(EvenlyDiscretizedFunc cmlMFD, double minMag, double duration) {
        Preconditions.checkState((minMag <= (cmlMFD = FaultSysSolutionERF_Calc.calcProbsFromSummedMFD(cmlMFD, duration)).getMaxX() ? 1 : 0) != 0);
        return cmlMFD.getClosestYtoX(minMag);
    }

    private static double weightedAvgNonZero(List<Double> vals, List<Double> weights) {
        double runningTot = 0.0;
        double totWeight = 0.0;
        for (int i = 0; i < vals.size(); ++i) {
            double val = vals.get(i);
            if (!(val > 0.0)) continue;
            double weight = weights.get(i);
            runningTot += val * weight;
            totWeight += weight;
        }
        if (runningTot == 0.0) {
            return Double.NaN;
        }
        return runningTot /= totWeight;
    }

    private static double minNonZero(List<Double> vals) {
        double min = Double.POSITIVE_INFINITY;
        for (double val : vals) {
            if (!(val > 0.0) || !(val < min)) continue;
            min = val;
        }
        if (Double.isInfinite(min)) {
            return Double.NaN;
        }
        return min;
    }

    private static double maxNonZero(List<Double> vals) {
        double max = 0.0;
        for (double val : vals) {
            if (!(val > 0.0) || !(val > max)) continue;
            max = val;
        }
        if (max == 0.0) {
            return Double.NaN;
        }
        return max;
    }

    private static List<Table<MagDependentAperiodicityOptions, BPTAveragingTypeOptions, Map<U3LogicTreeBranch, SectProbGainResults[]>>> loadBranchCSVVals(File file, int[] magRangeIndexes, boolean parents) throws ZipException, IOException {
        return FaultSysSolutionERF_Calc.loadBranchCSVVals(new File[]{file}, magRangeIndexes, parents);
    }

    private static List<Table<MagDependentAperiodicityOptions, BPTAveragingTypeOptions, Map<U3LogicTreeBranch, SectProbGainResults[]>>> loadBranchCSVVals(File[] files, int[] magRangeIndexes, boolean parents) throws ZipException, IOException {
        int[] colStarts = new int[magRangeIndexes.length];
        ArrayList maps = Lists.newArrayList();
        for (int i = 0; i < magRangeIndexes.length; ++i) {
            colStarts[i] = 2 + magRangeIndexes[i] * 7 + 1;
            HashBasedTable table = HashBasedTable.create();
            maps.add(table);
        }
        for (File file : files) {
            ZipFile zip = new ZipFile(file);
            for (ZipEntry zipEntry : Collections.list(zip.entries())) {
                try {
                    String name = zipEntry.getName().trim();
                    if (parents && !name.endsWith("parents.csv") || !parents && !name.endsWith("subs.csv")) continue;
                    int covEnd = name.lastIndexOf("/");
                    String namePrefix = name.substring(0, covEnd);
                    name = name.substring(covEnd + 1);
                    MagDependentAperiodicityOptions cov = null;
                    for (MagDependentAperiodicityOptions testCOV : MagDependentAperiodicityOptions.values()) {
                        if (!namePrefix.contains(testCOV.name())) continue;
                        cov = testCOV;
                        break;
                    }
                    Preconditions.checkNotNull(cov);
                    BPTAveragingTypeOptions aveType = null;
                    for (BPTAveragingTypeOptions testType : BPTAveragingTypeOptions.values()) {
                        String dirName = MPJ_ERF_ProbGainCalcScriptWriter.getAveDirName(testType);
                        if (!namePrefix.contains(dirName) && !file.getName().startsWith(dirName)) continue;
                        aveType = testType;
                        break;
                    }
                    Preconditions.checkNotNull(aveType);
                    U3LogicTreeBranch branch = U3LogicTreeBranch.fromFileName(name);
                    Preconditions.checkNotNull((Object)branch);
                    CSVFile<String> csv = CSVFile.readStream(zip.getInputStream(zipEntry), true);
                    for (int i = 0; i < magRangeIndexes.length; ++i) {
                        int colStart = colStarts[i];
                        Table table = (Table)maps.get(i);
                        Preconditions.checkState((boolean)csv.get(0, colStart).startsWith("Recur"));
                        SectProbGainResults[] vals = new SectProbGainResults[csv.getNumRows() - 1];
                        for (int row = 1; row < csv.getNumRows(); ++row) {
                            double recurrInt = Double.parseDouble(csv.get(row, colStart));
                            double openInt = Double.parseDouble(csv.get(row, colStart + 1));
                            double pPois = Double.parseDouble(csv.get(row, colStart + 2));
                            double pBPT = Double.parseDouble(csv.get(row, colStart + 3));
                            double pGain = Double.parseDouble(csv.get(row, colStart + 4));
                            double implGain = Double.parseDouble(csv.get(row, colStart + 5));
                            int index = parents ? row - 1 : Integer.parseInt(csv.get(row, 1));
                            vals[index] = new SectProbGainResults(recurrInt, openInt, pPois, pBPT, pGain, implGain);
                        }
                        Map branchVals = (Map)table.get((Object)cov, (Object)aveType);
                        if (branchVals == null) {
                            branchVals = Maps.newHashMap();
                            table.put((Object)cov, (Object)aveType, (Object)branchVals);
                        }
                        Preconditions.checkState((!branchVals.containsKey(branch) ? 1 : 0) != 0);
                        branchVals.put(branch, vals);
                    }
                }
                catch (RuntimeException e) {
                    System.out.println("Error on " + zipEntry.getName());
                    zip.close();
                    throw e;
                }
            }
            zip.close();
        }
        return maps;
    }

    private static void writeOpenIntTableComparisons() throws IOException, org.dom4j.DocumentException, GMT_MapException, RuntimeException {
        U3FaultSystemSolution sol = U3FaultSystemIO.loadSol(new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions"), "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
        Map<Integer, List<LastEventData>> ver9Data = LastEventData.load(UCERF3_DataUtils.locateResourceAsStream("paleoRateData", "UCERF3_OpenIntervals_ver9.xls"), new int[]{0, 1});
        Map<Integer, List<LastEventData>> ver9RCFData = LastEventData.load(UCERF3_DataUtils.locateResourceAsStream("paleoRateData", "UCERF3_OpenIntervals_ver9.xls"), new int[]{0, 2});
        Map<Integer, List<LastEventData>> ver8Data = LastEventData.load(UCERF3_DataUtils.locateResourceAsStream("paleoRateData", "UCERF3_OpenIntervals_ver8.xls"), new int[]{0, 1});
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(sol);
        LastEventData.populateSubSects(((FaultSystemSolution)sol).getRupSet().getFaultSectionDataList(), ver9Data);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        erf.getTimeSpan().setDuration(30.0);
        EvenlyDiscretizedFunc[] ver9Vals = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 6.7, 1, 0.1);
        LastEventData.populateSubSects(((FaultSystemSolution)sol).getRupSet().getFaultSectionDataList(), ver8Data);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        EvenlyDiscretizedFunc[] ver8Vals = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 6.7, 1, 0.1);
        LastEventData.populateSubSects(((FaultSystemSolution)sol).getRupSet().getFaultSectionDataList(), ver9RCFData);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        EvenlyDiscretizedFunc[] ver9RCFVals = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 6.7, 1, 0.1);
        double[] ver9_8_ratios = new double[ver9Vals.length];
        double[] ver9RCF_9_ratios = new double[ver9Vals.length];
        for (int i = 0; i < ver9Vals.length; ++i) {
            ver9_8_ratios[i] = ver9Vals[i].getY(0) / ver8Vals[i].getY(0);
            ver9RCF_9_ratios[i] = ver9RCFVals[i].getY(0) / ver9Vals[i].getY(0);
        }
        CPT ratioCPT = FaultSysSolutionERF_Calc.getScaledLinearRatioCPT(0.02);
        ArrayList<LocationList> traces = FaultBasedMapGen.getTraces(((FaultSystemSolution)sol).getRupSet().getFaultSectionDataList());
        CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
        File dir = new File("/tmp");
        FaultBasedMapGen.makeFaultPlot(ratioCPT, traces, ver9_8_ratios, region, dir, "oi_table_m6.7_30yr_ver9_ver8_ratio", false, true, "M>=6.7 30yr Prob, OI Table Ver9 / Ver8");
        FaultBasedMapGen.makeFaultPlot(ratioCPT, traces, ver9RCF_9_ratios, region, dir, "oi_table_m6.7_30yr_ver9_RCF_ver9_ratio", false, true, "M>=6.7 30yr Prob, OI Table Ver9_RCF / Ver9");
    }

    public static List<Table<MagDependentAperiodicityOptions, BPTAveragingTypeOptions, Map<U3LogicTreeBranch, SectProbGainResults[]>>> loadBranchFaultCSVVals(File[] files, int[] magRangeIndexes) throws ZipException, IOException {
        int[] colStarts = new int[magRangeIndexes.length];
        ArrayList maps = Lists.newArrayList();
        for (int i = 0; i < magRangeIndexes.length; ++i) {
            colStarts[i] = 1 + magRangeIndexes[i] * 3 + 1;
            HashBasedTable table = HashBasedTable.create();
            maps.add(table);
        }
        for (File file : files) {
            ZipFile zip = new ZipFile(file);
            for (ZipEntry zipEntry : Collections.list(zip.entries())) {
                String name = zipEntry.getName().trim();
                if (!name.endsWith("main_faults.csv")) continue;
                int covEnd = name.lastIndexOf("/");
                String namePrefix = name.substring(0, covEnd);
                name = name.substring(covEnd + 1);
                MagDependentAperiodicityOptions cov = null;
                for (MagDependentAperiodicityOptions testCOV : MagDependentAperiodicityOptions.values()) {
                    if (!namePrefix.contains(testCOV.name())) continue;
                    cov = testCOV;
                    break;
                }
                Preconditions.checkNotNull(cov);
                BPTAveragingTypeOptions aveType = null;
                for (BPTAveragingTypeOptions testType : BPTAveragingTypeOptions.values()) {
                    String dirName = MPJ_ERF_ProbGainCalcScriptWriter.getAveDirName(testType);
                    if (!namePrefix.contains(dirName) && !file.getName().startsWith(dirName)) continue;
                    aveType = testType;
                    break;
                }
                Preconditions.checkNotNull(aveType);
                U3LogicTreeBranch branch = U3LogicTreeBranch.fromFileName(name);
                Preconditions.checkNotNull((Object)branch);
                CSVFile<String> csv = CSVFile.readStream(zip.getInputStream(zipEntry), true);
                for (int i = 0; i < magRangeIndexes.length; ++i) {
                    int colStart = colStarts[i];
                    Table table = (Table)maps.get(i);
                    Preconditions.checkState((boolean)csv.get(0, colStart).startsWith("U3 pBPT"));
                    SectProbGainResults[] vals = new SectProbGainResults[csv.getNumRows() - 1];
                    double recurrInt = Double.NaN;
                    double openInt = Double.NaN;
                    double implGain = Double.NaN;
                    for (int row = 1; row < csv.getNumRows(); ++row) {
                        double pBPT = Double.parseDouble(csv.get(row, colStart));
                        double pPois = Double.parseDouble(csv.get(row, colStart + 1));
                        double pGain = pBPT / pPois;
                        int index = row - 1;
                        vals[index] = new SectProbGainResults(recurrInt, openInt, pPois, pBPT, pGain, implGain);
                    }
                    Map branchVals = (Map)table.get((Object)cov, (Object)aveType);
                    if (branchVals == null) {
                        branchVals = Maps.newHashMap();
                        table.put((Object)cov, (Object)aveType, (Object)branchVals);
                    }
                    Preconditions.checkState((!branchVals.containsKey(branch) ? 1 : 0) != 0);
                    branchVals.put(branch, vals);
                }
            }
        }
        return maps;
    }

    public static void writeTimeDepPlotsForWeb(List<BPTAveragingTypeOptions> aveTypes, boolean skipAvgMethods, String dirPrefix, File outputDir) throws IOException, org.dom4j.DocumentException, GMT_MapException, RuntimeException {
        U3FaultSystemSolution meanSol = U3FaultSystemIO.loadSol(new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions"), "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
        FaultSysSolutionERF_Calc.writeTimeDepPlotsForWeb(aveTypes, skipAvgMethods, dirPrefix, outputDir, meanSol);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeTimeDepPlotsForWeb(List<BPTAveragingTypeOptions> aveTypes, boolean skipAvgMethods, String dirPrefix, File outputDir, FaultSystemSolution meanSol) throws IOException, org.dom4j.DocumentException, GMT_MapException, RuntimeException {
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        double[] minMags = new double[]{0.0, 6.7, 7.7};
        int[] csvMagRangeIndexes = new int[]{4, 0, 2};
        int[] csvFaultMagRangeIndexes = new int[]{0, 1, 3};
        double[] durations = new double[]{5.0, 30.0};
        File[] csvDirs = new File[]{new File(dirPrefix + "-5yr"), new File(dirPrefix + "-30yr")};
        File[] csvMainFaultDirs = new File[]{new File(dirPrefix + "-main-5yr"), new File(dirPrefix + "-main-30yr")};
        Preconditions.checkState((aveTypes.size() >= 1 ? 1 : 0) != 0);
        Object[] csvZipNames = new String[aveTypes.size()];
        for (int i = 0; i < aveTypes.size(); ++i) {
            csvZipNames[i] = MPJ_ERF_ProbGainCalcScriptWriter.getAveDirName(aveTypes.get(i)) + ".zip";
        }
        int def_hist_open_ref = 1875;
        FileWriter fw = new FileWriter(new File(outputDir, "metadata.txt"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd 'at' HH:mm:ss z");
        fw.write("Directory and plots generated by " + FaultSysSolutionERF_Calc.class.getName() + ".writeTimeDepPlotsForWeb()\n");
        fw.write("Which calls and aggregates plots from " + FaultSysSolutionERF_Calc.class.getName() + ".writeBranchAggregatedFigs(...)\n");
        fw.write("Date: " + df.format(new Date()) + "\n");
        fw.write("Averaging types: " + Joiner.on((String)", ").join(aveTypes) + "\n");
        fw.write("\n");
        String zipNames = csvZipNames.length == 1 ? "/" + csvZipNames[0] : "/[" + Joiner.on((String)",").join((Iterable)Lists.newArrayList((Object[])csvZipNames)) + "]";
        for (int i = 0; i < durations.length; ++i) {
            fw.write((int)durations[i] + "yr data loaded from " + csvDirs[i].getName() + zipNames + "\n");
        }
        fw.write("\n");
        fw.write("Data is generated by " + FaultSysSolutionERF_Calc.class.getName() + ".writeSubSectionTimeDependenceCSV(erf, subOutputFile) and " + FaultSysSolutionERF_Calc.class.getName() + ".writeParentSectionTimeDependenceCSV(erf, subOutputFile). Results are calculated for each logic tree branch in parallel on a cluster with " + MPJ_ERF_ProbGainCalc.class.getName() + ". See also " + MPJ_ERF_ProbGainCalcScriptWriter.class.getName() + " for batch submission script generation. Each zip file contains data files for each mag-dependent apreriodicity funcion. Note that data aggregated for 'main faults' is calculated separately, also by MPJ_ERF_ProbGainCalc with the --main-faults argument.");
        fw.close();
        ArrayList labels = Lists.newArrayList();
        ArrayList parentSectFiles = Lists.newArrayList();
        ArrayList mainFaultFiles = Lists.newArrayList();
        CaliforniaRegions.RELM_COLLECTION region = new CaliforniaRegions.RELM_COLLECTION();
        CPT tightRatioCPT = FaultSysSolutionERF_Calc.getScaledLinearRatioCPT(0.02, 0.8, 1.2);
        CPT wideRatioCPT = FaultSysSolutionERF_Calc.getScaledLinearRatioCPT(0.02);
        for (int i = 0; i < durations.length; ++i) {
            double duration = durations[i];
            File[] csvZipFiles = new File[csvZipNames.length];
            File[] csvMainFualtZipFiles = new File[csvZipNames.length];
            for (int j = 0; j < csvZipNames.length; ++j) {
                Object csvZipName = csvZipNames[j];
                csvZipFiles[j] = new File(csvDirs[i], (String)csvZipName);
                csvMainFualtZipFiles[j] = new File(csvMainFaultDirs[i], (String)csvZipName);
            }
            File avgTempDir = null;
            if (!skipAvgMethods) {
                FaultSystemSolutionERF meanERF = new FaultSystemSolutionERF(meanSol);
                meanERF.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
                meanERF.setParameter("Historic Open Interval", 2014 - def_hist_open_ref);
                meanERF.setParameter("Apply Aftershock Filter", false);
                meanERF.getTimeSpan().setDuration(duration);
                ArrayList avgTypes = Lists.newArrayList((Object[])BPTAveragingTypeOptions.values());
                avgTempDir = FileUtils.createTempDir();
                while (avgTypes.size() >= 2) {
                    int refIndex = 0;
                    FaultSysSolutionERF_Calc.makeAvgMethodProbGainMaps(meanERF, avgTempDir, null, avgTypes, refIndex);
                    avgTypes.remove(0);
                }
            }
            System.out.println("Loading all parent sect results from " + csvDirs[i].getAbsolutePath() + " (" + Joiner.on((String)",").join(csvZipNames) + ")");
            List<Table<MagDependentAperiodicityOptions, BPTAveragingTypeOptions, Map<U3LogicTreeBranch, SectProbGainResults[]>>> parentMaps = FaultSysSolutionERF_Calc.loadBranchCSVVals(csvZipFiles, csvMagRangeIndexes, true);
            System.out.println("Loading all sub sect results from " + csvDirs[i].getAbsolutePath() + " (" + Joiner.on((String)",").join(csvZipNames) + ")");
            List<Table<MagDependentAperiodicityOptions, BPTAveragingTypeOptions, Map<U3LogicTreeBranch, SectProbGainResults[]>>> subSectMaps = FaultSysSolutionERF_Calc.loadBranchCSVVals(csvZipFiles, csvMagRangeIndexes, false);
            System.out.println("Loading all main fault results from " + csvMainFaultDirs[i].getAbsolutePath() + " (" + Joiner.on((String)",").join(csvZipNames) + ")");
            List<Table<MagDependentAperiodicityOptions, BPTAveragingTypeOptions, Map<U3LogicTreeBranch, SectProbGainResults[]>>> mainFaultMaps = FaultSysSolutionERF_Calc.loadBranchFaultCSVVals(csvMainFualtZipFiles, csvFaultMagRangeIndexes);
            for (int j = 0; j < minMags.length; ++j) {
                int[] comps;
                File branchDir;
                Object fileLabel;
                Object label;
                FaultSystemSolutionERF meanERF = new FaultSystemSolutionERF(meanSol);
                meanERF.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_PREF_BLEND);
                meanERF.setParameter("Historic Open Interval", 2014 - def_hist_open_ref);
                meanERF.setParameter("Apply Aftershock Filter", false);
                if (csvZipNames.length == 1) {
                    meanERF.setParameter("BPT Averaging Type", (Object)aveTypes.get(0));
                }
                meanERF.getTimeSpan().setDuration(duration);
                double minMag = minMags[j];
                if (minMag == 0.0) {
                    label = "All Events";
                    fileLabel = "all";
                } else {
                    label = "M>=" + (float)minMag;
                    fileLabel = "m" + (float)minMag;
                }
                label = (String)label + ", " + (int)duration + "yr forecast";
                fileLabel = (String)fileLabel + "_" + (int)duration + "yr";
                File subDir = new File(outputDir, (String)fileLabel);
                if (!subDir.exists()) {
                    subDir.mkdir();
                }
                if (!(branchDir = new File(subDir, "BranchAveragedResults")).exists()) {
                    branchDir.mkdir();
                }
                File tmpResultsDir = FileUtils.createTempDir();
                System.out.println("Making " + (String)label + " sub section plots");
                Map<Integer, List<Double>> meanVals = FaultSysSolutionERF_Calc.writeBranchAggregatedTimeDepFigs(subSectMaps.get(j), tmpResultsDir, false, minMag, duration);
                System.out.println("Copying " + (String)label + " sub section plots");
                Files.copy((File)new File(tmpResultsDir, "mean_time_dep_prob.pdf"), (File)new File(branchDir, "U3_TimeDep_Mean.pdf"));
                Files.copy((File)new File(tmpResultsDir, "mean_time_dep_prob.kml"), (File)new File(branchDir, "U3_TimeDep_Mean.kml"));
                Files.copy((File)new File(tmpResultsDir, "FM3_1_mean_time_dep_prob.pdf"), (File)new File(branchDir, "U3_FM3_1_TimeDep_Mean.pdf"));
                Files.copy((File)new File(tmpResultsDir, "FM3_1_mean_time_dep_prob.kml"), (File)new File(branchDir, "U3_FM3_1_TimeDep_Mean.kml"));
                Files.copy((File)new File(tmpResultsDir, "FM3_2_mean_time_dep_prob.pdf"), (File)new File(branchDir, "U3_FM3_2_TimeDep_Mean.pdf"));
                Files.copy((File)new File(tmpResultsDir, "FM3_2_mean_time_dep_prob.kml"), (File)new File(branchDir, "U3_FM3_2_TimeDep_Mean.kml"));
                Files.copy((File)new File(tmpResultsDir, "min_time_dep_prob.pdf"), (File)new File(branchDir, "U3_TimeDep_Min.pdf"));
                Files.copy((File)new File(tmpResultsDir, "max_time_dep_prob.pdf"), (File)new File(branchDir, "U3_TimeDep_Max.pdf"));
                Files.copy((File)new File(tmpResultsDir, "gain_u3.pdf"), (File)new File(branchDir, "U3_Gain.pdf"));
                File branchSensDir = new File(subDir, "BranchSensitivityMaps");
                if (!branchSensDir.exists()) {
                    branchSensDir.mkdir();
                }
                for (File file : new File(tmpResultsDir, "branch_ratios").listFiles()) {
                    String name = file.getName();
                    if (!name.endsWith(".pdf") && !name.endsWith(".csv")) continue;
                    Files.copy((File)file, (File)new File(branchSensDir, name));
                }
                Files.copy((File)new File(tmpResultsDir, "branch_aggregated_subs.csv"), (File)new File(subDir, "sub_section_probabilities.csv"));
                FileUtils.deleteRecursive(tmpResultsDir);
                tmpResultsDir = FileUtils.createTempDir();
                System.out.println("Making " + (String)label + " parent section plots");
                FaultSysSolutionERF_Calc.writeBranchAggregatedTimeDepFigs(parentMaps.get(j), tmpResultsDir, true, minMag, duration);
                System.out.println("Copying " + (String)label + " parent section plots");
                File parentsDestCSV = new File(subDir, "parent_section_probabilities.csv");
                Files.copy((File)new File(tmpResultsDir, "branch_aggregated_parents.csv"), (File)parentsDestCSV);
                Files.copy((File)new File(tmpResultsDir, "gain_u3_u2.pdf"), (File)new File(branchDir, "U3_U2_TimeDep_Ratio.pdf"));
                labels.add(label);
                parentSectFiles.add(parentsDestCSV);
                FileUtils.deleteRecursive(tmpResultsDir);
                tmpResultsDir = FileUtils.createTempDir();
                System.out.println("Making " + (String)label + " main fault plots");
                FaultSysSolutionERF_Calc.writeBranchAggregatedFaultResults(mainFaultMaps.get(j), tmpResultsDir, minMag, duration);
                System.out.println("Copying " + (String)label + " main fault plots");
                File mainFaultsDestCSV = new File(subDir, "main_fault_probabilities.csv");
                Files.copy((File)new File(tmpResultsDir, "branch_aggregated_main_faults.csv"), (File)mainFaultsDestCSV);
                mainFaultFiles.add(mainFaultsDestCSV);
                FileUtils.deleteRecursive(tmpResultsDir);
                System.out.println("Done with " + (String)label);
                File sensTestDir = new File(subDir, "OtherSensitivityTests");
                if (!sensTestDir.exists()) {
                    sensTestDir.mkdir();
                }
                meanERF.getTimeSpan().setDuration(duration);
                meanERF.updateForecast();
                EvenlyDiscretizedFunc[] branchAvgResults = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(meanERF, minMag, 1, 0.5);
                double[] ratios = new double[branchAvgResults.length];
                double[] baProbs = new double[branchAvgResults.length];
                int prevParent = -1;
                int indexInParent = -1;
                ArrayList faults = Lists.newArrayList();
                for (FaultSection faultSection : meanSol.getRupSet().getFaultSectionDataList()) {
                    faults.add(faultSection.getFaultTrace());
                }
                for (int k = 0; k < ratios.length; ++k) {
                    double d = branchAvgResults[k].getY(0);
                    int n = meanSol.getRupSet().getFaultSectionData(k).getParentSectionId();
                    if (n == prevParent) {
                        ++indexInParent;
                    } else {
                        prevParent = n;
                        indexInParent = 0;
                    }
                    double meanProb = meanVals.get(n).get(indexInParent);
                    ratios[k] = d / meanProb;
                    baProbs[k] = d;
                }
                FaultBasedMapGen.makeFaultPlot(wideRatioCPT, faults, ratios, region, sensTestDir, "Branch_Averaged_vs_Mean_Ratio", false, true, "UCERF3 TimeDep Branch Averaged / True Mean");
                File avgMethodDir = new File(sensTestDir, "AveragingMethods");
                if (!avgMethodDir.exists()) {
                    avgMethodDir.mkdir();
                }
                if (minMag > 0.0) {
                    String string = "" + (float)minMag;
                } else {
                    String string = "supra_seis";
                }
                if (avgTempDir != null) {
                    for (File file : avgTempDir.listFiles()) {
                        void var52_67;
                        if (!file.getName().endsWith(".pdf") || !file.getName().contains((CharSequence)var52_67)) continue;
                        Files.copy((File)file, (File)new File(avgMethodDir, file.getName()));
                    }
                }
                for (int comp : comps = new int[]{2014, 1850, 1900}) {
                    meanERF.setParameter("Historic Open Interval", 2014 - comp);
                    meanERF.updateForecast();
                    EvenlyDiscretizedFunc[] histOpenResults = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(meanERF, minMag, 1, 0.5);
                    ratios = new double[baProbs.length];
                    for (int k = 0; k < baProbs.length; ++k) {
                        ratios[k] = histOpenResults[k].getY(0) / baProbs[k];
                    }
                    Object compStr = comp == 2014 ? "None" : "" + comp;
                    FaultBasedMapGen.makeFaultPlot(wideRatioCPT, faults, ratios, region, sensTestDir, "Hist_Open_Interval_Test_" + (String)compStr, false, true, "UCERF3 Time Dep Hist Open Interval " + (String)compStr + " / " + def_hist_open_ref);
                }
                for (File file : sensTestDir.listFiles()) {
                    if (!file.getName().endsWith(".png")) continue;
                    file.delete();
                }
            }
            if (avgTempDir == null) continue;
            FileUtils.deleteRecursive(avgTempDir);
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        for (int i = 0; i < labels.size(); ++i) {
            HSSFSheet sheet = wb.createSheet();
            wb.setSheetName(i, (String)labels.get(i));
            CSVFile<String> csv = CSVFile.readFile((File)parentSectFiles.get(i), true);
            HSSFRow header = sheet.createRow(0);
            for (int col = 0; col < csv.getNumCols(); ++col) {
                header.createCell(col).setCellValue(csv.get(0, col));
            }
            for (int row = 1; row < csv.getNumRows(); ++row) {
                HSSFRow r = sheet.createRow(row);
                r.createCell(0).setCellValue(csv.get(row, 0));
                for (int col = 1; col < csv.getNumCols(); ++col) {
                    r.createCell(col).setCellValue(Double.parseDouble(csv.get(row, col)));
                }
            }
        }
        wb.setActiveSheet(0);
        FileOutputStream out = new FileOutputStream(new File(outputDir, "parent_section_probabilities.xls"));
        wb.write((OutputStream)out);
        out.close();
        wb = new HSSFWorkbook();
        for (int i = 0; i < labels.size(); ++i) {
            HSSFSheet sheet = wb.createSheet();
            wb.setSheetName(i, (String)labels.get(i));
            CSVFile<String> csv = CSVFile.readFile((File)mainFaultFiles.get(i), true);
            HSSFRow header = sheet.createRow(0);
            for (int col = 0; col < csv.getNumCols(); ++col) {
                header.createCell(col).setCellValue(csv.get(0, col));
            }
            for (int row = 1; row < csv.getNumRows(); ++row) {
                HSSFRow r = sheet.createRow(row);
                r.createCell(0).setCellValue(csv.get(row, 0));
                for (int col = 1; col < csv.getNumCols(); ++col) {
                    r.createCell(col).setCellValue(Double.parseDouble(csv.get(row, col)));
                }
            }
        }
        wb.setActiveSheet(0);
        out = new FileOutputStream(new File(outputDir, "main_fault_probabilities.xls"));
        wb.write((OutputStream)out);
        out.close();
        FaultSysSolutionERF_Calc.doFinalWebPlotAssembly(outputDir, aveTypes.size() > 1);
    }

    private static void doFinalWebPlotAssembly(File dir, boolean defaultAve) throws IOException {
        FaultSysSolutionERF_Calc.writeStringToFile(new File(dir, "HEADER.html"), "<h1 style=\"font-family:'HelveticaNeue-Light', sans-serif; font-weight:normal;\">UCERF3 Time Dependent Supplementary Figures</h1>\n\n<p style=\"font-family:'HelveticaNeue-Light', sans-serif; font-weight:normal; width:540px;\">Each directory contains results for a different magnitude range and time span. For example, 'm6.7_5yr' refers to 5 year results for M >= 6.7 ruptures and 'all_30yr' refers to 30 year results for all supra-seismogenic ruptures.<br>Each calculation includes aftershocks. UCERF2 results, where presented, have been scaled to include aftershocks as: newProb = 1 - exp((1/0.97)*ln(1-oldProb))</p>");
        String aveTypeStr = defaultAve ? "default BPT averaging type" : "the corresponding BPT averaging type";
        for (File subDir : dir.listFiles()) {
            String label;
            String name = subDir.getName();
            if (!subDir.isDirectory() || name.startsWith(".")) continue;
            if (name.equals("all_5yr")) {
                label = "All Supra-Seismogenic Ruptures, 5 Year Forecast";
            } else if (name.equals("all_30yr")) {
                label = "All Supra-Seismogenic Ruptures, 30 Year Forecast";
            } else if (name.equals("m6.7_5yr")) {
                label = "All M>=6.7 Ruptures, 5 Year Forecast";
            } else if (name.equals("m6.7_30yr")) {
                label = "All M>=6.7 Ruptures, 30 Year Forecast";
            } else if (name.equals("m7.7_5yr")) {
                label = "All M>=7.7 Ruptures, 5 Year Forecast";
            } else if (name.equals("m7.7_30yr")) {
                label = "All M>=7.7 Ruptures, 30 Year Forecast";
            } else {
                throw new IllegalStateException("Unexpected directory: " + name);
            }
            FaultSysSolutionERF_Calc.writeStringToFile(new File(subDir, "HEADER.html"), "<h1 style=\"font-family:'HelveticaNeue-Light', sans-serif; font-weight:normal;\">" + label + " Figures</h1>\n\n<p style=\"font-family:'HelveticaNeue-Light', sans-serif; font-weight:normal; width:540px;\"><b><i>BranchAveragedResults</i></b>: Results/Comparisons with UCERF2, aggregated across all logic tree branches<br><b><i>BranchSensitivityMaps</i></b>: Sensitivity of Time Dependent Probabilities to each logic tree branch choice<br><b><i>OtherSensitivityTests</i></b>: Miscelaneous sensitivity tests using the branch averaged solution, Mid COV values, and " + aveTypeStr + "</p>");
            File sensDir = new File(subDir, "BranchSensitivityMaps");
            try {
                TestPDFCombine.combine(sensDir, sensDir);
            }
            catch (DocumentException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
            File avgSensDir = new File(new File(subDir, "OtherSensitivityTests"), "AveragingMethods");
            if (avgSensDir.listFiles() != null && avgSensDir.listFiles().length != 0) continue;
            avgSensDir.delete();
        }
    }

    public static void writeStringToFile(File file, String string) throws IOException {
        FileWriter fw = new FileWriter(file);
        fw.write(string + "\n");
        fw.close();
    }

    public static Map<String, DiscretizedFunc[]> loadUCERF2MainFaultMPDs(boolean includeAftershocks, boolean timeDep) throws IOException {
        CSVFile<String> csv = timeDep ? CSVFile.readStream(UCERF3_DataUtils.locateResourceAsStream("UCERF2_Section_TimeDepMFDs", "UCERF2_Main_Fault_TimeDep_Probs.csv"), false) : CSVFile.readStream(UCERF3_DataUtils.locateResourceAsStream("UCERF2_Section_MFDs", "UCERF2_Main_Fault_TimeIndep_Probs.csv"), false);
        Set<String> u3MainFaultNames = FaultModels.parseNamedFaultsAltFile(UCERF3_DataUtils.getReader("FaultModels", "MainFaultsForTimeDepComparison.txt")).keySet();
        double aftMult = 1.0309278350515465;
        double[] xVals = new double[csv.getNumRows() - 2];
        for (int row = 2; row < csv.getNumRows(); ++row) {
            xVals[row - 2] = Double.parseDouble(csv.get(row, 0));
        }
        HashMap map = Maps.newHashMap();
        for (int col = 1; col < csv.getLine(0).size(); col += 3) {
            DiscretizedFunc[] funcs = new DiscretizedFunc[3];
            String name = csv.get(0, col);
            int longestMatch = 6;
            List closestNames = null;
            for (String u3Name : u3MainFaultNames) {
                int length = StringUtils.getCommonPrefix((String[])new String[]{name, u3Name}).length();
                if (length > longestMatch) {
                    longestMatch = length;
                    closestNames = Lists.newArrayList((Object[])new String[]{u3Name});
                    continue;
                }
                if (length != longestMatch || closestNames == null) continue;
                closestNames.add(u3Name);
            }
            if (closestNames == null) {
                System.out.println("No match for " + name);
                continue;
            }
            System.out.println("Mapped " + name + " to " + Joiner.on((String)",").join(closestNames));
            ArbitrarilyDiscretizedFunc minFunc = new ArbitrarilyDiscretizedFunc();
            minFunc.setName("UCERF2 " + name + " (min)");
            ArbitrarilyDiscretizedFunc maxFunc = new ArbitrarilyDiscretizedFunc();
            maxFunc.setName("UCERF2 " + name + " (max)");
            ArbitrarilyDiscretizedFunc meanFunc = new ArbitrarilyDiscretizedFunc();
            meanFunc.setName("UCERF2 " + name + " (mean)");
            funcs[0] = minFunc;
            funcs[1] = maxFunc;
            funcs[2] = meanFunc;
            for (int i = 0; i < funcs.length; ++i) {
                int c = col + i;
                for (int j = 0; j < xVals.length; ++j) {
                    int row = j + 2;
                    double prob = Double.parseDouble(csv.get(row, c));
                    if (includeAftershocks) {
                        prob = 1.0 - Math.exp(aftMult * Math.log(1.0 - prob));
                    }
                    funcs[i].set(xVals[j], prob);
                }
            }
            for (String u3Name : closestNames) {
                map.put(u3Name, funcs);
            }
        }
        return map;
    }

    private static void debugAvgMethods() throws IOException, org.dom4j.DocumentException {
        FaultSysSolutionERF_Calc.debugAvgMethods(U3FaultSystemIO.loadSol(new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions"), "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip")));
    }

    private static void debugAvgMethods(FaultSystemSolution sol) {
        int subSectIndex = -1;
        for (FaultSection faultSection : sol.getRupSet().getFaultSectionDataList()) {
            if (!faultSection.getName().contains("Mojave")) continue;
            subSectIndex = faultSection.getSectionId();
            break;
        }
        Preconditions.checkState((subSectIndex >= 0 ? 1 : 0) != 0);
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(sol);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        erf.getTimeSpan().setDuration(30.0);
        erf.setParameter("BPT Averaging Type", (Object)BPTAveragingTypeOptions.AVE_RI_AVE_TIME_SINCE);
        erf.updateForecast();
        double d = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 6.7, 1, 0.1)[subSectIndex].getY(0);
        erf = new FaultSystemSolutionERF(sol);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        erf.getTimeSpan().setDuration(30.0);
        erf.setParameter("BPT Averaging Type", (Object)BPTAveragingTypeOptions.AVE_RATE_AVE_NORM_TIME_SINCE);
        erf.updateForecast();
        double numProb = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 6.7, 1, 0.1)[subSectIndex].getY(0);
        double probGain = numProb / d;
        System.out.println("Subsection " + subSectIndex + " results: " + numProb + "/" + d + " = " + probGain);
    }

    /*
     * WARNING - void declaration
     */
    public static void testAveragingMethodsForProbMaps(double yrForOpenInterval) throws GMT_MapException, RuntimeException, IOException {
        void var30_28;
        double minMag = 6.7;
        int numMag = 4;
        double deltaMag = 0.5;
        U3FaultSystemSolution meanSol = null;
        try {
            meanSol = U3FaultSystemIO.loadSol(new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions"), "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
        }
        catch (org.dom4j.DocumentException e) {
            e.printStackTrace();
        }
        double duration = 30.0;
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(meanSol);
        erf.getTimeSpan().setDuration(duration);
        FaultSystemSolution sol = erf.getSolution();
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        erf.setParameter("Aperiodicity", (Object)MagDependentAperiodicityOptions.MID_VALUES);
        int startYear = erf.getTimeSpan().getStartTimeYear();
        double openIntervalYrs = (double)startYear - yrForOpenInterval;
        System.out.println("ERF startYear=" + startYear + ": openIntervalYrs=" + openIntervalYrs);
        erf.setParameter("Historic Open Interval", openIntervalYrs);
        Object prefix = "aveMethodsMidAper_OpenInt" + Math.round(openIntervalYrs);
        String dirName = "AveMethods_tests_MidAper_OpenInt" + Math.round(openIntervalYrs);
        File saveDir = new File(dirName);
        if (!saveDir.exists()) {
            saveDir.mkdir();
        }
        BPTAveragingTypeOptions aveType = BPTAveragingTypeOptions.AVE_RI_AVE_NORM_TIME_SINCE;
        erf.setParameter("BPT Averaging Type", (Object)aveType);
        erf.updateForecast();
        EvenlyDiscretizedFunc[] aveRI_aveNTS_Funcs = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag);
        EvenlyDiscretizedFunc[] aveRI_aveNTS_AllMags = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag);
        aveType = BPTAveragingTypeOptions.AVE_RI_AVE_TIME_SINCE;
        erf.setParameter("BPT Averaging Type", (Object)aveType);
        erf.updateForecast();
        EvenlyDiscretizedFunc[] aveRI_aveTS_Funcs = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag);
        EvenlyDiscretizedFunc[] aveRI_aveTS_AllMags = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag);
        aveType = BPTAveragingTypeOptions.AVE_RATE_AVE_NORM_TIME_SINCE;
        erf.setParameter("BPT Averaging Type", (Object)aveType);
        erf.updateForecast();
        EvenlyDiscretizedFunc[] aveRate_aveNTS_Funcs = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag);
        EvenlyDiscretizedFunc[] aveRate_aveNTS_AllMags = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag);
        CPT diffCPT = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(-0.1, 0.1);
        CPT probCPT = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(-4.0, 0.0);
        CPT ratioCPT = FaultSysSolutionERF_Calc.getScaledLinearRatioCPT(0.02);
        ArrayList faults = Lists.newArrayList();
        for (FaultSection faultSection : sol.getRupSet().getFaultSectionDataList()) {
            faults.add(faultSection.getFaultTrace());
        }
        CaliforniaRegions.RELM_COLLECTION region = new CaliforniaRegions.RELM_COLLECTION();
        if (prefix == null) {
            prefix = "";
        }
        if (!((String)prefix).isEmpty() && !((String)prefix).endsWith("_")) {
            prefix = (String)prefix + "_";
        }
        prefix = (String)prefix + (int)duration + "yr";
        boolean bl = false;
        while (var30_28 < numMag + 1) {
            Object magStr;
            String myPrefix;
            double[] aveRate_aveNTS_Vals;
            double[] aveRI_aveTS_Vals;
            double[] aveRI_aveNTS_Vals;
            if (var30_28 == numMag) {
                aveRI_aveNTS_Vals = FaultSysSolutionERF_Calc.extractYVals(aveRI_aveNTS_AllMags, 0);
                aveRI_aveTS_Vals = FaultSysSolutionERF_Calc.extractYVals(aveRI_aveTS_AllMags, 0);
                aveRate_aveNTS_Vals = FaultSysSolutionERF_Calc.extractYVals(aveRate_aveNTS_AllMags, 0);
                myPrefix = (String)prefix + "_supra_seis";
                magStr = "Supra Seis";
            } else {
                aveRI_aveNTS_Vals = FaultSysSolutionERF_Calc.extractYVals(aveRI_aveNTS_Funcs, (int)var30_28);
                aveRI_aveTS_Vals = FaultSysSolutionERF_Calc.extractYVals(aveRI_aveTS_Funcs, (int)var30_28);
                aveRate_aveNTS_Vals = FaultSysSolutionERF_Calc.extractYVals(aveRate_aveNTS_Funcs, (int)var30_28);
                double mag = aveRI_aveNTS_Funcs[0].getX((int)var30_28);
                myPrefix = (String)prefix + "_" + (float)mag + "+";
                magStr = "M>=" + (float)mag;
            }
            double[] aveRI_aveTS_over_aveRI_aveNTS_ratio = new double[aveRI_aveNTS_Vals.length];
            double[] aveRate_aveNTS_over_aveRI_aveNTS_ratio = new double[aveRI_aveNTS_Vals.length];
            double[] aveRI_aveTS_over_aveRI_aveNTS_diff = new double[aveRI_aveNTS_Vals.length];
            double[] aveRate_aveNTS_over_aveRI_aveNTS_diff = new double[aveRI_aveNTS_Vals.length];
            double[] aveRI_aveTS_over_Mean_ratio = new double[aveRI_aveNTS_Vals.length];
            double[] aveRI_aveNTS_over_Mean_ratio = new double[aveRI_aveNTS_Vals.length];
            double[] aveRate_aveNTS_over_Mean_ratio = new double[aveRI_aveNTS_Vals.length];
            for (int j = 0; j < aveRI_aveTS_over_aveRI_aveNTS_ratio.length; ++j) {
                aveRI_aveTS_over_aveRI_aveNTS_ratio[j] = aveRI_aveTS_Vals[j] / aveRI_aveNTS_Vals[j];
                aveRate_aveNTS_over_aveRI_aveNTS_ratio[j] = aveRate_aveNTS_Vals[j] / aveRI_aveNTS_Vals[j];
                aveRI_aveTS_over_aveRI_aveNTS_diff[j] = aveRI_aveTS_Vals[j] - aveRI_aveNTS_Vals[j];
                aveRate_aveNTS_over_aveRI_aveNTS_diff[j] = aveRate_aveNTS_Vals[j] - aveRI_aveNTS_Vals[j];
                double mean = (aveRI_aveNTS_Vals[j] + aveRI_aveTS_Vals[j] + aveRate_aveNTS_Vals[j]) / 3.0;
                aveRI_aveTS_over_Mean_ratio[j] = aveRI_aveTS_Vals[j] / mean;
                aveRI_aveNTS_over_Mean_ratio[j] = aveRI_aveNTS_Vals[j] / mean;
                aveRate_aveNTS_over_Mean_ratio[j] = aveRate_aveNTS_Vals[j] / mean;
            }
            FaultBasedMapGen.makeFaultPlot(probCPT, faults, FaultBasedMapGen.log10(aveRI_aveNTS_Vals), region, saveDir, myPrefix + "_aveRI_aveNTS", false, true, "Log10(" + (float)duration + " yr " + (String)magStr + " aveRI_aveNTS)");
            FaultBasedMapGen.makeFaultPlot(probCPT, faults, FaultBasedMapGen.log10(aveRI_aveTS_Vals), region, saveDir, myPrefix + "_aveRI_aveTS", false, true, "Log10(" + (float)duration + " yr " + (String)magStr + " aveRI_aveTS)");
            FaultBasedMapGen.makeFaultPlot(probCPT, faults, FaultBasedMapGen.log10(aveRate_aveNTS_Vals), region, saveDir, myPrefix + "_aveRate_aveNTS", false, true, "Log10(" + (float)duration + " yr " + (String)magStr + " aveRate_aveNTS)");
            FaultBasedMapGen.makeFaultPlot(ratioCPT, faults, aveRI_aveTS_over_aveRI_aveNTS_ratio, region, saveDir, myPrefix + "_aveRI_aveTS_over_aveRI_aveNTS_ratio", false, true, (float)duration + " yr " + (String)magStr + " aveRI_aveTS_over_aveRI_aveNTS_ratio");
            FaultBasedMapGen.makeFaultPlot(ratioCPT, faults, aveRate_aveNTS_over_aveRI_aveNTS_ratio, region, saveDir, myPrefix + "_aveRate_aveNTS_over_aveRI_aveNTS_ratio", false, true, (float)duration + " yr " + (String)magStr + " aveRate_aveNTS_over_aveRI_aveNTS_ratio");
            FaultBasedMapGen.makeFaultPlot(diffCPT, faults, aveRI_aveTS_over_aveRI_aveNTS_diff, region, saveDir, myPrefix + "_aveRI_aveTS_minus_aveRI_aveNTS_diff", false, true, (float)duration + " yr " + (String)magStr + " aveRI_aveTS_minus_aveRI_aveNTS_diff");
            FaultBasedMapGen.makeFaultPlot(diffCPT, faults, aveRate_aveNTS_over_aveRI_aveNTS_diff, region, saveDir, myPrefix + "_aveRate_aveNTS_minus_aveRI_aveNTS_diff", false, true, (float)duration + " yr " + (String)magStr + " aveRate_aveNTS_minus_aveRI_aveNTS_diff");
            FaultBasedMapGen.makeFaultPlot(ratioCPT, faults, aveRI_aveTS_over_Mean_ratio, region, saveDir, myPrefix + "_aveRI_aveTS_over_Mean_ratio", false, true, (float)duration + " yr " + (String)magStr + " aveRI_aveTS_over_Mean_ratio");
            FaultBasedMapGen.makeFaultPlot(ratioCPT, faults, aveRI_aveNTS_over_Mean_ratio, region, saveDir, myPrefix + "_aveRI_aveNTS_over_Mean_ratio", false, true, (float)duration + " yr " + (String)magStr + " aveRI_aveNTS_over_Mean_ratio");
            FaultBasedMapGen.makeFaultPlot(ratioCPT, faults, aveRate_aveNTS_over_Mean_ratio, region, saveDir, myPrefix + "_aveRate_aveNTS_over_Mean_ratio", false, true, (float)duration + " yr " + (String)magStr + " aveRate_aveNTS_over_Mean_ratio");
            ++var30_28;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void testHistOpenIntervalFaultProbMaps() throws GMT_MapException, RuntimeException, IOException {
        void var22_22;
        double minMag = 6.7;
        int numMag = 4;
        double deltaMag = 0.5;
        Object prefix = "openIntTest_MidAper";
        String dirName = "OpenInterval_tests_MidAper";
        File saveDir = new File(dirName);
        if (!saveDir.exists()) {
            saveDir.mkdir();
        }
        U3FaultSystemSolution meanSol = null;
        try {
            meanSol = U3FaultSystemIO.loadSol(new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions"), "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
        }
        catch (org.dom4j.DocumentException e) {
            e.printStackTrace();
        }
        double duration = 30.0;
        String durStr = (int)duration + "yr";
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(meanSol);
        erf.getTimeSpan().setDuration(duration);
        FaultSystemSolution sol = erf.getSolution();
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
        erf.setParameter("Aperiodicity", (Object)MagDependentAperiodicityOptions.MID_VALUES);
        erf.updateForecast();
        EvenlyDiscretizedFunc[] noOpenIntFuncs = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag);
        EvenlyDiscretizedFunc[] noOpenIntAllMags = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag);
        erf.setParameter("Historic Open Interval", 164.0);
        erf.updateForecast();
        EvenlyDiscretizedFunc[] openIntFuncs = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, minMag, numMag, deltaMag);
        EvenlyDiscretizedFunc[] openIntAllMags = FaultSysSolutionERF_Calc.calcSubSectSupraSeisMagProbDists(erf, 0.0, 1, deltaMag);
        CPT probCPT = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(-4.0, 0.0);
        CPT ratioCPT = FaultSysSolutionERF_Calc.getScaledLinearRatioCPT(0.02);
        ArrayList faults = Lists.newArrayList();
        for (FaultSection faultSection : sol.getRupSet().getFaultSectionDataList()) {
            faults.add(faultSection.getFaultTrace());
        }
        CaliforniaRegions.RELM_COLLECTION region = new CaliforniaRegions.RELM_COLLECTION();
        if (prefix == null) {
            prefix = "";
        }
        if (!((String)prefix).isEmpty() && !((String)prefix).endsWith("_")) {
            prefix = (String)prefix + "_";
        }
        prefix = (String)prefix + (int)duration + "yr";
        boolean bl = false;
        while (var22_22 < numMag + 1) {
            Object magStr;
            String myPrefix;
            double[] openIntVals;
            double[] noOpenIntVals;
            if (var22_22 == numMag) {
                noOpenIntVals = FaultSysSolutionERF_Calc.extractYVals(noOpenIntAllMags, 0);
                openIntVals = FaultSysSolutionERF_Calc.extractYVals(openIntAllMags, 0);
                myPrefix = (String)prefix + "_supra_seis";
                magStr = "Supra Seis";
            } else {
                noOpenIntVals = FaultSysSolutionERF_Calc.extractYVals(noOpenIntFuncs, (int)var22_22);
                openIntVals = FaultSysSolutionERF_Calc.extractYVals(openIntFuncs, 0);
                double mag = noOpenIntFuncs[0].getX((int)var22_22);
                myPrefix = (String)prefix + "_" + (float)mag + "+";
                magStr = "M>=" + (float)mag;
            }
            double[] openIntOverNoOpenIntRatio = new double[noOpenIntVals.length];
            for (int j = 0; j < openIntOverNoOpenIntRatio.length; ++j) {
                openIntOverNoOpenIntRatio[j] = openIntVals[j] / noOpenIntVals[j];
            }
            FaultBasedMapGen.makeFaultPlot(probCPT, faults, FaultBasedMapGen.log10(noOpenIntVals), region, saveDir, myPrefix + "_NoOpenInt", false, true, "Log10(" + (float)duration + " yr " + (String)magStr + " NoOpenInt)");
            FaultBasedMapGen.makeFaultPlot(probCPT, faults, FaultBasedMapGen.log10(openIntVals), region, saveDir, myPrefix + "_OpenInt", false, true, "Log10(" + (float)duration + " yr " + (String)magStr + " OpenInt)");
            FaultBasedMapGen.makeFaultPlot(ratioCPT, faults, openIntOverNoOpenIntRatio, region, saveDir, myPrefix + "_OpenIntOverNoOpenIntRatio", false, true, (float)duration + " yr " + (String)magStr + " OpenIntOverNoOpenIntRatio");
            if (((String)magStr).equals("M>=6.7")) {
                for (int s = 0; s < openIntOverNoOpenIntRatio.length; ++s) {
                    System.out.println(s + "\t" + openIntOverNoOpenIntRatio[s] + "\t" + ((FaultSystemSolution)meanSol).getRupSet().getFaultSectionData(s).getName());
                }
            }
            ++var22_22;
        }
    }

    public static void writeFullModelRegionalMagProbDists(String dirPrefix, BPTAveragingTypeOptions[] avgTypes, File outputDir, FaultSystemRupSet fm31RupSet, FaultSystemRupSet fm32RupSet) {
        File[] csvDirs = new File[]{new File(dirPrefix + "-5yr"), new File(dirPrefix + "-30yr")};
    }

    public static void testNuclVsPartMFDsInRegion(Region region) {
        U3FaultSystemSolution meanSol;
        ArrayList<SummedMagFreqDist> funcsIncr = new ArrayList<SummedMagFreqDist>();
        ArrayList<EvenlyDiscretizedFunc> funcsCum = new ArrayList<EvenlyDiscretizedFunc>();
        System.out.println("Instantiating ERF...");
        String f = "dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip";
        File file = new File(f);
        try {
            meanSol = U3FaultSystemIO.loadSol(file);
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(meanSol);
        erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.INCLUDE);
        erf.getParameter("Treat Background Seismicity As").setValue(BackgroundRupType.POINT);
        System.out.println("ADJUSTABLE PARAM SETTINGS:\n" + erf.getAdjustableParameterList().toString());
        erf.updateForecast();
        SummedMagFreqDist nuclMFD_U3 = ERF_Calculator.getMagFreqDistInRegionFaster(erf, region, 5.05, 40, 0.1, true);
        SummedMagFreqDist partMFD_U3 = ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, 5.05, 40, 0.1, true);
        nuclMFD_U3.setName("UCERF3 Nucleation MFD");
        partMFD_U3.setName("UCERF3 Participation MFD");
        MeanUCERF2 erfU2 = new MeanUCERF2();
        erfU2.setParameter("Probability Model", "Poisson");
        erfU2.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
        erfU2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
        erfU2.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
        erfU2.updateForecast();
        SummedMagFreqDist nuclMFD_U2 = ERF_Calculator.getMagFreqDistInRegionFaster(erfU2, region, 5.05, 40, 0.1, true);
        SummedMagFreqDist partMFD_U2 = ERF_Calculator.getParticipationMagFreqDistInRegion(erfU2, region, 5.05, 40, 0.1, true);
        nuclMFD_U2.setName("UCERF2 Nucleation MFD");
        partMFD_U2.setName("UCERF2 Participation MFD");
        funcsIncr.add(nuclMFD_U2);
        funcsIncr.add(partMFD_U2);
        funcsIncr.add(nuclMFD_U3);
        funcsIncr.add(partMFD_U3);
        funcsCum.add(nuclMFD_U2.getCumRateDistWithOffset());
        funcsCum.add(partMFD_U2.getCumRateDistWithOffset());
        funcsCum.add(nuclMFD_U3.getCumRateDistWithOffset());
        funcsCum.add(partMFD_U3.getCumRateDistWithOffset());
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 2.0f, null, 1.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, null, 1.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 2.0f, null, 1.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, null, 1.0f, Color.BLUE));
        GraphWindow graphIncr = new GraphWindow(funcsIncr, "Incremental MFDs in " + region.getName(), plotChars);
        graphIncr.setX_AxisLabel("Magnitude");
        graphIncr.setY_AxisLabel("Rate (per year)");
        graphIncr.setPlotLabelFontSize(18);
        graphIncr.setAxisLabelFontSize(18);
        graphIncr.setTickLabelFontSize(16);
        graphIncr.setX_AxisRange(5.0, 8.5);
        graphIncr.setY_AxisRange(1.0E-6, 10.0);
        graphIncr.setYLog(true);
        GraphWindow graphCum = new GraphWindow(funcsCum, "Cumulative MFDs in " + region.getName(), plotChars);
        graphCum.setX_AxisLabel("Magnitude");
        graphCum.setY_AxisLabel("Rate (per year)");
        graphCum.setPlotLabelFontSize(18);
        graphCum.setAxisLabelFontSize(18);
        graphCum.setTickLabelFontSize(16);
        graphCum.setX_AxisRange(5.0, 8.5);
        graphCum.setY_AxisRange(1.0E-6, 10.0);
        graphCum.setYLog(true);
    }

    public static void plotCumulativeDistOfSubsectionRecurrenceIntervals(FaultSystemSolutionERF erf, boolean wtByMomentRate, File outputPDF_FileName) {
        ArbDiscrEmpiricalDistFunc dist = new ArbDiscrEmpiricalDistFunc();
        double[] sectPartRates = erf.getSolution().calcParticRateForAllSects(6.0, 10.0);
        double[] sectMoRates = null;
        if (wtByMomentRate) {
            sectMoRates = FaultSysSolutionERF_Calc.calcMomentRateForAllFaultSections(erf);
        }
        for (int i = 0; i < sectPartRates.length; ++i) {
            if (wtByMomentRate) {
                dist.set(1.0 / sectPartRates[i], sectMoRates[i]);
                continue;
            }
            dist.set(1.0 / sectPartRates[i], 1.0);
        }
        DiscretizedFunc cumDist = dist.getNormalizedCumDist();
        cumDist.setName("Cumulative Distribution of Section Recurrence Intervals");
        cumDist.setInfo("Num Sections = " + erf.getSolution().getRupSet().getNumSections() + "\nFraction at RI=1600 years = " + cumDist.getInterpolatedY(1600.0) + "\nFraction at RI=250 years = " + cumDist.getInterpolatedY(250.0) + "\nFraction at RI=70 years = " + cumDist.getInterpolatedY(70.0));
        DefaultXY_DataSet RI1600_func = new DefaultXY_DataSet();
        RI1600_func.set(1600.0, 0.0);
        RI1600_func.set(1600.0, 1.0);
        DefaultXY_DataSet RI250_func = new DefaultXY_DataSet();
        RI250_func.set(250.0, 0.0);
        RI250_func.set(250.0, 1.0);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, Color.BLACK));
        ArrayList<XY_DataSet> funcList = new ArrayList<XY_DataSet>();
        funcList.add(cumDist);
        funcList.add(RI1600_func);
        funcList.add(RI250_func);
        GraphWindow graph = new GraphWindow(funcList, "", plotChars);
        graph.setX_AxisRange(10.0, 100000.0);
        graph.setY_AxisRange(0.0, 1.0);
        graph.setY_AxisLabel("Fraction of Fault Sections");
        graph.setX_AxisLabel("Recurrence Interval (years)");
        graph.setTickLabelFontSize(24);
        graph.setAxisLabelFontSize(28);
        graph.setPlotLabelFontSize(18);
        graph.setXLog(true);
        if (outputPDF_FileName != null) {
            File dir = outputPDF_FileName.getParentFile();
            String name = outputPDF_FileName.getName();
            if (name.endsWith(".pdf")) {
                name = name.substring(0, name.indexOf(".pdf"));
            }
            try {
                graph.saveAsPDF(new File(dir, name + ".pdf").getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void testTotSubSeisMFD(FaultSystemSolutionERF erf) {
        MFDGridSourceProvider gridSrcProvider = (MFDGridSourceProvider)erf.getGridSourceProvider();
        SummedMagFreqDist mfd1 = new SummedMagFreqDist(2.05, 8.95, 70);
        for (int i = 0; i < gridSrcProvider.getGriddedRegion().getNumLocations(); ++i) {
            IncrementalMagFreqDist mfd = gridSrcProvider.getMFD_SubSeisOnFault(i);
            if (mfd == null) continue;
            mfd1.addIncrementalMagFreqDist(mfd);
        }
        mfd1.setName("Total Subseis MFD from grid source provider");
        SummedMagFreqDist mfd2 = new SummedMagFreqDist(2.05, 8.95, 70);
        for (IncrementalMagFreqDist mfd : erf.getSolution().requireModule(SubSeismoOnFaultMFDs.class).getAll()) {
            mfd2.addIncrementalMagFreqDist(mfd);
        }
        mfd1.setName("Total Subseis MFD from InversionFaultSystemSolution");
        ArrayList<SummedMagFreqDist> mfdList = new ArrayList<SummedMagFreqDist>();
        mfdList.add(mfd1);
        mfdList.add(mfd2);
        GraphWindow mfd_Graph = new GraphWindow(mfdList, "Subseis MFD comparison");
        mfd_Graph.setX_AxisLabel("Mag");
        mfd_Graph.setY_AxisLabel("Rate");
        mfd_Graph.setYLog(true);
        mfd_Graph.setPlotLabelFontSize(22);
        mfd_Graph.setAxisLabelFontSize(20);
        mfd_Graph.setTickLabelFontSize(18);
    }

    private static Document getFactSheetKML(CSVFile<String> timeDepMeanCSV, CSVFile<String> timeIndepCSV, List<CSVFile<String>> timeDepPercentileCSVs, double[] timeDepPercentiles, CSVFile<String> parentMeanCSV, List<? extends FaultSection> subSects, String title) throws IOException {
        return FaultSysSolutionERF_Calc.getFactSheetKML(timeDepMeanCSV, timeIndepCSV, timeDepPercentileCSVs, timeDepPercentiles, parentMeanCSV, subSects, true, title);
    }

    private static Document getFactSheetKML(CSVFile<String> primaryCSV, CSVFile<String> gainCSV, List<CSVFile<String>> percentileCSVs, double[] percentiles, CSVFile<String> parentMeanCSV, List<? extends FaultSection> subSects, boolean timeDep, String title) throws IOException {
        int i;
        float colorMag = 6.7f;
        int colorMagColumn = 18;
        double duration = 30.0;
        float[] tableMags = new float[]{6.7f, 7.0f, 7.5f, 8.0f};
        int[] tableColumns = new int[]{18, 21, 26, 31};
        int numProbCols = 1;
        if (percentileCSVs != null) {
            numProbCols += percentileCSVs.size();
        }
        Color probColor = new Color(230, 230, 230);
        Color gainColor = new Color(230, 200, 200);
        ArrayList headers = Lists.newArrayList();
        ArrayList firstHeader = Lists.newArrayList((Object[])new String[]{"", "30 Year Participation Prob (%)"});
        if (percentileCSVs != null) {
            for (int i2 = 0; i2 < percentileCSVs.size(); ++i2) {
                firstHeader.add(col_span_placeholder);
            }
        }
        if (gainCSV != null) {
            firstHeader.add("Ratios");
        }
        firstHeader.add(col_span_placeholder);
        headers.add(firstHeader.toArray(new String[0]));
        ArrayList secondHeader = Lists.newArrayList((Object[])new String[]{"Mag", "<b>Mean</b><sup>1</sup>"});
        if (percentileCSVs != null) {
            for (double p : percentiles) {
                secondHeader.add("p<sub>" + (float)p + "</sub><sup>1</sup>");
            }
        }
        if (gainCSV == null) {
            secondHeader.addAll(Lists.newArrayList((Object[])new String[]{"U3/U2<sup>2</sup>"}));
        } else {
            secondHeader.addAll(Lists.newArrayList((Object[])new String[]{"Gain<sup>2</sup>", "U3/U2<sup>3</sup>"}));
        }
        headers.add(secondHeader.toArray(new String[0]));
        Preconditions.checkState((firstHeader.size() == secondHeader.size() ? 1 : 0) != 0, (Object)("headers inconsistnent.\n\tFIRST: " + Joiner.on((String)",").join((Iterable)firstHeader) + "\n\tSECOND: " + Joiner.on((String)",").join((Iterable)secondHeader)));
        int nh = headers.size();
        Preconditions.checkState((colorMag == Float.parseFloat(primaryCSV.get(0, colorMagColumn)) ? 1 : 0) != 0);
        for (i = 0; i < tableMags.length; ++i) {
            Preconditions.checkState((tableMags[i] == Float.parseFloat(primaryCSV.get(0, tableColumns[i])) ? 1 : 0) != 0);
        }
        for (i = 0; i < tableMags.length; ++i) {
            Preconditions.checkState((tableMags[i] == Float.parseFloat(parentMeanCSV.get(0, tableColumns[i])) ? 1 : 0) != 0);
        }
        ArrayList faults = Lists.newArrayList();
        double[] plotValues = new double[subSects.size()];
        ArrayList descriptions = Lists.newArrayList();
        String gte = "\u2265";
        HashMap parentNameRowMap = Maps.newHashMap();
        for (int row = 1; row < parentMeanCSV.getNumRows(); ++row) {
            parentNameRowMap.put(parentMeanCSV.get(row, 0), row);
        }
        HashMap ucerf2ParentMPDs = Maps.newHashMap();
        for (FaultSection faultSection : subSects) {
            ArrayList<IncrementalMagFreqDist> u2MFDs;
            Integer parentID = faultSection.getParentSectionId();
            if (ucerf2ParentMPDs.containsKey(parentID) || (u2MFDs = timeDep ? UCERF2_Section_TimeDepMFDsCalc.getMeanMinAndMaxMFD(parentID, true, true) : UCERF2_Section_MFDsCalc.getMeanMinAndMaxMFD(parentID, true, true)) == null) continue;
            IncrementalMagFreqDist meanU2MFD = u2MFDs.get(0);
            meanU2MFD.scale(1.0309278350515465);
            ArbitrarilyDiscretizedFunc u2Probs = new ArbitrarilyDiscretizedFunc();
            float[] fArray = tableMags;
            int n = fArray.length;
            for (int j = 0; j < n; ++j) {
                double minMag = fArray[j];
                u2Probs.set(minMag, FaultSysSolutionERF_Calc.calcProbAboveMagFromMFD(meanU2MFD, minMag, duration));
            }
            ucerf2ParentMPDs.put(parentID, u2Probs);
        }
        for (int i3 = 0; i3 < subSects.size(); ++i3) {
            FaultSection faultSection = subSects.get(i3);
            FaultTrace trace = faultSection.getFaultTrace();
            trace.setName(faultSection.getName());
            faults.add(trace);
            plotValues[i3] = Double.parseDouble(primaryCSV.get(i3 + 1, colorMagColumn));
            Object description = "";
            String[][] tableVals = new String[tableMags.length + nh][((String[])headers.get(0)).length];
            Color[][] tableColors = new Color[tableVals.length][tableVals[0].length];
            for (int h = 0; h < nh; ++h) {
                tableVals[h] = (String[])headers.get(h);
            }
            ArbitrarilyDiscretizedFunc ucerf2Probs = (ArbitrarilyDiscretizedFunc)ucerf2ParentMPDs.get(faultSection.getParentSectionId());
            for (int j = 0; j < tableMags.length; ++j) {
                double tdVal = Double.parseDouble(primaryCSV.get(i3 + 1, tableColumns[j]));
                int row = j + nh;
                int col = 0;
                tableVals[row][col++] = "M" + gte + tableMags[j];
                tableVals[row][col++] = "<b>" + FaultSysSolutionERF_Calc.formattedProb(tdVal) + "</b>";
                if (percentileCSVs != null) {
                    for (CSVFile<String> pCSV : percentileCSVs) {
                        tableVals[row][col++] = FaultSysSolutionERF_Calc.formattedProb(Double.parseDouble(pCSV.get(i3 + 1, tableColumns[j])));
                    }
                }
                if (tdVal == 0.0) {
                    if (gainCSV != null) {
                        tableVals[row][col++] = kmlInfGainStr;
                    }
                    tableVals[row][col++] = kmlInfGainStr;
                    continue;
                }
                if (gainCSV != null) {
                    double tiVal = Double.parseDouble(gainCSV.get(i3 + 1, tableColumns[j]));
                    tableVals[row][col++] = FaultSysSolutionERF_Calc.formattedGain(tdVal / tiVal);
                }
                if (ucerf2Probs == null) {
                    tableVals[row][col++] = FaultSysSolutionERF_Calc.formattedGain(Double.NaN);
                    continue;
                }
                double u2Prob = ucerf2Probs.getY(tableMags[j]);
                double u3ParentProb = Double.parseDouble(parentMeanCSV.get((Integer)parentNameRowMap.get(faultSection.getParentSectionName()), tableColumns[j]));
                tableVals[row][col++] = FaultSysSolutionERF_Calc.formattedGain(u3ParentProb / u2Prob);
            }
            for (int row = 0; row < tableVals.length; ++row) {
                for (int col = 1; col < tableVals[row].length; ++col) {
                    tableColors[row][col] = col - 1 < numProbCols ? probColor : gainColor;
                }
            }
            if (!((String)description).isEmpty()) {
                description = (String)description + "<br>\n";
            }
            description = (String)description + FaultSysSolutionERF_Calc.generateHTMLTable(tableVals, tableColors);
            description = (String)description + "<br>\n";
            description = (String)description + "<font size=\"-2\">";
            description = (String)description + "<br>1. Mean and percentiles across all UCERF3 logic tree branches";
            if (gainCSV == null) {
                description = (String)description + "<br>2. Mean UCERF3/UCERF2 probability, averaged over parent fault section";
            } else {
                Preconditions.checkState((boolean)timeDep);
                description = (String)description + "<br>2. Mean time dependent probability gain (to time independent UCERF3)";
                description = (String)description + "<br>3. Mean UCERF3/UCERF2 probability, averaged over parent fault section";
            }
            description = (String)description + "</font>";
            descriptions.add(description);
        }
        CPT logProbCPT = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(-4.0, 0.0);
        double d = -1.0;
        int bufferMaxPixels = 3500;
        String name = timeDep ? "UCERF3 Mean Time Dep Prob" : "UCERF3 Mean Time Indep Prob";
        Document doc = FaultBasedMapGen.getFaultKML(logProbCPT, faults, FaultBasedMapGen.log10(plotValues), false, 40, 4, name, descriptions, d, bufferMaxPixels);
        doc.getRootElement().element("Folder").element("name").setText(title);
        return doc;
    }

    private static void writeFactSheetKMZ(File outputFile, Document ... docs) throws IOException {
        Document doc = docs[0];
        Element root = doc.getRootElement();
        for (int i = 1; i < docs.length; ++i) {
            Element el = docs[i].getRootElement().element("Folder");
            docs[i].getRootElement().remove(el);
            el.addElement("visibility").setText("0");
            ArrayList placemarkEls = Lists.newArrayList((Iterator)el.elementIterator("Placemark"));
            for (Element placemarkEl : placemarkEls) {
                placemarkEl.addElement("visibility").setText("0");
            }
            root.add(el);
        }
        Element overlayEl = root.addElement("ScreenOverlay");
        overlayEl.addElement("name").setText("Legend");
        overlayEl.addElement("Icon").addElement("href").setText("partic_legend.png");
        Element overlayXYEl = overlayEl.addElement("overlayXY");
        overlayXYEl.addAttribute("x", "0.05");
        overlayXYEl.addAttribute("y", "0.92");
        overlayXYEl.addAttribute("xunits", "fraction");
        overlayXYEl.addAttribute("yunits", "fraction");
        Element screenXYEl = overlayEl.addElement("screenXY");
        screenXYEl.addAttribute("x", "0.05");
        screenXYEl.addAttribute("y", "0.92");
        screenXYEl.addAttribute("xunits", "fraction");
        screenXYEl.addAttribute("yunits", "fraction");
        XMLUtils.writeDocumentToFile(outputFile, doc);
        String fName = outputFile.getName().replaceAll(".kml", "") + ".kmz";
        File zipFile = new File(outputFile.getParentFile(), fName);
        ArrayList zipFiles = Lists.newArrayList((Object[])new String[]{outputFile.getName(), "partic_legend.png"});
        FileUtils.createZipFile(zipFile.getAbsolutePath(), outputFile.getParentFile().getAbsolutePath(), zipFiles);
    }

    private static String formattedProb(double val) {
        String str = val == 0.0 ? kmlInfGainStr : (val > 0.0 && val < 1.0E-4 ? kmlBelowMinStr : kmlProbDF.format(val));
        str = str.replaceAll("%", "");
        return str;
    }

    private static String formattedGain(double val) {
        String str = !Doubles.isFinite((double)val) ? kmlInfGainStr : kmlGainDF.format(val);
        return str;
    }

    private static String generateHTMLTable(String[][] values, Color[][] colors) {
        StringBuilder str = new StringBuilder();
        str.append("<table cellpadding=\"5\">\n");
        for (int row = 0; row < values.length; ++row) {
            str.append("\t<tr>\n");
            for (int col = 0; col < values[row].length; ++col) {
                Object colSpanStr = "";
                if (values[row][col].equals(col_span_placeholder)) continue;
                int colSpans = 1;
                for (int col2 = col + 1; col2 < values[row].length && values[row][col2].equals(col_span_placeholder); ++col2) {
                    ++colSpans;
                }
                if (colSpans > 1) {
                    colSpanStr = " colspan=\"" + colSpans + "\"";
                }
                Object colorStr = "";
                if (colors[row][col] != null) {
                    colorStr = " bgcolor=\"#" + Integer.toHexString(colors[row][col].getRGB() & 0xFFFFFF) + "\"";
                }
                if (row == 0 || col == 0) {
                    str.append("\t\t<th" + (String)colSpanStr + (String)colorStr + ">").append(values[row][col]).append("</th>\n");
                    continue;
                }
                str.append("\t\t<td" + (String)colSpanStr + (String)colorStr + ">").append(values[row][col]).append("</td>\n");
            }
            str.append("\t</tr>\n");
        }
        str.append("</table>");
        return str.toString();
    }

    private static void calcFactSheetSubSectTableVals(CSVFile<String> fm31_td_mean_csv, CSVFile<String> fm31_ti_mean_csv, CSVFile<String> fm31_parent_csv, List<FaultSectionPrefData> fm31_sub_sects, CSVFile<String> fm32_td_mean_csv, CSVFile<String> fm32_ti_mean_csv, CSVFile<String> fm32_parent_csv, List<FaultSectionPrefData> fm32_sub_sects) {
        ArrayList names = Lists.newArrayList();
        names.add("San Andreas (Mojave S), Subsection 7");
        names.add("San Andreas (Peninsula) 2011 CFM, Subsection 8");
        names.add("Hayward (No) 2011 CFM, Subsection 4");
        names.add("Calaveras (No) 2011 CFM, Subsection 3");
        names.add("San Jacinto (San Bernardino), Subsection 4");
        names.add("Elsinore (Glen Ivy) rev, Subsection 1");
        float[] tableMags = new float[]{6.7f, 7.5f, 8.0f};
        int[] tableColumns = new int[]{18, 26, 31};
        for (String name : names) {
            System.out.println(name);
            double ripeness = -1.0;
            for (int i = 0; i < tableMags.length; ++i) {
                float mag = tableMags[i];
                int col = tableColumns[i];
                double[] fm31_vals = FaultSysSolutionERF_Calc.calcFactSheetVals(name, col, mag, fm31_td_mean_csv, fm31_ti_mean_csv, fm31_parent_csv, fm31_sub_sects);
                double[] fm32_vals = FaultSysSolutionERF_Calc.calcFactSheetVals(name, col, mag, fm32_td_mean_csv, fm32_ti_mean_csv, fm32_parent_csv, fm32_sub_sects);
                double avgTD = 0.5 * fm31_vals[0] + 0.5 * fm32_vals[0];
                if (i == 0) {
                    ripeness = 0.5 * fm31_vals[1] + 0.5 * fm32_vals[1];
                }
                double avgU3_gain = 0.5 * fm31_vals[2] + 0.5 * fm32_vals[2];
                System.out.println("\t" + mag + ": " + FaultSysSolutionERF_Calc.formattedProb(avgTD) + " (" + FaultSysSolutionERF_Calc.formattedGain(avgU3_gain) + ")");
            }
            System.out.println("\tRipeness: " + FaultSysSolutionERF_Calc.formattedGain(ripeness));
        }
    }

    private static double[] calcFactSheetVals(String subSectName, int col, double mag, CSVFile<String> td_mean_csv, CSVFile<String> ti_mean_csv, CSVFile<String> parent_csv, List<FaultSectionPrefData> sub_sects) {
        FaultSectionPrefData s = null;
        for (FaultSectionPrefData subSect : sub_sects) {
            if (!subSect.getName().equals(subSectName)) continue;
            s = subSect;
            break;
        }
        Preconditions.checkNotNull(s);
        int row = s.getSectionId() + 1;
        double tdVal = Double.parseDouble(td_mean_csv.get(row, col));
        double tiVal = Double.parseDouble(ti_mean_csv.get(row, col));
        double tdGain = tdVal / tiVal;
        double u3Gain = -1.0;
        for (row = 1; row < parent_csv.getNumRows(); ++row) {
            if (!parent_csv.get(row, 0).equals(s.getParentSectionName())) continue;
            double u3Val = Double.parseDouble(parent_csv.get(row, col));
            ArrayList<IncrementalMagFreqDist> u2MFDs = UCERF2_Section_TimeDepMFDsCalc.getMeanMinAndMaxMFD(s.getParentSectionId(), true, true);
            if (u2MFDs == null) continue;
            IncrementalMagFreqDist meanU2MFD = u2MFDs.get(0);
            meanU2MFD.scale(1.0309278350515465);
            double u2Val = FaultSysSolutionERF_Calc.calcProbAboveMagFromMFD(meanU2MFD, mag, 30.0);
            u3Gain = u3Val / u2Val;
            break;
        }
        Preconditions.checkState((u3Gain != -1.0 ? 1 : 0) != 0);
        return new double[]{tdVal, tdGain, u3Gain};
    }

    public static void main(String[] args) throws Exception {
        File invDir = new File("/home/kevin/OpenSHA/UCERF3/fss_csvs/");
        List<? extends FaultSection> subSects_3_1 = U3FaultSystemIO.loadRupSet(new File(invDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip")).getFaultSectionDataList();
        List<? extends FaultSection> subSects_3_2 = U3FaultSystemIO.loadRupSet(new File(invDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_2_MEAN_BRANCH_AVG_SOL.zip")).getFaultSectionDataList();
        File pressReleaseDir = new File("/home/kevin/OpenSHA/UCERF3/press_release/time_indep");
        File outputFile = new File(pressReleaseDir, "ucerf3_timeindep_30yr_probs.kml");
        Document fm3_1Doc = FaultSysSolutionERF_Calc.getFactSheetKML(CSVFile.readFile(new File(pressReleaseDir, "FM3_1_30yr_sub_sect_probs_u3_poisson_mean.csv"), true), null, null, null, CSVFile.readFile(new File(pressReleaseDir, "FM3_1_30yr_parent_sect_probs_u3_td_mean.csv"), true), subSects_3_1, false, "Fault Model 3.1");
        Document fm3_2Doc = FaultSysSolutionERF_Calc.getFactSheetKML(CSVFile.readFile(new File(pressReleaseDir, "FM3_2_30yr_sub_sect_probs_u3_td_mean.csv"), true), null, null, null, CSVFile.readFile(new File(pressReleaseDir, "FM3_2_30yr_parent_sect_probs_u3_td_mean.csv"), true), subSects_3_2, false, "Fault Model 3.2");
        FaultSysSolutionERF_Calc.writeFactSheetKMZ(outputFile, fm3_1Doc, fm3_2Doc);
        System.exit(0);
        String dirPrefix = "/home/kevin/OpenSHA/UCERF3/probGains/2014_02_15-ucerf3-prob-gains-open1875";
        U3FaultSystemSolution meanSol = U3FaultSystemIO.loadSol(new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions"), "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
        File outputMainDir = new File("/tmp/asdf");
        FaultSysSolutionERF_Calc.writeTimeDepPlotsForWeb(Lists.newArrayList((Object[])new BPTAveragingTypeOptions[]{BPTAveragingTypeOptions.AVE_RI_AVE_NORM_TIME_SINCE}), true, dirPrefix, new File(outputMainDir, "TimeDependent_AVE_RI_AVE_NORM_TIME_SINCE"), meanSol);
    }

    private static class SubSectNameComparator
    implements Comparator<String> {
        private final String key = "Subsection ";
        private final int len = "Subsection ".length();

        private SubSectNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int ss1_index = o1.indexOf("Subsection ") + this.len;
            int ss2_index = o2.indexOf("Subsection ") + this.len;
            int ret = o1.substring(0, ss1_index).compareTo(o2.substring(0, ss2_index));
            if (ret != 0) {
                return ret;
            }
            int ss1 = Integer.parseInt(o1.substring(ss1_index));
            int ss2 = Integer.parseInt(o2.substring(ss2_index));
            Preconditions.checkState((ss1 >= 0 && ss2 >= 0 ? 1 : 0) != 0);
            return Integer.valueOf(ss1).compareTo(ss2);
        }
    }

    public static class SectProbGainResults {
        double recurrInt;
        double openInt;
        double pPois;
        double pTimeDep;
        double pGain;
        double implGain;

        public SectProbGainResults(double recurrInt, double openInt, double pPois, double pBPT, double pGain, double implGain) {
            this.recurrInt = recurrInt;
            this.openInt = openInt;
            this.pPois = pPois;
            this.pTimeDep = pBPT;
            this.pGain = pGain;
            this.implGain = implGain;
        }
    }

    private static class FaultTraceComparable
    implements Comparable<FaultTraceComparable> {
        private String name;
        private int parentID;
        private FaultTrace trace;

        public FaultTraceComparable(String name, int parentID, FaultTrace trace) {
            this.name = name;
            this.parentID = parentID;
            this.trace = trace;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.parentID;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FaultTraceComparable other = (FaultTraceComparable)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.parentID == other.parentID;
        }

        @Override
        public int compareTo(FaultTraceComparable o) {
            return this.name.compareTo(o.name);
        }
    }
}

