/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import java.io.File;
import java.io.IOException;
import org.dom4j.DocumentException;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSetMath;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.mapping.gmt.gui.GMT_MapGuiBean;
import org.opensha.commons.mapping.gmt.gui.ImageViewerWindow;
import org.opensha.commons.param.impl.CPTParameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.analysis.FaultSystemSolutionCalc;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class GMT_CA_Maps {
    static final String defaultNucleationCPT = GMT_CPT_Files.UCERF2_FIGURE_35.getFileName();
    static final String defaultParticipationCPT = GMT_CPT_Files.UCERF2_FIGURE_35.getFileName();
    static final String defaultRatioCPT = GMT_CPT_Files.UCERF3_RATIOS.getFileName();
    static final String defaultColorScaleLimits = "Manually";
    static final double defaultColorScaleMinNucl = -6.0;
    static final double defaultColorScaleMaxNucl = -1.0;
    static final double defaultColorScaleMinPart = -5.0;
    static final double defaultColorScaleMaxPart = -1.0;
    static final double defaultColorScaleMinRatio = -2.0;
    static final double defaultColorScaleMaxRatio = 2.0;
    static final double defaultColorScaleMinPDF = -6.0;
    static final double defaultColorScaleMaxPDF = -2.0;
    static final double defaultColorScaleMinMoRate = 13.0;
    static final double defaultColorScaleMaxMoRate = 17.0;
    static final boolean makeMapOnServer = true;
    static final double defaultMinLat = 31.5;
    static final double defaultMaxLat = 43.0;
    static final double defaultMinLon = -125.4;
    static final double defaultMaxLon = -113.1;
    static final double defaultGridSpacing = 0.1;
    static final String defaultTopoResolution = "No Topo";
    static final String defaultShowHighways = "None";
    static final String defaultCoast = "Draw Boundary";
    static final double defaultImageWidth = 6.5;
    static final boolean defaultApplyGMT_Smoothing = false;
    static final boolean defaultBlackBackground = false;
    static final CaliforniaRegions.RELM_TESTING_GRIDDED defaultGridRegion = RELM_RegionUtils.getGriddedRegionInstance();
    public static final File GMT_DIR = new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "GMT");

    public static GMT_MapGenerator getDefaultGMT_MapGenerator() {
        GMT_MapGenerator gmt_MapGenerator = new GMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)gmt_MapGenerator.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(defaultNucleationCPT);
        gmt_MapGenerator.setParameter("Min Latitude", 31.5);
        gmt_MapGenerator.setParameter("Min Longitude", -125.4);
        gmt_MapGenerator.setParameter("Max Latitude", 43.0);
        gmt_MapGenerator.setParameter("Max Longitude", -113.1);
        gmt_MapGenerator.setParameter("Grid Spacing", 0.1);
        gmt_MapGenerator.setParameter("Color Scale Limits", defaultColorScaleLimits);
        gmt_MapGenerator.setParameter("Color-Scale Min", -6.0);
        gmt_MapGenerator.setParameter("Color-Scale Max", -1.0);
        gmt_MapGenerator.setParameter("Topo Resolution", defaultTopoResolution);
        gmt_MapGenerator.setParameter("Highways in plot", defaultShowHighways);
        gmt_MapGenerator.setParameter("Coast", defaultCoast);
        gmt_MapGenerator.setParameter("Image Width", 6.5);
        gmt_MapGenerator.setParameter("Apply GMT Smoothing?", false);
        gmt_MapGenerator.setParameter("Apply Black Background?", false);
        return gmt_MapGenerator;
    }

    public static void makeMap(GeoDataSet geoDataSet, String scaleLabel, String metadata, String dirName, GMT_MapGenerator gmt_MapGenerator) throws IOException {
        try {
            if (!GMT_DIR.exists()) {
                GMT_DIR.mkdir();
            }
            String url = gmt_MapGenerator.makeMapUsingServlet(geoDataSet, scaleLabel, (String)metadata, null);
            metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(gmt_MapGenerator.getGMTFilesWebAddress());
            File downloadDir = new File(GMT_DIR, dirName);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            File zipFile = new File(downloadDir, "allFiles.zip");
            String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
            FileUtils.downloadURL(zipURL, zipFile);
            FileUtils.unzipFile(zipFile, downloadDir);
            ImageViewerWindow imageViewerWindow = new ImageViewerWindow(url, (String)metadata, true);
        }
        catch (GMT_MapException e) {
            e.printStackTrace();
        }
    }

    public static GriddedRegion getDefaultGriddedRegion() {
        return defaultGridRegion;
    }

    public static void plotRatioOfRateMaps(GeoDataSet geoDataSet1, GeoDataSet geoDataSet2, String scaleLabel, String metadata, String dirName) throws IOException {
        GeoDataSet ratioGeoDataSet = GeoDataSetMath.divide(geoDataSet1, geoDataSet2);
        System.out.println("MIN RATIO = " + ratioGeoDataSet.getMinZ());
        System.out.println("MAX RATIO = " + ratioGeoDataSet.getMaxZ());
        GMT_MapGenerator gmt_MapGenerator = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        gmt_MapGenerator.setParameter("Color-Scale Min", -2.0);
        gmt_MapGenerator.setParameter("Color-Scale Max", 2.0);
        CPTParameter cptParam = (CPTParameter)gmt_MapGenerator.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(defaultRatioCPT);
        GMT_CA_Maps.makeMap(ratioGeoDataSet, scaleLabel, metadata, dirName, gmt_MapGenerator);
    }

    public static void plotRatioOfNucleationRateMaps(ERF erf1, ERF erf2, double minMag, double maxMag, String scaleLabel, String metadata, String dirName) throws IOException {
        GriddedGeoDataSet geoDataSet1 = ERF_Calculator.getNucleationRatesInRegion(erf1, defaultGridRegion, minMag, maxMag);
        GriddedGeoDataSet geoDataSet2 = ERF_Calculator.getNucleationRatesInRegion(erf2, defaultGridRegion, minMag, maxMag);
        GMT_CA_Maps.plotRatioOfRateMaps(geoDataSet1, geoDataSet2, scaleLabel, metadata, dirName);
    }

    public static void plotRatioOfNucleationRateMaps(FaultSystemSolution faultSysSolution1, FaultSystemSolution faultSysSolution2, double minMag, double maxMag, String scaleLabel, String metadata, String dirName) throws IOException {
        FaultSystemSolutionERF erf1 = new FaultSystemSolutionERF(faultSysSolution1);
        erf1.updateForecast();
        FaultSystemSolutionERF erf2 = new FaultSystemSolutionERF(faultSysSolution2);
        erf2.updateForecast();
        GMT_CA_Maps.plotRatioOfNucleationRateMaps(erf1, erf2, minMag, maxMag, scaleLabel, metadata, dirName);
    }

    public static void plotRatioOfParticipationRateMaps(ERF erf1, ERF erf2, double minMag, double maxMag, String scaleLabel, String metadata, String dirName) throws IOException {
        GriddedGeoDataSet geoDataSet1 = ERF_Calculator.getParticipationRatesInRegion(erf1, defaultGridRegion, minMag, maxMag);
        GriddedGeoDataSet geoDataSet2 = ERF_Calculator.getParticipationRatesInRegion(erf2, defaultGridRegion, minMag, maxMag);
        GMT_CA_Maps.plotRatioOfRateMaps(geoDataSet1, geoDataSet2, scaleLabel, metadata, dirName);
    }

    public static void plotRatioOfParticipationRateMaps(FaultSystemSolution faultSysSolution1, FaultSystemSolution faultSysSolution2, double minMag, double maxMag, String scaleLabel, String metadata, String dirName) throws IOException {
        FaultSystemSolutionERF erf1 = new FaultSystemSolutionERF(faultSysSolution1);
        erf1.updateForecast();
        FaultSystemSolutionERF erf2 = new FaultSystemSolutionERF(faultSysSolution2);
        erf2.updateForecast();
        GMT_CA_Maps.plotRatioOfParticipationRateMaps(erf1, erf2, minMag, maxMag, scaleLabel, metadata, dirName);
    }

    public static void plotNucleationRateMap(ERF erf, double minMag, double maxMag, String scaleLabel, String metadata, String dirName) throws IOException {
        GriddedGeoDataSet geoDataSet = ERF_Calculator.getNucleationRatesInRegion(erf, defaultGridRegion, minMag, maxMag);
        GMT_CA_Maps.plotNucleationRateMap(geoDataSet, scaleLabel, metadata, dirName);
    }

    public static void plotNucleationRateMap(FaultSystemSolution faultSysSolution, double minMag, double maxMag, String scaleLabel, String metadata, String dirName) throws IOException {
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(faultSysSolution);
        erf.updateForecast();
        GMT_CA_Maps.plotNucleationRateMap(erf, minMag, maxMag, scaleLabel, metadata, dirName);
    }

    public static void plotNucleationRateMap(GeoDataSet geoDataSet, String scaleLabel, String metadata, String dirName) throws IOException {
        GMT_MapGenerator gmt_MapGenerator = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        gmt_MapGenerator.setParameter("Color-Scale Min", -6.0);
        gmt_MapGenerator.setParameter("Color-Scale Max", -1.0);
        CPTParameter cptParam = (CPTParameter)gmt_MapGenerator.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(defaultNucleationCPT);
        GMT_CA_Maps.makeMap(geoDataSet, scaleLabel, metadata, dirName, gmt_MapGenerator);
    }

    public static void plotParticipationRateMap(ERF erf, double minMag, double maxMag, String scaleLabel, String metadata, String dirName) throws IOException {
        GriddedGeoDataSet geoDataSet = ERF_Calculator.getParticipationRatesInRegion(erf, defaultGridRegion, minMag, maxMag);
        GMT_CA_Maps.plotParticipationRateMap(geoDataSet, scaleLabel, metadata, dirName);
    }

    public static void plotParticipationRateMap(FaultSystemSolution faultSysSolution, double minMag, double maxMag, String scaleLabel, String metadata, String dirName) throws IOException {
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(faultSysSolution);
        erf.updateForecast();
        GMT_CA_Maps.plotParticipationRateMap(erf, minMag, maxMag, scaleLabel, metadata, dirName);
    }

    public static void plotParticipationRateMap(GeoDataSet geoDataSet, String scaleLabel, String metadata, String dirName) throws IOException {
        GMT_MapGenerator gmt_MapGenerator = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        gmt_MapGenerator.setParameter("Color-Scale Min", -5.0);
        gmt_MapGenerator.setParameter("Color-Scale Max", -1.0);
        CPTParameter cptParam = (CPTParameter)gmt_MapGenerator.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(defaultParticipationCPT);
        GMT_CA_Maps.makeMap(geoDataSet, scaleLabel, metadata, dirName, gmt_MapGenerator);
    }

    public static void testMakeUCERF2_Fig35(String dirName) throws IOException {
        double newVal;
        int i;
        MeanUCERF2 meanUCERF2 = new MeanUCERF2();
        meanUCERF2.setParameter("Rupture Offset", 5.0);
        meanUCERF2.getParameter("Probability Model").setValue("WGCEP Preferred Blend");
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_CROSSHAIR);
        meanUCERF2.getTimeSpan().setDuration(30.0);
        meanUCERF2.updateForecast();
        GMT_MapGenerator gen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)gen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.UCERF2_FIGURE_35.getFileName());
        gen.setParameter("Color-Scale Min", -5.0);
        gen.setParameter("Color-Scale Max", 0.0);
        GriddedGeoDataSet geoDataSet = ERF_Calculator.getParticipationRatesInRegion(meanUCERF2, defaultGridRegion, 5.0, 10.0);
        for (i = 0; i < geoDataSet.size(); ++i) {
            newVal = 1.0 - Math.exp(-geoDataSet.get(i) * 30.0);
            geoDataSet.set(i, newVal);
        }
        GMT_CA_Maps.makeMap(geoDataSet, "Test of UCERF2 Fig 35, M=5.0", "GMT_CA_Maps.testMakeUCERF2_Fig35()", dirName + "M5_0", gen);
        geoDataSet = ERF_Calculator.getParticipationRatesInRegion(meanUCERF2, defaultGridRegion, 6.7, 10.0);
        for (i = 0; i < geoDataSet.size(); ++i) {
            newVal = 1.0 - Math.exp(-geoDataSet.get(i) * 30.0);
            geoDataSet.set(i, newVal);
        }
        GMT_CA_Maps.makeMap(geoDataSet, "Test of UCERF2 Fig 35, M=6.7", "GMT_CA_Maps.testMakeUCERF2_Fig35()", dirName + "M6_7", gen);
        geoDataSet = ERF_Calculator.getParticipationRatesInRegion(meanUCERF2, defaultGridRegion, 7.7, 10.0);
        for (i = 0; i < geoDataSet.size(); ++i) {
            newVal = 1.0 - Math.exp(-geoDataSet.get(i) * 30.0);
            geoDataSet.set(i, newVal);
        }
        GMT_CA_Maps.makeMap(geoDataSet, "Test of UCERF2 Fig 35, M=7.7", "GMT_CA_Maps.testMakeUCERF2_Fig35()", dirName + "M7_7", gen);
    }

    public static void testMakeUCERF2_Fig19(String dirName) throws IOException {
        MeanUCERF2 meanUCERF2 = new MeanUCERF2();
        meanUCERF2.setParameter("Rupture Offset", 5.0);
        meanUCERF2.getParameter("Probability Model").setValue("WGCEP Preferred Blend");
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_ONLY);
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_CROSSHAIR);
        meanUCERF2.getTimeSpan().setDuration(30.0);
        meanUCERF2.updateForecast();
        GMT_MapGenerator gen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)gen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
        gen.setParameter("Color-Scale Min", -5.0);
        gen.setParameter("Color-Scale Max", -3.0);
        GriddedGeoDataSet geoDataSet = ERF_Calculator.getNucleationRatesInRegion(meanUCERF2, defaultGridRegion, 5.0, 10.0);
        GMT_CA_Maps.makeMap(geoDataSet, "TempTest of UCERF2", "GMT_CA_Maps.tempTestUCERF2()", dirName, gen);
    }

    public static void tempTestUCERF2(String dirName) throws IOException {
        MeanUCERF2 meanUCERF2 = new MeanUCERF2();
        meanUCERF2.setParameter("Rupture Offset", 5.0);
        meanUCERF2.getParameter("Probability Model").setValue("WGCEP Preferred Blend");
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
        meanUCERF2.getTimeSpan().setDuration(30.0);
        meanUCERF2.updateForecast();
        GMT_MapGenerator gen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)gen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
        gen.setParameter("Color-Scale Min", -6.0);
        gen.setParameter("Color-Scale Max", -2.0);
        GriddedGeoDataSet geoDataSet = ERF_Calculator.getNucleationRatesInRegion(meanUCERF2, defaultGridRegion, 6.0, 10.0);
        for (int i = 0; i < geoDataSet.size(); ++i) {
            double newVal = geoDataSet.get(i) * 5.0;
            geoDataSet.set(i, newVal);
        }
        GMT_CA_Maps.makeMap(geoDataSet, "Test of UCERF2 Fig 19a", "GMT_CA_Maps.testMakeUCERF2_Fig19()", dirName + "_a", gen);
        GriddedGeoDataSet bulgeDataSet = GMT_CA_Maps.getM6_5_BulgeData(meanUCERF2, 6.5, 0.8);
        cptParam = (CPTParameter)gen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.GMT_POLAR.getFileName());
        gen.setParameter("Color-Scale Min", -1.0);
        gen.setParameter("Color-Scale Max", 1.0);
        GMT_CA_Maps.makeMap(bulgeDataSet, "Test of UCERF2 Fig 19b", "GMT_CA_Maps.testMakeUCERF2_Fig19()", dirName + "_b", gen);
    }

    public static void plotM6_5_BulgeMap(ERF erf, double mag, double bValue, String scaleLabel, String metadata, String dirName) throws IOException {
        GriddedGeoDataSet bulgeDataSet = GMT_CA_Maps.getM6_5_BulgeData(erf, mag, bValue);
        GMT_MapGenerator gen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)gen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.GMT_POLAR.getFileName());
        gen.setParameter("Color-Scale Min", -1.0);
        gen.setParameter("Color-Scale Max", 1.0);
        GMT_CA_Maps.makeMap(bulgeDataSet, scaleLabel, metadata, dirName, gen);
    }

    public static void plotBulgeFromFirstGenAftershocksMap(FaultSystemSolutionERF erf, String scaleLabel, String metadata, String dirName, boolean applyCorr) throws IOException {
        GriddedGeoDataSet bulgeDataSet = new GriddedGeoDataSet(defaultGridRegion, true);
        SummedMagFreqDist[] subMFD_Array = FaultSystemSolutionCalc.getSubSeismNucleationMFD_inGridNodes((InversionFaultSystemSolution)erf.getSolution(), defaultGridRegion);
        SummedMagFreqDist[] supraMFD_Array = FaultSystemSolutionCalc.getSupraSeismNucleationMFD_inGridNodes((InversionFaultSystemSolution)erf.getSolution(), defaultGridRegion);
        for (int i = 0; i < bulgeDataSet.size(); ++i) {
            if (subMFD_Array[i] != null) {
                double corr;
                if (applyCorr && (corr = ETAS_Utils.getScalingFactorToImposeGR_numPrimary(supraMFD_Array[i], subMFD_Array[i], false)) < 1.0) {
                    supraMFD_Array[i].scale(corr);
                }
                double val = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_numPrimary(supraMFD_Array[i], subMFD_Array[i], false);
                bulgeDataSet.set(i, val);
                continue;
            }
            bulgeDataSet.set(i, Double.POSITIVE_INFINITY);
        }
        GMT_MapGenerator gen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)gen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.UCERF3_RATIOS.getFileName());
        gen.setParameter("Color-Scale Min", -2.0);
        gen.setParameter("Color-Scale Max", 2.0);
        GMT_CA_Maps.makeMap(bulgeDataSet, scaleLabel, metadata, dirName, gen);
    }

    private static GriddedGeoDataSet getM6_5_BulgeData(ERF erf, double mag, double bValue) {
        GriddedGeoDataSet geoDataSet5_0 = ERF_Calculator.getNucleationRatesInRegion(erf, defaultGridRegion, 5.0, 10.0);
        GriddedGeoDataSet geoDataSetMag = ERF_Calculator.getNucleationRatesInRegion(erf, defaultGridRegion, mag, 10.0);
        GriddedGeoDataSet bulgeDataSet = new GriddedGeoDataSet(defaultGridRegion, true);
        double m5to6pt5 = Math.pow(10.0, -(mag - 5.0) * bValue);
        for (int i = 0; i < bulgeDataSet.size(); ++i) {
            bulgeDataSet.set(i, geoDataSetMag.get(i) / (geoDataSet5_0.get(i) * m5to6pt5));
        }
        return bulgeDataSet;
    }

    public static void plotSpatialPDF_Map(GeoDataSet geoDataSet, String scaleLabel, String metadata, String dirName) throws IOException {
        GMT_MapGenerator gmt_MapGenerator = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        gmt_MapGenerator.setParameter("Color-Scale Min", -6.0);
        gmt_MapGenerator.setParameter("Color-Scale Max", -2.0);
        CPTParameter cptParam = (CPTParameter)gmt_MapGenerator.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(defaultNucleationCPT);
        GMT_CA_Maps.makeMap(geoDataSet, scaleLabel, metadata, dirName, gmt_MapGenerator);
    }

    public static void plotSpatialMoRate_Map(GeoDataSet geoDataSet, String scaleLabel, String metadata, String dirName) throws IOException {
        GMT_MapGenerator gmt_MapGenerator = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        gmt_MapGenerator.setParameter("Color-Scale Min", 13.0);
        gmt_MapGenerator.setParameter("Color-Scale Max", 17.0);
        CPTParameter cptParam = (CPTParameter)gmt_MapGenerator.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(defaultNucleationCPT);
        GMT_CA_Maps.makeMap(geoDataSet, scaleLabel, metadata, dirName, gmt_MapGenerator);
    }

    public static void plotMagnitudeMap(GeoDataSet magGeoDataSet, String scaleLabel, String metadata, String dirName) throws IOException {
        GMT_MapGenerator gmt_MapGenerator = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        gmt_MapGenerator.setParameter("Color-Scale Min", 4.0);
        gmt_MapGenerator.setParameter("Color-Scale Max", 10.0);
        CPTParameter cptParam = (CPTParameter)gmt_MapGenerator.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
        gmt_MapGenerator.setParameter("Plot Log", false);
        GMT_CA_Maps.makeMap(magGeoDataSet, scaleLabel, metadata, dirName, gmt_MapGenerator);
    }

    public static void plot_bValueMap(ERF erf, double min_bValMag, double max_bValMag, String scaleLabel, String metadata, String dirName) throws IOException {
        GriddedGeoDataSet geoDataSet = ERF_Calculator.get_bValueAtPointsInRegion(erf, defaultGridRegion, min_bValMag, max_bValMag);
        GMT_MapGenerator gmt_MapGenerator = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        gmt_MapGenerator.setParameter("Color-Scale Min", -2.0);
        gmt_MapGenerator.setParameter("Color-Scale Max", 2.0);
        gmt_MapGenerator.setParameter("Plot Log", false);
        CPTParameter cptParam = (CPTParameter)gmt_MapGenerator.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(defaultNucleationCPT);
        GMT_CA_Maps.makeMap(geoDataSet, scaleLabel, metadata, dirName, gmt_MapGenerator);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        GMT_CA_Maps.testMakeUCERF2_Fig19("tempTestHere");
        System.out.println("Done");
    }
}

