/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.primitives.Doubles;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.param.BPTAveragingTypeOptions;
import org.opensha.sha.earthquake.param.MagDependentAperiodicityOptions;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import scratch.UCERF3.U3CompoundFaultSystemSolution;
import scratch.UCERF3.analysis.FaultSysSolutionERF_Calc;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class MPJ_ERF_ProbGainCalc
extends MPJTaskCalculator {
    private U3CompoundFaultSystemSolution cfss;
    private List<U3LogicTreeBranch> branches;
    private FaultSystemSolutionERF[] erfs;
    private double duration;
    private File outputDir;
    private boolean mainFaults = false;
    private Map<String, List<Integer>> mainFaultsMap;
    private Map<FaultModels, Map<String, Collection<Integer>>> mainFaultsRupMappings;
    private List<String> mainFaultsSorted;

    public MPJ_ERF_ProbGainCalc(CommandLine cmd) throws ZipException, IOException {
        super(cmd);
        File compoundFile = new File(cmd.getOptionValue("cfss"));
        Preconditions.checkArgument((boolean)compoundFile.exists(), (Object)("Compound file doesn't exist: " + compoundFile.getAbsolutePath()));
        this.cfss = U3CompoundFaultSystemSolution.fromZipFile(compoundFile);
        this.branches = Lists.newArrayList(this.cfss.getBranches());
        Collections.sort(this.branches);
        int numThreads = this.getNumThreads();
        this.erfs = new FaultSystemSolutionERF[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            this.erfs[i] = new FaultSystemSolutionERF();
            FaultSystemSolutionERF erf = this.erfs[i];
            erf.setParameter("Apply Aftershock Filter", false);
            erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
            if (cmd.hasOption("ave")) {
                BPTAveragingTypeOptions aveType = BPTAveragingTypeOptions.valueOf(cmd.getOptionValue("ave"));
                erf.setParameter("BPT Averaging Type", (Object)aveType);
            }
            this.duration = Double.parseDouble(cmd.getOptionValue("duration"));
            erf.getTimeSpan().setDuration(this.duration);
            if (cmd.hasOption("cov")) {
                MagDependentAperiodicityOptions cov = MagDependentAperiodicityOptions.valueOf(cmd.getOptionValue("cov"));
                erf.setParameter("Aperiodicity", (Object)cov);
            }
            if (!cmd.hasOption("hist")) continue;
            double histBasis = Double.parseDouble(cmd.getOptionValue("hist"));
            double calcOpen = 2014.0 - histBasis;
            System.out.println("Setting historical open interval to " + calcOpen + " (basis=" + histBasis + ")");
            erf.setParameter("Historic Open Interval", calcOpen);
        }
        this.outputDir = new File(cmd.getOptionValue("dir"));
        if (this.rank == 0) {
            Preconditions.checkState((this.outputDir.exists() || this.outputDir.mkdirs() ? 1 : 0) != 0);
        }
        if (cmd.hasOption("faults")) {
            this.mainFaults = true;
            this.mainFaultsMap = FaultModels.parseNamedFaultsAltFile(UCERF3_DataUtils.getReader("FaultModels", "MainFaultsForTimeDepComparison.txt"));
            this.mainFaultsSorted = Lists.newArrayList(this.mainFaultsMap.keySet());
            Collections.sort(this.mainFaultsSorted);
            this.mainFaultsRupMappings = Maps.newHashMap();
        }
    }

    protected int getNumTasks() {
        return this.branches.size();
    }

    protected void calculateBatch(int[] batch) throws Exception {
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        for (int index : batch) {
            stack.add(index);
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < this.getNumThreads(); ++i) {
            threads.add(new Thread(new CalcRunnable(this.erfs[i], stack)));
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
    }

    private Table<String, Double, Double> calcFaultProbs(FaultSystemSolutionERF erf, FaultSystemRupSet rupSet, double[] minMags, Map<String, Collection<Integer>> mappings) {
        ArrayTable bptTable = ArrayTable.create(this.mainFaultsSorted, (Iterable)Doubles.asList((double[])minMags));
        for (double minMag : minMags) {
            for (String fault : this.mainFaultsSorted) {
                Collection<Integer> rups = mappings.get(fault);
                double prob = rups.isEmpty() ? Double.NaN : MPJ_ERF_ProbGainCalc.calcFaultProb(erf, rupSet, rups, minMag);
                bptTable.put((Object)fault, (Object)minMag, (Object)prob);
            }
        }
        return bptTable;
    }

    public static double calcFaultProb(FaultSystemSolutionERF erf, FaultSystemRupSet rupSet, Collection<Integer> rups, double minMag) {
        ArrayList probs = Lists.newArrayList();
        for (int sourceID = 0; sourceID < erf.getNumFaultSystemSources(); ++sourceID) {
            int rupID = erf.getFltSysRupIndexForSource(sourceID);
            if (!rups.contains(rupID) || !(rupSet.getMagForRup(rupID) >= minMag)) continue;
            probs.add(erf.getSource(sourceID).computeTotalProb());
        }
        return FaultSysSolutionERF_Calc.calcSummedProbs(probs);
    }

    protected void doFinalAssembly() throws Exception {
    }

    protected static Options createOptions() {
        Options options = MPJTaskCalculator.createOptions();
        Option cfssOption = new Option("cfss", "compound-sol", true, "Compound Fault System Solution File");
        cfssOption.setRequired(true);
        options.addOption(cfssOption);
        Option dirOption = new Option("dir", "output-dir", true, "Output Directory");
        dirOption.setRequired(true);
        options.addOption(dirOption);
        Option durationOption = new Option("dur", "duration", true, "Forecast Duration");
        durationOption.setRequired(true);
        options.addOption(durationOption);
        Option aperiodOption = new Option("cov", "aperiodicity", true, "Aperiodicity enum name");
        aperiodOption.setRequired(false);
        options.addOption(aperiodOption);
        Option histOption = new Option("hist", "hist-open-interval-basis", true, "Historical Open Interval Basis (year, e.g. 1875)");
        histOption.setRequired(false);
        options.addOption(histOption);
        Option aveRIOption = new Option("ave", "ave-type", true, "Average Type");
        aveRIOption.setRequired(false);
        options.addOption(aveRIOption);
        Option mainFaultsOption = new Option("faults", "main-faults", false, "Flag for doing main faults calculation instead");
        mainFaultsOption.setRequired(false);
        options.addOption(mainFaultsOption);
        return options;
    }

    public static void main(String[] args) {
        args = MPJTaskCalculator.initMPJ((String[])args);
        try {
            Options options = MPJ_ERF_ProbGainCalc.createOptions();
            CommandLine cmd = MPJ_ERF_ProbGainCalc.parse((Options)options, (String[])args, MPJ_ERF_ProbGainCalc.class);
            MPJ_ERF_ProbGainCalc driver = new MPJ_ERF_ProbGainCalc(cmd);
            driver.run();
            MPJ_ERF_ProbGainCalc.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJ_ERF_ProbGainCalc.abortAndExit((Throwable)t);
        }
    }

    private class CalcRunnable
    implements Runnable {
        private FaultSystemSolutionERF erf;
        private Deque<Integer> stack;

        public CalcRunnable(FaultSystemSolutionERF erf, Deque<Integer> stack) {
            this.erf = erf;
            this.stack = stack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (true) {
                try {
                    while (true) {
                        Integer index;
                        Deque<Integer> deque = this.stack;
                        synchronized (deque) {
                            try {
                                index = this.stack.pop();
                            }
                            catch (Exception e) {
                                index = null;
                            }
                        }
                        if (index == null) break block7;
                        U3LogicTreeBranch branch = MPJ_ERF_ProbGainCalc.this.branches.get(index);
                        String name = branch.buildFileName();
                        File subOutputFile = new File(MPJ_ERF_ProbGainCalc.this.outputDir, name + "_subs.csv");
                        File parentOutputFile = new File(MPJ_ERF_ProbGainCalc.this.outputDir, name + "_parents.csv");
                        File mainOutputFile = new File(MPJ_ERF_ProbGainCalc.this.outputDir, name + "_main_faults.csv");
                        if (MPJ_ERF_ProbGainCalc.this.mainFaults && mainOutputFile.exists() || !MPJ_ERF_ProbGainCalc.this.mainFaults && parentOutputFile.exists()) continue;
                        InversionFaultSystemSolution sol = MPJ_ERF_ProbGainCalc.this.cfss.getSolution(branch);
                        this.erf.setSolution(sol);
                        this.erf.getTimeSpan().setDuration(MPJ_ERF_ProbGainCalc.this.duration);
                        if (!MPJ_ERF_ProbGainCalc.this.mainFaults) {
                            FaultSysSolutionERF_Calc.writeSubSectionTimeDependenceCSV(this.erf, subOutputFile);
                            FaultSysSolutionERF_Calc.writeParentSectionTimeDependenceCSV(this.erf, parentOutputFile);
                            continue;
                        }
                        double[] minMags = new double[]{0.0, 6.7, 7.2, 7.7, 8.2};
                        FaultModels fm = branch.getValue(FaultModels.class);
                        FaultSystemRupSet rupSet = ((FaultSystemSolution)sol).getRupSet();
                        HashMap mappings = MPJ_ERF_ProbGainCalc.this.mainFaultsRupMappings.get(fm);
                        if (mappings == null) {
                            mappings = Maps.newHashMap();
                            for (String fault : MPJ_ERF_ProbGainCalc.this.mainFaultsSorted) {
                                Object rups = new HashSet();
                                for (Integer parentID : MPJ_ERF_ProbGainCalc.this.mainFaultsMap.get(fault)) {
                                    List<Integer> parentRups = rupSet.getRupturesForParentSection(parentID);
                                    if (parentRups == null) continue;
                                    ((AbstractCollection)rups).addAll(parentRups);
                                }
                                mappings.put(fault, rups);
                            }
                            MPJ_ERF_ProbGainCalc.this.mainFaultsRupMappings.put(fm, mappings);
                        }
                        CSVFile csv = new CSVFile(true);
                        ArrayList header = Lists.newArrayList((Object[])new String[]{"Name"});
                        for (double minMag : minMags) {
                            header.add("M>=" + (float)minMag);
                            header.add("U3 pBPT");
                            header.add("U3 pPois");
                        }
                        csv.addLine(header);
                        this.erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
                        this.erf.getTimeSpan().setDuration(MPJ_ERF_ProbGainCalc.this.duration);
                        this.erf.updateForecast();
                        Table<String, Double, Double> bptTable = MPJ_ERF_ProbGainCalc.this.calcFaultProbs(this.erf, rupSet, minMags, mappings);
                        this.erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
                        this.erf.getTimeSpan().setDuration(MPJ_ERF_ProbGainCalc.this.duration);
                        this.erf.updateForecast();
                        Table<String, Double, Double> poisTable = MPJ_ERF_ProbGainCalc.this.calcFaultProbs(this.erf, rupSet, minMags, mappings);
                        for (String fault : MPJ_ERF_ProbGainCalc.this.mainFaultsSorted) {
                            ArrayList line = Lists.newArrayList((Object[])new String[]{fault});
                            for (double minMag : minMags) {
                                line.add("");
                                line.add(String.valueOf(bptTable.get((Object)fault, (Object)minMag)));
                                line.add(String.valueOf(poisTable.get((Object)fault, (Object)minMag)));
                            }
                            csv.addLine(line);
                        }
                        csv.writeToFile(mainOutputFile);
                    }
                }
                catch (IOException e) {
                    ExceptionUtils.throwAsRuntimeException(e);
                    continue;
                }
                break;
            }
        }
    }
}

