/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.editor.impl.GriddedParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.ButtonParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.U3AverageFaultSystemSolution;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.UCERF3InversionConfiguration;
import scratch.UCERF3.utils.FindEquivUCERF2_Ruptures.FindEquivUCERF2_FM2pt1_Ruptures;
import scratch.UCERF3.utils.FindEquivUCERF2_Ruptures.FindEquivUCERF2_FM3_Ruptures;
import scratch.UCERF3.utils.FindEquivUCERF2_Ruptures.FindEquivUCERF2_Ruptures;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class RupRateConvergenceGUI
extends JFrame
implements ParameterChangeListener {
    private static final int DEFAULT_PLOT_WIDTH = 100;
    private U3AverageFaultSystemSolution sol;
    private static final String BROWSE_PARAM_NAME = "Browse";
    private FileParameter browseParam = new FileParameter("Browse");
    private static final String UCERF2_PARAM_NAME = "Only UCERF2 Equiv Rups";
    private BooleanParameter ucerf2Param = new BooleanParameter("Only UCERF2 Equiv Rups", false);
    private static final String SDOM_N_PARAM_NAME = "N (for SDOM)";
    private static final Integer SDOM_N_PARAM_MIN = 1;
    private static final Integer SDOM_N_PARAM_MAX = 10000;
    private IntegerParameter sdomNParam = new IntegerParameter("N (for SDOM)", SDOM_N_PARAM_MIN, SDOM_N_PARAM_MAX);
    private static final String LOG_PARAM_NAME = "Log Y Scale";
    private static final Boolean LOG_PARAM_DEFAULT = false;
    private BooleanParameter logParam = new BooleanParameter("Log Y Scale", LOG_PARAM_DEFAULT);
    private static final String PARENT_SECT_FILTER_PARAM_NAME = "Parent Section Filter";
    private static final String PARENT_SECT_FILTER_PARAM_DEFAULT = "(none)";
    private StringParameter parentSectParam;
    private static final String SORT_PARAM_NAME = "Sort By";
    private EnumParameter<SortTypes> sortParam = new EnumParameter<SortTypes>("Sort By", EnumSet.allOf(SortTypes.class), SortTypes.INDEX, null);
    private static final String ZOOM_IN_PARAM_NAME = "Zoom In";
    private ButtonParameter zoomInParam = new ButtonParameter("Zoom In", "+");
    private static final String ZOOM_OUT_PARAM_NAME = "Zoom Out";
    private ButtonParameter zoomOutParam = new ButtonParameter("Zoom Out", "-");
    private static final String START_PARAM_NAME = "Start";
    private ButtonParameter startParam = new ButtonParameter("Start", "|<");
    private static final String PREV_PAGE_PARAM_NAME = "Prev Page";
    private ButtonParameter prevPageParam = new ButtonParameter("Prev Page", "<<<");
    private static final String PREV_HALF_PAGE_PARAM_NAME = "Prev 1/2 Page";
    private ButtonParameter prevHalfPageParam = new ButtonParameter("Prev 1/2 Page", "<<");
    private static final String PREV_RUP_PARAM_NAME = "Prev Rup";
    private ButtonParameter prevRupParam = new ButtonParameter("Prev Rup", "<");
    private static final String END_PARAM_NAME = "End";
    private ButtonParameter endParam = new ButtonParameter("End", ">|");
    private static final String NEXT_PAGE_PARAM_NAME = "Next Page";
    private ButtonParameter nextPageParam = new ButtonParameter("Next Page", ">>>");
    private static final String NEXT_HALF_PAGE_PARAM_NAME = "Next 1/2 Page";
    private ButtonParameter nextHalfPageParam = new ButtonParameter("Next 1/2 Page", ">>");
    private static final String NEXT_RUP_PARAM_NAME = "Next Rup";
    private ButtonParameter nextRupParam = new ButtonParameter("Next Rup", ">");
    private ArrayList<String> parentNames;
    private ArrayList<Integer> parentIDs;
    private HeadlessGraphPanel gp;
    private ArrayList<DiscretizedFunc> funcs;
    private ArrayList<PlotCurveCharacterstics> chars;
    private double[] stdDevs;
    private FindEquivUCERF2_Ruptures ucerf2Rups;
    private EvenlyDiscretizedFunc meanFunc;
    private EvenlyDiscretizedFunc minFunc;
    private EvenlyDiscretizedFunc maxFunc;
    private EvenlyDiscretizedFunc meanPlusStdDevFunc;
    private EvenlyDiscretizedFunc meanMinusStdDevFunc;
    private EvenlyDiscretizedFunc meanPlusStdDevOfMeanFunc;
    private EvenlyDiscretizedFunc meanMinusStdDevOfMeanFunc;
    private ArbitrarilyDiscretizedFunc ucerf2RatesFunc;
    private List<Integer> curRups;
    private ParameterList controlParamList;
    private JTextArea labels;

    public RupRateConvergenceGUI() {
        ParameterList paramList = new ParameterList();
        paramList.addParameter(this.browseParam);
        paramList.addParameter(this.ucerf2Param);
        this.sdomNParam.setValue(SDOM_N_PARAM_MIN);
        paramList.addParameter(this.sdomNParam);
        paramList.addParameter(this.logParam);
        ArrayList parentSects = Lists.newArrayList((Object[])new String[]{PARENT_SECT_FILTER_PARAM_DEFAULT});
        this.parentSectParam = new StringParameter(PARENT_SECT_FILTER_PARAM_NAME, parentSects, PARENT_SECT_FILTER_PARAM_DEFAULT);
        paramList.addParameter(this.parentSectParam);
        paramList.addParameter(this.sortParam);
        this.controlParamList = new ParameterList();
        this.controlParamList.addParameter(this.zoomOutParam);
        this.controlParamList.addParameter(this.zoomInParam);
        this.controlParamList.addParameter(this.startParam);
        this.controlParamList.addParameter(this.prevPageParam);
        this.controlParamList.addParameter(this.prevHalfPageParam);
        this.controlParamList.addParameter(this.prevRupParam);
        this.controlParamList.addParameter(this.nextRupParam);
        this.controlParamList.addParameter(this.nextHalfPageParam);
        this.controlParamList.addParameter(this.nextPageParam);
        this.controlParamList.addParameter(this.endParam);
        for (Parameter<?> param : paramList) {
            param.addParameterChangeListener(this);
        }
        for (Parameter<?> param : this.controlParamList) {
            param.addParameterChangeListener(this);
        }
        GriddedParameterListEditor paramEdit = new GriddedParameterListEditor(paramList, 1, 0);
        GriddedParameterListEditor controlParamEdit = new GriddedParameterListEditor(this.controlParamList, 1, 0);
        this.enableButtons();
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.setContentPane(mainPanel);
        this.gp = new HeadlessGraphPanel();
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.add(paramEdit);
        topPanel.add(controlParamEdit);
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)this.gp, "Center");
        this.labels = new JTextArea("");
        this.labels.setEditable(false);
        mainPanel.add((Component)this.labels, "South");
        this.setTitle("Rupture Rate Convergence GUI");
        this.setSize(1400, 800);
    }

    /*
     * WARNING - void declaration
     */
    private void setSol(U3AverageFaultSystemSolution sol) {
        this.sol = sol;
        this.ucerf2Rups = null;
        if (sol == null) {
            this.meanFunc = null;
            this.minFunc = null;
            this.maxFunc = null;
            this.meanPlusStdDevFunc = null;
            this.meanMinusStdDevFunc = null;
            this.meanPlusStdDevOfMeanFunc = null;
            this.meanMinusStdDevOfMeanFunc = null;
            this.stdDevs = null;
        } else {
            void var4_5;
            int numRups = sol.getRupSet().getNumRuptures();
            this.stdDevs = new double[numRups];
            this.meanFunc = new EvenlyDiscretizedFunc(0.0, numRups, 1.0);
            this.meanFunc.setName("Mean Rate");
            this.minFunc = new EvenlyDiscretizedFunc(0.0, numRups, 1.0);
            this.minFunc.setName("Min Rate");
            this.maxFunc = new EvenlyDiscretizedFunc(0.0, numRups, 1.0);
            this.maxFunc.setName("Max Rate");
            this.meanPlusStdDevFunc = new EvenlyDiscretizedFunc(0.0, numRups, 1.0);
            this.meanPlusStdDevFunc.setName("Mean + Std Dev");
            this.meanMinusStdDevFunc = new EvenlyDiscretizedFunc(0.0, numRups, 1.0);
            this.meanMinusStdDevFunc.setName("Mean - Std Dev");
            this.meanPlusStdDevOfMeanFunc = new EvenlyDiscretizedFunc(0.0, numRups, 1.0);
            this.meanPlusStdDevOfMeanFunc.setName("Mean + Std Dev Of Mean");
            this.meanMinusStdDevOfMeanFunc = new EvenlyDiscretizedFunc(0.0, numRups, 1.0);
            this.meanMinusStdDevOfMeanFunc.setName("Mean - Std Dev Of Mean");
            this.ucerf2RatesFunc = new ArbitrarilyDiscretizedFunc();
            this.ucerf2RatesFunc.setName("UCERF2 Rates");
            this.sdomNParam.setValue(sol.getNumSolutions());
            this.sdomNParam.getEditor().refreshParamEditor();
            ArrayList<double[]> ucerf2_magsAndRates = UCERF3InversionConfiguration.getUCERF2MagsAndrates(sol.getRupSet());
            boolean bl = false;
            while (var4_5 < numRups) {
                double stdDev;
                double mean = sol.getRateForRup((int)var4_5);
                this.stdDevs[var4_5] = stdDev = sol.getRateStdDev((int)var4_5);
                double min = sol.getRateMin((int)var4_5);
                double max = sol.getRateMax((int)var4_5);
                this.meanFunc.set((int)var4_5, mean);
                this.minFunc.set((int)var4_5, min);
                this.maxFunc.set((int)var4_5, max);
                this.meanPlusStdDevFunc.set((int)var4_5, mean + stdDev);
                this.meanMinusStdDevFunc.set((int)var4_5, mean - stdDev);
                double[] ucerf2_vals = ucerf2_magsAndRates.get((int)var4_5);
                if (ucerf2_vals != null) {
                    this.ucerf2RatesFunc.set((double)var4_5, ucerf2_vals[1]);
                }
                ++var4_5;
            }
            this.updateSDOM();
        }
        this.parentNames = Lists.newArrayList((Object[])new String[]{PARENT_SECT_FILTER_PARAM_DEFAULT});
        this.parentIDs = Lists.newArrayList((Object[])new Integer[]{-1});
        if (sol != null) {
            int prevParentID = -2;
            for (FaultSection faultSection : sol.getRupSet().getFaultSectionDataList()) {
                int parentID = faultSection.getParentSectionId();
                if (parentID == prevParentID) continue;
                this.parentNames.add(faultSection.getParentSectionName());
                this.parentIDs.add(parentID);
                prevParentID = parentID;
            }
        }
        this.parentSectParam.removeParameterChangeListener(this);
        this.parentSectParam.setValue(PARENT_SECT_FILTER_PARAM_DEFAULT);
        ((StringConstraint)this.parentSectParam.getConstraint()).setStrings(this.parentNames);
        this.parentSectParam.getEditor().refreshParamEditor();
        this.parentSectParam.addParameterChangeListener(this);
        this.enableButtons();
    }

    private void updateSDOM() {
        if (this.sol == null) {
            return;
        }
        int n = (Integer)this.sdomNParam.getValue();
        for (int i = 0; i < this.sol.getRupSet().getNumRuptures(); ++i) {
            double stdDev = this.stdDevs[i];
            double mean = this.meanFunc.getY(i);
            double sdom = stdDev / Math.sqrt(n);
            this.meanPlusStdDevOfMeanFunc.set(i, mean + sdom);
            this.meanMinusStdDevOfMeanFunc.set(i, mean - sdom);
        }
    }

    private void enableButtons() {
        boolean enable = this.sol != null && this.funcs != null;
        for (Parameter<?> param : this.controlParamList) {
            param.getEditor().setEnabled(enable);
            param.getEditor().refreshParamEditor();
        }
    }

    private void rebuildPlot() {
        this.funcs = Lists.newArrayList();
        this.chars = Lists.newArrayList();
        if (this.sol != null) {
            float normalWidth = 4.0f;
            float meanWidth = 10.0f;
            this.funcs.add(this.meanFunc);
            this.chars.add(new PlotCurveCharacterstics(PlotSymbol.DASH, meanWidth, Color.BLACK));
            this.funcs.add(this.minFunc);
            this.chars.add(new PlotCurveCharacterstics(PlotSymbol.DASH, normalWidth, Color.RED));
            this.funcs.add(this.maxFunc);
            this.chars.add(new PlotCurveCharacterstics(PlotSymbol.DASH, normalWidth, Color.RED));
            this.funcs.add(this.meanPlusStdDevFunc);
            this.chars.add(new PlotCurveCharacterstics(PlotSymbol.DASH, normalWidth, Color.GREEN));
            this.funcs.add(this.meanMinusStdDevFunc);
            this.chars.add(new PlotCurveCharacterstics(PlotSymbol.DASH, normalWidth, Color.GREEN));
            this.funcs.add(this.meanPlusStdDevOfMeanFunc);
            this.chars.add(new PlotCurveCharacterstics(PlotSymbol.DASH, normalWidth, Color.BLUE));
            this.funcs.add(this.meanMinusStdDevOfMeanFunc);
            this.chars.add(new PlotCurveCharacterstics(PlotSymbol.DASH, normalWidth, Color.BLUE));
            this.funcs.add(this.ucerf2RatesFunc);
            this.chars.add(new PlotCurveCharacterstics(PlotSymbol.X, normalWidth * 0.5f, Color.GRAY));
            if (this.sol != null && ((Boolean)this.ucerf2Param.getValue()).booleanValue()) {
                System.out.println("Using UCERF2 Rups!");
                if (this.ucerf2Rups == null) {
                    this.ucerf2Rups = this.sol.getRupSet().getFaultModel() == FaultModels.FM2_1 ? new FindEquivUCERF2_FM2pt1_Ruptures(this.sol.getRupSet(), UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR) : new FindEquivUCERF2_FM3_Ruptures((FaultSystemRupSet)this.sol.getRupSet(), UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, this.sol.getRupSet().getFaultModel());
                }
                this.curRups = Lists.newArrayList();
                HashSet<Integer> rupsSet = new HashSet<Integer>();
                for (int r = 0; r < this.ucerf2Rups.getNumUCERF2_Ruptures(); ++r) {
                    int ind = this.ucerf2Rups.getEquivFaultSystemRupIndexForUCERF2_Rupture(r);
                    if (ind < 0 || rupsSet.contains(ind)) continue;
                    this.curRups.add(ind);
                    rupsSet.add(ind);
                }
            } else {
                this.curRups = Lists.newArrayList();
                for (int i = 0; i < this.sol.getRupSet().getNumRuptures(); ++i) {
                    this.curRups.add(i);
                }
            }
            if (!((String)this.parentSectParam.getValue()).equals(PARENT_SECT_FILTER_PARAM_DEFAULT)) {
                String parentName = (String)this.parentSectParam.getValue();
                int parentID = this.parentIDs.get(this.parentNames.indexOf(parentName));
                ArrayList subSet = Lists.newArrayList();
                for (int r : this.curRups) {
                    List<Integer> parents = this.sol.getRupSet().getParentSectionsForRup(r);
                    if (!parents.contains(parentID)) continue;
                    subSet.add(r);
                }
                this.curRups = subSet;
            }
            if (this.curRups.isEmpty()) {
                this.funcs = Lists.newArrayList();
                this.chars = Lists.newArrayList();
            } else {
                Collections.sort(this.curRups, ((SortTypes)((Object)this.sortParam.getValue())).getComparator(this.sol, (Integer)this.sdomNParam.getValue()));
                this.funcs = this.getForSubset();
                int minX = 0;
                int maxX = 99;
                if (maxX >= this.curRups.size()) {
                    maxX = this.curRups.size() - 1;
                }
                double[] yBounds = this.getYBounds(minX, maxX);
                this.gp.setUserBounds(minX, maxX, yBounds[0], yBounds[1]);
                this.updateSectionsLabel(minX, maxX);
            }
        }
        if (this.funcs.size() == 0) {
            this.updateSectionsLabel(-1, -1);
        }
        this.drawGraph();
        this.enableButtons();
    }

    private ArrayList<DiscretizedFunc> getForSubset() {
        ArrayList newFuncs = Lists.newArrayList();
        for (DiscretizedFunc func : this.funcs) {
            int i;
            AbstractDiscretizedFunc newFunc;
            if (func instanceof EvenlyDiscretizedFunc) {
                newFunc = new EvenlyDiscretizedFunc(0.0, this.curRups.size(), 1.0);
                newFunc.setName(func.getName());
                for (i = 0; i < this.curRups.size(); ++i) {
                    ((EvenlyDiscretizedFunc)newFunc).set(i, func.getY(this.curRups.get(i)));
                }
                newFuncs.add(newFunc);
                continue;
            }
            newFunc = new ArbitrarilyDiscretizedFunc();
            newFunc.setName(func.getName());
            for (i = 0; i < this.curRups.size(); ++i) {
                int ind = func.getXIndex(this.curRups.get(i).intValue());
                if (ind < 0) continue;
                ((ArbitrarilyDiscretizedFunc)newFunc).set((double)i, func.getY(ind));
            }
            newFuncs.add(newFunc);
        }
        return newFuncs;
    }

    private void drawGraph() {
        this.gp.setYLog((Boolean)this.logParam.getValue());
        this.gp.drawGraphPanel("Rupture Index", "Rate", this.funcs, this.chars, "Rup Rate Convergence");
    }

    private double[] getYBounds(int minX, int maxX) {
        double minY = Double.POSITIVE_INFINITY;
        double minNonZero = Double.POSITIVE_INFINITY;
        double maxY = 0.0;
        for (DiscretizedFunc func : this.funcs) {
            int x;
            if (func instanceof EvenlyDiscretizedFunc) {
                for (x = minX; x <= maxX; ++x) {
                    double y = func.getY(x);
                    if (y < minY) {
                        minY = y;
                    }
                    if (y > maxY) {
                        maxY = y;
                    }
                    if (!(y > 0.0) || !(y < minNonZero)) continue;
                    minNonZero = y;
                }
                continue;
            }
            for (x = minX; x <= maxX; ++x) {
                int ind = func.getXIndex(x);
                if (ind < 0) continue;
                double y = func.getY(ind);
                if (y < minY) {
                    minY = y;
                }
                if (y > maxY) {
                    maxY = y;
                }
                if (!(y > 0.0) || !(y < minNonZero)) continue;
                minNonZero = y;
            }
        }
        if (((Boolean)this.logParam.getValue()).booleanValue()) {
            minY = minNonZero;
        }
        if (Double.isInfinite(minY) || minY > maxY) {
            minY = maxY;
        }
        if (((Boolean)this.logParam.getValue()).booleanValue()) {
            if (minY <= 0.0) {
                minY = 1.0E-10;
            }
            if (maxY < minY) {
                maxY = minY;
            }
        }
        double[] ret = new double[]{minY, maxY};
        return ret;
    }

    private void updatePlotRange(int min, int max) {
        double[] yBounds = this.getYBounds(min, max);
        double minY = yBounds[0] * 0.9;
        double maxY = yBounds[1] * 1.1;
        this.gp.setUserBounds(min, max, minY, maxY);
        this.gp.getXAxis().setRange((double)min, (double)max);
        this.gp.getYAxis().setRange(minY, maxY);
        this.updateSectionsLabel(min, max);
    }

    private void updateSectionsLabel(int minX, int maxX) {
        String endLabel;
        String startLabel;
        if (this.sol == null || minX < 0) {
            startLabel = "";
            endLabel = "";
        } else {
            int startRup = this.curRups.get(minX);
            int endRup = this.curRups.get(maxX);
            startLabel = this.getLabelForRup(startRup);
            endLabel = this.getLabelForRup(endRup);
        }
        String label = "FIRST RUP:\t" + startLabel + "\nLAST RUP:\t" + endLabel;
        this.labels.setText(label);
    }

    private String getLabelForRup(int rupIndex) {
        List<Integer> inds = this.sol.getRupSet().getSectionsIndicesForRup(rupIndex);
        ArrayList parentNames = Lists.newArrayList();
        int lastParentID = -2;
        for (int ind : inds) {
            FaultSection sect = this.sol.getRupSet().getFaultSectionData(ind);
            int parent = sect.getParentSectionId();
            if (parent == lastParentID) continue;
            parentNames.add(sect.getParentSectionName());
            lastParentID = parent;
        }
        return "Mag: " + (float)this.sol.getRupSet().getMagForRup(rupIndex) + "\tParent Sects: " + Joiner.on((String)"; ").join((Iterable)parentNames);
    }

    private int[] getCurrentBounds() {
        int max;
        int min;
        try {
            min = (int)this.gp.getX_AxisRange().getLowerBound();
            max = (int)this.gp.getX_AxisRange().getUpperBound();
        }
        catch (Exception e) {
            min = 0;
            max = 0;
        }
        int[] ret = new int[]{min, max};
        return ret;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        Parameter param = event.getParameter();
        int[] range = this.getCurrentBounds();
        int min = range[0];
        if (min < 0) {
            min = 0;
        }
        int max = range[1];
        int num = max - min;
        if (param == this.browseParam) {
            U3AverageFaultSystemSolution sol = null;
            try {
                sol = U3FaultSystemIO.loadAvgInvSol((File)this.browseParam.getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error loading average solution:\n" + e.getMessage(), "Error Loading Average Solution", 0);
            }
            this.setSol(sol);
            this.rebuildPlot();
        } else if (param == this.ucerf2Param) {
            this.rebuildPlot();
        } else if (param == this.sdomNParam) {
            int[] bounds = this.getCurrentBounds();
            this.updateSDOM();
            this.rebuildPlot();
            this.updatePlotRange(bounds[0], bounds[1]);
        } else if (param == this.logParam) {
            int[] bounds = this.getCurrentBounds();
            this.rebuildPlot();
            this.updatePlotRange(bounds[0], bounds[1]);
        } else if (param == this.parentSectParam) {
            this.rebuildPlot();
        } else if (param == this.sortParam) {
            this.rebuildPlot();
        } else {
            int size;
            int totSize = this.funcs.get(0).size();
            if (param == this.startParam) {
                min = 0;
                max = num;
            } else if (param == this.prevPageParam) {
                min -= num;
                max -= num;
            } else if (param == this.prevHalfPageParam) {
                min -= num / 2;
                max -= num / 2;
            } else if (param == this.prevRupParam) {
                --min;
                --max;
            } else if (param == this.endParam) {
                max = totSize - 1;
                min = max - num;
            } else if (param == this.nextPageParam) {
                min += num;
                max += num;
            } else if (param == this.nextHalfPageParam) {
                min += num / 2;
                max += num / 2;
            } else if (param == this.nextRupParam) {
                ++min;
                ++max;
            } else if (param == this.zoomInParam) {
                size = (int)((double)num * 2.0 / 3.0);
                max = min + size;
            } else if (param == this.zoomOutParam) {
                size = (int)((double)num * 1.5);
                max = min + size;
            }
            if (min < 0) {
                int below = 0 - min;
                min += below;
                max += below;
            } else if (max >= totSize) {
                int above = max - totSize;
                max -= above;
                min -= above;
            }
            this.updatePlotRange(min, max);
        }
    }

    public static void main(String[] args) {
        RupRateConvergenceGUI gui = new RupRateConvergenceGUI();
        gui.setVisible(true);
        gui.setDefaultCloseOperation(3);
    }

    private static enum SortTypes {
        INDEX("Rupture Index"){

            @Override
            public Comparator<Integer> getComparator(U3AverageFaultSystemSolution sol, int n) {
                return new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return o1.compareTo(o2);
                    }
                };
            }
        }
        ,
        MAG_INCREASING("Mag (Increasing)"){

            @Override
            public Comparator<Integer> getComparator(final U3AverageFaultSystemSolution sol, int n) {
                return new Comparator<Integer>(){
                    final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        double m1 = sol.getRupSet().getMagForRup(o1);
                        double m2 = sol.getRupSet().getMagForRup(o2);
                        return Double.compare(m1, m2);
                    }
                };
            }
        }
        ,
        MAG_DECREASING("Mag (Decreasing)"){

            @Override
            public Comparator<Integer> getComparator(final U3AverageFaultSystemSolution sol, int n) {
                return new Comparator<Integer>(){
                    final /* synthetic */ 3 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        double m1 = sol.getRupSet().getMagForRup(o1);
                        double m2 = sol.getRupSet().getMagForRup(o2);
                        return -Double.compare(m1, m2);
                    }
                };
            }
        }
        ,
        STD_DEV_OVER_MEAN("Std Dev / Mean"){

            @Override
            public Comparator<Integer> getComparator(final U3AverageFaultSystemSolution sol, int n) {
                return new Comparator<Integer>(){
                    final /* synthetic */ 4 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        double d1 = sol.getRateStdDev(o1) / sol.getRateForRup(o1);
                        double d2 = sol.getRateStdDev(o2) / sol.getRateForRup(o2);
                        return Double.compare(d1, d2);
                    }
                };
            }
        }
        ,
        STD_DEV_OF_MEAN_OVER_MEAN("SDOM / Mean"){

            @Override
            public Comparator<Integer> getComparator(final U3AverageFaultSystemSolution sol, final int n) {
                return new Comparator<Integer>(){
                    final /* synthetic */ 5 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        double stdDev1 = sol.getRateStdDev(o1);
                        double stdDev2 = sol.getRateStdDev(o2);
                        double mean1 = sol.getRateForRup(o1);
                        double mean2 = sol.getRateForRup(o2);
                        double sdom1 = stdDev1 / Math.sqrt(n);
                        double sdom2 = stdDev2 / Math.sqrt(n);
                        double d1 = sdom1 / mean1;
                        double d2 = sdom2 / mean2;
                        return Double.compare(d1, d2);
                    }
                };
            }
        };

        private String name;

        private SortTypes(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public abstract Comparator<Integer> getComparator(U3AverageFaultSystemSolution var1, int var2);
    }
}

