/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.enumTreeBranches;

import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.sha.earthquake.faultSysSolution.util.MaxMagOffFaultBranchNode;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv")})
@Affects(value="rates.csv")
public enum MaxMagOffFault implements U3LogicTreeBranchNode<MaxMagOffFault>,
MaxMagOffFaultBranchNode
{
    MAG_7p3(7.3, 0.1, 0.1),
    MAG_7p6(7.6, 0.8, 0.8),
    MAG_7p9(7.9, 0.1, 0.1),
    MAG_7p2(7.2, 0.0, 0.0),
    MAG_8p0(8.0, 0.0, 0.0);

    private double mmax;
    private double charWeight;
    private double grWeight;

    private MaxMagOffFault(double mmax, double charWeight, double grWeight) {
        this.mmax = mmax;
        this.charWeight = charWeight;
        this.grWeight = grWeight;
    }

    @Override
    public String getName() {
        String name = "" + (float)this.mmax;
        if (!name.contains(".")) {
            name = name + ".0";
        }
        return name;
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public double getRelativeWeight(InversionModels im) {
        if (im == null || im.isCharacteristic()) {
            return this.charWeight;
        }
        return this.grWeight;
    }

    @Override
    public double getMaxMagOffFault() {
        return this.mmax;
    }

    @Override
    public String encodeChoiceString() {
        return "MMaxOff" + this.getShortName();
    }

    @Override
    public String getBranchLevelName() {
        return "MMax Off Fault";
    }

    @Override
    public String getShortBranchLevelName() {
        return "MMaxOFf";
    }
}

