/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.enumTreeBranches;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.Ellsworth_B_WG02_MagAreaRel;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.HanksBakun2002_MagAreaRel;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.Shaw_2009_ModifiedMagAreaRel;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.TMG2017CruMagAreaRel;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.TMG2017SubMagAreaRel;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.sha.earthquake.faultSysSolution.RupSetScalingRelationship;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv")})
@Affects.Affected(value={@Affects(value="properties.csv"), @Affects(value="rates.csv")})
public enum ScalingRelationships implements U3LogicTreeBranchNode<ScalingRelationships>,
RupSetScalingRelationship
{
    AVE_UCERF2("Average UCERF2", "AveU2"){

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            double areaKm = area / 1000000.0;
            double mag = (ellB_magArea.getMedianMag(areaKm) + hb_magArea.getMedianMag(areaKm)) / 2.0;
            double moment = MagUtils.magToMoment(mag);
            return FaultMomentCalc.getSlip(area, moment);
        }

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            double areaKm = area / 1000000.0;
            return (ellB_magArea.getMedianMag(areaKm) + hb_magArea.getMedianMag(areaKm)) / 2.0;
        }

        @Override
        public double getArea(double mag, double origWidth) {
            return Double.NaN;
        }

        @Override
        public double getRelativeWeight(InversionModels im) {
            return 0.0;
        }
    }
    ,
    SHAW_2009_MOD("Shaw (2009) Modified", "Shaw09Mod"){

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            double mag = this.getMag(area, length, width, origWidth, aveRake);
            double moment = MagUtils.magToMoment(mag);
            return FaultMomentCalc.getSlip(area, moment);
        }

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return sh09_ModMagArea.getWidthDepMedianMag(area * 1.0E-6, origWidth * 0.001);
        }

        @Override
        public double getArea(double mag, double origWidth) {
            return sh09_ModMagArea.getMedianArea(mag) * 1000000.0;
        }

        @Override
        public double getRelativeWeight(InversionModels im) {
            return 0.2;
        }
    }
    ,
    HANKS_BAKUN_08("Hanks & Bakun (2008)", "HB08"){

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            double mag = hb_magArea.getMedianMag(area / 1000000.0);
            double moment = MagUtils.magToMoment(mag);
            return FaultMomentCalc.getSlip(area, moment);
        }

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return hb_magArea.getMedianMag(area * 1.0E-6);
        }

        @Override
        public double getArea(double mag, double origWidth) {
            return hb_magArea.getMedianArea(mag) * 1000000.0;
        }

        @Override
        public double getRelativeWeight(InversionModels im) {
            return 0.2;
        }
    }
    ,
    ELLSWORTH_B("Ellsworth B", "EllB"){

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            double mag = ellB_magArea.getMedianMag(area / 1000000.0);
            double moment = MagUtils.magToMoment(mag);
            return FaultMomentCalc.getSlip(area, moment);
        }

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return ellB_magArea.getMedianMag(area * 1.0E-6);
        }

        @Override
        public double getArea(double mag, double origWidth) {
            return ellB_magArea.getMedianArea(mag) * 1000000.0;
        }

        @Override
        public double getRelativeWeight(InversionModels im) {
            return 0.2;
        }
    }
    ,
    ELLB_SQRT_LENGTH("EllB M(A) & Shaw12 Sqrt Length D(L)", "EllBsqrtLen"){

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            double impliedAseis = 1.0 - area / length / origWidth;
            if (impliedAseis >= 0.2) {
                double moment = MagUtils.magToMoment(this.getMag(area, length, width, origWidth, aveRake));
                return FaultMomentCalc.getSlip(area, moment);
            }
            double c6 = 5.69E-5;
            double xi = 1.25;
            double w = 15000.0;
            return c6 * Math.sqrt(length * w);
        }

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return ellB_magArea.getMedianMag(area * 1.0E-6);
        }

        @Override
        public double getArea(double mag, double origWidth) {
            return ellB_magArea.getMedianArea(mag) * 1000000.0;
        }

        @Override
        public double getRelativeWeight(InversionModels im) {
            return 0.2;
        }
    }
    ,
    SHAW_CONST_STRESS_DROP("Shaw09 M(A) & Shaw12 Const Stress Drop D(L)", "ShConStrDrp"){

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            double impliedAseis = 1.0 - area / length / origWidth;
            if (impliedAseis >= 0.2) {
                double moment = MagUtils.magToMoment(this.getMag(area, length, width, origWidth, aveRake));
                return FaultMomentCalc.getSlip(area, moment);
            }
            double stressDrop = 4.54;
            double xi = 1.25;
            double w = 15000.0;
            double temp = 1.0 / (7.0 / (3.0 * length) + 1.0 / (2.0 * w)) * 1000000.0;
            return stressDrop * temp / 3.0E10;
        }

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            return sh09_ModMagArea.getWidthDepMedianMag(area * 1.0E-6, origWidth * 0.001);
        }

        @Override
        public double getArea(double mag, double origWidth) {
            return sh09_ModMagArea.getMedianArea(mag) * 1000000.0;
        }

        @Override
        public double getRelativeWeight(InversionModels im) {
            return 0.2;
        }
    }
    ,
    MEAN_UCERF3("Mean UCERF3 Scaling Relationship", "MeanU3Scale"){
        private ScalingRelationships[] scales;
        private double[] weights;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkInit() {
            if (this.weights == null) {
                7 var1_1 = this;
                synchronized (var1_1) {
                    if (this.weights == null) {
                        int i;
                        ScalingRelationships[] scales = new ScalingRelationships[]{SHAW_2009_MOD, HANKS_BAKUN_08, ELLSWORTH_B, ELLB_SQRT_LENGTH, SHAW_CONST_STRESS_DROP};
                        double[] weights = new double[scales.length];
                        double sum = 0.0;
                        for (i = 0; i < scales.length; ++i) {
                            double weight = scales[i].getRelativeWeight(null);
                            Preconditions.checkState((weight > 0.0 ? 1 : 0) != 0);
                            weights[i] = weight;
                            sum += weight;
                        }
                        if (sum != 1.0) {
                            i = 0;
                            while (i < weights.length) {
                                int n = i++;
                                weights[n] = weights[n] / sum;
                            }
                        }
                        this.scales = scales;
                        this.weights = weights;
                    }
                }
            }
        }

        @Override
        public double getRelativeWeight(InversionModels im) {
            return 0.0;
        }

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            this.checkInit();
            double slip = 0.0;
            for (int i = 0; i < this.weights.length; ++i) {
                slip += this.weights[i] * this.scales[i].getAveSlip(area, length, width, origWidth, aveRake);
            }
            return slip;
        }

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            this.checkInit();
            double mag = 0.0;
            for (int i = 0; i < this.weights.length; ++i) {
                mag += this.weights[i] * this.scales[i].getMag(area, length, width, origWidth, aveRake);
            }
            return mag;
        }

        @Override
        public double getArea(double mag, double origWidth) {
            this.checkInit();
            double area = 0.0;
            for (int i = 0; i < this.weights.length; ++i) {
                area += this.weights[i] * this.scales[i].getArea(mag, origWidth);
            }
            return area;
        }
    }
    ,
    TMG_SUB_2017("Thingbaijam et al.(2017) Subduction", "TMG_SUB_2017"){
        private TMG2017SubMagAreaRel tmg_sub_magArea = new TMG2017SubMagAreaRel(90.0);

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            this.tmg_sub_magArea.setRake(aveRake);
            double mag = this.tmg_sub_magArea.getMedianMag(area * 1.0E-6);
            double moment = MagUtils.magToMoment(mag);
            return FaultMomentCalc.getSlip(area, moment);
        }

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            this.tmg_sub_magArea.setRake(aveRake);
            return this.tmg_sub_magArea.getMedianMag(area * 1.0E-6);
        }

        @Override
        public double getArea(double mag, double origWidth) {
            return this.tmg_sub_magArea.getMedianArea(mag) * 1000000.0;
        }

        @Override
        public double getRelativeWeight(InversionModels im) {
            return 0.0;
        }
    }
    ,
    TMG_CRU_2017("Thingbaijam et al.(2017) Crustal", "TMG_CRU_2017"){
        private TMG2017CruMagAreaRel tmg_cru_magArea = new TMG2017CruMagAreaRel(0.0);

        @Override
        public double getAveSlip(double area, double length, double width, double origWidth, double aveRake) {
            this.tmg_cru_magArea.setRake(aveRake);
            double mag = this.tmg_cru_magArea.getMedianMag(area * 1.0E-6);
            double moment = MagUtils.magToMoment(mag);
            return FaultMomentCalc.getSlip(area, moment);
        }

        @Override
        public double getMag(double area, double length, double width, double origWidth, double aveRake) {
            this.tmg_cru_magArea.setRake(aveRake);
            return this.tmg_cru_magArea.getMedianMag(area * 1.0E-6);
        }

        @Override
        public double getArea(double mag, double origWidth) {
            return this.tmg_cru_magArea.getMedianArea(mag) * 1000000.0;
        }

        @Override
        public double getRelativeWeight(InversionModels im) {
            return 0.0;
        }
    };

    private static Ellsworth_B_WG02_MagAreaRel ellB_magArea;
    private static HanksBakun2002_MagAreaRel hb_magArea;
    private static Shaw_2009_ModifiedMagAreaRel sh09_ModMagArea;
    private String name;
    private String shortName;

    private ScalingRelationships(String name, String shortName) {
        this.name = name;
        this.shortName = shortName;
    }

    public abstract double getArea(double var1, double var3);

    @Override
    public String encodeChoiceString() {
        return this.getShortName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getBranchLevelName() {
        return "Scaling Relationship";
    }

    @Override
    public String getShortBranchLevelName() {
        return "Scale";
    }

    public static void makeSlipLengthPlot(double downDipWidth, int maxLength, boolean saveFiles) {
        ArbitrarilyDiscretizedFunc u2_func = new ArbitrarilyDiscretizedFunc();
        u2_func.setName("AVE_UCERF2");
        ArbitrarilyDiscretizedFunc sh09_funcMod = new ArbitrarilyDiscretizedFunc();
        sh09_funcMod.setName("SHAW_2009_MOD");
        ArbitrarilyDiscretizedFunc ellB_func = new ArbitrarilyDiscretizedFunc();
        ellB_func.setName("ELLSWORTH_B");
        ArbitrarilyDiscretizedFunc hb_func = new ArbitrarilyDiscretizedFunc();
        hb_func.setName("HANKS_BAKUN_08");
        ArbitrarilyDiscretizedFunc sh12_sqrtL_func = new ArbitrarilyDiscretizedFunc();
        sh12_sqrtL_func.setName("ELLB_SQRT_LENGTH");
        ArbitrarilyDiscretizedFunc sh12_csd_func = new ArbitrarilyDiscretizedFunc();
        sh12_csd_func.setName("SHAW_CONST_STRESS_DROP");
        ScalingRelationships u2 = AVE_UCERF2;
        ScalingRelationships sh09_Mod = SHAW_2009_MOD;
        ScalingRelationships ellB = ELLSWORTH_B;
        ScalingRelationships hb = HANKS_BAKUN_08;
        ScalingRelationships sh12_sqrtL = ELLB_SQRT_LENGTH;
        ScalingRelationships sh12_csd = SHAW_CONST_STRESS_DROP;
        for (int i = 1; i <= maxLength; ++i) {
            double lengthKm = i;
            double length = lengthKm * 1000.0;
            double area = length * downDipWidth * 1000.0;
            double rake = Double.NaN;
            u2_func.set(lengthKm, u2.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            sh09_funcMod.set(lengthKm, sh09_Mod.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            ellB_func.set(lengthKm, ellB.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            hb_func.set(lengthKm, hb.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            sh12_sqrtL_func.set(lengthKm, sh12_sqrtL.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            sh12_csd_func.set(lengthKm, sh12_csd.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
        }
        ArrayList<ArbitrarilyDiscretizedFunc> funcs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        funcs.add(sh09_funcMod);
        funcs.add(ellB_func);
        funcs.add(hb_func);
        funcs.add(sh12_sqrtL_func);
        funcs.add(sh12_csd_func);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.GREEN));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.MAGENTA));
        GraphWindow graph = new GraphWindow(funcs, "Slip-Length Relationships; DDW=" + downDipWidth + " km", plotChars);
        graph.setX_AxisLabel("Length (km)");
        graph.setY_AxisLabel("Slip (m)");
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(18);
        graph.setTickLabelFontSize(16);
        if (saveFiles) {
            try {
                graph.saveAsPDF("slipLengthScalingPlot.pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void makeSlipAreaPlot(double downDipWidth, int maxLength, boolean saveFiles) {
        ArbitrarilyDiscretizedFunc u2_func = new ArbitrarilyDiscretizedFunc();
        u2_func.setName("AVE_UCERF2");
        ArbitrarilyDiscretizedFunc sh09_funcMod = new ArbitrarilyDiscretizedFunc();
        sh09_funcMod.setName("SHAW_2009_MOD");
        ArbitrarilyDiscretizedFunc ellB_func = new ArbitrarilyDiscretizedFunc();
        ellB_func.setName("ELLSWORTH_B");
        ArbitrarilyDiscretizedFunc hb_func = new ArbitrarilyDiscretizedFunc();
        hb_func.setName("HANKS_BAKUN_08");
        ArbitrarilyDiscretizedFunc sh12_sqrtL_func = new ArbitrarilyDiscretizedFunc();
        sh12_sqrtL_func.setName("ELLB_SQRT_LENGTH");
        ArbitrarilyDiscretizedFunc sh12_csd_func = new ArbitrarilyDiscretizedFunc();
        sh12_csd_func.setName("SHAW_CONST_STRESS_DROP");
        ScalingRelationships u2 = AVE_UCERF2;
        ScalingRelationships sh09_Mod = SHAW_2009_MOD;
        ScalingRelationships ellB = ELLSWORTH_B;
        ScalingRelationships hb = HANKS_BAKUN_08;
        ScalingRelationships sh12_sqrtL = ELLB_SQRT_LENGTH;
        ScalingRelationships sh12_csd = SHAW_CONST_STRESS_DROP;
        for (int i = 1; i <= maxLength; ++i) {
            double lengthKm = i;
            double length = lengthKm * 1000.0;
            double area = length * downDipWidth * 1000.0;
            double areaKm = area * 1.0E-6;
            double rake = Double.NaN;
            u2_func.set(areaKm, u2.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            sh09_funcMod.set(areaKm, sh09_Mod.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            ellB_func.set(areaKm, ellB.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            hb_func.set(areaKm, hb.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            sh12_sqrtL_func.set(areaKm, sh12_sqrtL.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            sh12_csd_func.set(areaKm, sh12_csd.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
        }
        ArrayList<ArbitrarilyDiscretizedFunc> funcs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        funcs.add(sh09_funcMod);
        funcs.add(ellB_func);
        funcs.add(hb_func);
        funcs.add(sh12_sqrtL_func);
        funcs.add(sh12_csd_func);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.GREEN));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.MAGENTA));
        GraphWindow graph = new GraphWindow(funcs, "Slip-Area Relationships; DDW=" + downDipWidth + " km", plotChars);
        graph.setX_AxisLabel("Area (km-sq)");
        graph.setY_AxisLabel("Slip (m)");
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(18);
        graph.setTickLabelFontSize(16);
        if (saveFiles) {
            try {
                graph.saveAsPDF("slipAreaScalingPlot.pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void makeSlipMagPlot(double downDipWidth, int maxLength, boolean saveFiles) {
        ArbitrarilyDiscretizedFunc heckerEq9b = new ArbitrarilyDiscretizedFunc();
        heckerEq9b.setName("Hecker Eq 9b");
        ArbitrarilyDiscretizedFunc sh09_funcMod = new ArbitrarilyDiscretizedFunc();
        sh09_funcMod.setName("SHAW_2009_MOD");
        ArbitrarilyDiscretizedFunc ellB_func = new ArbitrarilyDiscretizedFunc();
        ellB_func.setName("ELLSWORTH_B");
        ArbitrarilyDiscretizedFunc hb_func = new ArbitrarilyDiscretizedFunc();
        hb_func.setName("HANKS_BAKUN_08");
        ArbitrarilyDiscretizedFunc sh12_sqrtL_func = new ArbitrarilyDiscretizedFunc();
        sh12_sqrtL_func.setName("ELLB_SQRT_LENGTH");
        ArbitrarilyDiscretizedFunc sh12_csd_func = new ArbitrarilyDiscretizedFunc();
        sh12_csd_func.setName("SHAW_CONST_STRESS_DROP");
        ScalingRelationships sh09_Mod = SHAW_2009_MOD;
        ScalingRelationships ellB = ELLSWORTH_B;
        ScalingRelationships hb = HANKS_BAKUN_08;
        ScalingRelationships sh12_sqrtL = ELLB_SQRT_LENGTH;
        ScalingRelationships sh12_csd = SHAW_CONST_STRESS_DROP;
        for (int i = (int)downDipWidth; i <= maxLength; ++i) {
            double lengthKm = i;
            double length = lengthKm * 1000.0;
            double area = length * downDipWidth * 1000.0;
            double rake = Double.NaN;
            sh09_funcMod.set(sh09_Mod.getMag(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake), sh09_Mod.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            ellB_func.set(ellB.getMag(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake), ellB.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            hb_func.set(hb.getMag(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake), hb.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            sh12_sqrtL_func.set(ellB.getMag(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake), sh12_sqrtL.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            sh12_csd_func.set(sh09_Mod.getMag(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake), sh12_csd.getAveSlip(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            double heckerMag = hb.getMag(area, length, downDipWidth * 1000.0, downDipWidth * 1000.0, rake);
            double heckerSlip = Math.pow(10.0, 0.41 * heckerMag - 2.79);
            heckerEq9b.set(heckerMag, heckerSlip);
        }
        ArrayList<ArbitrarilyDiscretizedFunc> funcs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        funcs.add(sh09_funcMod);
        funcs.add(ellB_func);
        funcs.add(hb_func);
        funcs.add(sh12_sqrtL_func);
        funcs.add(sh12_csd_func);
        funcs.add(heckerEq9b);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.GREEN));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.MAGENTA));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.CYAN));
        GraphWindow graph = new GraphWindow(funcs, "Implied Slip vs Mag Relationships; DDW=" + downDipWidth + " km", plotChars);
        graph.setX_AxisLabel("Magnitude");
        graph.setY_AxisLabel("Slip (m)");
        graph.setX_AxisRange(6.0, 8.5);
        graph.setY_AxisRange(0.0, 20.0);
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(18);
        graph.setTickLabelFontSize(16);
        if (saveFiles) {
            try {
                graph.saveAsPDF("slipMagScalingPlot.pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void testCreepingSectionSlips() {
        double lengthKm = 150.0;
        double origWidthKm = 11.0;
        double widthKm = 1.2;
        double areaKm = lengthKm * widthKm;
        ArrayList<ScalingRelationships> magAreaList = new ArrayList<ScalingRelationships>();
        magAreaList.add(ELLSWORTH_B);
        magAreaList.add(HANKS_BAKUN_08);
        magAreaList.add(SHAW_2009_MOD);
        ArrayList<ScalingRelationships> aveSlipForRupModelsList = new ArrayList<ScalingRelationships>();
        aveSlipForRupModelsList.add(ELLSWORTH_B);
        aveSlipForRupModelsList.add(HANKS_BAKUN_08);
        aveSlipForRupModelsList.add(SHAW_2009_MOD);
        aveSlipForRupModelsList.add(ELLB_SQRT_LENGTH);
        aveSlipForRupModelsList.add(SHAW_CONST_STRESS_DROP);
        FaultModels fm = FaultModels.FM3_1;
        DeformationModels dm = DeformationModels.GEOLOGIC;
        Object result = "CREEPING SECTION Mag and AveSlip (assuming length=150, origDDW=11, and DDW=1.2 km):\n";
        for (ScalingRelationships scale : ScalingRelationships.values()) {
            double mag = scale.getMag(areaKm * 1000000.0, lengthKm * 1000.0, widthKm * 1000.0, origWidthKm * 1000.0, Double.NaN);
            double slip = scale.getAveSlip(areaKm * 1000000.0, lengthKm * 1000.0, widthKm * 1000.0, origWidthKm * 1000.0, Double.NaN);
            mag = (double)Math.round(mag * 100.0) / 100.0;
            slip = (double)Math.round(slip * 100.0) / 100.0;
            result = (String)result + (float)mag + "\t" + (float)slip + "\tfor\t" + scale.getShortName() + "\n";
        }
        System.out.println((String)result);
    }

    public static void makeMagAreaPlot(boolean saveFiles) {
        double downDipWidth = 11.0;
        ArbitrarilyDiscretizedFunc sh09mod_func = new ArbitrarilyDiscretizedFunc();
        sh09mod_func.setName("SHAW_2009_Mod; downDipWidth=" + downDipWidth);
        ArbitrarilyDiscretizedFunc ellB_func = new ArbitrarilyDiscretizedFunc();
        ellB_func.setName("ELLSWORTH_B");
        ArbitrarilyDiscretizedFunc hb_func = new ArbitrarilyDiscretizedFunc();
        hb_func.setName("HANKS_BAKUN_08");
        ScalingRelationships sh09mod = SHAW_2009_MOD;
        ScalingRelationships ellB = ELLSWORTH_B;
        ScalingRelationships hb = HANKS_BAKUN_08;
        for (int i = 50; i <= 20000; i += 10) {
            double area = i;
            double rake = Double.NaN;
            sh09mod_func.set(area, sh09mod.getMag(area * 1000000.0, 1000.0 * area / downDipWidth, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            ellB_func.set(area, ellB.getMag(area * 1000000.0, 1000.0 * area / downDipWidth, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
            hb_func.set(area, hb.getMag(area * 1000000.0, 1000.0 * area / downDipWidth, downDipWidth * 1000.0, downDipWidth * 1000.0, rake));
        }
        ArrayList<ArbitrarilyDiscretizedFunc> funcs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        funcs.add(sh09mod_func);
        funcs.add(ellB_func);
        funcs.add(hb_func);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, null, 1.0f, Color.GREEN));
        GraphWindow graph = new GraphWindow(funcs, "Mag-Area Relationships", plotChars);
        graph.setX_AxisLabel("Area (km-sq)");
        graph.setY_AxisLabel("Magnitude");
        graph.setXLog(true);
        graph.setX_AxisRange(50.0, 20000.0);
        graph.setY_AxisRange(5.0, 9.0);
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(18);
        graph.setTickLabelFontSize(16);
        if (saveFiles) {
            try {
                graph.saveAsPDF("magAreaScalingPlot.pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        ScalingRelationships.makeSlipAreaPlot(11.0, 1000, true);
        ScalingRelationships.makeSlipLengthPlot(11.0, 1000, true);
        ScalingRelationships.makeMagAreaPlot(true);
    }

    static {
        ellB_magArea = new Ellsworth_B_WG02_MagAreaRel();
        hb_magArea = new HanksBakun2002_MagAreaRel();
        sh09_ModMagArea = new Shaw_2009_ModifiedMagAreaRel();
    }
}

