/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.util.ExceptionUtils;

public class CubeSamplerCache
implements LoadingCache<Integer, IntegerPDF_FunctionSampler> {
    private static final boolean D = true;
    private static final boolean DD = false;
    private int size;
    private CacheLoader<Integer, IntegerPDF_FunctionSampler> loader;
    private Map<Integer, Integer> numForthcomingMap;
    private Cache<Integer, IntegerPDF_FunctionSampler> cache;
    private int getCount = 0;
    private int loadCount = 0;
    private int regenCount = 0;
    private HashSet<Integer> regenTracker;

    public CubeSamplerCache(int size, CacheLoader<Integer, IntegerPDF_FunctionSampler> loader, Map<Integer, Integer> numForthcomingMap, boolean softCacheValues) {
        this.size = size;
        this.loader = loader;
        this.numForthcomingMap = numForthcomingMap;
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize((long)(size * 2));
        if (softCacheValues) {
            builder = builder.softValues();
        }
        this.cache = builder.build();
        this.regenTracker = new HashSet();
    }

    public synchronized IntegerPDF_FunctionSampler get(Integer index) {
        ++this.getCount;
        IntegerPDF_FunctionSampler ret = (IntegerPDF_FunctionSampler)this.cache.getIfPresent((Object)index);
        if (ret == null) {
            try {
                ret = (IntegerPDF_FunctionSampler)this.loader.load((Object)index);
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            Preconditions.checkNotNull((Object)ret);
            ++this.loadCount;
            if (this.regenTracker.contains(index)) {
                ++this.regenCount;
            } else {
                this.regenTracker.add(index);
            }
            while (this.cache.size() >= (long)this.size) {
                int myPriority = this.getNumForthcoming(index);
                int toRemoveIndex = -1;
                Iterator iterator = this.cache.asMap().keySet().iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    int oPriority = this.getNumForthcoming(key);
                    if (oPriority > myPriority) continue;
                    toRemoveIndex = key;
                    if (oPriority >= myPriority) continue;
                    break;
                }
                if (toRemoveIndex < 0) break;
                this.cache.invalidate((Object)toRemoveIndex);
            }
            if (this.cache.size() < (long)this.size) {
                this.cache.put((Object)index, (Object)ret);
            }
        }
        if (this.getCount % 100 == 0) {
            System.out.println("***CACHE get=" + this.getCount + ", load=" + this.loadCount + ", regen=" + this.regenCount);
        }
        return ret;
    }

    private int getNumForthcoming(int index) {
        Integer num = this.numForthcomingMap.get(index);
        if (num == null) {
            num = 0;
        }
        return num;
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public void cleanUp() {
    }

    public synchronized IntegerPDF_FunctionSampler get(Integer key, Callable<? extends IntegerPDF_FunctionSampler> valueLoader) throws ExecutionException {
        return (IntegerPDF_FunctionSampler)this.cache.get((Object)key, valueLoader);
    }

    public ImmutableMap<Integer, IntegerPDF_FunctionSampler> getAllPresent(Iterable<?> keys) {
        return this.cache.getAllPresent(keys);
    }

    public IntegerPDF_FunctionSampler getIfPresent(Object key) {
        return (IntegerPDF_FunctionSampler)this.cache.getIfPresent(key);
    }

    public void invalidate(Object key) {
        this.cache.invalidate(key);
    }

    public void invalidateAll(Iterable<?> keys) {
        this.cache.invalidateAll();
    }

    public void put(Integer key, IntegerPDF_FunctionSampler value) {
        this.cache.put((Object)key, (Object)value);
    }

    public void putAll(Map<? extends Integer, ? extends IntegerPDF_FunctionSampler> m) {
        this.cache.putAll(m);
    }

    public long size() {
        return this.cache.size();
    }

    public CacheStats stats() {
        return this.cache.stats();
    }

    public IntegerPDF_FunctionSampler apply(Integer key) {
        throw new UnsupportedOperationException();
    }

    public ConcurrentMap<Integer, IntegerPDF_FunctionSampler> asMap() {
        return this.cache.asMap();
    }

    public ImmutableMap<Integer, IntegerPDF_FunctionSampler> getAll(Iterable<? extends Integer> keys) throws ExecutionException {
        return this.cache.getAllPresent(keys);
    }

    public IntegerPDF_FunctionSampler getUnchecked(Integer key) {
        return this.get(key);
    }

    public void refresh(Integer key) {
        try {
            this.cache.put((Object)key, (Object)((IntegerPDF_FunctionSampler)this.loader.load((Object)key)));
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
    }
}

