/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import scratch.UCERF3.erf.ETAS.ETAS_LocationWeightCalculator;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;
import scratch.UCERF3.erf.ETAS.ETAS_SimAnalysisTools;

public class ETAS_CubeDiscretizationParams {
    public static boolean D = true;
    public static final double DEFAULT_MAX_DEPTH = 24.0;
    public static final double DEFAULT_DEPTH_DISCR = 2.0;
    public static final int DEFAULT_NUM_PT_SRC_SUB_PTS = 5;
    private final GriddedRegion griddedRegion;
    private final double maxDepth;
    private final int numPtSrcSubPts;
    private final double depthDiscr;
    private final double pointSrcDiscr;
    private final double cubeLatLonSpacing;
    private final GriddedRegion gridRegForCubes;
    private final GriddedRegion gridRegForParentLocs;
    private ETAS_LocationWeightCalculator locWeightCalc;

    public ETAS_CubeDiscretizationParams(GriddedRegion griddedRegion) {
        this(griddedRegion, 24.0, 5, 2.0);
    }

    public ETAS_CubeDiscretizationParams(GriddedRegion griddedRegion, double maxDepth, int numPtSrcSubPts, double depthDiscr) {
        this.griddedRegion = griddedRegion;
        this.maxDepth = maxDepth;
        this.numPtSrcSubPts = numPtSrcSubPts;
        this.depthDiscr = depthDiscr;
        this.pointSrcDiscr = griddedRegion.getSpacing();
        this.cubeLatLonSpacing = this.pointSrcDiscr / (double)numPtSrcSubPts;
        Region regionForRates = new Region(griddedRegion.getBorder(), BorderType.MERCATOR_LINEAR);
        if (numPtSrcSubPts % 2 == 0) {
            this.gridRegForCubes = new GriddedRegion(regionForRates, this.cubeLatLonSpacing, new Location(this.cubeLatLonSpacing / 2.0, this.cubeLatLonSpacing / 2.0));
            this.gridRegForParentLocs = new GriddedRegion(regionForRates, this.cubeLatLonSpacing, GriddedRegion.ANCHOR_0_0);
        } else {
            this.gridRegForCubes = new GriddedRegion(regionForRates, this.cubeLatLonSpacing, GriddedRegion.ANCHOR_0_0);
            this.gridRegForParentLocs = new GriddedRegion(regionForRates, this.cubeLatLonSpacing, new Location(this.cubeLatLonSpacing / 2.0, this.cubeLatLonSpacing / 2.0));
        }
    }

    public GriddedRegion getGriddedRegion() {
        return this.griddedRegion;
    }

    public double getMaxDepth() {
        return this.maxDepth;
    }

    public int getNumPtSrcSubPts() {
        return this.numPtSrcSubPts;
    }

    public double getDepthDiscr() {
        return this.depthDiscr;
    }

    public double getPointSrcDiscr() {
        return this.pointSrcDiscr;
    }

    public double getCubeLatLonSpacing() {
        return this.cubeLatLonSpacing;
    }

    public GriddedRegion getGridRegForCubes() {
        return this.gridRegForCubes;
    }

    public GriddedRegion getGridRegForParentLocs() {
        return this.gridRegForParentLocs;
    }

    public synchronized ETAS_LocationWeightCalculator getLocationWeightCalc(ETAS_ParameterList etasParams) {
        if (this.locWeightCalc == null) {
            if (D) {
                System.out.println("Creating ETAS_LocationWeightCalculator");
            }
            long startTime = System.currentTimeMillis();
            double maxDistKm = 1000.0;
            GriddedRegion gridRegForCubes = this.getGridRegForCubes();
            double midLat = (gridRegForCubes.getMaxLat() + gridRegForCubes.getMinLat()) / 2.0;
            double etasDistDecay = etasParams.get_q();
            double etasMinDist = etasParams.get_d();
            this.locWeightCalc = new ETAS_LocationWeightCalculator(maxDistKm, this.getMaxDepth(), this.getCubeLatLonSpacing(), this.getDepthDiscr(), midLat, etasDistDecay, etasMinDist);
            if (D) {
                ETAS_SimAnalysisTools.writeMemoryUse("Memory after making etas_LocWeightCalc");
            }
            double runtime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            if (D) {
                System.out.println("Done creating ETAS_LocationWeightCalculator; it took (sec): " + runtime);
            }
        }
        return this.locWeightCalc;
    }
}

