/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.mapping.gmt.gui.GMT_MapGuiBean;
import org.opensha.commons.mapping.gmt.gui.ImageViewerWindow;
import org.opensha.commons.param.impl.CPTParameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.AbstractNthRupERF;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FiniteApproxPointSurface;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.analysis.GMT_CA_Maps;
import scratch.UCERF3.erf.ETAS.ETAS_CubeDiscretizationParams;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_LocationWeightCalculator;
import scratch.UCERF3.erf.ETAS.ETAS_LongTermMFDs;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelOptions;
import scratch.UCERF3.erf.ETAS.ETAS_SimAnalysisTools;
import scratch.UCERF3.erf.ETAS.ETAS_Simulator;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.ETAS.SectionSourceNuclRates;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.RELM_RegionUtils;

public class ETAS_PrimaryEventSampler {
    static final double MAX_CHAR_FACTOR = 1.0E10;
    boolean APPLY_ERT_FAULTS;
    boolean APPLY_ERT_GRIDDED = true;
    static final boolean D = ETAS_Simulator.D;
    double trulyOffFaultGR_Corr = Double.NaN;
    public static final String defaultSectDistForCubeCacheFilename = "src/main/resources/scratchData/ucerf3/InversionSolutions/sectDistForCubeCache";
    public static final String defaultSectInCubeCacheFilename = "src/main/resources/scratchData/ucerf3/InversionSolutions/sectInCubeCache";
    public static final String defaultGriddedCorrFilename = "src/main/resources/scratchData/ucerf3/InversionSolutions/griddedSeisCorrectionCache";
    public static final String defaultCubeInsidePolyCacheFilename = "src/main/resources/scratchData/ucerf3/InversionSolutions/cubeInsidePolyCache";
    int numCubeDepths;
    int numCubesPerDepth;
    int numCubes;
    int numParDepths;
    int numParLocsPerDepth;
    int numParLocs;
    double maxDepth;
    double depthDiscr;
    GriddedRegion origGriddedRegion;
    GriddedRegion gridRegForCubes;
    GriddedRegion gridRegForParentLocs;
    double cubeLatLonSpacing;
    AbstractNthRupERF erf;
    FaultSystemSolutionERF fssERF;
    int numFltSystSources = -1;
    int totNumSrc;
    FaultSystemRupSet rupSet;
    PolygonFaultGridAssociations faultPolyMgr;
    int numPtSrcSubPts;
    double pointSrcDiscr;
    double[] latForCubeCenter;
    double[] lonForCubeCenter;
    double[] depthForCubeCenter;
    double[] sourceRates;
    double[] totSectNuclRateArray;
    double[] totalSectRateInCubeArray;
    SectionSourceNuclRates[] srcNuclRateOnSects;
    private ETAS_LongTermMFDs longTermMFDs;
    double totRate;
    List<float[]> fractionSectInCubeList;
    List<float[]> sectDistForCubeList;
    List<int[]> sectInCubeList;
    int[] isCubeInsideFaultPolygon;
    int[] numCubesInsideFaultPolygonArray;
    int[] origGridSeisTrulyOffVsSubSeisStatus;
    IntegerPDF_FunctionSampler cubeSamplerGriddedRatesOnly;
    Map<Integer, ArrayList<ETAS_EqkRupture>> eventListForParLocIndexMap;
    double[] grCorrFactorForSectArray;
    double[] charFactorForSectArray;
    boolean includeERF_Rates = false;
    boolean applyGR_Corr;
    U3ETAS_ProbabilityModelOptions probModel;
    boolean wtSupraNuclBySubSeisRates;
    boolean includeSpatialDecay;
    private ETAS_CubeDiscretizationParams cubeParams;
    ETAS_LocationWeightCalculator locWeightCalc;
    SummedMagFreqDist[] mfdForSrcArray;
    SummedMagFreqDist[] mfdForSrcSubSeisOnlyArray;
    SummedMagFreqDist[] mfdForTrulyOffOnlyArray;
    ETAS_Utils etas_utils;
    ETAS_ParameterList etasParams;
    private static final Location ptStrFootwallTestLoc = new Location(0.0, 0.0);
    private boolean warnedNegDepth = false;
    private boolean warnedBelow = false;

    public ETAS_PrimaryEventSampler(ETAS_CubeDiscretizationParams cubeParams, AbstractNthRupERF erf, ETAS_LongTermMFDs longTermMFDs, double[] sourceRates, String outputFileNameWithPath, ETAS_ParameterList etasParams, ETAS_Utils etas_utils, List<float[]> inputSectDistForCubeList, List<int[]> inputSectInCubeList, int[] inputIsCubeInsideFaultPolygon) {
        this.cubeParams = cubeParams;
        this.etasParams = etasParams;
        this.longTermMFDs = longTermMFDs;
        this.applyGR_Corr = etasParams.getImposeGR();
        this.probModel = etasParams.getU3ETAS_ProbModel();
        this.wtSupraNuclBySubSeisRates = etasParams.getApplySubSeisForSupraNucl();
        if (this.probModel == U3ETAS_ProbabilityModelOptions.FULL_TD) {
            this.APPLY_ERT_FAULTS = true;
            this.APPLY_ERT_GRIDDED = true;
        } else {
            this.APPLY_ERT_FAULTS = false;
            this.APPLY_ERT_GRIDDED = false;
        }
        this.includeSpatialDecay = true;
        this.origGriddedRegion = cubeParams.getGriddedRegion();
        this.cubeLatLonSpacing = this.pointSrcDiscr / (double)this.numPtSrcSubPts;
        if (D) {
            System.out.println("Gridded Region has " + this.origGriddedRegion.getNumLocations() + " cells");
        }
        this.numPtSrcSubPts = cubeParams.getNumPtSrcSubPts();
        this.erf = erf;
        this.maxDepth = cubeParams.getMaxDepth();
        this.depthDiscr = cubeParams.getDepthDiscr();
        this.pointSrcDiscr = cubeParams.getPointSrcDiscr();
        this.numCubeDepths = (int)Math.round(this.maxDepth / this.depthDiscr);
        this.etas_utils = etas_utils;
        if (erf instanceof FaultSystemSolutionERF) {
            this.rupSet = ((FaultSystemSolutionERF)erf).getSolution().getRupSet();
            this.faultPolyMgr = this.rupSet.requireModule(PolygonFaultGridAssociations.class);
            this.fssERF = (FaultSystemSolutionERF)erf;
            this.numFltSystSources = this.fssERF.getNumFaultSystemSources();
        } else {
            this.rupSet = null;
            this.faultPolyMgr = null;
            this.fssERF = null;
            this.numFltSystSources = 0;
        }
        this.gridRegForCubes = cubeParams.getGridRegForCubes();
        this.gridRegForParentLocs = cubeParams.getGridRegForParentLocs();
        this.numCubesPerDepth = this.gridRegForCubes.getNumLocations();
        this.numCubes = this.numCubesPerDepth * this.numCubeDepths;
        this.numParDepths = this.numCubeDepths + 1;
        this.numParLocsPerDepth = this.gridRegForParentLocs.getNumLocations();
        this.numParLocs = this.numParLocsPerDepth * this.numParDepths;
        if (D) {
            System.out.println("numParLocsPerDepth=" + this.numParLocsPerDepth);
            System.out.println("numCubesPerDepth=" + this.numCubesPerDepth);
        }
        this.computeGR_CorrFactorsForSections();
        this.eventListForParLocIndexMap = Maps.newHashMap();
        this.totNumSrc = erf.getNumSources();
        if (this.totNumSrc != sourceRates.length) {
            throw new RuntimeException("Problem with number of sources");
        }
        if (D) {
            System.out.println("totNumSrc=" + this.totNumSrc + "\tnumFltSystSources=" + this.numFltSystSources + "\tnumPointsForRates=" + this.numCubes);
        }
        this.sourceRates = sourceRates;
        if (D) {
            System.gc();
        }
        if (D) {
            ETAS_SimAnalysisTools.writeMemoryUse("Memory before making data");
        }
        this.latForCubeCenter = new double[this.numCubes];
        this.lonForCubeCenter = new double[this.numCubes];
        this.depthForCubeCenter = new double[this.numCubes];
        for (int i = 0; i < this.numCubes; ++i) {
            int[] regAndDepIndex = this.getCubeRegAndDepIndicesForIndex(i);
            Location loc = this.gridRegForCubes.getLocation(regAndDepIndex[0]);
            this.latForCubeCenter[i] = loc.getLatitude();
            this.lonForCubeCenter[i] = loc.getLongitude();
            this.depthForCubeCenter[i] = this.getCubeDepth(regAndDepIndex[1]);
        }
        this.origGridSeisTrulyOffVsSubSeisStatus = this.getOrigGridSeisTrulyOffVsSubSeisStatus();
        if (inputSectDistForCubeList != null && inputSectInCubeList != null && inputIsCubeInsideFaultPolygon != null) {
            this.sectInCubeList = inputSectInCubeList;
            this.sectDistForCubeList = inputSectDistForCubeList;
            this.isCubeInsideFaultPolygon = inputIsCubeInsideFaultPolygon;
        } else {
            File sectInCubeCacheFilename = new File(defaultSectInCubeCacheFilename);
            File sectDistForCubeCacheFilename = new File(defaultSectDistForCubeCacheFilename);
            File cubeInsidePolyCacheFilename = new File(defaultCubeInsidePolyCacheFilename);
            if (sectInCubeCacheFilename.exists() && sectDistForCubeCacheFilename.exists() && cubeInsidePolyCacheFilename.exists()) {
                try {
                    if (D) {
                        ETAS_SimAnalysisTools.writeMemoryUse("Memory before reading " + String.valueOf(sectDistForCubeCacheFilename));
                    }
                    this.sectDistForCubeList = MatrixIO.floatArraysListFromFile(sectDistForCubeCacheFilename);
                    if (D) {
                        ETAS_SimAnalysisTools.writeMemoryUse("Memory before reading " + String.valueOf(sectInCubeCacheFilename));
                    }
                    this.sectInCubeList = MatrixIO.intArraysListFromFile(sectInCubeCacheFilename);
                    if (D) {
                        ETAS_SimAnalysisTools.writeMemoryUse("Memory before reading " + String.valueOf(cubeInsidePolyCacheFilename));
                    }
                    this.isCubeInsideFaultPolygon = MatrixIO.intArrayFromFile(cubeInsidePolyCacheFilename);
                    if (D) {
                        ETAS_SimAnalysisTools.writeMemoryUse("Memory after reading isCubeInsideFaultPolygon");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                if (D) {
                    ETAS_SimAnalysisTools.writeMemoryUse("Memory before running generateAndWriteCacheDataToFiles()");
                }
                this.generateAndWriteCacheDataToFiles();
                if (D) {
                    ETAS_SimAnalysisTools.writeMemoryUse("Memory after running generateAndWriteCacheDataToFiles()");
                }
                System.gc();
                try {
                    this.sectDistForCubeList = MatrixIO.floatArraysListFromFile(sectDistForCubeCacheFilename);
                    this.sectInCubeList = MatrixIO.intArraysListFromFile(sectInCubeCacheFilename);
                    this.isCubeInsideFaultPolygon = MatrixIO.intArrayFromFile(cubeInsidePolyCacheFilename);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (D) {
            System.out.println("Starting to make fractionSectInCubeList");
        }
        long startTime = System.currentTimeMillis();
        ArrayList<ArrayList<Integer>> cubesForSectionList = new ArrayList<ArrayList<Integer>>();
        ArrayList<ArrayList<Float>> cubeDistsForSectionList = new ArrayList<ArrayList<Float>>();
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            cubesForSectionList.add(new ArrayList());
            cubeDistsForSectionList.add(new ArrayList());
        }
        for (int c = 0; c < this.numCubes; ++c) {
            int[] sectInCubeArray = this.sectInCubeList.get(c);
            float[] sectDistForCubeArray = this.sectDistForCubeList.get(c);
            for (int i = 0; i < sectInCubeArray.length; ++i) {
                int s = sectInCubeArray[i];
                float dist = sectDistForCubeArray[i];
                cubesForSectionList.get(s).add(c);
                cubeDistsForSectionList.get(s).add(Float.valueOf(dist));
            }
        }
        ArrayList<HashMap<Integer, Float>> hashMapForSectList = new ArrayList<HashMap<Integer, Float>>();
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            hashMapForSectList.add(this.getCubesAndFractForFaultSection_BoatRamp(s, cubesForSectionList, cubeDistsForSectionList));
        }
        this.fractionSectInCubeList = new ArrayList<float[]>();
        for (int c = 0; c < this.numCubes; ++c) {
            int[] sectInCubeArray = this.sectInCubeList.get(c);
            float[] fracsForCubeArray = new float[sectInCubeArray.length];
            for (int i = 0; i < sectInCubeArray.length; ++i) {
                int s = sectInCubeArray[i];
                fracsForCubeArray[i] = ((Float)((HashMap)hashMapForSectList.get(s)).get(c)).floatValue();
            }
            this.fractionSectInCubeList.add(fracsForCubeArray);
        }
        double runtime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        if (D) {
            System.out.println("fractionSectInCubeList took (sec): " + runtime);
        }
        if (D) {
            System.out.println("Starting to build numCubesInsideFaultPolygonArray");
        }
        startTime = System.currentTimeMillis();
        this.numCubesInsideFaultPolygonArray = new int[this.rupSet.getNumSections()];
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            this.numCubesInsideFaultPolygonArray[s] = cubesForSectionList.get(s).size();
        }
        runtime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        if (D) {
            System.out.println("numCubesInsideFaultPolygonArray took (sec): " + runtime);
        }
        if (erf instanceof FaultSystemSolutionERF) {
            this.totSectNuclRateArray = new double[this.rupSet.getNumSections()];
            this.srcNuclRateOnSects = new SectionSourceNuclRates[this.rupSet.getNumSections()];
            for (int sect = 0; sect < this.srcNuclRateOnSects.length; ++sect) {
                List<Integer> fssIndexes = this.rupSet.getRupturesForSection(sect);
                ArrayList<Integer> srcIndexes = new ArrayList<Integer>();
                for (int fssIndex : fssIndexes) {
                    int srcIndex = this.fssERF.getSrcIndexForFltSysRup(fssIndex);
                    if (srcIndex < 0) continue;
                    srcIndexes.add(srcIndex);
                }
                this.srcNuclRateOnSects[sect] = new SectionSourceNuclRates(srcIndexes);
            }
            this.computeSectNucleationRates();
            if (D) {
                System.gc();
            }
            if (D) {
                ETAS_SimAnalysisTools.writeMemoryUse("Memory after making data");
            }
        }
        if (D) {
            ETAS_SimAnalysisTools.writeMemoryUse("Memory before computeTotSectRateInCubesArray()");
        }
        this.computeTotSectRateInCubesArray();
        if (D) {
            ETAS_SimAnalysisTools.writeMemoryUse("Memory after computeTotSectRateInCubesArray()");
        }
        this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        startTime = System.currentTimeMillis();
        if (D) {
            System.out.println("Starting getCubeSamplerWithERF_RatesOnly()");
        }
        this.getCubeSamplerWithERF_GriddedRatesOnly();
        runtime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        if (D) {
            System.out.println("getCubeSamplerWithERF_RatesOnly() took (sec): " + runtime);
        }
        this.locWeightCalc = cubeParams.getLocationWeightCalc(etasParams);
    }

    private void computeSectNucleationRates() {
        long st = System.currentTimeMillis();
        for (int s = 0; s < this.totSectNuclRateArray.length; ++s) {
            this.totSectNuclRateArray[s] = 0.0;
        }
        double[] sectNormTimeSince = this.fssERF.getNormTimeSinceLastForSections();
        double[] totLongTermSubSeisRateOnSectArray = this.longTermMFDs.getTotLongTermSubSeisRateOnSectArray();
        for (int src = 0; src < this.numFltSystSources; ++src) {
            int sectIndex;
            int s;
            int fltSysRupIndex = this.fssERF.getFltSysRupIndexForSource(src);
            List<Integer> sectIndexList = this.rupSet.getSectionsIndicesForRup(fltSysRupIndex);
            int numSubRates = 0;
            double aveSubRates = 0.0;
            for (int sect : sectIndexList) {
                if (!(totLongTermSubSeisRateOnSectArray[sect] > 0.0)) continue;
                ++numSubRates;
                aveSubRates += totLongTermSubSeisRateOnSectArray[sect];
            }
            aveSubRates = aveSubRates == 0.0 ? 1.0 : (aveSubRates /= (double)numSubRates);
            double[] relSectNuclRateArray = new double[sectIndexList.size()];
            double sum = 0.0;
            for (s = 0; s < relSectNuclRateArray.length; ++s) {
                sectIndex = sectIndexList.get(s);
                double sectWt1 = this.wtSupraNuclBySubSeisRates ? (totLongTermSubSeisRateOnSectArray[sectIndex] != 0.0 ? totLongTermSubSeisRateOnSectArray[sectIndex] : aveSubRates) : this.rupSet.getAreaForSection(sectIndex);
                double normTS = Double.NaN;
                if (sectNormTimeSince != null) {
                    normTS = sectNormTimeSince[sectIndex];
                }
                relSectNuclRateArray[s] = Double.isNaN(normTS) ? 1.0 * sectWt1 : (this.APPLY_ERT_FAULTS ? normTS * sectWt1 : 1.0 * sectWt1);
                sum += relSectNuclRateArray[s];
            }
            for (s = 0; s < relSectNuclRateArray.length; ++s) {
                sectIndex = sectIndexList.get(s);
                double sectNuclRate = sum > 0.0 ? this.grCorrFactorForSectArray[sectIndex] * relSectNuclRateArray[s] * this.sourceRates[src] / sum : 0.0;
                int index = this.srcNuclRateOnSects[sectIndex].indexOf(src);
                this.srcNuclRateOnSects[sectIndex].setSourceNucleationRate(index, (float)sectNuclRate);
                int n = sectIndex;
                this.totSectNuclRateArray[n] = this.totSectNuclRateArray[n] + sectNuclRate;
            }
        }
        for (int sect = 0; sect < this.rupSet.getNumSections(); ++sect) {
            double testTotRate = 0.0;
            for (int i = 0; i < this.srcNuclRateOnSects[sect].size(); ++i) {
                testTotRate += (double)this.srcNuclRateOnSects[sect].getSourceNucleationRate(i);
            }
            double ratio = testTotRate / this.totSectNuclRateArray[sect];
            if (!(ratio < 0.9999) && !(ratio > 1.0001)) continue;
            throw new RuntimeException("Test failed in computeSectNucleationRates(); ratio =" + ratio + " for sect " + sect);
        }
        double[] testSrcRates = new double[this.numFltSystSources];
        for (int sectIndex = 0; sectIndex < this.rupSet.getNumSections(); ++sectIndex) {
            for (int i = 0; i < this.srcNuclRateOnSects[sectIndex].size(); ++i) {
                int srcIndex;
                int n = srcIndex = this.srcNuclRateOnSects[sectIndex].getSourceIndex(i);
                testSrcRates[n] = testSrcRates[n] + (double)this.srcNuclRateOnSects[sectIndex].getSourceNucleationRate(i) / this.grCorrFactorForSectArray[sectIndex];
            }
        }
        for (int srcIndex = 0; srcIndex < this.numFltSystSources; ++srcIndex) {
            double testRatio = testSrcRates[srcIndex] / this.sourceRates[srcIndex];
            if (!(testRatio < 0.9999) && !(testRatio > 1.0001)) continue;
            throw new RuntimeException("Source rate test failed in computeSectNucleationRates(); testRatio =" + testRatio + " for srcIndex " + srcIndex + "\ntestSrcRates=" + testSrcRates[srcIndex] + "\nsourceRates=" + this.sourceRates[srcIndex]);
        }
        if (D) {
            double timeSec = (double)(System.currentTimeMillis() - st) / 1000.0;
            System.out.println("computeSectNucleationRates runtime(sec) = " + timeSec);
        }
    }

    public void computeTotSectRateInCubesArray() {
        long st = System.currentTimeMillis();
        this.totalSectRateInCubeArray = new double[this.numCubes];
        for (int c = 0; c < this.numCubes; ++c) {
            int[] sectInCubeArray = this.sectInCubeList.get(c);
            float[] fracts = this.fractionSectInCubeList.get(c);
            for (int s = 0; s < sectInCubeArray.length; ++s) {
                int n = c;
                this.totalSectRateInCubeArray[n] = this.totalSectRateInCubeArray[n] + this.totSectNuclRateArray[sectInCubeArray[s]] * (double)fracts[s];
            }
        }
        if (D) {
            double timeSec = (double)(System.currentTimeMillis() - st) / 1000.0;
            System.out.println("tempSectRateInCubeArray runtime(sec) = " + timeSec);
        }
    }

    public void setSectInCubeCaches(List<float[]> sectDistForCubeList, List<int[]> sectInCubeList) {
        this.sectDistForCubeList = sectDistForCubeList;
        this.sectInCubeList = sectInCubeList;
    }

    public void addRuptureToProcess(ETAS_EqkRupture rup) {
        int parLocIndex = this.getParLocIndexForLocation(rup.getParentTriggerLoc());
        if (parLocIndex != -1) {
            if (this.eventListForParLocIndexMap.keySet().contains(parLocIndex)) {
                this.eventListForParLocIndexMap.get(parLocIndex).add(rup);
            } else {
                ArrayList<ETAS_EqkRupture> list = new ArrayList<ETAS_EqkRupture>();
                list.add(rup);
                this.eventListForParLocIndexMap.put(parLocIndex, list);
            }
        }
    }

    private HashMap<Integer, Double> getCubesAndDistancesInsideSectionPolygon(int sectionIndex) {
        HashMap<Integer, Double> cubeDistMap = new HashMap<Integer, Double>();
        Region faultPolygon = this.faultPolyMgr.getPoly(sectionIndex);
        RuptureSurface surface = this.rupSet.getFaultSectionData(sectionIndex).getFaultSurface(0.25, false, true);
        for (int i = 0; i < this.numCubes; ++i) {
            Location cubeLoc = this.getCubeLocationForIndex(i);
            if (!faultPolygon.contains(cubeLoc)) continue;
            double dist = LocationUtils.distanceToSurf(cubeLoc, surface);
            cubeDistMap.put(i, dist);
        }
        return cubeDistMap;
    }

    private HashMap<Integer, Double> getSectionsAndTheirFractsCrossingCube(int cubeIndex) {
        HashMap<Integer, Double> sectFracMap = new HashMap<Integer, Double>();
        Location cubeLoc = this.getCubeLocationForIndex(cubeIndex);
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            double dist = LocationUtils.linearDistanceFast(cubeLoc, (Location)this.rupSet.getFaultSectionData(s).getFaultTrace().get(0));
            if (dist > 32.0) continue;
            RuptureSurface surface = this.rupSet.getFaultSectionData(s).getFaultSurface(0.25, false, true);
            int numLocs = surface.getEvenlyDiscretizedNumLocs();
            double wt = 1.0 / (double)numLocs;
            for (int i = 0; i < numLocs; ++i) {
                Location loc = surface.getEvenlyDiscretizedLocation(i);
                if (this.getCubeIndexForLocation(loc) != cubeIndex) continue;
                if (!sectFracMap.containsKey(s)) {
                    sectFracMap.put(s, 0.0);
                }
                double newWt = wt + sectFracMap.get(s);
                sectFracMap.put(s, newWt);
            }
        }
        return sectFracMap;
    }

    private int getNumCubesInsideSectionPolygon(int sectionIndex) {
        int numCubesInside = 0;
        Region faultPolygon = this.faultPolyMgr.getPoly(sectionIndex);
        for (int i = 0; i < this.numCubesPerDepth; ++i) {
            Location cubeLoc = this.gridRegForCubes.getLocation(i);
            if (!faultPolygon.contains(cubeLoc)) continue;
            numCubesInside += this.numCubeDepths;
        }
        return numCubesInside;
    }

    private double getFarthestCubeDistAtDepthForSection(StirlingGriddedSurface surface, double depthKm, ArrayList<Integer> cubeList) {
        double min = Double.MAX_VALUE;
        int rowIndex = -1;
        for (int r = 0; r < surface.getNumRows(); ++r) {
            double diff = Math.abs(((Location)surface.get(r, 0)).getDepth() - depthKm);
            if (!(diff < min)) continue;
            min = diff;
            rowIndex = r;
        }
        int cubeDepthIndex = this.getCubeDepthIndex(depthKm);
        double maxDist = -1.0;
        for (int cubeIndex : cubeList) {
            Location cubeLoc = this.getCubeLocationForIndex(cubeIndex);
            if (this.getCubeDepthIndex(cubeLoc.getDepth()) != cubeDepthIndex) continue;
            double minDist = Double.MAX_VALUE;
            for (int c = 0; c < surface.getNumCols(); ++c) {
                Location surfLoc = surface.getLocation(rowIndex, c);
                double dist = LocationUtils.linearDistanceFast(cubeLoc, surfLoc);
                if (!(dist < minDist)) continue;
                minDist = dist;
            }
            if (!(maxDist < minDist)) continue;
            maxDist = minDist;
        }
        return maxDist;
    }

    private double getFaultSectionPolygonHalfWidth(int sectionIndex, Set<Integer> cubeList) {
        RuptureSurface surface = this.rupSet.getFaultSectionData(sectionIndex).getFaultSurface(1.0, false, false);
        Preconditions.checkState((boolean)(surface instanceof EvenlyGriddedSurface));
        EvenlyGriddedSurface gridSurf = (EvenlyGriddedSurface)surface;
        int rowIndexHalfWayDown = gridSurf.getNumRows() / 2;
        double depthHalfWayDown = gridSurf.getLocation(rowIndexHalfWayDown, 0).getDepth();
        int cubeDepthIndex = this.getCubeDepthIndex(depthHalfWayDown);
        double maxDist = -1.0;
        for (int cubeIndex : cubeList) {
            Location cubeLoc = this.getCubeLocationForIndex(cubeIndex);
            if (this.getCubeDepthIndex(cubeLoc.getDepth()) != cubeDepthIndex) continue;
            double minDist = Double.MAX_VALUE;
            for (int c = 0; c < gridSurf.getNumCols(); ++c) {
                Location surfLoc = gridSurf.getLocation(rowIndexHalfWayDown, c);
                double dist = LocationUtils.linearDistanceFast(cubeLoc, surfLoc);
                if (!(dist < minDist)) continue;
                minDist = dist;
            }
            if (!(maxDist < minDist)) continue;
            maxDist = minDist;
        }
        return maxDist;
    }

    public void tempSectTest() {
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            System.out.println(this.rupSet.getFaultSectionData(s).getName() + "\t" + this.rupSet.getFaultSectionData(s).getFaultTrace().getName());
        }
    }

    private HashMap<Integer, Float> getCubesAndFractForFaultSection_BoatRamp(int sectionIndex, ArrayList<ArrayList<Integer>> cubesForSectionList, ArrayList<ArrayList<Float>> cubeDistsForSectionList) {
        double numCubes = cubesForSectionList.get(sectionIndex).size();
        HashMap<Integer, Float> wtMap = new HashMap<Integer, Float>();
        if (this.applyGR_Corr || this.charFactorForSectArray[sectionIndex] <= 1.0) {
            float wt = 1.0f / (float)numCubes;
            for (int i = 0; i < cubesForSectionList.get(sectionIndex).size(); ++i) {
                int cubeIndex = cubesForSectionList.get(sectionIndex).get(i);
                wtMap.put(cubeIndex, Float.valueOf(wt));
            }
            return wtMap;
        }
        double charFactor = this.charFactorForSectArray[sectionIndex] * this.grCorrFactorForSectArray[sectionIndex];
        double distThresh = 10.0;
        double totalRate = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray()[sectionIndex].getTotalIncrRate();
        double cubeRateBeyondDistThresh = totalRate / (charFactor * numCubes);
        double totalRateBeyondDistThresh = 0.0;
        double numCubesWithinDistThresh = 0.0;
        double sumDistWithinDistThresh = 0.0;
        double minDist = Double.MAX_VALUE;
        double maxDist = 0.0;
        for (int i = 0; i < cubesForSectionList.get(sectionIndex).size(); ++i) {
            double dist = cubeDistsForSectionList.get(sectionIndex).get(i).floatValue();
            if (dist <= distThresh) {
                numCubesWithinDistThresh += 1.0;
                sumDistWithinDistThresh += dist;
            } else {
                totalRateBeyondDistThresh += cubeRateBeyondDistThresh;
            }
            if (minDist > dist) {
                minDist = dist;
            }
            if (!(maxDist < dist)) continue;
            maxDist = dist;
        }
        double totRateWithinDistThresh = totalRate - totalRateBeyondDistThresh;
        double slope = (totRateWithinDistThresh - numCubesWithinDistThresh * cubeRateBeyondDistThresh) / (sumDistWithinDistThresh - numCubesWithinDistThresh * distThresh);
        double intercept = cubeRateBeyondDistThresh - slope * distThresh;
        double minRate = Double.MAX_VALUE;
        double maxRate = 0.0;
        float totWt = 0.0f;
        for (int i = 0; i < cubesForSectionList.get(sectionIndex).size(); ++i) {
            int cubeIndex = cubesForSectionList.get(sectionIndex).get(i);
            double dist = cubeDistsForSectionList.get(sectionIndex).get(i).floatValue();
            double rate = dist <= distThresh ? slope * dist + intercept : cubeRateBeyondDistThresh;
            if (minRate > rate) {
                minRate = rate;
            }
            if (maxRate < rate) {
                maxRate = rate;
            }
            double wt = rate / totalRate;
            wtMap.put(cubeIndex, Float.valueOf((float)wt));
            totWt = (float)((double)totWt + wt);
        }
        double minCharFactor = minRate / cubeRateBeyondDistThresh;
        double maxCharFactor = maxRate / cubeRateBeyondDistThresh;
        if ((double)totWt < 0.9999 || (double)totWt > 1.0001) {
            if (D) {
                System.out.println("getCubesAndFractForFaultSection_BoatRamp returned null for: " + sectionIndex + "\t" + this.rupSet.getFaultSectionData(sectionIndex).getName() + "\tcharFactor=" + charFactor + "\ttotalRate=" + totalRate + "\ttotWt=" + totWt);
            }
            return null;
        }
        return wtMap;
    }

    private void generateAndWriteCacheDataToFiles() {
        if (D) {
            System.out.println("Starting ETAS.ETAS_PrimaryEventSampler.generateAndWriteListListDataToFile(); THIS WILL TAKE TIME AND MEMORY!");
        }
        long st = System.currentTimeMillis();
        CalcProgressBar progressBar = null;
        try {
            progressBar = new CalcProgressBar("Sections to process in generateAndWriteCacheDataToFiles()", "junk");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList sectAtPointList = new ArrayList();
        ArrayList sectDistToPointList = new ArrayList();
        int numSect = this.rupSet.getNumSections();
        for (int i = 0; i < this.numCubes; ++i) {
            sectAtPointList.add(new ArrayList());
            sectDistToPointList.add(new ArrayList());
        }
        if (progressBar != null) {
            progressBar.showProgress(true);
        }
        for (int s = 0; s < numSect; ++s) {
            HashMap<Integer, Double> cubeDistMap;
            if (progressBar != null) {
                progressBar.updateProgress(s, numSect);
            }
            if ((cubeDistMap = this.getCubesAndDistancesInsideSectionPolygon(s)) == null) continue;
            for (int cubeIndex : cubeDistMap.keySet()) {
                ((ArrayList)sectAtPointList.get(cubeIndex)).add(s);
                ((ArrayList)sectDistToPointList.get(cubeIndex)).add(Float.valueOf(cubeDistMap.get(cubeIndex).floatValue()));
            }
        }
        ETAS_SimAnalysisTools.writeMemoryUse("Memory before writing files");
        File intListListFile = new File(defaultSectInCubeCacheFilename);
        File floatListListFile = new File(defaultSectDistForCubeCacheFilename);
        try {
            MatrixIO.intListListToFile(sectAtPointList, intListListFile);
            MatrixIO.floatListListToFile(sectDistToPointList, floatListListFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (D) {
            System.out.println("Starting on insidePoly calculation");
        }
        int numCubes = this.gridRegForCubes.getNodeCount();
        int[] insidePoly = new int[numCubes];
        if (this.erf instanceof FaultSystemSolutionERF) {
            GridSourceProvider gridSrcProvider = ((FaultSystemSolutionERF)this.erf).getSolution().getGridSourceProvider();
            int numBad = 0;
            block11: for (int c = 0; c < numCubes; ++c) {
                if (progressBar != null) {
                    progressBar.updateProgress(c, numCubes);
                }
                Location loc = this.getCubeLocationForIndex(c);
                int gridIndex = gridSrcProvider.getGriddedRegion().indexForLocation(loc);
                if (gridIndex == -1) {
                    ++numBad;
                    continue;
                }
                if (this.origGridSeisTrulyOffVsSubSeisStatus[gridIndex] == 0) {
                    insidePoly[c] = 0;
                    continue;
                }
                if (this.origGridSeisTrulyOffVsSubSeisStatus[gridIndex] == 1) {
                    insidePoly[c] = 1;
                    continue;
                }
                insidePoly[c] = 0;
                for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
                    if (!this.faultPolyMgr.getPoly(s).contains(loc)) continue;
                    insidePoly[c] = 1;
                    continue block11;
                }
            }
            int numCubesInside = 0;
            for (int c = 0; c < numCubes; ++c) {
                if (insidePoly[c] != 1) continue;
                ++numCubesInside;
            }
            if (D) {
                System.out.println(numCubesInside + " are inside polygons, out of " + numCubes);
                System.out.println(numBad + " were bad");
            }
        }
        if (progressBar != null) {
            progressBar.showProgress(false);
        }
        File cubeInsidePolyFile = new File(defaultCubeInsidePolyCacheFilename);
        try {
            MatrixIO.intArrayToFile(insidePoly, cubeInsidePolyFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            int[] insidePoly2 = MatrixIO.intArrayFromFile(cubeInsidePolyFile);
            boolean ok = true;
            for (int i = 0; i < insidePoly2.length; ++i) {
                if (insidePoly[i] == insidePoly2[i]) continue;
                ok = false;
            }
            if (!ok) {
                throw new RuntimeException("Problem with file");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (D) {
            System.out.println("ETAS_PrimaryEventSampler.generateAndWriteListListDataToFile() took " + (System.currentTimeMillis() - st) / 60000L + " min");
        }
    }

    private int[] getOrigGridSeisTrulyOffVsSubSeisStatus() {
        MFDGridSourceProvider gridSrcProvider = ((FaultSystemSolutionERF)this.erf).getSolution().requireModule(MFDGridSourceProvider.class);
        int numGridLocs = gridSrcProvider.getGriddedRegion().getNodeCount();
        int[] gridSeisStatus = new int[numGridLocs];
        int num0 = 0;
        int num1 = 0;
        int num2 = 0;
        for (int i = 0; i < numGridLocs; ++i) {
            IncrementalMagFreqDist trulyOffMFD;
            IncrementalMagFreqDist subSeisMFD = gridSrcProvider.getMFD_SubSeisOnFault(i);
            if (subSeisMFD != null && subSeisMFD.calcSumOfY_Vals() == 0.0) {
                subSeisMFD = null;
            }
            if ((trulyOffMFD = gridSrcProvider.getMFD_Unassociated(i)) != null && trulyOffMFD.calcSumOfY_Vals() == 0.0) {
                trulyOffMFD = null;
            }
            double frac = this.faultPolyMgr.getNodeFraction(i);
            if (subSeisMFD == null && trulyOffMFD != null) {
                gridSeisStatus[i] = 0;
                ++num0;
                if (!(frac > 1.0E-6)) continue;
                throw new RuntimeException("Problem: frac > 1e-6; " + frac);
            }
            if (subSeisMFD != null && trulyOffMFD == null) {
                gridSeisStatus[i] = 1;
                ++num1;
                if (!(frac < 0.999999)) continue;
                throw new RuntimeException("Problem: frac < 1.0 -1e-6; " + frac);
            }
            if (subSeisMFD != null && trulyOffMFD != null) {
                gridSeisStatus[i] = 2;
                ++num2;
                if (frac != 0.0 && frac != 1.0) continue;
                System.out.println("Location:\t" + String.valueOf(this.origGriddedRegion.getLocation(i)));
                System.out.println("subSeisMFD:\n" + subSeisMFD.toString());
                System.out.println("trulyOffMFD:\n" + trulyOffMFD.toString());
                throw new RuntimeException("Problem fault association frac=" + frac + ", but subSeis total rate >0 (" + (float)subSeisMFD.calcSumOfY_Vals() + ") and trulyOff total rate >0 (" + (float)trulyOffMFD.calcSumOfY_Vals() + ")");
            }
            throw new RuntimeException("Problem for grid " + i + ": subSeisMFD==null ? " + (subSeisMFD == null) + ", trulyOffMFD==null ? " + (trulyOffMFD == null) + ", frac=" + (float)frac);
        }
        if (D) {
            System.out.println(num0 + "\t (num0) out of\t" + numGridLocs);
            System.out.println(num1 + "\t (num1) out of\t" + numGridLocs);
            System.out.println(num2 + "\t (num2) out of\t" + numGridLocs);
        }
        return gridSeisStatus;
    }

    public IntegerPDF_FunctionSampler old_getAveSamplerForRupture(EqkRupture mainshock) {
        long st = System.currentTimeMillis();
        IntegerPDF_FunctionSampler aveSampler = new IntegerPDF_FunctionSampler(this.numCubes);
        LocationList locList = mainshock.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
        for (Location loc : locList) {
            int parLocIndex = this.getParLocIndexForLocation(loc);
            IntegerPDF_FunctionSampler sampler = this.getCubeSampler(parLocIndex);
            for (int i = 0; i < this.numCubes; ++i) {
                aveSampler.add(i, sampler.getY(i));
            }
        }
        if (D) {
            double sec = (double)(System.currentTimeMillis() - st) / 1000.0;
            System.out.println("getAveSamplerForRupture() took (sec): " + (float)sec);
        }
        return aveSampler;
    }

    public LocationList getParentTriggerCubeLocationsForLargePointSource(Location hypoLoc, double mag) {
        LocationList locList = new LocationList();
        if (mag <= 4.0) {
            locList.add(hypoLoc);
        } else {
            double radius = ETAS_Utils.getRuptureRadiusFromMag(mag);
            for (int c = 0; c < this.numParLocs; ++c) {
                Location parLoc = this.getParLocationForIndex(c);
                if (!(LocationUtils.linearDistanceFast(hypoLoc, parLoc) <= radius)) continue;
                locList.add(parLoc);
            }
        }
        return locList;
    }

    public IntegerPDF_FunctionSampler getAveSamplerForRupture(ETAS_EqkRupture mainshock) {
        LocationList locList;
        long st = System.currentTimeMillis();
        IntegerPDF_FunctionSampler aveSampler = new IntegerPDF_FunctionSampler(this.numCubes);
        LocationList locList2 = null;
        if (mainshock.getRuptureSurface().isPointSurface()) {
            locList = this.getParentTriggerCubeLocationsForLargePointSource(mainshock.getHypocenterLocation(), mainshock.getMag());
            if (locList.size() == 1) {
                return this.getCubeSampler(this.getParLocIndexForLocation((Location)locList.get(0)));
            }
            locList2 = locList;
        } else {
            if (mainshock.getFSSIndex() != -1) {
                RuptureSurface surf = this.etas_utils.getRuptureSurfaceWithNoCreepReduction(mainshock.getFSSIndex(), this.fssERF, 1.0);
                locList = surf.getEvenlyDiscritizedListOfLocsOnSurface();
            } else {
                locList = mainshock.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
            }
            locList2 = new ArrayList();
            for (Object loc : locList) {
                locList2.add(new Location(((Location)loc).getLatitude() + 0.005, ((Location)loc).getLongitude() + 0.005, ((Location)loc).getDepth()));
                locList2.add(new Location(((Location)loc).getLatitude() + 0.005, ((Location)loc).getLongitude() - 0.005, ((Location)loc).getDepth()));
                locList2.add(new Location(((Location)loc).getLatitude() - 0.005, ((Location)loc).getLongitude() + 0.005, ((Location)loc).getDepth()));
                locList2.add(new Location(((Location)loc).getLatitude() - 0.005, ((Location)loc).getLongitude() - 0.005, ((Location)loc).getDepth()));
            }
        }
        HashMap<Integer, Double> parLocMap = new HashMap<Integer, Double>();
        for (Location loc : locList2) {
            int parLocIndex = this.getParLocIndexForLocation(loc);
            if (parLocMap.containsKey(parLocIndex)) {
                double newVal = 1.0 + (Double)parLocMap.get(parLocIndex);
                parLocMap.put(parLocIndex, newVal);
                continue;
            }
            parLocMap.put(parLocIndex, 1.0);
        }
        CalcProgressBar progressBar = null;
        if (D) {
            progressBar = new CalcProgressBar("getAveSamplerForRupture(*)", "junk");
            progressBar.showProgress(true);
        }
        int progress = 0;
        Iterator parLocIndex = parLocMap.keySet().iterator();
        while (parLocIndex.hasNext()) {
            int parLocIndex2 = (Integer)parLocIndex.next();
            if (D) {
                progressBar.updateProgress(progress, parLocMap.keySet().size());
                ++progress;
            }
            if (parLocIndex2 == -1) continue;
            IntegerPDF_FunctionSampler sampler = this.getCubeSampler(parLocIndex2);
            for (int i = 0; i < this.numCubes; ++i) {
                aveSampler.add(i, sampler.getY(i) * (Double)parLocMap.get(parLocIndex2));
            }
        }
        if (D) {
            progressBar.showProgress(false);
            double sec = (double)(System.currentTimeMillis() - st) / 1000.0;
            System.out.println("getAveSamplerForRupture() took (sec): " + (float)sec);
        }
        return aveSampler;
    }

    public void tempAveSamplerAtFaults(ETAS_EqkRupture mainshock) {
        IntegerPDF_FunctionSampler aveSampler = this.getAveSamplerForRupture(mainshock);
        double[] fltNuclRate = new double[this.numCubes];
        double[] totCubeProb = new double[this.numCubes];
        for (int c = 0; c < this.numCubes; ++c) {
            fltNuclRate[c] = 0.0;
            if (this.sectInCubeList.get(c).length > 0) {
                int[] sectInCube = this.sectInCubeList.get(c);
                float[] fractInCube = this.fractionSectInCubeList.get(c);
                for (int s = 0; s < sectInCube.length; ++s) {
                    int n = c;
                    fltNuclRate[n] = fltNuclRate[n] + this.totSectNuclRateArray[sectInCube[s]] * (double)fractInCube[s];
                }
            }
            totCubeProb[c] = fltNuclRate[c] * aveSampler.getY(c);
        }
        int[] topCubeIndices = ETAS_SimAnalysisTools.getIndicesForHighestValuesInArray(totCubeProb, 50);
        System.out.print("cubeIndex\ttotFltProb\tcubeProb\tgrdSeisRate\tfltNuclRate\tlat\tlon\tdepth\tsect data...");
        for (int cubeIndex : topCubeIndices) {
            double gridSeisRateInCube = this.cubeSamplerGriddedRatesOnly.getY(cubeIndex);
            Location loc = this.getCubeLocationForIndex(cubeIndex);
            int[] sectInCube = this.sectInCubeList.get(cubeIndex);
            float[] fractInCube = this.fractionSectInCubeList.get(cubeIndex);
            System.out.print(cubeIndex + "\t" + totCubeProb[cubeIndex] + "\t" + aveSampler.getY(cubeIndex) + "\t" + gridSeisRateInCube + "\t" + fltNuclRate[cubeIndex] + "\t" + loc.getLongitude() + "\t" + loc.getLatitude() + "\t" + loc.getDepth());
            List<? extends FaultSection> fltDataList = ((FaultSystemSolutionERF)this.erf).getSolution().getRupSet().getFaultSectionDataList();
            for (int s = 0; s < sectInCube.length; ++s) {
                int sectIndex = sectInCube[s];
                double sectRate = this.totSectNuclRateArray[sectIndex] * (double)fractInCube[s];
                System.out.print("\t" + fltDataList.get(sectIndex).getName() + "\t" + this.totSectNuclRateArray[sectIndex] + "\t" + fractInCube[s]);
            }
            System.out.print("\n");
        }
        System.out.print(this.getCubeMFD(426462).toString());
        Location loc = this.getCubeLocationForIndex(426462);
        Location newLoc = new Location(loc.getLatitude() + 0.04, loc.getLongitude() - 0.04, loc.getDepth());
        System.out.print(newLoc.toString());
        System.out.print(this.getCubeMFD(this.getCubeIndexForLocation(newLoc)).toString());
    }

    public Hashtable<Integer, Double> getRelativeTriggerProbOfSourcesInCube(int cubeIndex, double fracSupra) {
        Hashtable<Integer, Double> probForSrcHashtable = this.getNucleationRatesOfSourcesInCube(cubeIndex, fracSupra);
        if (probForSrcHashtable == null) {
            return null;
        }
        double sum = 0.0;
        for (int srcIndex : probForSrcHashtable.keySet()) {
            sum += probForSrcHashtable.get(srcIndex).doubleValue();
        }
        for (int srcIndex : probForSrcHashtable.keySet()) {
            double normVal = probForSrcHashtable.get(srcIndex) / sum;
            probForSrcHashtable.put(srcIndex, normVal);
        }
        if (D) {
            double testVal = 0.0;
            for (int srcIndex : probForSrcHashtable.keySet()) {
                testVal += probForSrcHashtable.get(srcIndex).doubleValue();
            }
            if (testVal < 0.9999 || testVal > 1.0001) {
                throw new RuntimeException("PROBLEM");
            }
        }
        return probForSrcHashtable;
    }

    public Hashtable<Integer, Double> getNucleationRatesOfSourcesInCube(int cubeIndex, double fracSupra) {
        Hashtable<Integer, Double> rateForSrcHashtable = new Hashtable<Integer, Double>();
        int gridSrcIndex = -1;
        double gridSrcRate = 0.0;
        int griddeSeisRegionIndex = this.origGriddedRegion.indexForLocation(this.getCubeLocationForIndex(cubeIndex));
        if (griddeSeisRegionIndex != -1) {
            gridSrcIndex = this.numFltSystSources + griddeSeisRegionIndex;
            gridSrcRate = this.cubeSamplerGriddedRatesOnly.getY(cubeIndex);
        }
        int[] sectInCubeArray = this.sectInCubeList.get(cubeIndex);
        if (gridSrcIndex == -1 && sectInCubeArray.length == 0) {
            return null;
        }
        if (gridSrcIndex != -1 && (sectInCubeArray.length == 0 || fracSupra == 0.0)) {
            rateForSrcHashtable.put(gridSrcIndex, gridSrcRate);
            return rateForSrcHashtable;
        }
        if (gridSrcIndex != -1) {
            rateForSrcHashtable.put(gridSrcIndex, gridSrcRate);
        }
        float[] fracts = this.fractionSectInCubeList.get(cubeIndex);
        for (int s = 0; s < sectInCubeArray.length; ++s) {
            int sectIndex = sectInCubeArray[s];
            double fracSectInCube = fracts[s];
            for (int i = 0; i < this.srcNuclRateOnSects[sectIndex].size(); ++i) {
                int srcIndex = this.srcNuclRateOnSects[sectIndex].getSourceIndex(i);
                double srcNuclRateInCube = (double)this.srcNuclRateOnSects[sectIndex].getSourceNucleationRate(i) * fracSectInCube * fracSupra;
                if (rateForSrcHashtable.containsKey(srcIndex)) {
                    double newRate = rateForSrcHashtable.get(srcIndex) + srcNuclRateInCube;
                    rateForSrcHashtable.put(srcIndex, newRate);
                    continue;
                }
                rateForSrcHashtable.put(srcIndex, srcNuclRateInCube);
            }
        }
        return rateForSrcHashtable;
    }

    public void testNucleationRatesOfFaultSourcesInCubes() {
        if (D) {
            System.out.println("testNucleationRatesOfFaultSourcesInCubes():");
        }
        double[] testSrcRate = new double[this.numFltSystSources];
        System.out.println("\tloop over cubes...");
        CalcProgressBar progressBar = new CalcProgressBar("loop over cubes", "junk");
        progressBar.showProgress(true);
        for (int c = 0; c < this.numCubes; ++c) {
            progressBar.updateProgress(c, this.numCubes);
            Hashtable<Integer, Double> srcRatesInCube = this.getNucleationRatesOfSourcesInCube(c, 1.0);
            if (srcRatesInCube == null) continue;
            for (int srcIndex : srcRatesInCube.keySet()) {
                double rate;
                if (srcIndex >= this.numFltSystSources || Double.isNaN(rate = srcRatesInCube.get(srcIndex).doubleValue())) continue;
                int n = srcIndex;
                testSrcRate[n] = testSrcRate[n] + rate;
            }
        }
        progressBar.showProgress(false);
        System.out.println("\tloop over sources...");
        progressBar = new CalcProgressBar("loop over sources", "junk");
        progressBar.showProgress(true);
        for (int srcIndex = 0; srcIndex < this.numFltSystSources; ++srcIndex) {
            progressBar.updateProgress(srcIndex, this.sourceRates.length);
            double fractDiff = Math.abs(testSrcRate[srcIndex] - this.sourceRates[srcIndex]) / this.sourceRates[srcIndex];
            String name = this.fssERF.getSource(srcIndex).getName();
            if (!(fractDiff > 1.0E-4) || name.contains("Mendocino")) continue;
            int gridRegionIndex = srcIndex - this.numFltSystSources;
            if (gridRegionIndex >= 0) {
                Location loc = this.origGriddedRegion.getLocation(gridRegionIndex);
                System.out.println("\tDiff=" + (float)fractDiff + " for " + srcIndex + "; " + name + "\t" + loc.getLatitude() + "\t" + loc.getLongitude() + "\t" + loc.getDepth());
                continue;
            }
            System.out.println("\tDiff=" + (float)fractDiff + " for " + srcIndex + "; " + this.fssERF.getSource(srcIndex).getName());
        }
        progressBar.showProgress(false);
    }

    public double[] getRelativeTriggerProbOfEachSource(IntegerPDF_FunctionSampler sampler, double frac, ETAS_EqkRupture rupture) {
        long st = System.currentTimeMillis();
        double[] trigProb = new double[this.erf.getNumSources()];
        sampler.scale(1.0 / sampler.getSumOfY_vals());
        CalcProgressBar progressBar = null;
        if (D) {
            progressBar = new CalcProgressBar("getRelativeTriggerProbOfEachSource", "junk");
            progressBar.showProgress(true);
        }
        List<Integer> list = sampler.getOrderedIndicesOfHighestXFract(frac);
        double fracSupra = 1.0;
        int numDone = 0;
        for (int i : list) {
            Hashtable<Integer, Double> relSrcProbForCube;
            if (D) {
                progressBar.updateProgress(numDone, list.size());
            }
            if (this.APPLY_ERT_GRIDDED) {
                fracSupra = this.getERT_MinFracSupra(rupture, this.getCubeLocationForIndex(i));
            }
            if ((relSrcProbForCube = this.getRelativeTriggerProbOfSourcesInCube(i, fracSupra)) != null) {
                Iterator<Integer> iterator = relSrcProbForCube.keySet().iterator();
                while (iterator.hasNext()) {
                    int srcKey;
                    int n = srcKey = iterator.next().intValue();
                    trigProb[n] = trigProb[n] + sampler.getY(i) * relSrcProbForCube.get(srcKey);
                }
            }
            ++numDone;
        }
        if (D) {
            progressBar.showProgress(false);
        }
        double testSum = 0.0;
        for (int s = 0; s < trigProb.length; ++s) {
            testSum += trigProb[s];
        }
        if (testSum < 0.9999 || testSum > 1.0001) {
            System.out.println("testSum=" + testSum);
        }
        if (D) {
            st = System.currentTimeMillis() - st;
            System.out.println("getRelativeTriggerProbOfEachSource took:" + (float)st / 1000.0f + " sec");
        }
        return trigProb;
    }

    public List<SummedMagFreqDist> getExpectedPrimaryMFD_PDF(double[] relSrcProbs) {
        long st = System.currentTimeMillis();
        SummedMagFreqDist magDist = new SummedMagFreqDist(2.05, 8.95, 70);
        SummedMagFreqDist supraMagDist = new SummedMagFreqDist(2.05, 8.95, 70);
        SummedMagFreqDist subSeisMagDist = new SummedMagFreqDist(2.05, 8.95, 70);
        double testTotProb = 0.0;
        for (int s = 0; s < relSrcProbs.length; ++s) {
            IncrementalMagFreqDist srcMFD = this.mfdForSrcArray == null ? ERF_Calculator.getTotalMFD_ForSource(this.erf.getSource(s), 1.0, 2.05, 8.95, 70, true) : this.mfdForSrcArray[s].deepClone();
            srcMFD.normalizeByTotalRate();
            srcMFD.scale(relSrcProbs[s]);
            double totMFD_Prob = srcMFD.getTotalIncrRate();
            if (Double.isNaN(totMFD_Prob)) continue;
            testTotProb += totMFD_Prob;
            magDist.addIncrementalMagFreqDist(srcMFD);
            if (s < this.numFltSystSources) {
                supraMagDist.addIncrementalMagFreqDist(srcMFD);
                continue;
            }
            subSeisMagDist.addIncrementalMagFreqDist(srcMFD);
        }
        ArrayList<SummedMagFreqDist> mfdList = new ArrayList<SummedMagFreqDist>();
        mfdList.add(magDist);
        mfdList.add(supraMagDist);
        mfdList.add(subSeisMagDist);
        if (D) {
            System.out.println("\ttestTotProb=" + testTotProb);
            st = System.currentTimeMillis() - st;
            System.out.println("getExpectedPrimaryMFD_PDF took:" + (float)st / 1000.0f + " sec");
        }
        return mfdList;
    }

    public List<SummedMagFreqDist> getExpectedPrimaryMFD_PDF_Alt(IntegerPDF_FunctionSampler sampler, double frac) {
        sampler.scale(1.0 / sampler.getSumOfY_vals());
        List<Integer> list = sampler.getOrderedIndicesOfHighestXFract(frac);
        CalcProgressBar progressBar = null;
        if (D) {
            progressBar = new CalcProgressBar("getExpectedPrimaryMFD_PDF_Alt", "junk");
            progressBar.showProgress(true);
        }
        SummedMagFreqDist magDist = new SummedMagFreqDist(2.05, 8.95, 70);
        SummedMagFreqDist supraMagDist = new SummedMagFreqDist(2.05, 8.95, 70);
        SummedMagFreqDist subSeisMagDist = new SummedMagFreqDist(2.05, 8.95, 70);
        int count = 0;
        for (int i : list) {
            SummedMagFreqDist mfdSub;
            SummedMagFreqDist mfd;
            if (D) {
                progressBar.updateProgress(count, list.size());
                ++count;
            }
            if ((mfd = this.getCubeMFD(i)) == null) continue;
            double total = mfd.getTotalIncrRate();
            mfd.scale(sampler.getY(i) / total);
            magDist.addIncrementalMagFreqDist(mfd);
            SummedMagFreqDist mfdSupra = this.getCubeMFD_SupraSeisOnly(i);
            if (mfdSupra != null) {
                mfdSupra.scale(sampler.getY(i) / total);
                supraMagDist.addIncrementalMagFreqDist(mfdSupra);
            }
            if ((mfdSub = this.getCubeMFD_GriddedSeisOnly(i)) == null) continue;
            mfdSub.scale(sampler.getY(i) / total);
            subSeisMagDist.addIncrementalMagFreqDist(mfdSub);
        }
        if (D) {
            progressBar.showProgress(false);
        }
        ArrayList<SummedMagFreqDist> mfdList = new ArrayList<SummedMagFreqDist>();
        mfdList.add(magDist);
        mfdList.add(supraMagDist);
        mfdList.add(subSeisMagDist);
        return mfdList;
    }

    private double getERT_MinFracSupra(ETAS_EqkRupture parentRup, Location cubeLoc) {
        double minFrac = this.getERT_FracSupra(parentRup, cubeLoc);
        ETAS_EqkRupture previousParent = parentRup;
        while (previousParent.getParentRup() != null) {
            ETAS_EqkRupture nextParent = previousParent.getParentRup();
            double newFrac = this.getERT_FracSupra(nextParent, cubeLoc);
            if (newFrac < minFrac) {
                minFrac = newFrac;
            }
            previousParent = nextParent;
        }
        return minFrac;
    }

    private double getERT_FracSupra(ETAS_EqkRupture parentRup, Location cubeLoc) {
        if (parentRup.getFSSIndex() >= 0 || !this.APPLY_ERT_GRIDDED) {
            return 1.0;
        }
        double halfCubeWidth = 1.24;
        boolean pointSurface = parentRup.getRuptureSurface() instanceof PointSurface;
        if (!pointSurface) {
            return 1.0;
        }
        double parMag = parentRup.getMag();
        if (parMag < 4.0) {
            return 1.0;
        }
        double srcRadius = ETAS_Utils.getRuptureRadiusFromMag(parMag);
        Location parLoc = ((PointSurface)parentRup.getRuptureSurface()).getLocation();
        double dist = LocationUtils.linearDistanceFast(parLoc, cubeLoc);
        double frac = dist <= srcRadius - halfCubeWidth ? 0.0 : (dist > srcRadius + halfCubeWidth ? 1.0 : (dist - srcRadius + halfCubeWidth) / (2.0 * halfCubeWidth));
        return frac;
    }

    public String plotSubSectTriggerProbGivenAllPrimayEvents(IntegerPDF_FunctionSampler sampler, File resultsDir, int numToList, String nameSuffix, double expNum, boolean isPoisson, ETAS_EqkRupture parentRup) {
        Object info = "";
        if (this.erf instanceof FaultSystemSolutionERF) {
            FaultSystemSolutionERF tempERF = (FaultSystemSolutionERF)this.erf;
            sampler.scale(1.0 / sampler.getSumOfY_vals());
            double[] sectProbArray = new double[this.rupSet.getNumSections()];
            double totGridProb = 0.0;
            for (int i = 0; i < this.numCubes; ++i) {
                double fracSupra = this.getERT_MinFracSupra(parentRup, this.getCubeLocationForIndex(i));
                if (this.APPLY_ERT_GRIDDED && fracSupra == 0.0) continue;
                int[] sectInCubeArray = this.sectInCubeList.get(i);
                float[] fractInCubeArray = this.fractionSectInCubeList.get(i);
                double sum = 0.0;
                for (int s = 0; s < sectInCubeArray.length; ++s) {
                    int sectIndex = sectInCubeArray[s];
                    sum += this.totSectNuclRateArray[sectIndex] * (double)fractInCubeArray[s] * fracSupra;
                }
                double gridCubeRate = this.cubeSamplerGriddedRatesOnly.getY(i);
                if (!((sum += gridCubeRate) > 0.0)) continue;
                totGridProb += sampler.getY(i) * gridCubeRate / sum;
                for (int s = 0; s < sectInCubeArray.length; ++s) {
                    int sectIndex = sectInCubeArray[s];
                    double val = this.totSectNuclRateArray[sectIndex] * (double)fractInCubeArray[s] * fracSupra * sampler.getY(i) / sum;
                    int n = sectIndex;
                    sectProbArray[n] = sectProbArray[n] + val;
                }
            }
            double sum = 0.0;
            for (double val : sectProbArray) {
                sum += val;
            }
            System.out.println("SUM TEST HERE (prob of flt rup given primary event): " + sum);
            System.out.println("SUM TEST HERE (totGridProb): " + totGridProb);
            System.out.println("SUM TEST HERE (total prob; should be 1.0): " + (totGridProb + sum));
            double min = Double.MAX_VALUE;
            double max = 0.0;
            for (int sect = 0; sect < sectProbArray.length; ++sect) {
                if (isPoisson) {
                    int n = sect;
                    sectProbArray[n] = sectProbArray[n] * expNum;
                } else {
                    sectProbArray[sect] = 1.0 - Math.pow(1.0 - sectProbArray[sect], expNum);
                }
                if (!(sectProbArray[sect] < 1.0E-16)) continue;
                sectProbArray[sect] = 1.0E-16;
            }
            min = -5.0;
            max = 0.0;
            CPT cpt = FaultBasedMapGen.getParticipationCPT().rescale(min, max);
            List<? extends FaultSection> faults = this.rupSet.getFaultSectionDataList();
            double[] values = FaultBasedMapGen.log10(sectProbArray);
            String name = "SectOneOrMoreTriggerProb" + nameSuffix;
            String title = "Log10(Trigger Prob)";
            if (isPoisson) {
                name = "SectExpTriggerNum" + nameSuffix;
                title = "Log10(Exp Trigger Num)";
            }
            try {
                FileWriter fr = new FileWriter(new File(resultsDir, name + ".txt"));
                for (int s = 0; s < sectProbArray.length; ++s) {
                    fr.write(s + "\t" + (float)sectProbArray[s] + "\t" + faults.get(s).getName() + "\n");
                }
                fr.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, this.origGriddedRegion, resultsDir, name, true, false, title);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int[] topValueIndices = ETAS_SimAnalysisTools.getIndicesForHighestValuesInArray(sectProbArray, numToList);
            info = (String)info + "\nThe following sections are most likely to be triggered:\n\n";
            List<? extends FaultSection> fltDataList = tempERF.getSolution().getRupSet().getFaultSectionDataList();
            for (int sectIndex : topValueIndices) {
                info = (String)info + "\t" + sectProbArray[sectIndex] + "\t" + sectIndex + "\t" + fltDataList.get(sectIndex).getName() + "\n";
            }
            return info;
        }
        throw new RuntimeException("erf must be instance of FaultSystemSolutionERF");
    }

    public void writeGMT_PieSliceDecayData(Location parLoc, String fileNamePrefix) {
        double sliceLenghtDegrees = 2.0;
        try {
            String polygonString;
            Color c;
            double val;
            Location cubeLoc;
            double depth;
            int d;
            FileWriter fileWriterGMT = new FileWriter(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "GMT.txt"));
            FileWriter fileWriterSCECVDO = new FileWriter(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "SCECVDO.txt"));
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
            int parLocIndex = this.getParLocIndexForLocation(parLoc);
            Location translatedParLoc = this.getParLocationForIndex(parLocIndex);
            float parLat = (float)translatedParLoc.getLatitude();
            float parLon = (float)translatedParLoc.getLongitude();
            IntegerPDF_FunctionSampler sampler = this.getCubeSampler(parLocIndex);
            sampler.scale(1.0 / sampler.getSumOfY_vals());
            cpt = cpt.rescale(-9.0, -1.0);
            cpt.writeCPTFile(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "_CPT.txt"));
            double halfCubeLatLon = this.cubeLatLonSpacing / 2.0;
            double halfCubeDepth = this.depthDiscr / 2.0;
            double startCubeLon = translatedParLoc.getLongitude() + halfCubeLatLon;
            double startCubeLat = translatedParLoc.getLatitude() + halfCubeLatLon;
            int numLatLon = (int)(sliceLenghtDegrees / this.cubeLatLonSpacing);
            double lat = startCubeLat;
            for (int i = 0; i < numLatLon; ++i) {
                double lon = startCubeLon + (double)i * this.cubeLatLonSpacing;
                for (d = 0; d < this.numCubeDepths; ++d) {
                    depth = this.getCubeDepth(d);
                    cubeLoc = new Location(lat, lon, depth);
                    val = sampler.getY(this.getCubeIndexForLocation(cubeLoc));
                    c = cpt.getColor((float)Math.log10(val));
                    fileWriterGMT.write("> -G" + c.getRed() + "/" + c.getGreen() + "/" + c.getBlue() + "\n");
                    fileWriterSCECVDO.write("> " + val + "\n");
                    polygonString = parLat + "\t" + (float)(lon - halfCubeLatLon) + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    polygonString = polygonString + parLat + "\t" + (float)(lon + halfCubeLatLon) + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    polygonString = polygonString + parLat + "\t" + (float)(lon + halfCubeLatLon) + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    polygonString = polygonString + parLat + "\t" + (float)(lon - halfCubeLatLon) + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    fileWriterGMT.write(polygonString);
                    fileWriterSCECVDO.write(polygonString);
                }
            }
            double lon = startCubeLon;
            for (int i = 0; i < numLatLon; ++i) {
                lat = startCubeLat + (double)i * this.cubeLatLonSpacing;
                for (d = 0; d < this.numCubeDepths; ++d) {
                    depth = this.getCubeDepth(d);
                    cubeLoc = new Location(lat, lon, depth);
                    val = sampler.getY(this.getCubeIndexForLocation(cubeLoc));
                    c = cpt.getColor((float)Math.log10(val));
                    fileWriterGMT.write("> -G" + c.getRed() + "/" + c.getGreen() + "/" + c.getBlue() + "\n");
                    fileWriterSCECVDO.write("> " + val + "\n");
                    polygonString = (float)(lat - halfCubeLatLon) + "\t" + parLon + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    polygonString = polygonString + (float)(lat + halfCubeLatLon) + "\t" + parLon + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    polygonString = polygonString + (float)(lat + halfCubeLatLon) + "\t" + parLon + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    polygonString = polygonString + (float)(lat - halfCubeLatLon) + "\t" + parLon + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    fileWriterGMT.write(polygonString);
                    fileWriterSCECVDO.write(polygonString);
                }
            }
            double depth2 = 0.0;
            for (int i = 0; i < numLatLon; ++i) {
                lat = startCubeLat + (double)i * this.cubeLatLonSpacing;
                for (int j = 0; j < numLatLon; ++j) {
                    double distDegree;
                    lon = startCubeLon + (double)j * this.cubeLatLonSpacing;
                    cubeLoc = new Location(lat, lon, depth2);
                    int cubeIndex = this.getCubeIndexForLocation(cubeLoc);
                    if (cubeIndex == -1 || (distDegree = Math.sqrt((cubeLoc.getLatitude() - startCubeLat) * (cubeLoc.getLatitude() - startCubeLat) + (cubeLoc.getLongitude() - startCubeLon) * (cubeLoc.getLongitude() - startCubeLon))) > sliceLenghtDegrees) continue;
                    double val2 = sampler.getY(this.getCubeIndexForLocation(cubeLoc));
                    Color c2 = cpt.getColor((float)Math.log10(val2));
                    fileWriterGMT.write("> -G" + c2.getRed() + "/" + c2.getGreen() + "/" + c2.getBlue() + "\n");
                    fileWriterSCECVDO.write("> " + val2 + "\n");
                    String polygonString2 = (float)(lat - halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + depth2 + "\n";
                    polygonString2 = polygonString2 + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + depth2 + "\n";
                    polygonString2 = polygonString2 + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + depth2 + "\n";
                    polygonString2 = polygonString2 + (float)(lat - halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + depth2 + "\n";
                    fileWriterGMT.write(polygonString2);
                    fileWriterSCECVDO.write(polygonString2);
                }
            }
            fileWriterGMT.close();
            fileWriterSCECVDO.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void writeGMT_PieSliceRatesData(Location parLoc, String fileNamePrefix) {
        double sliceLenghtDegrees = 2.0;
        try {
            String polygonString;
            Color c;
            double val;
            Location cubeLoc;
            double depth;
            int d;
            FileWriter fileWriterGMT = new FileWriter(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "GMT.txt"));
            FileWriter fileWriterSCECVDO = new FileWriter(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "SCECVDO.txt"));
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
            int parLocIndex = this.getParLocIndexForLocation(parLoc);
            Location translatedParLoc = this.getParLocationForIndex(parLocIndex);
            float parLat = (float)translatedParLoc.getLatitude();
            float parLon = (float)translatedParLoc.getLongitude();
            IntegerPDF_FunctionSampler sampler = this.getCubeSamplerWithERF_GriddedRatesOnly();
            sampler.scale(1.0 / sampler.getSumOfY_vals());
            cpt = cpt.rescale(-7.0, -5.0);
            cpt = cpt.rescale(-9.0, -1.0);
            cpt.writeCPTFile(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "_CPT.txt"));
            double halfCubeLatLon = this.cubeLatLonSpacing / 2.0;
            double halfCubeDepth = this.depthDiscr / 2.0;
            double startCubeLon = translatedParLoc.getLongitude() + halfCubeLatLon;
            double startCubeLat = translatedParLoc.getLatitude() + halfCubeLatLon;
            int numLatLon = (int)(sliceLenghtDegrees / this.cubeLatLonSpacing);
            double lat = startCubeLat;
            for (int i = 0; i < numLatLon; ++i) {
                double lon = startCubeLon + (double)i * this.cubeLatLonSpacing;
                for (d = 0; d < this.numCubeDepths; ++d) {
                    depth = this.getCubeDepth(d);
                    cubeLoc = new Location(lat, lon, depth);
                    val = sampler.getY(this.getCubeIndexForLocation(cubeLoc));
                    c = cpt.getColor((float)Math.log10(val));
                    fileWriterGMT.write("> -G" + c.getRed() + "/" + c.getGreen() + "/" + c.getBlue() + "\n");
                    fileWriterSCECVDO.write("> " + val + "\n");
                    polygonString = parLat + "\t" + (float)(lon - halfCubeLatLon) + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    polygonString = polygonString + parLat + "\t" + (float)(lon + halfCubeLatLon) + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    polygonString = polygonString + parLat + "\t" + (float)(lon + halfCubeLatLon) + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    polygonString = polygonString + parLat + "\t" + (float)(lon - halfCubeLatLon) + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    fileWriterGMT.write(polygonString);
                    fileWriterSCECVDO.write(polygonString);
                }
            }
            double lon = startCubeLon;
            for (int i = 0; i < numLatLon; ++i) {
                lat = startCubeLat + (double)i * this.cubeLatLonSpacing;
                for (d = 0; d < this.numCubeDepths; ++d) {
                    depth = this.getCubeDepth(d);
                    cubeLoc = new Location(lat, lon, depth);
                    val = sampler.getY(this.getCubeIndexForLocation(cubeLoc));
                    c = cpt.getColor((float)Math.log10(val));
                    fileWriterGMT.write("> -G" + c.getRed() + "/" + c.getGreen() + "/" + c.getBlue() + "\n");
                    fileWriterSCECVDO.write("> " + val + "\n");
                    polygonString = (float)(lat - halfCubeLatLon) + "\t" + parLon + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    polygonString = polygonString + (float)(lat + halfCubeLatLon) + "\t" + parLon + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    polygonString = polygonString + (float)(lat + halfCubeLatLon) + "\t" + parLon + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    polygonString = polygonString + (float)(lat - halfCubeLatLon) + "\t" + parLon + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    fileWriterGMT.write(polygonString);
                    fileWriterSCECVDO.write(polygonString);
                }
            }
            double depth2 = 0.0;
            for (int i = 0; i < numLatLon; ++i) {
                lat = startCubeLat + (double)i * this.cubeLatLonSpacing;
                for (int j = 0; j < numLatLon; ++j) {
                    double distDegree;
                    lon = startCubeLon + (double)j * this.cubeLatLonSpacing;
                    cubeLoc = new Location(lat, lon, depth2);
                    int cubeIndex = this.getCubeIndexForLocation(cubeLoc);
                    if (cubeIndex == -1 || (distDegree = Math.sqrt((cubeLoc.getLatitude() - startCubeLat) * (cubeLoc.getLatitude() - startCubeLat) + (cubeLoc.getLongitude() - startCubeLon) * (cubeLoc.getLongitude() - startCubeLon))) > sliceLenghtDegrees) continue;
                    double val2 = sampler.getY(this.getCubeIndexForLocation(cubeLoc));
                    Color c2 = cpt.getColor((float)Math.log10(val2));
                    fileWriterGMT.write("> -G" + c2.getRed() + "/" + c2.getGreen() + "/" + c2.getBlue() + "\n");
                    fileWriterSCECVDO.write("> " + val2 + "\n");
                    String polygonString2 = (float)(lat - halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + depth2 + "\n";
                    polygonString2 = polygonString2 + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + depth2 + "\n";
                    polygonString2 = polygonString2 + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + depth2 + "\n";
                    polygonString2 = polygonString2 + (float)(lat - halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + depth2 + "\n";
                    fileWriterGMT.write(polygonString2);
                    fileWriterSCECVDO.write(polygonString2);
                }
            }
            fileWriterGMT.close();
            fileWriterSCECVDO.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void writeRatesCrossSectionData(Location startLoc, double lengthDegrees, String fileNamePrefix, double magThresh, boolean fltOnly) {
        try {
            Object polygonString;
            FileWriter fileWriterGMT = new FileWriter(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "GMT.txt"));
            FileWriter fileWriterSCECVDO = new FileWriter(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "SCECVDO.txt"));
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
            Location startCubeLoc = this.getCubeLocationForIndex(this.getCubeIndexForLocation(startLoc));
            cpt = cpt.rescale(-8.5, -4.5);
            cpt.setBelowMinColor(Color.WHITE);
            cpt.writeCPTFile(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "_CPT.txt"));
            double halfCubeLatLon = this.cubeLatLonSpacing / 2.0;
            double halfCubeDepth = this.depthDiscr / 2.0;
            double startCubeLon = startCubeLoc.getLongitude();
            double startCubeLat = startCubeLoc.getLatitude();
            int numLatLon = (int)(lengthDegrees / this.cubeLatLonSpacing);
            double minVal = Double.MAX_VALUE;
            double maxVal = -1.7976931348623157E308;
            SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray();
            double lat = startCubeLat;
            double lon = startCubeLon;
            for (int i = 0; i < numLatLon; ++i) {
                for (int d = 0; d < this.numCubeDepths; ++d) {
                    double depth = this.getCubeDepth(d);
                    Location cubeLoc = new Location(lat, lon, depth);
                    int cubeIndex = this.getCubeIndexForLocation(cubeLoc);
                    SummedMagFreqDist mfd = this.getCubeMFD(cubeIndex);
                    double val = mfd.getCumRate(magThresh);
                    if (minVal > Math.log10(val)) {
                        minVal = Math.log10(val);
                    }
                    if (maxVal < Math.log10(val)) {
                        maxVal = Math.log10(val);
                    }
                    if (fltOnly && this.getCubeMFD_SupraSeisOnly(cubeIndex).getTotalIncrRate() > 1.0E-15) {
                        val = 1.0E-16;
                        HashMap<Integer, Double> sectsAndFractMap = this.getSectionsAndTheirFractsCrossingCube(cubeIndex);
                        if (sectsAndFractMap.size() > 0) {
                            val = 0.0;
                            for (int s : sectsAndFractMap.keySet()) {
                                val += longTermSupraSeisMFD_OnSectArray[s].getCumRate(magThresh) * sectsAndFractMap.get(s);
                            }
                        }
                    }
                    Color c = cpt.getColor((float)Math.log10(val));
                    fileWriterGMT.write("> -W125/125/125 -G" + c.getRed() + "/" + c.getGreen() + "/" + c.getBlue() + "\n");
                    fileWriterSCECVDO.write("> " + val + "\n");
                    polygonString = (float)(lat - halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    polygonString = (String)polygonString + (float)(lat - halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    polygonString = (String)polygonString + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    polygonString = (String)polygonString + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    fileWriterGMT.write((String)polygonString);
                    fileWriterSCECVDO.write((String)polygonString);
                }
                lat += this.cubeLatLonSpacing;
                lon += this.cubeLatLonSpacing;
            }
            double depth = 0.0;
            int numOtherWay = 30;
            double newStartLat = startCubeLat;
            double newStartLon = startCubeLon + this.cubeLatLonSpacing;
            int numLonDone = 0;
            for (int j = 0; j < numOtherWay; ++j) {
                if (numLonDone != 2) {
                    newStartLon -= this.cubeLatLonSpacing;
                    ++numLonDone;
                } else {
                    newStartLat += this.cubeLatLonSpacing;
                    numLonDone = 0;
                }
                lat = newStartLat;
                lon = newStartLon;
                for (int i = 0; i < numLatLon; ++i) {
                    Location cubeLoc = new Location(lat, lon, depth + halfCubeDepth);
                    int cubeIndex = this.getCubeIndexForLocation(cubeLoc);
                    SummedMagFreqDist mfd = this.getCubeMFD(cubeIndex);
                    double val = mfd.getCumRate(magThresh);
                    if (minVal > Math.log10(val)) {
                        minVal = Math.log10(val);
                    }
                    if (maxVal < Math.log10(val)) {
                        maxVal = Math.log10(val);
                    }
                    if (fltOnly && this.getCubeMFD_SupraSeisOnly(cubeIndex).getTotalIncrRate() > 1.0E-15) {
                        val = 1.0E-16;
                        HashMap<Integer, Double> sectsAndFractMap = this.getSectionsAndTheirFractsCrossingCube(cubeIndex);
                        if (sectsAndFractMap.size() > 0) {
                            val = 0.0;
                            for (int s : sectsAndFractMap.keySet()) {
                                val += longTermSupraSeisMFD_OnSectArray[s].getCumRate(magThresh) * sectsAndFractMap.get(s);
                            }
                        }
                    }
                    Color c = cpt.getColor((float)Math.log10(val));
                    fileWriterGMT.write("> -W125/125/125 -G" + c.getRed() + "/" + c.getGreen() + "/" + c.getBlue() + "\n");
                    fileWriterSCECVDO.write("> " + val + "\n");
                    String polygonString2 = (float)(lat - halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + depth + "\n";
                    polygonString2 = polygonString2 + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + depth + "\n";
                    polygonString2 = polygonString2 + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + depth + "\n";
                    if (j != 0) {
                        polygonString2 = polygonString2 + (float)(lat - halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + depth + "\n";
                    }
                    fileWriterGMT.write(polygonString2);
                    fileWriterSCECVDO.write(polygonString2);
                    lat += this.cubeLatLonSpacing;
                    lon += this.cubeLatLonSpacing;
                }
            }
            fileWriterGMT.close();
            fileWriterSCECVDO.close();
            System.out.println("Value Range:\n\tminVal=" + minVal + "\n\tmaxVal=" + maxVal);
            FileWriter fileWriterPolygons = new FileWriter(new File(GMT_CA_Maps.GMT_DIR, "PolygonData.txt"));
            for (int i = 1849; i > 1843; --i) {
                polygonString = "> -W\n";
                for (Location loc : this.faultPolyMgr.getPoly(i).getBorder()) {
                    polygonString = (String)polygonString + (float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + loc.getDepth() + "\n";
                }
                fileWriterPolygons.write((String)polygonString);
            }
            fileWriterPolygons.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void writeBulgeCrossSectionData(Location startLoc, double lengthDegrees, String fileNamePrefix, boolean fltOnly) {
        try {
            FileWriter fileWriterGMT = new FileWriter(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "GMT.txt"));
            FileWriter fileWriterSCECVDO = new FileWriter(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "SCECVDO.txt"));
            CPT cpt = GMT_CPT_Files.UCERF3_RATIOS.instance();
            Location startCubeLoc = this.getCubeLocationForIndex(this.getCubeIndexForLocation(startLoc));
            cpt = cpt.rescale(-2.0, 2.0);
            cpt.setBelowMinColor(Color.WHITE);
            cpt.writeCPTFile(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "_CPT.txt"));
            double halfCubeLatLon = this.cubeLatLonSpacing / 2.0;
            double halfCubeDepth = this.depthDiscr / 2.0;
            double startCubeLon = startCubeLoc.getLongitude();
            double startCubeLat = startCubeLoc.getLatitude();
            int numLatLon = (int)(lengthDegrees / this.cubeLatLonSpacing);
            double minVal = Double.MAX_VALUE;
            double maxVal = -1.7976931348623157E308;
            double lat = startCubeLat;
            double lon = startCubeLon;
            for (int i = 0; i < numLatLon; ++i) {
                for (int d = 0; d < this.numCubeDepths; ++d) {
                    double depth = this.getCubeDepth(d);
                    Location cubeLoc = new Location(lat, lon, depth);
                    int cubeIndex = this.getCubeIndexForLocation(cubeLoc);
                    double val = 1.0 / this.getAveScalingFactorToImposeGR_supraRatesInCube(cubeIndex);
                    if (minVal > Math.log10(val)) {
                        minVal = Math.log10(val);
                    }
                    if (maxVal < Math.log10(val)) {
                        maxVal = Math.log10(val);
                    }
                    if (fltOnly && this.getCubeMFD_SupraSeisOnly(cubeIndex).getTotalIncrRate() > 1.0E-15) {
                        val = 1.0E-16;
                        HashMap<Integer, Double> sectsAndFractMap = this.getSectionsAndTheirFractsCrossingCube(cubeIndex);
                        if (sectsAndFractMap.size() > 0) {
                            val = 0.0;
                            double wt = 0.0;
                            for (int s : sectsAndFractMap.keySet()) {
                                val += this.totSectNuclRateArray[s] * this.charFactorForSectArray[s];
                                wt += this.totSectNuclRateArray[s];
                            }
                            val /= wt;
                            val *= 8.0;
                        }
                    }
                    Color c = cpt.getColor((float)Math.log10(val));
                    fileWriterGMT.write("> -W125/125/125 -G" + c.getRed() + "/" + c.getGreen() + "/" + c.getBlue() + "\n");
                    fileWriterSCECVDO.write("> " + val + "\n");
                    String polygonString = (float)(lat - halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    polygonString = polygonString + (float)(lat - halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    polygonString = polygonString + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    polygonString = polygonString + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    fileWriterGMT.write(polygonString);
                    fileWriterSCECVDO.write(polygonString);
                }
                lat += this.cubeLatLonSpacing;
                lon += this.cubeLatLonSpacing;
            }
            double depth = 0.0;
            int numOtherWay = 30;
            double newStartLat = startCubeLat;
            double newStartLon = startCubeLon + this.cubeLatLonSpacing;
            int numLonDone = 0;
            for (int j = 0; j < numOtherWay; ++j) {
                if (numLonDone != 2) {
                    newStartLon -= this.cubeLatLonSpacing;
                    ++numLonDone;
                } else {
                    newStartLat += this.cubeLatLonSpacing;
                    numLonDone = 0;
                }
                lat = newStartLat;
                lon = newStartLon;
                for (int i = 0; i < numLatLon; ++i) {
                    Location cubeLoc = new Location(lat, lon, depth + halfCubeDepth);
                    int cubeIndex = this.getCubeIndexForLocation(cubeLoc);
                    double val = 1.0 / this.getAveScalingFactorToImposeGR_supraRatesInCube(cubeIndex);
                    if (minVal > Math.log10(val)) {
                        minVal = Math.log10(val);
                    }
                    if (maxVal < Math.log10(val)) {
                        maxVal = Math.log10(val);
                    }
                    if (fltOnly && this.getCubeMFD_SupraSeisOnly(cubeIndex).getTotalIncrRate() > 1.0E-15) {
                        val = 1.0E-16;
                        HashMap<Integer, Double> sectsAndFractMap = this.getSectionsAndTheirFractsCrossingCube(cubeIndex);
                        if (sectsAndFractMap.size() > 0) {
                            val = 0.0;
                            double wt = 0.0;
                            for (int s : sectsAndFractMap.keySet()) {
                                val += this.totSectNuclRateArray[s] * this.charFactorForSectArray[s];
                                wt += this.totSectNuclRateArray[s];
                            }
                            val /= wt;
                            val *= 8.0;
                        }
                    }
                    Color c = cpt.getColor((float)Math.log10(val));
                    fileWriterGMT.write("> -W125/125/125 -G" + c.getRed() + "/" + c.getGreen() + "/" + c.getBlue() + "\n");
                    fileWriterSCECVDO.write("> " + val + "\n");
                    String polygonString = (float)(lat - halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + depth + "\n";
                    polygonString = polygonString + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + depth + "\n";
                    polygonString = polygonString + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + depth + "\n";
                    if (j != 0) {
                        polygonString = polygonString + (float)(lat - halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + depth + "\n";
                    }
                    fileWriterGMT.write(polygonString);
                    fileWriterSCECVDO.write(polygonString);
                    lat += this.cubeLatLonSpacing;
                    lon += this.cubeLatLonSpacing;
                }
            }
            fileWriterGMT.close();
            fileWriterSCECVDO.close();
            System.out.println("Value Range:\n\tminVal=" + minVal + "\n\tmaxVal=" + maxVal);
            FileWriter fileWriterPolygons = new FileWriter(new File(GMT_CA_Maps.GMT_DIR, "PolygonData.txt"));
            for (int i = 1849; i > 1843; --i) {
                Object polygonString = "> -W\n";
                for (Location loc : this.faultPolyMgr.getPoly(i).getBorder()) {
                    polygonString = (String)polygonString + (float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + loc.getDepth() + "\n";
                }
                fileWriterPolygons.write((String)polygonString);
            }
            fileWriterPolygons.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void OLDwriteBulgeCrossSectionData(Location startLoc, double lengthDegrees, String fileNamePrefix) {
        try {
            FileWriter fileWriterGMT = new FileWriter(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "GMT.txt"));
            FileWriter fileWriterSCECVDO = new FileWriter(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "SCECVDO.txt"));
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
            Location startCubeLoc = this.getCubeLocationForIndex(this.getCubeIndexForLocation(startLoc));
            if (this.mfdForSrcArray == null) {
                this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
            }
            cpt = cpt.rescale(-3.0, 3.0);
            cpt.writeCPTFile(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + "_CPT.txt"));
            double halfCubeLatLon = this.cubeLatLonSpacing / 2.0;
            double halfCubeDepth = this.depthDiscr / 2.0;
            double startCubeLon = startCubeLoc.getLongitude();
            double startCubeLat = startCubeLoc.getLatitude();
            int numLatLon = (int)(lengthDegrees / this.cubeLatLonSpacing);
            double lat = startCubeLat;
            double lon = startCubeLon;
            for (int i = 0; i < numLatLon; ++i) {
                for (int d = 0; d < this.numCubeDepths; ++d) {
                    double depth = this.getCubeDepth(d);
                    Location cubeLoc = new Location(lat, lon, depth);
                    int cubeIndex = this.getCubeIndexForLocation(cubeLoc);
                    SummedMagFreqDist mfdSupra = this.getCubeMFD_SupraSeisOnly(cubeIndex);
                    SummedMagFreqDist mfdGridded = this.getCubeMFD_GriddedSeisOnly(cubeIndex);
                    double bulge = 1.0;
                    if (mfdSupra != null && mfdGridded != null && Double.isInfinite(bulge = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_supraRates(mfdSupra, mfdGridded, false))) {
                        bulge = 1000.0;
                    }
                    Color c = cpt.getColor((float)Math.log10(bulge));
                    fileWriterGMT.write("> -G" + c.getRed() + "/" + c.getGreen() + "/" + c.getBlue() + "\n");
                    fileWriterSCECVDO.write("> " + bulge + "\n");
                    String polygonString = (float)(lat - halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    polygonString = polygonString + (float)(lat - halfCubeLatLon) + "\t" + (float)(lon - halfCubeLatLon) + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    polygonString = polygonString + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + -((float)(depth + halfCubeDepth)) + "\n";
                    polygonString = polygonString + (float)(lat + halfCubeLatLon) + "\t" + (float)(lon + halfCubeLatLon) + "\t" + -((float)(depth - halfCubeDepth)) + "\n";
                    fileWriterGMT.write(polygonString);
                    fileWriterSCECVDO.write(polygonString);
                }
                lat += this.cubeLatLonSpacing;
                lon += this.cubeLatLonSpacing;
            }
            fileWriterGMT.close();
            fileWriterSCECVDO.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void plotImpliedBulgeForSubSections(String dirName, String nameSuffix, boolean display) throws GMT_MapException, RuntimeException, IOException {
        File resultsDir = new File(GMT_CA_Maps.GMT_DIR, dirName);
        if (!resultsDir.exists()) {
            resultsDir.mkdir();
        }
        List<? extends FaultSection> faults = this.fssERF.getSolution().getRupSet().getFaultSectionDataList();
        double[] values = new double[faults.size()];
        FileWriter fileWriter = new FileWriter(new File(resultsDir, dirName + ".csv"));
        fileWriter.write("SectID,CharFactorSupraRates,CharFactorNumPrimary,CharFactorMoRate,subRate,supraRate,minSupraMag,MoRate,SectName,SubSect\n");
        double meanValSupraRates = 0.0;
        double meanValSupraRatesMoRateWted = 0.0;
        double meanValSupraRatesSupraRateWted = 0.0;
        double meanValNumPrimary = 0.0;
        double meanValNumPrimaryMoRateWted = 0.0;
        double meanValNumPrimarySupraRateWted = 0.0;
        double totMoRate = 0.0;
        double totSupraRate = 0.0;
        double meanValSupraRatesLog = 0.0;
        double meanValSupraRatesMoRateWtedLog = 0.0;
        double meanValSupraRatesSupraRateWtedLog = 0.0;
        double meanValLog = 0.0;
        double meanValMoRateWtedLog = 0.0;
        double meanValSupraRateWtedLog = 0.0;
        ArbDiscrEmpiricalDistFunc charValSupraRatesDist = new ArbDiscrEmpiricalDistFunc();
        ArbDiscrEmpiricalDistFunc charValSupraRatesDistMoRateWted = new ArbDiscrEmpiricalDistFunc();
        ArbDiscrEmpiricalDistFunc charValSupraRatesDistSupraRateWted = new ArbDiscrEmpiricalDistFunc();
        DefaultXY_DataSet charValSupraRatesVsMomentRateData = new DefaultXY_DataSet();
        DefaultXY_DataSet charValSupraRatesVsSupraRateData = new DefaultXY_DataSet();
        SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray();
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        int numPts = 0;
        for (int sectIndex = 0; sectIndex < values.length; ++sectIndex) {
            if (longTermSupraSeisMFD_OnSectArray[sectIndex] != null) {
                if (Double.isNaN(longTermSupraSeisMFD_OnSectArray[sectIndex].getMaxMagWithNonZeroRate())) {
                    System.out.println("NaN HERE: " + this.fssERF.getSolution().getRupSet().getFaultSectionData(sectIndex).getName());
                    throw new RuntimeException("Problem");
                }
            } else {
                throw new RuntimeException("Problem");
            }
            double valNumPrimary = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_numPrimary(longTermSupraSeisMFD_OnSectArray[sectIndex], longTermSubSeisMFD_OnSectList.get(sectIndex), false);
            double valSupraRates = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_supraRates(longTermSupraSeisMFD_OnSectArray[sectIndex], longTermSubSeisMFD_OnSectList.get(sectIndex), false);
            double valMoRate = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_MoRates(longTermSupraSeisMFD_OnSectArray[sectIndex], longTermSubSeisMFD_OnSectList.get(sectIndex), false);
            values[sectIndex] = Math.log10(valSupraRates);
            if (longTermSubSeisMFD_OnSectList.get(sectIndex).getTotalIncrRate() <= 1.0E-15) continue;
            ++numPts;
            double moRate = this.rupSet.getFaultSectionData(sectIndex).calcMomentRate(true);
            double minSupraMag = ETAS_Utils.getMinMagSupra(longTermSupraSeisMFD_OnSectArray[sectIndex], longTermSubSeisMFD_OnSectList.get(sectIndex));
            double supraRate = longTermSupraSeisMFD_OnSectArray[sectIndex].getCumRate(minSupraMag);
            double subRate = longTermSubSeisMFD_OnSectList.get(sectIndex).getCumRate(2.55);
            charValSupraRatesVsMomentRateData.set(moRate, valSupraRates);
            charValSupraRatesVsSupraRateData.set(supraRate, valSupraRates);
            meanValSupraRates += valSupraRates;
            meanValSupraRatesMoRateWted += moRate * valSupraRates;
            meanValSupraRatesSupraRateWted += supraRate * valSupraRates;
            meanValNumPrimary += valNumPrimary;
            meanValNumPrimaryMoRateWted += moRate * valNumPrimary;
            meanValNumPrimarySupraRateWted += supraRate * valNumPrimary;
            totMoRate += moRate;
            totSupraRate += supraRate;
            meanValSupraRatesLog += Math.log10(valSupraRates);
            meanValSupraRatesMoRateWtedLog += moRate * Math.log10(valSupraRates);
            meanValSupraRatesSupraRateWtedLog += supraRate * Math.log10(valSupraRates);
            meanValLog += Math.log10(valNumPrimary);
            meanValMoRateWtedLog += moRate * Math.log10(valNumPrimary);
            meanValSupraRateWtedLog += supraRate * Math.log10(valNumPrimary);
            charValSupraRatesDist.set(valSupraRates, 1.0);
            charValSupraRatesDistMoRateWted.set(valSupraRates, moRate);
            charValSupraRatesDistSupraRateWted.set(valSupraRates, supraRate);
            fileWriter.write(sectIndex + "," + (float)valSupraRates + "," + (float)valNumPrimary + "," + (float)valMoRate + "," + subRate + "," + supraRate + "," + minSupraMag + "," + moRate + "," + this.fssERF.getSolution().getRupSet().getFaultSectionData(sectIndex).getName() + "\n");
        }
        fileWriter.close();
        meanValSupraRates /= (double)numPts;
        meanValNumPrimary /= (double)numPts;
        meanValSupraRatesMoRateWted /= totMoRate;
        meanValNumPrimaryMoRateWted /= totMoRate;
        meanValSupraRatesSupraRateWted /= totSupraRate;
        meanValNumPrimarySupraRateWted /= totSupraRate;
        meanValSupraRatesLog /= (double)numPts;
        meanValLog /= (double)numPts;
        meanValSupraRatesMoRateWtedLog /= totMoRate;
        meanValMoRateWtedLog /= totMoRate;
        meanValSupraRatesSupraRateWtedLog /= totSupraRate;
        meanValSupraRateWtedLog /= totSupraRate;
        meanValSupraRatesLog = Math.pow(10.0, meanValSupraRatesLog);
        meanValLog = Math.pow(10.0, meanValLog);
        meanValSupraRatesMoRateWtedLog = Math.pow(10.0, meanValSupraRatesMoRateWtedLog);
        meanValMoRateWtedLog = Math.pow(10.0, meanValMoRateWtedLog);
        meanValSupraRatesSupraRateWtedLog = Math.pow(10.0, meanValSupraRatesSupraRateWtedLog);
        meanValSupraRateWtedLog = Math.pow(10.0, meanValSupraRateWtedLog);
        System.out.println("meanValSupraRates=" + meanValSupraRates + "\nmeanValSupraRatesMoRateWted=" + meanValSupraRatesMoRateWted + "\nmeanValSupraRatesSupraRateWted=" + meanValSupraRatesSupraRateWted);
        System.out.println("meanValNumPrimary=" + meanValNumPrimary + "\nmeanValNumPrimaryMoRateWted=" + meanValNumPrimaryMoRateWted + "\nmeanValNumPrimarySupraRateWted=" + meanValNumPrimarySupraRateWted);
        System.out.println("meanValSupraRatesLog=" + meanValSupraRatesLog + "\nmeanValSupraRatesMoRateWtedLog=" + meanValSupraRatesMoRateWtedLog + "\nmeanValSupraRatesSupraRateWtedLog=" + meanValSupraRatesSupraRateWtedLog);
        System.out.println("meanValNumPrimaryLog=" + meanValLog + "\nmeanValNumPrimaryMoRateWtedLog=" + meanValMoRateWtedLog + "\nmeanValNumPrimarySupraRateWtedLog=" + meanValSupraRateWtedLog);
        DiscretizedFunc charValSupraRatesDistCumDist = charValSupraRatesDist.getCumDist();
        charValSupraRatesDistCumDist.scale(1.0 / charValSupraRatesDist.calcSumOfY_Vals());
        charValSupraRatesDistCumDist.setName("charValSupraRatesDistCumDist");
        charValSupraRatesDistCumDist.setInfo("mean=" + charValSupraRatesDist.getMean() + "; median=" + charValSupraRatesDist.getMedian());
        DiscretizedFunc charValSupraRatesDistMoRateWtedCumDist = charValSupraRatesDistMoRateWted.getCumDist();
        charValSupraRatesDistMoRateWtedCumDist.scale(1.0 / charValSupraRatesDistMoRateWted.calcSumOfY_Vals());
        charValSupraRatesDistMoRateWtedCumDist.setName("charValSupraRatesDistMoRateWtedCumDist");
        charValSupraRatesDistMoRateWtedCumDist.setInfo("mean=" + charValSupraRatesDistMoRateWted.getMean() + "; median=" + charValSupraRatesDistMoRateWted.getMedian());
        DiscretizedFunc charValSupraRatesDistSupraRateWtedCumDist = charValSupraRatesDistSupraRateWted.getCumDist();
        charValSupraRatesDistSupraRateWtedCumDist.scale(1.0 / charValSupraRatesDistSupraRateWted.calcSumOfY_Vals());
        charValSupraRatesDistSupraRateWtedCumDist.setName("charValSupraRatesDistSupraRateWtedCumDist");
        charValSupraRatesDistSupraRateWtedCumDist.setInfo("mean=" + charValSupraRatesDistSupraRateWted.getMean() + "; median=" + charValSupraRatesDistSupraRateWted.getMedian());
        ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
        funcs.add(charValSupraRatesDistCumDist);
        funcs.add(charValSupraRatesDistMoRateWtedCumDist);
        funcs.add(charValSupraRatesDistSupraRateWtedCumDist);
        GraphWindow sectGraph = new GraphWindow(funcs, "Sect CharFactor Stats");
        sectGraph.setX_AxisLabel("CharFactor");
        sectGraph.setY_AxisLabel("Cumulative Fraction");
        sectGraph.setX_AxisRange(0.01, 100.0);
        sectGraph.setXLog(true);
        sectGraph.setY_AxisRange(0.0, 1.0);
        sectGraph.setAxisLabelFontSize(24);
        sectGraph.setTickLabelFontSize(22);
        sectGraph.setPlotLabelFontSize(26);
        File fileName1 = new File(resultsDir, "charValSupraRatesDist.pdf");
        sectGraph.saveAsPDF(fileName1.getAbsolutePath());
        GraphWindow sectGraph4 = new GraphWindow(charValSupraRatesVsMomentRateData, "CharFactor vs Moment Rate", new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLACK));
        sectGraph4.setY_AxisLabel("CharFactor");
        sectGraph4.setX_AxisLabel("Moment Rate (NM/yr)");
        sectGraph4.setXLog(true);
        sectGraph4.setYLog(true);
        sectGraph4.setAxisLabelFontSize(24);
        sectGraph4.setTickLabelFontSize(22);
        sectGraph4.setPlotLabelFontSize(26);
        File fileName2 = new File(resultsDir, "charValSupraRatesVsMoRate.pdf");
        sectGraph4.saveAsPDF(fileName2.getAbsolutePath());
        double startBinCenterLogX = -2.125;
        double binWidthLogX = 0.25;
        double endBinCenterLogX = -6.0;
        DefaultXY_DataSet medianBinnedData = new DefaultXY_DataSet();
        DefaultXY_DataSet meanBinnedData = new DefaultXY_DataSet();
        DefaultXY_DataSet meanMinus2stdomData = new DefaultXY_DataSet();
        DefaultXY_DataSet meanPlus2stdomData = new DefaultXY_DataSet();
        for (double binCenterLogX = startBinCenterLogX; binCenterLogX > endBinCenterLogX; binCenterLogX -= binWidthLogX) {
            double minVal = Math.pow(10.0, binCenterLogX - binWidthLogX / 2.0);
            double maxVal = Math.pow(10.0, binCenterLogX + binWidthLogX / 2.0);
            ArbDiscrEmpiricalDistFunc distFunc = new ArbDiscrEmpiricalDistFunc();
            for (int i = 0; i < charValSupraRatesVsSupraRateData.size(); ++i) {
                double xVal = charValSupraRatesVsSupraRateData.getX(i);
                if (!(xVal > minVal) || !(xVal <= maxVal)) continue;
                distFunc.set(Math.log10(charValSupraRatesVsSupraRateData.getY(i)), 1.0);
            }
            medianBinnedData.set(Math.pow(10.0, binCenterLogX), Math.pow(10.0, distFunc.getMedian()));
            meanBinnedData.set(Math.pow(10.0, binCenterLogX), Math.pow(10.0, distFunc.getMean()));
            double stdom = distFunc.getStdDev() / Math.sqrt(distFunc.calcSumOfY_Vals());
            meanMinus2stdomData.set(Math.pow(10.0, binCenterLogX), Math.pow(10.0, distFunc.getMean() - 2.0 * stdom));
            meanPlus2stdomData.set(Math.pow(10.0, binCenterLogX), Math.pow(10.0, distFunc.getMean() + 2.0 * stdom));
        }
        ArrayList<DefaultXY_DataSet> funcs2 = new ArrayList<DefaultXY_DataSet>();
        funcs2.add(charValSupraRatesVsSupraRateData);
        funcs2.add(medianBinnedData);
        funcs2.add(meanBinnedData);
        funcs2.add(meanMinus2stdomData);
        funcs2.add(meanPlus2stdomData);
        ArrayList<PlotCurveCharacterstics> plotCharList = new ArrayList<PlotCurveCharacterstics>();
        plotCharList.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLACK));
        plotCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        plotCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        plotCharList.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        plotCharList.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        plotCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.red));
        GraphWindow sectGraph5 = new GraphWindow(funcs2, "CharFactor vs SupraRate", plotCharList);
        sectGraph5.setY_AxisLabel("CharFactor");
        sectGraph5.setX_AxisLabel("SupraRate (per year)");
        sectGraph5.setXLog(true);
        sectGraph5.setYLog(true);
        sectGraph5.setAxisLabelFontSize(24);
        sectGraph5.setTickLabelFontSize(22);
        sectGraph5.setPlotLabelFontSize(26);
        File fileName3 = new File(resultsDir, "charValSupraRatesVsSupraRate.pdf");
        sectGraph5.saveAsPDF(fileName3.getAbsolutePath());
        String name = "ImpliedCharFactorForSubSections_" + nameSuffix;
        String title = "Log10(CharFactor)";
        CPT cpt = FaultBasedMapGen.getLogRatioCPT().rescale(-2.0, 2.0);
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, this.origGriddedRegion, resultsDir, name, display, false, title);
    }

    public void plotImpliedBulgeForSubSectionsHackTestMoRate(File resultsDir, String nameSuffix, boolean display) throws GMT_MapException, RuntimeException, IOException {
        if (!resultsDir.exists()) {
            resultsDir.mkdir();
        }
        List<? extends FaultSection> faults = this.fssERF.getSolution().getRupSet().getFaultSectionDataList();
        double[] values = new double[faults.size()];
        FileWriter fileWriter = new FileWriter(new File(resultsDir, "FaultSubsectionCharFactorData.csv"));
        fileWriter.write("SectID,CharFactorSupraRates,CharFactorNumPrimary,supraRate,MoRate,SectName\n");
        double meanValSupraRates = 0.0;
        double meanValSupraRatesMoRateWted = 0.0;
        double meanValSupraRatesSupraRateWted = 0.0;
        double meanValNumPrimary = 0.0;
        double meanValNumPrimaryMoRateWted = 0.0;
        double meanValNumPrimarySupraRateWted = 0.0;
        double totMoRate = 0.0;
        double totSupraRate = 0.0;
        double meanValSupraRatesLog = 0.0;
        double meanValSupraRatesMoRateWtedLog = 0.0;
        double meanValSupraRatesSupraRateWtedLog = 0.0;
        double meanValLog = 0.0;
        double meanValMoRateWtedLog = 0.0;
        double meanValSupraRateWtedLog = 0.0;
        ArbDiscrEmpiricalDistFunc charValSupraRatesDist = new ArbDiscrEmpiricalDistFunc();
        ArbDiscrEmpiricalDistFunc charValSupraRatesDistMoRateWted = new ArbDiscrEmpiricalDistFunc();
        ArbDiscrEmpiricalDistFunc charValSupraRatesDistSupraRateWted = new ArbDiscrEmpiricalDistFunc();
        DefaultXY_DataSet charValSupraRatesVsMomentRateData = new DefaultXY_DataSet();
        DefaultXY_DataSet charValSupraRatesVsSupraRateData = new DefaultXY_DataSet();
        SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray();
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        int numPts = 0;
        for (int sectIndex = 0; sectIndex < values.length; ++sectIndex) {
            if (longTermSupraSeisMFD_OnSectArray[sectIndex] != null) {
                if (Double.isNaN(longTermSupraSeisMFD_OnSectArray[sectIndex].getMaxMagWithNonZeroRate())) {
                    System.out.println("NaN HERE: " + this.fssERF.getSolution().getRupSet().getFaultSectionData(sectIndex).getName());
                    throw new RuntimeException("Problem");
                }
            } else {
                throw new RuntimeException("Problem");
            }
            double valNumPrimary = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_numPrimary(longTermSupraSeisMFD_OnSectArray[sectIndex], longTermSubSeisMFD_OnSectList.get(sectIndex), false);
            double valSupraRates = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_MoRates(longTermSupraSeisMFD_OnSectArray[sectIndex], longTermSubSeisMFD_OnSectList.get(sectIndex), false);
            values[sectIndex] = Math.log10(valSupraRates);
            if (longTermSubSeisMFD_OnSectList.get(sectIndex).getTotalIncrRate() <= 1.0E-15) continue;
            ++numPts;
            double moRate = this.rupSet.getFaultSectionData(sectIndex).calcMomentRate(true);
            double minSupraMag = ETAS_Utils.getMinMagSupra(longTermSupraSeisMFD_OnSectArray[sectIndex], longTermSubSeisMFD_OnSectList.get(sectIndex));
            double supraRate = longTermSupraSeisMFD_OnSectArray[sectIndex].getCumRate(minSupraMag);
            charValSupraRatesVsMomentRateData.set(moRate, valSupraRates);
            charValSupraRatesVsSupraRateData.set(moRate, valSupraRates);
            meanValSupraRates += valSupraRates;
            meanValSupraRatesMoRateWted += moRate * valSupraRates;
            meanValSupraRatesSupraRateWted += supraRate * valSupraRates;
            meanValNumPrimary += valNumPrimary;
            meanValNumPrimaryMoRateWted += moRate * valNumPrimary;
            meanValNumPrimarySupraRateWted += supraRate * valNumPrimary;
            totMoRate += moRate;
            totSupraRate += supraRate;
            meanValSupraRatesLog += Math.log10(valSupraRates);
            meanValSupraRatesMoRateWtedLog += moRate * Math.log10(valSupraRates);
            meanValSupraRatesSupraRateWtedLog += supraRate * Math.log10(valSupraRates);
            meanValLog += Math.log10(valNumPrimary);
            meanValMoRateWtedLog += moRate * Math.log10(valNumPrimary);
            meanValSupraRateWtedLog += supraRate * Math.log10(valNumPrimary);
            charValSupraRatesDist.set(valSupraRates, 1.0);
            charValSupraRatesDistMoRateWted.set(valSupraRates, moRate);
            charValSupraRatesDistSupraRateWted.set(valSupraRates, supraRate);
            fileWriter.write(sectIndex + "," + (float)valSupraRates + "," + (float)valNumPrimary + "," + supraRate + "," + moRate + "," + this.fssERF.getSolution().getRupSet().getFaultSectionData(sectIndex).getName() + "\n");
        }
        fileWriter.close();
        meanValSupraRates /= (double)numPts;
        meanValNumPrimary /= (double)numPts;
        meanValSupraRatesMoRateWted /= totMoRate;
        meanValNumPrimaryMoRateWted /= totMoRate;
        meanValSupraRatesSupraRateWted /= totSupraRate;
        meanValNumPrimarySupraRateWted /= totSupraRate;
        meanValSupraRatesLog /= (double)numPts;
        meanValLog /= (double)numPts;
        meanValSupraRatesMoRateWtedLog /= totMoRate;
        meanValMoRateWtedLog /= totMoRate;
        meanValSupraRatesSupraRateWtedLog /= totSupraRate;
        meanValSupraRateWtedLog /= totSupraRate;
        meanValSupraRatesLog = Math.pow(10.0, meanValSupraRatesLog);
        meanValLog = Math.pow(10.0, meanValLog);
        meanValSupraRatesMoRateWtedLog = Math.pow(10.0, meanValSupraRatesMoRateWtedLog);
        meanValMoRateWtedLog = Math.pow(10.0, meanValMoRateWtedLog);
        meanValSupraRatesSupraRateWtedLog = Math.pow(10.0, meanValSupraRatesSupraRateWtedLog);
        meanValSupraRateWtedLog = Math.pow(10.0, meanValSupraRateWtedLog);
        System.out.println("meanValSupraRates=" + meanValSupraRates + "\nmeanValSupraRatesMoRateWted=" + meanValSupraRatesMoRateWted + "\nmeanValSupraRatesSupraRateWted=" + meanValSupraRatesSupraRateWted);
        System.out.println("meanValNumPrimary=" + meanValNumPrimary + "\nmeanValNumPrimaryMoRateWted=" + meanValNumPrimaryMoRateWted + "\nmeanValNumPrimarySupraRateWted=" + meanValNumPrimarySupraRateWted);
        System.out.println("meanValSupraRatesLog=" + meanValSupraRatesLog + "\nmeanValSupraRatesMoRateWtedLog=" + meanValSupraRatesMoRateWtedLog + "\nmeanValSupraRatesSupraRateWtedLog=" + meanValSupraRatesSupraRateWtedLog);
        System.out.println("meanValNumPrimaryLog=" + meanValLog + "\nmeanValNumPrimaryMoRateWtedLog=" + meanValMoRateWtedLog + "\nmeanValNumPrimarySupraRateWtedLog=" + meanValSupraRateWtedLog);
        DiscretizedFunc charValSupraRatesDistCumDist = charValSupraRatesDist.getCumDist();
        charValSupraRatesDistCumDist.scale(1.0 / charValSupraRatesDist.calcSumOfY_Vals());
        charValSupraRatesDistCumDist.setName("charValSupraRatesDistCumDist");
        charValSupraRatesDistCumDist.setInfo("mean=" + charValSupraRatesDist.getMean() + "; median=" + charValSupraRatesDist.getMedian());
        DiscretizedFunc charValSupraRatesDistMoRateWtedCumDist = charValSupraRatesDistMoRateWted.getCumDist();
        charValSupraRatesDistMoRateWtedCumDist.scale(1.0 / charValSupraRatesDistMoRateWted.calcSumOfY_Vals());
        charValSupraRatesDistMoRateWtedCumDist.setName("charValSupraRatesDistMoRateWtedCumDist");
        charValSupraRatesDistMoRateWtedCumDist.setInfo("mean=" + charValSupraRatesDistMoRateWted.getMean() + "; median=" + charValSupraRatesDistMoRateWted.getMedian());
        DiscretizedFunc charValSupraRatesDistSupraRateWtedCumDist = charValSupraRatesDistSupraRateWted.getCumDist();
        charValSupraRatesDistSupraRateWtedCumDist.scale(1.0 / charValSupraRatesDistSupraRateWted.calcSumOfY_Vals());
        charValSupraRatesDistSupraRateWtedCumDist.setName("charValSupraRatesDistSupraRateWtedCumDist");
        charValSupraRatesDistSupraRateWtedCumDist.setInfo("mean=" + charValSupraRatesDistSupraRateWted.getMean() + "; median=" + charValSupraRatesDistSupraRateWted.getMedian());
        ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
        funcs.add(charValSupraRatesDistCumDist);
        funcs.add(charValSupraRatesDistMoRateWtedCumDist);
        funcs.add(charValSupraRatesDistSupraRateWtedCumDist);
        GraphWindow sectGraph = new GraphWindow(funcs, "Sect CharFactor Stats");
        sectGraph.setX_AxisLabel("CharFactor");
        sectGraph.setY_AxisLabel("Cumulative Fraction");
        sectGraph.setX_AxisRange(0.01, 100.0);
        sectGraph.setXLog(true);
        sectGraph.setY_AxisRange(0.0, 1.0);
        sectGraph.setAxisLabelFontSize(24);
        sectGraph.setTickLabelFontSize(22);
        sectGraph.setPlotLabelFontSize(26);
        File fileName1 = new File(resultsDir, "charValSupraRatesDist.pdf");
        sectGraph.saveAsPDF(fileName1.getAbsolutePath());
        GraphWindow sectGraph4 = new GraphWindow(charValSupraRatesVsMomentRateData, "CharFactor vs Moment Rate", new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLACK));
        sectGraph4.setY_AxisLabel("CharFactor");
        sectGraph4.setX_AxisLabel("Moment Rate (NM/yr)");
        sectGraph4.setXLog(true);
        sectGraph4.setYLog(true);
        sectGraph4.setAxisLabelFontSize(24);
        sectGraph4.setTickLabelFontSize(22);
        sectGraph4.setPlotLabelFontSize(26);
        File fileName2 = new File(resultsDir, "charValSupraRatesVsMoRate.pdf");
        sectGraph4.saveAsPDF(fileName2.getAbsolutePath());
        double startBinCenterLogX = 17.0;
        double binWidthLogX = 0.5;
        double endBinCenterLogX = 13.0;
        DefaultXY_DataSet medianBinnedData = new DefaultXY_DataSet();
        DefaultXY_DataSet meanBinnedData = new DefaultXY_DataSet();
        DefaultXY_DataSet meanMinus2stdomData = new DefaultXY_DataSet();
        DefaultXY_DataSet meanPlus2stdomData = new DefaultXY_DataSet();
        for (double binCenterLogX = startBinCenterLogX; binCenterLogX > endBinCenterLogX; binCenterLogX -= binWidthLogX) {
            double minVal = Math.pow(10.0, binCenterLogX - binWidthLogX / 2.0);
            double maxVal = Math.pow(10.0, binCenterLogX + binWidthLogX / 2.0);
            ArbDiscrEmpiricalDistFunc distFunc = new ArbDiscrEmpiricalDistFunc();
            for (int i = 0; i < charValSupraRatesVsSupraRateData.size(); ++i) {
                double xVal = charValSupraRatesVsSupraRateData.getX(i);
                if (!(xVal > minVal) || !(xVal <= maxVal)) continue;
                distFunc.set(Math.log10(charValSupraRatesVsSupraRateData.getY(i)), 1.0);
            }
            medianBinnedData.set(Math.pow(10.0, binCenterLogX), Math.pow(10.0, distFunc.getMedian()));
            meanBinnedData.set(Math.pow(10.0, binCenterLogX), Math.pow(10.0, distFunc.getMean()));
            double stdom = distFunc.getStdDev() / Math.sqrt(distFunc.calcSumOfY_Vals());
            meanMinus2stdomData.set(Math.pow(10.0, binCenterLogX), Math.pow(10.0, distFunc.getMean() - 2.0 * stdom));
            meanPlus2stdomData.set(Math.pow(10.0, binCenterLogX), Math.pow(10.0, distFunc.getMean() + 2.0 * stdom));
        }
        ArrayList<DefaultXY_DataSet> funcs2 = new ArrayList<DefaultXY_DataSet>();
        funcs2.add(charValSupraRatesVsSupraRateData);
        funcs2.add(medianBinnedData);
        funcs2.add(meanBinnedData);
        funcs2.add(meanMinus2stdomData);
        funcs2.add(meanPlus2stdomData);
        ArrayList<PlotCurveCharacterstics> plotCharList = new ArrayList<PlotCurveCharacterstics>();
        plotCharList.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLACK));
        plotCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        plotCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        plotCharList.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        plotCharList.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        plotCharList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.red));
        GraphWindow sectGraph5 = new GraphWindow(funcs2, "CharFactor vs SupraRate", plotCharList);
        sectGraph5.setY_AxisLabel("CharFactor");
        sectGraph5.setX_AxisLabel("SupraRate (per year)");
        sectGraph5.setXLog(true);
        sectGraph5.setYLog(true);
        sectGraph5.setAxisLabelFontSize(24);
        sectGraph5.setTickLabelFontSize(22);
        sectGraph5.setPlotLabelFontSize(26);
        File fileName3 = new File(resultsDir, "charValSupraRatesVsSupraRate.pdf");
        sectGraph5.saveAsPDF(fileName3.getAbsolutePath());
        String name = "ImpliedCharFactorForSubSections_" + nameSuffix;
        String title = "Log10(CharFactor)";
        CPT cpt = FaultBasedMapGen.getLogRatioCPT().rescale(-2.0, 2.0);
        FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, this.origGriddedRegion, resultsDir, name, display, false, title);
    }

    public void plotCharFactorStats(File resultsDir) {
        if (!resultsDir.exists()) {
            resultsDir.mkdir();
        }
        List<? extends FaultSection> faults = this.fssERF.getSolution().getRupSet().getFaultSectionDataList();
        double[] charFactorNumPrimaryArray = new double[faults.size()];
        double[] charFactorSupraRatesArray = new double[faults.size()];
        double[] supraRatesArray = new double[faults.size()];
        DefaultXY_DataSet logCharFactorNumPrimaryVsLogSupraRate = new DefaultXY_DataSet();
        DefaultXY_DataSet logCharFactorSupraSeisVsLogSupraRate = new DefaultXY_DataSet();
        SummedMagFreqDist totSubMFD = new SummedMagFreqDist(2.55, 8.95, 65);
        SummedMagFreqDist totSupraMFD = new SummedMagFreqDist(2.55, 8.95, 65);
        HashMap<String, SummedMagFreqDist> parentSectSubSeisMFD_Map = new HashMap<String, SummedMagFreqDist>();
        HashMap<String, SummedMagFreqDist> parentSectSupraSeisMFD_Map = new HashMap<String, SummedMagFreqDist>();
        for (int sectIndex = 0; sectIndex < charFactorNumPrimaryArray.length; ++sectIndex) {
            String name = this.rupSet.getFaultSectionData(sectIndex).getParentSectionName();
            if (!parentSectSubSeisMFD_Map.containsKey(name)) {
                parentSectSubSeisMFD_Map.put(name, new SummedMagFreqDist(2.55, 8.95, 65));
            }
            if (parentSectSupraSeisMFD_Map.containsKey(name)) continue;
            parentSectSupraSeisMFD_Map.put(name, new SummedMagFreqDist(2.55, 8.95, 65));
        }
        SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray();
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        for (int sectIndex = 0; sectIndex < charFactorNumPrimaryArray.length; ++sectIndex) {
            if (longTermSupraSeisMFD_OnSectArray[sectIndex].getMaxY() == 0.0 || longTermSubSeisMFD_OnSectList.get(sectIndex).getMaxY() == 0.0) {
                charFactorNumPrimaryArray[sectIndex] = Double.NaN;
                charFactorSupraRatesArray[sectIndex] = Double.NaN;
                supraRatesArray[sectIndex] = Double.NaN;
            } else {
                charFactorNumPrimaryArray[sectIndex] = Math.log10(1.0 / ETAS_Utils.getScalingFactorToImposeGR_numPrimary(longTermSupraSeisMFD_OnSectArray[sectIndex], longTermSubSeisMFD_OnSectList.get(sectIndex), false));
                charFactorSupraRatesArray[sectIndex] = Math.log10(1.0 / ETAS_Utils.getScalingFactorToImposeGR_supraRates(longTermSupraSeisMFD_OnSectArray[sectIndex], longTermSubSeisMFD_OnSectList.get(sectIndex), false));
                double minSupraMag = ETAS_Utils.getMinMagSupra(longTermSupraSeisMFD_OnSectArray[sectIndex], longTermSubSeisMFD_OnSectList.get(sectIndex));
                supraRatesArray[sectIndex] = longTermSupraSeisMFD_OnSectArray[sectIndex].getCumRate(minSupraMag);
                logCharFactorNumPrimaryVsLogSupraRate.set(Math.log10(supraRatesArray[sectIndex]), charFactorNumPrimaryArray[sectIndex]);
                logCharFactorSupraSeisVsLogSupraRate.set(Math.log10(supraRatesArray[sectIndex]), charFactorSupraRatesArray[sectIndex]);
            }
            totSubMFD.addIncrementalMagFreqDist(longTermSubSeisMFD_OnSectList.get(sectIndex));
            totSupraMFD.addIncrementalMagFreqDist(longTermSupraSeisMFD_OnSectArray[sectIndex]);
            String name = this.rupSet.getFaultSectionData(sectIndex).getParentSectionName();
            ((SummedMagFreqDist)parentSectSubSeisMFD_Map.get(name)).addIncrementalMagFreqDist(longTermSubSeisMFD_OnSectList.get(sectIndex));
            ((SummedMagFreqDist)parentSectSupraSeisMFD_Map.get(name)).addIncrementalMagFreqDist(longTermSupraSeisMFD_OnSectArray[sectIndex]);
        }
        HistogramFunction histNumPrimary_SupraRateWted = new HistogramFunction(-3.0, 3.0, 61);
        HistogramFunction histSupraRates_SupraRateWted = new HistogramFunction(-3.0, 3.0, 61);
        HistogramFunction histNumPrimary = new HistogramFunction(-3.0, 3.0, 61);
        HistogramFunction histSupraRates = new HistogramFunction(-3.0, 3.0, 61);
        for (int sectIndex = 0; sectIndex < charFactorNumPrimaryArray.length; ++sectIndex) {
            if (Double.isNaN(supraRatesArray[sectIndex])) continue;
            histNumPrimary_SupraRateWted.add(charFactorNumPrimaryArray[sectIndex], supraRatesArray[sectIndex]);
            histSupraRates_SupraRateWted.add(charFactorSupraRatesArray[sectIndex], supraRatesArray[sectIndex]);
            histNumPrimary.add(charFactorNumPrimaryArray[sectIndex], 1.0);
            histSupraRates.add(charFactorSupraRatesArray[sectIndex], 1.0);
        }
        histNumPrimary_SupraRateWted.normalizeBySumOfY_Vals();
        histNumPrimary_SupraRateWted.setName("histNumPrimary_SupraRateWted");
        HistogramFunction histNumPrimary_SupraRateWtedCum = histNumPrimary_SupraRateWted.getCumulativeDistFunctionWithHalfBinOffset();
        histNumPrimary_SupraRateWtedCum.setName("histNumPrimary_SupraRateWtedCum");
        double median = histNumPrimary_SupraRateWtedCum.getFirstInterpolatedX(0.5);
        String info = "mean=" + Math.pow(10.0, histNumPrimary_SupraRateWted.computeMean()) + "; mode=" + Math.pow(10.0, histNumPrimary_SupraRateWted.getMode()) + "; median=" + Math.pow(10.0, median);
        histNumPrimary_SupraRateWted.setInfo(info);
        histNumPrimary_SupraRateWtedCum.setInfo(info);
        histSupraRates_SupraRateWted.normalizeBySumOfY_Vals();
        histSupraRates_SupraRateWted.setName("histSupraRates_SupraRateWted");
        HistogramFunction histSupraRates_SupraRateWtedCum = histSupraRates_SupraRateWted.getCumulativeDistFunctionWithHalfBinOffset();
        histSupraRates_SupraRateWtedCum.setName("histSupraRates_SupraRateWtedCum");
        median = histSupraRates_SupraRateWtedCum.getFirstInterpolatedX(0.5);
        info = "Stats converted out of log space:\ngeom mean=" + Math.pow(10.0, histSupraRates_SupraRateWted.computeMean()) + "; mode=" + Math.pow(10.0, histSupraRates_SupraRateWted.getMode()) + "; median=" + Math.pow(10.0, median);
        histSupraRates_SupraRateWted.setInfo(info);
        histSupraRates_SupraRateWtedCum.setInfo(info);
        ArrayList<HistogramFunction> funcs1 = new ArrayList<HistogramFunction>();
        funcs1.add(histNumPrimary_SupraRateWted);
        funcs1.add(histNumPrimary_SupraRateWtedCum);
        funcs1.add(histSupraRates_SupraRateWted);
        funcs1.add(histSupraRates_SupraRateWtedCum);
        GraphWindow graph = new GraphWindow(funcs1, "CharFactor Stats SupraRate Wted");
        graph.setX_AxisLabel("Log10-CharFactor");
        graph.setY_AxisLabel("Density");
        histNumPrimary.normalizeBySumOfY_Vals();
        histNumPrimary.setName("histNumPrimary");
        HistogramFunction histNumPrimaryCum = histNumPrimary.getCumulativeDistFunctionWithHalfBinOffset();
        histNumPrimaryCum.setName("histNumPrimaryCum");
        median = histNumPrimaryCum.getFirstInterpolatedX(0.5);
        info = "Stats converted out of log space:\ngeom mean=" + Math.pow(10.0, histNumPrimary.computeMean()) + "; mode=" + Math.pow(10.0, histNumPrimary.getMode()) + "; median=" + Math.pow(10.0, median);
        histNumPrimary.setInfo(info);
        histNumPrimaryCum.setInfo(info);
        histSupraRates.normalizeBySumOfY_Vals();
        histSupraRates.setName("histSupraRates");
        HistogramFunction histSupraRatesCum = histSupraRates.getCumulativeDistFunctionWithHalfBinOffset();
        histSupraRatesCum.setName("histSupraRatesCum");
        median = histSupraRatesCum.getFirstInterpolatedX(0.5);
        info = "Stats converted out of log space:\ngeom mean=" + Math.pow(10.0, histSupraRates.computeMean()) + "; mode=" + Math.pow(10.0, histSupraRates.getMode()) + "; median=" + Math.pow(10.0, median);
        histSupraRates.setInfo(info);
        histSupraRatesCum.setInfo(info);
        ArrayList<HistogramFunction> funcs2 = new ArrayList<HistogramFunction>();
        funcs2.add(histNumPrimary);
        funcs2.add(histNumPrimaryCum);
        funcs2.add(histSupraRates);
        funcs2.add(histSupraRatesCum);
        GraphWindow graph4 = new GraphWindow(funcs2, "CharFactor Stats");
        graph4.setX_AxisLabel("Log10-GRcorr");
        graph4.setY_AxisLabel("Density");
        GraphWindow graph2 = new GraphWindow(logCharFactorNumPrimaryVsLogSupraRate, "CharFactorNumPrimary vs SupraRate", new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        graph2.setY_AxisLabel("Log10-CharFactor");
        graph2.setX_AxisLabel("Log10(SupraRate)");
        GraphWindow graph3 = new GraphWindow(logCharFactorSupraSeisVsLogSupraRate, "CharFactorSupraRates vs SupraRate", new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        graph3.setY_AxisLabel("Log10-CharFactor");
        graph3.setX_AxisLabel("Log10(SupraRate)");
        IncrementalMagFreqDist tempSubMFD = new IncrementalMagFreqDist(2.55, 8.95, 65);
        IncrementalMagFreqDist tempSupraMFD = new IncrementalMagFreqDist(2.55, 8.95, 65);
        for (int i = 0; i < totSupraMFD.size(); ++i) {
            if (totSupraMFD.getX(i) < 6.3) {
                tempSubMFD.set(i, totSubMFD.getY(i));
                continue;
            }
            tempSupraMFD.set(i, totSupraMFD.getY(i));
        }
        double totCharFactorNumPrimary = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_numPrimary(tempSupraMFD, tempSubMFD, false);
        double totCharFactorNumPrimary2 = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_numPrimary(totSupraMFD, totSubMFD, false);
        double totCharFactorSupraRates = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_supraRates(tempSupraMFD, tempSubMFD, false);
        info = "totCharFactorNumPrimary=" + totCharFactorNumPrimary + "\ntotCharFactorSupraRates=" + totCharFactorSupraRates + "\ntotCharFactorNumPrimary2=" + totCharFactorNumPrimary2;
        double minMag = 2.55;
        double maxMag = totSupraMFD.getMaxMagWithNonZeroRate();
        int numMag = (int)Math.round((maxMag - minMag) / totSupraMFD.getDelta()) + 1;
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(1.0, 1.0, minMag, maxMag, numMag);
        gr.scaleToIncrRate(minMag, totSubMFD.getY(minMag));
        gr.setName("Perfect GR");
        totSubMFD.setInfo(info);
        totSupraMFD.setInfo(info);
        SummedMagFreqDist totalTrulyOffFaultMFD = new SummedMagFreqDist(2.55, 8.95, 65);
        SummedMagFreqDist totalModelMFD = new SummedMagFreqDist(2.55, 8.95, 65);
        for (int src = this.fssERF.getNumFaultSystemSources(); src < this.fssERF.getNumSources(); ++src) {
            if (this.mfdForTrulyOffOnlyArray[src] == null) continue;
            totalTrulyOffFaultMFD.addIncrementalMagFreqDist(this.mfdForTrulyOffOnlyArray[src]);
        }
        totalModelMFD.addIncrementalMagFreqDist(totalTrulyOffFaultMFD);
        totalModelMFD.addIncrementalMagFreqDist(totSubMFD);
        totalModelMFD.addIncrementalMagFreqDist(totSupraMFD);
        totalModelMFD.setName("totalModelMFD");
        totalTrulyOffFaultMFD.setName("totalTrulyOffFaultMFD");
        ArrayList<EvenlyDiscretizedFunc> totalFuncs = new ArrayList<EvenlyDiscretizedFunc>();
        totalFuncs.add(totSubMFD);
        totalFuncs.add(totSupraMFD);
        totalFuncs.add(gr);
        totalFuncs.add(totSubMFD.getCumRateDistWithOffset());
        totalFuncs.add(totSupraMFD.getCumRateDistWithOffset());
        totalFuncs.add(gr.getCumRateDistWithOffset());
        totalFuncs.add(totalModelMFD.getCumRateDistWithOffset());
        GraphWindow totMFD_Graph = new GraphWindow(totalFuncs, "Total MFDs");
        totMFD_Graph.setYLog(true);
        ArbDiscrEmpiricalDistFunc parSectCharFactorDistSupraRateWted = new ArbDiscrEmpiricalDistFunc();
        ArbDiscrEmpiricalDistFunc parSectCharFactorDist = new ArbDiscrEmpiricalDistFunc();
        DefaultXY_DataSet parSectCharFactorVsMomentRateData = new DefaultXY_DataSet();
        DefaultXY_DataSet parSectCharFactorVsSupraRateData = new DefaultXY_DataSet();
        System.out.println("name\tcharFactorSurpaRates\tcharFactorNumPrimary\tsupraRate\tmoRate");
        for (String name : parentSectSupraSeisMFD_Map.keySet()) {
            double parGRcorrSupraRates = ETAS_Utils.getScalingFactorToImposeGR_supraRates((IncrementalMagFreqDist)parentSectSupraSeisMFD_Map.get(name), (IncrementalMagFreqDist)parentSectSubSeisMFD_Map.get(name), false);
            double parGRcorr = ETAS_Utils.getScalingFactorToImposeGR_numPrimary((IncrementalMagFreqDist)parentSectSupraSeisMFD_Map.get(name), (IncrementalMagFreqDist)parentSectSubSeisMFD_Map.get(name), false);
            double moRate = ((SummedMagFreqDist)parentSectSupraSeisMFD_Map.get(name)).getTotalMomentRate() + ((SummedMagFreqDist)parentSectSubSeisMFD_Map.get(name)).getTotalMomentRate();
            double minMagSupra = ETAS_Utils.getMinMagSupra((IncrementalMagFreqDist)parentSectSupraSeisMFD_Map.get(name), (IncrementalMagFreqDist)parentSectSubSeisMFD_Map.get(name));
            double supraRate = ((SummedMagFreqDist)parentSectSupraSeisMFD_Map.get(name)).getCumRate(minMagSupra);
            parSectCharFactorDist.set(1.0 / parGRcorrSupraRates, 1.0);
            parSectCharFactorDistSupraRateWted.set(1.0 / parGRcorrSupraRates, minMagSupra);
            parSectCharFactorVsMomentRateData.set(moRate, 1.0 / parGRcorrSupraRates);
            parSectCharFactorVsSupraRateData.set(supraRate, 1.0 / parGRcorrSupraRates);
            System.out.println(name + "\t" + 1.0 / parGRcorrSupraRates + "\t" + 1.0 / parGRcorr + "\t" + supraRate + "\t" + moRate);
        }
        DiscretizedFunc parSectCharFactorDistSupraRateWtedCum = parSectCharFactorDistSupraRateWted.getCumDist();
        parSectCharFactorDistSupraRateWtedCum.scale(1.0 / parSectCharFactorDistSupraRateWted.calcSumOfY_Vals());
        parSectCharFactorDistSupraRateWtedCum.setName("parSectCharFactorDistSupraRateWtedCum");
        parSectCharFactorDistSupraRateWtedCum.setInfo("mean=" + parSectCharFactorDistSupraRateWted.getMean() + "; median=" + parSectCharFactorDistSupraRateWted.getMedian());
        DiscretizedFunc parSectCharFactorDistCum = parSectCharFactorDist.getCumDist();
        parSectCharFactorDistCum.scale(1.0 / parSectCharFactorDist.calcSumOfY_Vals());
        parSectCharFactorDistCum.setName("parSectCharFactorDistCum");
        parSectCharFactorDistCum.setInfo("mean=" + parSectCharFactorDist.getMean() + "; median=" + parSectCharFactorDist.getMedian());
        ArrayList<DiscretizedFunc> parSectFuncs = new ArrayList<DiscretizedFunc>();
        parSectFuncs.add(parSectCharFactorDistSupraRateWtedCum);
        parSectFuncs.add(parSectCharFactorDistCum);
        GraphWindow parSectGraph = new GraphWindow(parSectFuncs, "Parent Sect CharFactor Stats");
        parSectGraph.setX_AxisLabel("CharFactor");
        parSectGraph.setY_AxisLabel("Cumulative Density");
        parSectGraph.setXLog(true);
        parSectGraph.setAxisLabelFontSize(20);
        parSectGraph.setTickLabelFontSize(18);
        parSectGraph.setPlotLabelFontSize(22);
        GraphWindow parSectGrCorrVsMoRateGraph = new GraphWindow(parSectCharFactorVsMomentRateData, "parSectCharFactorVsMomentRateData", new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLACK));
        parSectGrCorrVsMoRateGraph.setY_AxisLabel("CharFactor");
        parSectGrCorrVsMoRateGraph.setX_AxisLabel("Moment Rate (NM/yr)");
        parSectGrCorrVsMoRateGraph.setXLog(true);
        parSectGrCorrVsMoRateGraph.setYLog(true);
        parSectGrCorrVsMoRateGraph.setAxisLabelFontSize(20);
        parSectGrCorrVsMoRateGraph.setTickLabelFontSize(18);
        parSectGrCorrVsMoRateGraph.setPlotLabelFontSize(22);
        GraphWindow parSectGrCorrVsSupraRateGraph = new GraphWindow(parSectCharFactorVsSupraRateData, "parSectCharFactorVsSupraRateData", new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLACK));
        parSectGrCorrVsSupraRateGraph.setY_AxisLabel("CharFactor");
        parSectGrCorrVsSupraRateGraph.setX_AxisLabel("SupraRate");
        parSectGrCorrVsSupraRateGraph.setXLog(true);
        parSectGrCorrVsSupraRateGraph.setYLog(true);
        parSectGrCorrVsSupraRateGraph.setAxisLabelFontSize(20);
        parSectGrCorrVsSupraRateGraph.setTickLabelFontSize(18);
        parSectGrCorrVsSupraRateGraph.setPlotLabelFontSize(22);
    }

    public void OLDplotCharFactorStats(File resultsDir) {
        if (!resultsDir.exists()) {
            resultsDir.mkdir();
        }
        List<? extends FaultSection> faults = this.fssERF.getSolution().getRupSet().getFaultSectionDataList();
        double[] charFactorNumPrimaryArray = new double[faults.size()];
        double[] charFactorSupraRatesArray = new double[faults.size()];
        double[] momentRates = new double[faults.size()];
        DefaultXY_DataSet logCharFactorNumPrimaryVsLogMomentRate = new DefaultXY_DataSet();
        DefaultXY_DataSet logCharFactorSupraSeisVsLogMomentRate = new DefaultXY_DataSet();
        SummedMagFreqDist totSubMFD = new SummedMagFreqDist(2.55, 8.95, 65);
        SummedMagFreqDist totSupraMFD = new SummedMagFreqDist(2.55, 8.95, 65);
        HashMap<String, SummedMagFreqDist> parentSectSubSeisMFD_Map = new HashMap<String, SummedMagFreqDist>();
        HashMap<String, SummedMagFreqDist> parentSectSupraSeisMFD_Map = new HashMap<String, SummedMagFreqDist>();
        for (int sectIndex = 0; sectIndex < charFactorNumPrimaryArray.length; ++sectIndex) {
            String name = this.rupSet.getFaultSectionData(sectIndex).getParentSectionName();
            if (!parentSectSubSeisMFD_Map.containsKey(name)) {
                parentSectSubSeisMFD_Map.put(name, new SummedMagFreqDist(2.55, 8.95, 65));
            }
            if (parentSectSupraSeisMFD_Map.containsKey(name)) continue;
            parentSectSupraSeisMFD_Map.put(name, new SummedMagFreqDist(2.55, 8.95, 65));
        }
        SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray();
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        for (int sectIndex = 0; sectIndex < charFactorNumPrimaryArray.length; ++sectIndex) {
            charFactorNumPrimaryArray[sectIndex] = Math.log10(1.0 / ETAS_Utils.getScalingFactorToImposeGR_numPrimary(longTermSupraSeisMFD_OnSectArray[sectIndex], longTermSubSeisMFD_OnSectList.get(sectIndex), false));
            charFactorSupraRatesArray[sectIndex] = Math.log10(1.0 / ETAS_Utils.getScalingFactorToImposeGR_supraRates(longTermSupraSeisMFD_OnSectArray[sectIndex], longTermSubSeisMFD_OnSectList.get(sectIndex), false));
            momentRates[sectIndex] = faults.get(sectIndex).calcMomentRate(true);
            logCharFactorNumPrimaryVsLogMomentRate.set(Math.log10(momentRates[sectIndex]), charFactorNumPrimaryArray[sectIndex]);
            logCharFactorSupraSeisVsLogMomentRate.set(Math.log10(momentRates[sectIndex]), charFactorSupraRatesArray[sectIndex]);
            totSubMFD.addIncrementalMagFreqDist(longTermSubSeisMFD_OnSectList.get(sectIndex));
            totSupraMFD.addIncrementalMagFreqDist(longTermSupraSeisMFD_OnSectArray[sectIndex]);
            String name = this.rupSet.getFaultSectionData(sectIndex).getParentSectionName();
            ((SummedMagFreqDist)parentSectSubSeisMFD_Map.get(name)).addIncrementalMagFreqDist(longTermSubSeisMFD_OnSectList.get(sectIndex));
            ((SummedMagFreqDist)parentSectSupraSeisMFD_Map.get(name)).addIncrementalMagFreqDist(longTermSupraSeisMFD_OnSectArray[sectIndex]);
        }
        HistogramFunction histNumPrimary_MoRateWted = new HistogramFunction(-3.0, 3.0, 61);
        HistogramFunction histSupraRates_MoRateWted = new HistogramFunction(-3.0, 3.0, 61);
        HistogramFunction histNumPrimary = new HistogramFunction(-3.0, 3.0, 61);
        HistogramFunction histSupraRates = new HistogramFunction(-3.0, 3.0, 61);
        for (int sectIndex = 0; sectIndex < charFactorNumPrimaryArray.length; ++sectIndex) {
            histNumPrimary_MoRateWted.add(charFactorNumPrimaryArray[sectIndex], momentRates[sectIndex]);
            histSupraRates_MoRateWted.add(charFactorSupraRatesArray[sectIndex], momentRates[sectIndex]);
            histNumPrimary.add(charFactorNumPrimaryArray[sectIndex], 1.0);
            histSupraRates.add(charFactorSupraRatesArray[sectIndex], 1.0);
        }
        histNumPrimary_MoRateWted.normalizeBySumOfY_Vals();
        histNumPrimary_MoRateWted.setName("histNumPrimary_MoRateWted");
        HistogramFunction histNumPrimary_MoRateWtedCum = histNumPrimary_MoRateWted.getCumulativeDistFunctionWithHalfBinOffset();
        histNumPrimary_MoRateWtedCum.setName("histNumPrimary_MoRateWtedCum");
        double median = histNumPrimary_MoRateWtedCum.getFirstInterpolatedX(0.5);
        String info = "mean=" + Math.pow(10.0, histNumPrimary_MoRateWted.computeMean()) + "; mode=" + Math.pow(10.0, histNumPrimary_MoRateWted.getMode()) + "; median=" + Math.pow(10.0, median);
        histNumPrimary_MoRateWted.setInfo(info);
        histNumPrimary_MoRateWtedCum.setInfo(info);
        histSupraRates_MoRateWted.normalizeBySumOfY_Vals();
        histSupraRates_MoRateWted.setName("histSupraRates_MoRateWted");
        HistogramFunction histSupraRates_MoRateWtedCum = histSupraRates_MoRateWted.getCumulativeDistFunctionWithHalfBinOffset();
        histSupraRates_MoRateWtedCum.setName("histSupraRates_MoRateWtedCum");
        median = histSupraRates_MoRateWtedCum.getFirstInterpolatedX(0.5);
        info = "mean=" + Math.pow(10.0, histSupraRates_MoRateWted.computeMean()) + "; mode=" + Math.pow(10.0, histSupraRates_MoRateWted.getMode()) + "; median=" + Math.pow(10.0, median);
        histSupraRates_MoRateWted.setInfo(info);
        histSupraRates_MoRateWtedCum.setInfo(info);
        ArrayList<HistogramFunction> funcs1 = new ArrayList<HistogramFunction>();
        funcs1.add(histNumPrimary_MoRateWted);
        funcs1.add(histNumPrimary_MoRateWtedCum);
        funcs1.add(histSupraRates_MoRateWted);
        funcs1.add(histSupraRates_MoRateWtedCum);
        GraphWindow graph = new GraphWindow(funcs1, "CharFactor Stats MoRate Wted");
        graph.setX_AxisLabel("Log10-CharFactor");
        graph.setY_AxisLabel("Density");
        histNumPrimary.normalizeBySumOfY_Vals();
        histNumPrimary.setName("histNumPrimary");
        HistogramFunction histNumPrimaryCum = histNumPrimary.getCumulativeDistFunctionWithHalfBinOffset();
        histNumPrimaryCum.setName("histNumPrimaryCum");
        median = histNumPrimaryCum.getFirstInterpolatedX(0.5);
        info = "Stats converted our of log space:\ngeom mean=" + Math.pow(10.0, histNumPrimary.computeMean()) + "; mode=" + Math.pow(10.0, histNumPrimary.getMode()) + "; median=" + Math.pow(10.0, median);
        histNumPrimary.setInfo(info);
        histNumPrimaryCum.setInfo(info);
        histSupraRates.normalizeBySumOfY_Vals();
        histSupraRates.setName("histSupraRates");
        HistogramFunction histSupraRatesCum = histSupraRates.getCumulativeDistFunctionWithHalfBinOffset();
        histSupraRatesCum.setName("histSupraRatesCum");
        median = histSupraRatesCum.getFirstInterpolatedX(0.5);
        info = "Stats converted our of log space:\ngeom mean=" + Math.pow(10.0, histSupraRates.computeMean()) + "; mode=" + Math.pow(10.0, histSupraRates.getMode()) + "; median=" + Math.pow(10.0, median);
        histSupraRates.setInfo(info);
        histSupraRatesCum.setInfo(info);
        ArrayList<HistogramFunction> funcs2 = new ArrayList<HistogramFunction>();
        funcs2.add(histNumPrimary);
        funcs2.add(histNumPrimaryCum);
        funcs2.add(histSupraRates);
        funcs2.add(histSupraRatesCum);
        GraphWindow graph4 = new GraphWindow(funcs2, "CharFactor Stats");
        graph4.setX_AxisLabel("Log10-GRcorr");
        graph4.setY_AxisLabel("Density");
        GraphWindow graph2 = new GraphWindow(logCharFactorNumPrimaryVsLogMomentRate, "CharFactor NumPrimary vs MoRate", new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        graph2.setY_AxisLabel("Log10-CharFactor");
        graph2.setX_AxisLabel("Log10(MoRate)");
        GraphWindow graph3 = new GraphWindow(logCharFactorSupraSeisVsLogMomentRate, "CharFactor SupraRates vs MoRate", new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        graph3.setY_AxisLabel("Log10-CharFactor");
        graph3.setX_AxisLabel("Log10(MoRate)");
        IncrementalMagFreqDist tempSubMFD = new IncrementalMagFreqDist(2.55, 8.95, 65);
        IncrementalMagFreqDist tempSupraMFD = new IncrementalMagFreqDist(2.55, 8.95, 65);
        for (int i = 0; i < totSupraMFD.size(); ++i) {
            if (totSupraMFD.getX(i) < 6.3) {
                tempSubMFD.set(i, totSubMFD.getY(i));
                continue;
            }
            tempSupraMFD.set(i, totSupraMFD.getY(i));
        }
        double totCharFactorNumPrimary = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_numPrimary(tempSupraMFD, tempSubMFD, false);
        double totCharFactorNumPrimary2 = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_numPrimary(totSupraMFD, totSubMFD, false);
        double totCharFactorSupraRates = 1.0 / ETAS_Utils.getScalingFactorToImposeGR_supraRates(tempSupraMFD, tempSubMFD, false);
        info = "totCharFactorNumPrimary=" + totCharFactorNumPrimary + "\ntotCharFactorSupraRates=" + totCharFactorSupraRates + "\ntotCharFactorNumPrimary2=" + totCharFactorNumPrimary2;
        double minMag = 2.55;
        double maxMag = totSupraMFD.getMaxMagWithNonZeroRate();
        int numMag = (int)Math.round((maxMag - minMag) / totSupraMFD.getDelta()) + 1;
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(1.0, 1.0, minMag, maxMag, numMag);
        gr.scaleToIncrRate(minMag, totSubMFD.getY(minMag));
        gr.setName("Perfect GR");
        totSubMFD.setInfo(info);
        totSupraMFD.setInfo(info);
        SummedMagFreqDist totalTrulyOffFaultMFD = new SummedMagFreqDist(2.55, 8.95, 65);
        SummedMagFreqDist totalModelMFD = new SummedMagFreqDist(2.55, 8.95, 65);
        for (int src = this.fssERF.getNumFaultSystemSources(); src < this.fssERF.getNumSources(); ++src) {
            if (this.mfdForTrulyOffOnlyArray[src] == null) continue;
            totalTrulyOffFaultMFD.addIncrementalMagFreqDist(this.mfdForTrulyOffOnlyArray[src]);
        }
        totalModelMFD.addIncrementalMagFreqDist(totalTrulyOffFaultMFD);
        totalModelMFD.addIncrementalMagFreqDist(totSubMFD);
        totalModelMFD.addIncrementalMagFreqDist(totSupraMFD);
        totalModelMFD.setName("totalModelMFD");
        totalTrulyOffFaultMFD.setName("totalTrulyOffFaultMFD");
        ArrayList<EvenlyDiscretizedFunc> totalFuncs = new ArrayList<EvenlyDiscretizedFunc>();
        totalFuncs.add(totSubMFD);
        totalFuncs.add(totSupraMFD);
        totalFuncs.add(gr);
        totalFuncs.add(totSubMFD.getCumRateDistWithOffset());
        totalFuncs.add(totSupraMFD.getCumRateDistWithOffset());
        totalFuncs.add(gr.getCumRateDistWithOffset());
        totalFuncs.add(totalModelMFD.getCumRateDistWithOffset());
        GraphWindow totMFD_Graph = new GraphWindow(totalFuncs, "Total MFDs");
        totMFD_Graph.setYLog(true);
        ArbDiscrEmpiricalDistFunc parSectCharFactorDistMoRateWted = new ArbDiscrEmpiricalDistFunc();
        ArbDiscrEmpiricalDistFunc parSectCharFactorDist = new ArbDiscrEmpiricalDistFunc();
        DefaultXY_DataSet parSectCharFactorVsMomentRateData = new DefaultXY_DataSet();
        DefaultXY_DataSet parSectCharFactorVsSupraRateData = new DefaultXY_DataSet();
        System.out.println("name\tcharFactorSurpaRates\tcharFactorNumPrimary");
        for (String name : parentSectSupraSeisMFD_Map.keySet()) {
            double parGRcorrSupraRates = ETAS_Utils.getScalingFactorToImposeGR_supraRates((IncrementalMagFreqDist)parentSectSupraSeisMFD_Map.get(name), (IncrementalMagFreqDist)parentSectSubSeisMFD_Map.get(name), false);
            double parGRcorr = ETAS_Utils.getScalingFactorToImposeGR_numPrimary((IncrementalMagFreqDist)parentSectSupraSeisMFD_Map.get(name), (IncrementalMagFreqDist)parentSectSubSeisMFD_Map.get(name), false);
            double moRate = ((SummedMagFreqDist)parentSectSupraSeisMFD_Map.get(name)).getTotalMomentRate() + ((SummedMagFreqDist)parentSectSubSeisMFD_Map.get(name)).getTotalMomentRate();
            parSectCharFactorDist.set(1.0 / parGRcorrSupraRates, 1.0);
            parSectCharFactorDistMoRateWted.set(1.0 / parGRcorrSupraRates, moRate);
            parSectCharFactorVsMomentRateData.set(moRate, 1.0 / parGRcorrSupraRates);
            double minMagSupra = ETAS_Utils.getMinMagSupra((IncrementalMagFreqDist)parentSectSupraSeisMFD_Map.get(name), (IncrementalMagFreqDist)parentSectSubSeisMFD_Map.get(name));
            parSectCharFactorVsSupraRateData.set(((SummedMagFreqDist)parentSectSupraSeisMFD_Map.get(name)).getCumRate(minMagSupra), 1.0 / parGRcorrSupraRates);
            System.out.println(name + "\t" + 1.0 / parGRcorrSupraRates + "\t" + 1.0 / parGRcorr + "\t" + moRate);
        }
        DiscretizedFunc parSectCharFactorDistMoRateWtedCum = parSectCharFactorDistMoRateWted.getCumDist();
        parSectCharFactorDistMoRateWtedCum.scale(1.0 / parSectCharFactorDistMoRateWted.calcSumOfY_Vals());
        parSectCharFactorDistMoRateWtedCum.setName("parSectCharFactorDistMoRateWtedCum");
        parSectCharFactorDistMoRateWtedCum.setInfo("mean=" + parSectCharFactorDistMoRateWted.getMean() + "; median=" + parSectCharFactorDistMoRateWted.getMedian());
        DiscretizedFunc parSectCharFactorDistCum = parSectCharFactorDist.getCumDist();
        parSectCharFactorDistCum.scale(1.0 / parSectCharFactorDist.calcSumOfY_Vals());
        parSectCharFactorDistCum.setName("parSectCharFactorDistCum");
        parSectCharFactorDistCum.setInfo("mean=" + parSectCharFactorDist.getMean() + "; median=" + parSectCharFactorDist.getMedian());
        ArrayList<DiscretizedFunc> parSectFuncs = new ArrayList<DiscretizedFunc>();
        parSectFuncs.add(parSectCharFactorDistMoRateWtedCum);
        parSectFuncs.add(parSectCharFactorDistCum);
        GraphWindow parSectGraph = new GraphWindow(parSectFuncs, "Parent Sect CharFactor Stats");
        parSectGraph.setX_AxisLabel("CharFactor");
        parSectGraph.setY_AxisLabel("Cumulative Density");
        parSectGraph.setXLog(true);
        parSectGraph.setAxisLabelFontSize(20);
        parSectGraph.setTickLabelFontSize(18);
        parSectGraph.setPlotLabelFontSize(22);
        GraphWindow parSectGrCorrVsMoRateGraph = new GraphWindow(parSectCharFactorVsMomentRateData, "parSectCharFactorVsMomentRateData", new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLACK));
        parSectGrCorrVsMoRateGraph.setY_AxisLabel("Log10(CharFactor)");
        parSectGrCorrVsMoRateGraph.setX_AxisLabel("Log10(Moment Rate (NM/yr))");
        parSectGrCorrVsMoRateGraph.setXLog(true);
        parSectGrCorrVsMoRateGraph.setYLog(true);
        parSectGrCorrVsMoRateGraph.setAxisLabelFontSize(20);
        parSectGrCorrVsMoRateGraph.setTickLabelFontSize(18);
        parSectGrCorrVsMoRateGraph.setPlotLabelFontSize(22);
        GraphWindow parSectGrCorrVsSupraRateGraph = new GraphWindow(parSectCharFactorVsSupraRateData, "parSectCharFactorVsSupraRateData", new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLACK));
        parSectGrCorrVsSupraRateGraph.setY_AxisLabel("CharFactor");
        parSectGrCorrVsSupraRateGraph.setX_AxisLabel("SupraRate");
        parSectGrCorrVsSupraRateGraph.setAxisLabelFontSize(20);
        parSectGrCorrVsSupraRateGraph.setTickLabelFontSize(18);
        parSectGrCorrVsSupraRateGraph.setPlotLabelFontSize(22);
    }

    public String plotPrimayEventOverlap(ETAS_EqkRupture mainshock, double[] relSrcProbs, File resultsDir, int numToCheck, String nameSuffix) {
        Location firstLocOnMainTr = mainshock.getRuptureSurface().getFirstLocOnUpperEdge();
        Location lastLocOnMainTr = mainshock.getRuptureSurface().getLastLocOnUpperEdge();
        double offsetAimuth = LocationUtils.azimuth(firstLocOnMainTr, lastLocOnMainTr) + 90.0;
        String info = "";
        if (this.fssERF != null && mainshock.getFSSIndex() >= 0) {
            int mainShockFSSindex = mainshock.getFSSIndex();
            List<Integer> mainShockSectIndices = this.fssERF.getSolution().getRupSet().getSectionsIndicesForRup(mainShockFSSindex);
            double totFltSrcProb = 0.0;
            double[] fltSrcProbArray = new double[this.numFltSystSources];
            for (int srcIndex = 0; srcIndex < this.numFltSystSources; ++srcIndex) {
                totFltSrcProb += relSrcProbs[srcIndex];
                fltSrcProbArray[srcIndex] = relSrcProbs[srcIndex];
            }
            int[] topValueIndices = ETAS_SimAnalysisTools.getIndicesForHighestValuesInArray(fltSrcProbArray, numToCheck);
            ArrayList<Integer> overlappingSrcIndexList = new ArrayList<Integer>();
            ArrayList<Double> overlappingSrcProbList = new ArrayList<Double>();
            double totRelProb = 0.0;
            int num = 0;
            for (int srcIndex : topValueIndices) {
                int fssIndex = this.fssERF.getFltSysRupIndexForSource(srcIndex);
                List<Integer> srcSectIndicides = this.fssERF.getSolution().getRupSet().getSectionsIndicesForRup(fssIndex);
                ArrayList<Integer> common = new ArrayList<Integer>(srcSectIndicides);
                common.retainAll(mainShockSectIndices);
                int numCommon = common.size();
                double fractCommon2 = (double)numCommon / (double)srcSectIndicides.size();
                if (!(fractCommon2 >= 0.5)) continue;
                overlappingSrcIndexList.add(srcIndex);
                double relProb = fltSrcProbArray[srcIndex] / totFltSrcProb;
                overlappingSrcProbList.add(relProb);
                System.out.println(num + "\t" + relProb + "\t" + (totRelProb += relProb) + "\t" + srcIndex + "\t" + this.erf.getSource(srcIndex).getName());
                ++num;
            }
            System.out.println("totRelProb=\t" + totRelProb);
            ArrayList<LocationList> tracesList = FaultBasedMapGen.getTraces(this.rupSet.getFaultSectionDataList());
            ArrayList<Double> valuesList = new ArrayList<Double>();
            for (int i = 0; i < tracesList.size(); ++i) {
                valuesList.add(1.0E-14);
            }
            int numToInclude = overlappingSrcIndexList.size();
            double maxTotWt = 0.8;
            double totForNumIncluded = 0.0;
            for (int i = 0; i < numToInclude; ++i) {
                int srcIndex = (Integer)overlappingSrcIndexList.get(i);
                double relProb = (Double)overlappingSrcProbList.get(i);
                totForNumIncluded += relProb;
                int fssIndex = this.fssERF.getFltSysRupIndexForSource(srcIndex);
                List<Integer> srcSectIncides = this.fssERF.getSolution().getRupSet().getSectionsIndicesForRup(fssIndex);
                LocationVector vect = new LocationVector(offsetAimuth, (double)(i + 1) * 3.0, 0.0);
                for (int sectID : srcSectIncides) {
                    LocationList trace = tracesList.get(sectID);
                    LocationList movedTrace = new LocationList();
                    for (Location loc : trace) {
                        movedTrace.add(LocationUtils.location(loc, vect));
                    }
                    tracesList.add(movedTrace);
                    valuesList.add(relProb);
                }
                if (totForNumIncluded > maxTotWt) break;
            }
            for (int sect : mainShockSectIndices) {
                tracesList.add(tracesList.get(sect));
                valuesList.add(1.0);
            }
            LocationVector vect = new LocationVector(offsetAimuth, 200.0, 0.0);
            LocationList locList1 = new LocationList();
            locList1.add(firstLocOnMainTr);
            locList1.add(LocationUtils.location(firstLocOnMainTr, vect));
            tracesList.add(locList1);
            valuesList.add(2.0);
            LocationList locList2 = new LocationList();
            locList2.add(lastLocOnMainTr);
            locList2.add(LocationUtils.location(lastLocOnMainTr, vect));
            tracesList.add(locList2);
            valuesList.add(2.0);
            double[] valuesArray = new double[valuesList.size()];
            for (int i = 0; i < valuesList.size(); ++i) {
                valuesArray[i] = (Double)valuesList.get(i);
            }
            CPT cpt = FaultBasedMapGen.getParticipationCPT().rescale(-6.0, -1.0);
            cpt.setBelowMinColor(Color.GRAY);
            cpt.setAboveMaxColor(Color.BLACK);
            double[] values = FaultBasedMapGen.log10(valuesArray);
            String name = "OverlappingSections" + nameSuffix;
            String title = "Log10(relProb); totProb=" + (float)totForNumIncluded;
            try {
                FaultBasedMapGen.makeFaultPlot(cpt, tracesList, values, this.origGriddedRegion, resultsDir, name, true, false, title);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("erf must be instance of FaultSystemSolutionERF");
        }
        return info;
    }

    public String plotPrimayEventsThatTouchParent(ETAS_EqkRupture mainshock, double[] relSrcProbs, File resultsDir, int numToCheck, String nameSuffix) {
        Location firstLocOnMainTr = mainshock.getRuptureSurface().getFirstLocOnUpperEdge();
        Location lastLocOnMainTr = mainshock.getRuptureSurface().getLastLocOnUpperEdge();
        double offsetAimuth = LocationUtils.azimuth(firstLocOnMainTr, lastLocOnMainTr) + 90.0;
        String info = "";
        if (this.fssERF != null && mainshock.getFSSIndex() >= 0) {
            int i;
            int mainShockFSSindex = mainshock.getFSSIndex();
            List<Integer> mainShockSectIndices = this.fssERF.getSolution().getRupSet().getSectionsIndicesForRup(mainShockFSSindex);
            double totFltSrcProb = 0.0;
            double[] fltSrcProbArray = new double[this.numFltSystSources];
            for (int srcIndex = 0; srcIndex < this.numFltSystSources; ++srcIndex) {
                totFltSrcProb += relSrcProbs[srcIndex];
                fltSrcProbArray[srcIndex] = relSrcProbs[srcIndex];
            }
            int[] topValueIndices = ETAS_SimAnalysisTools.getIndicesForHighestValuesInArray(fltSrcProbArray, numToCheck);
            ArrayList<Integer> overlappingSrcIndexList = new ArrayList<Integer>();
            ArrayList<Double> overlappingSrcProbList = new ArrayList<Double>();
            double maxTotProb = 0.5;
            double totCondProb = 0.0;
            int num = 0;
            for (int srcIndex : topValueIndices) {
                int fssIndex = this.fssERF.getFltSysRupIndexForSource(srcIndex);
                List<Integer> srcSectIndicides = this.fssERF.getSolution().getRupSet().getSectionsIndicesForRup(fssIndex);
                ArrayList<Integer> common = new ArrayList<Integer>(srcSectIndicides);
                common.retainAll(mainShockSectIndices);
                int numCommon = common.size();
                if (numCommon > 0) {
                    ++num;
                    overlappingSrcIndexList.add(srcIndex);
                    double condProb = fltSrcProbArray[srcIndex] / totFltSrcProb;
                    overlappingSrcProbList.add(condProb);
                    System.out.println(num + "\t" + condProb + "\t" + (totCondProb += condProb) + "\t" + srcIndex + "\t" + this.erf.getSource(srcIndex).getName());
                }
                if (num > 200) break;
            }
            System.out.println("totCondProb=\t" + totCondProb + "\tnum=" + overlappingSrcIndexList.size());
            ArrayList<LocationList> tracesList = FaultBasedMapGen.getTraces(this.rupSet.getFaultSectionDataList());
            ArrayList<Double> valuesList = new ArrayList<Double>();
            for (i = 0; i < tracesList.size(); ++i) {
                valuesList.add(1.0E-14);
            }
            for (i = 0; i < overlappingSrcIndexList.size(); ++i) {
                int srcIndex;
                srcIndex = (Integer)overlappingSrcIndexList.get(i);
                double relProb = (Double)overlappingSrcProbList.get(i);
                int fssIndex = this.fssERF.getFltSysRupIndexForSource(srcIndex);
                List<Integer> srcSectIncides = this.fssERF.getSolution().getRupSet().getSectionsIndicesForRup(fssIndex);
                LocationVector vect = new LocationVector(offsetAimuth, (double)(i + 1) * 3.0, 0.0);
                for (int sectID : srcSectIncides) {
                    LocationList trace = tracesList.get(sectID);
                    LocationList movedTrace = new LocationList();
                    for (Location loc : trace) {
                        movedTrace.add(LocationUtils.location(loc, vect));
                    }
                    tracesList.add(movedTrace);
                    valuesList.add(relProb);
                }
            }
            for (int sect : mainShockSectIndices) {
                tracesList.add(tracesList.get(sect));
                valuesList.add(1.0);
            }
            LocationVector vect = new LocationVector(offsetAimuth, 200.0, 0.0);
            LocationList locList1 = new LocationList();
            locList1.add(firstLocOnMainTr);
            locList1.add(LocationUtils.location(firstLocOnMainTr, vect));
            tracesList.add(locList1);
            valuesList.add(2.0);
            LocationList locList2 = new LocationList();
            locList2.add(lastLocOnMainTr);
            locList2.add(LocationUtils.location(lastLocOnMainTr, vect));
            tracesList.add(locList2);
            valuesList.add(2.0);
            double[] valuesArray = new double[valuesList.size()];
            for (int i2 = 0; i2 < valuesList.size(); ++i2) {
                valuesArray[i2] = (Double)valuesList.get(i2);
            }
            CPT cpt = FaultBasedMapGen.getParticipationCPT().rescale(-4.5, -0.5);
            cpt.setBelowMinColor(Color.GRAY);
            cpt.setAboveMaxColor(Color.BLACK);
            double[] values = FaultBasedMapGen.log10(valuesArray);
            String name = "PrimayRupsThatTouchParent" + nameSuffix;
            String title = "Log10(relProb); totCondProb=" + (float)totCondProb;
            try {
                FaultBasedMapGen.makeFaultPlot(cpt, tracesList, values, this.origGriddedRegion, resultsDir, name, true, false, title);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("erf must be instance of FaultSystemSolutionERF");
        }
        return info;
    }

    public String plotMostLikelyTriggeredFSS_Ruptures(ETAS_EqkRupture mainshock, double[] relSrcProbs, File resultsDir, int numToCheck, String nameSuffix) {
        double offsetAimuth;
        Location lastLocOnMainTr;
        Location firstLocOnMainTr;
        List<Integer> mainShockSectIndices = null;
        if (mainshock.getFSSIndex() >= 0) {
            mainShockSectIndices = this.fssERF.getSolution().getRupSet().getSectionsIndicesForRup(mainshock.getFSSIndex());
            firstLocOnMainTr = mainshock.getRuptureSurface().getFirstLocOnUpperEdge();
            lastLocOnMainTr = mainshock.getRuptureSurface().getLastLocOnUpperEdge();
            offsetAimuth = LocationUtils.azimuth(firstLocOnMainTr, lastLocOnMainTr) + 90.0;
        } else {
            Location loc = mainshock.getRuptureSurface().getFirstLocOnUpperEdge();
            double minDist = 100000.0;
            int sectIndex = -1;
            for (FaultSection faultSection : this.rupSet.getFaultSectionDataList()) {
                double dist = LocationUtils.distanceToSurfFast(loc, faultSection.getFaultSurface(1.0, false, true));
                if (!(dist < minDist)) continue;
                minDist = dist;
                sectIndex = faultSection.getSectionId();
            }
            RuptureSurface surf = this.rupSet.getFaultSectionData(sectIndex).getFaultSurface(1.0, false, true);
            firstLocOnMainTr = surf.getFirstLocOnUpperEdge();
            lastLocOnMainTr = surf.getLastLocOnUpperEdge();
            offsetAimuth = LocationUtils.azimuth(firstLocOnMainTr, lastLocOnMainTr) + 90.0;
        }
        String info = "";
        if (this.fssERF != null) {
            double totFltSrcProb = 0.0;
            double[] fltSrcProbArray = new double[this.numFltSystSources];
            for (int srcIndex = 0; srcIndex < this.numFltSystSources; ++srcIndex) {
                totFltSrcProb += relSrcProbs[srcIndex];
                fltSrcProbArray[srcIndex] = relSrcProbs[srcIndex];
            }
            int[] topValueIndices = ETAS_SimAnalysisTools.getIndicesForHighestValuesInArray(fltSrcProbArray, numToCheck);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Double> overlappingSrcProbList = new ArrayList<Double>();
            int num = 0;
            for (int srcIndex : topValueIndices) {
                arrayList.add(srcIndex);
                double condProb = fltSrcProbArray[srcIndex] / totFltSrcProb;
                overlappingSrcProbList.add(condProb);
                System.out.println(num + "\t" + condProb + "\t" + srcIndex + "\t" + this.erf.getSource(srcIndex).getName());
                ++num;
            }
            ArrayList<LocationList> tracesList = FaultBasedMapGen.getTraces(this.rupSet.getFaultSectionDataList());
            ArrayList<Double> valuesList = new ArrayList<Double>();
            for (int i = 0; i < tracesList.size(); ++i) {
                valuesList.add(1.0E-14);
            }
            int numToInclude = arrayList.size();
            double maxTotWt = 1.01;
            double totCondProbForThoseIncluded = 0.0;
            for (int i = 0; i < numToInclude; ++i) {
                int srcIndex = (Integer)arrayList.get(i);
                double condProb = (Double)overlappingSrcProbList.get(i);
                totCondProbForThoseIncluded += condProb;
                int fssIndex = this.fssERF.getFltSysRupIndexForSource(srcIndex);
                List<Integer> srcSectIncides = this.fssERF.getSolution().getRupSet().getSectionsIndicesForRup(fssIndex);
                LocationVector vect = new LocationVector(offsetAimuth, (double)(i + 1) * 3.5, 0.0);
                for (int sectID : srcSectIncides) {
                    LocationList trace = tracesList.get(sectID);
                    LocationList movedTrace = new LocationList();
                    for (Location loc : trace) {
                        movedTrace.add(LocationUtils.location(loc, vect));
                    }
                    tracesList.add(movedTrace);
                    valuesList.add(condProb);
                }
                if (totCondProbForThoseIncluded > maxTotWt) break;
            }
            if (mainShockSectIndices != null) {
                for (int sect : mainShockSectIndices) {
                    tracesList.add(tracesList.get(sect));
                    valuesList.add(2.0);
                }
            }
            LocationVector vect = new LocationVector(offsetAimuth, 200.0, 0.0);
            LocationList locList1 = new LocationList();
            locList1.add(firstLocOnMainTr);
            locList1.add(LocationUtils.location(firstLocOnMainTr, vect));
            tracesList.add(locList1);
            valuesList.add(2.0);
            LocationList locList2 = new LocationList();
            locList2.add(lastLocOnMainTr);
            locList2.add(LocationUtils.location(lastLocOnMainTr, vect));
            tracesList.add(locList2);
            valuesList.add(2.0);
            double[] valuesArray = new double[valuesList.size()];
            for (int i = 0; i < valuesList.size(); ++i) {
                valuesArray[i] = (Double)valuesList.get(i);
            }
            CPT cpt = FaultBasedMapGen.getParticipationCPT().rescale(-4.0, 0.0);
            cpt.setBelowMinColor(Color.GRAY);
            cpt.setAboveMaxColor(Color.BLACK);
            double[] values = FaultBasedMapGen.log10(valuesArray);
            String name = "MostLikelyFSS_Rups" + nameSuffix;
            String title = "Log10(relProb); totProb=" + (float)totCondProbForThoseIncluded;
            try {
                FaultBasedMapGen.makeFaultPlot(cpt, tracesList, values, this.origGriddedRegion, resultsDir, name, true, false, title);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("erf must be instance of FaultSystemSolutionERF");
        }
        return info;
    }

    public String plotSubSectParticipationProbGivenRuptureAndReturnInfo(ETAS_EqkRupture mainshock, double[] relSrcProbs, File resultsDir, int numToList, String nameSuffix, double expNum, boolean isPoisson) {
        Object info = "";
        if (this.erf instanceof FaultSystemSolutionERF) {
            int[] topValueIndices;
            int i;
            String title;
            String name;
            int i2;
            double[] sectProbArray = new double[this.rupSet.getNumSections()];
            for (int srcIndex = 0; srcIndex < this.numFltSystSources; ++srcIndex) {
                int fltSysIndex = this.fssERF.getFltSysRupIndexForSource(srcIndex);
                for (Integer sectIndex : this.rupSet.getSectionsIndicesForRup(fltSysIndex)) {
                    int n = sectIndex;
                    sectProbArray[n] = sectProbArray[n] + relSrcProbs[srcIndex];
                }
            }
            if (isPoisson) {
                i2 = 0;
                while (i2 < sectProbArray.length) {
                    int n = i2++;
                    sectProbArray[n] = sectProbArray[n] * expNum;
                }
                name = "SectParticipationExpNumPrimary" + nameSuffix;
                title = "Log10(SectPartExpNumPrimary)";
            } else {
                for (i2 = 0; i2 < sectProbArray.length; ++i2) {
                    sectProbArray[i2] = 1.0 - Math.pow(1.0 - sectProbArray[i2], expNum);
                }
                name = "SectParticipationProbOneOrMorePrimary" + nameSuffix;
                title = "Log10(SectPartProbOneOrMorePrimary)";
            }
            CPT cpt = FaultBasedMapGen.getParticipationCPT().rescale(-5.0, 0.0);
            List<? extends FaultSection> faults = this.rupSet.getFaultSectionDataList();
            double[] values = FaultBasedMapGen.log10(sectProbArray);
            try {
                FileWriter fr = new FileWriter(new File(resultsDir, name + ".txt"));
                for (int s = 0; s < sectProbArray.length; ++s) {
                    fr.write(s + "\t" + (float)sectProbArray[s] + "\t" + faults.get(s).getName() + "\n");
                }
                fr.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                FaultBasedMapGen.makeFaultPlot(cpt, FaultBasedMapGen.getTraces(faults), values, this.origGriddedRegion, resultsDir, name, true, false, title);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (mainshock.getFSSIndex() >= 0 && this.erf instanceof FaultSystemSolutionERF) {
                info = (String)info + "\nProbability of sampling the rupture again:\n";
                int srcIndex = ((FaultSystemSolutionERF)this.erf).getSrcIndexForFltSysRup(mainshock.getFSSIndex());
                info = (String)info + "\n\t" + relSrcProbs[srcIndex] + "\t" + srcIndex + "\t" + this.erf.getSource(srcIndex).getName() + "\n";
            }
            double[] fltSrcProbs = new double[this.numFltSystSources];
            double totProb = 0.0;
            if (isPoisson) {
                for (i = 0; i < fltSrcProbs.length; ++i) {
                    fltSrcProbs[i] = relSrcProbs[i] * expNum;
                    totProb += fltSrcProbs[i];
                }
                info = (String)info + "\nScenario is most likely to trigger the following fault-based sources (expNum, relExpNum, srcIndex, mag, name):\n\n";
            } else {
                for (i = 0; i < fltSrcProbs.length; ++i) {
                    fltSrcProbs[i] = 1.0 - Math.pow(1.0 - relSrcProbs[i], expNum);
                    totProb += fltSrcProbs[i];
                }
                info = (String)info + "\nScenario is most likely to trigger the following fault-based sources (prob, relProb, srcIndex, mag, name):\n\n";
            }
            for (int srcIndex : topValueIndices = ETAS_SimAnalysisTools.getIndicesForHighestValuesInArray(fltSrcProbs, numToList)) {
                info = (String)info + "\t" + fltSrcProbs[srcIndex] + "\t" + fltSrcProbs[srcIndex] / totProb + "\t" + srcIndex + "\t" + this.erf.getSource(srcIndex).getRupture(0).getMag() + "\t" + this.erf.getSource(srcIndex).getName() + "\n";
            }
            topValueIndices = ETAS_SimAnalysisTools.getIndicesForHighestValuesInArray(sectProbArray, numToList);
            info = (String)info + "\nThe following sections are most likely to participate in a triggered event:\n\n";
            List<? extends FaultSection> fltDataList = this.fssERF.getSolution().getRupSet().getFaultSectionDataList();
            for (int sectIndex : topValueIndices) {
                info = (String)info + "\t" + sectProbArray[sectIndex] + "\t" + sectIndex + "\t" + fltDataList.get(sectIndex).getName() + "\n";
            }
        } else {
            throw new RuntimeException("erf must be instance of FaultSystemSolutionERF");
        }
        return info;
    }

    public boolean setRandomPrimaryEvent(ETAS_EqkRupture rupToFillIn, double maxPointSourceMag) {
        int randSrcIndex;
        ETAS_EqkRupture parRup = rupToFillIn.getParentRup();
        Location actualParentLoc = rupToFillIn.getParentTriggerLoc();
        int parRegIndex = this.gridRegForParentLocs.indexForLocation(actualParentLoc);
        if (parRegIndex < 0) {
            if (D) {
                System.out.print("Warning: parent location outside of region; parRegIndex=" + parRegIndex + "; parentLoc=" + actualParentLoc.toString() + "; Num pts on main shock surface: " + parRup.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface().size());
                if (parRup instanceof ETAS_EqkRupture) {
                    System.out.println("; Problem event generation: " + parRup.getGeneration());
                } else {
                    System.out.println(" ");
                }
            }
            return false;
        }
        int parLocIndex = this.getParLocIndexForLocation(actualParentLoc);
        Location translatedParLoc = this.getParLocationForIndex(parLocIndex);
        int aftShCubeIndex = -1;
        if (this.includeERF_Rates) {
            aftShCubeIndex = rupToFillIn.getCubeIndex();
            if (aftShCubeIndex == -1) {
                IntegerPDF_FunctionSampler sampler = this.getCubeSampler(parLocIndex);
                for (ETAS_EqkRupture tempRup : this.eventListForParLocIndexMap.get(parLocIndex)) {
                    tempRup.setCubeIndex(sampler.getRandomInt(this.etas_utils.getRandomDouble()));
                }
                this.eventListForParLocIndexMap.remove(parLocIndex);
                aftShCubeIndex = rupToFillIn.getCubeIndex();
                if (aftShCubeIndex == -1) {
                    throw new RuntimeException("Problem Here");
                }
            }
        } else {
            Location cubeLoc;
            Location relativeLoc = this.locWeightCalc.getRandomLoc(translatedParLoc.getDepth(), this.etas_utils);
            double latSign = 1.0;
            double lonSign = 1.0;
            if (this.etas_utils.getRandomDouble() < 0.5) {
                latSign = -1.0;
            }
            if (this.etas_utils.getRandomDouble() < 0.5) {
                lonSign = -1.0;
            }
            if ((aftShCubeIndex = this.getCubeIndexForLocation(cubeLoc = new Location(relativeLoc.getLatitude() * latSign + translatedParLoc.getLatitude(), relativeLoc.getLongitude() * lonSign + translatedParLoc.getLongitude(), relativeLoc.getDepth()))) == -1) {
                return false;
            }
            int griddeSeisRegionIndex = this.origGriddedRegion.indexForLocation(this.getCubeLocationForIndex(aftShCubeIndex));
            if (griddeSeisRegionIndex == -1) {
                return false;
            }
        }
        double fractionSupra = 0.0;
        if (this.totalSectRateInCubeArray[aftShCubeIndex] > 0.0) {
            fractionSupra = this.getERT_MinFracSupra(rupToFillIn.getParentRup(), this.getCubeLocationForIndex(aftShCubeIndex));
        }
        if ((randSrcIndex = this.getRandomSourceIndexInCube(aftShCubeIndex, fractionSupra)) < this.numFltSystSources) {
            ProbEqkSource src = this.erf.getSource(randSrcIndex);
            int r = 0;
            if (src.getNumRuptures() > 1) {
                r = src.drawSingleRandomEqkRuptureIndexFromRelativeRates(this.etas_utils.getRandomDouble());
            }
            int nthRup = this.erf.getIndexN_ForSrcAndRupIndices(randSrcIndex, r);
            ProbEqkRupture erf_rup = src.getRupture(r);
            rupToFillIn.setHypocenterLocation(this.getCubeLocationForIndex(aftShCubeIndex));
            rupToFillIn.setRuptureSurface(erf_rup.getRuptureSurface());
            rupToFillIn.setFSSIndex(((FaultSystemSolutionERF)this.erf).getFltSysRupIndexForNthRup(nthRup));
            rupToFillIn.setAveRake(erf_rup.getAveRake());
            rupToFillIn.setMag(erf_rup.getMag());
            rupToFillIn.setNthERF_Index(nthRup);
        } else {
            Location tempLoc;
            int randRupIndex;
            int gridRegionIndex = randSrcIndex - this.numFltSystSources;
            ProbEqkSource src = this.erf.getSource(randSrcIndex);
            if (src.getNumRuptures() == 1) {
                randRupIndex = 0;
            } else {
                Preconditions.checkState((src.getNumRuptures() > 1 ? 1 : 0) != 0);
                if (this.origGridSeisTrulyOffVsSubSeisStatus[gridRegionIndex] == 2) {
                    int[] regAndDepIndex = this.getCubeRegAndDepIndicesForIndex(aftShCubeIndex);
                    int isSubSeismo = this.isCubeInsideFaultPolygon[regAndDepIndex[0]];
                    MFDGridSourceProvider gridProv = ((FaultSystemSolutionERF)this.erf).getSolution().requireModule(MFDGridSourceProvider.class);
                    ProbEqkSource filteredSrc = isSubSeismo == 1 ? gridProv.getSourceSubSeisOnFault(gridRegionIndex, this.erf.getTimeSpan().getDuration(), null, FaultSystemSolutionERF_ETAS.GRID_SEIS_SETTINGS) : gridProv.getSourceUnassociated(gridRegionIndex, this.erf.getTimeSpan().getDuration(), null, FaultSystemSolutionERF_ETAS.GRID_SEIS_SETTINGS);
                    int filteredR = filteredSrc.drawSingleRandomEqkRuptureIndex(this.etas_utils.getRandomDouble());
                    ProbEqkRupture filteredRup = filteredSrc.getRupture(filteredR);
                    randRupIndex = -1;
                    boolean footwall = ETAS_PrimaryEventSampler.ptRupFootwallTest(filteredRup);
                    for (int r = 0; r < src.getNumRuptures(); ++r) {
                        boolean match;
                        ProbEqkRupture rup = src.getRupture(r);
                        boolean bl = match = Precision.equals((double)rup.getAveRake(), (double)filteredRup.getAveRake()) && Precision.equals((double)rup.getMag(), (double)filteredRup.getMag()) && footwall == ETAS_PrimaryEventSampler.ptRupFootwallTest(rup);
                        if (!match) continue;
                        Preconditions.checkState((randRupIndex < 0 ? 1 : 0) != 0, (String)"Multiple rupture mappings? sourceID=%s, subSeismo=%s,filteredR=%s, mag=%s, rake=%s, sourceType=%s, surfType=%s", (Object[])new Object[]{randSrcIndex, isSubSeismo, filteredR, filteredRup.getMag(), filteredRup.getAveRake(), filteredSrc.getClass().getName(), filteredRup.getRuptureSurface().getClass().getName()});
                        randRupIndex = r;
                    }
                    Preconditions.checkState((randRupIndex >= 0 ? 1 : 0) != 0, (String)"No rupture mapping found sourceID=%s, subSeismo=%s,filteredR=%s, mag=%s, rake=%s, sourceType=%s, surfType=%s", (Object[])new Object[]{randSrcIndex, isSubSeismo, filteredR, filteredRup.getMag(), filteredRup.getAveRake(), filteredSrc.getClass().getName(), filteredRup.getRuptureSurface().getClass().getName()});
                } else {
                    randRupIndex = src.drawSingleRandomEqkRuptureIndexFromRelativeRates(this.etas_utils.getRandomDouble());
                }
            }
            int nthRup = this.erf.getIndexN_ForSrcAndRupIndices(randSrcIndex, randRupIndex);
            ProbEqkRupture erf_rup = src.getRupture(randRupIndex);
            double relLat = this.latForCubeCenter[aftShCubeIndex] - translatedParLoc.getLatitude();
            double relLon = this.lonForCubeCenter[aftShCubeIndex] - translatedParLoc.getLongitude();
            double relDep = this.depthForCubeCenter[aftShCubeIndex] - translatedParLoc.getDepth();
            rupToFillIn.setGridNodeIndex(randSrcIndex - this.numFltSystSources);
            Location deltaLoc = this.locWeightCalc.getRandomDeltaLoc(Math.abs(relLat), Math.abs(relLon), this.depthForCubeCenter[aftShCubeIndex], translatedParLoc.getDepth(), this.etas_utils);
            double newLat = relLat < 0.0 ? this.latForCubeCenter[aftShCubeIndex] - deltaLoc.getLatitude() : this.latForCubeCenter[aftShCubeIndex] + deltaLoc.getLatitude();
            double newLon = relLon < 0.0 ? this.lonForCubeCenter[aftShCubeIndex] - deltaLoc.getLongitude() : this.lonForCubeCenter[aftShCubeIndex] + deltaLoc.getLongitude();
            double newDep = this.depthForCubeCenter[aftShCubeIndex] + deltaLoc.getDepth();
            Location randLoc = new Location(newLat, newLon, newDep);
            LocationVector corrVector = LocationUtils.vector(translatedParLoc, actualParentLoc);
            Location hypLoc = LocationUtils.location(randLoc, corrVector);
            if (hypLoc.getDepth() <= 0.0) {
                hypLoc = tempLoc = new Location(hypLoc.getLatitude(), hypLoc.getLongitude(), 1.0E-4);
            }
            if (hypLoc.getDepth() > this.maxDepth) {
                hypLoc = tempLoc = new Location(hypLoc.getLatitude(), hypLoc.getLongitude(), this.maxDepth - 1.0E-4);
            }
            if (this.erf instanceof FaultSystemSolutionERF) {
                int gridSrcIndex = randSrcIndex - this.numFltSystSources;
                Location gridSrcLoc = this.fssERF.getSolution().getGridSourceProvider().getGriddedRegion().getLocation(gridSrcIndex);
                int testIndex = this.fssERF.getSolution().getGridSourceProvider().getGriddedRegion().indexForLocation(hypLoc);
                if (testIndex != gridSrcIndex) {
                    if (testIndex == -1) {
                        return false;
                    }
                    IncrementalMagFreqDist mfd = this.fssERF.getSolution().getGridSourceProvider().getMFD(testIndex);
                    int maxMagIndex = mfd.getClosestXIndex(mfd.getMaxMagWithNonZeroRate());
                    int magIndex = mfd.getClosestXIndex(erf_rup.getMag());
                    double tempLat = hypLoc.getLatitude();
                    double tempLon = hypLoc.getLongitude();
                    double tempDepth = hypLoc.getDepth();
                    double halfGrid = this.pointSrcDiscr / 2.0;
                    if (maxMagIndex < magIndex) {
                        if (hypLoc.getLatitude() - gridSrcLoc.getLatitude() >= halfGrid) {
                            tempLat = gridSrcLoc.getLatitude() + halfGrid * 0.99;
                        } else if (hypLoc.getLatitude() - gridSrcLoc.getLatitude() <= -halfGrid) {
                            tempLat = gridSrcLoc.getLatitude() - halfGrid * 0.99;
                        }
                        if (hypLoc.getLongitude() - gridSrcLoc.getLongitude() >= halfGrid) {
                            tempLon = gridSrcLoc.getLongitude() + halfGrid * 0.99;
                        } else if (hypLoc.getLongitude() - gridSrcLoc.getLongitude() <= -halfGrid) {
                            tempLon = gridSrcLoc.getLongitude() - halfGrid * 0.99;
                        }
                        hypLoc = new Location(tempLat, tempLon, tempDepth);
                        int testIndex2 = this.fssERF.getSolution().getGridSourceProvider().getGriddedRegion().indexForLocation(hypLoc);
                        if (testIndex2 != gridSrcIndex) {
                            throw new RuntimeException("grid problem");
                        }
                    }
                }
            }
            if (erf_rup.getMag() < maxPointSourceMag) {
                rupToFillIn.setPointSurface(hypLoc);
            } else {
                double aveDip = erf_rup.getRuptureSurface().getAveDip();
                rupToFillIn.setRuptureSurface(this.etas_utils.getRandomFiniteRupSurface(erf_rup.getMag(), hypLoc, aveDip));
            }
            rupToFillIn.setHypocenterLocation(hypLoc);
            rupToFillIn.setAveRake(erf_rup.getAveRake());
            rupToFillIn.setMag(erf_rup.getMag());
            rupToFillIn.setNthERF_Index(nthRup);
        }
        double distToParent = LocationUtils.linearDistanceFast(actualParentLoc, rupToFillIn.getHypocenterLocation());
        rupToFillIn.setDistanceToParent(distToParent);
        return true;
    }

    private static boolean ptRupFootwallTest(ProbEqkRupture rup) {
        RuptureSurface surf = rup.getRuptureSurface();
        if (surf.getAveDip() == 90.0) {
            return false;
        }
        if (surf instanceof FiniteApproxPointSurface) {
            return ((FiniteApproxPointSurface)surf).isOnFootwall();
        }
        return surf.getDistanceX(ptStrFootwallTestLoc) < 0.0;
    }

    public Location getRandomFuzzyLocation(Location loc) {
        double sign1 = 1.0;
        double sign2 = 1.0;
        if (this.etas_utils.getRandomDouble() < 0.5) {
            sign1 = -1.0;
        }
        if (this.etas_utils.getRandomDouble() < 0.5) {
            sign2 = -1.0;
        }
        double lat = loc.getLatitude() + sign1 * 0.005;
        double lon = loc.getLongitude() + sign2 * 0.005;
        return new Location(lat, lon, loc.getDepth());
    }

    private IntegerPDF_FunctionSampler getCubeSampler(int locIndexForPar) {
        if (this.includeERF_Rates && this.includeSpatialDecay) {
            return this.getCubeSamplerWithDistDecay(locIndexForPar);
        }
        if (this.includeERF_Rates && !this.includeSpatialDecay) {
            return this.getCubeSamplerWithERF_GriddedRatesOnly();
        }
        if (!this.includeERF_Rates && this.includeSpatialDecay) {
            return this.getCubeSamplerWithOnlyDistDecay(locIndexForPar);
        }
        throw new IllegalStateException("include ERF rates and include spatial decay both false?");
    }

    public void declareRateChange() {
        if (D) {
            ETAS_SimAnalysisTools.writeMemoryUse("Memory before discarding chached Samplers");
        }
        this.computeSectNucleationRates();
        this.computeTotSectRateInCubesArray();
        if (this.mfdForSrcArray != null) {
            for (int s = 0; s < this.numFltSystSources; ++s) {
                this.mfdForSrcArray[s] = ERF_Calculator.getTotalMFD_ForSource(this.erf.getSource(s), this.erf.getTimeSpan().getDuration(), 5.05, 8.95, 40, true);
            }
        }
        if (D) {
            System.gc();
        }
        if (D) {
            ETAS_SimAnalysisTools.writeMemoryUse("Memory after discarding chached Samplers");
        }
    }

    private synchronized IntegerPDF_FunctionSampler getCubeSamplerWithERF_GriddedRatesOnly() {
        if (this.cubeSamplerGriddedRatesOnly == null) {
            this.cubeSamplerGriddedRatesOnly = new IntegerPDF_FunctionSampler(this.numCubes);
            for (int i = 0; i < this.numCubes; ++i) {
                double gridSrcRate = this.getGridSourcRateInCube(i, false);
                this.cubeSamplerGriddedRatesOnly.set(i, gridSrcRate);
            }
        }
        return this.cubeSamplerGriddedRatesOnly;
    }

    private IntegerPDF_FunctionSampler getCubeSamplerWithDistDecay(int parLocIndex) {
        Location parLoc = this.getParLocationForIndex(parLocIndex);
        this.getCubeSamplerWithERF_GriddedRatesOnly();
        IntegerPDF_FunctionSampler sampler = new IntegerPDF_FunctionSampler(this.numCubeDepths * this.numCubesPerDepth);
        for (int index = 0; index < this.numCubes; ++index) {
            double relLat = Math.abs(parLoc.getLatitude() - this.latForCubeCenter[index]);
            double relLon = Math.abs(parLoc.getLongitude() - this.lonForCubeCenter[index]);
            sampler.set(index, this.locWeightCalc.getProbAtPoint(relLat, relLon, this.depthForCubeCenter[index], parLoc.getDepth()) * this.cubeSamplerGriddedRatesOnly.getY(index));
        }
        return sampler;
    }

    private IntegerPDF_FunctionSampler getCubeSamplerWithOnlyDistDecay(int parLocIndex) {
        Location parLoc = this.getParLocationForIndex(parLocIndex);
        IntegerPDF_FunctionSampler sampler = new IntegerPDF_FunctionSampler(this.numCubes);
        for (int index = 0; index < this.numCubes; ++index) {
            double relLat = Math.abs(parLoc.getLatitude() - this.latForCubeCenter[index]);
            double relLon = Math.abs(parLoc.getLongitude() - this.lonForCubeCenter[index]);
            sampler.set(index, this.locWeightCalc.getProbAtPoint(relLat, relLon, this.depthForCubeCenter[index], parLoc.getDepth()));
        }
        return sampler;
    }

    public double getGridSourcRateInCube(int cubeIndex, boolean debug) {
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        int griddeSeisRegionIndex = this.origGriddedRegion.indexForLocation(this.getCubeLocationForIndex(cubeIndex));
        if (griddeSeisRegionIndex != -1) {
            int cubeRegIndex = this.getCubeRegAndDepIndicesForIndex(cubeIndex)[0];
            if (this.isCubeInsideFaultPolygon[cubeRegIndex] == 1) {
                int[] sectInCubeArray = this.sectInCubeList.get(cubeIndex);
                double totCubeRate = 0.0;
                for (int i = 0; i < sectInCubeArray.length; ++i) {
                    int sectID = sectInCubeArray[i];
                    double cubeRate = longTermSubSeisMFD_OnSectList.get(sectID).getCumRate(2.55) / (double)this.numCubesInsideFaultPolygonArray[sectID];
                    totCubeRate += cubeRate;
                    if (!debug) continue;
                    System.out.println(cubeRate + "\t" + longTermSubSeisMFD_OnSectList.get(sectID).getCumRate(2.55) + "\t" + (double)this.numCubesInsideFaultPolygonArray[sectID] + "\t" + sectID + "\t" + this.rupSet.getFaultSectionData(sectID).getName() + "\t" + cubeIndex + "\t" + String.valueOf(this.getCubeLocationForIndex(cubeIndex)));
                }
                return totCubeRate;
            }
            double rateTrulyOff = this.mfdForTrulyOffOnlyArray[this.numFltSystSources + griddeSeisRegionIndex].getTotalIncrRate();
            double origGridCellRate = rateTrulyOff / (1.0 - this.faultPolyMgr.getNodeFraction(griddeSeisRegionIndex));
            double rate = origGridCellRate / (double)(this.numPtSrcSubPts * this.numPtSrcSubPts * this.numCubeDepths);
            return rate;
        }
        return 0.0;
    }

    public int getRandomSourceIndexInCube_OLD(int cubeIndex) {
        int griddeSeisRegionIndex = this.origGriddedRegion.indexForLocation(this.getCubeLocationForIndex(cubeIndex));
        if (griddeSeisRegionIndex == -1) {
            throw new RuntimeException("No gridded source index for cube at: " + this.getCubeLocationForIndex(cubeIndex).toString());
        }
        int gridSrcIndex = this.numFltSystSources + griddeSeisRegionIndex;
        int[] sectInCubeArray = this.sectInCubeList.get(cubeIndex);
        if (sectInCubeArray.length == 0) {
            return gridSrcIndex;
        }
        IntegerPDF_FunctionSampler sampler = new IntegerPDF_FunctionSampler(sectInCubeArray.length + 1);
        double gridSrcRate = this.sourceRates[gridSrcIndex] / (double)(this.numPtSrcSubPts * this.numPtSrcSubPts * this.numCubeDepths);
        sampler.set(0, gridSrcRate);
        float[] fracts = this.fractionSectInCubeList.get(cubeIndex);
        for (int s = 0; s < sectInCubeArray.length; ++s) {
            sampler.set(s + 1, this.totSectNuclRateArray[sectInCubeArray[s]] * (double)fracts[s]);
        }
        int randSampleIndex = sampler.getRandomInt(this.etas_utils.getRandomDouble());
        if (randSampleIndex == 0) {
            return gridSrcIndex;
        }
        int sectIndex = sectInCubeArray[randSampleIndex - 1];
        IntegerPDF_FunctionSampler srcSampler = this.srcNuclRateOnSects[sectIndex].buildSampler();
        int index = srcSampler.getRandomInt(this.etas_utils.getRandomDouble());
        return this.srcNuclRateOnSects[sectIndex].getSourceIndex(index);
    }

    public int getRandomSourceIndexInCube(int cubeIndex, double fractionSupra) {
        int griddeSeisRegionIndex = this.origGriddedRegion.indexForLocation(this.getCubeLocationForIndex(cubeIndex));
        if (griddeSeisRegionIndex == -1) {
            throw new RuntimeException("No gridded source index for cube at: " + this.getCubeLocationForIndex(cubeIndex).toString());
        }
        int gridSrcIndex = this.numFltSystSources + griddeSeisRegionIndex;
        if (this.totalSectRateInCubeArray[cubeIndex] < 1.0E-15 || fractionSupra == 0.0) {
            return gridSrcIndex;
        }
        double gridSrcRate = this.cubeSamplerGriddedRatesOnly.getY(cubeIndex);
        double fractTest = gridSrcRate / (gridSrcRate + fractionSupra * this.totalSectRateInCubeArray[cubeIndex]);
        if (this.etas_utils.getRandomDouble() < fractTest) {
            return gridSrcIndex;
        }
        int[] sectInCubeArray = this.sectInCubeList.get(cubeIndex);
        float[] fracts = this.fractionSectInCubeList.get(cubeIndex);
        IntegerPDF_FunctionSampler sectSampler = new IntegerPDF_FunctionSampler(sectInCubeArray.length);
        for (int s = 0; s < sectInCubeArray.length; ++s) {
            sectSampler.set(s, this.totSectNuclRateArray[sectInCubeArray[s]] * (double)fracts[s]);
        }
        int randSectIndex = sectSampler.getRandomInt(this.etas_utils.getRandomDouble());
        int sectIndex = sectInCubeArray[randSectIndex];
        int index = this.srcNuclRateOnSects[sectIndex].buildSampler().getRandomInt(this.etas_utils.getRandomDouble());
        return this.srcNuclRateOnSects[sectIndex].getSourceIndex(index);
    }

    private void computeGR_CorrFactorsForSections() {
        this.grCorrFactorForSectArray = new double[this.rupSet.getNumSections()];
        this.charFactorForSectArray = new double[this.rupSet.getNumSections()];
        SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray();
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        double minCorr = Double.MAX_VALUE;
        int minCorrIndex = -1;
        for (int sectIndex = 0; sectIndex < this.grCorrFactorForSectArray.length; ++sectIndex) {
            if (longTermSupraSeisMFD_OnSectArray[sectIndex] != null) {
                if (Double.isNaN(longTermSupraSeisMFD_OnSectArray[sectIndex].getMaxMagWithNonZeroRate()) && D) {
                    System.out.println("NaN HERE: " + this.fssERF.getSolution().getRupSet().getFaultSectionData(sectIndex).getName());
                }
                double val = ETAS_Utils.getScalingFactorToImposeGR_supraRates(longTermSupraSeisMFD_OnSectArray[sectIndex], longTermSubSeisMFD_OnSectList.get(sectIndex), false);
                this.charFactorForSectArray[sectIndex] = 1.0 / val;
                this.grCorrFactorForSectArray[sectIndex] = this.applyGR_Corr ? val : (this.charFactorForSectArray[sectIndex] > 1.0E10 ? 1.0E10 / this.charFactorForSectArray[sectIndex] : 1.0);
                if (!(val < minCorr)) continue;
                minCorr = val;
                minCorrIndex = sectIndex;
                continue;
            }
            this.grCorrFactorForSectArray[sectIndex] = 1.0;
        }
        if (D) {
            System.out.println("min GR Corr (" + minCorr + ") at sect index: " + minCorrIndex + "\t" + this.fssERF.getSolution().getRupSet().getFaultSectionData(minCorrIndex).getName());
        }
    }

    private int[] getCubeRegAndDepIndicesForIndex(int cubeIndex) {
        int[] indices = new int[2];
        indices[1] = (int)Math.floor((double)cubeIndex / (double)this.numCubesPerDepth);
        if (indices[1] >= this.numCubeDepths) {
            System.out.println("PROBLEM: " + cubeIndex + "\t" + this.numCubesPerDepth + "\t" + indices[1] + "\t" + this.numCubeDepths);
        }
        indices[0] = cubeIndex - indices[1] * this.numCubesPerDepth;
        return indices;
    }

    public Location getCubeLocationForIndex(int cubeIndex) {
        int[] regAndDepIndex = this.getCubeRegAndDepIndicesForIndex(cubeIndex);
        Location regLoc = this.gridRegForCubes.getLocation(regAndDepIndex[0]);
        return new Location(regLoc.getLatitude(), regLoc.getLongitude(), this.getCubeDepth(regAndDepIndex[1]));
    }

    public int getCubeIndexForLocation(Location loc) {
        int iReg = this.gridRegForCubes.indexForLocation(loc);
        if (iReg == -1) {
            return -1;
        }
        int iDep = this.getCubeDepthIndex(loc.getDepth());
        return this.getCubeIndexForRegAndDepIndices(iReg, iDep);
    }

    private int getCubeIndexForRegAndDepIndices(int iReg, int iDep) {
        int index = iDep * this.numCubesPerDepth + iReg;
        if (index < this.numCubes && index >= 0) {
            return index;
        }
        return -1;
    }

    private int getCubeDepthIndex(double depth) {
        int index = (int)Math.round((depth - this.depthDiscr / 2.0) / this.depthDiscr);
        return index;
    }

    private double getCubeDepth(int depthIndex) {
        return (double)depthIndex * this.depthDiscr + this.depthDiscr / 2.0;
    }

    private int[] getParRegAndDepIndicesForIndex(int parLocIndex) {
        int[] indices = new int[2];
        indices[1] = (int)Math.floor((double)parLocIndex / (double)this.numParLocsPerDepth);
        indices[0] = parLocIndex - indices[1] * this.numParLocsPerDepth;
        return indices;
    }

    public Location getParLocationForIndex(int parLocIndex) {
        int[] regAndDepIndex = this.getParRegAndDepIndicesForIndex(parLocIndex);
        Location regLoc = this.gridRegForParentLocs.getLocation(regAndDepIndex[0]);
        return new Location(regLoc.getLatitude(), regLoc.getLongitude(), this.getParDepth(regAndDepIndex[1]));
    }

    public int getParLocIndexForLocation(Location loc) {
        int iReg = this.gridRegForParentLocs.indexForLocation(loc);
        if (iReg == -1) {
            return -1;
        }
        int iDep = this.getParDepthIndex(loc.getDepth());
        if (iDep == -1) {
            return -1;
        }
        return this.getParLocIndexForRegAndDepIndices(iReg, iDep);
    }

    private int getParLocIndexForRegAndDepIndices(int iReg, int iDep) {
        return iDep * this.numParLocsPerDepth + iReg;
    }

    private int getParDepthIndex(double depth) {
        int depthIndex = (int)Math.round(depth / this.depthDiscr);
        if (depthIndex < 0) {
            if (!this.warnedNegDepth) {
                System.err.println("WARNING: negative depth (" + depth + "), moving to surface. Further warnings surpressed.");
            }
            this.warnedNegDepth = true;
            return 0;
        }
        if (depthIndex >= this.numParDepths) {
            if (!this.warnedBelow) {
                System.err.println("WARNING: depth (" + depth + ") below model max, moving to maxDepth=" + this.maxDepth + ". Further warnings surpressed");
            }
            this.warnedBelow = true;
            return this.numParDepths - 1;
        }
        return depthIndex;
    }

    private double getParDepth(int parDepthIndex) {
        return (double)parDepthIndex * this.depthDiscr;
    }

    public void testRates() {
        double totGriddedRate;
        if (D) {
            System.out.println("Running testRates()");
        }
        long startTime = System.currentTimeMillis();
        this.getCubeSamplerWithERF_GriddedRatesOnly();
        double totRateTest1 = totGriddedRate = this.cubeSamplerGriddedRatesOnly.calcSumOfY_Vals();
        double[] sectSupraRatesTest = new double[this.rupSet.getNumSections()];
        for (int i = 0; i < this.numCubes; ++i) {
            int[] sections = this.sectInCubeList.get(i);
            float[] fracts = this.fractionSectInCubeList.get(i);
            for (int j = 0; j < sections.length; ++j) {
                int n = sections[j];
                sectSupraRatesTest[n] = sectSupraRatesTest[n] + this.totSectNuclRateArray[sections[j]] * (double)fracts[j];
            }
        }
        double totSectSupraRate = 0.0;
        for (int s = 0; s < sectSupraRatesTest.length; ++s) {
            totSectSupraRate += sectSupraRatesTest[s];
        }
        totRateTest1 += totSectSupraRate;
        double rateUnassigned = 0.0;
        for (int s = 0; s < sectSupraRatesTest.length; ++s) {
            double sectRateDiff = this.totSectNuclRateArray[s] - sectSupraRatesTest[s];
            double fractDiff = Math.abs(sectRateDiff) / this.totSectNuclRateArray[s];
            if (fractDiff > 0.001 & D) {
                System.out.println("\tfractDiff = " + (float)fractDiff + " for " + this.rupSet.getFaultSectionData(s).getName());
            }
            rateUnassigned += sectRateDiff;
        }
        totRateTest1 += rateUnassigned;
        double totRateTest2 = 0.0;
        double duration = this.erf.getTimeSpan().getDuration();
        for (int s = 0; s < this.erf.getNumSources(); ++s) {
            ProbEqkSource src = this.erf.getSource(s);
            int numRups = src.getNumRuptures();
            for (int r = 0; r < numRups; ++r) {
                totRateTest2 += src.getRupture(r).getMeanAnnualRate(duration);
            }
        }
        double runTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        if (D) {
            System.out.println("\tSum over cubes etc tot rate = " + (float)totRateTest1 + " should equal tot rate from ERF = " + (float)totRateTest2 + ";\tratio=" + (float)(totRateTest1 / totRateTest2) + ";\t totGriddedRate=" + (float)totGriddedRate + ";\t totSectSupraRate=" + (float)totSectSupraRate + ";\t rateUnassigned=" + (float)rateUnassigned);
            System.out.println("testRates() took (sec): " + (float)runTime);
        }
    }

    private void computeMFD_ForSrcArrays(double minMag, double maxMag, int numMag) {
        this.mfdForSrcArray = new SummedMagFreqDist[this.erf.getNumSources()];
        this.mfdForSrcSubSeisOnlyArray = new SummedMagFreqDist[this.erf.getNumSources()];
        this.mfdForTrulyOffOnlyArray = new SummedMagFreqDist[this.erf.getNumSources()];
        double duration = this.erf.getTimeSpan().getDuration();
        MFDGridSourceProvider mfdGridProv = null;
        if (this.erf instanceof FaultSystemSolutionERF) {
            mfdGridProv = ((FaultSystemSolutionERF)this.erf).getSolution().requireModule(MFDGridSourceProvider.class);
        }
        for (int s = 0; s < this.erf.getNumSources(); ++s) {
            this.mfdForSrcArray[s] = ERF_Calculator.getTotalMFD_ForSource(this.erf.getSource(s), duration, minMag, maxMag, numMag, true);
            if (mfdGridProv != null) {
                if (s < this.numFltSystSources) continue;
                int gridRegionIndex = s - this.numFltSystSources;
                if (this.origGridSeisTrulyOffVsSubSeisStatus[gridRegionIndex] == 2) {
                    this.mfdForSrcSubSeisOnlyArray[s] = ERF_Calculator.getTotalMFD_ForSource(mfdGridProv.getSourceSubSeisOnFault(gridRegionIndex, duration, null, FaultSystemSolutionERF_ETAS.GRID_SEIS_SETTINGS), duration, minMag, maxMag, numMag, true);
                    this.mfdForTrulyOffOnlyArray[s] = ERF_Calculator.getTotalMFD_ForSource(mfdGridProv.getSourceUnassociated(gridRegionIndex, duration, null, FaultSystemSolutionERF_ETAS.GRID_SEIS_SETTINGS), duration, minMag, maxMag, numMag, true);
                    continue;
                }
                if (this.origGridSeisTrulyOffVsSubSeisStatus[gridRegionIndex] == 1) {
                    this.mfdForSrcSubSeisOnlyArray[s] = this.mfdForSrcArray[s];
                    this.mfdForTrulyOffOnlyArray[s] = null;
                    continue;
                }
                this.mfdForSrcSubSeisOnlyArray[s] = null;
                this.mfdForTrulyOffOnlyArray[s] = this.mfdForSrcArray[s];
                continue;
            }
            this.mfdForSrcSubSeisOnlyArray[s] = null;
            this.mfdForTrulyOffOnlyArray[s] = null;
        }
    }

    public void testAltSubseisOnFaultMFD_Representations() {
        System.out.println("Starting testSubseisOnFaultMFDs()");
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        for (int srcID = this.numFltSystSources; srcID < this.fssERF.getNumSources(); ++srcID) {
            SummedMagFreqDist mfd = this.mfdForSrcSubSeisOnlyArray[srcID];
            if (mfd == null) continue;
            Map<Integer, Double> sectOnGridCellMap = this.faultPolyMgr.getSectionFracsOnNode(srcID - this.numFltSystSources);
            for (int sectID : sectOnGridCellMap.keySet()) {
                IncrementalMagFreqDist sectMFD = longTermSubSeisMFD_OnSectList.get(sectID).deepClone();
                double totRate = sectMFD.getCumRate(2.55);
                sectMFD.scale(mfd.getTotalIncrRate() / totRate);
                double test1 = mfd.getIncrRate(2.55);
                double test2 = sectMFD.getIncrRate(2.55);
                double fractDiff = Math.abs(test1 / test2 - 1.0);
                if (fractDiff > 1.0E-5) {
                    System.out.println("testSubseisOnFaultMFDs()  Sig M2.5 rate diff at srcID=\t" + srcID + "\t" + (float)fractDiff + "\t" + this.rupSet.getFaultSectionData(sectID).getName() + "\t" + String.valueOf(this.origGriddedRegion.getLocation(srcID - this.numFltSystSources)));
                }
                if ((fractDiff = Math.abs((test1 = mfd.getCumRate(2.55)) / (test2 = sectMFD.getCumRate(2.55)) - 1.0)) > 1.0E-5) {
                    System.out.println("testSubseisOnFaultMFDs()  Sig M2.5 cum rate diff at srcID\t=" + srcID + "\t" + (float)fractDiff + "\t" + this.rupSet.getFaultSectionData(sectID).getName() + "\t" + String.valueOf(this.origGriddedRegion.getLocation(srcID - this.numFltSystSources)));
                }
                if (!((fractDiff = Math.abs((test1 = mfd.getMaxMagWithNonZeroRate()) / (test2 = sectMFD.getMaxMagWithNonZeroRate()) - 1.0)) > 1.0E-5)) continue;
                System.out.println("testSubseisOnFaultMFDs()  Sig Mmax diff at srcID\t=" + srcID + "\t" + (float)fractDiff + "\t" + this.rupSet.getFaultSectionData(sectID).getName() + "\t" + String.valueOf(this.origGriddedRegion.getLocation(srcID - this.numFltSystSources)));
            }
        }
        System.out.println("Done with testSubseisOnFaultMFDs()");
    }

    public void testSubseisOnFaultMFDs() {
        System.out.println("Starting testSubseisOnFaultMFDs()");
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        for (int srcID = this.numFltSystSources; srcID < this.fssERF.getNumSources(); ++srcID) {
            double test2;
            SummedMagFreqDist mfd = this.mfdForSrcSubSeisOnlyArray[srcID];
            if (mfd == null) continue;
            SummedMagFreqDist testDist = new SummedMagFreqDist(mfd.getMinX(), mfd.getMaxX(), mfd.size());
            Map<Integer, Double> sectOnGridCellMap = this.faultPolyMgr.getSectionFracsOnNode(srcID - this.numFltSystSources);
            for (int sectID : sectOnGridCellMap.keySet()) {
                IncrementalMagFreqDist sectMFD = longTermSubSeisMFD_OnSectList.get(sectID).deepClone();
                sectMFD.scale(sectOnGridCellMap.get(sectID));
                testDist.addIncrementalMagFreqDist(sectMFD);
            }
            double test1 = mfd.getIncrRate(2.55);
            double fractDiff = Math.abs(test1 / (test2 = testDist.getIncrRate(2.55)) - 1.0);
            if (fractDiff > 1.0E-5) {
                System.out.println("testSubseisOnFaultMFDs()  Sig M2.5 rate diff at srcID=" + srcID + "\t" + String.valueOf(this.origGriddedRegion.getLocation(srcID - this.numFltSystSources)));
            }
            if ((fractDiff = Math.abs((test1 = mfd.getCumRate(2.55)) / (test2 = testDist.getCumRate(2.55)) - 1.0)) > 1.0E-5) {
                System.out.println("testSubseisOnFaultMFDs()  Sig M2.5 cum rate diff at srcID=" + srcID + "\t" + String.valueOf(this.origGriddedRegion.getLocation(srcID - this.numFltSystSources)));
            }
            if (!((fractDiff = Math.abs((test1 = mfd.getMaxMagWithNonZeroRate()) / (test2 = testDist.getMaxMagWithNonZeroRate()) - 1.0)) > 1.0E-5)) continue;
            System.out.println("testSubseisOnFaultMFDs()  Sig Mmax diff at srcID=" + srcID + "\t" + String.valueOf(this.origGriddedRegion.getLocation(srcID - this.numFltSystSources)));
        }
        System.out.println("Done with testSubseisOnFaultMFDs()");
    }

    private SummedMagFreqDist getCubeMFD(int cubeIndex) {
        Hashtable<Integer, Double> rateForSrcHashtable;
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        if ((rateForSrcHashtable = this.getNucleationRatesOfSourcesInCube(cubeIndex, 1.0)) == null) {
            return null;
        }
        double maxMagTest = 0.0;
        int testSrcIndex = -1;
        SummedMagFreqDist magDist = new SummedMagFreqDist(this.mfdForSrcArray[0].getMinX(), this.mfdForSrcArray[0].getMaxX(), this.mfdForSrcArray[0].size());
        for (int srcIndex : rateForSrcHashtable.keySet()) {
            SummedMagFreqDist mfd = null;
            double srcNuclRate = rateForSrcHashtable.get(srcIndex);
            int gridIndex = srcIndex - this.numFltSystSources;
            int cubeRegIndex = this.getCubeRegAndDepIndicesForIndex(cubeIndex)[0];
            mfd = srcIndex >= this.numFltSystSources && this.origGridSeisTrulyOffVsSubSeisStatus[gridIndex] == 2 ? (this.isCubeInsideFaultPolygon[cubeRegIndex] == 1 ? this.mfdForSrcSubSeisOnlyArray[srcIndex] : this.mfdForTrulyOffOnlyArray[srcIndex]) : this.mfdForSrcArray[srcIndex];
            double totRate = mfd.getTotalIncrRate();
            if (!(totRate > 0.0)) continue;
            for (int m = 0; m < mfd.size(); ++m) {
                magDist.add(m, mfd.getY(m) * srcNuclRate / totRate);
            }
            double maxMag = mfd.getMaxMagWithNonZeroRate();
            if (!(maxMagTest < maxMag) || !(srcNuclRate > 0.0)) continue;
            maxMagTest = maxMag;
            testSrcIndex = srcIndex;
        }
        double maxMagTest2 = magDist.getMaxMagWithNonZeroRate();
        if (Double.isNaN(maxMagTest2)) {
            maxMagTest2 = 0.0;
        }
        if (maxMagTest != maxMagTest2) {
            System.out.println("testSrcIndex=" + testSrcIndex);
            System.out.println(this.mfdForSrcArray[testSrcIndex]);
            System.out.println(String.valueOf(magDist) + "\nmaxMagTest=" + maxMagTest + "\nmaxMagTest2=" + maxMagTest2);
            throw new RuntimeException("problem with max mag at cube index " + cubeIndex);
        }
        return magDist;
    }

    private SummedMagFreqDist getCubeMFD_GriddedSeisOnly(int cubeIndex) {
        if (this.mfdForSrcArray == null) {
            throw new RuntimeException("must run computeMFD_ForSrcArrays(*) first");
        }
        Hashtable<Integer, Double> rateForSrcInCubeHashtable = this.getNucleationRatesOfSourcesInCube(cubeIndex, 1.0);
        if (rateForSrcInCubeHashtable == null) {
            return null;
        }
        SummedMagFreqDist magDist = new SummedMagFreqDist(this.mfdForSrcArray[0].getMinX(), this.mfdForSrcArray[0].getMaxX(), this.mfdForSrcArray[0].size());
        for (int srcIndex : rateForSrcInCubeHashtable.keySet()) {
            if (srcIndex < this.numFltSystSources) continue;
            SummedMagFreqDist mfd = null;
            double srcNuclRate = rateForSrcInCubeHashtable.get(srcIndex);
            int gridIndex = srcIndex - this.numFltSystSources;
            int cubeRegIndex = this.getCubeRegAndDepIndicesForIndex(cubeIndex)[0];
            mfd = this.origGridSeisTrulyOffVsSubSeisStatus[gridIndex] == 2 ? (this.isCubeInsideFaultPolygon[cubeRegIndex] == 1 ? this.mfdForSrcSubSeisOnlyArray[srcIndex] : this.mfdForTrulyOffOnlyArray[srcIndex]) : this.mfdForSrcArray[srcIndex];
            double totRate = mfd.getTotalIncrRate();
            if (!(totRate > 0.0)) continue;
            for (int m = 0; m < mfd.size(); ++m) {
                magDist.add(m, mfd.getY(m) * srcNuclRate / totRate);
            }
        }
        return magDist;
    }

    private SummedMagFreqDist getCubeMFD_SupraSeisOnly(int cubeIndex) {
        if (this.mfdForSrcArray == null) {
            throw new RuntimeException("must run computeMFD_ForSrcArrays(*) first");
        }
        Hashtable<Integer, Double> rateForSrcHashtable = this.getNucleationRatesOfSourcesInCube(cubeIndex, 1.0);
        if (rateForSrcHashtable == null) {
            return null;
        }
        SummedMagFreqDist magDist = new SummedMagFreqDist(this.mfdForSrcArray[0].getMinX(), this.mfdForSrcArray[0].getMaxX(), this.mfdForSrcArray[0].size());
        for (int srcIndex : rateForSrcHashtable.keySet()) {
            if (srcIndex >= this.numFltSystSources) continue;
            IncrementalMagFreqDist mfd = this.mfdForSrcArray[srcIndex].deepClone();
            double totRate = mfd.getTotalIncrRate();
            mfd.scale(rateForSrcHashtable.get(srcIndex) / totRate);
            magDist.addIncrementalMagFreqDist(mfd);
        }
        return magDist;
    }

    public void testMagFreqDist() {
        if (D) {
            System.out.println("Running testMagFreqDist()");
        }
        SummedMagFreqDist magDist = new SummedMagFreqDist(2.05, 8.95, 70);
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        CalcProgressBar progressBar = new CalcProgressBar("Looping over all points", "junk");
        progressBar.showProgress(true);
        for (int i = 0; i < this.numCubes; ++i) {
            progressBar.updateProgress(i, this.numCubes);
            SummedMagFreqDist mfd = this.getCubeMFD(i);
            if (mfd == null) continue;
            magDist.addIncrementalMagFreqDist(this.getCubeMFD(i));
        }
        progressBar.showProgress(false);
        magDist.setName("MFD from EqksAtPoint list");
        ArrayList<EvenlyDiscretizedFunc> magDistList = new ArrayList<EvenlyDiscretizedFunc>();
        magDistList.add(magDist);
        magDistList.add(magDist.getCumRateDistWithOffset());
        SummedMagFreqDist erfMFD = ERF_Calculator.getTotalMFD_ForERF(this.erf, 2.05, 8.95, 70, true);
        erfMFD.setName("MFD from ERF");
        magDistList.add(erfMFD);
        magDistList.add(erfMFD.getCumRateDistWithOffset());
        GraphWindow magDistsGraph = new GraphWindow(magDistList, "Mag-Freq Distributions");
        magDistsGraph.setX_AxisLabel("Mag");
        magDistsGraph.setY_AxisLabel("Rate");
        magDistsGraph.setY_AxisRange(1.0E-6, magDistsGraph.getY_AxisRange().getUpperBound());
        magDistsGraph.setYLog(true);
    }

    public void testGriddedSeisRatesInCubes() {
        int i;
        if (D) {
            System.out.println("testGriddedSeisRatesInCubes()");
        }
        CaliforniaRegions.RELM_TESTING_GRIDDED mapGriddedRegion = RELM_RegionUtils.getGriddedRegionInstance();
        GriddedGeoDataSet xyzDataSet = new GriddedGeoDataSet(mapGriddedRegion, true);
        for (int i2 = 0; i2 < xyzDataSet.size(); ++i2) {
            xyzDataSet.set(i2, 0.0);
        }
        double duration = this.erf.getTimeSpan().getDuration();
        CalcProgressBar progressBar = new CalcProgressBar("Looping over sources", "junk");
        progressBar.showProgress(true);
        int iSrc = -1;
        int numSrc = this.erf.getNumSources();
        for (ProbEqkSource src : this.erf) {
            progressBar.updateProgress(++iSrc, numSrc);
            if (iSrc < this.numFltSystSources) continue;
            for (ProbEqkRupture rup : src) {
                LocationList locList = rup.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
                double ptRate = rup.getMeanAnnualRate(duration) / (double)locList.size();
                for (Location loc : locList) {
                    int locIndex = mapGriddedRegion.indexForLocation(loc);
                    if (locIndex < 0) continue;
                    double oldRate = xyzDataSet.get(locIndex);
                    xyzDataSet.set(locIndex, ptRate + oldRate);
                }
            }
        }
        progressBar.showProgress(false);
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        GriddedGeoDataSet xyzDataSet2 = new GriddedGeoDataSet(mapGriddedRegion, true);
        for (i = 0; i < xyzDataSet2.size(); ++i) {
            xyzDataSet2.set(i, 0.0);
        }
        progressBar = new CalcProgressBar("Looping over cubes", "junk");
        progressBar.showProgress(true);
        for (i = 0; i < this.numCubes; ++i) {
            progressBar.updateProgress(i, this.numCubes);
            double rate = this.cubeSamplerGriddedRatesOnly.getY(i);
            int locIndex = mapGriddedRegion.indexForLocation(this.getCubeLocationForIndex(i));
            if (locIndex < 0) continue;
            double oldRate = xyzDataSet2.get(locIndex);
            xyzDataSet2.set(locIndex, rate + oldRate);
        }
        progressBar.showProgress(false);
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i3 = 0; i3 < xyzDataSet2.size(); ++i3) {
            sum1 += xyzDataSet.get(i3);
            sum2 += xyzDataSet2.get(i3);
            double diff = xyzDataSet2.get(i3) - xyzDataSet.get(i3);
            double absFractDiff = Math.abs(diff / xyzDataSet.get(i3));
            Location loc = xyzDataSet2.getLocation(i3);
            if (!(absFractDiff > 0.001)) continue;
            System.out.println(diff + "\t" + loc.getLongitude() + "\t" + loc.getLatitude());
        }
        System.out.println("sum over ERF = " + sum1);
        System.out.println("sum over cubes = " + sum2);
    }

    public double tempGetSampleProbForAllCubesOnFaultSection(int sectIndex, ETAS_EqkRupture mainshock) {
        double prob = 0.0;
        IntegerPDF_FunctionSampler aveSampler = this.getAveSamplerForRupture(mainshock);
        ArrayList<Integer> usedCubesIndices = new ArrayList<Integer>();
        FaultSection fltSectData = this.rupSet.getFaultSectionData(sectIndex);
        for (Location loc : fltSectData.getFaultSurface(1.0, false, true).getEvenlyDiscritizedListOfLocsOnSurface()) {
            int cubeIndex = this.getCubeIndexForLocation(loc);
            if (usedCubesIndices.contains(cubeIndex)) continue;
            prob += aveSampler.getY(cubeIndex);
            usedCubesIndices.add(cubeIndex);
        }
        return prob;
    }

    public void testFaultPolyMgr() {
        this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        int num = 0;
        double totVal1 = 0.0;
        double totVal2 = 0.0;
        double[] testsectSubSeisRates = new double[this.rupSet.getNumSections()];
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            Map<Integer, Double> nodeFracMap = this.faultPolyMgr.getNodeFractions(s);
            for (int regID : nodeFracMap.keySet()) {
                double subSeisRateForGridNode = this.mfdForSrcSubSeisOnlyArray[regID + this.numFltSystSources].getCumRate(2.55);
                double sum = 0.0;
                Map<Integer, Double> sectFracOnGridNode = this.faultPolyMgr.getSectionFracsOnNode(regID);
                for (int s2 : sectFracOnGridNode.keySet()) {
                    if (s2 == s) continue;
                    sum += longTermSubSeisMFD_OnSectList.get(s2).getCumRate(2.55) * sectFracOnGridNode.get(s2);
                }
                int n = s;
                testsectSubSeisRates[n] = testsectSubSeisRates[n] + (subSeisRateForGridNode - sum);
            }
            double val1 = testsectSubSeisRates[s];
            totVal1 += val1;
            double val2 = longTermSubSeisMFD_OnSectList.get(s).getCumRate(2.55);
            totVal2 += val2;
            double diff = Math.abs(val1 / val2 - 1.0);
            if (!(diff > 0.001)) continue;
            System.out.println("TEST2 diff=\t" + s + "\t" + diff + "\t" + this.rupSet.getFaultSectionData(s).getName() + "\t" + val1 + "\t" + val2);
            ++num;
        }
        System.out.println(num + " out of " + this.rupSet.getNumSections() + " had diffs >0.001");
        System.out.println("totVal1=" + totVal1 + "\ttotVal2=" + totVal2 + "\t" + totVal1 / totVal2);
        double[] subSeisRateForGridNodesTest = new double[this.origGriddedRegion.getNumLocations()];
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            Map<Integer, Double> nodeFracMap = this.faultPolyMgr.getNodeFractions(s);
            double totSectSubSeisRate = longTermSubSeisMFD_OnSectList.get(s).getCumRate(2.55);
            Iterator<Integer> iterator = nodeFracMap.keySet().iterator();
            while (iterator.hasNext()) {
                int gridID;
                int n = gridID = iterator.next().intValue();
                subSeisRateForGridNodesTest[n] = subSeisRateForGridNodesTest[n] + totSectSubSeisRate * nodeFracMap.get(gridID);
            }
        }
        for (int i = 0; i < subSeisRateForGridNodesTest.length; ++i) {
            if (!(subSeisRateForGridNodesTest[i] > 0.0)) continue;
            double expVal = this.mfdForSrcSubSeisOnlyArray[i + this.numFltSystSources].getCumRate(2.55);
            Location loc = this.origGriddedRegion.getLocation(i);
            double diff = Math.abs(subSeisRateForGridNodesTest[i] / expVal - 1.0);
            if (!(diff > 1.0E-6)) continue;
            System.out.println("TEST3\t" + i + "\t" + diff + "\t" + loc.getLatitude() + "\t" + loc.getLongitude() + "\t" + loc.getDepth() + "\t" + expVal + "\t" + subSeisRateForGridNodesTest[i]);
        }
        System.out.println("Done with testFaultPolyMgr()");
    }

    public void testSubSeisMFD_ForSect(int sectIndex) {
        IncrementalMagFreqDist mfd2 = ((FaultSystemSolutionERF)this.erf).getSolution().requireModule(SubSeismoOnFaultMFDs.class).get(sectIndex);
        mfd2.setName("Subseis MFD from erf.getSolution().getSubSeismoOnFaultMFD_List().get(sectIndex) for " + sectIndex + "; " + this.rupSet.getFaultSectionData(sectIndex).getName());
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        HashMap<Integer, Double> srcFractMap = new HashMap<Integer, Double>();
        Region faultPolygon = this.faultPolyMgr.getPoly(sectIndex);
        int numCubes = 0;
        for (int i = 0; i < this.gridRegForCubes.getNumLocations(); ++i) {
            Location cubeLoc = this.gridRegForCubes.getLocation(i);
            if (!faultPolygon.contains(cubeLoc)) continue;
            int srcIndex = this.numFltSystSources + this.origGriddedRegion.indexForLocation(cubeLoc);
            if (srcFractMap.containsKey(srcIndex)) {
                double newFrac = (Double)srcFractMap.get(srcIndex) + 1.0;
                srcFractMap.put(srcIndex, newFrac);
            } else {
                srcFractMap.put(srcIndex, 1.0);
            }
            ++numCubes;
        }
        System.out.println("srcFractMap");
        double tot = 0.0;
        Iterator srcIndex = srcFractMap.keySet().iterator();
        while (srcIndex.hasNext()) {
            int srcIndex2 = (Integer)srcIndex.next();
            double val = (Double)srcFractMap.get(srcIndex2) / (double)numCubes;
            srcFractMap.put(srcIndex2, val);
            Location gridLoc = this.origGriddedRegion.getLocation(srcIndex2 - this.numFltSystSources);
            System.out.println(srcIndex2 + "\t" + ((Double)srcFractMap.get(srcIndex2)).floatValue() + "\t" + String.valueOf(gridLoc));
            tot += ((Double)srcFractMap.get(srcIndex2)).doubleValue();
        }
        System.out.println("total=" + (float)tot);
        System.out.println("altMap");
        Map<Integer, Double> altMap = this.faultPolyMgr.getNodeFractions(sectIndex);
        tot = 0.0;
        for (int gridIndex : altMap.keySet()) {
            Location gridLoc = this.origGriddedRegion.getLocation(gridIndex);
            System.out.println(gridIndex + this.numFltSystSources + "\t" + altMap.get(gridIndex).floatValue() + "\t" + String.valueOf(gridLoc));
            tot += altMap.get(gridIndex).doubleValue();
        }
        System.out.println("total=" + (float)tot);
        SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray();
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        Map<Integer, Double> nodeFracMap = this.faultPolyMgr.getNodeFractions(sectIndex);
        double targetRate = 0.0;
        for (int regID : nodeFracMap.keySet()) {
            double subSeisRateForGridNode = this.mfdForSrcSubSeisOnlyArray[regID + this.numFltSystSources].getCumRate(2.55);
            double sum = 0.0;
            Map<Integer, Double> sectFracOnGridNode = this.faultPolyMgr.getSectionFracsOnNode(regID);
            for (int s2 : sectFracOnGridNode.keySet()) {
                if (s2 == sectIndex) continue;
                sum += longTermSubSeisMFD_OnSectList.get(s2).getCumRate(2.55) * sectFracOnGridNode.get(s2);
            }
            targetRate += subSeisRateForGridNode - sum;
        }
        IncrementalMagFreqDist mfd4 = longTermSubSeisMFD_OnSectList.get(sectIndex).deepClone();
        double scale = targetRate / mfd4.getCumRate(2.55);
        mfd4.scale(scale);
        mfd4.setName("Correct/New Way");
        SummedMagFreqDist mfd5 = new SummedMagFreqDist(2.05, 8.95, 70);
        for (int regID : nodeFracMap.keySet()) {
            double subSeisRateForGridNode = this.mfdForSrcSubSeisOnlyArray[regID + this.numFltSystSources].getCumRate(2.55);
            double sum = 0.0;
            Map<Integer, Double> sectFracOnGridNode = this.faultPolyMgr.getSectionFracsOnNode(regID);
            for (int s2 : sectFracOnGridNode.keySet()) {
                if (s2 == sectIndex) continue;
                sum += longTermSubSeisMFD_OnSectList.get(s2).getCumRate(2.55) * sectFracOnGridNode.get(s2);
            }
            targetRate = subSeisRateForGridNode - sum;
            IncrementalMagFreqDist mfd = this.mfdForSrcSubSeisOnlyArray[regID + this.numFltSystSources].deepClone();
            scale = targetRate / mfd.getCumRate(2.55);
            mfd.scale(scale);
            mfd5.addIncrementalMagFreqDist(mfd);
        }
        mfd5.setName("Correct/New Way Alt");
        ArrayList<IncrementalMagFreqDist> mfdList = new ArrayList<IncrementalMagFreqDist>();
        mfdList.add(mfd2);
        mfdList.add(mfd4);
        mfdList.add(mfd5);
        GraphWindow mfd_Graph = new GraphWindow(mfdList, "Subseis MFD comparison");
        mfd_Graph.setX_AxisLabel("Mag");
        mfd_Graph.setY_AxisLabel("Rate");
        mfd_Graph.setYLog(true);
        mfd_Graph.setPlotLabelFontSize(22);
        mfd_Graph.setAxisLabelFontSize(20);
        mfd_Graph.setTickLabelFontSize(18);
    }

    public void tempListSubsectsThatCoverGridCell(int gridCellIndex) {
        System.out.println("Running tempListSubsectsThatCoverGridCell(" + gridCellIndex + ")");
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            Map<Integer, Double> nodesForSectMap = this.faultPolyMgr.getScaledNodeFractions(s);
            if (!nodesForSectMap.keySet().contains(gridCellIndex)) continue;
            System.out.println(s + "\t" + String.valueOf(nodesForSectMap.get(gridCellIndex)) + "\t" + this.rupSet.getFaultSectionData(s).getName());
            Region faultPolygon = this.faultPolyMgr.getPoly(s);
            System.out.println("Section Polygon:");
            for (Location loc : faultPolygon.getBorder()) {
                System.out.println(loc.getLatitude() + "\t" + loc.getLongitude());
            }
        }
    }

    public double getTrulyOffFaultGR_Corr(boolean debug) {
        if (!Double.isNaN(this.trulyOffFaultGR_Corr)) {
            return this.trulyOffFaultGR_Corr;
        }
        double aveMinSupra = 6.35;
        this.trulyOffFaultGR_Corr = Double.NaN;
        for (int i = 0; i < this.origGriddedRegion.getNumLocations(); ++i) {
            if (this.origGridSeisTrulyOffVsSubSeisStatus[i] != 0) continue;
            SummedMagFreqDist mfd = this.mfdForTrulyOffOnlyArray[this.numFltSystSources + i];
            double maxMag = mfd.getMaxMagWithNonZeroRate();
            double minMag = mfd.getMinMagWithNonZeroRate();
            int numMag = (int)((maxMag - minMag) / mfd.getDelta()) + 1;
            GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(1.0, 1.0, minMag, maxMag, numMag);
            gr.scaleToIncrRate(minMag, mfd.getY(minMag));
            this.trulyOffFaultGR_Corr = gr.getCumRate(aveMinSupra) / mfd.getCumRate(aveMinSupra);
            if (!debug) break;
            ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
            mfd.setInfo("grCorr = " + (float)this.trulyOffFaultGR_Corr);
            funcs.add(mfd);
            funcs.add(gr);
            funcs.add(mfd.getCumRateDistWithOffset());
            funcs.add(gr.getCumRateDistWithOffset());
            GraphWindow graph = new GraphWindow(funcs, "From getTrulyOffFaultGR_Corr");
            graph.setX_AxisLabel("Mag");
            graph.setY_AxisLabel("Rate");
            graph.setYLog(true);
            break;
        }
        return this.trulyOffFaultGR_Corr;
    }

    public double getFaultGR_CorrFromTotalFaultMFDs(boolean debug) {
        double aveMinSupra = 6.35;
        double minMag = 2.55;
        double maxMag = 8.95;
        int numMag = 65;
        double grCorr = Double.NaN;
        SummedMagFreqDist totMFD_Supra = new SummedMagFreqDist(minMag, maxMag, numMag);
        totMFD_Supra.setName("totMFD_Supra");
        SummedMagFreqDist totMFD_Sub = new SummedMagFreqDist(minMag, maxMag, numMag);
        totMFD_Sub.setName("totMFD_Sub");
        SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray();
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            if (longTermSubSeisMFD_OnSectList.get(s) == null) continue;
            totMFD_Sub.addIncrementalMagFreqDist(longTermSubSeisMFD_OnSectList.get(s));
            if (longTermSupraSeisMFD_OnSectArray[s] == null) continue;
            totMFD_Supra.addIncrementalMagFreqDist(longTermSupraSeisMFD_OnSectArray[s]);
        }
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(1.0, 1.0, minMag, maxMag, numMag);
        gr.scaleToIncrRate(minMag, totMFD_Sub.getY(minMag));
        gr.setName("GR Dist");
        grCorr = gr.getCumRate(aveMinSupra) / totMFD_Supra.getCumRate(aveMinSupra);
        if (debug) {
            ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
            totMFD_Supra.setInfo("grCorr = " + (float)grCorr);
            funcs.add(totMFD_Supra);
            funcs.add(totMFD_Sub);
            funcs.add(gr);
            funcs.add(totMFD_Supra.getCumRateDistWithOffset());
            funcs.add(totMFD_Sub.getCumRateDistWithOffset());
            funcs.add(gr.getCumRateDistWithOffset());
            GraphWindow graph = new GraphWindow(funcs, "From getFaultGR_CorrFromTotalFaultMFDs");
            graph.setX_AxisLabel("Mag");
            graph.setY_AxisLabel("Rate");
            graph.setYLog(true);
        }
        return grCorr;
    }

    public void plotExpectedLongTermMFDs() {
        double minMag = 2.55;
        double maxMag = 8.95;
        int numMag = 65;
        SummedMagFreqDist totMFD_Supra = new SummedMagFreqDist(minMag, maxMag, numMag);
        totMFD_Supra.setName("totMFD_Supra");
        SummedMagFreqDist totMFD_Sub = new SummedMagFreqDist(minMag, maxMag, numMag);
        totMFD_Sub.setName("totMFD_Sub");
        SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray();
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
            if (longTermSubSeisMFD_OnSectList.get(s) == null) continue;
            totMFD_Sub.addIncrementalMagFreqDist(longTermSubSeisMFD_OnSectList.get(s));
            if (longTermSupraSeisMFD_OnSectArray[s] == null) continue;
            totMFD_Supra.addIncrementalMagFreqDist(longTermSupraSeisMFD_OnSectArray[s]);
        }
        SummedMagFreqDist totalTrulyOffFaultMFD = new SummedMagFreqDist(minMag, maxMag, numMag);
        for (int src = this.fssERF.getNumFaultSystemSources(); src < this.fssERF.getNumSources(); ++src) {
            if (this.mfdForTrulyOffOnlyArray[src] == null) continue;
            totalTrulyOffFaultMFD.addIncrementalMagFreqDist(this.mfdForTrulyOffOnlyArray[src]);
        }
        totalTrulyOffFaultMFD.setName("totalTrulyOffFaultMFD");
        SummedMagFreqDist totalModelMFD = new SummedMagFreqDist(minMag, maxMag, numMag);
        totalModelMFD.addIncrementalMagFreqDist(totalTrulyOffFaultMFD);
        totalModelMFD.addIncrementalMagFreqDist(totMFD_Sub);
        totalModelMFD.addIncrementalMagFreqDist(totMFD_Supra);
        totalModelMFD.setName("totalModelMFD");
        SummedMagFreqDist totalOnFaultMFD = new SummedMagFreqDist(minMag, maxMag, numMag);
        totalOnFaultMFD.addIncrementalMagFreqDist(totMFD_Sub);
        totalOnFaultMFD.addIncrementalMagFreqDist(totMFD_Supra);
        GutenbergRichterMagFreqDist gr1 = new GutenbergRichterMagFreqDist(1.0, 1.0, minMag, maxMag + 1.0, numMag + 10);
        gr1.scaleToIncrRate(minMag, totalOnFaultMFD.getY(minMag));
        gr1.setName("GR Dist 1");
        GutenbergRichterMagFreqDist gr2 = new GutenbergRichterMagFreqDist(1.0, 1.0, minMag, maxMag + 1.0, numMag + 10);
        gr2.scaleToIncrRate(minMag, totalTrulyOffFaultMFD.getY(minMag));
        gr2.setName("GR Dist 2");
        ArrayList<PlotCurveCharacterstics> plotCharsList = new ArrayList<PlotCurveCharacterstics>();
        plotCharsList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
        plotCharsList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED));
        plotCharsList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLUE));
        plotCharsList.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, Color.RED));
        plotCharsList.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, Color.BLUE));
        ArrayList<IncrementalMagFreqDist> funcs = new ArrayList<IncrementalMagFreqDist>();
        funcs.add(totalModelMFD);
        funcs.add(totalOnFaultMFD);
        funcs.add(totalTrulyOffFaultMFD);
        funcs.add(gr1);
        funcs.add(gr2);
        GraphWindow graph = new GraphWindow(funcs, "Imcremental MFDs", plotCharsList);
        graph.setX_AxisLabel("Magnitude");
        graph.setY_AxisLabel("Incremental Rate (per year)");
        graph.setYLog(true);
        graph.setAxisLabelFontSize(20);
        graph.setPlotLabelFontSize(20);
        graph.setTickLabelFontSize(18);
        graph.setAxisRange(4.0, 8.5, 1.0E-5, 100.0);
        ArrayList<EvenlyDiscretizedFunc> funcsCum = new ArrayList<EvenlyDiscretizedFunc>();
        funcsCum.add(totalModelMFD.getCumRateDistWithOffset());
        funcsCum.add(totalOnFaultMFD.getCumRateDistWithOffset());
        funcsCum.add(totalTrulyOffFaultMFD.getCumRateDistWithOffset());
        funcsCum.add(gr1.getCumRateDistWithOffset());
        funcsCum.add(gr2.getCumRateDistWithOffset());
        GraphWindow graphCum = new GraphWindow(funcsCum, "Cumulative MFDs", plotCharsList);
        graphCum.setX_AxisLabel("Magnitude");
        graphCum.setY_AxisLabel("Cumulative Rate (per year)");
        graphCum.setYLog(true);
        graphCum.setAxisLabelFontSize(20);
        graphCum.setPlotLabelFontSize(20);
        graphCum.setTickLabelFontSize(18);
        graphCum.setAxisRange(4.0, 8.5, 1.0E-5, 100.0);
        try {
            graph.saveAsPDF("LongTermMFDs_Incremental.pdf");
            graph.saveAsTXT("LongTermMFDs_Incremental.txt");
            graphCum.saveAsPDF("LongTermMFDs_Cumulative.pdf");
            graphCum.saveAsTXT("LongTermMFDs_Cumulative.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void plotMFDsForSubSect(int sectIndex) {
        String name = this.rupSet.getFaultSectionData(sectIndex).getName();
        SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray();
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        IncrementalMagFreqDist subSeisMFD = longTermSubSeisMFD_OnSectList.get(sectIndex);
        subSeisMFD.setName(String.valueOf(subSeisMFD) + " for " + name);
        SummedMagFreqDist supraSeisMFD = longTermSupraSeisMFD_OnSectArray[sectIndex];
        supraSeisMFD.setName(String.valueOf(supraSeisMFD) + " for " + name);
        SummedMagFreqDist combinedMFD = new SummedMagFreqDist(2.55, 8.45, 60);
        combinedMFD.addIncrementalMagFreqDist(subSeisMFD);
        combinedMFD.addIncrementalMagFreqDist(supraSeisMFD);
        combinedMFD.setName("Total Cum MFD for " + name);
        GutenbergRichterMagFreqDist perfectGR = new GutenbergRichterMagFreqDist(1.0, 1.0, 2.55, 8.35, 59);
        perfectGR.scaleToIncrRate(2.55, subSeisMFD.getY(2.55));
        perfectGR.setName("perfectGR");
        double grCorr = ETAS_Utils.getScalingFactorToImposeGR_supraRates(supraSeisMFD, subSeisMFD, false);
        IncrementalMagFreqDist supraSeisMFD_grCorr = supraSeisMFD.deepClone();
        supraSeisMFD_grCorr.scaleToCumRate(0, supraSeisMFD_grCorr.getTotalIncrRate() * grCorr);
        double testCorr = ETAS_Utils.getScalingFactorToImposeGR_supraRates(supraSeisMFD_grCorr, subSeisMFD, false);
        supraSeisMFD_grCorr.setName(String.valueOf(supraSeisMFD_grCorr) + " for " + name);
        System.out.println("grCorr=" + grCorr + "\ttestCorr=" + testCorr);
        supraSeisMFD_grCorr.setInfo("grCorr=" + grCorr + "\ttestCorr=" + testCorr);
        ArrayList<EvenlyDiscretizedFunc> mfdList1 = new ArrayList<EvenlyDiscretizedFunc>();
        mfdList1.add(subSeisMFD);
        mfdList1.add(supraSeisMFD);
        mfdList1.add(combinedMFD.getCumRateDistWithOffset());
        mfdList1.add(perfectGR);
        mfdList1.add(perfectGR.getCumRateDistWithOffset());
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.LIGHT_GRAY));
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.DARK_GRAY));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, Color.BLACK));
        chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 3.0f, Color.BLACK));
        GraphWindow magProbDistsGraph1 = new GraphWindow(mfdList1, name, chars);
        magProbDistsGraph1.setX_AxisLabel("Magnitude");
        magProbDistsGraph1.setY_AxisLabel("Rate (per year)");
        magProbDistsGraph1.setY_AxisRange(1.0E-8, 1.0);
        magProbDistsGraph1.setX_AxisRange(2.5, 8.5);
        magProbDistsGraph1.setYLog(true);
        magProbDistsGraph1.setPlotLabelFontSize(18);
        magProbDistsGraph1.setAxisLabelFontSize(22);
        magProbDistsGraph1.setTickLabelFontSize(20);
        SummedMagFreqDist combinedMFDcorr = new SummedMagFreqDist(2.55, 8.45, 60);
        combinedMFDcorr.addIncrementalMagFreqDist(subSeisMFD);
        combinedMFDcorr.addIncrementalMagFreqDist(supraSeisMFD_grCorr);
        combinedMFDcorr.setName("Total Corr Cum MFD for " + name);
        ArrayList<EvenlyDiscretizedFunc> mfdList2 = new ArrayList<EvenlyDiscretizedFunc>();
        mfdList2.add(subSeisMFD);
        mfdList2.add(supraSeisMFD_grCorr);
        mfdList2.add(combinedMFDcorr.getCumRateDistWithOffset());
        mfdList2.add(perfectGR);
        mfdList2.add(perfectGR.getCumRateDistWithOffset());
        GraphWindow magProbDistsGraph2 = new GraphWindow(mfdList2, name + " (GR-corrected)", chars);
        magProbDistsGraph2.setX_AxisLabel("Magnitude");
        magProbDistsGraph2.setY_AxisLabel("Rate (per year)");
        magProbDistsGraph2.setY_AxisRange(1.0E-8, 1.0);
        magProbDistsGraph2.setX_AxisRange(2.5, 8.5);
        magProbDistsGraph2.setYLog(true);
        magProbDistsGraph2.setPlotLabelFontSize(18);
        magProbDistsGraph2.setAxisLabelFontSize(22);
        magProbDistsGraph2.setTickLabelFontSize(20);
        ETAS_ParameterList params = new ETAS_ParameterList();
        double expNum = ETAS_Utils.getExpectedNumEvents(params.get_k(), params.get_p(), 5.5, 2.5, params.get_c(), 0.0, 360.0);
        EvenlyDiscretizedFunc expCumDistForM5p5 = combinedMFD.getCumRateDistWithOffset();
        double scaleFact = expNum / combinedMFD.getTotalIncrRate();
        expCumDistForM5p5.scale(scaleFact);
        expCumDistForM5p5.setName("expCumDistForM5p5");
        expCumDistForM5p5.setTolerance(0.001);
        double expNum5p5 = expCumDistForM5p5.getY(5.5);
        double expNum6p3 = expCumDistForM5p5.getY(6.3);
        expCumDistForM5p5.setInfo("expNum=" + expNum + "\nnum\u22655.5=" + expNum5p5 + "\nnum\u22656.3=" + expNum6p3);
        EvenlyDiscretizedFunc expCumDistForPerfectGR_M5p5 = perfectGR.getCumRateDistWithOffset();
        scaleFact = expNum / perfectGR.getTotalIncrRate();
        expCumDistForPerfectGR_M5p5.scale(scaleFact);
        expCumDistForPerfectGR_M5p5.setName("expCumDistForPerfectGR_M5p5");
        expCumDistForPerfectGR_M5p5.setTolerance(0.001);
        expNum5p5 = expCumDistForPerfectGR_M5p5.getY(5.5);
        expNum6p3 = expCumDistForPerfectGR_M5p5.getY(6.3);
        expCumDistForPerfectGR_M5p5.setInfo("expNum=" + expNum + "\nnum\u22655.5=" + expNum5p5 + "\nnum\u22656.3=" + expNum6p3);
        EvenlyDiscretizedFunc expCumDistForCorrM5p5 = combinedMFDcorr.getCumRateDistWithOffset();
        scaleFact = expNum / combinedMFDcorr.getTotalIncrRate();
        expCumDistForCorrM5p5.scale(scaleFact);
        expCumDistForCorrM5p5.setName("expCumDistForCorrM5p5");
        expCumDistForCorrM5p5.setTolerance(0.001);
        expNum5p5 = expCumDistForCorrM5p5.getY(5.5);
        expNum6p3 = expCumDistForCorrM5p5.getY(6.3);
        expCumDistForCorrM5p5.setInfo("expNum=" + expNum + "\nnum\u22655.5=" + expNum5p5 + "\nnum\u22656.3=" + expNum6p3);
        ArrayList<EvenlyDiscretizedFunc> mfdList3 = new ArrayList<EvenlyDiscretizedFunc>();
        mfdList3.add(expCumDistForM5p5);
        mfdList3.add(expCumDistForPerfectGR_M5p5);
        mfdList3.add(expCumDistForCorrM5p5);
        ArrayList<PlotCurveCharacterstics> chars2 = new ArrayList<PlotCurveCharacterstics>();
        chars2.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
        chars2.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, Color.BLACK));
        chars2.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 3.0f, Color.BLACK));
        GraphWindow magProbDistsGraph3 = new GraphWindow(mfdList3, "Expected Num Primary for M 5.5 Main Shock", chars2);
        magProbDistsGraph3.setX_AxisLabel("Magnitude (M)");
        magProbDistsGraph3.setY_AxisLabel("Num\u2265M (over the next year)");
        magProbDistsGraph3.setY_AxisRange(1.0E-6, 100.0);
        magProbDistsGraph3.setX_AxisRange(2.5, 8.5);
        magProbDistsGraph3.setYLog(true);
        magProbDistsGraph3.setPlotLabelFontSize(18);
        magProbDistsGraph3.setAxisLabelFontSize(22);
        magProbDistsGraph3.setTickLabelFontSize(20);
        String fileNamePrefix = name.replace(" ", "_").replace(",", "_");
        try {
            magProbDistsGraph1.saveAsPDF(fileNamePrefix + "_MFDs.pdf");
            magProbDistsGraph1.saveAsTXT(fileNamePrefix + "_MFDs.txt");
            magProbDistsGraph2.saveAsPDF(fileNamePrefix + "_MFDs_GRcorr.pdf");
            magProbDistsGraph2.saveAsTXT(fileNamePrefix + "_MFDs_GRcorr.txt");
            magProbDistsGraph3.saveAsPDF(fileNamePrefix + "_ExpNumM5p5.pdf");
            magProbDistsGraph3.saveAsTXT(fileNamePrefix + "_ExpNumM5p5.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writePolygonsForSubSections(String fileNamePrefix, int firstSubSectID, int lastSubSectID) {
        try {
            FileWriter fileWriterPolygons = new FileWriter(new File(GMT_CA_Maps.GMT_DIR, fileNamePrefix + ".txt"));
            fileWriterPolygons.write("lat\tlon\tdepth\n");
            for (int i = firstSubSectID; i <= lastSubSectID; ++i) {
                Object polygonString = "";
                for (Location loc : this.faultPolyMgr.getPoly(i).getBorder()) {
                    polygonString = (String)polygonString + (float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + loc.getDepth() + "\n";
                }
                fileWriterPolygons.write((String)polygonString);
            }
            fileWriterPolygons.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeTotSubSeisRateForSections(int firstSubSectID, int lastSubSectID) {
        double totRate = 0.0;
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        System.out.println("\nM\u22652.5 Subseis Rates for Subsections\n");
        for (int i = firstSubSectID; i <= lastSubSectID; ++i) {
            String name = this.rupSet.getFaultSectionData(i).getName();
            double rate = longTermSubSeisMFD_OnSectList.get(i).getCumRate(2.55);
            System.out.println("\t" + rate + "\t" + name);
            totRate += rate;
        }
        System.out.println("\ttotRate=" + totRate);
    }

    public SummedMagFreqDist getLongTermTotalERF_MFD() {
        return this.longTermMFDs.getLongTermTotalERF_MFD();
    }

    public IntegerPDF_FunctionSampler getExpectedAfterShockRateInCubesFromSupraRates(double numYears, ETAS_ParameterList etasParams, double multFactForAllGen, String dirName) {
        ProbabilityModelOptions probModel = (ProbabilityModelOptions)((Object)this.erf.getParameter("Probability Model").getValue());
        if (probModel != ProbabilityModelOptions.POISSON) {
            throw new RuntimeException("ERF must be Poisson");
        }
        double duration = this.fssERF.getTimeSpan().getDuration();
        double[] aftRateForEachParLocArray = new double[this.gridRegForParentLocs.getNodeCount()];
        CalcProgressBar progressBar = new CalcProgressBar("Looping over all points", "junk");
        progressBar.showProgress(true);
        for (int srcID = 0; srcID < this.fssERF.getNumFaultSystemSources(); ++srcID) {
            progressBar.updateProgress(srcID, this.fssERF.getNumFaultSystemSources());
            ProbEqkSource src = this.fssERF.getSource(srcID);
            if (src.getNumRuptures() > 1) {
                throw new RuntimeException("More than one rup per source not yet supported");
            }
            ProbEqkRupture rup = src.getRupture(0);
            double rupRate = rup.getMeanAnnualRate(duration);
            int fssRupIndex = this.fssERF.getFltSysRupIndexForSource(srcID);
            double numAftershocks = multFactForAllGen * ETAS_Utils.getExpectedNumEvents(etasParams.get_k(), etasParams.get_p(), rup.getMag(), 2.5, etasParams.get_c(), 0.0, numYears * 365.25);
            RuptureSurface surf = this.etas_utils.getRuptureSurfaceWithNoCreepReduction(fssRupIndex, this.fssERF, 1.0);
            LocationList locList = surf.getEvenlyDiscritizedListOfLocsOnSurface();
            double numSurfacePoints = locList.size();
            for (Location loc : locList) {
                int parLocIndex = this.getParLocIndexForLocation(loc);
                if (parLocIndex < 0 || parLocIndex >= aftRateForEachParLocArray.length) continue;
                int n = parLocIndex;
                aftRateForEachParLocArray[n] = aftRateForEachParLocArray[n] + rupRate * numAftershocks / numSurfacePoints;
                if (parLocIndex != aftRateForEachParLocArray.length - 1) continue;
                System.out.println("Bogus Point for Loc " + String.valueOf(loc));
            }
        }
        IntegerPDF_FunctionSampler aftRateInEachCubeSampler = new IntegerPDF_FunctionSampler(this.numCubes);
        for (int parLocIndex = 0; parLocIndex < aftRateForEachParLocArray.length; ++parLocIndex) {
            progressBar.updateProgress(parLocIndex, aftRateForEachParLocArray.length);
            double aftRate = aftRateForEachParLocArray[parLocIndex];
            if (!(aftRate > 0.0)) continue;
            IntegerPDF_FunctionSampler probInEachCubeSampler = this.getCubeSamplerWithOnlyDistDecay(parLocIndex);
            for (int cubeIndex = 0; cubeIndex < aftRateInEachCubeSampler.size(); ++cubeIndex) {
                double cubeRate = probInEachCubeSampler.getY(cubeIndex) * aftRate;
                double prevRate = aftRateInEachCubeSampler.getY(cubeIndex);
                aftRateInEachCubeSampler.set(cubeIndex, prevRate + cubeRate);
            }
        }
        progressBar.showProgress(false);
        if (dirName != null) {
            GMT_MapGenerator mapGen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
            CPTParameter cptParam = (CPTParameter)mapGen.getAdjustableParamsList().getParameter("Color Scheme");
            cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
            ((CPT)cptParam.getValue()).setBelowMinColor(Color.WHITE);
            mapGen.setParameter("Min Latitude", this.gridRegForCubes.getMinGridLat());
            mapGen.setParameter("Max Latitude", this.gridRegForCubes.getMaxGridLat());
            mapGen.setParameter("Min Longitude", this.gridRegForCubes.getMinGridLon());
            mapGen.setParameter("Max Longitude", this.gridRegForCubes.getMaxGridLon());
            mapGen.setParameter("Grid Spacing", this.gridRegForCubes.getLatSpacing());
            GriddedGeoDataSet xyzDataSet = new GriddedGeoDataSet(this.gridRegForCubes, true);
            double depth = 7.0;
            int depthIndex = this.getCubeDepthIndex(depth);
            int numCubesAtDepth = xyzDataSet.size();
            progressBar = new CalcProgressBar("Looping over all points", "junk");
            progressBar.showProgress(true);
            for (int i = 0; i < numCubesAtDepth; ++i) {
                progressBar.updateProgress(i, numCubesAtDepth);
                int samplerIndex = this.getCubeIndexForRegAndDepIndices(i, depthIndex);
                xyzDataSet.set(i, aftRateInEachCubeSampler.getY(samplerIndex));
            }
            progressBar.showProgress(false);
            mapGen.setParameter("Plot Log", true);
            mapGen.setParameter("Color Scale Limits", "Manually");
            mapGen.setParameter("Color-Scale Min", -7.0);
            mapGen.setParameter("Color-Scale Max", -1.0);
            Object metadata = "Map from calling getExpectedAfterShockRateInCubesFromSupraRates(*) method";
            try {
                String url = mapGen.makeMapUsingServlet(xyzDataSet, "M\u22652.5 Rates at " + depth + " km depth", (String)metadata, dirName);
                metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(mapGen.getGMTFilesWebAddress());
                ImageViewerWindow imgView = new ImageViewerWindow(url, (String)metadata, true);
                File downloadDir = new File(GMT_CA_Maps.GMT_DIR, dirName);
                if (!downloadDir.exists()) {
                    downloadDir.mkdir();
                }
                File zipFile = new File(downloadDir, "allFiles.zip");
                String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
                FileUtils.downloadURL(zipURL, zipFile);
                FileUtils.unzipFile(zipFile, downloadDir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return aftRateInEachCubeSampler;
    }

    public void getExpectedAfterShockRateInGridCellsFromSupraRates(double numYears, ETAS_ParameterList etasParams, double multFactForAllGen, String dirNameForCubeRates) {
        IntegerPDF_FunctionSampler sampler = this.getExpectedAfterShockRateInCubesFromSupraRates(numYears, etasParams, multFactForAllGen, dirNameForCubeRates);
        GriddedGeoDataSet ratesFromAshocks = new GriddedGeoDataSet(this.origGriddedRegion, true);
        double[] zVals = new double[this.origGriddedRegion.getNodeCount()];
        for (int cubeIndex = 0; cubeIndex < sampler.size(); ++cubeIndex) {
            Location loc = this.getCubeLocationForIndex(cubeIndex);
            int regIndex = this.origGriddedRegion.indexForLocation(loc);
            if (regIndex == -1) continue;
            int n = regIndex;
            zVals[n] = zVals[n] + sampler.getY(cubeIndex);
        }
        for (int i = 0; i < this.origGriddedRegion.getNodeCount(); ++i) {
            ratesFromAshocks.set(i, zVals[i]);
        }
        GriddedGeoDataSet origCellRates = ERF_Calculator.getNucleationRatesInRegion(this.erf, this.origGriddedRegion, 0.0, 10.0);
        GriddedGeoDataSet newCellRates = new GriddedGeoDataSet(this.origGriddedRegion, true);
        GriddedGeoDataSet rateRatios = new GriddedGeoDataSet(this.origGriddedRegion, true);
        double[] griddedSeisCorr = new double[rateRatios.size()];
        for (int i = 0; i < this.origGriddedRegion.getNodeCount(); ++i) {
            if (ratesFromAshocks.get(i) > origCellRates.get(i)) {
                newCellRates.set(i, ratesFromAshocks.get(i));
            } else {
                newCellRates.set(i, origCellRates.get(i));
            }
            rateRatios.set(i, newCellRates.get(i) / origCellRates.get(i));
            griddedSeisCorr[i] = rateRatios.get(i);
        }
        GMT_MapGenerator gmt_MapGenerator = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        gmt_MapGenerator.setParameter("Color-Scale Min", -3.5);
        gmt_MapGenerator.setParameter("Color-Scale Max", 1.5);
        CPTParameter cptParam = (CPTParameter)gmt_MapGenerator.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
        ((CPT)cptParam.getValue()).setBelowMinColor(Color.WHITE);
        try {
            MatrixIO.doubleArrayToFile(griddedSeisCorr, new File(defaultGriddedCorrFilename));
            GMT_CA_Maps.makeMap(ratesFromAshocks, "Aftershock Nucleation Rate", "test", "ExpAfterShockRateFromSupraMap", gmt_MapGenerator);
            GMT_CA_Maps.makeMap(origCellRates, "Original Nucleation Rate", "test", "OrigRateMap", gmt_MapGenerator);
            GMT_CA_Maps.makeMap(newCellRates, "Corrected Nucleation Rate", "test", "NewRateMap", gmt_MapGenerator);
            cptParam.setValue(GMT_CPT_Files.UCERF3_RATIOS.getFileName());
            gmt_MapGenerator.setParameter("Color-Scale Min", 2.0 - Math.floor(rateRatios.getMaxZ()));
            gmt_MapGenerator.setParameter("Color-Scale Max", Math.floor(rateRatios.getMaxZ()));
            gmt_MapGenerator.setParameter("Plot Log", false);
            System.out.println("Max Ratio = " + rateRatios.getMaxZ());
            GMT_CA_Maps.makeMap(rateRatios, "Corrected vs Original Ratio", "test", "NewVsOrigRateRatioMap", gmt_MapGenerator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ETAS_ParameterList etasParams = new ETAS_ParameterList();
        etasParams.setApplyGridSeisCorr(true);
        etasParams.setApplySubSeisForSupraNucl(true);
        etasParams.setImposeGR(false);
        etasParams.setU3ETAS_ProbModel(U3ETAS_ProbabilityModelOptions.POISSON);
        CaliforniaRegions.RELM_TESTING_GRIDDED griddedRegion = RELM_RegionUtils.getGriddedRegionInstance();
        long startTimeMillis = ETAS_Simulator.getTimeInMillisFromYear(2014.0);
        FaultSystemSolutionERF_ETAS erf = ETAS_Simulator.getU3_ETAS_ERF(startTimeMillis, 1.0, false);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        if (D) {
            System.out.println("Making ETAS_PrimaryEventSampler");
        }
        double[] sourceRates = new double[erf.getNumSources()];
        double duration = erf.getTimeSpan().getDuration();
        for (int s = 0; s < erf.getNumSources(); ++s) {
            sourceRates[s] = erf.getSource(s).computeTotalEquivMeanAnnualRate(duration);
        }
        ETAS_CubeDiscretizationParams cubeParams = new ETAS_CubeDiscretizationParams(griddedRegion);
        ETAS_LongTermMFDs longTermMFDs = new ETAS_LongTermMFDs(erf, etasParams.getApplySubSeisForSupraNucl());
        ETAS_PrimaryEventSampler etas_PrimEventSampler = new ETAS_PrimaryEventSampler(cubeParams, erf, longTermMFDs, sourceRates, null, etasParams, new ETAS_Utils(), null, null, null);
        etas_PrimEventSampler.plotMFDsForSubSect(2460);
        etas_PrimEventSampler.plotMFDsForSubSect(2159);
    }

    public ArrayList<ArrayList<Integer>> intArraysListFromFile(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null!");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"File doesn't exist!");
        long len = file.length();
        Preconditions.checkState((len > 0L ? 1 : 0) != 0, (Object)"file is empty!");
        Preconditions.checkState((len % 4L == 0L ? 1 : 0) != 0, (Object)"file size isn't evenly divisible by 4, thus not a sequence of double & integer values.");
        return this.intArraysListFromInputStream(new FileInputStream(file));
    }

    public ArrayList<ArrayList<Integer>> intArraysListFromInputStream(InputStream is) throws IOException {
        int i;
        DataInputStream in;
        int size;
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        Preconditions.checkState(((size = (in = new DataInputStream(is)).readInt()) > 0 ? 1 : 0) != 0, (Object)"Size must be > 0!");
        ArrayList<ArrayList<Integer>> list = new ArrayList<ArrayList<Integer>>();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (i = 0; i < this.totNumSrc; ++i) {
            idList.add(i);
        }
        for (i = 0; i < size; ++i) {
            int listSize = in.readInt();
            ArrayList<Integer> intList = new ArrayList<Integer>();
            for (int j = 0; j < listSize; ++j) {
                intList.add((Integer)idList.get(in.readInt()));
            }
            list.add(intList);
        }
        in.close();
        return list;
    }

    public List<EvenlyDiscretizedFunc> generateRuptureDiagnostics(ETAS_EqkRupture rupture, double expNum, String rupInfo, File resultsDir, Writer info_fileWriter) throws IOException {
        File subDirName;
        if (D) {
            System.out.println("Starting generateRuptureDiagnostics");
        }
        if (!(subDirName = new File(resultsDir, "Diagnostics_" + rupInfo)).exists()) {
            subDirName.mkdir();
        }
        IntegerPDF_FunctionSampler aveCubeSamplerForRup = this.getAveSamplerForRupture(rupture);
        double[] relSrcProbs = this.getRelativeTriggerProbOfEachSource(aveCubeSamplerForRup, 0.99, rupture);
        long st = System.currentTimeMillis();
        List<EvenlyDiscretizedFunc> expectedPrimaryMFDsForScenarioList = ETAS_SimAnalysisTools.getExpectedPrimaryMFDs_ForRup(rupInfo, new File(subDirName, rupInfo + "_ExpPrimMFD").getAbsolutePath(), this.getExpectedPrimaryMFD_PDF(relSrcProbs), rupture, expNum, this.fssERF.isPoisson());
        ETAS_SimAnalysisTools.plotExpectedPrimaryMFD_ForRup(rupInfo, new File(subDirName, rupInfo + "_ExpPrimMFD").getAbsolutePath(), expectedPrimaryMFDsForScenarioList, rupture, expNum);
        if (D) {
            System.out.println("expectedPrimaryMFDsForScenarioList took (msec) " + (System.currentTimeMillis() - st));
        }
        st = System.currentTimeMillis();
        this.plotSamplerMap(aveCubeSamplerForRup, "Primary Sampler for " + rupInfo, "PrimarySamplerMap_" + rupInfo, subDirName);
        if (D) {
            System.out.println("plotSamplerMap took (msec) " + (System.currentTimeMillis() - st));
        }
        st = System.currentTimeMillis();
        Object info = this.plotSubSectParticipationProbGivenRuptureAndReturnInfo(rupture, relSrcProbs, subDirName, 30, rupInfo, expNum, this.fssERF.isPoisson());
        if (D) {
            System.out.println("plotSubSectParticipationProbGivenRuptureAndReturnInfo took (msec) " + (System.currentTimeMillis() - st));
        }
        st = System.currentTimeMillis();
        info = (String)info + "\n\n" + this.plotSubSectTriggerProbGivenAllPrimayEvents(aveCubeSamplerForRup, subDirName, 30, rupInfo, expNum, this.fssERF.isPoisson(), rupture);
        if (D) {
            System.out.println("plotSubSectRelativeTriggerProbGivenSupraSeisRupture took (msec) " + (System.currentTimeMillis() - st));
        }
        if (D) {
            System.out.println((String)info);
        }
        info_fileWriter.write((String)info + "\n");
        return expectedPrimaryMFDsForScenarioList;
    }

    public String plotSamplerMap(IntegerPDF_FunctionSampler cubeSampler, String label, String dirName, File path) {
        int i;
        int i2;
        GMT_MapGenerator mapGen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)mapGen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
        mapGen.setParameter("Min Latitude", this.gridRegForCubes.getMinGridLat());
        mapGen.setParameter("Max Latitude", this.gridRegForCubes.getMaxGridLat());
        mapGen.setParameter("Min Longitude", this.gridRegForCubes.getMinGridLon());
        mapGen.setParameter("Max Longitude", this.gridRegForCubes.getMaxGridLon());
        mapGen.setParameter("Grid Spacing", this.gridRegForCubes.getLatSpacing());
        mapGen.setParameter("Plot Log", true);
        mapGen.setParameter("Color Scale Limits", "From Data");
        GriddedGeoDataSet xyzDataSet = new GriddedGeoDataSet(this.gridRegForCubes, true);
        for (i2 = 0; i2 < xyzDataSet.size(); ++i2) {
            xyzDataSet.set(i2, 0.0);
        }
        for (i2 = 0; i2 < this.numCubes; ++i2) {
            Location loc = this.getCubeLocationForIndex(i2);
            int mapLocIndex = this.gridRegForCubes.indexForLocation(loc);
            if (mapLocIndex < 0) continue;
            double oldRate = xyzDataSet.get(mapLocIndex);
            xyzDataSet.set(mapLocIndex, cubeSampler.getY(i2) + oldRate);
        }
        double sum = 0.0;
        for (i = 0; i < xyzDataSet.size(); ++i) {
            sum += xyzDataSet.get(i);
        }
        for (i = 0; i < xyzDataSet.size(); ++i) {
            xyzDataSet.set(i, xyzDataSet.get(i) / sum);
        }
        if (xyzDataSet.getMinZ() == 0.0) {
            int i3;
            double minNonZero = Double.MAX_VALUE;
            for (i3 = 0; i3 < xyzDataSet.size(); ++i3) {
                if (!(xyzDataSet.get(i3) > 0.0) || !(xyzDataSet.get(i3) < minNonZero)) continue;
                minNonZero = xyzDataSet.get(i3);
            }
            for (i3 = 0; i3 < xyzDataSet.size(); ++i3) {
                if (xyzDataSet.get(i3) != 0.0) continue;
                xyzDataSet.set(i3, minNonZero);
            }
        }
        Object metadata = "Map from calling plotSamplerMap(*) method";
        try {
            String url = mapGen.makeMapUsingServlet(xyzDataSet, label, (String)metadata, dirName);
            metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(mapGen.getGMTFilesWebAddress());
            ImageViewerWindow imgView = new ImageViewerWindow(url, (String)metadata, true);
            File downloadDir = null;
            downloadDir = path != null ? new File(path, dirName) : new File(dirName);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            File zipFile = new File(downloadDir, "allFiles.zip");
            String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
            FileUtils.downloadURL(zipURL, zipFile);
            FileUtils.unzipFile(zipFile, downloadDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "For Block Prob Map: " + mapGen.getGMTFilesWebAddress() + " (deleted at midnight)";
    }

    public String plotMaxMagAtDepthMap(double depth, String dirName) {
        GMT_MapGenerator mapGen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)mapGen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
        mapGen.setParameter("Min Latitude", this.gridRegForCubes.getMinGridLat());
        mapGen.setParameter("Max Latitude", this.gridRegForCubes.getMaxGridLat());
        mapGen.setParameter("Min Longitude", this.gridRegForCubes.getMinGridLon());
        mapGen.setParameter("Max Longitude", this.gridRegForCubes.getMaxGridLon());
        mapGen.setParameter("Grid Spacing", this.gridRegForCubes.getLatSpacing());
        mapGen.setParameter("Plot Log", false);
        mapGen.setParameter("Color Scale Limits", "Manually");
        mapGen.setParameter("Color-Scale Min", 6.0);
        mapGen.setParameter("Color-Scale Max", 8.5);
        GriddedGeoDataSet maxMagData = new GriddedGeoDataSet(this.gridRegForCubes, true);
        int depthIndex = this.getCubeDepthIndex(depth);
        int numCubesAtDepth = maxMagData.size();
        CalcProgressBar progressBar = new CalcProgressBar("Looping over all points", "junk");
        progressBar.showProgress(true);
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        for (int i = 0; i < numCubesAtDepth; ++i) {
            progressBar.updateProgress(i, numCubesAtDepth);
            int samplerIndex = this.getCubeIndexForRegAndDepIndices(i, depthIndex);
            SummedMagFreqDist mfd = this.getCubeMFD(samplerIndex);
            if (mfd == null) continue;
            maxMagData.set(i, mfd.getMaxMagWithNonZeroRate());
        }
        progressBar.showProgress(false);
        Object metadata = "Map from calling plotMaxMagAtDepthMap(*) method";
        try {
            String url = mapGen.makeMapUsingServlet(maxMagData, "Max Mag at " + depth + " km depth", (String)metadata, dirName);
            metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(mapGen.getGMTFilesWebAddress());
            ImageViewerWindow imgView = new ImageViewerWindow(url, (String)metadata, true);
            File downloadDir = new File(GMT_CA_Maps.GMT_DIR, dirName);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            File zipFile = new File(downloadDir, "allFiles.zip");
            String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
            FileUtils.downloadURL(zipURL, zipFile);
            FileUtils.unzipFile(zipFile, downloadDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "For Max Mag at depth Map: " + mapGen.getGMTFilesWebAddress() + " (deleted at midnight)";
    }

    public void testTotalSubSeisOnFaultMFD() {
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        SummedMagFreqDist mfd1 = new SummedMagFreqDist(2.05, 8.95, 70);
        for (int src = this.numFltSystSources; src < this.erf.getNumSources(); ++src) {
            if (this.mfdForSrcSubSeisOnlyArray[src] == null) continue;
            mfd1.addIncrementalMagFreqDist(this.mfdForSrcSubSeisOnlyArray[src]);
        }
        SummedMagFreqDist mfd2 = new SummedMagFreqDist(2.05, 8.95, 70);
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        for (IncrementalMagFreqDist incrementalMagFreqDist : longTermSubSeisMFD_OnSectList) {
            if (incrementalMagFreqDist == null) continue;
            mfd2.addIncrementalMagFreqDist(incrementalMagFreqDist);
        }
        ArrayList<SummedMagFreqDist> funcs = new ArrayList<SummedMagFreqDist>();
        funcs.add(mfd1);
        funcs.add(mfd2);
        GraphWindow graphWindow = new GraphWindow(funcs, "testTotalSubSeisOnFaultMFD()");
        graphWindow.setX_AxisLabel("Mag");
        graphWindow.setY_AxisLabel("Incr Rate");
        graphWindow.setYLog(true);
    }

    public void tempTestBulgeInCube() {
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        Location loc = new Location(35.82, -120.26, 7.0);
        int cubeIndex = this.getCubeIndexForLocation(loc);
        System.out.println("\ntempTestBulgeInCube()");
        Map<Integer, Double> sectFracMap = this.faultPolyMgr.getSectionFracsOnNode(this.origGriddedRegion.indexForLocation(loc));
        for (int sectID : sectFracMap.keySet()) {
            System.out.println(sectID + "\t" + String.valueOf(sectFracMap.get(sectID)) + "\t" + this.rupSet.getFaultSectionData(sectID).getName());
        }
        double aveGRcorr = this.getAveScalingFactorToImposeGR_supraRatesInCube(cubeIndex);
        System.out.println("aveGRcorr=" + aveGRcorr + "\t(from getAveScalingFactorToImposeGR_supraRatesInCube(cubeIndex))");
        SummedMagFreqDist mfdSupra = this.getCubeMFD_SupraSeisOnly(cubeIndex);
        SummedMagFreqDist mfdGridded = this.getCubeMFD_GriddedSeisOnly(cubeIndex);
        ETAS_Utils.getScalingFactorToImposeGR_supraRates(mfdSupra, mfdGridded, true);
        int index = 0;
        double rate1 = 0.0;
        double rate2 = 0.0;
        double rate3 = 0.0;
        SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray();
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        for (int sectID : this.sectInCubeList.get(cubeIndex)) {
            System.out.println("\n" + this.rupSet.getFaultSectionData(sectID).getName());
            int numCubesInsideFaultPolygon = this.numCubesInsideFaultPolygonArray[sectID];
            System.out.println("numCubesInsideFaultPolygonArray[sectID]=" + numCubesInsideFaultPolygon);
            System.out.println(sectID + "\t" + this.fractionSectInCubeList.get(cubeIndex)[index] + "\t" + (float)(1.0 / (double)numCubesInsideFaultPolygon));
            double val = ETAS_Utils.getScalingFactorToImposeGR_supraRates(longTermSupraSeisMFD_OnSectArray[sectID], longTermSubSeisMFD_OnSectList.get(sectID), true);
            System.out.println("\t" + this.grCorrFactorForSectArray[sectID] + " =? " + val);
            rate1 += val * longTermSupraSeisMFD_OnSectArray[sectID].getCumRate(2.55) / (double)this.numCubesInsideFaultPolygonArray[sectID];
            rate2 += this.totSectNuclRateArray[sectID] / (double)this.numCubesInsideFaultPolygonArray[sectID];
            for (int i = 0; i < this.srcNuclRateOnSects[sectID].size(); ++i) {
                rate3 += (double)(this.srcNuclRateOnSects[sectID].getSourceNucleationRate(i) / (float)this.numCubesInsideFaultPolygonArray[sectID]);
            }
            this.testSubSeisMFD_ForSect(sectID);
            ++index;
        }
        System.out.println("Test1\t" + rate1 + "\t" + mfdSupra.getTotalIncrRate());
        System.out.println("Test2\t" + rate2 + "\t" + mfdSupra.getTotalIncrRate());
        System.out.println("Test3\t" + rate3 + "\t" + mfdSupra.getTotalIncrRate());
    }

    public double getAveScalingFactorToImposeGR_supraRatesInCube(int cubeIndex) {
        double aveGRcorr = 0.0;
        double totRateSupra = 0.0;
        float[] fracArray = this.fractionSectInCubeList.get(cubeIndex);
        int[] sectArray = this.sectInCubeList.get(cubeIndex);
        if (fracArray.length == 0) {
            return this.getTrulyOffFaultGR_Corr(false);
        }
        SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray();
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        for (int i = 0; i < sectArray.length; ++i) {
            int sectID = sectArray[i];
            IncrementalMagFreqDist supraMFD = longTermSupraSeisMFD_OnSectArray[sectID].deepClone();
            IncrementalMagFreqDist subMFD = longTermSubSeisMFD_OnSectList.get(sectID).deepClone();
            if (supraMFD == null || subMFD == null) continue;
            supraMFD.scale(this.grCorrFactorForSectArray[sectID] * (double)fracArray[i]);
            subMFD.scale(1.0 / (double)this.numCubesInsideFaultPolygonArray[sectID]);
            double rate = supraMFD.getTotalIncrRate();
            double val = ETAS_Utils.getScalingFactorToImposeGR_supraRates(supraMFD, subMFD, false);
            aveGRcorr += rate * val;
            totRateSupra += rate;
        }
        return aveGRcorr / totRateSupra;
    }

    public void tempTestBulgeforCubesInSectPolygon(int sectID) {
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        Region faultPolygon = this.faultPolyMgr.getPoly(sectID);
        System.out.println("Section Polygon for " + this.rupSet.getFaultSectionData(sectID).getName() + "\n" + faultPolygon.getBorder().toString());
        SummedMagFreqDist[] longTermSupraSeisMFD_OnSectArray = this.longTermMFDs.getLongTermSupraSeisMFD_OnSectArray();
        List<? extends IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = this.longTermMFDs.getLongTermSubSeisMFD_OnSectList();
        double sectCorr = ETAS_Utils.getScalingFactorToImposeGR_supraRates(longTermSupraSeisMFD_OnSectArray[sectID], longTermSubSeisMFD_OnSectList.get(sectID), false);
        System.out.println("sect grCorr = " + sectCorr);
        for (int i = 0; i < this.numCubes; ++i) {
            Location cubeLoc = this.getCubeLocationForIndex(i);
            if (!faultPolygon.contains(cubeLoc)) continue;
            SummedMagFreqDist mfdSupra = this.getCubeMFD_SupraSeisOnly(i);
            SummedMagFreqDist mfdGridded = this.getCubeMFD_GriddedSeisOnly(i);
            double grCorr = ETAS_Utils.getScalingFactorToImposeGR_supraRates(mfdSupra, mfdGridded, false);
            int gridRegionIndex = this.origGriddedRegion.indexForLocation(cubeLoc);
            System.out.println(grCorr + "\t" + gridRegionIndex + "\t" + String.valueOf(cubeLoc));
        }
    }

    public String plotBulgeAtDepthMap(double depth, String dirName) {
        double minX;
        double maxX;
        GMT_MapGenerator mapGen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)mapGen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.UCERF3_RATIOS.getFileName());
        mapGen.setParameter("Min Latitude", this.gridRegForCubes.getMinGridLat());
        mapGen.setParameter("Max Latitude", this.gridRegForCubes.getMaxGridLat());
        mapGen.setParameter("Min Longitude", this.gridRegForCubes.getMinGridLon());
        mapGen.setParameter("Max Longitude", this.gridRegForCubes.getMaxGridLon());
        mapGen.setParameter("Grid Spacing", this.gridRegForCubes.getLatSpacing());
        mapGen.setParameter("Plot Log", true);
        mapGen.setParameter("Color Scale Limits", "Manually");
        mapGen.setParameter("Color-Scale Min", -3.0);
        mapGen.setParameter("Color-Scale Max", 3.0);
        GriddedGeoDataSet bulgeData = new GriddedGeoDataSet(this.gridRegForCubes, true);
        int depthIndex = this.getCubeDepthIndex(depth);
        int numCubesAtDepth = bulgeData.size();
        CalcProgressBar progressBar = new CalcProgressBar("Looping over all points", "junk");
        progressBar.showProgress(true);
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        for (int i = 0; i < numCubesAtDepth; ++i) {
            progressBar.updateProgress(i, numCubesAtDepth);
            int cubeIndex = this.getCubeIndexForRegAndDepIndices(i, depthIndex);
            int[] regAndDepIndex = this.getCubeRegAndDepIndicesForIndex(cubeIndex);
            double bulge = 1.0 / this.getAveScalingFactorToImposeGR_supraRatesInCube(cubeIndex);
            bulgeData.set(i, bulge);
        }
        progressBar.showProgress(false);
        Object metadata = "Map from calling plotBulgeDepthMap(*) method";
        try {
            String url = mapGen.makeMapUsingServlet(bulgeData, "CharFactor at " + depth + " km depth", (String)metadata, dirName);
            metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(mapGen.getGMTFilesWebAddress());
            ImageViewerWindow imgView = new ImageViewerWindow(url, (String)metadata, true);
            File downloadDir = new File(GMT_CA_Maps.GMT_DIR, dirName);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            File zipFile = new File(downloadDir, "allFiles.zip");
            String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
            FileUtils.downloadURL(zipURL, zipFile);
            FileUtils.unzipFile(zipFile, downloadDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double delta = Math.log10(1.01);
        double min = -4.0 + delta / 2.0;
        double max = 4.0;
        int num = (int)((max - min) / delta);
        HistogramFunction hist = new HistogramFunction(min, num, delta);
        for (int i = 0; i < bulgeData.size(); ++i) {
            if (this.isCubeInsideFaultPolygon[i] != 1) continue;
            hist.add(bulgeData.get(i), 1.0);
        }
        hist.normalizeBySumOfY_Vals();
        hist.setName("Histogram of log10 Values");
        HistogramFunction cumHist = hist.getCumulativeDistFunctionWithHalfBinOffset();
        cumHist.setInfo("Cumulative distribution");
        String info = "mean=" + (float)hist.computeMean() + "\nmedian=" + (float)cumHist.getFirstInterpolatedX(0.5) + "\nmode=" + (float)hist.getMode() + "\n" + hist.toString();
        hist.setInfo(info);
        cumHist.setInfo(info);
        ArrayList<HistogramFunction> funcList = new ArrayList<HistogramFunction>();
        funcList.add(hist);
        funcList.add(cumHist);
        GraphWindow graph = new GraphWindow(funcList, "Histogram of log10 Bulge Values for Cubes with Faults");
        graph.setX_AxisLabel("Log10(1.0/GRcorr)");
        graph.setY_AxisLabel("Num or Fraction");
        if (bulgeData.getMaxZ() - bulgeData.getMinZ() < delta / 10.0) {
            maxX = 1.0;
            minX = -1.0;
        } else {
            double absMax = Math.max(Math.abs(bulgeData.getMaxZ()), Math.abs(bulgeData.getMinZ()));
            maxX = absMax + delta / 2.0;
            minX = -absMax - delta / 2.0;
        }
        graph.setX_AxisRange(minX, maxX);
        File file = new File(new File(GMT_CA_Maps.GMT_DIR, dirName), "histogramForCubesWithFaults.pdf");
        try {
            graph.saveAsPDF(file.getAbsolutePath());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return "For Bulge at depth Map: " + mapGen.getGMTFilesWebAddress() + " (deleted at midnight)";
    }

    public String plotBulgeAtDepthAndAboveMagMap(double depth, double mag, String dirName) {
        GMT_MapGenerator mapGen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)mapGen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.UCERF3_RATIOS.getFileName());
        mapGen.setParameter("Min Latitude", this.gridRegForCubes.getMinGridLat());
        mapGen.setParameter("Max Latitude", this.gridRegForCubes.getMaxGridLat());
        mapGen.setParameter("Min Longitude", this.gridRegForCubes.getMinGridLon());
        mapGen.setParameter("Max Longitude", this.gridRegForCubes.getMaxGridLon());
        mapGen.setParameter("Grid Spacing", this.gridRegForCubes.getLatSpacing());
        mapGen.setParameter("Plot Log", true);
        mapGen.setParameter("Color Scale Limits", "Manually");
        mapGen.setParameter("Color-Scale Min", -3.0);
        mapGen.setParameter("Color-Scale Max", 3.0);
        GriddedGeoDataSet bulgeData = new GriddedGeoDataSet(this.gridRegForCubes, true);
        int depthIndex = this.getCubeDepthIndex(depth);
        int numCubesAtDepth = bulgeData.size();
        CalcProgressBar progressBar = new CalcProgressBar("Looping over all points", "junk");
        progressBar.showProgress(true);
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        for (int i = 0; i < numCubesAtDepth; ++i) {
            progressBar.updateProgress(i, numCubesAtDepth);
            int cubeIndex = this.getCubeIndexForRegAndDepIndices(i, depthIndex);
            if (this.getCubeMFD_GriddedSeisOnly(cubeIndex) == null) {
                bulgeData.set(i, 1.0);
                continue;
            }
            double rate1 = this.getCubeMFD_GriddedSeisOnly(cubeIndex).getCumRate(2.55) * Math.pow(10.0, 2.5 - mag);
            if (rate1 == 0.0) {
                bulgeData.set(i, 1.0);
                continue;
            }
            SummedMagFreqDist supraMFD = this.getCubeMFD_SupraSeisOnly(cubeIndex);
            int magIndex = supraMFD.getClosestXIndex(mag);
            double rate2 = this.getCubeMFD_SupraSeisOnly(cubeIndex).getCumRate(magIndex);
            bulgeData.set(i, rate2 / rate1);
        }
        progressBar.showProgress(false);
        Object metadata = "Map from calling plotBulgeAtDepthAndAboveMagMap(*) method";
        try {
            String url = mapGen.makeMapUsingServlet(bulgeData, "CharFactor at " + depth + " km depth and mag>=" + mag, (String)metadata, dirName);
            metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(mapGen.getGMTFilesWebAddress());
            ImageViewerWindow imgView = new ImageViewerWindow(url, (String)metadata, true);
            File downloadDir = new File(GMT_CA_Maps.GMT_DIR, dirName);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            File zipFile = new File(downloadDir, "allFiles.zip");
            String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
            FileUtils.downloadURL(zipURL, zipFile);
            FileUtils.unzipFile(zipFile, downloadDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double delta = Math.log10(1.01);
        double min = -4.0 + delta / 2.0;
        double max = 4.0;
        int num = (int)((max - min) / delta);
        HistogramFunction hist = new HistogramFunction(min, num, delta);
        for (int i = 0; i < bulgeData.size(); ++i) {
            if (this.isCubeInsideFaultPolygon[i] != 1 || !(bulgeData.get(i) >= hist.getMinX()) || !(bulgeData.get(i) <= hist.getMaxX())) continue;
            hist.add(bulgeData.get(i), 1.0);
        }
        hist.normalizeBySumOfY_Vals();
        hist.setName("Histogram of log10 Values");
        HistogramFunction cumHist = hist.getCumulativeDistFunctionWithHalfBinOffset();
        cumHist.setInfo("Cumulative distribution");
        String info = "mean=" + (float)hist.computeMean() + "\nmedian=" + (float)cumHist.getFirstInterpolatedX(0.5) + "\nmode=" + (float)hist.getMode() + "\n" + hist.toString();
        hist.setInfo(info);
        info = "mean=" + (float)hist.computeMean() + "\nmedian=" + (float)cumHist.getFirstInterpolatedX(0.5) + "\nmode=" + (float)hist.getMode() + "\n" + cumHist.toString();
        cumHist.setInfo(info);
        ArrayList<HistogramFunction> funcList = new ArrayList<HistogramFunction>();
        funcList.add(hist);
        funcList.add(cumHist);
        GraphWindow graph = new GraphWindow(funcList, "Histogram of log10 Bulge Values for Cubes with Faults");
        graph.setX_AxisLabel("Log10(1.0/GRcorr)");
        graph.setY_AxisLabel("Num or Fraction");
        double maxX = 3.0;
        double minX = -3.0;
        graph.setX_AxisRange(minX, maxX);
        File file = new File(new File(GMT_CA_Maps.GMT_DIR, dirName), "histogramForCubesWithFaults.pdf");
        try {
            graph.saveAsPDF(file.getAbsolutePath());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return "For Bulge at depth Map: " + mapGen.getGMTFilesWebAddress() + " (deleted at midnight)";
    }

    public String plotRateAtDepthMap(double depth, double mag, String dirName) {
        GMT_MapGenerator mapGen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)mapGen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
        ((CPT)cptParam.getValue()).setBelowMinColor(Color.WHITE);
        mapGen.setParameter("Min Latitude", this.gridRegForCubes.getMinGridLat());
        mapGen.setParameter("Max Latitude", this.gridRegForCubes.getMaxGridLat());
        mapGen.setParameter("Min Longitude", this.gridRegForCubes.getMinGridLon());
        mapGen.setParameter("Max Longitude", this.gridRegForCubes.getMaxGridLon());
        mapGen.setParameter("Grid Spacing", this.gridRegForCubes.getLatSpacing());
        GriddedGeoDataSet xyzDataSet = new GriddedGeoDataSet(this.gridRegForCubes, true);
        int depthIndex = this.getCubeDepthIndex(depth);
        int numCubesAtDepth = xyzDataSet.size();
        CalcProgressBar progressBar = new CalcProgressBar("Looping over all points", "junk");
        progressBar.showProgress(true);
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        int magIndex = this.mfdForSrcArray[0].getClosestXIndex(mag);
        for (int i = 0; i < numCubesAtDepth; ++i) {
            progressBar.updateProgress(i, numCubesAtDepth);
            int samplerIndex = this.getCubeIndexForRegAndDepIndices(i, depthIndex);
            SummedMagFreqDist mfd = this.getCubeMFD(samplerIndex);
            double rate = 0.0;
            if (mfd != null) {
                rate = this.getCubeMFD(samplerIndex).getCumRate(magIndex);
            }
            if (rate == 0.0) {
                rate = 1.0E-16;
            }
            xyzDataSet.set(i, rate);
        }
        progressBar.showProgress(false);
        mapGen.setParameter("Plot Log", true);
        mapGen.setParameter("Color Scale Limits", "Manually");
        if (mag < 5.0) {
            mapGen.setParameter("Color-Scale Min", -5.0);
            mapGen.setParameter("Color-Scale Max", -1.0);
        } else {
            mapGen.setParameter("Color-Scale Min", -9.0);
            mapGen.setParameter("Color-Scale Max", -4.0);
        }
        Object metadata = "Map from calling plotRateAtDepthMap(*) method";
        try {
            String url = mapGen.makeMapUsingServlet(xyzDataSet, "M\u2265" + mag + " Rates at " + depth + " km depth", (String)metadata, dirName);
            metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(mapGen.getGMTFilesWebAddress());
            ImageViewerWindow imgView = new ImageViewerWindow(url, (String)metadata, true);
            File downloadDir = new File(GMT_CA_Maps.GMT_DIR, dirName);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            File zipFile = new File(downloadDir, "allFiles.zip");
            String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
            FileUtils.downloadURL(zipURL, zipFile);
            FileUtils.unzipFile(zipFile, downloadDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "For rates at depth above mag map: " + mapGen.getGMTFilesWebAddress() + " (deleted at midnight)";
    }

    public String plotRatesOnlySamplerAtDepthMap(double depth, String dirName) {
        GMT_MapGenerator mapGen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)mapGen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
        ((CPT)cptParam.getValue()).setBelowMinColor(Color.WHITE);
        mapGen.setParameter("Min Latitude", this.gridRegForCubes.getMinGridLat());
        mapGen.setParameter("Max Latitude", this.gridRegForCubes.getMaxGridLat());
        mapGen.setParameter("Min Longitude", this.gridRegForCubes.getMinGridLon());
        mapGen.setParameter("Max Longitude", this.gridRegForCubes.getMaxGridLon());
        mapGen.setParameter("Grid Spacing", this.gridRegForCubes.getLatSpacing());
        GriddedGeoDataSet xyzDataSet = new GriddedGeoDataSet(this.gridRegForCubes, true);
        int depthIndex = this.getCubeDepthIndex(depth);
        int numCubesAtDepth = xyzDataSet.size();
        CalcProgressBar progressBar = new CalcProgressBar("Looping over all points", "junk");
        progressBar.showProgress(true);
        this.getCubeSamplerWithERF_GriddedRatesOnly();
        for (int i = 0; i < numCubesAtDepth; ++i) {
            progressBar.updateProgress(i, numCubesAtDepth);
            int samplerIndex = this.getCubeIndexForRegAndDepIndices(i, depthIndex);
            double rate = this.cubeSamplerGriddedRatesOnly.getY(samplerIndex);
            if (rate <= 1.0E-16) {
                rate = 1.0E-16;
            }
            xyzDataSet.set(i, rate);
        }
        progressBar.showProgress(false);
        mapGen.setParameter("Plot Log", true);
        mapGen.setParameter("Color Scale Limits", "Manually");
        mapGen.setParameter("Color-Scale Min", -7.0);
        mapGen.setParameter("Color-Scale Max", -1.0);
        Object metadata = "Map from calling plotSamplerAtDepthMap(*) method";
        try {
            String url = mapGen.makeMapUsingServlet(xyzDataSet, "Rates at depth=" + depth, (String)metadata, dirName);
            metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(mapGen.getGMTFilesWebAddress());
            ImageViewerWindow imgView = new ImageViewerWindow(url, (String)metadata, true);
            File downloadDir = new File(GMT_CA_Maps.GMT_DIR, dirName);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            File zipFile = new File(downloadDir, "allFiles.zip");
            String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
            FileUtils.downloadURL(zipURL, zipFile);
            FileUtils.unzipFile(zipFile, downloadDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "For rates at depth above mag map: " + mapGen.getGMTFilesWebAddress() + " (deleted at midnight)";
    }

    public String plotRandomSampleRatesMap(String dirName, int numYrs) {
        GMT_MapGenerator mapGen = new GMT_MapGenerator();
        mapGen.setParameter("Apply GMT Smoothing?", false);
        mapGen.setParameter("Topo Resolution", "No Topo");
        mapGen.setParameter("Min Latitude", 31.5);
        mapGen.setParameter("Max Latitude", 43.0);
        mapGen.setParameter("Min Longitude", -125.4);
        mapGen.setParameter("Max Longitude", -113.0);
        mapGen.setParameter("Plot Log", true);
        mapGen.setParameter("Color Scale Limits", "Manually");
        mapGen.setParameter("Color-Scale Min", -2.0);
        mapGen.setParameter("Color-Scale Max", 1.0);
        CaliforniaRegions.RELM_TESTING_GRIDDED mapGriddedRegion = RELM_RegionUtils.getGriddedRegionInstance();
        GriddedGeoDataSet xyzDataSet = new GriddedGeoDataSet(mapGriddedRegion, true);
        for (int i = 0; i < xyzDataSet.size(); ++i) {
            xyzDataSet.set(i, 0.0);
        }
        this.getCubeSamplerWithERF_GriddedRatesOnly();
        this.totRate = this.cubeSamplerGriddedRatesOnly.calcSumOfY_Vals();
        long numSamples = (long)numYrs * (long)this.totRate;
        System.out.println("num random samples for map test = " + numSamples + "\ntotRate=" + this.totRate);
        CalcProgressBar progressBar = new CalcProgressBar("Looping random samples", "junk");
        progressBar.showProgress(true);
        for (long i = 0L; i < numSamples; ++i) {
            progressBar.updateProgress(i, numSamples);
            int indexFromSampler = this.cubeSamplerGriddedRatesOnly.getRandomInt(this.etas_utils.getRandomDouble());
            int[] regAndDepIndex = this.getCubeRegAndDepIndicesForIndex(indexFromSampler);
            int indexForMap = mapGriddedRegion.indexForLocation(this.gridRegForCubes.locationForIndex(regAndDepIndex[0]));
            if (indexForMap <= 0) continue;
            double oldNum = xyzDataSet.get(indexForMap) * (double)numYrs;
            xyzDataSet.set(indexForMap, (1.0 + oldNum) / (double)numYrs);
        }
        progressBar.showProgress(false);
        if (D) {
            System.out.println("RandomSampleRatesMap: min=" + xyzDataSet.getMinZ() + "; max=" + xyzDataSet.getMaxZ());
        }
        Object metadata = "Map from calling RandomSampleRatesMap() method";
        try {
            String url = mapGen.makeMapUsingServlet(xyzDataSet, "RandomSampleRatesMap", (String)metadata, dirName);
            metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(mapGen.getGMTFilesWebAddress());
            ImageViewerWindow imgView = new ImageViewerWindow(url, (String)metadata, true);
            File downloadDir = new File(GMT_CA_Maps.GMT_DIR, dirName);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            File zipFile = new File(downloadDir, "allFiles.zip");
            String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
            FileUtils.downloadURL(zipURL, zipFile);
            FileUtils.unzipFile(zipFile, downloadDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "For RandomSampleRatesMap: " + mapGen.getGMTFilesWebAddress() + " (deleted at midnight)";
    }
}

