/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.DocumentException;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSetMath;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.mapping.gmt.GMT_Map;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_MultiSimAnalysisTools;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class HaywiredSRL_PaperCalc {
    private static final double gridRegDiscr = 0.02;

    private static void calcFractWithinRegion(double[] mags, File binFile, Region region, long maxOT) {
        int[] countsWithin = new int[mags.length];
        int[] countsTotal = new int[mags.length];
        int catalogCount = 0;
        for (List catalog : ETAS_CatalogIO.getBinaryCatalogsIterable(binFile, StatUtils.min((double[])mags))) {
            ETAS_EqkRupture rup;
            if (catalogCount++ % 5000 == 0) {
                System.out.println("Processing catalog " + catalogCount);
            }
            Iterator iterator = catalog.iterator();
            while (iterator.hasNext() && (rup = (ETAS_EqkRupture)iterator.next()).getOriginTime() <= maxOT) {
                double mag = rup.getMag();
                boolean inside = region.contains(rup.getHypocenterLocation());
                for (int i = 0; i < mags.length; ++i) {
                    if (!(mag >= mags[i])) continue;
                    Preconditions.checkState((countsTotal[i] < Integer.MAX_VALUE ? 1 : 0) != 0);
                    int n = i;
                    countsTotal[n] = countsTotal[n] + 1;
                    if (!inside) continue;
                    int n2 = i;
                    countsWithin[n2] = countsWithin[n2] + 1;
                }
            }
        }
        for (int i = 0; i < mags.length; ++i) {
            System.out.println("M>=" + mags[i]);
            double fract = (double)countsWithin[i] / (double)countsTotal[i];
            System.out.println(countsWithin[i] + "/" + countsTotal[i] + " = " + (float)fract + " within");
        }
    }

    public static GriddedGeoDataSet calcTINucleation(GriddedRegion reg, FaultSystemSolution sol, double duration, double minMag) {
        int index;
        System.out.println("Caching sect to node mappings with " + reg.getNodeCount() + " nodes");
        ArrayList sectFractNodesMaps = new ArrayList();
        FaultSystemRupSet rupSet = sol.getRupSet();
        for (int s = 0; s < rupSet.getNumSections(); ++s) {
            HashMap<Integer, Double> sectFractNodesMap = new HashMap<Integer, Double>();
            sectFractNodesMaps.add(sectFractNodesMap);
            RuptureSurface surf = rupSet.getFaultSectionData(s).getFaultSurface(1.0);
            LocationList locs = surf.getEvenlyDiscritizedListOfLocsOnSurface();
            double fractEach = 1.0 / (double)locs.size();
            for (Object loc : locs) {
                index = reg.indexForLocation((Location)loc);
                if (index < 0) continue;
                Double fract = (Double)sectFractNodesMap.get(index);
                if (fract == null) {
                    fract = 0.0;
                }
                fract = fract + fractEach;
                sectFractNodesMap.put(index, fract);
            }
        }
        System.out.println("Calculating supra-seismogenic");
        GriddedGeoDataSet map = new GriddedGeoDataSet(reg, false);
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            double rate = sol.getRateForRup(r) * duration;
            for (int s : rupSet.getSectionsIndicesForRup(r)) {
                Object loc;
                Map nodeMappings = (Map)sectFractNodesMaps.get(s);
                loc = nodeMappings.keySet().iterator();
                while (loc.hasNext()) {
                    index = (Integer)loc.next();
                    map.set(index, map.get(index) + rate * (Double)nodeMappings.get(index));
                }
            }
        }
        System.out.println("Associating low res to high res grid indexes");
        HashMap<Integer, ArrayList<Integer>> lowToHighResIndexMap = new HashMap<Integer, ArrayList<Integer>>();
        GridSourceProvider gridProv = sol.getGridSourceProvider();
        GriddedRegion lowResReg = gridProv.getGriddedRegion();
        for (int i = 0; i < reg.getNodeCount(); ++i) {
            Location loc = reg.getLocation(i);
            int lowResIndex = lowResReg.indexForLocation(loc);
            ArrayList<Integer> indexes = (ArrayList<Integer>)lowToHighResIndexMap.get(lowResIndex);
            if (indexes == null) {
                indexes = new ArrayList<Integer>();
                lowToHighResIndexMap.put(lowResIndex, indexes);
            }
            indexes.add(i);
        }
        System.out.println("Calculating gridded");
        for (int lowResIndex = 0; lowResIndex < gridProv.getNumLocations(); ++lowResIndex) {
            List indexes = (List)lowToHighResIndexMap.get(lowResIndex);
            IncrementalMagFreqDist mfd = gridProv.getMFD(lowResIndex);
            double rateAbove = 0.0;
            for (Point2D pt : mfd) {
                if (!(pt.getX() >= minMag)) continue;
                rateAbove += pt.getY();
            }
            double rateEach = (rateAbove *= duration) / (double)indexes.size();
            Iterator iterator = indexes.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                map.set(i, map.get(i) + rateEach);
            }
        }
        System.out.println("DONE");
        return map;
    }

    private static void writeGriddedRegCSV(GriddedGeoDataSet map, File csvFile) throws IOException {
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine("Index", "Value");
        for (int i = 0; i < map.size(); ++i) {
            csv.addLine("" + i, "" + map.get(i));
        }
        csv.writeToFile(csvFile);
    }

    private static GriddedGeoDataSet loadGriddedRegCSV(GriddedRegion reg, File csvFile) throws IOException {
        GriddedGeoDataSet map = new GriddedGeoDataSet(reg, false);
        CSVFile<String> csv = CSVFile.readFile(csvFile, true);
        for (int row = 1; row < csv.getNumRows(); ++row) {
            int index = Integer.parseInt(csv.get(row, 0));
            double val = Double.parseDouble(csv.get(row, 1));
            map.set(index, val);
        }
        return map;
    }

    public static GriddedGeoDataSet calcETASNucleation(GriddedRegion reg, File binFile, long maxOT, double minMag) {
        GriddedGeoDataSet map = new GriddedGeoDataSet(reg, false);
        int catalogCount = 0;
        for (List catalog : ETAS_CatalogIO.getBinaryCatalogsIterable(binFile, minMag)) {
            ETAS_EqkRupture rup;
            if (catalogCount++ % 5000 == 0) {
                System.out.println("Processing catalog " + catalogCount);
            }
            Iterator iterator = catalog.iterator();
            while (iterator.hasNext() && (rup = (ETAS_EqkRupture)iterator.next()).getOriginTime() <= maxOT) {
                int index = reg.indexForLocation(rup.getHypocenterLocation());
                if (index < 0) continue;
                map.set(index, map.get(index) + 1.0);
            }
        }
        map.scale(1.0 / (double)catalogCount);
        return map;
    }

    private static void plotRatio(GriddedRegion gridReg, GeoDataSet numerator, GeoDataSet denominator, CPT cpt, String label, boolean log, File outputDir, String prefix) throws GMT_MapException, IOException {
        GeoDataSet ratio = GeoDataSetMath.divide(numerator, denominator);
        for (int i = 0; i < ratio.size(); ++i) {
            if (Double.isFinite(ratio.get(i)) && ratio.get(i) != 0.0) continue;
            ratio.set(i, Double.NaN);
        }
        if (log) {
            ratio.log10();
        }
        Region plotReg = new Region(new Location(gridReg.getMinGridLat(), gridReg.getMinGridLon()), new Location(gridReg.getMaxGridLat(), gridReg.getMaxGridLon()));
        GMT_Map map = FaultBasedMapGen.buildMap(cpt, null, null, ratio, gridReg.getSpacing(), plotReg, false, label);
        FaultBasedMapGen.plotMap(outputDir, prefix, false, map);
    }

    public static void main(String[] args) throws IOException, DocumentException, GMT_MapException {
        FaultBasedMapGen.SAVE_ZIPS = true;
        FaultBasedMapGen.LOCAL_MAPGEN = true;
        File outputDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/haywired_srl");
        File nuclMapDir = new File(outputDir, "nucleation_rate_maps");
        Preconditions.checkState((nuclMapDir.exists() || nuclMapDir.mkdir() ? 1 : 0) != 0);
        File faultParticDir = new File(outputDir, "fault_participation");
        Preconditions.checkState((faultParticDir.exists() || faultParticDir.mkdir() ? 1 : 0) != 0);
        long otScenario = 1325419200000L;
        long otScenarioOneWeek = otScenario + 604800000L;
        long otScenarioOneYear = otScenario + 31557600000L;
        long otScenarioTenYear = otScenario + 315576000000L;
        double durationOneWeek = 0.019164955509924708;
        boolean calcFractInReg = false;
        boolean plotFaultGainTI = false;
        boolean plotGriddedGainTI = false;
        boolean plotFaultGriddedRatio = false;
        boolean plotFaultPartics = true;
        File faultSimDir = new File("/data/kevin/ucerf3/etas/simulations/2016_06_15-haywired_m7-10yr-full_td-no_ert-combined");
        File faultFullFile = new File(faultSimDir, "results_descendents.bin");
        File faultM5File = new File(faultSimDir, "results_descendents_m5.bin");
        File griddedSimDir = new File("/data/kevin/ucerf3/etas/simulations/2017_01_02-haywired_m7-10yr-gridded-only-200kcombined");
        File griddedFullFile = new File(griddedSimDir, "results_descendents_combined.bin");
        File griddedM5File = new File(griddedSimDir, "results_descendents_m5_preserve.bin");
        File fssFile = new File("/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip");
        U3FaultSystemSolution refSol = null;
        if (calcFractInReg) {
            HaywiredSRL_PaperCalc.calcFractWithinRegion(new double[]{2.5, 5.0}, faultFullFile, new CaliforniaRegions.SF_BOX(), otScenarioOneWeek);
        }
        GriddedRegion reg = new GriddedRegion(new CaliforniaRegions.RELM_TESTING(), 0.02, GriddedRegion.ANCHOR_0_0);
        File tiNucleationFile = new File(nuclMapDir, "u3_ti_nucleation_one_week.csv");
        GriddedGeoDataSet tiNucleation = null;
        if (tiNucleationFile.exists()) {
            System.out.println("Loading TI nucleation file");
            tiNucleation = HaywiredSRL_PaperCalc.loadGriddedRegCSV(reg, tiNucleationFile);
        } else {
            refSol = U3FaultSystemIO.loadSol(fssFile);
            tiNucleation = HaywiredSRL_PaperCalc.calcTINucleation(reg, refSol, durationOneWeek, 2.5);
            HaywiredSRL_PaperCalc.writeGriddedRegCSV(tiNucleation, tiNucleationFile);
        }
        File etasFaultNuclFile = new File(nuclMapDir, "etas_fault_based_one_week.csv");
        GriddedGeoDataSet etasFaultNucl = null;
        if (etasFaultNuclFile.exists()) {
            System.out.println("Loading ETAS fault based nucleation");
            etasFaultNucl = HaywiredSRL_PaperCalc.loadGriddedRegCSV(reg, etasFaultNuclFile);
        } else {
            System.out.println("Calculating ETAS fault based nucleation");
            etasFaultNucl = HaywiredSRL_PaperCalc.calcETASNucleation(reg, faultFullFile, otScenarioOneWeek, 2.5);
            HaywiredSRL_PaperCalc.writeGriddedRegCSV(etasFaultNucl, etasFaultNuclFile);
        }
        File etasGriddedNuclFile = new File(nuclMapDir, "etas_gridded_one_week.csv");
        GriddedGeoDataSet etasGriddedNucl = null;
        if (etasGriddedNuclFile.exists()) {
            System.out.println("Loading ETAS gridded nucleation");
            etasGriddedNucl = HaywiredSRL_PaperCalc.loadGriddedRegCSV(reg, etasGriddedNuclFile);
        } else {
            System.out.println("Calculating ETAS gridded nucleation");
            etasGriddedNucl = HaywiredSRL_PaperCalc.calcETASNucleation(reg, griddedFullFile, otScenarioOneWeek, 2.5);
            HaywiredSRL_PaperCalc.writeGriddedRegCSV(etasGriddedNucl, etasGriddedNuclFile);
        }
        CPT logGainCPT = GMT_CPT_Files.UCERF3_ETAS_GAIN.instance().rescale(0.0, 1.0);
        int i = logGainCPT.size();
        while (--i >= 0) {
            if (!(((CPTVal)logGainCPT.get((int)i)).start <= 0.5)) continue;
            logGainCPT.remove(i);
        }
        logGainCPT = logGainCPT.rescale(0.0, 4.0);
        logGainCPT.setBelowMinColor(logGainCPT.getMinColor());
        GeoDataSet faultPlusTI = GeoDataSetMath.add(etasFaultNucl, tiNucleation);
        if (plotFaultGainTI) {
            HaywiredSRL_PaperCalc.plotRatio(reg, faultPlusTI, tiNucleation, logGainCPT, "Log10 Gain Fault ETAS/U3TI", true, nuclMapDir, "gain_fault_vs_ti");
        }
        GeoDataSet griddedPlusTI = GeoDataSetMath.add(etasGriddedNucl, tiNucleation);
        if (plotGriddedGainTI) {
            HaywiredSRL_PaperCalc.plotRatio(reg, griddedPlusTI, tiNucleation, logGainCPT, "Log10 Gain Gridded ETAS/U3TI", true, nuclMapDir, "gain_gridded_vs_ti");
        }
        CPT ratioCPT = GMT_CPT_Files.GMT_POLAR.instance().rescale(-2.0, 2.0);
        ratioCPT.setNanColor(Color.WHITE);
        if (plotFaultGriddedRatio) {
            HaywiredSRL_PaperCalc.plotRatio(reg, faultPlusTI, griddedPlusTI, ratioCPT, "Log10 Fault/Gridded ETAS", true, nuclMapDir, "ratio_fault_gridded");
        }
        if (plotFaultPartics) {
            if (refSol == null) {
                refSol = U3FaultSystemIO.loadSol(fssFile);
            }
            double[] faultMinMags = new double[]{0.0, 6.7, 7.8};
            List<ETAS_CatalogIO.ETAS_Catalog> catalogs = ETAS_CatalogIO.loadCatalogsBinary(faultM5File);
            CPT particCPT = CPT.loadFromFile(new File(faultParticDir, "faultPartRate.cpt"));
            CPT particGainCPT = CPT.loadFromFile(new File(faultParticDir, "faultPartGain.cpt"));
            ETAS_MultiSimAnalysisTools.plotSectRates(catalogs, 0.019164955509924708, ((FaultSystemSolution)refSol).getRupSet(), faultMinMags, faultParticDir, "1 Week", "week", otScenarioOneWeek, refSol, true, particCPT, particGainCPT);
            ETAS_MultiSimAnalysisTools.plotSectRates(catalogs, 1.0, ((FaultSystemSolution)refSol).getRupSet(), faultMinMags, faultParticDir, "1 Year", "year", otScenarioOneYear, refSol, true, particCPT, particGainCPT);
            ETAS_MultiSimAnalysisTools.plotSectRates(catalogs, 10.0, ((FaultSystemSolution)refSol).getRupSet(), faultMinMags, faultParticDir, "10 Year", "ten_year", otScenarioTenYear, refSol, true, particCPT, particGainCPT);
        }
    }
}

