/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.analysis;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;

public class ETAS_EventMapPlotUtils {
    static final float rup_surface_thickness = 3.0f;
    private static final DecimalFormat optionalDigitDF = new DecimalFormat("0.#");

    public static Region getMapRegion(ETAS_Config config, ETAS_Launcher launcher) {
        List<ETAS_EqkRupture> triggerRups;
        Region mapRegion;
        ETAS_Config.ComcatMetadata meta = config.getComcatMetadata();
        Region region = mapRegion = meta == null ? null : meta.region;
        if (mapRegion == null && (triggerRups = launcher.getCombinedTriggers()) != null && !triggerRups.isEmpty()) {
            DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
            DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
            for (ETAS_EqkRupture rup : triggerRups) {
                for (Location loc : rup.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface()) {
                    latTrack.addValue(loc.getLatitude());
                    lonTrack.addValue(loc.getLongitude());
                }
            }
            mapRegion = ETAS_EventMapPlotUtils.getMapRegion(latTrack, lonTrack);
        }
        return mapRegion;
    }

    static Region getMapRegion(DataUtils.MinMaxAveTracker latTrack, DataUtils.MinMaxAveTracker lonTrack) {
        double maxSpan = Math.max(latTrack.getMax() - latTrack.getMin(), lonTrack.getMax() - lonTrack.getMin());
        double centerLat = 0.5 * (latTrack.getMax() + latTrack.getMin());
        double centerLon = 0.5 * (lonTrack.getMax() + lonTrack.getMin());
        System.out.println("Lon range: " + lonTrack.getMin() + " " + lonTrack.getMax());
        System.out.println("Lat range: " + latTrack.getMin() + " " + latTrack.getMax());
        System.out.println("Center: " + centerLat + ", " + centerLon);
        System.out.println("Span: " + maxSpan);
        double halfSpan = maxSpan * 0.5;
        Location topRight = new Location(centerLat + halfSpan, centerLon + halfSpan);
        Location bottomLeft = new Location(centerLat - halfSpan, centerLon - halfSpan);
        topRight = LocationUtils.location(topRight, new LocationVector(45.0, 20.0, 0.0));
        bottomLeft = LocationUtils.location(bottomLeft, new LocationVector(225.0, 20.0, 0.0));
        Region mapRegion = new Region(topRight, bottomLeft);
        return mapRegion;
    }

    static void buildEventPlot(List<? extends ObsEqkRupture> events, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars) throws IOException {
        ETAS_EventMapPlotUtils.buildEventPlot(events, funcs, chars, 0.0);
    }

    private static DiscretizedFunc getDefaultMagSizeFunc() {
        ArbitrarilyDiscretizedFunc magSizeFunc = new ArbitrarilyDiscretizedFunc();
        magSizeFunc.set(2.0, 2.0);
        while (magSizeFunc.getMaxX() < 8.0) {
            magSizeFunc.set(magSizeFunc.getMaxX() + 1.0, magSizeFunc.getMaxY() * 1.5);
        }
        return magSizeFunc;
    }

    private static void initializeMagFuncs(List<Range> magRanges, List<PlotCurveCharacterstics> magChars, List<XY_DataSet> magXYs, double maxMag, DataUtils.MinMaxAveTracker magTrack, CPT magCPT, Color fixedColor) {
        DiscretizedFunc magSizeFunc = ETAS_EventMapPlotUtils.getDefaultMagSizeFunc();
        if (!(maxMag > 0.0)) {
            maxMag = magTrack.getMax();
        }
        double minFilledMag = 5.0;
        if (maxMag <= 3.0) {
            magSizeFunc.scale(2.0);
            minFilledMag = 2.0;
        } else if (maxMag <= 4.0) {
            magSizeFunc.scale(1.5);
            minFilledMag = 3.0;
        } else if (maxMag <= 5.0) {
            magSizeFunc.scale(1.25);
            minFilledMag = 4.0;
        }
        double magCeil = Math.ceil(maxMag);
        double magFloor = Math.floor(magTrack.getMin());
        if (magCeil == maxMag || magFloor == magCeil) {
            magCeil += 1.0;
        }
        if (magCPT != null) {
            magCPT = magCeil == magFloor + 1.0 ? magCPT.rescale(magFloor - 1.0, magFloor) : magCPT.rescale(magFloor, magCeil - 1.0);
        }
        double minMag = magFloor;
        while ((float)minMag < (float)magCeil) {
            PlotSymbol symbol;
            double myMaxMag = minMag + 1.0;
            magRanges.add(new Range(minMag, myMaxMag));
            PlotSymbol plotSymbol = symbol = (float)minMag >= (float)minFilledMag ? PlotSymbol.FILLED_CIRCLE : PlotSymbol.CIRCLE;
            double symbolWidth = minMag < magSizeFunc.getMinX() ? magSizeFunc.getMinY() : (minMag > magSizeFunc.getMaxX() ? magSizeFunc.getMaxY() : magSizeFunc.getInterpolatedY(minMag));
            Color color = magCPT == null ? fixedColor : magCPT.getColor((float)minMag);
            PlotCurveCharacterstics plotChar = new PlotCurveCharacterstics(symbol, (float)symbolWidth, color);
            magChars.add(plotChar);
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            if (minMag == magFloor && magTrack.getMin() >= minMag + 0.11) {
                xy.setName("M" + optionalDigitDF.format(magTrack.getMin()));
            } else {
                xy.setName("M" + (int)minMag);
            }
            magXYs.add(xy);
            minMag += 1.0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void buildEventPlot(List<? extends ObsEqkRupture> events, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, double maxMag) throws IOException {
        int i;
        if (events.isEmpty()) {
            return;
        }
        DataUtils.MinMaxAveTracker magTrack = new DataUtils.MinMaxAveTracker();
        for (ObsEqkRupture obsEqkRupture : events) {
            magTrack.addValue(obsEqkRupture.getMag());
        }
        PlotCurveCharacterstics singleQuakeChar = null;
        Object var7_7 = null;
        ArrayList<PlotCurveCharacterstics> magChars = null;
        ArrayList<XY_DataSet> magXYs = null;
        CPT magCPT = GMT_CPT_Files.GMT_DRYWET.instance().reverse();
        if (events.size() > 1) {
            ArrayList<Range> arrayList = new ArrayList<Range>();
            magChars = new ArrayList<PlotCurveCharacterstics>();
            magXYs = new ArrayList<XY_DataSet>();
            ETAS_EventMapPlotUtils.initializeMagFuncs(arrayList, magChars, magXYs, maxMag, magTrack, magCPT, null);
        } else {
            DiscretizedFunc magSizeFunc = ETAS_EventMapPlotUtils.getDefaultMagSizeFunc();
            double mag = events.get(0).getMag();
            double d = mag < magSizeFunc.getMinX() ? magSizeFunc.getMinY() : (mag > magSizeFunc.getMaxX() ? magSizeFunc.getMaxY() : magSizeFunc.getInterpolatedY(mag));
            singleQuakeChar = new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, (float)d, magCPT.getMaxColor());
        }
        ArrayList<XY_DataSet> surfXYs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> surfChars = new ArrayList<PlotCurveCharacterstics>();
        for (ObsEqkRupture obsEqkRupture : events) {
            RuptureSurface surf;
            PlotCurveCharacterstics plotChar;
            XY_DataSet ptXY;
            double mag = obsEqkRupture.getMag();
            Location hypo = obsEqkRupture.getHypocenterLocation();
            if (singleQuakeChar != null) {
                ptXY = new DefaultXY_DataSet();
                ptXY.setName("M" + (float)mag);
                plotChar = singleQuakeChar;
                if (hypo != null) {
                    funcs.add(ptXY);
                    chars.add(plotChar);
                }
            } else {
                void var7_9;
                ptXY = null;
                plotChar = null;
                for (int i2 = 0; i2 < var7_9.size(); ++i2) {
                    Range magRange = (Range)var7_9.get(i2);
                    if (!(mag >= magRange.getLowerBound()) || !(mag < magRange.getUpperBound())) continue;
                    ptXY = (XY_DataSet)magXYs.get(i2);
                    plotChar = (PlotCurveCharacterstics)magChars.get(i2);
                }
                Preconditions.checkNotNull((Object)ptXY, (String)"No mag ranges found which contain M=%s", (Object)mag);
            }
            if ((surf = obsEqkRupture.getRuptureSurface()) != null && !surf.isPointSurface()) {
                List<XY_DataSet> mySurfXYs = ETAS_EventMapPlotUtils.getSurfOutlines(surf);
                PlotCurveCharacterstics surfChar = new PlotCurveCharacterstics(PlotLineType.DOTTED, 2.0f, plotChar.getColor());
                for (XY_DataSet surfXY : mySurfXYs) {
                    surfXYs.add(surfXY);
                    surfChars.add(surfChar);
                }
                mySurfXYs = ETAS_EventMapPlotUtils.getSurfTraces(surf);
                surfChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, plotChar.getColor());
                for (XY_DataSet surfXY : mySurfXYs) {
                    surfXYs.add(surfXY);
                    surfChars.add(surfChar);
                }
            }
            if (hypo == null) continue;
            ptXY.set(hypo.getLongitude(), hypo.getLatitude());
        }
        funcs.addAll(surfXYs);
        chars.addAll(surfChars);
        for (i = 0; magXYs != null && i < magXYs.size(); ++i) {
            XY_DataSet xY_DataSet = (XY_DataSet)magXYs.get(i);
            if (xY_DataSet.size() <= 0) continue;
            funcs.add(xY_DataSet);
            chars.add((PlotCurveCharacterstics)magChars.get(i));
        }
        if (magXYs != null) {
            for (i = 0; i < surfXYs.size(); ++i) {
                funcs.add((XY_DataSet)surfXYs.get(i));
                PlotCurveCharacterstics plotCurveCharacterstics = (PlotCurveCharacterstics)surfChars.get(i);
                Color c = plotCurveCharacterstics.getColor();
                c = plotCurveCharacterstics.getLineType() == PlotLineType.SOLID ? new Color(c.getRed(), c.getGreen(), c.getBlue(), 220) : new Color(c.getRed(), c.getGreen(), c.getBlue(), 127);
                chars.add(new PlotCurveCharacterstics(plotCurveCharacterstics.getLineType(), plotCurveCharacterstics.getLineWidth(), c));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void buildGenerationPlot(List<? extends ETAS_EqkRupture> events, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, double maxMag, int maxGeneration) throws IOException {
        void var16_30;
        void var16_28;
        void var16_26;
        int gen;
        if (events.isEmpty()) {
            return;
        }
        DataUtils.MinMaxAveTracker magTrack = new DataUtils.MinMaxAveTracker();
        for (ObsEqkRupture obsEqkRupture : events) {
            magTrack.addValue(obsEqkRupture.getMag());
        }
        int minGeneration = maxGeneration - 1;
        for (ETAS_EqkRupture eTAS_EqkRupture : events) {
            minGeneration = Integer.min(minGeneration, eTAS_EqkRupture.getGeneration());
        }
        Color[] colorArray = new Color[1 + maxGeneration - minGeneration];
        Color[] colorArray2 = new Color[]{Color.BLUE.darker(), Color.CYAN.darker().darker(), Color.GREEN.darker(), Color.ORANGE.darker(), Color.RED.darker(), Color.MAGENTA.darker()};
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = colorArray2[i % colorArray2.length];
        }
        ArrayList<ArrayList<Range>> genMagRanges = new ArrayList<ArrayList<Range>>();
        ArrayList<Object> genMagChars = new ArrayList<Object>();
        ArrayList<ArrayList<XY_DataSet>> genMagXYs = new ArrayList<ArrayList<XY_DataSet>>();
        for (int g = 0; g <= maxGeneration; ++g) {
            ArrayList<Range> magRanges = new ArrayList<Range>();
            genMagRanges.add(magRanges);
            ArrayList magChars = new ArrayList();
            genMagChars.add(magChars);
            ArrayList<XY_DataSet> arrayList = new ArrayList<XY_DataSet>();
            genMagXYs.add(arrayList);
            ETAS_EventMapPlotUtils.initializeMagFuncs(magRanges, magChars, arrayList, maxMag, magTrack, null, colorArray[Integer.max(0, g - minGeneration)]);
        }
        ArrayList<XY_DataSet> surfXYs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> surfChars = new ArrayList<PlotCurveCharacterstics>();
        for (ETAS_EqkRupture eTAS_EqkRupture : events) {
            gen = eTAS_EqkRupture.getGeneration();
            Preconditions.checkState((gen >= 0 ? 1 : 0) != 0);
            if (gen > maxGeneration) {
                gen = maxGeneration;
            }
            List magRanges = (List)genMagRanges.get(gen);
            List magChars = (List)genMagChars.get(gen);
            List magXYs = (List)genMagXYs.get(gen);
            double mag = eTAS_EqkRupture.getMag();
            XY_DataSet ptXY = null;
            PlotCurveCharacterstics plotChar = null;
            Location hypo = eTAS_EqkRupture.getHypocenterLocation();
            for (int i = 0; i < magRanges.size(); ++i) {
                Range magRange = (Range)magRanges.get(i);
                if (!(mag >= magRange.getLowerBound()) || !(mag < magRange.getUpperBound())) continue;
                ptXY = (XY_DataSet)magXYs.get(i);
                plotChar = (PlotCurveCharacterstics)magChars.get(i);
            }
            Preconditions.checkNotNull(ptXY, (String)"No mag ranges found which contain M=%s", (Object)mag);
            RuptureSurface surf = eTAS_EqkRupture.getRuptureSurface();
            if (surf != null && !surf.isPointSurface()) {
                List<XY_DataSet> mySurfXYs = ETAS_EventMapPlotUtils.getSurfOutlines(surf);
                PlotCurveCharacterstics surfChar = new PlotCurveCharacterstics(PlotLineType.DOTTED, 2.0f, plotChar.getColor());
                for (XY_DataSet surfXY : mySurfXYs) {
                    surfXYs.add(surfXY);
                    surfChars.add(surfChar);
                }
                mySurfXYs = ETAS_EventMapPlotUtils.getSurfTraces(surf);
                surfChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, plotChar.getColor());
                for (XY_DataSet surfXY : mySurfXYs) {
                    surfXYs.add(surfXY);
                    surfChars.add(surfChar);
                }
            }
            if (hypo == null) continue;
            ptXY.set(hypo.getLongitude(), hypo.getLatitude());
        }
        funcs.addAll(surfXYs);
        chars.addAll(surfChars);
        boolean firstGen = true;
        boolean bl = false;
        while (var16_26 <= maxGeneration) {
            boolean labeled = false;
            List magXYs = (List)genMagXYs.get((int)var16_26);
            for (int m = 0; m < magXYs.size(); ++m) {
                XY_DataSet magXY = (XY_DataSet)magXYs.get(m);
                if (magXY.size() == 0) continue;
                if (labeled) {
                    magXY.setName(null);
                    continue;
                }
                Object name = firstGen ? "Generation " : "";
                name = (String)name + (int)var16_26;
                if (var16_26 == maxGeneration) {
                    name = (String)name + "+";
                }
                magXY.setName((String)name);
                labeled = true;
                firstGen = false;
            }
            ++var16_26;
        }
        boolean bl2 = false;
        while (var16_28 < ((List)genMagXYs.get(0)).size()) {
            for (gen = 0; gen <= maxGeneration; ++gen) {
                PlotCurveCharacterstics magChar = (PlotCurveCharacterstics)((List)genMagChars.get(gen)).get((int)var16_28);
                XY_DataSet magXY = (XY_DataSet)((List)genMagXYs.get(gen)).get((int)var16_28);
                if (magXY.size() <= 0) continue;
                funcs.add(magXY);
                chars.add(magChar);
                if (magChar.getSymbol() == null || !magChar.getSymbol().isFilled()) continue;
                PlotCurveCharacterstics outlineChar = new PlotCurveCharacterstics(PlotSymbol.CIRCLE, magChar.getSymbolWidth(), new Color(0, 0, 0, 100));
                if (magXY.getName() != null) {
                    magXY = magXY.deepClone();
                    magXY.setName(null);
                }
                funcs.add(magXY);
                chars.add(outlineChar);
            }
            ++var16_28;
        }
        boolean bl3 = false;
        while (var16_30 < surfXYs.size()) {
            funcs.add((XY_DataSet)surfXYs.get((int)var16_30));
            PlotCurveCharacterstics surfChar = (PlotCurveCharacterstics)surfChars.get((int)var16_30);
            Color c = surfChar.getColor();
            c = surfChar.getLineType() == PlotLineType.SOLID ? new Color(c.getRed(), c.getGreen(), c.getBlue(), 220) : new Color(c.getRed(), c.getGreen(), c.getBlue(), 127);
            chars.add(new PlotCurveCharacterstics(surfChar.getLineType(), surfChar.getLineWidth(), c));
            ++var16_30;
        }
    }

    public static List<XY_DataSet> getSurfTraces(RuptureSurface surf) {
        ArrayList<? extends RuptureSurface> allSurfs = new ArrayList<RuptureSurface>();
        if (surf instanceof CompoundSurface) {
            allSurfs.addAll(((CompoundSurface)surf).getSurfaceList());
        } else {
            allSurfs.add(surf);
        }
        ArrayList<XY_DataSet> ret = new ArrayList<XY_DataSet>();
        for (RuptureSurface ruptureSurface : allSurfs) {
            DefaultXY_DataSet surfXY = new DefaultXY_DataSet();
            for (Location loc : ruptureSurface.getEvenlyDiscritizedUpperEdge()) {
                surfXY.set(loc.getLongitude(), loc.getLatitude());
            }
            ret.add(surfXY);
        }
        return ret;
    }

    public static List<XY_DataSet> getSurfOutlines(RuptureSurface surf) {
        double dip;
        try {
            dip = surf.getAveDip();
        }
        catch (Exception e) {
            dip = 45.0;
        }
        ArrayList<? extends RuptureSurface> allSurfs = new ArrayList<RuptureSurface>();
        if (surf instanceof CompoundSurface) {
            allSurfs.addAll(((CompoundSurface)surf).getSurfaceList());
        } else {
            allSurfs.add(surf);
        }
        ArrayList<XY_DataSet> ret = new ArrayList<XY_DataSet>();
        for (RuptureSurface ruptureSurface : allSurfs) {
            DefaultXY_DataSet surfXY;
            if (dip == 90.0) {
                surfXY = new DefaultXY_DataSet();
                for (Location loc : ruptureSurface.getEvenlyDiscritizedUpperEdge()) {
                    surfXY.set(loc.getLongitude(), loc.getLatitude());
                }
                ret.add(surfXY);
                continue;
            }
            if (surf instanceof EvenlyGriddedSurface) {
                EvenlyGriddedSurface gridSurf = (EvenlyGriddedSurface)surf;
                DefaultXY_DataSet topXY = new DefaultXY_DataSet();
                DefaultXY_DataSet botXY = new DefaultXY_DataSet();
                for (int col = 0; col < gridSurf.getNumCols(); ++col) {
                    Location topLoc = (Location)gridSurf.get(0, col);
                    Location botLoc = (Location)gridSurf.get(gridSurf.getNumRows() - 1, col);
                    topXY.set(topLoc.getLongitude(), topLoc.getLatitude());
                    botXY.set(botLoc.getLongitude(), botLoc.getLatitude());
                }
                DefaultXY_DataSet leftXY = new DefaultXY_DataSet();
                DefaultXY_DataSet rightXY = new DefaultXY_DataSet();
                for (int row = 0; row < gridSurf.getNumRows(); ++row) {
                    Location leftLoc = (Location)gridSurf.get(row, 0);
                    Location rightLoc = (Location)gridSurf.get(row, gridSurf.getNumCols() - 1);
                    leftXY.set(leftLoc.getLongitude(), leftLoc.getLatitude());
                    rightXY.set(rightLoc.getLongitude(), rightLoc.getLatitude());
                }
                ret.add(topXY);
                ret.add(botXY);
                ret.add(leftXY);
                ret.add(rightXY);
                continue;
            }
            try {
                surfXY = new DefaultXY_DataSet();
                for (Location loc : ruptureSurface.getPerimeter()) {
                    surfXY.set(loc.getLongitude(), loc.getLatitude());
                }
                surfXY.set(surfXY.get(0));
                ret.add(surfXY);
            }
            catch (UnsupportedOperationException e) {
                System.err.println("Skipping surface in map, cannot get perimeter: " + e.getMessage());
            }
        }
        return ret;
    }

    private static double traceDist(FaultTrace trace, Location loc) {
        return LocationUtils.distanceToLine(trace.first(), trace.last(), loc);
    }

    static void writeMapPlot(List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, Region mapRegion, String title, File outputDir, String prefix) throws IOException {
        ETAS_EventMapPlotUtils.writeMapPlot(funcs, chars, mapRegion, title, outputDir, prefix, 1000);
    }

    public static HeadlessGraphPanel writeMapPlot(List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, Region mapRegion, String title, File outputDir, String prefix, int width) throws IOException {
        PlotSpec spec = new PlotSpec(funcs, chars, title, "Longitude", "Latitude");
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = ETAS_AbstractPlot.buildGraphPanel();
        double latSpan = mapRegion.getMaxLat() - mapRegion.getMinLat();
        double lonSpan = mapRegion.getMaxLon() - mapRegion.getMinLon();
        gp.setUserBounds(new Range(mapRegion.getMinLon(), mapRegion.getMaxLon()), new Range(mapRegion.getMinLat(), mapRegion.getMaxLat()));
        gp.drawGraphPanel(spec, false, false);
        TickUnits tus = new TickUnits();
        NumberTickUnit tu = lonSpan > 5.0 ? new NumberTickUnit(1.0) : (lonSpan > 2.0 ? new NumberTickUnit(0.5) : (lonSpan > 1.0 ? new NumberTickUnit(0.25) : new NumberTickUnit(0.1)));
        tus.add((TickUnit)tu);
        XYPlot plot = gp.getPlot();
        plot.getRangeAxis().setStandardTickUnits((TickUnitSource)tus);
        plot.getDomainAxis().setStandardTickUnits((TickUnitSource)tus);
        int height = PlotUtils.calcHeight(gp, width, true);
        gp.getChartPanel().setSize(width, height);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        return gp;
    }

    static FaultTrace getUpperEdge(RuptureSurface surf) {
        try {
            return surf.getUpperEdge();
        }
        catch (Exception e) {
            return surf.getEvenlyDiscritizedUpperEdge();
        }
    }

    static void buildEventDepthPlot(List<ETAS_EqkRupture> events, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, RuptureSurface surf) throws IOException {
        FaultTrace trace;
        if (events.isEmpty() || surf == null || surf.isPointSurface()) {
            return;
        }
        if (surf instanceof CompoundSurface) {
            List<? extends RuptureSurface> subSurfs = ((CompoundSurface)surf).getSurfaceList();
            ArrayList<Location[]> pairs = new ArrayList<Location[]>();
            for (int i = 0; i < subSurfs.size(); ++i) {
                FaultTrace tr1 = ETAS_EventMapPlotUtils.getUpperEdge(subSurfs.get(i));
                pairs.add(new Location[]{tr1.first(), tr1.last()});
                for (int j = i + 1; j < subSurfs.size(); ++j) {
                    FaultTrace faultTrace = ETAS_EventMapPlotUtils.getUpperEdge(subSurfs.get(j));
                    pairs.add(new Location[]{tr1.first(), faultTrace.first()});
                    pairs.add(new Location[]{tr1.first(), faultTrace.last()});
                    pairs.add(new Location[]{tr1.last(), faultTrace.first()});
                    pairs.add(new Location[]{tr1.last(), faultTrace.last()});
                }
            }
            Location[] furthestPair = null;
            double furthestDist = 0.0;
            for (Location[] pair : pairs) {
                double dist = LocationUtils.horzDistanceFast(pair[0], pair[1]);
                if (!(dist > furthestDist)) continue;
                furthestDist = dist;
                furthestPair = pair;
            }
            trace = new FaultTrace(null);
            trace.add(furthestPair[0]);
            trace.add(furthestPair[1]);
        } else {
            trace = ETAS_EventMapPlotUtils.getUpperEdge(surf);
        }
        PlotCurveCharacterstics rupBelowChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK);
        PlotCurveCharacterstics rupAboveChar = new PlotCurveCharacterstics(PlotLineType.DOTTED, 4.0f, Color.BLACK);
        ArrayList<DefaultXY_DataSet> rupFuncs = new ArrayList<DefaultXY_DataSet>();
        ArrayList<? extends RuptureSurface> subSurfs = new ArrayList<RuptureSurface>();
        if (surf instanceof CompoundSurface) {
            subSurfs.addAll(((CompoundSurface)surf).getSurfaceList());
        } else {
            subSurfs.add(surf);
        }
        for (RuptureSurface ruptureSurface : subSurfs) {
            XY_DataSet xy = new DefaultXY_DataSet();
            if (rupFuncs.isEmpty()) {
                xy.setName("Rupture Surface");
            }
            if (ruptureSurface instanceof EvenlyGriddedSurface) {
                EvenlyGriddedSurface gridSurf = (EvenlyGriddedSurface)ruptureSurface;
                Location topLeft = (Location)gridSurf.get(0, 0);
                Location botLeft = (Location)gridSurf.get(gridSurf.getNumRows() - 1, 0);
                Location topRight = (Location)gridSurf.get(0, gridSurf.getNumCols() - 1);
                Location botRight = (Location)gridSurf.get(gridSurf.getNumRows() - 1, gridSurf.getNumCols() - 1);
                xy.set(ETAS_EventMapPlotUtils.traceDist(trace, topLeft), topLeft.getDepth());
                xy.set(ETAS_EventMapPlotUtils.traceDist(trace, topRight), topRight.getDepth());
                xy.set(ETAS_EventMapPlotUtils.traceDist(trace, botLeft), botLeft.getDepth());
                xy.set(ETAS_EventMapPlotUtils.traceDist(trace, botRight), botRight.getDepth());
                xy.set(ETAS_EventMapPlotUtils.traceDist(trace, topLeft), topLeft.getDepth());
            } else {
                FaultTrace upper = ruptureSurface.getEvenlyDiscritizedUpperEdge();
                LocationList lower = ruptureSurface.getEvenlyDiscritizedLowerEdge();
                for (Location loc : upper) {
                    xy.set(ETAS_EventMapPlotUtils.traceDist(trace, loc), loc.getDepth());
                }
                int j = lower.size();
                while (--j >= 0) {
                    xy.set(ETAS_EventMapPlotUtils.traceDist(trace, (Location)lower.get(j)), ((Location)lower.get(j)).getDepth());
                }
                xy.set(ETAS_EventMapPlotUtils.traceDist(trace, upper.first()), upper.first().getDepth());
            }
            rupFuncs.add((DefaultXY_DataSet)xy);
            if (xy.getName() != null) {
                xy = xy.deepClone();
                xy.setName(null);
            }
            funcs.add(xy);
            chars.add(rupBelowChar);
        }
        DataUtils.MinMaxAveTracker magTrack = new DataUtils.MinMaxAveTracker();
        for (ETAS_EqkRupture rup : events) {
            magTrack.addValue(rup.getMag());
        }
        Object var10_18 = null;
        ArrayList<PlotCurveCharacterstics> magChars = null;
        ArrayList<DefaultXY_DataSet> magXYs = null;
        CPT magCPT = GMT_CPT_Files.GMT_DRYWET.instance().reverse();
        ArbitrarilyDiscretizedFunc magSizeFunc = new ArbitrarilyDiscretizedFunc();
        magSizeFunc.set(2.0, 2.0);
        while (magSizeFunc.getMaxX() < 8.0) {
            magSizeFunc.set(magSizeFunc.getMaxX() + 1.0, magSizeFunc.getMaxY() * 1.5);
        }
        double maxMag = magTrack.getMax();
        double minFilledMag = maxMag > 7.0 ? 6.0 : 5.0;
        ArrayList<Range> arrayList = new ArrayList<Range>();
        magChars = new ArrayList<PlotCurveCharacterstics>();
        magXYs = new ArrayList<DefaultXY_DataSet>();
        double magCeil = Math.ceil(maxMag);
        double magFloor = Math.floor(magTrack.getMin());
        if (magCeil == maxMag || magFloor == magCeil) {
            magCeil += 1.0;
        }
        magCPT = magCeil == magFloor + 1.0 ? magCPT.rescale(magFloor - 1.0, magFloor) : magCPT.rescale(magFloor, magCeil - 1.0);
        double minMag = magFloor;
        while ((float)minMag < (float)magCeil) {
            PlotSymbol symbol;
            double myMaxMag = minMag + 1.0;
            arrayList.add(new Range(minMag, myMaxMag));
            PlotSymbol plotSymbol = symbol = (float)minMag >= (float)minFilledMag ? PlotSymbol.FILLED_CIRCLE : PlotSymbol.CIRCLE;
            double symbolWidth = minMag < magSizeFunc.getMinX() ? magSizeFunc.getMinY() : (minMag > magSizeFunc.getMaxX() ? magSizeFunc.getMaxY() : magSizeFunc.getInterpolatedY(minMag));
            Color color = magCPT.getColor((float)minMag);
            PlotCurveCharacterstics plotChar = new PlotCurveCharacterstics(symbol, (float)symbolWidth, color);
            magChars.add(plotChar);
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            xy.setName("M" + (int)minMag);
            magXYs.add(xy);
            minMag += 1.0;
        }
        for (ETAS_EqkRupture eTAS_EqkRupture : events) {
            if (eTAS_EqkRupture.getHypocenterLocation() == null) continue;
            double mag = eTAS_EqkRupture.getMag();
            XY_DataSet ptXY = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                Range magRange = (Range)arrayList.get(i);
                if (!(mag >= magRange.getLowerBound()) || !(mag < magRange.getUpperBound())) continue;
                ptXY = (XY_DataSet)magXYs.get(i);
            }
            Preconditions.checkNotNull(ptXY);
            Location hypo = eTAS_EqkRupture.getHypocenterLocation();
            ptXY.set(ETAS_EventMapPlotUtils.traceDist(trace, hypo), hypo.getDepth());
        }
        for (int i = 0; magXYs != null && i < magXYs.size(); ++i) {
            XY_DataSet xY_DataSet = (XY_DataSet)magXYs.get(i);
            if (xY_DataSet.size() <= 0) continue;
            funcs.add(xY_DataSet);
            chars.add((PlotCurveCharacterstics)magChars.get(i));
        }
        for (XY_DataSet xY_DataSet : rupFuncs) {
            funcs.add(xY_DataSet);
            chars.add(rupAboveChar);
        }
    }

    static void writeDepthPlot(List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, String title, File outputDir, String prefix) throws IOException {
        PlotSpec spec = new PlotSpec(funcs, chars, title, "Fault Normal Distance (km)", "Depth (km)");
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = ETAS_AbstractPlot.buildGraphPanel();
        DataUtils.MinMaxAveTracker depthTrack = new DataUtils.MinMaxAveTracker();
        for (XY_DataSet func : funcs) {
            depthTrack.addValue(func.getMinY());
            depthTrack.addValue(func.getMaxY());
        }
        double maxDepth = Math.ceil(depthTrack.getMax()) + 2.0;
        Range xRange = new Range(-maxDepth, maxDepth);
        Range yRange = new Range(0.0, maxDepth);
        gp.drawGraphPanel(spec, false, false, xRange, yRange);
        XYPlot plot = gp.getPlot();
        plot.getRangeAxis().setInverted(true);
        gp.getChartPanel().setSize(1000, 600);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
    }
}

