/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.analysis;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.mapping.gmt.GMT_Map;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_MFD_Plot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;

public class ETAS_GriddedNucleationPlot
extends ETAS_AbstractPlot {
    private static double[] mags = new double[]{2.5, 5.0, 6.0, 7.0};
    private static double discr = 0.02;
    private GriddedRegion reg;
    private GriddedGeoDataSet[] totalXYZs;
    private GriddedGeoDataSet[] triggeredXYZs;
    private GriddedGeoDataSet[] triggeredPrimaryXYZs;
    private int numCatalogs = 0;
    private int numRupsSkipped = 0;
    private IncrementalMagFreqDist totalIncrCounts;
    private double modalMag;
    private String prefix;
    private boolean annualize;
    private boolean hasSpont;
    private boolean hasTriggered;
    private boolean ratio_spread_across_poly = false;

    protected ETAS_GriddedNucleationPlot(ETAS_Config config, ETAS_Launcher launcher, String prefix, boolean annualize) {
        super(config, launcher);
        int i;
        this.prefix = prefix;
        this.annualize = annualize;
        this.reg = new GriddedRegion(new CaliforniaRegions.RELM_TESTING(), discr, GriddedRegion.ANCHOR_0_0);
        this.hasTriggered = config.hasTriggers();
        boolean bl = this.hasSpont = config.isIncludeSpontaneous() || config.getTriggerCatalogFile() != null && config.isTreatTriggerCatalogAsSpontaneous();
        if (this.hasSpont) {
            this.totalXYZs = new GriddedGeoDataSet[mags.length];
            for (i = 0; i < mags.length; ++i) {
                this.totalXYZs[i] = new GriddedGeoDataSet(this.reg, false);
            }
        }
        if (this.hasTriggered) {
            this.triggeredXYZs = new GriddedGeoDataSet[mags.length];
            this.triggeredPrimaryXYZs = new GriddedGeoDataSet[mags.length];
            for (i = 0; i < mags.length; ++i) {
                this.triggeredXYZs[i] = new GriddedGeoDataSet(this.reg, false);
                this.triggeredPrimaryXYZs[i] = new GriddedGeoDataSet(this.reg, false);
            }
        }
        this.totalIncrCounts = new IncrementalMagFreqDist(ETAS_MFD_Plot.mfdMinMag, ETAS_MFD_Plot.mfdNumMag, ETAS_MFD_Plot.mfdDelta);
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public boolean isFilterSpontaneous() {
        return this.hasTriggered;
    }

    @Override
    protected void doProcessCatalog(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
        if (this.hasSpont) {
            this.doProcessCatalog(completeCatalog, this.totalXYZs, null, this.totalIncrCounts);
        }
        if (this.hasTriggered) {
            this.doProcessCatalog(triggeredOnlyCatalog, this.triggeredXYZs, this.triggeredPrimaryXYZs, this.hasSpont ? null : this.totalIncrCounts);
        }
        ++this.numCatalogs;
    }

    private void doProcessCatalog(List<ETAS_EqkRupture> catalog, GriddedGeoDataSet[] xyzs, GriddedGeoDataSet[] primaryXYZs, IncrementalMagFreqDist incrCounts) {
        for (ETAS_EqkRupture rup : catalog) {
            Location loc;
            int index;
            double mag = rup.getMag();
            if (incrCounts != null) {
                incrCounts.add(incrCounts.getClosestXIndex(mag), 1.0);
            }
            if ((index = this.reg.indexForLocation(loc = rup.getHypocenterLocation())) < 0) {
                ++this.numRupsSkipped;
                continue;
            }
            for (int i = 0; i < mags.length; ++i) {
                if (!(mag >= mags[i])) continue;
                xyzs[i].set(index, xyzs[i].get(index) + 1.0);
                if (primaryXYZs == null || rup.getGeneration() != 1) continue;
                primaryXYZs[i].set(index, primaryXYZs[i].get(index) + 1.0);
            }
        }
    }

    protected List<MapRunnable> doFinalize(File outputDir, FaultSystemSolution fss, ExecutorService exec) throws IOException {
        double scalar;
        if (this.numRupsSkipped > 0) {
            System.out.println("GriddedNucleation: skipped " + this.numRupsSkipped + " ruptures outside of region");
        }
        if (this.ratio_spread_across_poly) {
            this.ratio_spread_across_poly = fss.getRupSet().hasModule(FaultGridAssociations.class);
        }
        GriddedGeoDataSet[] fssXYZs = null;
        if (this.annualize) {
            scalar = 1.0 / (this.getConfig().getDuration() * (double)this.numCatalogs);
            GridSourceProvider gridProv = fss.getGridSourceProvider();
            if (gridProv != null) {
                fssXYZs = new GriddedGeoDataSet[this.totalXYZs.length];
                System.out.println("Calculating FSS mfds");
                GriddedRegion gridReg = gridProv.getGriddedRegion();
                FaultSystemRupSet rupSet = fss.getRupSet();
                FaultGridAssociations polyMGR = null;
                if (this.ratio_spread_across_poly) {
                    polyMGR = rupSet.getModule(FaultGridAssociations.class);
                }
                HashMap rupToGridNodes = new HashMap();
                for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                    HashSet<Integer> nodes = new HashSet<Integer>();
                    for (Location l : rupSet.getSurfaceForRupture(r, 1.0).getEvenlyDiscritizedListOfLocsOnSurface()) {
                        int node = gridReg.indexForLocation(l);
                        if (node < 0) continue;
                        nodes.add(node);
                    }
                    if (this.ratio_spread_across_poly) {
                        Iterator<Object> iterator = rupSet.getSectionsIndicesForRup(r).iterator();
                        while (iterator.hasNext()) {
                            int sect = (Integer)iterator.next();
                            nodes.addAll(polyMGR.getNodeFractions(sect).keySet());
                        }
                    }
                    rupToGridNodes.put(r, nodes);
                }
                for (int i = 0; i < mags.length; ++i) {
                    if (!(mags[i] >= this.modalMag) || !(mags[i] >= 5.0)) continue;
                    fssXYZs[i] = new GriddedGeoDataSet(gridReg, false);
                    for (int j = 0; j < gridProv.getNumLocations(); ++j) {
                        IncrementalMagFreqDist mfd = gridProv.getMFD(j);
                        for (int k = 0; k < mfd.size(); ++k) {
                            if (!(mfd.getX(k) >= mags[i])) continue;
                            fssXYZs[i].set(j, fssXYZs[i].get(j) + mfd.getY(k));
                        }
                    }
                    for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                        if (!(rupSet.getMagForRup(r) >= mags[i])) continue;
                        double rate = fss.getRateForRup(r);
                        Iterator iterator = ((HashSet)rupToGridNodes.get(r)).iterator();
                        while (iterator.hasNext()) {
                            int node = (Integer)iterator.next();
                            fssXYZs[i].set(node, fssXYZs[i].get(node) + rate);
                        }
                    }
                }
            }
        } else {
            scalar = 1.0 / (double)this.numCatalogs;
        }
        int modalIndex = this.totalIncrCounts.getXindexForMaxY();
        this.modalMag = this.totalIncrCounts.getX(modalIndex) - 0.5 * this.totalIncrCounts.getDelta();
        System.out.println("GriddedParticipation modal magnitude (will skip plots below): " + (float)this.modalMag);
        ArrayList<MapRunnable> runnables = new ArrayList<MapRunnable>();
        if (this.hasSpont) {
            runnables.add(new MapRunnable(this.totalXYZs, fssXYZs, this.modalMag, scalar, outputDir, this.prefix));
        }
        if (this.hasTriggered) {
            runnables.add(new MapRunnable(this.triggeredXYZs, this.modalMag, scalar, outputDir, this.prefix + "_triggered"));
            runnables.add(new MapRunnable(this.triggeredPrimaryXYZs, this.modalMag, scalar, outputDir, this.prefix + "_triggered_primary"));
        }
        return runnables;
    }

    @Override
    public List<String> generateMarkdown(String relativePathToOutputDir, String topLevelHeading, String topLink) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(topLevelHeading + " Gridded Nucleation");
        lines.add(topLink);
        lines.add("");
        MarkdownUtils.TableBuilder builder = MarkdownUtils.tableBuilder();
        builder.initNewLine();
        builder.addColumn("Min Mag");
        if (this.hasSpont) {
            builder.addColumn("Complete Catalog (including spontaneous)");
            if (this.annualize) {
                builder.addColumn("Ratio WRT Long-Term Model");
            }
        }
        if (this.hasTriggered) {
            builder.addColumn("Triggered Ruptures (no spontaneous)");
            builder.addColumn("Triggered Ruptures (primary aftershocks only)");
        }
        builder.finalizeLine();
        for (int i = 0; i < mags.length; ++i) {
            if ((float)mags[i] < (float)this.modalMag) continue;
            builder.initNewLine();
            builder.addColumn("**M&ge;" + optionalDigitDF.format(mags[i]) + "**");
            String magStr = "_m" + (float)mags[i];
            if (this.hasSpont) {
                builder.addColumn("![Nucleation Plot](" + relativePathToOutputDir + "/" + this.prefix + magStr + ".png)");
                if (this.annualize) {
                    builder.addColumn("![Nucleation Plot](" + relativePathToOutputDir + "/" + this.prefix + magStr + "_ratio.png)");
                }
            }
            if (this.hasTriggered) {
                builder.addColumn("![Nucleation Plot](" + relativePathToOutputDir + "/" + this.prefix + "_triggered" + magStr + ".png)");
                builder.addColumn("![Nucleation Plot](" + relativePathToOutputDir + "/" + this.prefix + "_triggered_primary" + magStr + ".png)");
            }
            builder.finalizeLine();
        }
        lines.addAll(builder.build());
        return lines;
    }

    public static void main(String[] args) throws IOException {
        boolean doPlot;
        File outputDir;
        File resultsFile;
        File runDir;
        if (args.length == 4) {
            runDir = new File(args[0]);
            resultsFile = new File(args[1]);
            outputDir = new File(args[2]);
            doPlot = Boolean.parseBoolean(args[3]);
        } else {
            runDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2019_11_05-Start2012_500yr_kCOV1p5_Spontaneous_HistoricalCatalog");
            resultsFile = new File(runDir, "results_m5_preserve_chain.bin");
            outputDir = new File("/tmp");
            doPlot = true;
        }
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        File jsonFile = new File(runDir, "config.json");
        ETAS_Config config = ETAS_Config.readJSON(jsonFile);
        ETAS_Launcher launcher = new ETAS_Launcher(config);
        ETAS_GriddedNucleationPlot plot = new ETAS_GriddedNucleationPlot(config, launcher, "gridded_nucleation", true);
        FaultSystemSolution fss = launcher.checkOutFSS();
        int index = 0;
        for (ETAS_CatalogIO.ETAS_Catalog catalog : ETAS_CatalogIO.getBinaryCatalogsIterable(resultsFile, 0.0)) {
            System.out.println("Catalog " + index++);
            plot.processCatalog(catalog, fss);
        }
        for (MapRunnable map : plot.doFinalize(outputDir, fss, null)) {
            for (int i = 0; i < mags.length; ++i) {
                if ((float)mags[i] < (float)plot.modalMag) continue;
                String myPrefix = map.prefix + "_m" + (float)mags[i];
                System.out.println(myPrefix);
                GriddedGeoDataSet xyz = map.xyzs[i].copy();
                xyz.scale(map.scalar);
                GriddedGeoDataSet.writeXYZFile((XYZ_DataSet)xyz, new File(outputDir, myPrefix + ".xyz"));
            }
            if (!doPlot) continue;
            map.run();
        }
        launcher.checkInFSS(fss);
    }

    private class MapRunnable
    implements Runnable {
        private GriddedGeoDataSet[] xyzs;
        private GriddedGeoDataSet[] fssXYZs;
        private double modalMag;
        private double scalar;
        private File outputDir;
        private String prefix;

        public MapRunnable(GriddedGeoDataSet[] xyzs, double modalMag, double scalar, File outputDir, String prefix) {
            this(xyzs, null, modalMag, scalar, outputDir, prefix);
        }

        public MapRunnable(GriddedGeoDataSet[] xyzs, GriddedGeoDataSet[] fssXYZs, double modalMag, double scalar, File outputDir, String prefix) {
            this.xyzs = xyzs;
            this.fssXYZs = fssXYZs;
            this.modalMag = modalMag;
            this.scalar = scalar;
            this.outputDir = outputDir;
            this.prefix = prefix;
        }

        @Override
        public void run() {
            try {
                for (GriddedGeoDataSet xyz : this.xyzs) {
                    xyz.scale(this.scalar);
                }
                CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
                cpt.setNanColor(Color.GRAY);
                cpt.setBelowMinColor(Color.BLUE);
                CPT ratioCPT = GMT_CPT_Files.GMT_POLAR.instance().rescale(-2.0, 2.0);
                ratioCPT.setNanColor(Color.GRAY);
                Region plotReg = new Region(new Location(ETAS_GriddedNucleationPlot.this.reg.getMinGridLat(), ETAS_GriddedNucleationPlot.this.reg.getMinGridLon()), new Location(ETAS_GriddedNucleationPlot.this.reg.getMaxGridLat(), ETAS_GriddedNucleationPlot.this.reg.getMaxGridLon()));
                double minZ = Math.floor(Math.log10(this.scalar));
                for (int i = 0; i < mags.length; ++i) {
                    if ((float)mags[i] < (float)this.modalMag) continue;
                    GriddedGeoDataSet xyz = this.xyzs[i];
                    GriddedGeoDataSet ratio = null;
                    if (this.fssXYZs != null && this.fssXYZs[i] != null) {
                        int n;
                        ratio = new GriddedGeoDataSet(this.fssXYZs[i].getRegion(), false);
                        GriddedGeoDataSet rescaled = new GriddedGeoDataSet(ratio.getRegion(), false);
                        for (n = 0; n < xyz.size(); ++n) {
                            Location loc = xyz.getLocation(n);
                            int index = rescaled.getRegion().indexForLocation(loc);
                            if (index < 0) continue;
                            rescaled.set(index, rescaled.get(index) + xyz.get(n));
                        }
                        for (n = 0; n < ratio.size(); ++n) {
                            ratio.set(n, rescaled.get(n) / this.fssXYZs[i].get(n));
                        }
                        ratio.log10();
                    }
                    xyz.log10();
                    double maxZ = Math.ceil(xyz.getMaxZ());
                    if (xyz.getMaxZ() == Double.NEGATIVE_INFINITY) {
                        maxZ = minZ + 4.0;
                    }
                    if (maxZ == minZ) {
                        maxZ += 1.0;
                    }
                    for (int j = 0; j < xyz.size(); ++j) {
                        if (!Double.isInfinite(xyz.get(j))) continue;
                        xyz.set(j, minZ);
                    }
                    Preconditions.checkState((minZ < maxZ ? 1 : 0) != 0, (String)"minZ=%s >= maxZ=%s", (Object)minZ, (Object)maxZ);
                    double mag = mags[i];
                    String label = "Log10 M>=" + (float)mag;
                    label = ETAS_GriddedNucleationPlot.this.annualize ? label + " Nucleation Rate" : label + " Expected Num";
                    String myPrefix = this.prefix + "_m" + (float)mag;
                    GMT_Map map = FaultBasedMapGen.buildMap(cpt.rescale(minZ, maxZ), null, null, this.xyzs[i], discr, plotReg, false, label);
                    map.setCPTCustomInterval(1.0);
                    FaultBasedMapGen.plotMap(this.outputDir, myPrefix, false, map);
                    if (ratio == null) continue;
                    myPrefix = myPrefix + "_ratio";
                    map = FaultBasedMapGen.buildMap(ratioCPT, null, null, ratio, ratio.getRegion().getSpacing(), plotReg, false, label + " Ratio");
                    map.setCPTCustomInterval(1.0);
                    FaultBasedMapGen.plotMap(this.outputDir, myPrefix, false, map);
                }
            }
            catch (IOException | GMT_MapException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
    }
}

