/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.analysis;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.math3.stat.StatUtils;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.uncertainty.UncertainArbDiscFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import scratch.UCERF3.analysis.FaultSysSolutionERF_Calc;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;

public class ETAS_HazardChangePlot
extends ETAS_AbstractPlot {
    private String prefix;
    private double radius;
    static double[] times = new double[]{1.1407711613050422E-4, 0.0027378507871321013, 0.019164955509924708, 0.08213552361396304, 1.0, 10.0, 30.0, 100.0};
    private static double[] minMags = new double[]{5.0, 6.0, 7.0, 8.0};
    private static double overallMinMag = StatUtils.min((double[])minMags);
    private ArbitrarilyDiscretizedFunc etasTimesFunc;
    private ArbitrarilyDiscretizedFunc u3TimesFunc;
    private List<Region> triggerRegions;
    private Region unionRegion;
    private HashSet<Integer> fssIndexesInside;
    private long simOT;
    private List<int[][]> catalogCounts;
    private boolean[] hasMags;
    private ArbitrarilyDiscretizedFunc[] tiFuncs;
    private ArbitrarilyDiscretizedFunc[] tdFuncs;
    private ArbitrarilyDiscretizedFunc[] simFuncs;
    private ArbitrarilyDiscretizedFunc[] simLowerFuncs;
    private ArbitrarilyDiscretizedFunc[] simUpperFuncs;
    private ArbitrarilyDiscretizedFunc[] simOnlyFuncs;

    public ETAS_HazardChangePlot(ETAS_Config config, ETAS_Launcher launcher, String prefix, double radius) {
        super(config, launcher);
        this.prefix = prefix;
        this.radius = radius;
        this.simOT = config.getSimulationStartTimeMillis();
        Preconditions.checkState((boolean)config.hasTriggers(), (Object)"Hazard change plot requires trigger ruptures");
        int etasNumX = 1000;
        int u3NumX = 10;
        EvenlyDiscretizedFunc evenlyDiscrTimes = new EvenlyDiscretizedFunc(Math.log(times[0]), Math.log(times[times.length - 1]), etasNumX);
        this.etasTimesFunc = new ArbitrarilyDiscretizedFunc();
        for (double x : times) {
            this.etasTimesFunc.set(x, 0.0);
        }
        Object object = evenlyDiscrTimes.iterator();
        while (object.hasNext()) {
            Point2D pt = (Point2D)object.next();
            double time = Math.exp(pt.getX());
            if (ETAS_HazardChangePlot.isHardcodedTime(time)) continue;
            this.etasTimesFunc.set(time, 0.0);
        }
        evenlyDiscrTimes = new EvenlyDiscretizedFunc(Math.log(0.08213552361396304), Math.log(times[times.length - 1]), u3NumX);
        this.u3TimesFunc = new ArbitrarilyDiscretizedFunc();
        for (double x : (Object)times) {
            this.u3TimesFunc.set(x, 0.0);
        }
        object = evenlyDiscrTimes.iterator();
        while (object.hasNext()) {
            Point2D pt = (Point2D)object.next();
            double time = Math.exp(pt.getX());
            if (ETAS_HazardChangePlot.isHardcodedTime(time)) continue;
            this.u3TimesFunc.set(time, 0.0);
        }
        this.catalogCounts = new ArrayList<int[][]>();
        this.hasMags = new boolean[minMags.length];
        for (int m = 0; m < minMags.length; ++m) {
            this.hasMags[m] = false;
        }
    }

    private synchronized void checkInitTriggerRegions() {
        if (this.triggerRegions != null) {
            return;
        }
        ETAS_Launcher launcher = this.getLauncher();
        ETAS_Config config = this.getConfig();
        List<ETAS_EqkRupture> triggerRups = launcher.getCombinedTriggers();
        Preconditions.checkState((!triggerRups.isEmpty() ? 1 : 0) != 0, (Object)"No trigger ruptures?");
        this.triggerRegions = new ArrayList<Region>();
        ETAS_Config.ComcatMetadata meta = config.getComcatMetadata();
        if (meta != null && meta.region != null) {
            System.out.println("Will compute hazard change in ComCat region");
            this.triggerRegions.add(meta.region);
        } else {
            for (ETAS_EqkRupture rup : triggerRups) {
                RuptureSurface surf = rup.getRuptureSurface();
                if (surf == null || surf instanceof PointSurface) {
                    this.triggerRegions.add(new Region(rup.getHypocenterLocation(), this.radius));
                    continue;
                }
                if (surf instanceof CompoundSurface) {
                    for (RuptureSurface ruptureSurface : ((CompoundSurface)surf).getSurfaceList()) {
                        FaultTrace upper;
                        try {
                            upper = ruptureSurface.getUpperEdge();
                        }
                        catch (Exception e) {
                            upper = ruptureSurface.getEvenlyDiscritizedUpperEdge();
                        }
                        this.triggerRegions.add(new Region((LocationList)upper, this.radius));
                    }
                    continue;
                }
                this.triggerRegions.add(new Region((LocationList)surf.getUpperEdge(), this.radius));
            }
        }
        this.unionRegion = this.triggerRegions.get(0);
        for (int i = 1; i < this.triggerRegions.size(); ++i) {
            try {
                this.unionRegion = Region.union(this.unionRegion, this.triggerRegions.get(i));
            }
            catch (Exception e) {
                this.unionRegion = null;
                System.err.println("Exception unioning trigger regions, will be slower:");
                e.printStackTrace();
                break;
            }
            if (this.unionRegion != null) continue;
            System.out.println("Warning, can't union trigger rupture buffered regions, will be slower");
            break;
        }
    }

    @Override
    public int getVersion() {
        return 2;
    }

    private static boolean isHardcodedTime(double time) {
        for (double test : times) {
            if ((float)time != (float)test) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFilterSpontaneous() {
        return true;
    }

    private boolean insideTriggerRegion(Location loc) {
        this.checkInitTriggerRegions();
        if (this.unionRegion == null) {
            for (Region triggerRegion : this.triggerRegions) {
                if (!triggerRegion.contains(loc)) continue;
                return true;
            }
            return false;
        }
        return this.unionRegion.contains(loc);
    }

    @Override
    protected void doProcessCatalog(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
        if (this.fssIndexesInside == null) {
            FaultSystemRupSet rupSet = fss.getRupSet();
            this.fssIndexesInside = new HashSet();
            for (int s = 0; s < rupSet.getNumSections(); ++s) {
                for (Location loc : rupSet.getFaultSectionData(s).getFaultTrace()) {
                    if (!this.insideTriggerRegion(loc)) continue;
                    this.fssIndexesInside.addAll(rupSet.getRupturesForSection(s));
                }
            }
        }
        int[][] counts = new int[minMags.length][this.etasTimesFunc.size()];
        for (ETAS_EqkRupture rup : triggeredOnlyCatalog) {
            int fssIndex;
            if (rup.getMag() < overallMinMag || ((fssIndex = rup.getFSSIndex()) < 0 || !this.fssIndexesInside.contains(fssIndex)) && !this.insideTriggerRegion(rup.getHypocenterLocation())) continue;
            long rupOT = rup.getOriginTime();
            Preconditions.checkState((rupOT >= this.simOT ? 1 : 0) != 0);
            double timeSince = (double)(rupOT - this.simOT) / 3.15576E10;
            double mag = rup.getMag();
            for (int m = 0; m < minMags.length; ++m) {
                if (mag < minMags[m]) continue;
                this.hasMags[m] = true;
                for (int t = 0; t < this.etasTimesFunc.size(); ++t) {
                    if (timeSince > this.etasTimesFunc.getX(t)) continue;
                    int[] nArray = counts[m];
                    int n = t;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        this.catalogCounts.add(counts);
        this.tiFuncs = null;
    }

    @Override
    protected List<? extends Runnable> doFinalize(File outputDir, FaultSystemSolution fss, ExecutorService exec) throws IOException {
        ArbitrarilyDiscretizedFunc[] addToSimFuncs;
        if (this.tiFuncs != null) {
            return null;
        }
        System.out.println("Calculating hazard change for U3-TI");
        this.tiFuncs = this.calcUCERF3(fss, true, exec);
        if (this.getConfig().isTimeIndependentERF()) {
            this.tdFuncs = null;
            addToSimFuncs = this.tiFuncs;
        } else {
            System.out.println("Calculating hazard change for U3-TD");
            this.tdFuncs = this.calcUCERF3(fss, false, exec);
            addToSimFuncs = this.tdFuncs;
        }
        System.out.println("Calculating hazard change for ETAS simulations");
        this.simFuncs = new ArbitrarilyDiscretizedFunc[minMags.length];
        this.simLowerFuncs = new ArbitrarilyDiscretizedFunc[minMags.length];
        this.simUpperFuncs = new ArbitrarilyDiscretizedFunc[minMags.length];
        this.simOnlyFuncs = new ArbitrarilyDiscretizedFunc[minMags.length];
        ArbitrarilyDiscretizedFunc[] gainFuncs = new ArbitrarilyDiscretizedFunc[minMags.length];
        ArbitrarilyDiscretizedFunc[] gainLowerFuncs = new ArbitrarilyDiscretizedFunc[minMags.length];
        ArbitrarilyDiscretizedFunc[] gainUpperFuncs = new ArbitrarilyDiscretizedFunc[minMags.length];
        ArbitrarilyDiscretizedFunc[] gainOnlyFuncs = new ArbitrarilyDiscretizedFunc[minMags.length];
        for (int m = 0; m < minMags.length; ++m) {
            if (!this.hasMags[m]) continue;
            CSVFile<String> csv = new CSVFile<String>(true);
            csv.addLine("Duration (years)", "TI Prob", "TD Prob", "ETAS Prob", "ETAS p2.5", "ETAS p97.5", "ETAS Only Prob");
            this.simFuncs[m] = new ArbitrarilyDiscretizedFunc();
            this.simLowerFuncs[m] = new ArbitrarilyDiscretizedFunc();
            this.simUpperFuncs[m] = new ArbitrarilyDiscretizedFunc();
            this.simOnlyFuncs[m] = new ArbitrarilyDiscretizedFunc();
            gainFuncs[m] = new ArbitrarilyDiscretizedFunc();
            gainLowerFuncs[m] = new ArbitrarilyDiscretizedFunc();
            gainUpperFuncs[m] = new ArbitrarilyDiscretizedFunc();
            gainOnlyFuncs[m] = new ArbitrarilyDiscretizedFunc();
            for (int t = 0; t < this.etasTimesFunc.size(); ++t) {
                double u3Prob;
                double duration = this.etasTimesFunc.getX(t);
                int numWith = 0;
                int totalNum = 0;
                for (int[][] counts : this.catalogCounts) {
                    Preconditions.checkState((counts[m].length == this.etasTimesFunc.size() ? 1 : 0) != 0);
                    if (counts[m][t] > 0) {
                        ++numWith;
                    }
                    ++totalNum;
                }
                try {
                    u3Prob = addToSimFuncs[m].getInterpolatedY_inLogXLogYDomain(duration);
                    Preconditions.checkState((boolean)Double.isFinite(u3Prob));
                }
                catch (Exception e) {
                    u3Prob = addToSimFuncs[m].getInterpolatedY(duration);
                }
                Preconditions.checkState((Double.isFinite(u3Prob) && u3Prob >= 0.0 && u3Prob <= 1.0 ? 1 : 0) != 0, (String)"Bad U3 prob: %s\n\n$s", (Object)u3Prob, (Object)addToSimFuncs[m]);
                double simProb = (double)numWith / (double)totalNum;
                double[] conf = ETAS_Utils.getBinomialProportion95confidenceInterval(simProb, totalNum);
                double tiProb = this.tiFuncs[m].getInterpolatedY(duration);
                double tdProb = this.tdFuncs == null ? Double.NaN : this.tdFuncs[m].getInterpolatedY(duration);
                ArrayList<Object> line = new ArrayList<Object>();
                line.add("" + (float)duration);
                line.add("" + tiProb);
                line.add("" + tdProb);
                double denom = this.tiFuncs == null ? tiProb : tdProb;
                double prob = 1.0 - (1.0 - simProb) * (1.0 - u3Prob);
                line.add("" + prob);
                this.simFuncs[m].set(duration, prob);
                gainFuncs[m].set(duration, prob / denom);
                double lowerProb = 1.0 - (1.0 - conf[0]) * (1.0 - u3Prob);
                line.add("" + lowerProb);
                this.simLowerFuncs[m].set(duration, lowerProb);
                gainLowerFuncs[m].set(duration, lowerProb / denom);
                double upperProb = 1.0 - (1.0 - conf[1]) * (1.0 - u3Prob);
                line.add("" + upperProb);
                this.simUpperFuncs[m].set(duration, upperProb);
                gainUpperFuncs[m].set(duration, upperProb / denom);
                if ((float)duration <= (float)this.getConfig().getDuration()) {
                    line.add("" + simProb);
                    this.simOnlyFuncs[m].set(duration, simProb);
                    gainOnlyFuncs[m].set(duration, simProb / denom);
                } else {
                    line.add("NaN");
                }
                csv.addLine((List<String>)line);
            }
            String fileName = this.prefix + "_m" + (float)minMags[m] + ".csv";
            csv.writeToFile(new File(outputDir, fileName));
        }
        boolean xAxisInverted = false;
        for (int m = 0; m < minMags.length; ++m) {
            if (!this.hasMags[m]) continue;
            for (boolean gain : new boolean[]{false, true}) {
                Range yRange;
                ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                if (gain) {
                    gainFuncs[m].setName("UCERF3-ETAS");
                    funcs.add(gainFuncs[m]);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED));
                    UncertainArbDiscFunc gainConfFunc = new UncertainArbDiscFunc(gainFuncs[m], gainLowerFuncs[m], gainUpperFuncs[m]);
                    gainConfFunc.setName("95% Conf");
                    funcs.add(gainConfFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, new Color(255, 0, 0, 30)));
                    double maxGain = 10.0;
                    for (XY_DataSet func : funcs) {
                        for (Point2D pt : func) {
                            maxGain = Math.max(maxGain, pt.getY());
                        }
                    }
                    maxGain = Math.pow(10.0, Math.ceil(Math.log10(maxGain)));
                    gainOnlyFuncs[m].setName("UCERF3-ETAS Triggered Only");
                    funcs.add(gainOnlyFuncs[m]);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.RED));
                    yRange = new Range(1.0, maxGain);
                } else {
                    this.tiFuncs[m].setName("UCERF3-TI");
                    funcs.add(this.tiFuncs[m]);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
                    if (this.tdFuncs != null) {
                        this.tdFuncs[m].setName("UCERF3-TD");
                        funcs.add(this.tdFuncs[m]);
                        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLUE));
                    }
                    this.simFuncs[m].setName("UCERF3-ETAS");
                    funcs.add(this.simFuncs[m]);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED));
                    UncertainArbDiscFunc simConfFunc = new UncertainArbDiscFunc(this.simFuncs[m], this.simLowerFuncs[m], this.simUpperFuncs[m]);
                    simConfFunc.setName("95% Conf");
                    funcs.add(simConfFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, new Color(255, 0, 0, 30)));
                    double minProb = 1.0;
                    for (XY_DataSet func : funcs) {
                        for (Point2D pt : func) {
                            if (!(pt.getY() > 0.0)) continue;
                            minProb = Math.min(minProb, pt.getY());
                        }
                    }
                    minProb *= 0.5;
                    this.simOnlyFuncs[m].setName("UCERF3-ETAS Triggered Only");
                    funcs.add(this.simOnlyFuncs[m]);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.RED));
                    yRange = new Range(minProb, 1.0);
                }
                List<XYTextAnnotation> annotations = ETAS_HazardChangePlot.buildPlotAnnotations(xAxisInverted, funcs, chars, yRange);
                for (XY_DataSet func : funcs) {
                    Preconditions.checkState((func.size() > 0 ? 1 : 0) != 0, (String)"Empty func with name: %s", (Object)func.getName());
                }
                String yAxisLabel = "M\u2265" + (float)minMags[m];
                yAxisLabel = gain ? yAxisLabel + " Probability Gain" : yAxisLabel + " Participation Probability";
                PlotSpec spec = new PlotSpec(funcs, chars, "M\u2265" + (float)minMags[m] + " Simulation Hazard Change", "Forecast Timespan (years)", yAxisLabel);
                spec.setPlotAnnotations(annotations);
                spec.setLegendVisible(true);
                HeadlessGraphPanel gp = ETAS_HazardChangePlot.buildGraphPanel();
                gp.setxAxisInverted(xAxisInverted);
                gp.setUserBounds(new Range(times[0], times[times.length - 1]), yRange);
                gp.drawGraphPanel(spec, true, true);
                gp.getChartPanel().setSize(1000, 800);
                String myPrefix = this.prefix + "_m" + (float)minMags[m];
                if (gain) {
                    myPrefix = myPrefix + "_gain";
                }
                gp.saveAsPNG(new File(outputDir, myPrefix + ".png").getAbsolutePath());
                gp.saveAsPDF(new File(outputDir, myPrefix + ".pdf").getAbsolutePath());
                gp.saveAsTXT(new File(outputDir, myPrefix + ".txt").getAbsolutePath());
            }
        }
        return null;
    }

    public static List<XYTextAnnotation> buildPlotAnnotations(boolean xAxisInverted, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, Range yRange) {
        double annY1 = Math.pow(10.0, Math.log10(yRange.getLowerBound()) + 0.985 * (Math.log10(yRange.getUpperBound()) - Math.log10(yRange.getLowerBound())));
        double annY2 = Math.pow(10.0, Math.log10(yRange.getLowerBound()) + 0.94 * (Math.log10(yRange.getUpperBound()) - Math.log10(yRange.getLowerBound())));
        ArrayList<XYTextAnnotation> annotations = new ArrayList<XYTextAnnotation>();
        Font annFont = new Font("SansSerif", 1, 20);
        for (int i = 0; i < times.length; ++i) {
            double time = times[i];
            String label = ETAS_HazardChangePlot.getTimeShortLabel(time);
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            xy.set(time, yRange.getLowerBound());
            xy.set(time, yRange.getUpperBound());
            funcs.add(xy);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GRAY));
            XYTextAnnotation ann = new XYTextAnnotation(label, time, annY1);
            if (i == 0 && xAxisInverted || i == times.length - 1 && !xAxisInverted) {
                ann.setTextAnchor(TextAnchor.TOP_RIGHT);
                if (!xAxisInverted) {
                    ann.setY(annY2);
                }
            } else {
                ann.setTextAnchor(TextAnchor.TOP_LEFT);
            }
            ann.setFont(annFont);
            annotations.add(ann);
        }
        return annotations;
    }

    /*
     * WARNING - void declaration
     */
    private ArbitrarilyDiscretizedFunc[] calcUCERF3(FaultSystemSolution fss, boolean timeIndep, ExecutorService exec) {
        void var12_20;
        void var12_18;
        FaultSystemSolutionERF_ETAS erf = ETAS_Launcher.buildERF_millis(fss, timeIndep, timeIndep ? 1.0 : this.u3TimesFunc.getMinX(), this.simOT);
        erf.updateForecast();
        int numFSSsources = erf.getNumFaultSystemSources();
        ArrayList<Integer> sourceIDs = new ArrayList<Integer>();
        for (int sourceID = 0; sourceID < erf.getNumSources(); ++sourceID) {
            int fssIndex = -1;
            if (sourceID < numFSSsources) {
                fssIndex = erf.getFltSysRupIndexForSource(sourceID);
            }
            if (fssIndex >= 0) {
                if (!this.fssIndexesInside.contains(fssIndex)) continue;
                sourceIDs.add(sourceID);
                continue;
            }
            ProbEqkSource source = erf.getSource(sourceID);
            RuptureSurface sourceSurf = source.getSourceSurface();
            Preconditions.checkState((boolean)(sourceSurf instanceof PointSurface));
            if (!this.insideTriggerRegion(((PointSurface)sourceSurf).getLocation())) continue;
            sourceIDs.add(sourceID);
        }
        Preconditions.checkState((!sourceIDs.isEmpty() ? 1 : 0) != 0, (Object)"No UCERF3 source IDs found inside of trigger region!");
        ArbitrarilyDiscretizedFunc[] funcs = new ArbitrarilyDiscretizedFunc[minMags.length];
        for (int m = 0; m < funcs.length; ++m) {
            funcs[m] = new ArbitrarilyDiscretizedFunc();
        }
        ArrayDeque<FaultSystemSolutionERF_ETAS> erfDeque = new ArrayDeque<FaultSystemSolutionERF_ETAS>();
        erfDeque.push(erf);
        int threads = Integer.min(Runtime.getRuntime().availableProcessors(), 10);
        if (timeIndep || threads < 1) {
            threads = 1;
        }
        ArrayList futures = new ArrayList();
        for (int t = 0; t < this.u3TimesFunc.size(); ++t) {
            futures.add(exec.submit(new U3CalcRunnable(fss, timeIndep, sourceIDs, erfDeque, this.u3TimesFunc.getX(t), funcs)));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        HashSet<Double> smoothedXVals = new HashSet<Double>();
        boolean bl = false;
        while (var12_18 < this.etasTimesFunc.size()) {
            smoothedXVals.add(this.etasTimesFunc.getX((int)var12_18));
            ++var12_18;
        }
        boolean bl2 = false;
        while ((double)var12_20 < this.u3TimesFunc.getX((int)var12_20)) {
            smoothedXVals.add(this.u3TimesFunc.getX((int)var12_20));
            ++var12_20;
        }
        ArbitrarilyDiscretizedFunc[] arbitrarilyDiscretizedFuncArray = new ArbitrarilyDiscretizedFunc[funcs.length];
        for (int m = 0; m < funcs.length; ++m) {
            ArbitrarilyDiscretizedFunc rateFunc = new ArbitrarilyDiscretizedFunc();
            for (int i2 = 0; i2 < funcs[m].size(); ++i2) {
                double time = funcs[m].getX(i2);
                double prob = funcs[m].getY(i2);
                if (prob == 1.0) {
                    prob -= 1.0E-10;
                }
                double rate = -Math.log(1.0 - prob) / time;
                rateFunc.set(time, rate);
            }
            arbitrarilyDiscretizedFuncArray[m] = new ArbitrarilyDiscretizedFunc();
            Iterator iterator = smoothedXVals.iterator();
            while (iterator.hasNext()) {
                double x = (Double)iterator.next();
                double smoothedRate = rateFunc.getInterpolatedY(x);
                double smoothedProb = Double.isInfinite(smoothedRate) ? 1.0 : 1.0 - Math.exp(-smoothedRate * x);
                Preconditions.checkState((boolean)Double.isFinite(smoothedProb), (String)"Bad smoothed prob! 1-e^(-%s*%s)=%s", (Object)smoothedRate, (Object)x, (Object)smoothedProb);
                arbitrarilyDiscretizedFuncArray[m].set(x, smoothedProb);
            }
        }
        return arbitrarilyDiscretizedFuncArray;
    }

    @Override
    public List<String> generateMarkdown(String relativePathToOutputDir, String topLevelHeading, String topLink) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String title = "Hazard Change Over Time";
        lines.add(topLevelHeading + " " + title);
        lines.add(topLink);
        lines.add("");
        ETAS_Config.ComcatMetadata meta = this.getConfig().getComcatMetadata();
        if (meta != null && meta.region != null) {
            Object str = "These plots show how the probability of ruptures of various magnitudes ";
            str = (float)meta.region.getExtent() == (float)new CaliforniaRegions.RELM_TESTING().getExtent() ? (String)str + "statewide" : (String)str + "within the region used to fetch ComCat trigger ruptures";
            str = (String)str + " changes over time";
            lines.add((String)str);
        } else {
            lines.add("These plots show how the probability of ruptures of various magnitudes within " + optionalDigitDF.format(this.radius) + "km of any scenario rupture changes over time");
        }
        lines.add("");
        for (int m = 0; m < minMags.length; ++m) {
            if (!this.hasMags[m]) continue;
            lines.add(topLevelHeading + "# M&ge;" + (float)minMags[m] + " " + title);
            lines.add(topLink);
            lines.add("");
            MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
            table.initNewLine();
            table.addColumn("![Hazard Change](" + relativePathToOutputDir + "/" + this.prefix + "_m" + (float)minMags[m] + ".png)");
            table.addColumn("![Gain](" + relativePathToOutputDir + "/" + this.prefix + "_m" + (float)minMags[m] + "_gain.png)");
            table.finalizeLine();
            lines.addAll(table.build());
            lines.add("");
            table = MarkdownUtils.tableBuilder();
            table.initNewLine();
            table.addColumn("Forecast Duration");
            table.addColumn("UCERF3-ETAS [95% Conf]");
            table.addColumn("UCERF3-ETAS Triggered Only");
            if (this.tdFuncs != null) {
                table.addColumn("UCERF3-TD");
                table.addColumn("UCERF3-ETAS/TD Gain");
                table.addColumn("UCERF3-TI");
            } else {
                table.addColumn("UCERF3-TI");
                table.addColumn("UCERF3-ETAS/TI Gain");
            }
            table.finalizeLine();
            boolean hasAsterisk = false;
            for (double time : times) {
                table.initNewLine();
                table.addColumn(ETAS_HazardChangePlot.getTimeLabel(time, true));
                String asterisk = "";
                if ((float)time > (float)this.getConfig().getDuration()) {
                    asterisk = " \\*";
                    hasAsterisk = true;
                }
                double etasProb = this.simFuncs[m].getY(time);
                table.addColumn(ETAS_HazardChangePlot.getProbStr(etasProb) + " [" + ETAS_HazardChangePlot.getProbStr(this.simLowerFuncs[m].getY(time)) + " - " + ETAS_HazardChangePlot.getProbStr(this.simUpperFuncs[m].getY(time)) + "]" + asterisk);
                if ((float)time > (float)this.simOnlyFuncs[m].getMaxX()) {
                    table.addColumn("\\*");
                } else {
                    table.addColumn(ETAS_HazardChangePlot.getProbStr(this.simOnlyFuncs[m].getY(time)));
                }
                if (this.tdFuncs != null) {
                    double tdProb = this.tdFuncs[m].getY(time);
                    table.addColumn(ETAS_HazardChangePlot.getProbStr(tdProb));
                    table.addColumn(optionalDigitDF.format(etasProb / tdProb) + asterisk);
                    table.addColumn(ETAS_HazardChangePlot.getProbStr(this.tiFuncs[m].getY(time)));
                } else {
                    double tiProb = this.tiFuncs[m].getY(time);
                    table.addColumn(ETAS_HazardChangePlot.getProbStr(tiProb));
                    table.addColumn(optionalDigitDF.format(etasProb / tiProb) + asterisk);
                }
                table.finalizeLine();
            }
            lines.addAll(table.build());
            lines.add("");
            if (!hasAsterisk) continue;
            lines.add("\\* *forecast duration is longer than simulation length, only ETAS ruptures from the first " + ETAS_HazardChangePlot.getTimeLabel(this.getConfig().getDuration(), true).toLowerCase() + " are included*");
        }
        return lines;
    }

    private class U3CalcRunnable
    implements Runnable {
        private FaultSystemSolution fss;
        private boolean timeIndep;
        private List<Integer> sourceIDs;
        private ArrayDeque<FaultSystemSolutionERF_ETAS> erfDeque;
        private double duration;
        private ArbitrarilyDiscretizedFunc[] ret;

        public U3CalcRunnable(FaultSystemSolution fss, boolean timeIndep, List<Integer> sourceIDs, ArrayDeque<FaultSystemSolutionERF_ETAS> erfDeque, double duration, ArbitrarilyDiscretizedFunc[] ret) {
            this.fss = fss;
            this.timeIndep = timeIndep;
            this.sourceIDs = sourceIDs;
            this.erfDeque = erfDeque;
            this.duration = duration;
            this.ret = ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            double rateScale;
            if (!this.timeIndep) {
                System.out.println("\tduration: " + ETAS_AbstractPlot.getTimeLabel(this.duration, true));
            }
            FaultSystemSolutionERF_ETAS erf = null;
            ArrayDeque<FaultSystemSolutionERF_ETAS> arrayDeque = this.erfDeque;
            synchronized (arrayDeque) {
                if (!this.erfDeque.isEmpty()) {
                    erf = this.erfDeque.pop();
                }
            }
            if (erf == null) {
                erf = ETAS_Launcher.buildERF_millis(this.fss, this.timeIndep, this.timeIndep ? 1.0 : this.duration, ETAS_HazardChangePlot.this.simOT);
                erf.updateForecast();
            }
            if (this.timeIndep) {
                rateScale = this.duration;
            } else {
                rateScale = 1.0;
                TimeSpan timeSpan = erf.getTimeSpan();
                if ((float)this.duration != (float)timeSpan.getDuration()) {
                    timeSpan.setDuration(this.duration);
                    erf.updateForecast();
                }
            }
            ArrayList probs = new ArrayList();
            for (int m = 0; m < minMags.length; ++m) {
                probs.add(new ArrayList());
            }
            for (int sourceID : this.sourceIDs) {
                ProbEqkSource source = erf.getSource(sourceID);
                for (ProbEqkRupture rup : source) {
                    double mag = rup.getMag();
                    double prob = rup.getProbability();
                    if (rateScale != 1.0) {
                        double annualRate = -Math.log(1.0 - prob);
                        prob = 1.0 - Math.exp(-annualRate * this.duration);
                    }
                    for (int m = 0; m < minMags.length; ++m) {
                        if (!(mag >= minMags[m])) continue;
                        ((List)probs.get(m)).add(prob);
                    }
                }
            }
            for (int m = 0; m < minMags.length; ++m) {
                List magProbs = (List)probs.get(m);
                this.ret[m].set(this.duration, FaultSysSolutionERF_Calc.calcSummedProbs(magProbs));
            }
            ArrayDeque<FaultSystemSolutionERF_ETAS> arrayDeque2 = this.erfDeque;
            synchronized (arrayDeque2) {
                this.erfDeque.push(erf);
            }
        }
    }
}

