/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.opensha.commons.calc.FractileCurveCalculator;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.data.uncertainty.UncertainArbDiscFunc;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_HazardChangePlot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;

public class ETAS_MFD_Plot
extends ETAS_AbstractPlot {
    static double mfdMinMag = 2.55;
    static double mfdDelta = 0.1;
    static int mfdNumMag = 66;
    private static double mfdMinY = 1.0E-4;
    private static double mfdMaxY = 10000.0;
    private String prefix;
    private boolean annualize;
    private boolean cumulative;
    private int numCatalogs = 0;
    private double[] durations;
    private MFD_Stats[] totalWithSpontStats;
    private MFD_Stats[] totalWithSpontSupraStats;
    private MFD_Stats[] triggeredStats;
    private MFD_Stats[] triggeredSupraStats;
    private MFD_Stats[] triggeredPrimaryStats;
    private EvenlyDiscretizedFunc fssMFD;
    private HistogramFunction totalCountHist;
    private boolean spontaneousFound = false;
    private static double[] fractiles = new double[]{0.025, 0.975};
    private boolean noTitles = false;
    private boolean includeMedian = true;
    private boolean includeMode = true;
    private boolean includePrimary = true;
    private Color probColor = Color.RED;

    public ETAS_MFD_Plot(ETAS_Config config, ETAS_Launcher launcher, String prefix, boolean annualize, boolean cumulative) {
        super(config, launcher);
        this.prefix = prefix;
        this.annualize = annualize;
        this.cumulative = cumulative;
        boolean triggerCatAsSpont = config.getTriggerCatalogFile() != null && config.isTreatTriggerCatalogAsSpontaneous();
        double totDuration = config.getDuration();
        if (!annualize) {
            ArrayList<Double> myDurations = new ArrayList<Double>();
            for (double duration : ETAS_HazardChangePlot.times) {
                if (!(duration < totDuration)) continue;
                myDurations.add(duration);
            }
            myDurations.add(totDuration);
            this.durations = Doubles.toArray(myDurations);
        } else {
            this.durations = new double[]{totDuration};
        }
        if (config.isIncludeSpontaneous() || triggerCatAsSpont) {
            this.totalWithSpontStats = this.buildStats();
            this.totalWithSpontSupraStats = this.buildStats();
            if (triggerCatAsSpont) {
                this.spontaneousFound = true;
            }
        }
        if (config.hasTriggers()) {
            this.triggeredStats = this.buildStats();
            this.triggeredSupraStats = this.buildStats();
            this.triggeredPrimaryStats = this.buildStats();
        }
        Preconditions.checkState((this.totalWithSpontStats != null || this.triggeredStats != null ? 1 : 0) != 0, (Object)"Must either have spontaneous, or trigger ruptures");
        this.totalCountHist = new HistogramFunction(mfdMinMag, mfdNumMag, mfdDelta);
    }

    @Override
    public int getVersion() {
        return 3;
    }

    private MFD_Stats[] buildStats() {
        MFD_Stats[] ret = new MFD_Stats[this.durations.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new MFD_Stats();
        }
        return ret;
    }

    @Override
    public boolean isFilterSpontaneous() {
        return this.triggeredStats != null;
    }

    @Override
    protected void doProcessCatalog(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
        for (int i = 0; i < this.durations.length; ++i) {
            IncrementalMagFreqDist supraHist;
            long maxOT = this.getConfig().getSimulationStartTimeMillis() + (long)(3.15576E10 * this.durations[i] + 0.5);
            if (this.totalWithSpontStats != null) {
                ETAS_EqkRupture rup;
                IncrementalMagFreqDist totalHist = new IncrementalMagFreqDist(mfdMinMag, mfdNumMag, mfdDelta);
                supraHist = new IncrementalMagFreqDist(mfdMinMag, mfdNumMag, mfdDelta);
                Iterator iterator = completeCatalog.iterator();
                while (iterator.hasNext() && (rup = (ETAS_EqkRupture)iterator.next()).getOriginTime() <= maxOT) {
                    int xIndex = totalHist.getClosestXIndex(rup.getMag());
                    totalHist.add(xIndex, 1.0);
                    this.totalCountHist.add(xIndex, 1.0);
                    if (!this.spontaneousFound && rup.getGeneration() == 0) {
                        System.out.println("Spontaneous rupture found, will include spont MFD plots");
                        this.spontaneousFound = true;
                    }
                    if (rup.getFSSIndex() <= 0) continue;
                    supraHist.add(xIndex, 1.0);
                }
                if (this.cumulative) {
                    this.totalWithSpontStats[i].addHistogram(totalHist.getCumRateDistWithOffset());
                    this.totalWithSpontSupraStats[i].addHistogram(supraHist.getCumRateDistWithOffset());
                } else {
                    this.totalWithSpontStats[i].addHistogram(totalHist);
                    this.totalWithSpontSupraStats[i].addHistogram(supraHist);
                }
            }
            if (this.triggeredStats == null) continue;
            IncrementalMagFreqDist noSpontHist = new IncrementalMagFreqDist(mfdMinMag, mfdNumMag, mfdDelta);
            supraHist = new IncrementalMagFreqDist(mfdMinMag, mfdNumMag, mfdDelta);
            IncrementalMagFreqDist primaryHist = new IncrementalMagFreqDist(mfdMinMag, mfdNumMag, mfdDelta);
            if (triggeredOnlyCatalog != null) {
                ETAS_EqkRupture rup;
                Iterator iterator = triggeredOnlyCatalog.iterator();
                while (iterator.hasNext() && (rup = (ETAS_EqkRupture)iterator.next()).getOriginTime() <= maxOT) {
                    int xIndex = noSpontHist.getClosestXIndex(rup.getMag());
                    noSpontHist.add(xIndex, 1.0);
                    if (this.totalWithSpontStats == null) {
                        this.totalCountHist.add(xIndex, 1.0);
                    }
                    if (rup.getGeneration() == 1) {
                        primaryHist.add(xIndex, 1.0);
                    }
                    if (rup.getFSSIndex() <= 0) continue;
                    supraHist.add(xIndex, 1.0);
                }
            }
            if (this.cumulative) {
                this.triggeredStats[i].addHistogram(noSpontHist.getCumRateDistWithOffset());
                this.triggeredSupraStats[i].addHistogram(supraHist.getCumRateDistWithOffset());
                this.triggeredPrimaryStats[i].addHistogram(primaryHist.getCumRateDistWithOffset());
                continue;
            }
            this.triggeredStats[i].addHistogram(noSpontHist);
            this.triggeredSupraStats[i].addHistogram(supraHist);
            this.triggeredPrimaryStats[i].addHistogram(primaryHist);
        }
        ++this.numCatalogs;
    }

    private String getPlotTitle() {
        if (this.annualize) {
            return "Magnitude Frequency Distribution";
        }
        return "Magnitude Number Distribution";
    }

    public void setHideTitles() {
        this.noTitles = true;
    }

    public void setIncludeMedian(boolean includeMedian) {
        this.includeMedian = includeMedian;
    }

    public void setIncludeMode(boolean includeMode) {
        this.includeMode = includeMode;
    }

    public void setIncludePrimary(boolean includePrimary) {
        this.includePrimary = includePrimary;
    }

    public void setProbColor(Color probColor) {
        this.probColor = probColor;
    }

    @Override
    protected List<? extends Runnable> doFinalize(File outputDir, FaultSystemSolution fss, ExecutorService exec) throws IOException {
        int numToTrim = this.calcNumToTrim();
        if (this.annualize) {
            this.fssMFD = this.calcFSS(fss);
        }
        String title = this.getPlotTitle();
        for (int i = 0; i < this.durations.length; ++i) {
            Object durTitle = title;
            Object durPrefix = this.prefix;
            if (this.durations.length > 1) {
                durTitle = ETAS_MFD_Plot.getTimeLabel(this.durations[i], false) + " " + title;
                durPrefix = ETAS_MFD_Plot.getTimeShortLabel(this.durations[i]).replaceAll(" ", "") + "_" + this.prefix;
            }
            if (this.totalWithSpontStats != null && this.spontaneousFound) {
                Object myTitle = durTitle;
                if (this.triggeredStats != null) {
                    myTitle = (String)myTitle + ", Including Spontaneous";
                }
                this.plot(outputDir, (String)durPrefix, (String)myTitle, this.totalWithSpontStats[i], null, this.totalWithSpontSupraStats[i], numToTrim, fss, this.durations[i]);
            }
            if (this.triggeredStats == null) continue;
            durTitle = (String)durTitle + ", Triggered Events";
            this.plot(outputDir, (String)durPrefix + "_triggered", (String)durTitle, this.triggeredStats[i], this.triggeredPrimaryStats[i], this.triggeredSupraStats[i], numToTrim, fss, this.durations[i]);
        }
        return null;
    }

    @Override
    public List<String> generateMarkdown(String relativePathToOutputDir, String topLevelHeading, String topLink) throws IOException {
        int numToTrim = this.calcNumToTrim();
        ArrayList<String> lines = new ArrayList<String>();
        String title = this.getPlotTitle();
        List<ETAS_EqkRupture> triggerRups = this.getLauncher().getCombinedTriggers();
        if (this.triggeredStats != null && !this.annualize && this.durations.length > 1) {
            lines.add((String)topLevelHeading + " Probabilities Summary Table");
            lines.add(topLink);
            lines.add("");
            double maxTriggerMag = 0.0;
            for (ETAS_EqkRupture trigger : triggerRups) {
                maxTriggerMag = Math.max(maxTriggerMag, trigger.getMag());
            }
            double modalMag = this.totalCountHist.getX(this.totalCountHist.getXindexForMaxY()) - 0.5 * mfdDelta;
            double minTableMag = Math.max(Math.floor(maxTriggerMag - 3.0), Math.floor(modalMag));
            minTableMag = Math.max(minTableMag, Math.ceil(mfdMinMag - 0.5 * mfdDelta));
            double maxMag = 0.0;
            for (Point2D pt : this.totalCountHist) {
                if (!(pt.getY() > 0.0)) continue;
                maxMag = Math.max(maxMag, pt.getX());
            }
            ArrayList<Double> mags = new ArrayList<Double>();
            boolean maxTriggerFound = false;
            for (double mag = minTableMag; mag <= maxMag; mag += 0.5) {
                if ((float)mag == (float)maxTriggerMag) {
                    maxTriggerFound = true;
                }
                mags.add(mag);
            }
            if (!maxTriggerFound && maxTriggerMag > minTableMag) {
                mags.add(maxTriggerMag);
                Collections.sort(mags);
            }
            System.out.println("Table mags: " + Joiner.on((String)", ").join(mags));
            if (this.totalWithSpontStats != null && this.spontaneousFound) {
                lines.add((String)topLevelHeading + "# Probabilities Summary Table, Including Spontaneous");
                lines.add(topLink);
                lines.add("");
                lines.addAll(this.getProbsSummaryTable(mags, this.totalWithSpontStats).build());
                lines.add("");
                lines.add((String)topLevelHeading + "# Probabilities Summary Table, Triggered Only");
                lines.add(topLink);
                lines.add("");
            }
            lines.addAll(this.getProbsSummaryTable(mags, this.triggeredStats).build());
            lines.add("");
        }
        lines.add((String)topLevelHeading + " " + title);
        lines.add(topLink);
        lines.add("");
        if (this.durations.length > 1) {
            topLevelHeading = (String)topLevelHeading + "#";
        }
        int i = this.durations.length;
        while (--i >= 0) {
            Object prefix = this.prefix;
            Object myTitle = title;
            if (this.durations.length > 1) {
                myTitle = ETAS_MFD_Plot.getTimeLabel(this.durations[i], false) + " " + title;
                lines.add((String)topLevelHeading + " " + (String)myTitle);
                lines.add(topLink);
                lines.add("");
                prefix = ETAS_MFD_Plot.getTimeShortLabel(this.durations[i]).replaceAll(" ", "") + "_" + (String)prefix;
            }
            if (this.totalWithSpontStats != null && this.spontaneousFound) {
                if (this.triggeredStats != null) {
                    myTitle = (String)myTitle + ", Including Spontaneous";
                    lines.add((String)topLevelHeading + "# " + (String)myTitle);
                    lines.add(topLink);
                    lines.add("");
                    lines.add("*Note: This section includes both spontaneous and triggered events*");
                    lines.add("");
                }
                lines.addAll(this.buildLegend(this.durations[i]));
                lines.add("");
                lines.add("![MFD Plot](" + relativePathToOutputDir + "/" + (String)prefix + ".png)");
                lines.add("");
                lines.addAll(this.buildTable(this.totalWithSpontStats[i], null, this.totalWithSpontSupraStats[i], numToTrim, this.durations[i]));
                lines.add("");
            }
            if (this.triggeredStats == null) continue;
            myTitle = (String)myTitle + ", Triggered Events";
            if (this.totalWithSpontStats != null) {
                lines.add((String)topLevelHeading + "# " + (String)myTitle);
                lines.add(topLink);
                lines.add("");
                lines.add("*Note: This section only includes triggered events, spontaneous were calculated but filtered out here*");
                lines.add("");
            }
            lines.addAll(this.buildLegend(this.durations[i]));
            lines.add("");
            lines.add("![MFD Plot](" + relativePathToOutputDir + "/" + (String)prefix + "_triggered.png)");
            lines.add("");
            lines.addAll(this.buildTable(this.triggeredStats[i], this.triggeredPrimaryStats[i], this.triggeredSupraStats[i], numToTrim, this.durations[i]));
            lines.add("");
        }
        return lines;
    }

    private MarkdownUtils.TableBuilder getProbsSummaryTable(List<Double> mags, MFD_Stats[] stats) {
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        table.addColumn("Magnitude");
        for (double duration : this.durations) {
            table.addColumn(ETAS_MFD_Plot.getTimeLabel(duration, false) + " Prob");
        }
        table.finalizeLine();
        int numForConf = this.getNumProcessed();
        for (double mag : mags) {
            double val;
            int d;
            table.initNewLine();
            table.addColumn("**M&ge;" + optionalDigitDF.format(mag) + "**");
            for (d = 0; d < this.durations.length; ++d) {
                val = stats[d].probFunc.getInterpolatedY(mag);
                table.addColumn(ETAS_MFD_Plot.getProbStr(val, true));
            }
            table.finalizeLine();
            table.initNewLine();
            table.addColumn("*95% Conf*");
            for (d = 0; d < this.durations.length; ++d) {
                val = stats[d].probFunc.getInterpolatedY(mag);
                table.addColumn("*" + ETAS_MFD_Plot.getConfString(val, numForConf, true) + "*");
            }
            table.finalizeLine();
        }
        return table;
    }

    private static String getFractilesString() {
        ArrayList<CallSite> percents = new ArrayList<CallSite>();
        for (double fractile : fractiles) {
            percents.add((CallSite)((Object)(optionalDigitDF.format(fractile * 100.0) + "%")));
        }
        return Joiner.on((String)",").join(percents);
    }

    private EvenlyDiscretizedFunc calcFSS(FaultSystemSolution fss) {
        GriddedRegion region = this.getLauncher().getRegion();
        IncrementalMagFreqDist fssIncrMFD = fss.calcNucleationMFD_forRegion((Region)region, 5.05, 8.95, 0.1, true);
        GridSourceProvider gridProv = fss.getGridSourceProvider();
        if (gridProv != null) {
            double minMag = 5.0;
            for (int i = 0; i < gridProv.getNumLocations(); ++i) {
                IncrementalMagFreqDist nodeMFD = gridProv.getMFD(i);
                for (int j = 0; j < nodeMFD.size(); ++j) {
                    double x = nodeMFD.getX(j);
                    if (!(x >= minMag)) continue;
                    fssIncrMFD.add(fssIncrMFD.getClosestXIndex(x), nodeMFD.getY(j));
                }
            }
        }
        if (this.cumulative) {
            return fssIncrMFD.getCumRateDistWithOffset();
        }
        return fssIncrMFD;
    }

    private void plot(File outputDir, String prefix, String title, MFD_Stats stats, MFD_Stats primaryStats, MFD_Stats supraStats, int numToTrim, FaultSystemSolution fss, double duration) throws IOException {
        stats.calcStats(this.annualize, this.getConfig());
        supraStats.calcStats(this.annualize, this.getConfig());
        EvenlyDiscretizedFunc meanFunc = stats.getMeanFunc(numToTrim);
        EvenlyDiscretizedFunc medianFunc = stats.getMedianFunc(numToTrim);
        EvenlyDiscretizedFunc modeFunc = stats.getModeFunc(numToTrim);
        EvenlyDiscretizedFunc probFunc = stats.getProbFunc(numToTrim);
        EvenlyDiscretizedFunc supraProbFunc = supraStats.getProbFunc(numToTrim);
        EvenlyDiscretizedFunc[] fractileFuncs = stats.getFractileFuncs(numToTrim);
        meanFunc.setName("Mean");
        modeFunc.setName("Mode");
        medianFunc.setName("Median");
        probFunc.setName(ETAS_MFD_Plot.getTimeShortLabel(duration) + " Prob");
        if (fractileFuncs.length > 0) {
            fractileFuncs[0].setName(ETAS_MFD_Plot.getFractilesString());
            for (int i = 1; i < fractileFuncs.length; ++i) {
                fractileFuncs[i].setName(null);
            }
        }
        ArrayList<AbstractDiscretizedFunc> funcs = new ArrayList<AbstractDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        funcs.add(meanFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK));
        for (EvenlyDiscretizedFunc func : fractileFuncs) {
            funcs.add(func);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        }
        if (this.includeMedian) {
            funcs.add(medianFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        }
        if (this.includeMode) {
            funcs.add(modeFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.CYAN.darker()));
        }
        if (this.fssMFD != null) {
            this.fssMFD.setName("FSS");
            funcs.add(this.fssMFD);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, new Color(86, 44, 0)));
        }
        if (probFunc != null) {
            funcs.add(probFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, this.probColor));
            EvenlyDiscretizedFunc probLower = new EvenlyDiscretizedFunc(probFunc.getMinX(), probFunc.getMaxX(), probFunc.size());
            EvenlyDiscretizedFunc probUpper = new EvenlyDiscretizedFunc(probFunc.getMinX(), probFunc.getMaxX(), probFunc.size());
            double fssMaxMag = fss.getRupSet().getMaxMag();
            for (int i = 0; i < probFunc.size(); ++i) {
                int aboveMax;
                double fract = probFunc.getY(i);
                double x = probFunc.getX(i);
                int n = aboveMax = x - 0.5 * mfdDelta > fssMaxMag ? 1 : 0;
                if (aboveMax != 0) {
                    Preconditions.checkState((fract == 0.0 ? 1 : 0) != 0);
                }
                if (fract >= 1.0 || aboveMax != 0) {
                    probLower.set(x, fract);
                    probUpper.set(x, fract);
                    continue;
                }
                double[] conf = ETAS_Utils.getBinomialProportion95confidenceInterval(fract, this.numCatalogs);
                probLower.set(i, conf[0]);
                probUpper.set(i, conf[1]);
            }
            UncertainArbDiscFunc confFunc = new UncertainArbDiscFunc(probFunc, probLower, probUpper);
            confFunc.setName("95% Conf");
            funcs.add(confFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, new Color(this.probColor.getRed(), this.probColor.getGreen(), this.probColor.getBlue(), 90)));
            if (supraProbFunc != null) {
                supraProbFunc.setName("Supra");
                funcs.add(supraProbFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, this.probColor));
            }
        }
        if (primaryStats != null && this.includePrimary) {
            primaryStats.calcStats(this.annualize, this.getConfig());
            EvenlyDiscretizedFunc primaryFunc = primaryStats.getMeanFunc(numToTrim);
            primaryFunc.setName("Primary");
            funcs.add(primaryFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN.darker()));
        }
        Object yAxisLabel = this.cumulative ? "Cumulative " : "Incremental ";
        yAxisLabel = this.annualize ? (String)yAxisLabel + "Annual Rate" : ETAS_MFD_Plot.getTimeLabel(duration, false) + " " + (String)yAxisLabel + "Number";
        PlotSpec spec = new PlotSpec(funcs, chars, this.noTitles ? " " : title, "Magnitude", (String)yAxisLabel);
        spec.setLegendVisible(true);
        double mfdMinY = ETAS_MFD_Plot.mfdMinY;
        if (mfdMinY > 1.0 / (double)this.numCatalogs) {
            mfdMinY = Math.pow(10.0, Math.floor(Math.log10(1.0 / (double)this.numCatalogs)));
        }
        HeadlessGraphPanel gp = ETAS_MFD_Plot.buildGraphPanel();
        gp.setLegendFontSize(18);
        gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
        gp.setUserBounds(meanFunc.getMinX(), meanFunc.getMaxX(), mfdMinY, mfdMaxY);
        gp.drawGraphPanel(spec, false, true);
        gp.getChartPanel().setSize(800, 600);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
        CSVFile csv = new CSVFile(true);
        ArrayList<Object> header = new ArrayList<Object>();
        header.add("Mag");
        header.add("Mean");
        for (double fractile : fractiles) {
            header.add(optionalDigitDF.format(fractile * 100.0) + " %ile");
        }
        header.add("Median");
        header.add("Mode");
        if (this.fssMFD != null) {
            header.add("Fault System Solution");
        }
        if (probFunc != null) {
            header.add(ETAS_MFD_Plot.getTimeShortLabel(duration) + " Probability");
            if (supraProbFunc != null) {
                header.add(ETAS_MFD_Plot.getTimeShortLabel(duration) + " Supra-Seis Prob");
            }
        }
        EvenlyDiscretizedFunc primaryMean = null;
        if (primaryStats != null) {
            primaryStats.calcStats(this.annualize, this.getConfig());
            primaryMean = primaryStats.getMeanFunc(numToTrim);
            header.add("Primary Aftershocks Mean");
        }
        csv.addLine(header);
        for (int i = 0; i < meanFunc.size(); ++i) {
            double mag = meanFunc.getX(i);
            ArrayList<Object> line = new ArrayList<Object>();
            line.add("" + (float)mag);
            line.add("" + (float)meanFunc.getY(i));
            for (EvenlyDiscretizedFunc fractileFunc : fractileFuncs) {
                line.add("" + (float)fractileFunc.getY(i));
            }
            line.add("" + (float)medianFunc.getY(i));
            line.add("" + (float)modeFunc.getY(i));
            if (this.fssMFD != null) {
                if ((float)mag < (float)this.fssMFD.getMinX()) {
                    line.add("");
                } else {
                    line.add("" + (float)this.fssMFD.getY(this.fssMFD.getClosestXIndex(mag)));
                }
            }
            if (probFunc != null) {
                line.add("" + (float)probFunc.getY(i));
                if (supraProbFunc != null) {
                    line.add("" + (float)supraProbFunc.getY(i));
                }
            }
            if (primaryMean != null) {
                line.add("" + (float)primaryMean.getY(i));
            }
            csv.addLine(line);
        }
        csv.writeToFile(new File(outputDir, prefix + ".csv"));
    }

    public static MFD_Stats readCSV(File csvFile) throws IOException {
        CSVFile<String> csv = CSVFile.readFile(csvFile, true);
        double minMag = csv.getDouble(1, 0);
        int numMag = csv.getNumRows() - 1;
        int meanCol = ETAS_MFD_Plot.getCSVColumn(csv, "Mean");
        EvenlyDiscretizedFunc meanFunc = new EvenlyDiscretizedFunc(minMag, numMag, mfdDelta);
        int probCol = ETAS_MFD_Plot.getCSVColumn(csv, "Probability");
        EvenlyDiscretizedFunc probFunc = probCol >= 0 ? new EvenlyDiscretizedFunc(minMag, numMag, mfdDelta) : null;
        int medianCol = ETAS_MFD_Plot.getCSVColumn(csv, "Median");
        EvenlyDiscretizedFunc medianFunc = new EvenlyDiscretizedFunc(minMag, numMag, mfdDelta);
        int modeCol = ETAS_MFD_Plot.getCSVColumn(csv, "Mode");
        EvenlyDiscretizedFunc modeFunc = new EvenlyDiscretizedFunc(minMag, numMag, mfdDelta);
        int numFracts = medianCol - 1 - meanCol;
        EvenlyDiscretizedFunc[] fractileFuncs = new EvenlyDiscretizedFunc[numFracts];
        for (int i = 0; i < numFracts; ++i) {
            fractileFuncs[i] = new EvenlyDiscretizedFunc(minMag, numMag, mfdDelta);
        }
        for (int m = 0; m < numMag; ++m) {
            int row = m + 1;
            meanFunc.set(m, csv.getDouble(row, meanCol));
            modeFunc.set(m, csv.getDouble(row, modeCol));
            medianFunc.set(m, csv.getDouble(row, medianCol));
            if (probFunc != null) {
                probFunc.set(m, csv.getDouble(row, probCol));
            }
            for (int i = 0; i < numFracts; ++i) {
                fractileFuncs[i].set(m, csv.getDouble(row, meanCol + 1 + i));
            }
        }
        MFD_Stats stats = new MFD_Stats();
        stats.meanFunc = meanFunc;
        stats.probFunc = probFunc;
        stats.medianFunc = medianFunc;
        stats.modeFunc = modeFunc;
        stats.fractileFuncs = fractileFuncs;
        return stats;
    }

    private static int getCSVColumn(CSVFile<String> csv, String name) {
        name = name.toLowerCase();
        for (int col = 1; col < csv.getNumCols(); ++col) {
            if (!csv.get(0, col).toLowerCase().contains(name)) continue;
            return col;
        }
        return -1;
    }

    private int calcNumToTrim() {
        return ETAS_MFD_Plot.calcNumToTrim(this.totalCountHist);
    }

    public double[] getDurations() {
        return this.durations;
    }

    public MFD_Stats[] getFullStats() {
        if (this.totalWithSpontStats != null) {
            return this.totalWithSpontStats;
        }
        return this.triggeredStats;
    }

    static int calcNumToTrim(HistogramFunction totalCountHist) {
        double minMag = mfdMinMag;
        double catModalMag = totalCountHist.getX(totalCountHist.getXindexForMaxY()) - 0.49 * mfdDelta;
        if (Double.isInfinite(catModalMag)) {
            throw new IllegalStateException("Empty catalogs!");
        }
        int numToTrim = 0;
        while (catModalMag > minMag + 0.5 * mfdDelta && minMag < 5.04) {
            minMag += mfdDelta;
            ++numToTrim;
        }
        return numToTrim;
    }

    private static EvenlyDiscretizedFunc trimFunc(EvenlyDiscretizedFunc func, int numToTrim) {
        if (numToTrim == 0 || func == null) {
            return func;
        }
        Preconditions.checkState((numToTrim > 0 ? 1 : 0) != 0);
        Preconditions.checkState((numToTrim < func.size() ? 1 : 0) != 0);
        EvenlyDiscretizedFunc trimmed = new EvenlyDiscretizedFunc(func.getX(numToTrim), func.size() - numToTrim, mfdDelta);
        for (int i = 0; i < trimmed.size(); ++i) {
            trimmed.set(i, func.getY(i + numToTrim));
        }
        return trimmed;
    }

    private List<String> buildLegend(double duration) {
        ArrayList<String> lines = new ArrayList<String>();
        String quantity = this.annualize ? "annual rate" : "expected number";
        lines.add("**Legend**");
        lines.add("* **Mean** (thick black line): mean " + quantity + " across all " + this.numCatalogs + " catalogs");
        lines.add("* **" + ETAS_MFD_Plot.getFractilesString() + "** (thin black lines): " + quantity + " percentiles across all " + this.numCatalogs + " catalogs");
        lines.add("* **Median** (thin blue line): median " + quantity + " across all " + this.numCatalogs + " catalogs");
        if (this.annualize && duration != 1.0) {
            lines.add("* **Mode** (thin cyan line): modal " + quantity + " across all " + this.numCatalogs + " catalogs (scaled to annualized value)");
        } else {
            lines.add("* **Mode** (thin cyan line): modal " + quantity + " across all " + this.numCatalogs + " catalogs");
        }
        if (this.annualize) {
            lines.add("* **Fault System Solution** (brown line): long-term MFD from the UCERF3 fault system solution");
        }
        lines.add("* **" + ETAS_MFD_Plot.getTimeShortLabel(duration) + " Probability** (thin red line): " + ETAS_MFD_Plot.getTimeLabel(duration, false).toLowerCase() + " probability calculated as the fraction of catalogs with at least 1 occurrence");
        lines.add("* **" + ETAS_MFD_Plot.getTimeShortLabel(duration) + " Supraseismogenic Probability** (thin dashed red line): same as above, but only for supraseismogenic ruptures on explicitly modeled UCERF3 faults");
        lines.add("* **95% Conf** (light red shaded region): binomial 95% confidence bounds on probability");
        if (this.triggeredPrimaryStats != null) {
            lines.add("* **Primary** (thin green line): mean " + quantity + " from primary triggered aftershocks only (no secondary, tertiary, etc...) across all " + this.numCatalogs + " catalogs");
        }
        return lines;
    }

    private List<String> buildTable(MFD_Stats stats, MFD_Stats primaryStats, MFD_Stats supraStats, int numToTrim, double duration) throws IOException {
        stats.calcStats(this.annualize, this.getConfig());
        supraStats.calcStats(this.annualize, this.getConfig());
        EvenlyDiscretizedFunc meanFunc = stats.getMeanFunc(numToTrim);
        EvenlyDiscretizedFunc medianFunc = stats.getMedianFunc(numToTrim);
        EvenlyDiscretizedFunc modeFunc = stats.getModeFunc(numToTrim);
        EvenlyDiscretizedFunc probFunc = stats.getProbFunc(numToTrim);
        EvenlyDiscretizedFunc supraProbFunc = supraStats.getProbFunc(numToTrim);
        EvenlyDiscretizedFunc[] fractileFuncs = stats.getFractileFuncs(numToTrim);
        MarkdownUtils.TableBuilder builder = MarkdownUtils.tableBuilder();
        builder.initNewLine().addColumn("Mag").addColumn("Mean");
        for (double fractile : fractiles) {
            builder.addColumn(optionalDigitDF.format(fractile * 100.0) + " %ile");
        }
        builder.addColumn("Median");
        builder.addColumn("Mode");
        if (this.fssMFD != null) {
            builder.addColumn("Long-Term Fault System Solution");
        }
        if (probFunc != null) {
            builder.addColumn(ETAS_MFD_Plot.getTimeShortLabel(duration) + " Probability");
            builder.addColumn(ETAS_MFD_Plot.getTimeShortLabel(duration) + " Prob 95% Conf");
            if (supraProbFunc != null) {
                builder.addColumn(ETAS_MFD_Plot.getTimeShortLabel(duration) + " Supra-Seis Prob");
            }
        }
        EvenlyDiscretizedFunc primaryMean = null;
        if (primaryStats != null) {
            primaryStats.calcStats(this.annualize, this.getConfig());
            primaryMean = primaryStats.getMeanFunc(numToTrim);
            builder.addColumn("Primary Aftershocks Mean");
        }
        builder.finalizeLine();
        int numForConf = this.getNumProcessed();
        for (int i = 0; i < meanFunc.size(); ++i) {
            double mag = meanFunc.getX(i);
            builder.initNewLine();
            if (this.cumulative) {
                builder.addColumn("**M&ge;" + optionalDigitDF.format(mag) + "**");
            } else {
                builder.addColumn("**M" + optionalDigitDF.format(mag - 0.5 * mfdDelta) + "-" + optionalDigitDF.format(mag + 0.5 * mfdDelta) + "**");
            }
            builder.addColumn(ETAS_MFD_Plot.getProbStr(meanFunc.getY(i)));
            for (EvenlyDiscretizedFunc fractileFunc : fractileFuncs) {
                builder.addColumn(ETAS_MFD_Plot.getProbStr(fractileFunc.getY(i)));
            }
            builder.addColumn(ETAS_MFD_Plot.getProbStr(medianFunc.getY(i)));
            builder.addColumn(ETAS_MFD_Plot.getProbStr(modeFunc.getY(i)));
            if (this.fssMFD != null) {
                if ((float)mag < (float)this.fssMFD.getMinX()) {
                    builder.addColumn("");
                } else {
                    builder.addColumn(ETAS_MFD_Plot.getProbStr(this.fssMFD.getY(this.fssMFD.getClosestXIndex(mag))));
                }
            }
            if (probFunc != null) {
                builder.addColumn(ETAS_MFD_Plot.getProbStr(probFunc.getY(i), true));
                builder.addColumn(ETAS_MFD_Plot.getConfString(probFunc.getY(i), numForConf, true));
                if (supraProbFunc != null) {
                    builder.addColumn(ETAS_MFD_Plot.getProbStr(supraProbFunc.getY(i), true));
                }
            }
            if (primaryMean != null) {
                builder.addColumn(ETAS_MFD_Plot.getProbStr(primaryMean.getY(i)));
            }
            builder.finalizeLine();
        }
        return builder.build();
    }

    public static class MFD_Stats {
        private XY_DataSetList histList = new XY_DataSetList();
        private List<Double> relativeWeights = new ArrayList<Double>();
        private EvenlyDiscretizedFunc meanFunc;
        private EvenlyDiscretizedFunc probFunc;
        private EvenlyDiscretizedFunc medianFunc;
        private EvenlyDiscretizedFunc modeFunc;
        private EvenlyDiscretizedFunc[] fractileFuncs;

        public synchronized void addHistogram(EvenlyDiscretizedFunc func) {
            this.histList.add(func);
            this.relativeWeights.add(1.0);
            if (this.meanFunc != null) {
                this.meanFunc = null;
                this.probFunc = null;
                this.medianFunc = null;
                this.modeFunc = null;
                this.fractileFuncs = null;
            }
        }

        public EvenlyDiscretizedFunc[] getFractileFuncs(int numToTrim) {
            if (numToTrim == 0) {
                return this.fractileFuncs;
            }
            EvenlyDiscretizedFunc[] trimmed = new EvenlyDiscretizedFunc[this.fractileFuncs.length];
            for (int i = 0; i < trimmed.length; ++i) {
                trimmed[i] = ETAS_MFD_Plot.trimFunc(this.fractileFuncs[i], numToTrim);
            }
            return trimmed;
        }

        public EvenlyDiscretizedFunc getMeanFunc(int numToTrim) {
            return ETAS_MFD_Plot.trimFunc(this.meanFunc, numToTrim);
        }

        public EvenlyDiscretizedFunc getProbFunc(int numToTrim) {
            return ETAS_MFD_Plot.trimFunc(this.probFunc, numToTrim);
        }

        public EvenlyDiscretizedFunc getMedianFunc(int numToTrim) {
            return ETAS_MFD_Plot.trimFunc(this.medianFunc, numToTrim);
        }

        public EvenlyDiscretizedFunc getModeFunc(int numToTrim) {
            return ETAS_MFD_Plot.trimFunc(this.modeFunc, numToTrim);
        }

        public synchronized void calcStats(boolean annualize, ETAS_Config config) {
            if (this.meanFunc != null) {
                return;
            }
            Preconditions.checkState((!this.histList.isEmpty() ? 1 : 0) != 0);
            EvenlyDiscretizedFunc func0 = (EvenlyDiscretizedFunc)this.histList.get(0);
            double minMag = func0.getMinX();
            int numMag = func0.size();
            double deltaMag = func0.getDelta();
            this.meanFunc = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
            this.probFunc = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
            this.medianFunc = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
            this.modeFunc = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
            this.fractileFuncs = new EvenlyDiscretizedFunc[fractiles.length];
            for (int i = 0; i < fractiles.length; ++i) {
                this.fractileFuncs[i] = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
            }
            FractileCurveCalculator fractileCalc = new FractileCurveCalculator(this.histList, this.relativeWeights);
            AbstractXY_DataSet meanCurve = fractileCalc.getMeanCurve();
            HashMap<Double, AbstractXY_DataSet> fractileCurves = null;
            fractileCurves = new HashMap<Double, AbstractXY_DataSet>();
            double[] dArray = fractiles;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double fractile = dArray[i];
                fractileCurves.put(fractile, fractileCalc.getFractile(fractile));
            }
            fractileCurves.put(0.5, fractileCalc.getFractile(0.5));
            double rateScalar = 1.0;
            if (annualize) {
                rateScalar = 1.0 / config.getDuration();
            }
            for (int i = 0; i < meanCurve.size(); ++i) {
                this.meanFunc.set(i, meanCurve.getY(i) * rateScalar);
                ArbDiscrEmpiricalDistFunc dist = fractileCalc.getEmpiricalDist(i);
                double mode = dist.size() == 1 ? dist.getX(0) : dist.getMostCentralMode();
                this.modeFunc.set(i, mode * rateScalar);
                int numWith = 0;
                for (XY_DataSet func : this.histList) {
                    if (!(func.getY(i) > 0.0)) continue;
                    ++numWith;
                }
                this.probFunc.set(i, (double)numWith / (double)this.histList.size());
                for (int j = 0; j < fractiles.length; ++j) {
                    double fractile = fractiles[j];
                    AbstractXY_DataSet fractileCurve = (AbstractXY_DataSet)fractileCurves.get(fractile);
                    this.fractileFuncs[j].set(i, fractileCurve.getY(i) * rateScalar);
                }
                AbstractXY_DataSet medianCurve = (AbstractXY_DataSet)fractileCurves.get(0.5);
                this.medianFunc.set(i, medianCurve.getY(i) * rateScalar);
            }
        }
    }
}

