/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.analysis;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_MFD_Plot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;

public class ETAS_StationarityPlot
extends ETAS_AbstractPlot {
    public static final double MIN_SIM_DURATION = 99.0;
    private static final double YEARS_PER_BIN = 10.0;
    private static final int MAX_TABLE_ROWS = 20;
    private EvenlyDiscretizedFunc xVals;
    private List<EvenlyDiscretizedFunc[]> simFuncs;
    private List<EvenlyDiscretizedFunc> simMomFuncs;
    private double[] mags = new double[]{2.5, 5.0, 6.0, 7.0};
    private double plotMinMag;
    private HistogramFunction totalCountHist;
    private String prefix;

    protected ETAS_StationarityPlot(ETAS_Config config, ETAS_Launcher launcher, String prefix) {
        super(config, launcher);
        this.prefix = prefix;
        double totDuration = config.getDuration();
        int numX = (int)(totDuration / 10.0);
        this.xVals = new EvenlyDiscretizedFunc(5.0, numX, 10.0);
        this.simFuncs = new ArrayList<EvenlyDiscretizedFunc[]>();
        this.simMomFuncs = new ArrayList<EvenlyDiscretizedFunc>();
        this.totalCountHist = new HistogramFunction(ETAS_MFD_Plot.mfdMinMag, ETAS_MFD_Plot.mfdNumMag, ETAS_MFD_Plot.mfdDelta);
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public boolean isFilterSpontaneous() {
        return false;
    }

    @Override
    protected void doProcessCatalog(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
        long simStartTime = this.getConfig().getSimulationStartTimeMillis();
        EvenlyDiscretizedFunc[] magFuncs = new EvenlyDiscretizedFunc[this.mags.length];
        for (int m = 0; m < this.mags.length; ++m) {
            magFuncs[m] = new EvenlyDiscretizedFunc(this.xVals.getMinX(), this.xVals.getMaxX(), this.xVals.size());
        }
        EvenlyDiscretizedFunc momFunc = new EvenlyDiscretizedFunc(this.xVals.getMinX(), this.xVals.getMaxX(), this.xVals.size());
        double maxX = this.xVals.getMaxX() + 0.5 * this.xVals.getDelta();
        for (ETAS_EqkRupture rup : completeCatalog) {
            this.totalCountHist.add(this.totalCountHist.getClosestXIndex(rup.getMag()), 1.0);
            double relativeTime = (double)(rup.getOriginTime() - simStartTime) / 3.15576E10;
            if (relativeTime > maxX) continue;
            int timeX = this.xVals.getClosestXIndex(relativeTime);
            for (int m = 0; m < this.mags.length; ++m) {
                if (!(rup.getMag() >= this.mags[m])) continue;
                magFuncs[m].add(timeX, 1.0);
            }
            momFunc.add(timeX, MagUtils.magToMoment(rup.getMag()));
        }
        this.simFuncs.add(magFuncs);
        this.simMomFuncs.add(momFunc);
    }

    @Override
    protected List<? extends Runnable> doFinalize(File outputDir, FaultSystemSolution fss, ExecutorService exec) throws IOException {
        int numToTrim = ETAS_MFD_Plot.calcNumToTrim(this.totalCountHist);
        this.plotMinMag = this.totalCountHist.getX(numToTrim) - this.totalCountHist.getDelta();
        ArrayList<EvenlyDiscretizedFunc> magFuncs = new ArrayList<EvenlyDiscretizedFunc>();
        ArrayList<Double> means = new ArrayList<Double>();
        for (int m = 0; m < this.mags.length; ++m) {
            if (this.mags[m] < this.plotMinMag) continue;
            EvenlyDiscretizedFunc meanFunc = new EvenlyDiscretizedFunc(this.xVals.getMinX(), this.xVals.getMaxX(), this.xVals.size());
            for (EvenlyDiscretizedFunc[] simFunc : this.simFuncs) {
                for (int i = 0; i < this.xVals.size(); ++i) {
                    meanFunc.add(i, simFunc[m].getY(i));
                }
            }
            meanFunc.scale(1.0 / (double)this.simFuncs.size());
            meanFunc.scale(0.1);
            meanFunc.setName("M\u2265" + (float)this.mags[m]);
            magFuncs.add(meanFunc);
            double mean = meanFunc.calcSumOfY_Vals() / (double)meanFunc.size();
            means.add(mean);
            System.out.println("Mean " + meanFunc.getName() + ": " + mean);
        }
        CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(0.0, Math.max(1, magFuncs.size() - 1));
        ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        double halfDelta = this.xVals.getDelta() * 0.5;
        double maxX = this.xVals.getMaxX() + halfDelta;
        double minNonZeroY = Double.POSITIVE_INFINITY;
        double maxY = 0.0;
        for (int i = 0; i < magFuncs.size(); ++i) {
            EvenlyDiscretizedFunc meanFunc = (EvenlyDiscretizedFunc)magFuncs.get(i);
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            for (int x = 0; x < meanFunc.size(); ++x) {
                double y = meanFunc.getY(x);
                if (!(y > 0.0)) continue;
                maxY = Math.max(y, maxY);
                minNonZeroY = Math.min(y, minNonZeroY);
                double middle = meanFunc.getX(x);
                xy.set(middle - halfDelta, y);
                xy.set(middle + halfDelta, y);
            }
            if (xy.size() == 0) continue;
            funcs.add(xy);
            Color c = cpt.getColor(i).darker();
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, c));
            double mean = (Double)means.get(i);
            xy.setName(meanFunc.getName() + ", mean=" + (float)mean);
            DefaultXY_DataSet meanXY = new DefaultXY_DataSet();
            meanXY.set(0.0, mean);
            meanXY.set(maxX, mean);
            funcs.add(meanXY);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, c));
        }
        String title = "ETAS Simulation Stationarity";
        PlotSpec spec = new PlotSpec(funcs, chars, title, "Simulated Years", "Annual Rate");
        spec.setLegendVisible(true);
        Range xRange = new Range(0.0, maxX);
        System.out.println("Y range: " + minNonZeroY + " " + maxY);
        Range yRange = ETAS_StationarityPlot.getYRange(minNonZeroY, maxY);
        HeadlessGraphPanel gp = ETAS_StationarityPlot.buildGraphPanel();
        gp.drawGraphPanel(spec, false, true, xRange, yRange);
        gp.getChartPanel().setSize(1000, 700);
        gp.saveAsPNG(new File(outputDir, this.prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, this.prefix + ".pdf").getAbsolutePath());
        funcs = new ArrayList();
        chars = new ArrayList();
        EvenlyDiscretizedFunc momFunc = this.xVals.deepClone();
        for (EvenlyDiscretizedFunc simMomFunc : this.simMomFuncs) {
            for (int i = 0; i < momFunc.size(); ++i) {
                momFunc.add(i, simMomFunc.getY(i));
            }
        }
        momFunc.scale(1.0 / (double)this.simMomFuncs.size());
        maxY = momFunc.getMaxY();
        minNonZeroY = Double.POSITIVE_INFINITY;
        double mean = 0.0;
        for (Point2D pt : momFunc) {
            if (pt.getY() > 0.0) {
                minNonZeroY = Math.min(minNonZeroY, pt.getY());
            }
            mean += pt.getY();
        }
        mean /= (double)momFunc.size();
        DefaultXY_DataSet xy = new DefaultXY_DataSet();
        for (int x = 0; x < momFunc.size(); ++x) {
            double y = momFunc.getY(x);
            if (!(y > 0.0)) continue;
            maxY = Math.max(y, maxY);
            minNonZeroY = Math.min(y, minNonZeroY);
            double middle = momFunc.getX(x);
            xy.set(middle - halfDelta, y);
            xy.set(middle + halfDelta, y);
        }
        funcs.add(xy);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
        xy.setName("Mean=" + (float)mean);
        DefaultXY_DataSet meanXY = new DefaultXY_DataSet();
        meanXY.set(0.0, mean);
        meanXY.set(maxX, mean);
        funcs.add(meanXY);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        spec = new PlotSpec(funcs, chars, title, "Simulated Years", "Annual Moment Rate");
        spec.setLegendVisible(true);
        System.out.println("Y range: " + minNonZeroY + " " + maxY);
        yRange = ETAS_StationarityPlot.getYRange(minNonZeroY, maxY);
        gp.drawGraphPanel(spec, false, true, xRange, yRange);
        gp.getChartPanel().setSize(1000, 700);
        gp.saveAsPNG(new File(outputDir, this.prefix + "_mom.png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, this.prefix + "_mom.pdf").getAbsolutePath());
        return null;
    }

    private static Range getYRange(double minY, double maxY) {
        minY /= 2.0;
        maxY *= 2.0;
        minY = Math.pow(10.0, Math.floor(Math.log10(minY)));
        maxY = Math.pow(10.0, Math.ceil(Math.log10(maxY)));
        return new Range(minY, maxY);
    }

    @Override
    public List<String> generateMarkdown(String relativePathToOutputDir, String topLevelHeading, String topLink) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(topLevelHeading + " Simulation Stationarity");
        lines.add(topLink);
        lines.add("");
        lines.add("![Stationarity Plot](" + relativePathToOutputDir + "/" + this.prefix + ".png)");
        lines.add("");
        lines.add("![Moment Rate Plot](" + relativePathToOutputDir + "/" + this.prefix + "_mom.png)");
        lines.add("");
        return lines;
    }
}

