/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.association;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.SurfaceCachingPolicy;
import org.opensha.sha.faultSurface.cache.SurfaceDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistances;
import org.opensha.sha.faultSurface.utils.GriddedSurfaceUtils;

class ArbitrarilyDiscretizedSurface
implements RuptureSurface,
CacheEnabledSurface,
Iterable<Location>,
XMLSaveable {
    public static String XML_METADATA_NAME = "ArbitrarilyDiscretizedSurface";
    private static boolean D = false;
    private static final boolean GRID_CENTERED_DEFAULT = true;
    private LocationList locs;
    private LocationList lowerEdge;
    private FaultTrace upperEdge;
    private double minDepth;
    private double maxDepth;
    private DistsRecord[] locDists;
    private Double lengthEst;
    private Distance distForLengthEst;
    private Double widthEst;
    private double horzComponentOfWidth = 0.0;
    private Double dipEst;
    private Double gridSpacingEst;
    private Boolean uniformSpacing;
    private Boolean gridCentered;
    private SurfaceDistanceCache cache = SurfaceCachingPolicy.build(this);

    public ArbitrarilyDiscretizedSurface(LocationList locs) {
        this(locs, null);
    }

    public ArbitrarilyDiscretizedSurface(LocationList locs, Boolean gridCentered) {
        Preconditions.checkState((!locs.isEmpty() ? 1 : 0) != 0);
        this.locs = locs;
        this.minDepth = Double.POSITIVE_INFINITY;
        this.maxDepth = Double.NEGATIVE_INFINITY;
        for (Location loc : locs) {
            double depth = loc.getDepth();
            if (gridCentered == null && (float)depth == 0.0f) {
                if (D) {
                    System.out.println("found zero depth, so it cannot be grid centered. setting gridCentered=false");
                }
                gridCentered = false;
            }
            if (depth < this.minDepth) {
                this.minDepth = depth;
            }
            if (!(depth > this.maxDepth)) continue;
            this.maxDepth = depth;
        }
        this.gridCentered = gridCentered;
    }

    private synchronized boolean isGridCentered() {
        double amountAboveSurface;
        if (this.gridCentered != null) {
            return this.gridCentered;
        }
        double aveSpacing = this.getAveGridSpacing();
        double aveDip = this.getAveDip();
        double vertComp = Math.sin(Math.toRadians(aveDip)) * aveSpacing;
        if (D) {
            System.out.println("vertical component of aveSpacing with assumed dip=" + (float)aveDip + ": " + (float)vertComp);
        }
        if ((amountAboveSurface = -(this.minDepth - vertComp)) / aveSpacing > 0.1) {
            if (D) {
                System.out.println("Assuming gridCentered=false because if false it would stick up " + amountAboveSurface + " km above the surface");
            }
            this.gridCentered = false;
        } else {
            this.gridCentered = true;
            if (D) {
                System.out.println("Couldn't determine grid spacing, assuming default: true");
            }
        }
        return this.gridCentered;
    }

    private DistsRecord[] getCalcDistances() {
        int i;
        if (this.locDists != null) {
            return this.locDists;
        }
        this.locDists = new DistsRecord[this.locs.size()];
        for (i = 0; i < this.locs.size(); ++i) {
            this.locDists[i] = new DistsRecord((Location)this.locs.get(i));
        }
        for (i = 0; i < this.locs.size(); ++i) {
            Location loc1 = (Location)this.locs.get(i);
            for (int j = i + 1; j < this.locs.size(); ++j) {
                Location loc2 = (Location)this.locs.get(j);
                Distance dist = new Distance(loc1, loc2);
                Preconditions.checkState((dist.dist3D > 0.0 ? 1 : 0) != 0, (String)"0 distance found between points %s and %s.\n\t%s\n\t%s", (Object)i, (Object)j, (Object)loc1, (Object)loc2);
                this.locDists[i].addDistance(dist);
                this.locDists[j].addDistance(dist);
            }
        }
        return this.locDists;
    }

    @Override
    public synchronized double getAveDip() {
        if (this.dipEst != null) {
            return this.dipEst;
        }
        double width = this.getRawWidthEstimate();
        this.dipEst = (float)this.horzComponentOfWidth == 0.0f ? Double.valueOf(90.0) : Double.valueOf(Math.toDegrees(Math.acos(this.horzComponentOfWidth / width)));
        if (D) {
            System.out.println("Estimated dip of " + this.dipEst.floatValue() + " from width of " + (float)width + "  with horzComp=" + (float)this.horzComponentOfWidth);
        }
        return this.dipEst;
    }

    @Override
    public double getAveStrike() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public synchronized double getAveLength() {
        if (this.lengthEst != null) {
            return this.lengthEst;
        }
        double maxHorzDist = Double.NEGATIVE_INFINITY;
        Distance maxHorzRecord = null;
        for (DistsRecord dist : this.getCalcDistances()) {
            if (!(dist.horzVertPenalizedDist > maxHorzDist)) continue;
            maxHorzDist = dist.horzVertPenalizedDist;
            maxHorzRecord = dist.farthestHorizVertPenalized;
        }
        Preconditions.checkNotNull(maxHorzRecord);
        Preconditions.checkState((maxHorzDist > 0.0 ? 1 : 0) != 0, (String)"Negative max vert-penalized dist? %s\n%s", (Object)maxHorzDist, maxHorzRecord);
        Preconditions.checkState(((float)maxHorzRecord.vertDist == 0.0f || maxHorzRecord.vertDist < this.getAveGridSpacing() ? 1 : 0) != 0, (String)"vertical component of location pair for length estimate (%s) is larger than grid spacing (%s)", (Object)maxHorzRecord.vertDist, (Object)this.getAveGridSpacing());
        this.lengthEst = maxHorzRecord.horzDist;
        this.distForLengthEst = maxHorzRecord;
        if (this.isGridCentered()) {
            this.lengthEst = this.lengthEst + this.getAveGridSpacing();
        }
        if (D) {
            System.out.println("getAveLength(): Estimated ave length: " + this.lengthEst.floatValue() + " with maximim vert-penalized dist of " + (float)maxHorzDist + ". Distance record:\n" + String.valueOf(maxHorzRecord));
        }
        return this.lengthEst;
    }

    @Override
    public synchronized double getAveWidth() {
        double width = this.getRawWidthEstimate();
        if (this.isGridCentered()) {
            width += this.getAveGridSpacing();
        }
        return width;
    }

    private synchronized double getRawWidthEstimate() {
        double len = this.getAveLength();
        double maxPositiveDist = 0.0;
        double maxNegativeDist = 0.0;
        Preconditions.checkNotNull((Object)this.distForLengthEst, (String)"Somehow no distForLengthEst but len calculated: %s", (Object)len);
        Location p1 = this.distForLengthEst.loc1;
        Location p2 = this.distForLengthEst.loc2;
        for (Location loc : this.locs) {
            double dist = LocationUtils.distanceToLineFast(p1, p2, loc);
            if (Double.isNaN(dist)) continue;
            if (dist > maxPositiveDist) {
                maxPositiveDist = dist;
            }
            if (!(dist < maxNegativeDist)) continue;
            maxNegativeDist = dist;
        }
        this.horzComponentOfWidth = -maxNegativeDist + maxPositiveDist;
        if (D) {
            System.out.println("getAveWidth(): estimated horizontal component to be abs(" + (float)maxNegativeDist + ") + " + (float)maxPositiveDist + " = " + (float)this.horzComponentOfWidth);
        }
        double totVert = this.maxDepth - this.minDepth;
        this.widthEst = Math.sqrt(this.horzComponentOfWidth * this.horzComponentOfWidth + totVert * totVert);
        return this.widthEst;
    }

    @Override
    public double getArea() {
        double aveSpacing = this.getAveGridSpacing();
        if (this.uniformSpacing.booleanValue()) {
            double aveArea = aveSpacing * aveSpacing;
            if (this.isGridCentered()) {
                return (double)this.locs.size() * aveArea;
            }
            double estAlongStrike = this.getAveLength() / aveSpacing;
            double estDownDip = this.getAveWidth() / aveSpacing;
            double estNumBoundary = estAlongStrike * 2.0 + estDownDip * 2.0 - 4.0;
            return ((double)this.locs.size() - 0.5 * estNumBoundary) * aveArea;
        }
        double length = this.getAveLength();
        double width = this.getAveWidth();
        return length * width;
    }

    @Override
    public double getAreaInsideRegion(Region region) {
        double area = this.getArea();
        double areaEach = area / (double)this.size();
        double areaInside = 0.0;
        for (Location loc : this.locs) {
            if (!region.contains(loc)) continue;
            areaInside += areaEach;
        }
        return areaInside;
    }

    @Override
    public int getEvenlyDiscretizedNumLocs() {
        return this.locs.size();
    }

    @Override
    public Location getEvenlyDiscretizedLocation(int index) {
        return (Location)this.locs.get(index);
    }

    @Override
    public LocationList getEvenlyDiscritizedListOfLocsOnSurface() {
        return this.locs;
    }

    @Override
    public ListIterator<Location> getLocationsIterator() {
        return this.locs.listIterator();
    }

    @Override
    public LocationList getEvenlyDiscritizedPerimeter() {
        throw new UnsupportedOperationException("Not implemented");
    }

    private void calcUpperLower() {
        if (this.lowerEdge != null) {
            return;
        }
        double halfSpacing = 0.5 * this.getAveGridSpacing();
        double maxDepthUpper = this.minDepth + halfSpacing;
        double minDepthLower = this.maxDepth - halfSpacing;
        this.lowerEdge = new LocationList();
        this.upperEdge = new FaultTrace(null);
        for (Location loc : this.locs) {
            if (loc.getDepth() <= maxDepthUpper) {
                this.upperEdge.add(loc);
            }
            if (!(loc.getDepth() >= minDepthLower)) continue;
            this.lowerEdge.add(loc);
        }
    }

    @Override
    public synchronized FaultTrace getEvenlyDiscritizedUpperEdge() {
        this.calcUpperLower();
        return this.upperEdge;
    }

    @Override
    public synchronized LocationList getEvenlyDiscritizedLowerEdge() {
        this.calcUpperLower();
        return this.lowerEdge;
    }

    @Override
    public synchronized double getAveGridSpacing() {
        if (this.gridSpacingEst != null) {
            return this.gridSpacingEst;
        }
        DistsRecord[] distRecs = this.getCalcDistances();
        double[] spacings = new double[distRecs.length];
        for (int i = 0; i < distRecs.length; ++i) {
            spacings[i] = distRecs[i].nearest3D.dist3D;
        }
        double aveDist = StatUtils.mean((double[])spacings);
        double maxDist = StatUtils.max((double[])spacings);
        if (D) {
            System.out.println("getAveGridSpacing(): ave=" + (float)aveDist + ", max=" + (float)maxDist);
        }
        this.uniformSpacing = DataUtils.getPercentDiff(maxDist, aveDist) <= 5.0;
        if (!this.uniformSpacing.booleanValue()) {
            System.out.println("WARNING: not evenly spaced. Average distToClosest=" + (float)aveDist + ", max=" + (float)maxDist);
        }
        this.gridSpacingEst = aveDist;
        return aveDist;
    }

    @Override
    public double getDistanceRup(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceRup();
    }

    @Override
    public double getDistanceJB(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceJB();
    }

    @Override
    public double getDistanceSeis(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceSeis();
    }

    @Override
    public double getDistanceX(Location siteLoc) {
        return this.cache.getDistanceX(siteLoc);
    }

    @Override
    public double calcDistanceX(Location siteLoc) {
        return GriddedSurfaceUtils.getDistanceX(this.getEvenlyDiscritizedUpperEdge(), siteLoc);
    }

    @Override
    public double getAveRupTopDepth() {
        return this.minDepth;
    }

    @Override
    public double getAveDipDirection() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public synchronized FaultTrace getUpperEdge() {
        this.calcUpperLower();
        return this.upperEdge;
    }

    @Override
    public LocationList getPerimeter() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Location getFirstLocOnUpperEdge() {
        return this.getUpperEdge().first();
    }

    @Override
    public Location getLastLocOnUpperEdge() {
        return this.getUpperEdge().last();
    }

    @Override
    public double getFractionOfSurfaceInRegion(Region region) {
        double numInside = 0.0;
        for (Location loc : this) {
            if (!region.contains(loc)) continue;
            numInside += 1.0;
        }
        return numInside / (double)this.size();
    }

    @Override
    public String getInfo() {
        return "Arbitrarily Discretized Surf with " + this.size() + " locs";
    }

    @Override
    public boolean isPointSurface() {
        return this.locs.size() == 1;
    }

    @Override
    public double getMinDistance(RuptureSurface surface) {
        return GriddedSurfaceUtils.getMinDistanceBetweenSurfaces(surface, this);
    }

    @Override
    public RuptureSurface getMoved(LocationVector v) {
        LocationList moved = new LocationList();
        for (Location loc : this.locs) {
            moved.add(LocationUtils.location(loc, v));
        }
        return new ArbitrarilyDiscretizedSurface(moved, this.isGridCentered());
    }

    @Override
    public RuptureSurface copyShallow() {
        LocationList locs2 = new LocationList();
        locs2.addAll(this.locs);
        return new ArbitrarilyDiscretizedSurface(locs2, this.isGridCentered());
    }

    @Override
    public SurfaceDistances calcDistances(Location loc) {
        Location loc1 = loc;
        double distJB = Double.MAX_VALUE;
        double distSeis = Double.MAX_VALUE;
        double distRup = Double.MAX_VALUE;
        ListIterator<Location> it = this.getLocationsIterator();
        while (it.hasNext()) {
            double rupDist;
            Location loc2 = it.next();
            double vertDist = LocationUtils.vertDistance(loc1, loc2);
            double horzDist = LocationUtils.horzDistanceFast(loc1, loc2);
            if (horzDist < distJB) {
                distJB = horzDist;
            }
            if ((rupDist = horzDist * horzDist + vertDist * vertDist) < distRup) {
                distRup = rupDist;
            }
            if (!(loc2.getDepth() >= 3.0) || !(rupDist < distSeis)) continue;
            distSeis = rupDist;
        }
        distRup = Math.pow(distRup, 0.5);
        distSeis = Math.pow(distSeis, 0.5);
        return new SurfaceDistances(distRup, distJB, distSeis);
    }

    @Override
    public double getQuickDistance(Location siteLoc) {
        return this.cache.getQuickDistance(siteLoc);
    }

    @Override
    public double calcQuickDistance(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceRup();
    }

    @Override
    public Iterator<Location> iterator() {
        return this.locs.iterator();
    }

    public int size() {
        return this.locs.size();
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        el.addAttribute("gridCentered", "" + this.isGridCentered());
        this.locs.toXMLMetadata(el);
        return root;
    }

    public static ArbitrarilyDiscretizedSurface fromXMLMetadata(Element el) {
        LocationList locs = LocationList.fromXMLMetadata(el.element("LocationList"));
        Attribute centerEl = el.attribute("gridCentered");
        Boolean gridCentered = null;
        if (centerEl != null) {
            gridCentered = Boolean.parseBoolean(centerEl.getValue());
        }
        return new ArbitrarilyDiscretizedSurface(locs, gridCentered);
    }

    @Override
    public void clearCache() {
        this.cache.clearCache();
    }

    private static FaultTrace buildTestTrace(Location ... locs) {
        FaultTrace trace = new FaultTrace(null);
        for (Location loc : locs) {
            trace.add(loc);
        }
        return trace;
    }

    public static void main(String[] args) {
        ArrayList<SimpleFaultData> testSFDs = new ArrayList<SimpleFaultData>();
        testSFDs.add(new SimpleFaultData(90.0, 10.0, 0.0, ArbitrarilyDiscretizedSurface.buildTestTrace(new Location(0.0, 0.0), new Location(1.0, 1.0))));
        testSFDs.add(new SimpleFaultData(90.0, 10.0, 4.0, ArbitrarilyDiscretizedSurface.buildTestTrace(new Location(0.0, 0.0), new Location(1.0, 1.0))));
        testSFDs.add(new SimpleFaultData(45.0, 10.0, 0.0, ArbitrarilyDiscretizedSurface.buildTestTrace(new Location(0.0, 0.0), new Location(1.0, 1.0))));
        testSFDs.add(new SimpleFaultData(45.0, 10.0, 4.0, ArbitrarilyDiscretizedSurface.buildTestTrace(new Location(0.0, 0.0), new Location(1.0, 1.0))));
        double[] gridSpacings = new double[]{0.5, 1.0};
        double[] randScrambles = new double[]{0.0, 0.01, 0.5};
        for (SimpleFaultData sfd : testSFDs) {
            System.out.println("*********************");
            System.out.println("Upper: " + sfd.getUpperSeismogenicDepth());
            System.out.println("Lower: " + sfd.getLowerSeismogenicDepth());
            System.out.println("Dip: " + sfd.getAveDip());
            System.out.println("*********************");
            for (double gridSpacing : gridSpacings) {
                StirlingGriddedSurface gridSurf = new StirlingGriddedSurface(sfd, gridSpacing);
                System.out.println();
                System.out.println("Grid spacing: " + gridSpacing);
                System.out.println("Width: " + gridSurf.getAveWidth());
                System.out.println();
                LocationList locs = gridSurf.getEvenlyDiscritizedListOfLocsOnSurface();
                for (double randScramble : randScrambles) {
                    LocationList myLocs;
                    System.out.println("Doing test with randScramble=" + randScramble);
                    if (randScramble > 0.0) {
                        myLocs = new LocationList();
                        for (Location loc : locs) {
                            double azimuth = Math.random() * 360.0;
                            double horiz = Math.random() * randScramble;
                            double vert = Math.random() * randScramble;
                            LocationVector vector = new LocationVector(azimuth, horiz, vert);
                            myLocs.add(LocationUtils.location(loc, vector));
                        }
                    } else {
                        myLocs = locs;
                    }
                    System.out.println();
                    ArbitrarilyDiscretizedSurface arbSurf = new ArbitrarilyDiscretizedSurface(myLocs);
                    ArrayList<Double> arbVals = new ArrayList<Double>();
                    ArrayList<Double> actualVals = new ArrayList<Double>();
                    ArrayList<String> names = new ArrayList<String>();
                    names.add("spacing");
                    arbVals.add(arbSurf.getAveGridSpacing());
                    actualVals.add(gridSurf.getAveGridSpacing());
                    names.add("area");
                    arbVals.add(arbSurf.getArea());
                    actualVals.add(gridSurf.getArea());
                    names.add("length");
                    arbVals.add(arbSurf.getAveLength());
                    actualVals.add(gridSurf.getAveLength());
                    names.add("width");
                    arbVals.add(arbSurf.getAveWidth());
                    actualVals.add(gridSurf.getAveWidth());
                    names.add("dip");
                    arbVals.add(arbSurf.getAveDip());
                    actualVals.add(gridSurf.getAveDip());
                    System.out.println("==== RESULTS ====");
                    for (int i = 0; i < names.size(); ++i) {
                        System.out.println("Quantity: " + (String)names.get(i));
                        System.out.println("\tArb: " + ((Double)arbVals.get(i)).floatValue());
                        System.out.println("\tAct: " + ((Double)actualVals.get(i)).floatValue());
                        System.out.println("\tDiff: " + (float)Math.abs((Double)arbVals.get(i) - (Double)actualVals.get(i)));
                        System.out.println("\t% Diff: " + (float)DataUtils.getPercentDiff((Double)arbVals.get(i), (Double)actualVals.get(i)) + " %");
                    }
                    System.out.println("=================");
                }
            }
        }
    }

    private class DistsRecord {
        private Location loc;
        private Distance nearest3D;
        private Distance nearestHoriz;
        private Distance farthest3D;
        private Distance farthestHoriz;
        private List<Distance> distances;
        private double horzVertPenalizedDist = 0.0;
        private Distance farthestHorizVertPenalized;

        private DistsRecord(Location loc) {
            this.loc = loc;
            this.distances = new ArrayList<Distance>();
        }

        private void addDistance(Distance dist) {
            if (this.farthest3D == null || dist.dist3D > this.farthest3D.dist3D) {
                this.farthest3D = dist;
            }
            if (this.farthestHoriz == null || dist.horzDist > this.farthestHoriz.horzDist) {
                this.farthestHoriz = dist;
            }
            if (this.nearest3D == null || dist.dist3D < this.nearest3D.dist3D) {
                this.nearest3D = dist;
            }
            if (this.nearestHoriz == null || dist.horzDist < this.nearestHoriz.horzDist) {
                this.nearestHoriz = dist;
            }
            double myHorzVertPenalizedDist = dist.horzDist - dist.vertDist;
            if (this.farthestHorizVertPenalized == null) {
                this.farthestHorizVertPenalized = dist;
                this.horzVertPenalizedDist = myHorzVertPenalizedDist;
            } else if (myHorzVertPenalizedDist > this.horzVertPenalizedDist) {
                this.farthestHorizVertPenalized = dist;
                this.horzVertPenalizedDist = myHorzVertPenalizedDist;
            }
            this.distances.add(dist);
        }
    }

    private class Distance {
        private final Location loc1;
        private final Location loc2;
        private final double horzDist;
        private final double vertDist;
        private final double dist3D;

        public Distance(Location loc1, Location loc2) {
            this.loc1 = loc1;
            this.loc2 = loc2;
            this.horzDist = LocationUtils.horzDistanceFast(loc1, loc2);
            this.vertDist = Math.abs(LocationUtils.vertDistance(loc1, loc2));
            this.dist3D = Math.sqrt(this.horzDist * this.horzDist + this.vertDist * this.vertDist);
        }

        public String toString() {
            return "Distance: " + String.valueOf(this.loc1) + " => " + String.valueOf(this.loc2) + "\n\tHoriz: " + (float)this.horzDist + "\n\tVert: " + (float)this.vertDist + "\n\t3D: " + (float)this.dist3D;
        }
    }
}

