/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.association;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.LogPrintStream;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupOrigTimeComparator;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.parsers.UCERF3_CatalogParser;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.GriddedSurfaceImpl;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.association.ArbitrarilyDiscretizedSurface;
import scratch.UCERF3.erf.ETAS.association.FiniteFaultMapper;
import scratch.UCERF3.erf.ETAS.association.JeanneFileLoader;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class FiniteFaultMappingData
implements XMLSaveable {
    private List<ObsEqkRupture> rups = Lists.newArrayList();
    private List<Map<FaultModels, Integer>> mappedRupIndexes = Lists.newArrayList();
    private List<RuptureSurface> mappedSurfaces = Lists.newArrayList();
    private Map<ObsEqkRupture, Integer> rupIndexMap = Maps.newHashMap();
    static final DateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");

    private FiniteFaultMappingData() {
    }

    private void addMapping(ObsEqkRupture rup, Map<FaultModels, Integer> mappings, RuptureSurface surface) {
        Preconditions.checkNotNull((Object)rup);
        Preconditions.checkNotNull((Object)rup.getEventId());
        Preconditions.checkState((rup.getEventId().length() > 0 ? 1 : 0) != 0);
        Preconditions.checkState((mappings != null || surface != null ? 1 : 0) != 0);
        Preconditions.checkState((mappings == null || surface == null ? 1 : 0) != 0);
        this.rupIndexMap.put(rup, this.rups.size());
        this.rups.add(rup);
        this.mappedRupIndexes.add(mappings);
        this.mappedSurfaces.add(surface);
    }

    private RuptureSurface getSurface(ObsEqkRupture rup, FaultModels fm, FaultSystemRupSet rupSet) {
        int index = this.rupIndexMap.get(rup);
        Map<FaultModels, Integer> mappings = this.mappedRupIndexes.get(index);
        if (mappings != null) {
            Integer rupIndex = mappings.get(fm);
            Preconditions.checkNotNull((Object)rupIndex, (Object)("No mapping exists for " + fm.name()));
            return rupSet.getSurfaceForRupture(rupIndex, 1.0);
        }
        RuptureSurface external = this.mappedSurfaces.get(index);
        Preconditions.checkNotNull((Object)external);
        return external;
    }

    private boolean hasMapping(ObsEqkRupture rupture) {
        return this.rupIndexMap.containsKey(rupture);
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement("FiniteFaultMappingData");
        for (int i = 0; i < this.rups.size(); ++i) {
            ObsEqkRupture rup = this.rups.get(i);
            Element rupEl = el.addElement("HistoricalRupture");
            rupEl.addAttribute("id", rup.getEventId());
            rupEl.addAttribute("date", df.format(rup.getOriginTimeCal().getTime()));
            rupEl.addAttribute("mag", "" + rup.getMag());
            Map<FaultModels, Integer> mappedIndexes = this.mappedRupIndexes.get(i);
            if (mappedIndexes != null) {
                Element mapEl = rupEl.addElement("RupSetMappings");
                Preconditions.checkState((!mappedIndexes.isEmpty() ? 1 : 0) != 0);
                for (FaultModels fm : mappedIndexes.keySet()) {
                    Element fmEl = mapEl.addElement(fm.name());
                    fmEl.addAttribute("rupIndex", String.valueOf(mappedIndexes.get(fm)));
                }
                continue;
            }
            RuptureSurface surf = this.mappedSurfaces.get(i);
            Preconditions.checkNotNull((Object)surf);
            Preconditions.checkState((boolean)(surf instanceof XMLSaveable));
            ((XMLSaveable)((Object)surf)).toXMLMetadata(rupEl);
        }
        return root;
    }

    public static void loadRuptureSurfaces(File xmlFile, ObsEqkRupList ruptures, FaultModels fm, FaultSystemRupSet rupSet) throws MalformedURLException, DocumentException {
        FiniteFaultMappingData.loadRuptureSurfaces(XMLUtils.loadDocument(xmlFile), ruptures, fm, rupSet);
    }

    public static void loadRuptureSurfaces(InputStream is, ObsEqkRupList ruptures, FaultModels fm, FaultSystemRupSet rupSet) throws DocumentException {
        FiniteFaultMappingData.loadRuptureSurfaces(XMLUtils.loadDocument(is), ruptures, fm, rupSet);
    }

    public static void loadRuptureSurfaces(Document doc, ObsEqkRupList ruptures, FaultModels fm, FaultSystemRupSet rupSet) {
        FiniteFaultMappingData data = FiniteFaultMappingData.load(doc, (List<? extends ObsEqkRupture>)ruptures);
        int count = 0;
        int numMapped = 0;
        for (int i = 0; i < ruptures.size(); ++i) {
            ObsEqkRupture rup = (ObsEqkRupture)ruptures.get(i);
            if (!data.hasMapping(rup)) continue;
            ++count;
            RuptureSurface surf = data.getSurface(rup, fm, rupSet);
            rup.setRuptureSurface(surf);
            if (!(surf instanceof CompoundSurface)) continue;
            int obsRupIndex = data.rupIndexMap.get(rup);
            int rupIndex = data.mappedRupIndexes.get(obsRupIndex).get(fm);
            ETAS_EqkRupture etasRup = new ETAS_EqkRupture(rup);
            etasRup.setFSSIndex(rupIndex);
            ruptures.set(i, etasRup);
            ++numMapped;
        }
        System.out.println("Loaded finite fault surfaces for " + count + " ruptures (" + numMapped + " are FaultSystemRupSet ruptures)");
    }

    static FiniteFaultMappingData load(File xmlFile, List<? extends ObsEqkRupture> ruptures) throws MalformedURLException, DocumentException {
        return FiniteFaultMappingData.load(XMLUtils.loadDocument(xmlFile), ruptures);
    }

    static FiniteFaultMappingData load(Document doc, List<? extends ObsEqkRupture> ruptures) {
        Element root = doc.getRootElement();
        Element el = root.element("FiniteFaultMappingData");
        FiniteFaultMappingData data = new FiniteFaultMappingData();
        for (Element rupEl : XMLUtils.getSubElementsList(el, "HistoricalRupture")) {
            Date date;
            try {
                date = df.parse(rupEl.attributeValue("date"));
            }
            catch (ParseException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            String id = rupEl.attributeValue("id");
            double mag = Double.parseDouble(rupEl.attributeValue("mag"));
            ObsEqkRupture match = FiniteFaultMappingData.findMatch(ruptures, id, date, mag);
            Element mappedIndexesEl = rupEl.element("RupSetMappings");
            Element griddedSurfEl = rupEl.element("GriddedSurfaceImpl");
            Element arbDiscSurfEl = rupEl.element("ArbitrarilyDiscretizedSurface");
            HashMap mappedIndexes = null;
            CacheEnabledSurface externalSurface = null;
            if (mappedIndexesEl != null) {
                mappedIndexes = Maps.newHashMap();
                for (Element subEl : XMLUtils.getSubElementsList(mappedIndexesEl)) {
                    FaultModels fm = FaultModels.valueOf(subEl.getName());
                    int index = Integer.parseInt(subEl.attributeValue("rupIndex"));
                    mappedIndexes.put(fm, index);
                }
            } else if (griddedSurfEl != null) {
                externalSurface = GriddedSurfaceImpl.fromXMLMetadata(rupEl.element(GriddedSurfaceImpl.XML_METADATA_NAME));
            } else {
                Preconditions.checkNotNull((Object)arbDiscSurfEl);
                externalSurface = ArbitrarilyDiscretizedSurface.fromXMLMetadata(rupEl.element(ArbitrarilyDiscretizedSurface.XML_METADATA_NAME));
            }
            data.addMapping(match, mappedIndexes, externalSurface);
        }
        return data;
    }

    private static ObsEqkRupture findMatch(List<? extends ObsEqkRupture> ruptures, String id, Date date, double mag) {
        for (ObsEqkRupture obsEqkRupture : ruptures) {
            if (!obsEqkRupture.getEventId().equals(id) || (float)mag != (float)obsEqkRupture.getMag()) continue;
            String matchDateStr = df.format(obsEqkRupture.getOriginTimeCal().getTime());
            if (!df.format(date).equals(matchDateStr)) continue;
            return obsEqkRupture;
        }
        throw new IllegalStateException("Rupture not found: id=" + id + ", mag=" + mag + ", date=" + df.format(date));
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File outputDir = new File("/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/EarthquakeCatalog");
        File logFile = new File(outputDir, "finite_fault_mappings_log.txt");
        FileWriter log_fw = new FileWriter(logFile);
        System.setOut(new LogPrintStream((OutputStream)System.out, log_fw));
        System.setErr(new LogPrintStream((OutputStream)System.err, log_fw));
        File finiteFile = new File("/home/kevin/OpenSHA/UCERF3/historical_finite_fault_mapping/UCERF3_finite.dat");
        ObsEqkRupList inputRups = UCERF3_CatalogParser.loadCatalog(new File("/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/EarthquakeCatalog/ofr2013-1165_EarthquakeCat.txt"));
        File outputFile = new File(outputDir, "finite_fault_mappings.xml");
        U3FaultSystemRupSet rupSet31 = U3FaultSystemIO.loadRupSet(new File("/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip"));
        U3FaultSystemRupSet rupSet32 = U3FaultSystemIO.loadRupSet(new File("/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_2_MEAN_BRANCH_AVG_SOL.zip"));
        for (ObsEqkRupture rup : inputRups) {
            if (!(rup.getHypocenterLocation().getDepth() > 24.0) || !(rup.getMag() >= 4.0)) continue;
            System.out.println(String.valueOf(rup.getHypocenterLocation()) + ", mag=" + rup.getMag());
        }
        List<ObsEqkRupture> finiteRups = JeanneFileLoader.loadFiniteRups(finiteFile, inputRups);
        Collections.sort(finiteRups, new ObsEqkRupOrigTimeComparator());
        System.out.println("Loaded " + finiteRups.size() + " finite rups");
        HashMap mappers = Maps.newHashMap();
        mappers.put(FaultModels.FM3_1, new FiniteFaultMapper(rupSet31, true, true));
        mappers.put(FaultModels.FM3_2, new FiniteFaultMapper(rupSet32, true, true));
        FiniteFaultMappingData data = new FiniteFaultMappingData();
        for (ObsEqkRupture rup : finiteRups) {
            HashMap matches = null;
            RuptureSurface externalSurf = null;
            for (FaultModels fm : mappers.keySet()) {
                FiniteFaultMapper mapper = (FiniteFaultMapper)mappers.get(fm);
                int rupIndex = mapper.getMappedRup(rup);
                if (rupIndex < 0) {
                    Preconditions.checkState((matches == null ? 1 : 0) != 0, (Object)("No match for " + fm.name() + " but had one in another FM"));
                    externalSurf = rup.getRuptureSurface();
                    Preconditions.checkNotNull((Object)externalSurf);
                    continue;
                }
                Preconditions.checkState((externalSurf == null ? 1 : 0) != 0, (Object)("Match for " + fm.name() + " but no match in another FM"));
                if (matches == null) {
                    matches = Maps.newHashMap();
                }
                matches.put(fm, rupIndex);
            }
            data.addMapping(rup, matches, externalSurf);
        }
        Document doc = XMLUtils.createDocumentWithRoot();
        data.toXMLMetadata(doc.getRootElement());
        XMLUtils.writeDocumentToFile(outputFile, doc);
        log_fw.close();
    }
}

