/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.ExceptionUtils;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_SimulationMetadata;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_CatalogIteration;

class ETAS_BinaryWriter
implements Closeable {
    private List<InProgressWriter> writers;

    public ETAS_BinaryWriter(File outputDir, ETAS_Config config) throws IOException {
        int numCatalogs = config.getNumSimulations();
        this.writers = new ArrayList<InProgressWriter>();
        for (ETAS_Config.BinaryFilteredOutputConfig binaryConfig : config.getBinaryOutputFilters()) {
            this.writers.add(new InProgressWriter(outputDir, numCatalogs, config, binaryConfig));
        }
    }

    public HashSet<Integer> getDoneIndexes() {
        HashSet<Integer> doneSet = null;
        for (InProgressWriter writer : this.writers) {
            if (doneSet == null) {
                doneSet = writer.doneSet;
                continue;
            }
            doneSet.retainAll(writer.doneSet);
        }
        return doneSet;
    }

    public static File locateCatalogFile(File catalogDir) {
        File asciiFile = new File(catalogDir, "simulatedEvents.txt");
        File binaryFile = new File(catalogDir, "simulatedEvents.bin");
        File binaryGZipFile = new File(catalogDir, "simulatedEvents.bin.gz");
        if (asciiFile.exists()) {
            return asciiFile;
        }
        if (binaryFile.exists()) {
            return binaryFile;
        }
        if (binaryGZipFile.exists()) {
            return binaryGZipFile;
        }
        throw new IllegalStateException("No ETAS catalogs found in " + catalogDir.getAbsolutePath());
    }

    public void processCatalog(int index, File catalogDir) throws IOException {
        ETAS_CatalogIO.ETAS_Catalog catalog;
        boolean preStaged = true;
        for (InProgressWriter writer : this.writers) {
            File stagedFile = writer.binaryConf.getPreStagedCatalogFile(catalogDir);
            if (stagedFile.exists()) continue;
            preStaged = false;
            break;
        }
        if (preStaged) {
            for (InProgressWriter writer : this.writers) {
                writer.processPreStaged(index, catalogDir);
            }
            return;
        }
        File catalogFile = ETAS_BinaryWriter.locateCatalogFile(catalogDir);
        try {
            catalog = ETAS_CatalogIO.loadCatalog(catalogFile);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Exception processing catalog " + catalogFile.getAbsolutePath());
        }
        ETAS_SimulationMetadata meta = catalog.getSimulationMetadata();
        if (meta != null && meta.catalogIndex < 0) {
            catalog.setSimulationMetadata(meta.getModCatalogIndex(index));
        }
        this.processCatalog(catalog);
    }

    public void processCatalog(ETAS_CatalogIO.ETAS_Catalog catalog) throws IOException {
        for (InProgressWriter writer : this.writers) {
            writer.processCatalog(catalog);
        }
    }

    public void flushWriters() throws IOException {
        for (InProgressWriter writer : this.writers) {
            if (writer.dOut == null) continue;
            writer.dOut.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (InProgressWriter writer : this.writers) {
            writer.close();
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1 || args.length > 2) {
            System.err.println("USAGE: " + ClassUtils.getClassNameWithoutPackage(ETAS_BinaryWriter.class) + " <etas-config.json> [<results-dir/catalogs.bin>]");
            System.exit(2);
        }
        File confFile = new File(args[0]);
        ETAS_Config config = ETAS_Config.readJSON(confFile);
        File outputDir = config.getOutputDir();
        Preconditions.checkState((boolean)outputDir.exists(), (Object)("ETAS output dir doesn't exist: " + outputDir.getAbsolutePath()));
        File resultsDir = args.length == 2 ? new File(args[1]) : ETAS_Launcher.getResultsDir(outputDir);
        Preconditions.checkState((boolean)resultsDir.exists(), (Object)("ETAS results dir doesn't exist: " + resultsDir.getAbsolutePath()));
        final ETAS_BinaryWriter writer = new ETAS_BinaryWriter(config.getOutputDir(), config);
        int numProcessed = ETAS_CatalogIteration.processCatalogs(resultsDir, new ETAS_CatalogIteration.Callback(){

            @Override
            public void processCatalog(ETAS_CatalogIO.ETAS_Catalog catalog, int index) {
                try {
                    writer.processCatalog(catalog);
                }
                catch (IOException e) {
                    ExceptionUtils.throwAsRuntimeException(e);
                }
            }
        });
        writer.close();
        System.out.println("Finished binary consolidation of " + numProcessed + " catalogs");
    }

    private class InProgressWriter
    implements Closeable {
        private File inProgressFile;
        private File destFile;
        private DataOutputStream dOut;
        private int numCatalogs;
        private ETAS_Config.BinaryFilteredOutputConfig binaryConf;
        private ETAS_Config config;
        private HashSet<Integer> doneSet;
        private boolean warnedNoMeta = false;

        public InProgressWriter(File outputDir, int numCatalogs, ETAS_Config config, ETAS_Config.BinaryFilteredOutputConfig binaryConf) throws IOException {
            this.numCatalogs = numCatalogs;
            this.binaryConf = binaryConf;
            this.config = config;
            this.doneSet = new HashSet();
            if (outputDir != null) {
                String prefix = binaryConf.getPrefix();
                this.inProgressFile = new File(outputDir, prefix + "_partial.bin");
                if (this.inProgressFile.exists() && this.inProgressFile.length() > 100L && !config.isForceRecalc()) {
                    System.out.println("Attempting to retstart, reading old " + this.inProgressFile.getName());
                    ETAS_CatalogIO.BinarayCatalogsMetadataIterator metadataIt = ETAS_CatalogIO.getBinaryCatalogsMetadataIterator(this.inProgressFile);
                    long writePos = -1L;
                    while (metadataIt.hasNext() && metadataIt.isNextFullyWritten()) {
                        long endIndex = metadataIt.getNextEndPos();
                        ETAS_SimulationMetadata meta = metadataIt.next();
                        if (meta != null && meta.catalogIndex >= 0) {
                            Preconditions.checkState((!this.doneSet.contains(meta.catalogIndex) ? 1 : 0) != 0, (String)"Duplicate catalog index encountered: %s", (int)meta.catalogIndex);
                            this.doneSet.add(meta.catalogIndex);
                            writePos = endIndex;
                            continue;
                        }
                        System.out.println("Old catalog format encountered without metadata, can't restart this (or subsequent) catalogs");
                        break;
                    }
                    metadataIt.close();
                    if (writePos > 0L) {
                        System.out.println("Will resume " + this.inProgressFile.getName() + " after " + this.doneSet.size() + " catalogs (at pos=" + writePos + ")");
                        RandomAccessFile raFile = new RandomAccessFile(this.inProgressFile, "rw");
                        long len = raFile.length();
                        Preconditions.checkState((writePos <= len ? 1 : 0) != 0, (String)"bad writePos=%s with len=%s", (long)writePos, (long)len);
                        if (writePos < len) {
                            long overwrite = len - writePos;
                            System.out.println("Write position is before end, will overwrite " + overwrite + " bytes (current lengh=" + len + ")");
                        }
                        raFile.seek(writePos);
                        FileOutputStream fout = new FileOutputStream(raFile.getFD());
                        this.dOut = new DataOutputStream(new BufferedOutputStream(fout, 0x640000));
                    }
                }
                this.destFile = new File(outputDir, prefix + ".bin");
            }
        }

        public synchronized void processCatalog(ETAS_CatalogIO.ETAS_Catalog catalog) throws IOException {
            ETAS_SimulationMetadata meta;
            if (this.dOut == null) {
                this.dOut = ETAS_CatalogIO.initCatalogsBinary(this.inProgressFile, this.numCatalogs);
            }
            if ((meta = catalog.getSimulationMetadata()) == null) {
                if (!this.warnedNoMeta) {
                    System.err.println("WARNING: catalog doesn't have metadata attached, old file version? future warnings supressed");
                    this.warnedNoMeta = true;
                }
            } else {
                Preconditions.checkState((meta.catalogIndex >= 0 ? 1 : 0) != 0, (String)"Bad catalog index: %s", (int)meta.catalogIndex);
                if (this.doneSet.contains(meta.catalogIndex)) {
                    System.err.println("WARNING: already processed index " + meta.catalogIndex + ", skipping");
                    return;
                }
            }
            catalog = this.binaryConf.filter(this.config, catalog);
            ETAS_CatalogIO.writeCatalogBinary(this.dOut, (List<ETAS_EqkRupture>)catalog);
            if (meta != null) {
                this.doneSet.add(meta.catalogIndex);
            }
        }

        public synchronized void processPreStaged(int index, File catalogDir) throws IOException {
            if (this.dOut == null) {
                this.dOut = ETAS_CatalogIO.initCatalogsBinary(this.inProgressFile, this.numCatalogs);
            }
            File stagedFile = this.binaryConf.getPreStagedCatalogFile(catalogDir);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(stagedFile));
            ByteStreams.copy((InputStream)in, (OutputStream)this.dOut);
            in.close();
            this.doneSet.add(index);
        }

        @Override
        public void close() throws IOException {
            this.dOut.close();
            Files.move((File)this.inProgressFile, (File)this.destFile);
        }
    }
}

