/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher;

import com.google.common.base.Preconditions;
import edu.usc.kmilner.mpj.taskDispatch.AsyncPostBatchHook;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.ExceptionUtils;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_BinaryWriter;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;

public class MPJ_ETAS_Launcher
extends MPJTaskCalculator {
    private ETAS_Config config;
    private ETAS_Launcher launcher;
    private ETAS_BinaryWriter binaryWriter;
    private boolean autoClean;

    public MPJ_ETAS_Launcher(CommandLine cmd, ETAS_Config config) throws IOException {
        super(cmd);
        this.config = config;
        this.shuffle = false;
        this.debug("building launcher");
        Long randSeed = config.getRandomSeed();
        if (randSeed == null) {
            randSeed = System.nanoTime() + (long)(this.rank * new Random().nextInt());
        }
        boolean scratchLink = cmd.hasOption("scratch-dir") && config.hasBinaryOutputFilters();
        this.launcher = new ETAS_LauncherPrintWrapper(config, this.rank == 0 && !scratchLink, randSeed);
        if (this.rank == 0) {
            this.launcher.setDebugLevel(ETAS_Launcher.DebugLevel.FINE);
        } else {
            this.launcher.setDebugLevel(ETAS_Launcher.DebugLevel.INFO);
        }
        if (this.rank == 0 && config.hasBinaryOutputFilters()) {
            this.binaryWriter = new ETAS_BinaryWriter(config.getOutputDir(), config);
            this.autoClean = cmd.hasOption("clean");
            this.postBatchHook = new BinaryConsolidateHook();
        }
        if (scratchLink) {
            File outputDir = config.getOutputDir();
            if (this.rank == 0) {
                ETAS_Launcher.waitOnDirCreation(outputDir, 10, 2000L);
            }
            File scratchDir = new File(cmd.getOptionValue("scratch-dir"));
            if (this.rank == 0) {
                ETAS_Launcher.waitOnDirCreation(scratchDir, 10, 2000L);
            }
            File scratchSubDir = new File(scratchDir, outputDir.getName());
            if (this.rank == 0) {
                ETAS_Launcher.waitOnDirCreation(scratchSubDir, 10, 2000L);
            }
            File resultsDir = ETAS_Launcher.getResultsDir(outputDir);
            File scratchResultsDir = new File(scratchSubDir, "results");
            if (this.rank == 0) {
                ETAS_Launcher.waitOnDirCreation(scratchResultsDir, 10, 2000L);
                if (!resultsDir.exists()) {
                    this.debug("Creating link to scratch results dir: " + scratchResultsDir.getAbsolutePath());
                    Files.createSymbolicLink(resultsDir.toPath(), scratchResultsDir.toPath(), new FileAttribute[0]);
                }
            }
        }
        if (cmd.hasOption("temp-dir")) {
            File tempDir = new File(cmd.getOptionValue("temp-dir"));
            ETAS_Launcher.waitOnDirCreation(tempDir, 10, 2000L);
            File tempSubDir = new File(tempDir, config.getOutputDir().getName());
            ETAS_Launcher.waitOnDirCreation(tempSubDir, 10, 2000L);
            this.launcher.setTempDir(tempSubDir);
        }
    }

    protected Collection<Integer> getDoneIndexes() {
        if (this.binaryWriter != null) {
            return this.binaryWriter.getDoneIndexes();
        }
        return null;
    }

    protected int getNumTasks() {
        return this.config.getNumSimulations();
    }

    protected void calculateBatch(int[] batch) throws Exception {
        this.launcher.calculate(this.getNumThreads(), batch, null, this.config.hasBinaryOutputFilters());
    }

    protected void doFinalAssembly() throws Exception {
        this.launcher.shutdownExecutor();
        if (this.binaryWriter != null) {
            ((BinaryConsolidateHook)this.postBatchHook).shutdown();
            this.binaryWriter.close();
        }
    }

    protected static Options createOptions() {
        Options ops = MPJTaskCalculator.createOptions();
        Option scratchDirOption = new Option("scratch", "scratch-dir", true, "Scratch directory. If supplied and binary output filters are enabled, the results directory will be written here and symbolically linked back to the output directory.");
        scratchDirOption.setRequired(false);
        ops.addOption(scratchDirOption);
        Option tempDirOption = new Option("temp", "temp-dir", true, "Temp directory. If supplied, all in-progress simulations will be written here (can be node-local) and copied to the output directory upon completion");
        tempDirOption.setRequired(false);
        ops.addOption(tempDirOption);
        Option cleanOption = new Option("cl", "clean", false, "Flag to automatically clean out finished directories after the results are consolidated into a binary output file");
        cleanOption.setRequired(false);
        ops.addOption(cleanOption);
        return ops;
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        try {
            args = MPJTaskCalculator.initMPJ((String[])args);
            Options options = MPJ_ETAS_Launcher.createOptions();
            CommandLine cmd = MPJ_ETAS_Launcher.parse((Options)options, (String[])args, MPJ_ETAS_Launcher.class);
            args = cmd.getArgs();
            if (args.length < 1) {
                System.err.println("USAGE: " + ClassUtils.getClassNameWithoutPackage(MPJ_ETAS_Launcher.class) + " [options] <conf-file.json> [...<config-file-N.json>]");
                MPJ_ETAS_Launcher.abortAndExit((int)2);
            }
            for (String arg : args) {
                File confFile = new File(arg);
                System.out.println("Processing configuration: " + arg);
                Preconditions.checkArgument((boolean)confFile.exists(), (Object)("configuration file doesn't exist: " + confFile.getAbsolutePath()));
                ETAS_Config config = ETAS_Config.readJSON(confFile);
                File outputDir = config.getOutputDir();
                List<ETAS_Config.BinaryFilteredOutputConfig> outputFilters = config.getBinaryOutputFilters();
                if (outputFilters != null && !outputFilters.isEmpty() && !config.isForceRecalc()) {
                    boolean allDone = true;
                    for (ETAS_Config.BinaryFilteredOutputConfig filter : outputFilters) {
                        File binFile = new File(outputDir, filter.getPrefix() + ".bin");
                        if (allDone = allDone && binFile.exists() && binFile.length() > 0L) continue;
                        break;
                    }
                    if (allDone) {
                        System.out.println("Already done, will skip " + arg);
                        continue;
                    }
                }
                System.gc();
                MPJ_ETAS_Launcher driver = new MPJ_ETAS_Launcher(cmd, config);
                driver.run();
            }
            MPJ_ETAS_Launcher.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJ_ETAS_Launcher.abortAndExit((Throwable)t);
        }
    }

    private class ETAS_LauncherPrintWrapper
    extends ETAS_Launcher {
        public ETAS_LauncherPrintWrapper(ETAS_Config config, boolean mkdirs, Long randSeed) throws IOException {
            super(config, mkdirs, randSeed);
        }

        @Override
        public void debug(ETAS_Launcher.DebugLevel level, String message) {
            if (this.debugLevel.shouldPrint(level)) {
                MPJ_ETAS_Launcher.this.debug(message);
            }
        }
    }

    private class BinaryConsolidateHook
    extends AsyncPostBatchHook {
        private BinaryCleanHook cleanHook;

        public BinaryConsolidateHook() {
            super(1);
            if (MPJ_ETAS_Launcher.this.autoClean) {
                this.cleanHook = new BinaryCleanHook();
            }
        }

        protected void batchProcessedAsync(int[] batch, int processIndex) {
            MPJ_ETAS_Launcher.this.debug("running async post-batch hook for process " + processIndex + ". " + this.getCountsString());
            MPJ_ETAS_Launcher.this.debug("async post-batch estimates: " + this.getRatesString());
            try {
                for (int index : batch) {
                    File catalogDir = MPJ_ETAS_Launcher.this.launcher.getResultsDir(index);
                    MPJ_ETAS_Launcher.this.binaryWriter.processCatalog(index, catalogDir);
                }
                MPJ_ETAS_Launcher.this.binaryWriter.flushWriters();
            }
            catch (IOException e) {
                System.err.println("Exception processing async!");
                e.printStackTrace();
                throw ExceptionUtils.asRuntimeException(e);
            }
            MPJ_ETAS_Launcher.this.debug("done running async post-batch hook for process " + processIndex + ". " + this.getCountsString());
            if (this.cleanHook != null) {
                this.cleanHook.batchProcessed(batch, processIndex);
            }
        }

        public void shutdown() {
            List awaiting;
            super.shutdown();
            if (this.cleanHook != null && (awaiting = this.cleanHook.shutdownNow()) != null) {
                MPJ_ETAS_Launcher.this.debug("Aborting cleanup before it's done. Batches: " + awaiting.size() + ". Estimates if allowed to continue: " + this.cleanHook.getCountsString());
            }
        }
    }

    private class BinaryCleanHook
    extends AsyncPostBatchHook {
        private SimpleFileVisitor<Path> deleteVisitor;

        public BinaryCleanHook() {
            super(1);
            this.deleteVisitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            };
            Preconditions.checkState((boolean)MPJ_ETAS_Launcher.this.autoClean);
        }

        protected void batchProcessedAsync(int[] batch, int processIndex) {
            MPJ_ETAS_Launcher.this.debug("running async cleanup hook for process " + processIndex + ". " + this.getCountsString());
            MPJ_ETAS_Launcher.this.debug("cleanup async post-batch estimates: " + this.getRatesString());
            for (int index : batch) {
                File catalogDir = MPJ_ETAS_Launcher.this.launcher.getResultsDir(index);
                MPJ_ETAS_Launcher.this.debug("removing completed directory: " + catalogDir.getAbsolutePath());
                try {
                    Path directory = catalogDir.toPath();
                    Files.walkFileTree(directory, this.deleteVisitor);
                }
                catch (Exception e) {
                    MPJ_ETAS_Launcher.this.debug("exception removing completed directory, skipping: " + catalogDir.getAbsolutePath());
                    e.printStackTrace();
                }
            }
            MPJ_ETAS_Launcher.this.debug("done running async cleanup post-batch hook for process " + processIndex + ". " + this.getCountsString());
        }
    }
}

