/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RupInRegionCache;
import org.opensha.sha.faultSurface.RuptureSurface;
import scratch.UCERF3.erf.FaultSystemSolutionERF;

public class FSSRupsInRegionCache
implements RupInRegionCache {
    private ConcurrentMap<Region, boolean[]> sectsInRegions = Maps.newConcurrentMap();
    private int numRups = -1;
    private ConcurrentMap<Region, ConcurrentMap<Integer, Boolean>> rupMap = Maps.newConcurrentMap();
    private ConcurrentMap<Region, ConcurrentMap<Integer, Boolean>> sectMap = Maps.newConcurrentMap();

    @Override
    public boolean isRupInRegion(ERF erf, ProbEqkSource source, EqkRupture rup, int srcIndex, int rupIndex, Region region) {
        Preconditions.checkArgument((boolean)(erf instanceof FaultSystemSolutionERF), (Object)"ERF must be a FaultSystemSolutionERF");
        FaultSystemSolutionERF fssERF = (FaultSystemSolutionERF)erf;
        FaultSystemSolution sol = fssERF.getSolution();
        Preconditions.checkNotNull((Object)sol, (Object)"FSS ERF has null solution");
        double erfGridSpacing = (Double)fssERF.getParameter("Fault Grid Spacing").getValue();
        RuptureSurface surf = rup.getRuptureSurface();
        int invIndex = srcIndex >= fssERF.getNumFaultSystemSources() ? -1 : fssERF.getFltSysRupIndexForSource(srcIndex);
        if (invIndex >= 0 && source instanceof FaultRuptureSource) {
            Preconditions.checkState((boolean)source.getName().contains("" + invIndex), (Object)("Bad mapping of inv index " + invIndex + " for source name: " + source.getName()));
            return this.isRupInRegion(sol, invIndex, region, erfGridSpacing);
        }
        for (Location loc : surf.getEvenlyDiscritizedListOfLocsOnSurface()) {
            if (!region.contains(loc)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRupInRegion(FaultSystemSolution sol, int fssIndex, Region region, double surfGridSpacing) {
        Boolean inside;
        Preconditions.checkArgument((fssIndex >= 0 && fssIndex < sol.getRupSet().getNumRuptures() ? 1 : 0) != 0);
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.numRups != sol.getRupSet().getNumRuptures()) {
                this.rupMap.clear();
                this.sectMap.clear();
                this.numRups = sol.getRupSet().getNumRuptures();
            }
        }
        serializable = region;
        synchronized (serializable) {
            if (!this.sectsInRegions.containsKey(region)) {
                FaultSystemRupSet rupSet = sol.getRupSet();
                boolean[] sects = new boolean[rupSet.getNumSections()];
                for (int i = 0; i < sects.length; ++i) {
                    FaultSection sect = rupSet.getFaultSectionData(i);
                    RuptureSurface surf = sect.getFaultSurface(surfGridSpacing, false, true);
                    boolean inside2 = false;
                    for (Location loc : surf.getEvenlyDiscritizedListOfLocsOnSurface()) {
                        if (!region.contains(loc)) continue;
                        inside2 = true;
                        break;
                    }
                    sects[i] = inside2;
                }
                this.sectsInRegions.put(region, sects);
            }
        }
        boolean[] sects = (boolean[])this.sectsInRegions.get(region);
        ConcurrentMap regRupMap = (ConcurrentMap)this.rupMap.get(region);
        ConcurrentMap regSectMap = (ConcurrentMap)this.sectMap.get(region);
        if (regRupMap == null) {
            regRupMap = Maps.newConcurrentMap();
            this.rupMap.putIfAbsent(region, regRupMap);
            regRupMap = (ConcurrentMap)this.rupMap.get(region);
        }
        if (regSectMap == null) {
            regSectMap = Maps.newConcurrentMap();
            this.sectMap.putIfAbsent(region, regSectMap);
            regSectMap = (ConcurrentMap)this.sectMap.get(region);
        }
        if ((inside = (Boolean)regRupMap.get(fssIndex)) == null) {
            inside = false;
            for (int index : sol.getRupSet().getSectionsIndicesForRup(fssIndex)) {
                if (!sects[index]) continue;
                inside = true;
                break;
            }
            regRupMap.putIfAbsent(fssIndex, inside);
        }
        return inside;
    }
}

