/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.griddedSeismicity;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.griddedSeismicity.SmallMagScaling;
import scratch.UCERF3.griddedSeismicity.UCERF3_GridSourceGenerator;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class GridSrcMFDPlotter {
    private static InversionFaultSystemSolution fss;
    private static ArrayList<PlotCurveCharacterstics> plotChars;
    private static SmallMagScaling magScaling;
    private static boolean incremental;
    private static String fName;

    GridSrcMFDPlotter() {
        if (fName.contains("_ch_") || fName.contains("_Char_")) {
            this.plotChar();
        }
        if (fName.contains("_gr_")) {
            this.plotGR();
        }
    }

    void plotFault(int idx) {
        UCERF3_GridSourceGenerator gridGen = new UCERF3_GridSourceGenerator(fss);
        System.out.println("init done");
        ArrayList funcs = Lists.newArrayList();
        String name = fss.getRupSet().getFaultSectionData(idx).getName();
        IncrementalMagFreqDist fSubSeisIncr = gridGen.getSectSubSeisMFD(idx);
        fSubSeisIncr.setName(name + " SubSeis MFD");
        EvenlyDiscretizedFunc fSubSeisCum = fSubSeisIncr.getCumRateDist();
        IncrementalMagFreqDist fSupSeisIncr = fss.calcNucleationMFD_forSect(idx, fSubSeisIncr.getMinX(), fSubSeisIncr.getMaxX(), fSubSeisIncr.size());
        fSupSeisIncr.setName(name + " SupraSeis MFD");
        EvenlyDiscretizedFunc fSupSeisCum = fSupSeisIncr.getCumRateDist();
        IncrementalMagFreqDist fTotalIncr = fSubSeisIncr.deepClone();
        fTotalIncr.setName(name + "Total MFD");
        GridSrcMFDPlotter.addDistro(fTotalIncr, fSupSeisIncr);
        EvenlyDiscretizedFunc fTotalCum = fTotalIncr.getCumRateDist();
        funcs.add(incremental ? fSupSeisIncr : fSupSeisCum);
        funcs.add(incremental ? fSubSeisIncr : fSubSeisCum);
        funcs.add(incremental ? fTotalIncr : fTotalCum);
        GraphWindow plotter = new GraphWindow(funcs, (fName.contains("_gr_") ? "GR" : "CH") + " : " + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, magScaling.toString()) + " : " + (incremental ? "Incr" : "Cum") + " : " + name, plotChars);
        plotter.setX_AxisRange(fTotalIncr.getMinX(), fTotalIncr.getMaxX());
        plotter.setY_AxisRange(1.0E-10, 1.0E-4);
        plotter.setYLog(true);
    }

    void plotChar() {
        UCERF3_GridSourceGenerator gridGen = new UCERF3_GridSourceGenerator(fss);
        System.out.println("init done");
        ArrayList funcs = Lists.newArrayList();
        IncrementalMagFreqDist tOnIncr = fss.calcNucleationMFD_forRegion((Region)new CaliforniaRegions.RELM_TESTING(), 5.05, 8.45, 0.1, true);
        tOnIncr.setName("Total on-fault MFD from inversion");
        EvenlyDiscretizedFunc tOnCum = tOnIncr.getCumRateDist();
        funcs.add(incremental ? tOnIncr : tOnCum);
        IncrementalMagFreqDist tOffIncr = fss.getFinalTotalGriddedSeisMFD();
        EvenlyDiscretizedFunc tOffCum = tOffIncr.getCumRateDist();
        funcs.add(incremental ? tOffIncr : tOffCum);
        IncrementalMagFreqDist tOnOffIncr = tOnIncr.deepClone();
        GridSrcMFDPlotter.addDistro(tOnOffIncr, tOffIncr);
        tOnOffIncr.setName("Total on + off");
        EvenlyDiscretizedFunc tOnOffCum = tOnOffIncr.getCumRateDist();
        funcs.add(incremental ? tOnOffIncr : tOnOffCum);
        IncrementalMagFreqDist tssSectIncr = gridGen.getSectSubSeisMFD();
        EvenlyDiscretizedFunc tssSectCum = tssSectIncr.getCumRateDist();
        funcs.add(incremental ? tssSectIncr : tssSectCum);
        IncrementalMagFreqDist trueOffIncr = gridGen.getNodeUnassociatedMFD();
        EvenlyDiscretizedFunc trueOffCum = trueOffIncr.getCumRateDist();
        funcs.add(incremental ? trueOffIncr : trueOffCum);
        IncrementalMagFreqDist tssIncr = tssSectIncr.deepClone();
        GridSrcMFDPlotter.addDistro(tssIncr, trueOffIncr);
        tssIncr.setName("Summed sub-seismogenic MFDs (sect + unnassociated)");
        EvenlyDiscretizedFunc tssCum = tssIncr.getCumRateDist();
        funcs.add(incremental ? tssIncr : tssCum);
        GraphWindow plotter = new GraphWindow(funcs, "UCERF2wt1000 : " + (fName.contains("_gr_") ? "GR" : "CH") + " : " + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, magScaling.toString()) + " : " + (incremental ? "Incr" : "Cum"), plotChars);
        plotter.setX_AxisRange(tssSectIncr.getMinX(), tssSectIncr.getMaxX());
        plotter.setY_AxisRange(1.0E-6, 10.0);
        plotter.setYLog(true);
    }

    private static void addDistro(EvenlyDiscretizedFunc f1, EvenlyDiscretizedFunc f2) {
        for (int i = 0; i < f1.size(); ++i) {
            f1.set(i, f1.getY(i) + f2.getY(i));
        }
    }

    void plotGR() {
        UCERF3_GridSourceGenerator gridGen = new UCERF3_GridSourceGenerator(fss);
        System.out.println("init done");
        ArrayList funcs = Lists.newArrayList();
        IncrementalMagFreqDist tOnIncr = fss.calcTotalNucleationMFD(5.05, 8.45, 0.1);
        tOnIncr.setName("Total on-fault MFD from inversion");
        EvenlyDiscretizedFunc tOnCum = tOnIncr.getCumRateDist();
        funcs.add(incremental ? tOnIncr : tOnCum);
        IncrementalMagFreqDist tOffIncr = fss.getFinalTotalGriddedSeisMFD();
        EvenlyDiscretizedFunc tOffCum = tOffIncr.getCumRateDist();
        funcs.add(incremental ? tOffIncr : tOffCum);
        IncrementalMagFreqDist tssSectIncr = gridGen.getSectSubSeisMFD();
        EvenlyDiscretizedFunc tssSectCum = tssSectIncr.getCumRateDist();
        funcs.add(incremental ? tssSectIncr : tssSectCum);
        IncrementalMagFreqDist trueOffIncr = gridGen.getNodeUnassociatedMFD();
        EvenlyDiscretizedFunc trueOffCum = trueOffIncr.getCumRateDist();
        funcs.add(incremental ? trueOffIncr : trueOffCum);
        IncrementalMagFreqDist tssRegionIncr = tssSectIncr.deepClone();
        GridSrcMFDPlotter.addDistro(tssRegionIncr, tOnIncr);
        GridSrcMFDPlotter.addDistro(tssRegionIncr, trueOffIncr);
        tssRegionIncr.setName("Total on-fault + subSeis + unassociated");
        EvenlyDiscretizedFunc tssRegionCum = tssRegionIncr.getCumRateDist();
        funcs.add(incremental ? tssRegionIncr : tssRegionCum);
        GraphWindow plotter = new GraphWindow(funcs, (fName.contains("_gr_") ? "GR" : "CH") + " : " + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, magScaling.toString()) + " : " + (incremental ? "Incr" : "Cum"), plotChars);
        plotter.setX_AxisRange(tssSectIncr.getMinX(), tssSectIncr.getMaxX());
        plotter.setY_AxisRange(1.0E-6, 30.0);
        plotter.setYLog(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GridSrcMFDPlotter();
            }
        });
    }

    static {
        magScaling = SmallMagScaling.SPATIAL;
        incremental = false;
        fName = "tmp/invSols/ucerf2/FM2_1_UC2ALL_MaAvU2_DsrTap_DrAveU2_Char_VarAPrioriZero_VarAPrioriWt1000_mean_sol.zip";
        try {
            File f = new File(fName);
            fss = U3FaultSystemIO.loadInvSol(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        plotChars = Lists.newArrayList((Object[])new PlotCurveCharacterstics[]{new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK), new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.MAGENTA.darker()), new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE.darker()), new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.ORANGE.darker()), new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED.brighter()), new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN.darker()), new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.CYAN.darker()), new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.YELLOW.darker())});
    }
}

