/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.griddedSeismicity;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import scratch.UCERF3.enumTreeBranches.FaultModels;

class SectionPolygons {
    private static boolean log = false;
    private static final double MAX_BUF_DIP = 50.0;
    private Map<Integer, Area> polyMap;
    private Map<Integer, String> parentNameMap;
    private Map<Integer, Area> parentAreaMap;
    private Map<Integer, List<FaultSection>> parentSubSectionMap;
    private static final double BUF = 100.0;
    private static final double TOL = 1.0E-9;

    private SectionPolygons() {
    }

    static SectionPolygons create(List<? extends FaultSection> srcList, Double buf, Double len) {
        SectionPolygons fp = new SectionPolygons();
        fp.parentAreaMap = Maps.newHashMap();
        fp.parentSubSectionMap = Maps.newHashMap();
        fp.parentNameMap = Maps.newHashMap();
        if (len == null) {
            SectionPolygons.initFSRS(fp, srcList);
        } else {
            SectionPolygons.initFM(fp, srcList, len);
        }
        if (buf != null && buf != 0.0) {
            Preconditions.checkArgument((buf > 0.0 && buf <= 20.0 ? 1 : 0) != 0);
            fp.applyBuffer(buf);
        }
        fp.build();
        return fp;
    }

    private static void initFSRS(SectionPolygons fp, List<? extends FaultSection> sects) {
        for (FaultSection faultSection : sects) {
            ArrayList fSects;
            int pID = faultSection.getParentSectionId();
            if (!fp.parentAreaMap.containsKey(pID)) {
                Region r = faultSection.getZonePolygon();
                Area a = r != null ? r.getShape() : null;
                fp.parentAreaMap.put(pID, a);
            }
            if ((fSects = fp.parentSubSectionMap.get(pID)) == null) {
                fSects = Lists.newArrayList();
                fp.parentSubSectionMap.put(pID, fSects);
            }
            fSects.add(faultSection);
            if (fp.parentNameMap.containsKey(pID)) continue;
            fp.parentNameMap.put(pID, faultSection.getParentSectionName());
        }
    }

    private static void initFM(SectionPolygons fp, List<? extends FaultSection> faults, double len) {
        for (FaultSection faultSection : faults) {
            int id = faultSection.getSectionId();
            Region r = faultSection.getZonePolygon();
            Area a = r != null ? r.getShape() : null;
            fp.parentAreaMap.put(id, a);
            fp.parentSubSectionMap.put(id, new ArrayList<FaultSection>(faultSection.getSubSectionsList(len)));
            fp.parentNameMap.put(id, faultSection.getName());
        }
    }

    Area get(int id) {
        return this.polyMap.get(id);
    }

    Iterable<Area> polys() {
        return this.polyMap.values();
    }

    Set<Integer> indices() {
        return this.polyMap.keySet();
    }

    private void applyBuffer(double buf) {
        for (Integer pID : this.parentSubSectionMap.keySet()) {
            List<FaultSection> sects = this.parentSubSectionMap.get(pID);
            LocationList trace = new LocationList();
            for (FaultSection sect : sects) {
                trace.addAll(sect.getFaultTrace());
            }
            trace = SectionPolygons.removeDupes(trace);
            double dip = sects.get(0).getAveDip();
            double dipDir = sects.get(0).getDipDirection();
            double scale = (dip - 50.0) / 40.0;
            if (scale <= 0.0) continue;
            double scaledBuf = scale * buf;
            Area buffArea = SectionPolygons.buildBufferPoly(trace, dipDir, scaledBuf);
            Area pArea = this.parentAreaMap.get(pID);
            pArea = SectionPolygons.merge(pArea, buffArea);
            if (!(pArea = SectionPolygons.cleanBorder(pArea)).isSingular()) {
                pArea = SectionPolygons.removeNests(pArea);
            }
            this.parentAreaMap.put(pID, pArea);
            if (pArea.isSingular()) continue;
            System.out.println("    non-singular " + pID + " " + this.parentNameMap.get(pID));
        }
    }

    public static Area buildBufferPoly(LocationList trace, double dipDir, double buf) {
        Preconditions.checkArgument((trace.size() > 1 ? 1 : 0) != 0);
        Area buffer = null;
        for (int i = 1; i < trace.size(); ++i) {
            Location a = (Location)trace.get(i - 1);
            Location b = (Location)trace.get(i);
            LocationList points = new LocationList();
            LocationVector v = new LocationVector(dipDir, buf, 0.0);
            points.add(a);
            points.add(LocationUtils.location(a, v));
            points.add(LocationUtils.location(b, v));
            points.add(b);
            v.reverse();
            points.add(LocationUtils.location(b, v));
            points.add(LocationUtils.location(a, v));
            buffer = SectionPolygons.merge(buffer, new Area(points.toPath()));
        }
        return buffer;
    }

    private void build() {
        this.polyMap = Maps.newTreeMap();
        int idx = -1;
        for (Integer pID : this.parentAreaMap.keySet()) {
            ++idx;
            StringBuilder sb = null;
            if (log) {
                sb = new StringBuilder();
                sb.append(Strings.padEnd((String)Integer.toString(idx), (int)5, (char)' '));
                sb.append(Strings.padEnd((String)Integer.toString(pID), (int)5, (char)' '));
                sb.append(Strings.padEnd((String)this.parentNameMap.get(pID), (int)48, (char)' '));
            }
            if (this.parentAreaMap.get(pID) == null) {
                if (log) {
                    System.out.println(sb.append("null-poly"));
                }
                this.initNullPolys(pID);
                continue;
            }
            if (log) {
                System.out.println(sb);
            }
            this.initPolys(pID);
        }
        this.cleanPolys();
        this.mergeDownDip();
        for (Integer id : this.polyMap.keySet()) {
            String mssg;
            Area poly = this.polyMap.get(id);
            String string = poly == null ? "null" : (mssg = !poly.isSingular() ? "non-singular" : "ok");
            if (poly == null || poly.isSingular()) continue;
            System.out.println(Strings.padEnd((String)id.toString(), (int)10, (char)' ') + mssg);
            List<LocationList> locLists = SectionPolygons.areaToLocLists(poly);
            for (LocationList locs : locLists) {
                System.out.println(locs);
            }
        }
    }

    private void initNullPolys(int pID) {
        List<FaultSection> subSecs = this.parentSubSectionMap.get(pID);
        for (FaultSection sec : subSecs) {
            int id = sec.getSectionId();
            this.polyMap.put(id, null);
        }
    }

    private void initPolys(int pID) {
        Area fPoly = this.parentAreaMap.get(pID);
        List<FaultSection> subSecs = this.parentSubSectionMap.get(pID);
        for (int i = 0; i < subSecs.size(); ++i) {
            Area prev;
            FaultSection ss1 = subSecs.get(i);
            int id = ss1.getSectionId();
            if (subSecs.size() == 1) {
                this.polyMap.put(id, fPoly);
                break;
            }
            if (i == subSecs.size() - 1) {
                if (fPoly.isSingular()) {
                    this.polyMap.put(id, fPoly);
                    break;
                }
                List<LocationList> locLists = SectionPolygons.areaToLocLists(fPoly);
                for (LocationList locs : locLists) {
                    Area polyPart = new Area(locs.toPath());
                    FaultTrace trace = ss1.getFaultTrace();
                    if (SectionPolygons.intersects(trace, polyPart)) {
                        this.polyMap.put(id, polyPart);
                        continue;
                    }
                    Area leftover = polyPart;
                    int sectionID = subSecs.get(i - 1).getSectionId();
                    prev = this.polyMap.get(sectionID);
                    prev.add(leftover);
                    prev = SectionPolygons.cleanBorder(prev);
                    if (!prev.isSingular()) {
                        prev = SectionPolygons.hardMerge(prev);
                    }
                    if (prev == null) {
                        System.out.println("merge problem last segment");
                    }
                    this.polyMap.put(sectionID, prev);
                }
                break;
            }
            FaultSection ss2 = subSecs.get(i + 1);
            LocationList envelope = SectionPolygons.createSubSecEnvelope(ss1, ss2);
            Area envPoly = new Area(envelope.toPath());
            Area subPoly = (Area)fPoly.clone();
            subPoly.intersect(envPoly);
            if (subPoly.isEmpty()) {
                this.polyMap.put(id, null);
                continue;
            }
            subPoly = SectionPolygons.cleanBorder(subPoly);
            Area leftover = null;
            if (subPoly.isSingular()) {
                this.polyMap.put(id, subPoly);
            } else {
                List<LocationList> locLists = SectionPolygons.areaToLocLists(subPoly);
                for (LocationList locs : locLists) {
                    Area polyPart = new Area(locs.toPath());
                    FaultTrace trace = ss1.getFaultTrace();
                    if (SectionPolygons.intersects(trace, polyPart)) {
                        this.polyMap.put(id, polyPart);
                        continue;
                    }
                    leftover = polyPart;
                }
            }
            fPoly.subtract(envPoly);
            fPoly = SectionPolygons.cleanBorder(fPoly);
            if (leftover == null) continue;
            Area fCopy = (Area)fPoly.clone();
            fCopy.add(leftover);
            fCopy = SectionPolygons.cleanBorder(fCopy);
            if (!fCopy.isSingular()) {
                if ((fCopy = SectionPolygons.hardMerge(fCopy)) == null) {
                    int sectionID = subSecs.get(i - 1).getSectionId();
                    prev = this.polyMap.get(sectionID);
                    prev.add(leftover);
                    prev = SectionPolygons.cleanBorder(prev);
                    if (!prev.isSingular()) {
                        prev = SectionPolygons.hardMerge(prev);
                    }
                    if (prev == null) {
                        System.out.println("merge problem");
                    }
                    this.polyMap.put(sectionID, prev);
                    continue;
                }
                fPoly = fCopy;
                continue;
            }
            fPoly = fCopy;
        }
    }

    private static LocationList createSubSecEnvelope(FaultSection sec1, FaultSection sec2) {
        FaultTrace t1 = sec1.getFaultTrace();
        FaultTrace t2 = sec2.getFaultTrace();
        Location p1 = (Location)t1.get(t1.size() - 2);
        Location p2 = (Location)t1.get(t1.size() - 1);
        Preconditions.checkState((boolean)p2.equals(t2.get(0)));
        LocationVector vBackAz = LocationUtils.vector(p2, p1);
        vBackAz.setHorzDistance(100.0);
        LocationVector vBisect = new LocationVector();
        vBisect.setAzimuth(sec1.getDipDirection());
        vBisect.setHorzDistance(100.0);
        LocationList locs = new LocationList();
        Location util = LocationUtils.location(p2, vBisect);
        locs.add(util);
        locs.add(0, LocationUtils.location(util, vBackAz));
        locs.add(p2);
        vBisect.reverse();
        util = LocationUtils.location(p2, vBisect);
        locs.add(util);
        locs.add(LocationUtils.location(util, vBackAz));
        return locs;
    }

    private void cleanPolys() {
        for (Integer id : this.polyMap.keySet()) {
            Area poly = this.polyMap.get(id);
            if (poly == null) continue;
            if (poly.isEmpty()) {
                this.polyMap.put(id, null);
                continue;
            }
            this.polyMap.put(id, SectionPolygons.cleanBorder(poly));
        }
    }

    static Area cleanBorder(Area area) {
        List<LocationList> locLists = SectionPolygons.areaToLocLists(area);
        locLists = SectionPolygons.pruneEmpties(locLists);
        locLists = SectionPolygons.removeDupes(locLists);
        Area areaOut = new Area();
        for (LocationList areaLocs : locLists) {
            areaOut.add(new Area(areaLocs.toPath()));
        }
        return areaOut;
    }

    private static List<LocationList> pruneEmpties(List<LocationList> locLists) {
        ArrayList newLocLists = Lists.newArrayList();
        for (LocationList locs : locLists) {
            if (SectionPolygons.isEmptyPoly(locs)) continue;
            newLocLists.add(locs);
        }
        return newLocLists;
    }

    private static List<LocationList> removeDupes(List<LocationList> locLists) {
        ArrayList newLocLists = Lists.newArrayList();
        for (LocationList locs : locLists) {
            newLocLists.add(SectionPolygons.removeDupes(locs));
        }
        return newLocLists;
    }

    private static LocationList removeDupes(LocationList locs) {
        LocationList newLocs = new LocationList();
        for (Location loc : locs) {
            SectionPolygons.validateLoc(newLocs, loc);
        }
        return newLocs;
    }

    private static boolean isEmptyPoly(LocationList locs) {
        Location start = (Location)locs.get(0);
        for (Location loc : locs) {
            if (SectionPolygons.areSimilar(start, loc)) continue;
            return false;
        }
        return true;
    }

    private static void validateLoc(LocationList locs, Location loc) {
        for (Location p : locs) {
            if (!SectionPolygons.areSimilar(p, loc)) continue;
            return;
        }
        locs.add(loc);
    }

    private static boolean areSimilar(Location p1, Location p2) {
        if (!Precision.equals((double)p1.getLatitude(), (double)p2.getLatitude(), (double)1.0E-9)) {
            return false;
        }
        if (!Precision.equals((double)p1.getLongitude(), (double)p2.getLongitude(), (double)1.0E-9)) {
            return false;
        }
        return Precision.equals((double)p1.getDepth(), (double)p2.getDepth(), (double)1.0E-9);
    }

    private static Area hardMerge(Area area) {
        List<LocationList> locLists = SectionPolygons.areaToLocLists(area);
        Preconditions.checkArgument((locLists.size() == 2 ? 1 : 0) != 0);
        Area a1 = new Area(locLists.get(0).toPath());
        Area a2 = new Area(locLists.get(1).toPath());
        return SectionPolygons.shiftMerge(a1, a2);
    }

    private static Area shiftMerge(Area a1, Area a2) {
        Preconditions.checkArgument((boolean)a1.isSingular());
        Preconditions.checkArgument((!a1.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)a2.isSingular());
        Preconditions.checkArgument((!a2.isEmpty() ? 1 : 0) != 0);
        LocationList locsToShift = SectionPolygons.areaToLocLists(a2).get(0);
        LocationList shiftedLocs = null;
        Area merged = (Area)a1.clone();
        shiftedLocs = SectionPolygons.shiftEW(locsToShift, 1.0E-9);
        merged.add(new Area(shiftedLocs.toPath()));
        if (merged.isSingular()) {
            return merged;
        }
        shiftedLocs = SectionPolygons.shiftNS(locsToShift, -1.0E-9);
        merged.add(new Area(shiftedLocs.toPath()));
        if (merged.isSingular()) {
            return merged;
        }
        shiftedLocs = SectionPolygons.shiftEW(locsToShift, -1.0E-9);
        merged.add(new Area(shiftedLocs.toPath()));
        if (merged.isSingular()) {
            return merged;
        }
        shiftedLocs = SectionPolygons.shiftNS(locsToShift, 1.0E-9);
        merged.add(new Area(shiftedLocs.toPath()));
        if (merged.isSingular()) {
            return merged;
        }
        return null;
    }

    private static LocationList shiftEW(LocationList locs, double shift) {
        LocationList locsOut = new LocationList();
        for (Location loc : locs) {
            Location shiftedLoc = new Location(loc.getLatitude(), loc.getLongitude() + shift);
            locsOut.add(shiftedLoc);
        }
        return locsOut;
    }

    private static LocationList shiftNS(LocationList locs, double shift) {
        LocationList locsOut = new LocationList();
        for (Location loc : locs) {
            Location shiftedLoc = new Location(loc.getLatitude() + shift, loc.getLongitude());
            locsOut.add(shiftedLoc);
        }
        return locsOut;
    }

    private static boolean intersects(FaultTrace trace, Area poly) {
        for (Location loc : trace) {
            if (!poly.contains(loc.getLongitude(), loc.getLatitude())) continue;
            return true;
        }
        return false;
    }

    private void mergeDownDip() {
        for (Integer pID : this.parentSubSectionMap.keySet()) {
            List<FaultSection> subSecs = this.parentSubSectionMap.get(pID);
            int numSubSecs = subSecs.size();
            for (int i = 0; i < numSubSecs; ++i) {
                FaultSection subSec = subSecs.get(i);
                int id = subSec.getSectionId();
                Area zone = this.polyMap.get(id);
                Area dd = SectionPolygons.createDownDipPoly(subSec);
                Area merged = SectionPolygons.merge(zone, dd);
                merged = SectionPolygons.removeNests(merged);
                this.polyMap.put(id, merged);
            }
        }
    }

    private static Area merge(Area zone, Area dd) {
        Area area = new Area();
        if (zone != null) {
            area.add(zone);
        }
        if (dd != null) {
            area.add(dd);
        }
        return area.isEmpty() ? null : area;
    }

    private static Area createDownDipPoly(FaultSection f) {
        RuptureSurface surf = f.getFaultSurface(1.0, false, false);
        LocationList perimeter = surf.getPerimeter();
        return new Area(perimeter.toPath());
    }

    private static Area removeNests(Area area) {
        if (area == null) {
            return null;
        }
        if (area.isSingular()) {
            return area;
        }
        List<LocationList> locLists = SectionPolygons.areaToLocLists(area);
        Preconditions.checkArgument((locLists.size() > 1 ? 1 : 0) != 0);
        Area a = new Area();
        for (LocationList locs : locLists) {
            Area toAdd = new Area(locs.toPath());
            a.add(toAdd);
        }
        a = SectionPolygons.cleanBorder(a);
        return a;
    }

    static List<LocationList> areaToLocLists(Area area) {
        ArrayList locLists = Lists.newArrayList();
        LocationList locs = null;
        double[] vertex = new double[6];
        PathIterator pi = area.getPathIterator(null);
        while (!pi.isDone()) {
            int type = pi.currentSegment(vertex);
            double lon = vertex[0];
            double lat = vertex[1];
            if (type == 0) {
                locs = new LocationList();
                locLists.add(locs);
                locs.add(new Location(lat, lon));
            } else if (type == 1) {
                locs.add(new Location(lat, lon));
            }
            pi.next();
        }
        return locLists;
    }

    static double getExtent(Area area) {
        List<LocationList> locLists = SectionPolygons.areaToLocLists(area);
        double total = 0.0;
        for (LocationList locs : locLists) {
            total += SectionPolygons.getExtent(locs);
        }
        return total;
    }

    private static double getExtent(LocationList locs) {
        Area area = new Area(locs.toPath());
        Rectangle2D rRect = area.getBounds2D();
        Location origin = new Location(rRect.getCenterY(), rRect.getCenterX());
        ArrayList xs = Lists.newArrayList();
        ArrayList ys = Lists.newArrayList();
        for (Location loc : locs) {
            LocationVector v = LocationUtils.vector(origin, loc);
            double az = v.getAzimuthRad();
            double d = v.getHorzDistance();
            xs.add(Math.sin(az) * d);
            ys.add(Math.cos(az) * d);
        }
        xs.add((Double)xs.get(0));
        ys.add((Double)ys.get(0));
        return SectionPolygons.computeArea(Doubles.toArray((Collection)xs), Doubles.toArray((Collection)ys));
    }

    private static double computeArea(double[] xs, double[] ys) {
        SectionPolygons.positivize(xs);
        SectionPolygons.positivize(ys);
        double area = 0.0;
        for (int i = 0; i < xs.length - 1; ++i) {
            area += xs[i] * ys[i + 1] - xs[i + 1] * ys[i];
        }
        return Math.abs(area) / 2.0;
    }

    private static void positivize(double[] v) {
        double min = Doubles.min((double[])v);
        if (min >= 0.0) {
            return;
        }
        DataUtils.add(Math.abs(min), v);
    }

    public static void main(String[] args) {
        SectionPolygons.create(FaultModels.FM3_1.getFaultSections(), 5.0, 7.0);
    }
}

