/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.griddedSeismicity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.griddedSeismicity.AbstractGridSourceProvider;
import scratch.UCERF3.griddedSeismicity.GridReader;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class UCERF3_GridSourceGenerator
extends AbstractGridSourceProvider {
    private final CaliforniaRegions.RELM_TESTING_GRIDDED region = RELM_RegionUtils.getGriddedRegionInstance();
    private static double[] fracStrikeSlip;
    private static double[] fracNormal;
    private static double[] fracReverse;
    private FaultGridAssociations polyMgr;
    private double[] srcSpatialPDF;
    private double[] revisedSpatialPDF;
    private IncrementalMagFreqDist realOffFaultMFD;
    private Map<Integer, SummedMagFreqDist> nodeSubSeisMFDs;
    private Map<Integer, IncrementalMagFreqDist> sectSubSeisMFDs;
    private double mfdMin = 5.05;
    private double mfdMax = 8.45;
    private int mfdNum = 35;

    public UCERF3_GridSourceGenerator(InversionFaultSystemSolution ifss) {
        this(ifss, ifss.getLogicTreeBranch().getValue(SpatialSeisPDF.class), ifss.getLogicTreeBranch().getValue(MomentRateFixes.class), ifss.getRupSet().getInversionTargetMFDs(), ifss.requireModule(SubSeismoOnFaultMFDs.class), ifss.getLogicTreeBranch().getValue(MaxMagOffFault.class).getMaxMagOffFault(), ifss.getRupSet().requireModule(FaultGridAssociations.class));
    }

    public UCERF3_GridSourceGenerator(FaultSystemSolution fss, SpatialSeisPDF srcSpatialPDF, MomentRateFixes rateFixes, InversionTargetMFDs targetMFDs, SubSeismoOnFaultMFDs subSeisMFDs, double mMaxOffFault, FaultGridAssociations polyMgr) {
        this.srcSpatialPDF = srcSpatialPDF.getPDF();
        IncrementalMagFreqDist totalNuclMFD = fss.calcNucleationMFD_forRegion((Region)RELM_RegionUtils.getGriddedRegionInstance(), 0.05, 8.95, 0.1, true);
        this.realOffFaultMFD = InversionFaultSystemSolution.getFinalTrulyOffFaultMFD(targetMFDs, rateFixes, mMaxOffFault, subSeisMFDs.getTotal(), totalNuclMFD);
        this.mfdMin = this.realOffFaultMFD.getMinX();
        this.mfdMax = this.realOffFaultMFD.getMaxX();
        this.mfdNum = this.realOffFaultMFD.size();
        this.polyMgr = polyMgr;
        System.out.println("   initSectionMFDs() ...");
        this.initSectionMFDs(fss, subSeisMFDs);
        System.out.println("   initNodeMFDs() ...");
        this.initNodeMFDs(fss);
        System.out.println("   updateSpatialPDF() ...");
        this.updateSpatialPDF();
    }

    private void initSectionMFDs(FaultSystemSolution fss, SubSeismoOnFaultMFDs subSeisMFDs) {
        ImmutableList<IncrementalMagFreqDist> subSeisMFD_list = subSeisMFDs.getAll();
        this.sectSubSeisMFDs = Maps.newHashMap();
        List<? extends FaultSection> faults = fss.getRupSet().getFaultSectionDataList();
        for (int i = 0; i < faults.size(); ++i) {
            this.sectSubSeisMFDs.put(faults.get(i).getSectionId(), (IncrementalMagFreqDist)subSeisMFD_list.get(i));
        }
    }

    private void initNodeMFDs(FaultSystemSolution fss) {
        this.nodeSubSeisMFDs = Maps.newHashMap();
        for (FaultSection faultSection : fss.getRupSet().getFaultSectionDataList()) {
            int id = faultSection.getSectionId();
            IncrementalMagFreqDist sectSubSeisMFD = this.sectSubSeisMFDs.get(id);
            Map<Integer, Double> nodeFractions = this.polyMgr.getNodeFractions(id);
            for (Integer nodeIdx : nodeFractions.keySet()) {
                SummedMagFreqDist nodeMFD = this.nodeSubSeisMFDs.get(nodeIdx);
                if (nodeMFD == null) {
                    nodeMFD = new SummedMagFreqDist(this.mfdMin, this.mfdMax, this.mfdNum);
                    this.nodeSubSeisMFDs.put(nodeIdx, nodeMFD);
                }
                double scale = nodeFractions.get(nodeIdx);
                IncrementalMagFreqDist scaledMFD = sectSubSeisMFD.deepClone();
                scaledMFD.scale(scale);
                nodeMFD.addIncrementalMagFreqDist(scaledMFD);
            }
        }
    }

    private void updateSpatialPDF() {
        this.revisedSpatialPDF = new double[this.srcSpatialPDF.length];
        for (int i = 0; i < this.region.getNodeCount(); ++i) {
            double fraction = 1.0 - this.polyMgr.getNodeFraction(i);
            this.revisedSpatialPDF[i] = this.srcSpatialPDF[i] * fraction;
        }
        DataUtils.asWeights(this.revisedSpatialPDF);
    }

    public IncrementalMagFreqDist getSectSubSeisMFD(int idx) {
        return this.sectSubSeisMFDs.get(idx);
    }

    public IncrementalMagFreqDist getSectSubSeisMFD() {
        SummedMagFreqDist sum = new SummedMagFreqDist(this.mfdMin, this.mfdMax, this.mfdNum);
        sum.setName("Sub-seismogenic MFD for all fault sections");
        for (IncrementalMagFreqDist mfd : this.sectSubSeisMFDs.values()) {
            sum.addIncrementalMagFreqDist(mfd);
        }
        return sum;
    }

    public IncrementalMagFreqDist getNodeUnassociatedMFD() {
        this.realOffFaultMFD.setInfo("Same as " + this.realOffFaultMFD.getName());
        this.realOffFaultMFD.setName("Unassociated MFD for all nodes");
        return this.realOffFaultMFD;
    }

    @Override
    public IncrementalMagFreqDist getMFD_SubSeisOnFault(int idx) {
        return this.nodeSubSeisMFDs.get(idx);
    }

    @Override
    public IncrementalMagFreqDist getMFD_Unassociated(int idx) {
        IncrementalMagFreqDist mfd = this.realOffFaultMFD.deepClone();
        mfd.scale(this.revisedSpatialPDF[idx]);
        return mfd;
    }

    @Override
    public GriddedRegion getGriddedRegion() {
        return this.region;
    }

    public IncrementalMagFreqDist getNodeSubSeisMFD() {
        SummedMagFreqDist sum = new SummedMagFreqDist(this.mfdMin, this.mfdMax, this.mfdNum);
        sum.setName("Sub-seismogenic MFD for all nodes");
        for (IncrementalMagFreqDist incrementalMagFreqDist : this.nodeSubSeisMFDs.values()) {
            sum.addIncrementalMagFreqDist(incrementalMagFreqDist);
        }
        return sum;
    }

    public static void main(String[] args) {
        InversionFaultSystemSolution invFss = null;
        try {
            File f = new File("/Users/pmpowers/projects/OpenSHA/tmp/invSols/refGR/FM3_1_NEOK_EllB_DsrUni_GRUnconst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_mean_sol.zip");
            System.out.println(f.exists());
            invFss = U3FaultSystemIO.loadInvSol(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UCERF3_GridSourceGenerator gridGen = new UCERF3_GridSourceGenerator(invFss);
        int numSrcs = gridGen.getNumLocations();
        int numRups = 0;
        System.out.println("numSrcs: " + numSrcs);
        for (int i = 0; i < numSrcs; ++i) {
            numRups += gridGen.getSource(i, 1.0, null, GriddedSeismicitySettings.DEFAULT).getNumRuptures();
        }
        System.out.println("numRups: " + numRups);
    }

    static void plot(ArrayList<IncrementalMagFreqDist> mfds) {
        GraphWindow graph = new GraphWindow(mfds, "GridSeis Test");
        graph.setX_AxisLabel("Magnitude");
        graph.setY_AxisLabel("Incremental Rate");
        graph.setYLog(true);
        graph.setY_AxisRange(1.0E-8, 100.0);
    }

    @Override
    public double getFracStrikeSlip(int idx) {
        UCERF3_GridSourceGenerator.checkInitFocalMechGrids();
        return fracStrikeSlip[idx];
    }

    @Override
    public double getFracReverse(int idx) {
        UCERF3_GridSourceGenerator.checkInitFocalMechGrids();
        return fracReverse[idx];
    }

    @Override
    public double getFracNormal(int idx) {
        UCERF3_GridSourceGenerator.checkInitFocalMechGrids();
        return fracNormal[idx];
    }

    private static synchronized void checkInitFocalMechGrids() {
        if (fracStrikeSlip == null) {
            fracStrikeSlip = new GridReader("StrikeSlipWts.txt").getValues();
        }
        if (fracReverse == null) {
            fracReverse = new GridReader("ReverseWts.txt").getValues();
        }
        if (fracNormal == null) {
            fracNormal = new GridReader("NormalWts.txt").getValues();
        }
    }

    @Override
    public MFDGridSourceProvider newInstance(Map<Integer, IncrementalMagFreqDist> nodeSubSeisMFDs, Map<Integer, IncrementalMagFreqDist> nodeUnassociatedMFDs, double[] fracStrikeSlip, double[] fracNormal, double[] fracReverse, TectonicRegionType[] trts) {
        return new AbstractGridSourceProvider.Precomputed(this.getGriddedRegion(), nodeSubSeisMFDs, nodeUnassociatedMFDs, fracStrikeSlip, fracNormal, fracReverse, trts);
    }
}

