/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.dom4j.DocumentException;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.SectionClusterList;
import scratch.UCERF3.inversion.UCERF3SectionConnectionStrategy;
import scratch.UCERF3.inversion.coulomb.CoulombRates;
import scratch.UCERF3.inversion.laughTest.UCERF3PlausibilityConfig;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF3_DataUtils;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoRateConstraintFetcher;

public class InversionFaultSystemRupSetFactory {
    public static final double DEFAULT_ASEIS_VALUE = 0.1;
    private static File rup_set_store_dir = new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "FaultSystemRupSets");

    public static InversionFaultSystemRupSet cachedForBranch(U3LogicTreeBranchNode<?> ... branchNodes) throws IOException {
        return InversionFaultSystemRupSetFactory.cachedForBranch(false, branchNodes);
    }

    public static InversionFaultSystemRupSet cachedForBranch(boolean forceRebuild, U3LogicTreeBranchNode<?> ... branchNodes) throws IOException {
        return InversionFaultSystemRupSetFactory.cachedForBranch(rup_set_store_dir, forceRebuild, branchNodes);
    }

    public static InversionFaultSystemRupSet cachedForBranch(File directory, boolean forceRebuild, U3LogicTreeBranchNode<?> ... branchNodes) throws IOException {
        U3LogicTreeBranch branch = U3LogicTreeBranch.fromValues(branchNodes);
        FaultModels faultModel = branch.getValue(FaultModels.class);
        DeformationModels deformationModel = branch.getValue(DeformationModels.class);
        InversionModels invModel = branch.getValue(InversionModels.class);
        String fileName = deformationModel.name() + "_" + faultModel.name() + ".zip";
        File file = new File(directory, fileName);
        if (!forceRebuild && file.exists()) {
            System.out.println("Loading cached rup set from file: " + file.getAbsolutePath());
            try {
                InversionFaultSystemRupSet rupSet = U3FaultSystemIO.loadInvRupSet(file);
                return rupSet;
            }
            catch (Exception e) {
                System.err.println("Error loading rupset from file: " + file.getAbsolutePath());
                e.printStackTrace();
            }
        }
        InversionFaultSystemRupSet rupSet = InversionFaultSystemRupSetFactory.forBranch(UCERF3PlausibilityConfig.getDefault(), 0.1, branch);
        System.out.println("Caching rup set to file: " + file.getAbsolutePath());
        if (!directory.exists()) {
            directory.mkdir();
        }
        U3FaultSystemIO.writeRupSet(rupSet, file);
        return rupSet;
    }

    public static InversionFaultSystemRupSet forBranch(U3LogicTreeBranchNode<?> ... branchesChoices) {
        return InversionFaultSystemRupSetFactory.forBranch(UCERF3PlausibilityConfig.getDefault(), 0.1, branchesChoices);
    }

    public static InversionFaultSystemRupSet forBranch(U3LogicTreeBranch branch) {
        return InversionFaultSystemRupSetFactory.forBranch(UCERF3PlausibilityConfig.getDefault(), 0.1, branch);
    }

    public static InversionFaultSystemRupSet forBranch(UCERF3PlausibilityConfig laughTest, double defaultAseismicityValue, U3LogicTreeBranchNode<?> ... branchesChoices) {
        U3LogicTreeBranch branch = U3LogicTreeBranch.fromValues(branchesChoices);
        return InversionFaultSystemRupSetFactory.forBranch(laughTest, defaultAseismicityValue, branch);
    }

    public static InversionFaultSystemRupSet forBranch(UCERF3PlausibilityConfig laughTest, double defaultAseismicityValue, U3LogicTreeBranch branch) {
        return InversionFaultSystemRupSetFactory.forBranch(laughTest, defaultAseismicityValue, branch, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR);
    }

    public static InversionFaultSystemRupSet forBranch(UCERF3PlausibilityConfig laughTest, double defaultAseismicityValue, U3LogicTreeBranch branch, File scratchDir) {
        DeformationModels filterBasis;
        Preconditions.checkArgument((boolean)branch.isFullySpecified(), (Object)"Logic tree must be fully specified (no null values) in order to create an InversionFaultSystemRupSet.");
        FaultModels faultModel = branch.getValue(FaultModels.class);
        DeformationModels deformationModel = branch.getValue(DeformationModels.class);
        System.out.println("Building a rupture set for: " + String.valueOf(deformationModel) + " (" + String.valueOf(faultModel) + ")");
        if (faultModel == FaultModels.FM2_1 && laughTest.getCoulombFilter() != null) {
            System.out.println("WARNING: removing coulomb filter since this is FM 2.1");
            laughTest.setCoulombFilter(null);
        }
        if ((filterBasis = faultModel.getFilterBasis()) == null) {
            filterBasis = deformationModel;
        }
        DeformationModelFetcher filterBasisFetcher = new DeformationModelFetcher(faultModel, filterBasis, scratchDir, defaultAseismicityValue);
        CoulombRates coulombRates = null;
        if (laughTest.getCoulombFilter() != null) {
            try {
                coulombRates = CoulombRates.loadUCERF3CoulombRates(faultModel);
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        }
        UCERF3SectionConnectionStrategy connectionStrategy = new UCERF3SectionConnectionStrategy(laughTest.getMaxAzimuthChange(), coulombRates);
        laughTest.setCoulombRates(coulombRates);
        SectionClusterList clusters = new SectionClusterList(filterBasisFetcher, connectionStrategy, laughTest);
        List<? extends FaultSection> faultSectionData = filterBasis == deformationModel ? clusters.getFaultSectionData() : new DeformationModelFetcher(faultModel, deformationModel, scratchDir, defaultAseismicityValue).getSubSectionList();
        InversionFaultSystemRupSet rupSet = new InversionFaultSystemRupSet(branch, clusters, faultSectionData);
        System.out.println("New rup set has " + rupSet.getNumRuptures() + " ruptures.");
        Object info = rupSet.getInfoString();
        info = info == null ? "" : (String)info + "\n\n";
        info = (String)info + "\n****** Logic Tree Branch ******";
        for (U3LogicTreeBranchNode node : branch) {
            info = (String)info + "\n" + ClassUtils.getClassNameWithoutPackage(U3LogicTreeBranch.getEnumEnclosingClass(node.getClass())) + ": " + node.name();
        }
        info = (String)info + "\n*******************************";
        rupSet.setInfoString((String)info);
        return rupSet;
    }

    public static void main(String[] args) throws IOException, DocumentException {
        try {
            InversionFaultSystemRupSetFactory.forBranch(FaultModels.FM3_1, DeformationModels.ABM, ScalingRelationships.ELLSWORTH_B, SlipAlongRuptureModels.TAPERED, InversionModels.GR_CONSTRAINED, TotalMag5Rate.RATE_9p6, MaxMagOffFault.MAG_7p3, MomentRateFixes.NONE, SpatialSeisPDF.UCERF2);
            UCERF3PlausibilityConfig filter = UCERF3PlausibilityConfig.getDefault();
            InversionFaultSystemRupSet rupSet = InversionFaultSystemRupSetFactory.forBranch(filter, 0.1, U3LogicTreeBranch.getMEAN_UCERF3(FaultModels.FM3_1));
            System.out.println("FM3.1: " + rupSet.getNumRuptures() + " rups, " + rupSet.getNumSections() + " sects");
            rupSet = InversionFaultSystemRupSetFactory.forBranch(filter, 0.1, U3LogicTreeBranch.getMEAN_UCERF3(FaultModels.FM3_2));
            System.out.println("FM3.2: " + rupSet.getNumRuptures() + " rups, " + rupSet.getNumSections() + " sects");
            U3FaultSystemIO.writeRupSet(rupSet, new File("/tmp/mean_rupSet.zip"));
            InversionFaultSystemRupSet invRupSet = U3FaultSystemIO.loadInvRupSet(new File("/tmp/mean_rupSet.zip"));
            System.out.println(invRupSet.getLogicTreeBranch());
            System.out.println(invRupSet.getOldPlausibilityConfiguration());
            System.exit(0);
            System.out.println("Num sub sects: " + rupSet.getFaultSectionDataList().size());
            UCERF3_PaleoRateConstraintFetcher.getConstraints(rupSet.getFaultSectionDataList());
            System.out.println("Total Orig Mo Rate (including creep reductions): " + rupSet.getTotalOrigMomentRate());
            System.out.println("Total Reduced Mo Rate (subseis and creep): " + rupSet.getTotalReducedMomentRate());
            System.out.println("Total Mo Rate Reduction (for subseis only): " + rupSet.getTotalMomentRateReduction());
            System.out.println("Total Mo Rate Reduction Fraction (for subseis, relative to creep reduced): " + rupSet.getTotalMomentRateReductionFraction());
            System.out.println("\n" + rupSet.getInfoString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

